/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.valueprovider.dynamic.workspace;

import com.sas.models.datasources.BaseDataSource;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.valueprovider.dynamic.BasePromptDynamicValueProvider;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.workspace.DataSourceColumnWithFormat;
import com.sas.prompts.valueprovider.dynamic.workspace.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.ColumnAttributes;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.simplesqlmodel.ColumnInfo;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueType;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import com.sas.util.ListFactory;
import com.sas.util.ValueItem;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.PersistHelper;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

public class ColumnNamesValueProvider
extends BasePromptDynamicValueProvider {
    private String tableName;
    private String sbipUrl;
    private List values;

    public ColumnNamesValueProvider() {
    }

    public ColumnNamesValueProvider(String sbipUrl) {
        this.setSbipUrl(sbipUrl);
    }

    public boolean isSearchable(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        return false;
    }

    @Override
    public Collection getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) {
        ArrayList dependentPrompts = new ArrayList();
        return dependentPrompts;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSbipUrl() {
        return this.sbipUrl;
    }

    public void setSbipUrl(String sbipUrl) {
        if (this.sbipUrl != (sbipUrl = PersistHelper.parseSBIPUrl((String)sbipUrl))) {
            this.sbipUrl = sbipUrl;
            this.values = null;
        }
    }

    @Override
    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, ValueType.LIST, null, 0, -1);
    }

    @Override
    public Object getValues(Locale locale, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, null, returnType, index, count);
    }

    @Override
    public Object getValues(Locale locale, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, null, searchCriteria, index, count);
    }

    @Override
    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, returnType, null, index, count);
    }

    @Override
    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, ValueType.LIST, searchCriteria, index, count);
    }

    private Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        Object returnObject = null;
        if (returnType == ValueType.LIST || returnType == ValueType.TREETHENLIST) {
            returnObject = this.getValuesAsList(locale, dynamicPromptValueContext, searchCriteria, index, count);
        } else if (returnType == ValueType.TREE) {
            returnObject = this.getValuesAsTree(locale, searchCriteria, index, count);
        }
        return returnObject;
    }

    private List getValuesAsList(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        int size;
        List returnList = Collections.EMPTY_LIST;
        if (index < 0 || count == 0) {
            return returnList;
        }
        if (this.values == null && !ColumnNamesValueProvider.isEmpty(this.sbipUrl)) {
            if (dynamicPromptValueContext != null) {
                this.dataprovider = dynamicPromptValueContext.getDataProvider();
            }
            if (this.dataprovider == null) {
                throw new ValueProviderException(RB.getStringResource("ColumnNamesValueProvider.InvalidDataProvider.txt"));
            }
            this.getLogger2().debug("getValuesAsList for", this.sbipUrl);
            try {
                PhysicalTableInterface physicalTable = ((DataProvider)this.dataprovider).getPhysicalTable(this.sbipUrl);
                if (null == physicalTable) {
                    throw new ValueProviderException(Message.format((String)RB.getStringResource("ColumnNamesValueProvider.InvalidPath.fmt.txt"), (Object)this.sbipUrl));
                }
                BaseDataSource ds = new BaseDataSource(1L, this.sbipUrl);
                List cols = physicalTable.getColumns();
                int size2 = cols.size();
                if (this.getLogger2().isDebugEnabled()) {
                    this.getLogger2().debug("The table has this many columns:", Integer.toString(size2));
                }
                this.values = ListFactory.newList((int)size2);
                for (int i = 0; i < size2; ++i) {
                    ColumnInterface c = (ColumnInterface)cols.get(i);
                    long columnType = -1L;
                    String description = c.getDescription();
                    if (description == null || description.length() == 0) {
                        description = c.getName();
                    }
                    DataSourceColumnWithFormat dsColumn = new DataSourceColumnWithFormat((DataSourceInterface)ds, c.getName(), description, columnType);
                    ColumnAttributes ca = c.getColumnAttributes();
                    String ct = ca.getSasColumnType();
                    String format = ca.getSasFormat();
                    dsColumn.setFormat(ColumnInfo.DEFAULT_FORMAT + " " + format);
                    if (ct.equals("C")) {
                        columnType = 1L;
                    } else if (ct.equals("N")) {
                        SASFormat sasFormat = null;
                        if (format != null && format.length() > 0) {
                            sasFormat = SASFormat.getInstance((String)format, (Locale)locale);
                        }
                        columnType = sasFormat != null && sasFormat.isDateFormat() ? 4L : (sasFormat != null && sasFormat.isTimeFormat() ? 8L : (sasFormat != null && sasFormat.isDateTimeFormat() ? 16L : 2L));
                    }
                    dsColumn.setColumnType(columnType);
                    ValueItem valueItem = new ValueItem((Object)description, (Object)dsColumn);
                    valueItem.setAttribute(ValueItem.PARENT, (Object)physicalTable.getName());
                    this.values.add(valueItem);
                }
            }
            catch (ServerConnectionException e) {
                throw new ValueProviderException((Throwable)e, e.getMessage());
            }
            catch (RemoteException e) {
                throw new ValueProviderException((Throwable)e, e.getMessage());
            }
            catch (ServiceException e) {
                throw new ValueProviderException((Throwable)e, e.getMessage());
            }
        }
        if (this.values != null && index < (size = this.values.size())) {
            int maxValues = count;
            if (maxValues > size || maxValues < 0) {
                maxValues = size;
            }
            returnList = ListFactory.newList((int)maxValues);
            int i = index;
            for (int l = 0; l < maxValues; ++l) {
                returnList.add(l, this.values.get(i));
                ++i;
            }
        }
        return returnList;
    }

    private Object getValuesAsTree(Locale locale, SearchCriteria searchCriteria, int index, int count) {
        throw new UnsupportedOperationException(RB.getStringResource("RelationalDataItemValueProvider.UnsupportedMethodError.log"));
    }

    protected static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ColumnNamesValueProvider clone = (ColumnNamesValueProvider)((Object)super.clone());
        clone.sbipUrl = this.sbipUrl;
        return clone;
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setSbipUrl(provider.consumeAttr("sbipUrl"));
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setAttr((Element)element, (String)"sbipUrl", (String)this.getSbipUrl());
    }

    public String getDefinitionElementName() {
        return "ColumnNamesValueProvider";
    }
}

