/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.valueprovider.dynamic.olap;

import com.sas.iom.SASMDX.ISession;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.valueprovider.dynamic.BasePromptDynamicValueProvider;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.Metadata;
import com.sas.storage.olap.tree.MetadataEntityTreeNode;
import com.sas.storage.olap.tree.MetadataTreeModel;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueType;
import com.sas.util.ValidateArg;
import com.sas.util.ValueItem;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Vector;
import javax.swing.tree.TreeModel;

public class CubeItemsValueProvider
extends BasePromptDynamicValueProvider {
    protected transient String cubeName;
    public static final int HIERARCHIES = 0;
    public static final int DIMENSIONS = 1;
    public static final int LEVELS = 2;
    private int itemType = 0;
    private transient String hierarchyName;
    private transient String sbipUrl;

    public boolean isSearchable(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        return false;
    }

    public void setCubeName(String cubeName) {
        this.cubeName = cubeName;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public void setSbipUrl(String sbipUrl) {
        this.sbipUrl = sbipUrl;
    }

    public String getSbipUrl() {
        return this.sbipUrl;
    }

    public int getItemType() {
        return this.itemType;
    }

    public void setItemType(int itemType) {
        this.itemType = itemType;
    }

    @Override
    public Collection getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, ValueType.LIST, null, 0, -1);
    }

    @Override
    public Object getValues(Locale locale, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, null, returnType, index, count);
    }

    @Override
    public Object getValues(Locale locale, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, null, searchCriteria, index, count);
    }

    @Override
    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, returnType, null, index, count);
    }

    @Override
    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, ValueType.LIST, searchCriteria, index, count);
    }

    private Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        Object returnObject = null;
        if (returnType == ValueType.TREE || returnType == ValueType.TREETHENLIST) {
            return this.getTreeModel(dynamicPromptValueContext);
        }
        if (returnObject == null || returnType == ValueType.LIST) {
            return this.getValuesAndLabels(dynamicPromptValueContext);
        }
        return returnObject;
    }

    protected Collection getValuesAndLabels(DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        ValidateArg.notNull((Object)dynamicPromptValueContext, (String)"DynamicPromptValueContext");
        Vector<ValueItem> dynamicValues = new Vector<ValueItem>();
        try {
            int i;
            DimensionInterface[] me;
            DataProviderInterface dp = dynamicPromptValueContext.getDataProvider();
            if (dp == null) {
                return Collections.EMPTY_LIST;
            }
            ISession isession = null;
            if (this.sbipUrl != null) {
                MetadataInterface m = ((PromptDataProviderInterface)dp).getPhysicalCube(this.sbipUrl);
                if (m != null) {
                    this.cubeName = m.getName();
                    LogicalServerInterface logicalServer = ((DataProvider)dp).getOLAPServer(this.sbipUrl);
                    isession = (ISession)((DataProvider)dp).getConnection(logicalServer);
                }
            } else {
                isession = (ISession)((DataProvider)dp).getConnection(this.getLogicalServerName());
            }
            Metadata metadata = new Metadata(isession);
            Filter f = new Filter();
            f.setCubeName(this.cubeName);
            if (this.itemType == 1) {
                me = metadata.getDimensions(f);
                for (i = 0; me != null && i < me.length; ++i) {
                    if (me[i].getType() == 2) continue;
                    dynamicValues.add(new ValueItem((Object)me[i].getName(), (Object)me[i].getUniqueName()));
                }
            }
            if (this.itemType == 2) {
                me = metadata.getLevels(f);
                for (i = 0; me != null && i < me.length; ++i) {
                    if (me[i].getHierarchy().getDimension().getType() == 2) continue;
                    dynamicValues.add(new ValueItem((Object)me[i].getName(), (Object)me[i].getUniqueName()));
                }
            } else {
                me = metadata.getHierarchies(f);
                for (i = 0; me != null && i < me.length; ++i) {
                    if (me[i].getDimension().getType() == 2) continue;
                    String label = me[i].getName() + " [" + me[i].getDimension().getName() + "]";
                    dynamicValues.add(new ValueItem((Object)label, (Object)me[i].getUniqueName()));
                }
            }
        }
        catch (OLAPException oe) {
            throw new ValueProviderException((Throwable)oe, oe.getMessage());
        }
        catch (ServerConnectionException oe) {
            throw new ValueProviderException((Throwable)oe, oe.getMessage());
        }
        catch (RemoteException oe) {
            throw new ValueProviderException((Throwable)oe, oe.getMessage());
        }
        return dynamicValues;
    }

    protected TreeModel getTreeModel(DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        MetadataEntityTreeNode rootNode = new MetadataEntityTreeNode();
        MetadataTreeModel model = new MetadataTreeModel(rootNode);
        try {
            DimensionInterface[] me;
            DataProviderInterface dp = dynamicPromptValueContext.getDataProvider();
            if (dp == null) {
                return model;
            }
            ISession isession = null;
            if (this.sbipUrl != null) {
                MetadataInterface m = ((PromptDataProviderInterface)dp).getPhysicalCube(this.sbipUrl);
                if (m != null) {
                    this.cubeName = m.getName();
                    LogicalServerInterface logicalServer = ((DataProvider)dp).getOLAPServer(this.sbipUrl);
                    isession = (ISession)((DataProvider)dp).getConnection(logicalServer);
                }
            } else {
                isession = (ISession)((DataProvider)dp).getConnection(this.getLogicalServerName());
            }
            Metadata metadata = new Metadata(isession);
            Filter f = new Filter();
            f.setCubeName(this.cubeName);
            if (this.itemType == 1) {
                me = metadata.getDimensions(f);
                model.setDimensionNodes(Arrays.asList(me));
            }
            if (this.itemType == 2) {
                me = metadata.getLevels(f);
                model.setLevelNodes(Arrays.asList(me));
            } else {
                me = metadata.getHierarchies(f);
                model.setHierarchyNodes(Arrays.asList(me));
            }
        }
        catch (OLAPException oe) {
            throw new ValueProviderException((Throwable)oe, oe.getMessage());
        }
        catch (ServerConnectionException oe) {
            throw new ValueProviderException((Throwable)oe, oe.getMessage());
        }
        catch (RemoteException oe) {
            throw new ValueProviderException((Throwable)oe, oe.getMessage());
        }
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CubeItemsValueProvider clone = (CubeItemsValueProvider)((Object)super.clone());
        clone.cubeName = this.cubeName;
        clone.hierarchyName = this.hierarchyName;
        clone.itemType = this.itemType;
        return clone;
    }

    public String getDefinitionElementName() {
        return "CubeItemsValueProvider";
    }
}

