/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.valueprovider.dynamic.iq;

import com.sas.MissingValues;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DateType;
import com.sas.datatypes.StringType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.QueryConnector;
import com.sas.iquery.dataretrieval.QueryConnectorInterface;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.BusinessRule;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Governing;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.RootDataItem;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.models.CacheException;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.FindPromptValuesByPromptDefinitionIDVisitor;
import com.sas.prompts.IQBasedPromptViewInterface;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptValuesVisitorInterface;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.util.iquery.PromptIQueryUtil;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.DataProviderUtil;
import com.sas.prompts.valueprovider.dynamic.iq.BaseRelationalDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.RB;
import com.sas.prompts.valueprovider.dynamic.iq.WhereToFilterUtil;
import com.sas.services.information.ServerInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.simplesqlmodel.ColumnInfo;
import com.sas.storage.simplesqlmodel.Expression;
import com.sas.storage.simplesqlmodel.OperandInterface;
import com.sas.storage.simplesqlmodel.WhereClause;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueType;
import com.sas.util.ListFactory;
import com.sas.util.Util;
import com.sas.util.ValueItem;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.IntegratedWritingContext;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import java.beans.PropertyChangeSupport;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import javax.swing.tree.TreeModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RelationalDataItemValueProvider
extends BaseRelationalDataItemValueProvider {
    private static final long serialVersionUID = 8138022397671172447L;
    public static final String LABEL_VALUE = "Label_Value";
    public static final String VALUE_LABEL = "Value_Label";
    public static final String SORT_FIRST_NONE = "Sort_First_None";
    public static final String SORT_ASCENDING = "Ascending";
    public static final String SORT_DESCENDING = "Descending";
    public static final String SORT_NONE = "None";
    public static final String SORT_UNKNOWN = "UNKNOWN";
    protected String valueFormatString;
    private transient DataItem labelDataItem;
    protected String labelFormatString;
    protected boolean useValueAsLabel;
    protected boolean distinct;
    protected String sortFirst;
    protected String sortOrder;
    private BusinessModel businessModel;
    private WhereClause whereClause;
    String labelDataItemId;
    protected boolean formattedLabels;
    protected boolean removeMissingValues;

    public RelationalDataItemValueProvider() {
        this(null, false, null);
    }

    public RelationalDataItemValueProvider(DataItem dataItem) {
        this(dataItem, false, null);
    }

    public RelationalDataItemValueProvider(DataItem dataItem, boolean isFormatted, String formatString) {
        if (dataItem != null && dataItem.getStructure().isOLAP()) {
            throw new IllegalArgumentException(RB.getStringResource("RelationalDataItemValueProvider.RelationalDataItemError.txt"));
        }
        this.formattedLabels = false;
        this.setDataItem(dataItem);
        this.dataType = null;
        this.formattedValues = isFormatted;
        this.valueFormatString = formatString;
        this.setThreshold(DataProviderUtil.DEFAULT_RELATIONAL_THRESHOLD);
        this.distinct = true;
        this.sortFirst = SORT_FIRST_NONE;
        this.propertyChangeSupport = new PropertyChangeSupport((Object)this);
    }

    @Override
    public final void setDataItem(DataItem dataItem) {
        try {
            DataItem oldValue = this.getDataItemFromID();
            if (oldValue != dataItem) {
                super.setDataItem(dataItem);
                this.propertyChangeSupport.firePropertyChange("dataItem", oldValue, dataItem);
            }
        }
        catch (ValueProviderException valueProviderException) {
            // empty catch block
        }
    }

    public boolean isAllowUserValues() {
        return false;
    }

    public void setDataItemExpression(BusinessModel businessModel, ExpressionInterface expression) {
        this.valueItemExpression = expression;
        this.businessModel = businessModel;
        this.setDataItem(null);
    }

    public ExpressionInterface getDataItemExpression() {
        return this.valueItemExpression;
    }

    protected BusinessModel getBusinessModel() {
        return this.businessModel;
    }

    public void setDistinct(boolean isDistinct) {
        boolean oldValue = this.distinct;
        if (Util.unequal((Object)oldValue, (Object)isDistinct)) {
            this.distinct = isDistinct;
            this.propertyChangeSupport.firePropertyChange("isDistinct", oldValue, isDistinct);
        }
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setValueFormatString(String formatString) {
        String oldValue = this.valueFormatString;
        if (Util.unequal((Object)oldValue, (Object)formatString)) {
            this.valueFormatString = formatString;
            this.propertyChangeSupport.firePropertyChange("valueFormatString", oldValue, formatString);
        }
    }

    public String getValueFormatString() {
        return this.valueFormatString;
    }

    public void setLabelDataItem(DataItem labelDataItem) {
        DataItem oldValue = this.labelDataItem;
        if (Util.unequal((Object)oldValue, (Object)labelDataItem)) {
            this.labelDataItem = labelDataItem;
            this.labelDataType = null;
            this.propertyChangeSupport.firePropertyChange("labelDataItem", oldValue, labelDataItem);
        }
    }

    public DataItem getLabelDataItem() {
        if (null == this.labelDataItem && null != this.getInfoMapUrl() && null != this.labelDataItemId && null != this.getDataProvider()) {
            try {
                this.labelDataItem = this.getDataProvider().getDataItemFromId(this.getInfoMapUrl(), this.labelDataItemId);
            }
            catch (ServerConnectionException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
        }
        return this.labelDataItem;
    }

    public void setLabelDataItemId(String dataItemId) {
        this.labelDataItemId = dataItemId;
        this.clearConnection();
    }

    public void setLabelFormatString(String formatString) {
        this.labelFormatString = formatString;
    }

    public String getLabelFormatString() {
        return this.labelFormatString;
    }

    public void setUseValueAsLabel(boolean valuesAsLabels) {
        boolean oldValue = valuesAsLabels;
        if (this.useValueAsLabel != valuesAsLabels) {
            this.useValueAsLabel = valuesAsLabels;
            this.propertyChangeSupport.firePropertyChange("labelDataItem", oldValue, valuesAsLabels);
        }
    }

    public boolean useValueAsLabel() {
        return this.useValueAsLabel;
    }

    public void setSortOrder(String sortOrder) {
        String oldValue = sortOrder;
        if (Util.unequal((Object)this.sortOrder, (Object)sortOrder)) {
            this.sortOrder = sortOrder;
            this.propertyChangeSupport.firePropertyChange("sortOrder", oldValue, sortOrder);
        }
    }

    public String getSortOrder() {
        String retVal = null;
        retVal = null != this.sortOrder ? this.sortOrder : (null != this.getDataItem() ? this.getSortTypeFromAction(this.getDataItem().getSortDirection()) : SORT_UNKNOWN);
        return retVal;
    }

    public void setSortFirst(String sortFirst) {
        String oldValue = sortFirst;
        if (Util.unequal((Object)this.sortFirst, (Object)sortFirst)) {
            this.sortFirst = sortFirst;
            this.propertyChangeSupport.firePropertyChange("sortFirst", oldValue, sortFirst);
        }
    }

    public String getSortFirst() {
        return this.sortFirst;
    }

    public int count() {
        return 0;
    }

    public void setWhereClause(WhereClause where) {
        WhereClause oldValue = this.whereClause;
        if (Util.unequal((Object)this.whereClause, (Object)where)) {
            this.whereClause = where;
            this.dependentPrompts.clear();
            this.propertyChangeSupport.firePropertyChange("where", oldValue, where);
        }
        if (this.whereClause != null) {
            this.getLogger2().debug("where clause set to:", this.whereClause.toString());
        } else {
            this.getLogger2().debug("where clause set to null");
        }
    }

    public WhereClause getWhereClause() {
        return this.whereClause;
    }

    @Override
    public Collection getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) {
        OperandInterface op;
        super.getDependentPrompts(locale, dynamicPromptValueContext);
        if (this.whereClause != null && (op = this.whereClause.getCondition()) instanceof Expression) {
            PromptIQueryUtil.promptsFromExpression((Expression)op, this.dependentPrompts);
        }
        this.getLogger2().debug("getDependentPrompts returns:", Integer.toString(this.dependentPrompts.size()));
        return this.dependentPrompts;
    }

    private void addWherePrompts(DynamicPromptValueContextInterface dynamicPromptValueContext) throws ServerConnectionException, ValueProviderException, MetadataException {
        Vector<FilterItem> list = new Vector<FilterItem>();
        if (this.whereClause == null) {
            return;
        }
        DataItem valueDataItem = this.getDataItemFromID();
        if (valueDataItem == null && this.valueItemExpression == null) {
            return;
        }
        BusinessModel bm = valueDataItem.getBusinessModel();
        ExpressionInterface[] filterExp = WhereToFilterUtil.convertWhereToFilterItemExpressions(this.whereClause, bm);
        for (int i = 0; i < filterExp.length; ++i) {
            FilterItem fi = bm.newFilterItem();
            fi.setExpression(filterExp[i]);
            list.add(fi);
        }
        this.addFilterPrompts(list, dynamicPromptValueContext);
    }

    protected TreeModel getValuesAsTree() {
        throw new UnsupportedOperationException(RB.getStringResource("RelationalDataItemValueProvider.UnsupportedMethodError.txt"));
    }

    @Override
    protected Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, null, dynamicPromptValueContext, returnType, searchCriteria, index, count);
    }

    @Override
    protected Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        Object returnObject = null;
        if (index < 0) {
            throw new ValueProviderException(RB.getStringResource("RelationalDataItemValueProvider.InvalidIndexError.txt", locale));
        }
        if (count == 0) {
            return Collections.EMPTY_LIST;
        }
        if (returnType == ValueType.LIST || returnType == ValueType.TREETHENLIST) {
            returnObject = this.getValuesAsList(locale, promptView, dynamicPromptValueContext, searchCriteria, index, count);
        } else if (returnType == ValueType.TREE) {
            returnObject = this.getValuesAsTree();
        }
        return returnObject;
    }

    protected Object getValuesAsList(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        DataSelection dataSelection = null;
        try {
            if (index < 0) {
                throw new ValueProviderException("Invalid index specified");
            }
            DataItem di = this.resolveDataItems(dynamicPromptValueContext);
            if (di != null || this.valueItemExpression != null) {
                List<ValueItem> l;
                int threshold;
                HashMap definitionValueMap = new HashMap();
                this.dependentPrompts.clear();
                if (null == this.allFilterList) {
                    this.allFilterList = new ArrayList();
                }
                this.allFilterList.clear();
                this.addFilterPrompts(this.getFilterList(), dynamicPromptValueContext);
                this.addWherePrompts(dynamicPromptValueContext);
                if (!this.populateDefinitionValueMap(locale, promptView, dynamicPromptValueContext, definitionValueMap)) {
                    List list = Collections.EMPTY_LIST;
                    return list;
                }
                dataSelection = this.createQuery(promptView, searchCriteria, definitionValueMap);
                if (promptView != null && promptView instanceof IQBasedPromptViewInterface) {
                    ((IQBasedPromptViewInterface)promptView).processValueProviderQuery((BusinessQuery)dataSelection);
                }
                if ((threshold = this.getThreshold()) < 0) {
                    this.getLogger2().debug("All values are being returned, threshold is set to -1");
                }
                int serverCount = threshold < 0 ? threshold : count;
                ValueItem[] valueItemArray = this.getValuesFromServer(dataSelection, locale, index, serverCount);
                List<ValueItem> list = l = Arrays.asList(valueItemArray);
                return list;
            }
            try {
                throw new ValueProviderException(MessageFormat.format(RB.getStringResource("DataItemValueProvider.invalidDataItemID.txt.fmt"), this.getDataItemId()));
            }
            catch (CacheException ce) {
                throw new ValueProviderException((Throwable)ce, ce.getMessage());
            }
            catch (InvalidPromptValueException ce) {
                throw new ValueProviderException((Throwable)ce, ce.getMessage());
            }
            catch (MetadataException ce) {
                throw new ValueProviderException((Throwable)ce, ce.getMessage());
            }
            catch (ServerConnectionException e) {
                throw new ValueProviderException((Throwable)e, e.getMessage());
            }
        }
        finally {
            if (dataSelection != null) {
                dataSelection.dispose();
                dataSelection = null;
            }
        }
    }

    boolean populateDefinitionValueMap(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, Map definitionValueMap) throws ValueProviderException {
        if (promptView == null) {
            if (!this.isAllDependentPromptValuesSet(dynamicPromptValueContext, locale, definitionValueMap)) {
                return false;
            }
        } else {
            if (!dynamicPromptValueContext.isValueSetForAllDependentPromptViews(promptView)) {
                return false;
            }
            Collection dpv = dynamicPromptValueContext.getDependentPromptViews(promptView);
            if (dpv != null && !dpv.isEmpty()) {
                for (PromptViewInterface pv : dpv) {
                    definitionValueMap.put(pv.getPromptDefinition(), pv.getPromptValue());
                }
            } else if (!this.isAllDependentPromptValuesSet(dynamicPromptValueContext, locale, definitionValueMap)) {
                return false;
            }
        }
        return true;
    }

    private DataItem resolveDataItems(DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        DataItem dataitem = null;
        try {
            dataitem = this.getDataItem();
        }
        catch (IllegalStateException ie) {
            String msg = MessageFormat.format(RB.getStringResource("RelationalDataItemValueProvider.invalidDataItemError.fmt"), this.getDataItemId());
            throw new ValueProviderException(msg);
        }
        if (dataitem == null && dynamicPromptValueContext != null) {
            DataProviderInterface dp = dynamicPromptValueContext.getDataProvider();
            String mapName = this.getInfoMapUrl();
            try {
                if (dp != null && !RelationalDataItemValueProvider.isEmpty(mapName) && dp instanceof DataProvider) {
                    this.setDataItem(((DataProvider)dp).getDataItemFromId(this.getInfoMapUrl(), this.getDataItemId()));
                    this.dataType = null;
                    if (this.labelDataItem == null && this.labelDataItemId != null) {
                        this.labelDataItem = ((DataProvider)dp).getDataItemFromId(mapName, this.labelDataItemId);
                    }
                }
            }
            catch (ServerConnectionException se) {
                throw new ValueProviderException((Throwable)se, se.getMessage());
            }
        }
        return dataitem;
    }

    private void setDataItemForExpression(BusinessModel dataSelection) throws ValueProviderException {
        if (this.valueItemExpression != null) {
            try {
                RootDataItem rootDataItem = dataSelection.newDataItem();
                this.setDataItem((DataItem)rootDataItem);
                rootDataItem.setExpression(this.valueItemExpression);
                dataSelection.addBusinessItem((BusinessItem)rootDataItem);
                boolean isUsable = rootDataItem.isUsableInQuery();
                if (!isUsable) {
                    throw new ValueProviderException(this.getReasonsMessage(rootDataItem.getReasonsUnusable()));
                }
            }
            catch (MetadataException me) {
                throw new ValueProviderException((Throwable)me, this.getReasonsMessage(me.getReasons()));
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RelationalDataItemValueProvider clone = (RelationalDataItemValueProvider)((Object)super.clone());
        clone.setDataItem(this.getDataItem());
        clone.labelDataItem = this.labelDataItem;
        clone.setFilterList((List)((ArrayList)this.getFilterList()).clone());
        clone.distinct = this.distinct;
        clone.sortOrder = this.sortOrder;
        return clone;
    }

    private DataSelection createQuery(PromptViewInterface promptView, SearchCriteria searchCriteria, Map defintionValueMap) throws MetadataException, ValueProviderException, InvalidPromptValueException {
        Collection viewFilterList;
        DataSelection dataSelection = this.createQueryItem(searchCriteria);
        List l = dataSelection.getSelectedItems();
        if (this.isFormattedLabels() != this.isFormattedValues() && this.labelDataItem != null) {
            ((SelectedItem)l.get(0)).setFormatType(1);
        }
        dataSelection.setQueryProperty(BusinessQueryProperty.EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS, true);
        ArrayList<FilterItem> effectiveFilters = new ArrayList<FilterItem>(2);
        if (searchCriteria != null) {
            FilterItem searchFilter = this.buildSearchFilter(dataSelection, searchCriteria);
            dataSelection.addBusinessItem((BusinessItem)searchFilter);
            effectiveFilters.add(searchFilter);
        }
        if (promptView != null && (viewFilterList = promptView.getPromptViewFilterExpressions()) != null) {
            for (ExpressionInterface expression : viewFilterList) {
                FilterItem nfi = dataSelection.newFilterItem();
                nfi.setExpression(expression);
                dataSelection.addBusinessItem((BusinessItem)nfi);
                effectiveFilters.add(nfi);
            }
        }
        if (this.allFilterList != null && this.allFilterList.size() > 0) {
            for (FilterItem fi : this.allFilterList) {
                FilterItem nfi = dataSelection.newFilterItem();
                nfi.setExpression(fi.getExpression());
                dataSelection.addBusinessItem((BusinessItem)nfi);
                effectiveFilters.add(nfi);
            }
        }
        if (!effectiveFilters.isEmpty()) {
            dataSelection.setFilters(effectiveFilters);
        }
        if (defintionValueMap != null && !defintionValueMap.isEmpty()) {
            PromptValuesInterface dsPromptValues = dataSelection.getPromptValues();
            Set pdKeys = defintionValueMap.keySet();
            for (PromptDefinitionInterface pd : pdKeys) {
                if (dsPromptValues.findPromptValuesForPromptDefinition(pd) == null) {
                    FindPromptValuesByPromptDefinitionIDVisitor visitor = new FindPromptValuesByPromptDefinitionIDVisitor(pd.getPromptID());
                    dsPromptValues.acceptPromptValuesVisitor((PromptValuesVisitorInterface)visitor);
                    PromptDefinitionInterface pd1 = visitor.getPromptDefinition();
                    if (pd1 == null || pd1.isFixed()) continue;
                    dsPromptValues.setPromptValue(pd1, defintionValueMap.get(pd));
                    continue;
                }
                if (pd.isFixed()) continue;
                dsPromptValues.setPromptValue(pd, defintionValueMap.get(pd));
            }
        }
        return dataSelection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataSelection createQueryItem(SearchCriteria searchCriteria) throws MetadataException, ValueProviderException {
        ArrayList<DataItem> resultItems = new ArrayList<DataItem>(2);
        DataItem valueDataItem = null;
        DataSelection dataSelection = null;
        if (this.valueItemExpression != null) {
            dataSelection = DataSelectionFactory.newDataSelection((BusinessModel)this.businessModel);
            this.setDataItemForExpression((BusinessModel)dataSelection);
            valueDataItem = this.getDataItemFromID();
        } else {
            valueDataItem = this.getDataItemFromID();
            dataSelection = DataSelectionFactory.newDataSelection((BusinessModel)valueDataItem.getBusinessModel());
        }
        if (dataSelection.isActionSupported(BusinessQueryActionType.PROPERTY_RETURN_DISTINCT_VALUES)) {
            dataSelection.setQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES, this.distinct);
        }
        this.labelDataItem = this.getLabelDataItem();
        if (dataSelection.isActionSupported(BusinessQueryActionType.PROPERTY_RETURN_UNFORMATTED_DATA)) {
            dataSelection.setQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA, !this.isFormattedValues());
        }
        DataItem querySearchItem = null;
        DataItemReference dataItemRef = dataSelection.newDataItemReference(valueDataItem);
        boolean formatted = false;
        if (!(this.labelDataItem == null || this.labelDataItem.equals(valueDataItem) && this.isFormattedLabels() == this.isFormattedValues())) {
            DataItemReference refToBase1 = dataSelection.newDataItemReference(this.labelDataItem);
            String defaultNumericFormat = null;
            if (this.labelDataItem.getExpressionTypeIgnoringFormattingForced() == 2 && RelationalDataItemValueProvider.isFormatEmpty(this.labelDataItem.getFormat()) && RelationalDataItemValueProvider.isFormatEmpty(this.labelFormatString)) {
                defaultNumericFormat = "BEST12.";
            }
            if (!(!this.isFormattedLabels() || RelationalDataItemValueProvider.isFormatEmpty(this.labelDataItem.getFormat()) && RelationalDataItemValueProvider.isFormatEmpty(this.labelFormatString) && RelationalDataItemValueProvider.isEmpty(defaultNumericFormat))) {
                formatted = true;
                dataSelection.addBusinessItem((BusinessItem)refToBase1);
                querySearchItem = !RelationalDataItemValueProvider.isFormatEmpty(this.labelFormatString) ? this.getFormattedQueryItem(dataSelection, (DataItem)refToBase1, this.labelFormatString) : (!RelationalDataItemValueProvider.isFormatEmpty(defaultNumericFormat) ? this.getFormattedQueryItem(dataSelection, (DataItem)refToBase1, defaultNumericFormat) : this.getFormattedQueryItem(dataSelection, (DataItem)refToBase1, this.labelDataItem.getFormat()));
                if (Util.equal((Object)this.sortFirst, (Object)LABEL_VALUE)) {
                    querySearchItem.setSortDirection(this.getDataItemActionSortType());
                }
                if (!querySearchItem.isUsableInQuery()) throw new ValueProviderException(this.getReasonsMessage(querySearchItem.getReasonsUnusable()));
                resultItems.add(querySearchItem);
                dataSelection.addBusinessItem((BusinessItem)querySearchItem);
            } else {
                dataSelection.addBusinessItem((BusinessItem)refToBase1);
                querySearchItem = this.getUnformattedQueryItem((DataItem)refToBase1);
                if (Util.equal((Object)this.sortFirst, (Object)LABEL_VALUE)) {
                    querySearchItem.setSortDirection(this.getDataItemActionSortType());
                }
                if (!querySearchItem.isUsableInQuery()) throw new ValueProviderException(this.getReasonsMessage(querySearchItem.getReasonsUnusable()));
                resultItems.add(querySearchItem);
                dataSelection.addBusinessItem((BusinessItem)querySearchItem);
            }
        }
        String defaultNumericFormat = null;
        if (valueDataItem.getExpressionTypeIgnoringFormattingForced() == 2 && RelationalDataItemValueProvider.isFormatEmpty(valueDataItem.getFormat()) && RelationalDataItemValueProvider.isFormatEmpty(this.valueFormatString)) {
            defaultNumericFormat = "BEST12.";
        }
        if (!(!this.isFormattedValues() || RelationalDataItemValueProvider.isFormatEmpty(valueDataItem.getFormat()) && RelationalDataItemValueProvider.isFormatEmpty(this.valueFormatString))) {
            dataSelection.addBusinessItem((BusinessItem)dataItemRef);
            querySearchItem = !RelationalDataItemValueProvider.isFormatEmpty(this.valueFormatString) ? this.getFormattedQueryItem(dataSelection, (DataItem)dataItemRef, this.valueFormatString) : (!RelationalDataItemValueProvider.isFormatEmpty(defaultNumericFormat) ? this.getFormattedQueryItem(dataSelection, (DataItem)dataItemRef, defaultNumericFormat) : this.getFormattedQueryItem(dataSelection, (DataItem)dataItemRef, valueDataItem.getFormat()));
            if (Util.equal((Object)this.sortFirst, (Object)VALUE_LABEL)) {
                querySearchItem.setSortDirection(this.getDataItemActionSortType());
            }
            if (!querySearchItem.isUsableInQuery()) throw new ValueProviderException(this.getReasonsMessage(querySearchItem.getReasonsUnusable()));
            resultItems.add(querySearchItem);
            dataSelection.addBusinessItem((BusinessItem)querySearchItem);
        } else {
            dataSelection.addBusinessItem((BusinessItem)dataItemRef);
            querySearchItem = this.getUnformattedQueryItem((DataItem)dataItemRef);
            if (Util.equal((Object)this.sortFirst, (Object)VALUE_LABEL)) {
                querySearchItem.setSortDirection(this.getDataItemActionSortType());
            }
            if (!querySearchItem.isUsableInQuery()) throw new ValueProviderException(this.getReasonsMessage(querySearchItem.getReasonsUnusable()));
            resultItems.add(querySearchItem);
            dataSelection.addBusinessItem((BusinessItem)querySearchItem);
        }
        if (resultItems.size() == 2 && formatted) {
            DataItemReference refToBase1 = dataSelection.newDataItemReference(this.labelDataItem);
            dataSelection.addBusinessItem((BusinessItem)refToBase1);
            querySearchItem = this.getUnformattedQueryItem((DataItem)refToBase1);
            if (Util.equal((Object)this.sortFirst, (Object)LABEL_VALUE)) {
                querySearchItem.setSortDirection(this.getDataItemActionSortType());
            }
            if (!querySearchItem.isUsableInQuery()) throw new ValueProviderException(this.getReasonsMessage(querySearchItem.getReasonsUnusable()));
            resultItems.add(querySearchItem);
            dataSelection.addBusinessItem((BusinessItem)querySearchItem);
        }
        dataSelection.addResultItems(resultItems, Role.COLUMN);
        return dataSelection;
    }

    private DataItemActionType getDataItemActionSortType() {
        if (this.sortOrder == SORT_ASCENDING || this.sortOrder.equals(SORT_ASCENDING)) {
            return DataItemActionType.SORT_ASCENDING;
        }
        if (this.sortOrder == SORT_DESCENDING || this.sortOrder.equals(SORT_DESCENDING)) {
            return DataItemActionType.SORT_DESCENDING;
        }
        return DataItemActionType.SORT_NONE;
    }

    private String getSortTypeFromAction(DataItemActionType type) {
        if (DataItemActionType.SORT_ASCENDING.equals(type)) {
            return SORT_ASCENDING;
        }
        if (DataItemActionType.SORT_DESCENDING.equals(type)) {
            return SORT_DESCENDING;
        }
        return SORT_NONE;
    }

    private DataItem getFormattedQueryItem(DataSelection ds, DataItem refToBase, String formatString) throws MetadataException {
        refToBase.setFormat(null);
        refToBase.setFormattingForced(false);
        ExpressionInterface exp = refToBase.getExpression();
        if (exp.getExpressionType() == 2 && refToBase.getValidActions().contains(DataItemActionType.USAGE_DETAIL)) {
            refToBase.setUsage(DataItemActionType.USAGE_DETAIL);
        }
        RootDataItem querySearchItem = ds.newDataItem();
        Function putFunc = ds.getServerProperties().getFunctionByNameID(FunctionNameID.PUT);
        StringExpression formatExpression = new StringExpression();
        int index = formatString.indexOf(ColumnInfo.DEFAULT_FORMAT);
        if (index >= 0) {
            formatString = formatString.length() > ColumnInfo.DEFAULT_FORMAT.length() ? formatString.substring(ColumnInfo.DEFAULT_FORMAT.length() + 1, formatString.length()) : null;
        }
        formatExpression.setText(formatString);
        formatExpression.setExpressionType(11);
        FunctionCall searchItemExpression = new FunctionCall(putFunc, new ExpressionInterface[]{refToBase, formatExpression});
        querySearchItem.setExpression((ExpressionInterface)searchItemExpression);
        querySearchItem.setFormat(null);
        querySearchItem.setFormattingForced(false);
        ds.addBusinessItem((BusinessItem)querySearchItem);
        return querySearchItem;
    }

    private DataItem getUnformattedQueryItem(DataItem refToBase) throws MetadataException {
        refToBase.setFormat(null);
        refToBase.setFormattingForced(false);
        if (refToBase.getExpressionType() == 2 && refToBase.getValidActions().contains(DataItemActionType.USAGE_DETAIL)) {
            refToBase.setUsage(DataItemActionType.USAGE_DETAIL);
        }
        return refToBase;
    }

    @Override
    protected DataItem getSearchItem(DataSelection dataSelection) throws ValueProviderException {
        List diList;
        DataItem searchItem = null;
        if (null != dataSelection && null != (diList = dataSelection.getResultItems()) && !diList.isEmpty()) {
            searchItem = (DataItem)diList.get(0);
        }
        if (searchItem == null && this.getDataItemFromID() == null && dataSelection != null) {
            this.setDataItemForExpression((BusinessModel)dataSelection);
        }
        if (searchItem == null) {
            searchItem = this.labelDataItem != null ? this.labelDataItem : this.getDataItemFromID();
        }
        return searchItem;
    }

    @Override
    protected boolean isFormattedSearch() {
        boolean isFormattedSearch = this.labelDataItem != null ? this.formattedLabels : this.formattedValues;
        return isFormattedSearch;
    }

    protected ValueItem[] getValuesFromServer(DataSelection dataSelection, Locale locale, int index, int count) throws CacheException {
        CacheException vpe;
        QueryConnectorInterface qc = this.getQueryConnector();
        boolean qcCreated = false;
        try {
            ArrayList<DataSelection> businessQueries = new ArrayList<DataSelection>(1);
            businessQueries.add(dataSelection);
            List valueItemsList = ListFactory.newList();
            int maxRowCount = count > 0 ? index + count : count;
            Governing governing = dataSelection.newGoverning();
            governing.setOutputObservations(maxRowCount);
            dataSelection.addBusinessRule((BusinessRule)governing);
            if (qc == null) {
                qc = new QueryConnector();
                qcCreated = true;
                RetrievalPolicy policy = new RetrievalPolicy();
                policy.setPolicyValue(0);
                policy.getConnectionConfiguration().setConnectionLifetime(1);
                qc.setRetrievalPolicy(policy);
            }
            this.printQuery(dataSelection);
            String queryId = dataSelection.getID();
            Map results = qc.retrieveQueryResultMap(businessQueries);
            ResultSetInterface resultSet = (ResultSetInterface)results.get(queryId);
            ResultSet rs = (ResultSet)resultSet.getResultSet();
            ResultSetMetaData rsMetadata = rs.getMetaData();
            int colCount = rsMetadata.getColumnCount();
            boolean isOnResultSet = rs.absolute(++index);
            if (!isOnResultSet) {
                ValueItem[] valueItemArray = (ValueItem[])valueItemsList.toArray(EMPTY_VALUEITEM_ARRAY);
                return valueItemArray;
            }
            DataTypeInterface valueDataType = this.convertExpressionTypeToDataType(this.getDataItemFromID());
            if (this.labelDataType == null) {
                this.labelDataType = this.convertExpressionTypeToDataType(this.getSearchItem(dataSelection));
            }
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), locale != null ? locale : Locale.getDefault());
            MissingValues mv = MissingValues.Dot;
            if (this.getDataType() instanceof StringType) {
                mv = MissingValues._BLANK_;
            }
            int valueColumnIndex = Math.min(colCount, 2);
            int labelColumnIndex = colCount;
            if (colCount >= 2) {
                labelColumnIndex = 1;
            }
            int valueItemIndex = 0;
            while (isOnResultSet) {
                Object valueColumn = null;
                Object labelColumn = null;
                boolean isMissing = false;
                if (colCount > 0) {
                    if (this.formattedValues) {
                        valueColumn = rs.getString(valueColumnIndex);
                        if (this.isTrimValues() && valueColumn != null) {
                            valueColumn = ((String)valueColumn).trim();
                        }
                        if (rs.wasNull() || valueColumn == null || ((String)valueColumn).trim().length() == 0) {
                            valueColumn = mv;
                            isMissing = true;
                        }
                    } else {
                        valueColumn = valueDataType instanceof DateType ? rs.getDate(valueColumnIndex, calendar) : (valueDataType instanceof TimeType ? rs.getTime(valueColumnIndex, calendar) : (valueDataType instanceof TimeStampType ? rs.getTimestamp(valueColumnIndex, calendar) : rs.getObject(valueColumnIndex)));
                        if (rs.wasNull() || valueColumn == null || valueColumn instanceof String && ((String)valueColumn).trim().length() == 0) {
                            valueColumn = mv;
                            isMissing = true;
                        }
                    }
                    if (this.labelDataItem != null) {
                        if (this.formattedLabels) {
                            labelColumn = rs.getString(labelColumnIndex);
                            if (this.isTrimLabels() && labelColumn != null) {
                                labelColumn = ((String)labelColumn).trim();
                            }
                            if (colCount == 3) {
                                rs.getString(3);
                            }
                            if (rs.wasNull() || labelColumn == null || ((String)labelColumn).trim().length() == 0) {
                                labelColumn = MissingValues.toDisplayString((MissingValues)mv, (Locale)locale);
                                isMissing = true;
                            }
                        } else {
                            labelColumn = this.labelDataType instanceof DateType ? rs.getDate(labelColumnIndex, calendar) : (this.labelDataType instanceof TimeType ? rs.getTime(labelColumnIndex, calendar) : (valueDataType instanceof TimeStampType ? rs.getTimestamp(labelColumnIndex, calendar) : rs.getObject(labelColumnIndex)));
                            if (colCount == 3) {
                                rs.getObject(3);
                            }
                            if (rs.wasNull() || labelColumn == null || labelColumn instanceof String && ((String)labelColumn).trim().length() == 0) {
                                labelColumn = MissingValues.toDisplayString((MissingValues)mv, (Locale)locale);
                                isMissing = true;
                            }
                        }
                    } else {
                        labelColumn = valueColumn;
                    }
                }
                if (!(isMissing && this.removeMissingValues)) {
                    ValueItem distinctVal = new ValueItem(labelColumn, valueColumn);
                    valueItemsList.add(valueItemIndex++, distinctVal);
                }
                isOnResultSet = rs.next();
            }
            ValueItem[] valueItemArray = (ValueItem[])valueItemsList.toArray(EMPTY_VALUEITEM_ARRAY);
            return valueItemArray;
        }
        catch (SQLException exc) {
            vpe = new CacheException(exc.getMessage());
            vpe.initCause((Throwable)exc);
            throw vpe;
        }
        catch (ExecutionException exc) {
            vpe = new CacheException(exc.getRootException().getMessage());
            vpe.initCause((Throwable)exc);
            throw vpe;
        }
        catch (IntelligentQueryException exc) {
            vpe = new CacheException(exc.getRootException().getMessage());
            vpe.initCause(exc.getRootException());
            throw vpe;
        }
        catch (ValueProviderException exc) {
            vpe = new CacheException(exc.getMessage());
            vpe.initCause((Throwable)exc);
            throw vpe;
        }
        catch (MetadataException me) {
            vpe = new CacheException(me.getRootException().getMessage());
            vpe.initCause(me.getRootException());
            throw vpe;
        }
        finally {
            try {
                int closeResultSet = 1;
                if (qcCreated) {
                    closeResultSet = 4097;
                }
                qc.closeResources(dataSelection.getSession(), closeResultSet);
                qc = null;
                qcCreated = false;
            }
            catch (ExecutionException e) {
                this.getLogger2().error(RB.getStringResource("OLAPDataItemValueProvider.ResultSetCloseError.txt"));
            }
            catch (DataRetrievalException e) {
                this.getLogger2().error(RB.getStringResource("OLAPDataItemValueProvider.ResultSetCloseError.txt"));
            }
        }
    }

    private void printQuery(DataSelection dataSelection) throws IntelligentQueryException {
        if (this.getLogger2().isDebugEnabled()) {
            QueryConnector qc2 = new QueryConnector();
            String query = qc2.getPhysicalQuery((BusinessQuery)dataSelection);
            this.getLogger2().debug("query =", query);
        }
    }

    @Override
    public List getReferencedResources(Class type, boolean recursive) {
        List whereRefs;
        ArrayList<DataItem> list = new ArrayList<DataItem>(2);
        DataItem di = this.getLabelDataItem();
        if (di != null) {
            if (null != type && type.isInstance(di)) {
                list.add(di);
            } else if (null == type) {
                list.add(di);
            }
        }
        if (null != this.getWhereClause() && recursive && (whereRefs = this.whereClause.getReferencedResources(type, recursive)) != null) {
            list.addAll(whereRefs);
        }
        list.addAll(super.getReferencedResources(type, recursive));
        return list;
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects("Where");
        if (!list.isEmpty()) {
            WhereClause clause = (WhereClause)list.get(0);
            this.setWhereClause(clause);
            this.getLogger2().debug("consumeRelObjects, setWhereClause() ");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void consumeAttributes(AttributesProvider provider) {
        PromptsReadingContext rc;
        block7: {
            super.consumeAttributes(provider);
            String refId = provider.consumeAttr("referenceIdLabel");
            if (null != refId) {
                rc = provider.getReadingContext();
                if (null != rc) {
                    Object obj = rc.getObject(refId);
                    if (null != obj && obj instanceof DataItem) {
                        this.setLabelDataItem((DataItem)obj);
                        this.getLogger2().debug("Found a LabelDataItem for this id:", refId);
                        break block7;
                    } else {
                        String msg = MessageFormat.format(RB.getStringResource("DataItemValueProvider.noDataItem.txt.fmt"), refId);
                        throw new IllegalStateException(msg);
                    }
                }
                this.getLogger2().warn(RB.getStringResource("DataItemValueProvider.noReadingContext.txt"));
            }
        }
        this.labelDataItemId = provider.consumeAttr("labelDataItemId");
        if (null == this.labelDataItem) {
            Map optionsMap;
            UserContextInterface userContext;
            this.getLogger2().debug("The labelDataItem is still null.");
            rc = provider.getReadingContext();
            if (null != rc && null != rc.getOptionsMap() && null != (userContext = (UserContextInterface)(optionsMap = rc.getOptionsMap()).get("USER_CONTEXT"))) {
                this.getLogger2().debug("Found a user context, so can make a DataProvider.");
                this.setDataProvider(new DataProvider(userContext));
                ServerInterface server = (ServerInterface)rc.getServer();
                if (null != server) {
                    this.getDataProvider().setMetadataServer(server);
                    this.getLogger2().debug("found a server from the reading context, set it on dataprovider");
                }
            }
        }
        this.setDistinct(provider.consumeBooleanAttr("distinct", true));
        this.setFormattedLabels(provider.consumeBooleanAttr("formattedLabels", false));
        this.setFormattedValues(provider.consumeBooleanAttr("formattedValues", false));
        this.setUseValueAsLabel(provider.consumeBooleanAttr("useValueAsLabel", false));
        this.setSortFirst(provider.consumeAttr("sortFirst"));
        this.setSortOrder(provider.consumeAttr("sortOrder"));
        this.setLabelFormatString(provider.consumeAttr("labelFormatString"));
        this.setValueFormatString(provider.consumeAttr("valueFormatString"));
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        IntegratedWritingContext outer;
        super.writeDefinition(element, writingContext);
        XmlUtil.setBooleanAttr((Element)element, (String)"distinct", (boolean)this.isDistinct(), (boolean)true);
        XmlUtil.setAttr((Element)element, (String)"labelFormatString", (String)this.getLabelFormatString());
        if (!SORT_FIRST_NONE.equals(this.getSortFirst())) {
            XmlUtil.setAttr((Element)element, (String)"sortFirst", (String)this.getSortFirst());
        }
        XmlUtil.setAttr((Element)element, (String)"sortOrder", (String)this.getSortOrder());
        XmlUtil.setBooleanAttr((Element)element, (String)"useValueAsLabel", (boolean)this.useValueAsLabel(), (boolean)false);
        XmlUtil.setAttr((Element)element, (String)"valueFormatString", (String)this.getValueFormatString());
        XmlUtil.setBooleanAttr((Element)element, (String)"formattedLabels", (boolean)this.isFormattedLabels(), (boolean)false);
        XmlUtil.setBooleanAttr((Element)element, (String)"formattedValues", (boolean)this.isFormattedValues(), (boolean)false);
        if (null != this.getWhereClause()) {
            this.getLogger2().debug("Writing where clause.");
            ArrayList<WhereClause> list = new ArrayList<WhereClause>();
            list.add(this.getWhereClause());
            RelationalDataItemValueProvider.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"Where");
        }
        if (null != (outer = writingContext.getOuterContext()) && null != this.getLabelDataItem()) {
            String refId = outer.getReference((Object)this.getLabelDataItem());
            if (null != refId) {
                this.getLogger2().debug("Writing LabelDataItem reference:", refId);
                XmlUtil.setAttr((Element)element, (String)"referenceIdLabel", (String)refId);
            } else {
                this.getLogger2().error(RB.getStringResource("DataItemValueProvider.noRefID.txt"));
            }
        } else {
            this.getLogger2().debug("Writing labelDdataItemId and infoMapUrl for web service and shared prompt cases.");
            if (null != this.getLabelDataItem()) {
                try {
                    this.getLogger2().debug("Writing id and url for real label DataItem.");
                    XmlUtil.setAttr((Element)element, (String)"labelDataItemId", (String)this.getLabelDataItem().getID());
                    this.createMetadataDescriptor(this.getLabelDataItem(), writingContext);
                }
                catch (InvalidIDException e) {
                    this.getLogger2().error(e.getMessage(), (Throwable)e);
                }
            } else {
                this.getLogger2().debug("Writing local fields for label id . labeDataItemId= ", this.labelDataItemId);
                XmlUtil.setAttr((Element)element, (String)"labelDataItemId", (String)this.labelDataItemId);
            }
        }
    }

    public String getDefinitionElementName() {
        return "RelationalDataItemValueProvider";
    }

    public void setFormattedLabels(boolean isFormatted) {
        this.formattedLabels = isFormatted;
    }

    public boolean isFormattedLabels() {
        return this.formattedLabels;
    }

    public void setRemoveMissingValues(boolean removeMissingValues) {
        this.removeMissingValues = removeMissingValues;
    }

    public boolean removeMissingValues() {
        return this.removeMissingValues;
    }
}

