/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.valueprovider.dynamic.iq;

import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.StringType;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.metadata.physical.OlapItem;
import com.sas.iquery.metadata.physical.oma.OMAHierarchy;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicPromptValueContext;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.MemberValueValidatorInterface;
import com.sas.prompts.OLAPPromptViewInterface;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.DataProviderUtil;
import com.sas.prompts.valueprovider.dynamic.iq.DataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.RB;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PerformanceTuning;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import com.sas.storage.olap.tree.LevelNode;
import com.sas.storage.olap.tree.MetadataEntityTreeNode;
import com.sas.storage.olap.tree.MetadataTreeModel;
import com.sas.storage.valueprovider.OLAPSearchCriteria;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderUtil;
import com.sas.storage.valueprovider.ValueType;
import com.sas.util.Util;
import com.sas.util.ValueItem;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import javax.swing.tree.TreeModel;
import org.w3c.dom.Element;

public class OLAPDataItemValueProvider
extends DataItemValueProvider
implements MemberValueValidatorInterface {
    private static final long serialVersionUID = -1797295015981586441L;
    private transient int valueType;
    private int descendentLevel;
    private TupleInterface[] tupleArray;
    private int searchTupleCount;
    private SearchCriteria lastSearchCriteria;
    private MetadataInterface _metadata;
    private MetadataInterface _userMetadata;
    private static String TEMP_MEASURE = "[MEASURES].[__TMP]";

    public OLAPDataItemValueProvider() {
        this(null);
    }

    public OLAPDataItemValueProvider(DataItem dataItem) {
        this.setDataItem(dataItem);
        this.valueType = MetadataEntityTreeNode.MEMBER_TREE;
        this.setThreshold(DataProviderUtil.DEFAULT_OLAP_THRESHOLD);
        this.setDescendentLevel(-1);
        this.lastSearchCriteria = null;
    }

    public void setUserMetadata(MetadataInterface metadata) {
        this._userMetadata = metadata;
    }

    public boolean isSearchable(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        return this.isSearchable();
    }

    public String getDefinitionElementName() {
        return "OLAPDataItemValueProvider";
    }

    private MetadataInterface getMetadataFromDynamicPromptValue(DynamicPromptValueContextInterface dynamicPromptValueContext) throws IQueryServicesException {
        DataProvider dp;
        MetadataInterface metadata = null;
        if (dynamicPromptValueContext != null && dynamicPromptValueContext instanceof DynamicPromptValueContext) {
            metadata = ((DynamicPromptValueContext)dynamicPromptValueContext).getMetadata();
        }
        if (dynamicPromptValueContext != null && metadata == null && (dp = (DataProvider)dynamicPromptValueContext.getDataProvider()) != null) {
            metadata = dp.getOLAPMetadataFromIQ(this.getDataItem().getBusinessModel());
        }
        return metadata;
    }

    private MetadataInterface getMetadataFromPromptView(PromptViewInterface promptView) {
        MetadataInterface metadata = null;
        if (promptView != null && promptView instanceof OLAPPromptViewInterface) {
            metadata = ((OLAPPromptViewInterface)promptView).getMetadata();
        }
        return metadata;
    }

    private MetadataInterface getMetadataFromDataItem(DataItem di) throws IQueryServicesException {
        MetadataInterface metadata = null;
        if (di != null) {
            metadata = BusinessQueryOLAPUtil.getMetadataInterface((Object)di.getBusinessModel());
        }
        return metadata;
    }

    private void releaseMetadataFromIQ(MetadataInterface metadata) {
        if (metadata != null) {
            BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)metadata);
        }
    }

    public void close() {
        this.clearConnection();
    }

    public boolean isValid(String memberName, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        boolean isValid = false;
        boolean iqCreatedMetadata = false;
        MetadataInterface metadata = null;
        if (memberName != null) {
            try {
                metadata = this.getMetadataFromDynamicPromptValue(dynamicPromptValueContext);
                if (metadata == null) {
                    metadata = this.getMetadataFromDataItem(this.getDataItem());
                    iqCreatedMetadata = true;
                }
                String cubeName = this.getCubeName();
                Filter f = new Filter();
                f.setCubeName(cubeName);
                f.setUniqueMemberName(memberName);
                MemberInterface member = null;
                try {
                    member = metadata.getMembers(f, 0, 1)[0];
                }
                catch (OLAPException oe) {
                    boolean bl = isValid;
                    if (iqCreatedMetadata && metadata != null) {
                        this.releaseMetadataFromIQ(metadata);
                    }
                    return bl;
                }
                if (memberName.equalsIgnoreCase(member.getUniqueName())) {
                    ExpressionInterface exp = this.getDataItem().getExpression();
                    if (exp instanceof ResourceAwareStringExpression) {
                        String hierarchyName = BusinessQueryOLAPUtil.getHierarchyName((BusinessModel)this.getDataItem().getBusinessModel(), (DataItem)this.getDataItem());
                        f.reset();
                        f.setCubeName(cubeName);
                        f.setUniqueHierarchyName(hierarchyName);
                        HierarchyInterface hierarchy = metadata.getHierarchy(f);
                        if (member.getLevel().getHierarchy().equals(hierarchy)) {
                            isValid = true;
                        }
                    } else if (exp instanceof Hierarchy && exp instanceof OlapItem) {
                        f.reset();
                        f.setCubeName(cubeName);
                        f.setUniqueHierarchyName(((Hierarchy)exp).getHierarchyUniqueName());
                        HierarchyInterface hierarchy = metadata.getHierarchy(f);
                        if (member.getLevel().getHierarchy().equals(hierarchy)) {
                            isValid = true;
                        }
                    }
                    if (exp instanceof Level) {
                        f.reset();
                        f.setCubeName(cubeName);
                        f.setUniqueLevelName(((OlapItem)exp).getUniqueName());
                        LevelInterface level = metadata.getLevel(f);
                        if (member.getLevel().equals(level)) {
                            isValid = true;
                        }
                    }
                }
            }
            catch (IQueryServicesException se) {
                LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).error(se.getMessage());
                throw new ValueProviderException((Throwable)se, se.getMessage());
            }
            catch (OLAPException se) {
                LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).error(se.getMessage());
                throw new ValueProviderException((Throwable)se, se.getMessage());
            }
            finally {
                if (iqCreatedMetadata && metadata != null) {
                    this.releaseMetadataFromIQ(metadata);
                }
            }
        }
        LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).debug("isValid:memberName=" + memberName);
        return isValid;
    }

    private boolean isSameQuery(SearchCriteria sc) {
        boolean isSameSearchCriteria = false;
        if (Util.equal((Object)this.lastSearchCriteria, (Object)sc)) {
            isSameSearchCriteria = true;
        } else if (this.lastSearchCriteria != null && sc != null && this.lastSearchCriteria.getOperator().equals(sc.getOperator()) && Util.equal((Object)this.lastSearchCriteria.getTextToMatch(), (Object)sc.getTextToMatch())) {
            isSameSearchCriteria = true;
        }
        return isSameSearchCriteria;
    }

    public DataTypeInterface getDataType() throws ValueProviderException {
        if (this.getDataItem() == null) {
            LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).error(RB.getStringResource("OLAPDataItemValueProvider.ValueDataItemNotSetError.txt"));
            throw new ValueProviderException(RB.getStringResource("OLAPDataItemValueProvider.ValueDataItemNotSetError.txt"));
        }
        if (this.dataType == null) {
            this.dataType = this.convertExpressionTypeToDataType(this.getDataItem());
        }
        return this.dataType;
    }

    public DataTypeInterface getDataType(DynamicPromptValueContextInterface dynamicContext) throws ValueProviderException {
        return this.getDataType();
    }

    private DataTypeInterface convertExpressionTypeToDataType(DataItem dataItem) {
        StructureOfDataItem expType = dataItem.getStructure();
        Object dt = null;
        dt = expType.equals(StructureOfDataItem.STRUCTURE_MEASURE) ? DoubleType.DEFAULT_INSTANCE : StringType.DEFAULT_INSTANCE;
        return dt;
    }

    public boolean isSearchable() throws ValueProviderException {
        boolean isSearchable = this.getDataType() instanceof StringType;
        LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).debug("isSerchable=" + isSearchable);
        return isSearchable;
    }

    public void setDescendentLevel(int levelDepth) {
        this.descendentLevel = levelDepth;
    }

    public int getDescendentLevel() {
        return this.descendentLevel;
    }

    public int count() {
        LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).debug("Count is Not Supported yet");
        return 0;
    }

    @Override
    protected Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        if (this.getDataItem() == null && dynamicPromptValueContext != null) {
            try {
                DataProviderInterface dp = dynamicPromptValueContext.getDataProvider();
                if (dp != null && dp instanceof DataProvider) {
                    this.setDataItem(((DataProvider)dp).getDataItemFromId(this.getInfoMapUrl(), this.getDataItemId()));
                }
            }
            catch (ServerConnectionException se) {
                throw new ValueProviderException((Throwable)se, se.getMessage());
            }
        }
        if (promptView != null && !dynamicPromptValueContext.isValueSetForAllDependentPromptViews(promptView)) {
            return Collections.EMPTY_LIST;
        }
        if (this.getDataItem() != null) {
            this.calculateThreshold(dynamicPromptValueContext);
            MetadataInterface metadata = null;
            boolean iqCreatedMetadata = false;
            try {
                if (this._userMetadata != null) {
                    metadata = this._userMetadata;
                }
                if (promptView != null && metadata == null) {
                    metadata = this.getMetadataFromPromptView(promptView);
                }
                if (dynamicPromptValueContext != null && metadata == null) {
                    metadata = this.getMetadataFromDynamicPromptValue(dynamicPromptValueContext);
                }
                Object returnObject = null;
                if (returnType == ValueType.TREE || returnType == ValueType.TREETHENLIST) {
                    returnObject = this.getValuesAsTree(metadata);
                }
                if (returnObject == null || returnType == ValueType.LIST) {
                    if (metadata == null) {
                        metadata = this.getMetadataFromDataItem(this.getDataItem());
                        iqCreatedMetadata = true;
                    }
                    returnObject = this.getValuesAsList(metadata, searchCriteria, index, count);
                }
                TreeModel treeModel = returnObject;
                return treeModel;
            }
            catch (IQueryServicesException ie) {
                throw new ValueProviderException((Throwable)ie, ie.getMessage());
            }
            finally {
                if (iqCreatedMetadata && metadata != null) {
                    this.releaseMetadataFromIQ(metadata);
                }
            }
        }
        this.getLogger2().error(RB.getStringResource("OLAPDataItemValueProvider.ValueDataItemNotSetError.txt"));
        throw new ValueProviderException(RB.getStringResource("OLAPDataItemValueProvider.ValueDataItemNotSetError.txt"));
    }

    private void calculateThreshold(DynamicPromptValueContextInterface dyp) {
        Map thresholdMap;
        DataProviderInterface dp;
        int userThreshold = this.getThreshold();
        if (dyp != null && (dp = dyp.getDataProvider()) instanceof DataProvider && (thresholdMap = ((DataProvider)dp).getThresholdMap()).containsKey(DataProviderUtil.OLAP_LIST_THRESHOLD)) {
            userThreshold = (Integer)thresholdMap.get(DataProviderUtil.OLAP_LIST_THRESHOLD);
            this.getLogger2().debug("Using dataprovider threshold:", String.valueOf(userThreshold));
        }
        this.setThreshold(userThreshold);
    }

    @Override
    protected void clearConnection() {
        this._userMetadata = null;
        if (this._metadata != null) {
            this.releaseMetadataFromIQ(this._metadata);
        }
        this._metadata = null;
    }

    @Override
    protected Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, null, dynamicPromptValueContext, returnType, searchCriteria, index, count);
    }

    private TreeModel getValuesAsTree(MetadataInterface metadata) throws ValueProviderException {
        if (!this.getDataItem().getStructure().isOLAP()) {
            LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).error("OLAPDataItemValueProvider.UnsupportedOperationError.txt");
            throw new UnsupportedOperationException(RB.getStringResource("OLAPDataItemValueProvider.UnsupportedOperationError.txt"));
        }
        LevelNode me = null;
        MetadataTreeModel model = null;
        try {
            if (metadata == null) {
                this._metadata = metadata = this.getMetadataFromDataItem(this.getDataItem());
            }
            String cubeName = this.getCubeName();
            ExpressionInterface exp = this.getDataItem().getExpression();
            Filter f = new Filter();
            f.setCubeName(cubeName);
            if (exp instanceof OMAHierarchy) {
                f.setUniqueHierarchyName(((OMAHierarchy)exp).getHierarchyUniqueName());
                HierarchyInterface hier = metadata.getHierarchy(f);
                LevelInterface[] levels = hier.getLevels();
                if (levels != null && levels.length > 0) {
                    for (int i = 0; i < levels.length; ++i) {
                        if (levels[i].getMemberCount() <= 0) continue;
                        me = new LevelNode(levels[i], this.valueType);
                        model = new MetadataTreeModel((MetadataEntityTreeNode)me);
                        break;
                    }
                }
            }
            if (exp instanceof Level) {
                f.setUniqueLevelName(((OlapItem)exp).getUniqueName());
                LevelInterface level = metadata.getLevel(f);
                me = new LevelNode(level, this.valueType);
                model = new MetadataTreeModel((MetadataEntityTreeNode)me);
            } else if (exp instanceof ResourceAwareStringExpression) {
                String hierarchyName = BusinessQueryOLAPUtil.getHierarchyName((BusinessModel)this.getDataItem().getBusinessModel(), (DataItem)this.getDataItem());
                f.setUniqueHierarchyName(hierarchyName);
                HierarchyInterface hier = metadata.getHierarchy(f);
                LevelInterface[] levels = hier.getLevels();
                if (levels != null && levels.length > 0) {
                    LevelInterface level = levels[0];
                    me = new LevelNode(level, this.valueType);
                    model = new MetadataTreeModel((MetadataEntityTreeNode)me);
                }
            }
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).error(e.getMessage());
            throw new ValueProviderException((Throwable)e, e.getMessage());
        }
        catch (MetadataException e) {
            LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).error(e.getMessage());
            throw new ValueProviderException((Throwable)e, e.getMessage());
        }
        catch (IQueryServicesException e) {
            LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).error(e.getMessage());
            throw new ValueProviderException((Throwable)e, e.getMessage());
        }
        return model;
    }

    private void clearPreviousQueryResults() {
        this.lastSearchCriteria = null;
        this.tupleArray = null;
        this.searchTupleCount = -1;
    }

    public void reset() {
        this.clearPreviousQueryResults();
    }

    protected Collection getValuesAsList(MetadataInterface metadata, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        Collection values = Collections.EMPTY_LIST;
        if (searchCriteria != null && searchCriteria instanceof OLAPSearchCriteria) {
            LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).debug("Member Search Criteria specified");
            String memberName = ((OLAPSearchCriteria)searchCriteria).getUniqueMemberName();
            if (memberName != null) {
                values = this.getMemberSearchValues(metadata, memberName, index, count);
            }
        } else if (searchCriteria != null) {
            this.verifySearchCriteria(searchCriteria);
            if (this.isSameQuery(searchCriteria)) {
                try {
                    this.lastSearchCriteria = searchCriteria;
                    if (this.searchTupleCount >= 0 && index >= this.searchTupleCount) {
                        return values;
                    }
                    Collection c = this.getList(this.tupleArray, index, count);
                    if (c != null) {
                        return c;
                    }
                }
                catch (OLAPException ve) {
                    throw new ValueProviderException((Throwable)ve, ve.getLocalizedMessage());
                }
            }
            this.lastSearchCriteria = searchCriteria;
            String searchQuery = this.buildSearchQuery(searchCriteria);
            LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).debug("SearchQuery= " + searchQuery);
            values = this._executeQuery(metadata, searchQuery, index, count);
        } else {
            this.clearPreviousQueryResults();
            values = this.getListValues(metadata, index, count);
        }
        return values;
    }

    private Collection getMemberSearchValues(MetadataInterface metadata, String memberName, int index, int count) throws ValueProviderException {
        ArrayList<ValueItem> values = new ArrayList<ValueItem>(32);
        try {
            String cubeName = this.getCubeName();
            Filter f = new Filter();
            f.setCubeName(cubeName);
            f.setUniqueMemberName(memberName);
            MemberInterface[] members = metadata.getMembers(f, 0, 1);
            MemberInterface[] mem = members[0].getChildren();
            if (mem != null && mem.length > 0) {
                ValueItem vi = null;
                List path = null;
                for (int i = 0; i < mem.length; ++i) {
                    vi = new ValueItem((Object)mem[i].getName(), (Object)mem[i].getUniqueName());
                    path = ValueProviderUtil.splitOLAPName((String)mem[i].getUniqueName());
                    vi.setAttribute(ValueItem.PARENT, (Object)path);
                    values.add(vi);
                }
            }
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).error(e.getMessage());
        }
        return values;
    }

    private Collection getListValues(MetadataInterface metadata, int index, int count) throws ValueProviderException {
        Vector values = new Vector();
        try {
            String cubeName = this.getCubeName();
            ExpressionInterface exp = this.getDataItem().getExpression();
            Filter f = new Filter();
            f.setCubeName(cubeName);
            if (exp instanceof ResourceAwareStringExpression) {
                String hierarchyName = BusinessQueryOLAPUtil.getHierarchyName((BusinessModel)this.getDataItem().getBusinessModel(), (DataItem)this.getDataItem());
                f.setUniqueHierarchyName(hierarchyName);
                this.getMembers(metadata, f, values, index, count);
            } else if (exp instanceof Hierarchy && exp instanceof OlapItem) {
                f.setUniqueHierarchyName(((Hierarchy)exp).getHierarchyUniqueName());
                this.getMembers(metadata, f, values, index, count);
            }
            if (exp instanceof Level) {
                f.setUniqueLevelName(((OlapItem)exp).getUniqueName());
                LevelInterface[] levels = metadata.getLevels(f);
                this.getMembers(levels, values, index, count);
            }
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).error(e.getMessage());
            throw new ValueProviderException((Throwable)e, e.getMessage());
        }
        catch (MetadataException e) {
            LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).error(e.getMessage());
            throw new ValueProviderException((Throwable)e, e.getMessage());
        }
        return values;
    }

    private void getMembers(MetadataInterface metadata, Filter filter, Collection values, int index, int count) throws OLAPException {
        if (this.descendentLevel < 0) {
            MemberInterface[] members = metadata.getMembers(filter, index, count);
            if (members != null && members.length > 0) {
                ValueItem vi = null;
                List path = null;
                for (int i = 0; i < members.length; ++i) {
                    vi = new ValueItem((Object)members[i].getName(), (Object)members[i].getUniqueName());
                    path = ValueProviderUtil.splitOLAPName((String)members[i].getUniqueName());
                    vi.setAttribute(ValueItem.PARENT, (Object)path);
                    values.add(vi);
                }
            }
        } else {
            LevelInterface[] levels = metadata.getHierarchy(filter).getLevels();
            this.getMembers(levels, values, index, count);
        }
    }

    private void getMembers(LevelInterface[] levels, Collection values, int index, int count) throws OLAPException {
        if (levels != null && levels.length > 0) {
            for (int i = 0; i < levels.length && i <= this.descendentLevel; ++i) {
                MemberInterface[] members = levels[i].getMembers(index, count);
                if (members == null || members.length <= 0) continue;
                for (int j = 0; j < members.length; ++j) {
                    ValueItem vi = new ValueItem((Object)members[j].getName(), (Object)members[j].getUniqueName());
                    List path = ValueProviderUtil.splitOLAPName((String)members[j].getUniqueName());
                    vi.setAttribute(ValueItem.PARENT, (Object)path);
                    values.add(vi);
                }
            }
        }
    }

    private String getCubeName() throws ValueProviderException {
        BusinessModel bm = this.getDataItem().getBusinessModel();
        String cubeName = null;
        try {
            List dataSourceList = bm.getObjects(true, DataSource.class);
            for (DataSource ds : dataSourceList) {
                if (!ds.getStructure().isOLAP() || !(ds instanceof DataSourceCube)) continue;
                cubeName = ((DataSourceCube)ds).getCube().getCubeName();
            }
        }
        catch (MetadataException me) {
            LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).debug(me.getMessage());
            throw new ValueProviderException(RB.getStringResource("OLAPDataItemValueProvider.QueryFailedError.txt"));
        }
        LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).debug("CubeName=" + cubeName);
        return cubeName;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        OLAPDataItemValueProvider clone = (OLAPDataItemValueProvider)((Object)super.clone());
        clone.businessQuery = this.businessQuery;
        clone.setDataItem(this.getDataItem());
        clone.valueType = this.valueType;
        return clone;
    }

    protected static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    protected void verifySearchCriteria(SearchCriteria searchCriteria) throws IllegalArgumentException, ValueProviderException {
        if (searchCriteria.isCaseSensitiveSearch()) {
            LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).error("Case sensitive search is not supported for OLAP");
            throw new ValueProviderException(RB.getStringResource("OLAPDataItemValueProvider.CaseSensitiveSearchNotSupportedError.txt"));
        }
    }

    protected String buildSearchQuery(SearchCriteria searchCriteria) throws ValueProviderException {
        if (searchCriteria == null) {
            return "";
        }
        SearchCriteria odSearchCriteria = searchCriteria;
        String searchFilterMDX = null;
        Object operator = odSearchCriteria.getOperator();
        if (this._isContainsSearch(odSearchCriteria)) {
            String textToMatch = odSearchCriteria.getTextToMatch();
            searchFilterMDX = textToMatch == null || textToMatch.length() == 0 ? this._buildStartsWithSearchQuery(odSearchCriteria) : this._buildContainsSearchQuery(odSearchCriteria);
        } else if (this._isEqualsSearch(odSearchCriteria)) {
            searchFilterMDX = this._buildEqualsSearchQuery(odSearchCriteria);
        } else if (SearchCriteria.OPERATOR_STARTS_WITH.equals(operator)) {
            searchFilterMDX = this._buildStartsWithSearchQuery(odSearchCriteria);
        } else if (SearchCriteria.OPERATOR_ENDS_WITH.equals(operator)) {
            searchFilterMDX = this._buildEndsWithSearchQuery(odSearchCriteria);
        } else if (SearchCriteria.OPERATOR_MATCH_PATTERN.equals(operator)) {
            searchFilterMDX = this._buildMatchPatternSearchQuery(odSearchCriteria);
        }
        return searchFilterMDX;
    }

    private Collection _executeQuery(MetadataInterface metadata, String mdxQuery, int index, int count) throws ValueProviderException {
        OLAPDataSet olapDataSet = null;
        try {
            olapDataSet = new OLAPDataSet(metadata.getConnection(), mdxQuery, 1);
            PerformanceTuning pf = olapDataSet.getPerformanceTuning();
            if (pf == null) {
                pf = new PerformanceTuning();
            }
            ResultSetMetadataInterface resultSetMeta = olapDataSet.getResultSetMetadata();
            AxisInterface colAxis = resultSetMeta.getAxes(0, 1)[0];
            this.searchTupleCount = colAxis.getTupleCount();
            int bufferSize = Math.max(this.getThreshold(), this.searchTupleCount);
            pf.setBufferSize(PerformanceTuning.COLUMNS_AXIS_TYPE, bufferSize);
            pf.setPageSize(PerformanceTuning.COLUMNS_AXIS_TYPE, this.getThreshold());
            pf.setPageCount(PerformanceTuning.COLUMNS_AXIS_TYPE, 1);
            olapDataSet.setPerformanceTuning(pf);
            if (index < 0) {
                throw new ValueProviderException("Invalid Index specified " + index);
            }
            if (index >= this.searchTupleCount) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            if (index + count > this.searchTupleCount) {
                count = this.searchTupleCount;
            }
            this.tupleArray = resultSetMeta.getTuples(0, 0, bufferSize);
            Collection collection = this.getList(this.tupleArray, index, count);
            return collection;
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).error(e.getMessage());
            throw new ValueProviderException((Throwable)e, RB.getStringResource("OLAPDataItemValueProvider.SearchFailedError.txt"));
        }
        finally {
            if (olapDataSet != null) {
                try {
                    olapDataSet.close();
                }
                catch (OLAPException e) {
                    LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).error(RB.getStringResource("OLAPDataItemValueProvider.ResultSetCloseError.txt"));
                }
            }
        }
    }

    private Collection getList(TupleInterface[] tuples, int index, int count) throws OLAPException {
        int startIndex;
        int firstTupleIndex = tuples[0].getTupleIndex();
        int lastTupleIndex = tuples[tuples.length - 1].getTupleIndex();
        if (count > tuples.length || index < firstTupleIndex || index > lastTupleIndex || index >= this.searchTupleCount) {
            return null;
        }
        if (count < 0 || index + count > this.searchTupleCount) {
            count = this.searchTupleCount - index;
        }
        ArrayList<ValueItem> l = new ArrayList<ValueItem>(count);
        for (int i = startIndex = Math.abs(firstTupleIndex - index); i < startIndex + count; ++i) {
            TupleElementInterface[] tupleElement = tuples[i].getElements(0, 1);
            ValueItem vi = new ValueItem((Object)tupleElement[0].getLabel(), (Object)tupleElement[0].getName());
            List path = Collections.EMPTY_LIST;
            if (tupleElement[0].getLevelDepth() > 1) {
                path = ValueProviderUtil.splitOLAPName((String)tupleElement[0].getName());
            }
            vi.setAttribute(ValueItem.PARENT, (Object)path);
            l.add(vi);
        }
        return l;
    }

    private boolean _isContainsSearch(SearchCriteria searchCriteria) {
        Object operator = searchCriteria.getOperator();
        return SearchCriteria.OPERATOR_CONTAINS.equals(operator) || SearchCriteria.OPERATOR_NOT_CONTAINS.equals(operator);
    }

    private boolean _isEqualsSearch(SearchCriteria searchCriteria) {
        Object operator = searchCriteria.getOperator();
        return SearchCriteria.OPERATOR_EQUAL.equals(operator) || SearchCriteria.OPERATOR_NOT_EQUAL.equals(operator);
    }

    private String _buildMatchPatternSearchQuery(SearchCriteria searchCriteria) throws ValueProviderException {
        String textToMatch = searchCriteria.getTextToMatch();
        if ((textToMatch = textToMatch.replaceAll("\"", "\"\"")).length() == 0 || textToMatch.equals("*")) {
            return this.buildSearchQuery("$");
        }
        textToMatch = this.processForWildCardSymbols(textToMatch);
        textToMatch = "^" + textToMatch + "$";
        return this.buildSearchQuery(textToMatch);
    }

    private String _buildStartsWithSearchQuery(SearchCriteria searchCriteria) throws ValueProviderException {
        String textToMatch = searchCriteria.getTextToMatch();
        if (textToMatch.length() == 0) {
            return this.buildSearchQuery("$");
        }
        textToMatch = this.processSpecialSymbolsForPerl(searchCriteria.getTextToMatch());
        textToMatch = '^' + textToMatch;
        return this.buildSearchQuery(textToMatch);
    }

    private String _buildEndsWithSearchQuery(SearchCriteria searchCriteria) throws ValueProviderException {
        String textToMatch = searchCriteria.getTextToMatch();
        if (textToMatch.length() == 0) {
            return this.buildSearchQuery("$");
        }
        textToMatch = this.processSpecialSymbolsForPerl(searchCriteria.getTextToMatch());
        textToMatch = textToMatch + '$';
        return this.buildSearchQuery(textToMatch);
    }

    private String processSpecialSymbolsForPerl(String textToMatch) {
        String processedText = textToMatch;
        processedText = textToMatch.replaceAll("\"", "\"\"");
        processedText = processedText.replaceAll("\\\\", "\\\\\\\\");
        processedText = processedText.replaceAll("\\?", "\\\\?");
        processedText = processedText.replaceAll("\\*", "\\\\\\*");
        processedText = processedText.replaceAll("\\\\&", "\\\\\\&");
        processedText = processedText.replaceAll("\\$", "\\\\\\$");
        processedText = processedText.replaceAll("\\'", "\\\\'");
        processedText = processedText.replaceAll("\\!", "\\\\!");
        processedText = processedText.replaceAll("\\~", "\\\\~");
        processedText = processedText.replaceAll("\\`", "\\\\`");
        processedText = processedText.replaceAll("\\@", "\\\\@");
        processedText = processedText.replaceAll("\\#", "\\\\#");
        processedText = processedText.replaceAll("\\^", "\\\\^");
        processedText = processedText.replaceAll("\\+", "\\\\+");
        processedText = processedText.replaceAll("\\|", "\\\\|");
        processedText = processedText.replaceAll("\\.", "\\\\.");
        processedText = processedText.replaceAll("\\(", "\\\\(");
        processedText = processedText.replaceAll("\\)", "\\\\)");
        processedText = processedText.replaceAll("\r\n", "");
        processedText = processedText.replaceAll("\n", "");
        processedText = processedText.replaceAll("\r", "");
        return processedText;
    }

    private String processForWildCardSymbols(String textToMatch) {
        String processedText = textToMatch;
        processedText = processedText.replaceAll("\\\\&", "\\\\\\&");
        processedText = processedText.replaceAll("\\$", "\\\\\\$");
        processedText = processedText.replaceAll("\\'", "\\\\'");
        processedText = processedText.replaceAll("\\!", "\\\\!");
        processedText = processedText.replaceAll("\\~", "\\\\~");
        processedText = processedText.replaceAll("\\`", "\\\\`");
        processedText = processedText.replaceAll("\\@", "\\\\@");
        processedText = processedText.replaceAll("\\#", "\\\\#");
        processedText = processedText.replaceAll("\\ ", "\\\\ ");
        processedText = processedText.replaceAll("\\^", "\\\\^");
        processedText = processedText.replaceAll("\\+", "\\\\+");
        processedText = processedText.replaceAll("\\|", "\\\\|");
        processedText = processedText.replaceAll("\\.", "\\\\.");
        processedText = processedText.replaceAll("\\(", "\\\\(");
        processedText = processedText.replaceAll("\\)", "\\\\)");
        processedText = processedText.replaceAll("\r\n", "");
        processedText = processedText.replaceAll("\n", "");
        processedText = processedText.replaceAll("\r", "");
        StringBuffer sb = new StringBuffer();
        if (processedText.charAt(0) == '?') {
            sb.append('.');
        } else if (processedText.charAt(0) == '*') {
            sb.append(".*");
            processedText = processedText + '$';
        } else if (processedText.charAt(0) == '\\') {
            if (processedText.length() == 1) {
                sb.append("\\\\");
            } else if (processedText.charAt(1) != '?' && processedText.charAt(1) != '*') {
                sb.append("\\\\");
            }
        } else {
            sb.append(processedText.charAt(0));
        }
        for (int i = 1; i < processedText.length(); ++i) {
            if (processedText.charAt(i) == '?') {
                if (processedText.charAt(i - 1) == '\\') {
                    sb.append("\\\\?");
                    continue;
                }
                sb.append('.');
                continue;
            }
            if (processedText.charAt(i) == '*') {
                if (processedText.charAt(i - 1) == '\\') {
                    sb.append("\\*");
                    continue;
                }
                if (i == processedText.length() - 1) {
                    sb = new StringBuffer('^' + sb.toString());
                }
                sb.append(".*");
                continue;
            }
            if (processedText.charAt(i) == '\\') {
                if (i == processedText.length() - 1) {
                    sb.append("\\\\");
                    continue;
                }
                if (processedText.charAt(i + 1) == '?' || processedText.charAt(i + 1) == '*' || processedText.charAt(i - 1) == '\\' || processedText.charAt(i + 1) == '\\') continue;
                sb.append("\\\\");
                continue;
            }
            sb.append(processedText.charAt(i));
        }
        return sb.toString();
    }

    private String buildSearchQuery(String textToMatch) throws ValueProviderException {
        try {
            String expName = null;
            String dimensionName = null;
            ExpressionInterface exp = this.getDataItem().getExpression();
            if (exp instanceof ResourceAwareStringExpression) {
                dimensionName = expName = BusinessQueryOLAPUtil.getHierarchyName((BusinessModel)this.getDataItem().getBusinessModel(), (DataItem)this.getDataItem());
            } else if (exp instanceof Hierarchy) {
                dimensionName = expName = ((OlapItem)exp).getUniqueName();
            }
            if (exp instanceof Level) {
                expName = ((OlapItem)exp).getUniqueName();
                dimensionName = ((OlapItem)exp).getDimensionName();
            }
            StringBuffer sb = new StringBuffer();
            sb.append("WITH MEMBER ");
            sb.append(TEMP_MEASURE);
            sb.append(" AS '2' ");
            sb.append("SELECT FILTER (");
            if (expName != null && dimensionName != null) {
                sb.append('{');
                sb.append(expName);
                sb.append(".MEMBERS }, ");
                sb.append("PRXMATCH( ");
                sb.append('\"');
                sb.append('\'');
                sb.append(textToMatch);
                sb.append("'i");
                sb.append('\"');
                sb.append(", ");
                sb.append(dimensionName);
                sb.append(".currentMember.name)) ");
                sb.append("ON COLUMNS FROM ");
                sb.append("[");
                sb.append(this.getCubeName());
                sb.append("] ");
                sb.append("WHERE ");
                sb.append(TEMP_MEASURE);
            }
            return sb.toString();
        }
        catch (MetadataException oe) {
            LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).error("Error generating  search query");
            throw new ValueProviderException(RB.getStringResource("OLAPDataItemValueProvider.SearchFailedError.txt"));
        }
    }

    private String _buildContainsSearchQuery(SearchCriteria searchCriteria) throws ValueProviderException {
        String searchFilterMDX = null;
        try {
            String expName = null;
            String dimensionName = null;
            ExpressionInterface exp = this.getDataItem().getExpression();
            if (exp instanceof ResourceAwareStringExpression) {
                dimensionName = expName = BusinessQueryOLAPUtil.getHierarchyName((BusinessModel)this.getDataItem().getBusinessModel(), (DataItem)this.getDataItem());
            } else if (exp instanceof Hierarchy) {
                dimensionName = expName = ((OlapItem)exp).getUniqueName();
            }
            if (exp instanceof Level) {
                expName = ((OlapItem)exp).getUniqueName();
                dimensionName = ((OlapItem)exp).getDimensionName();
            }
            String textToMatch = searchCriteria.getTextToMatch();
            textToMatch = textToMatch.replaceAll("\"", "\"\"");
            StringBuffer sb = new StringBuffer();
            sb.append("WITH MEMBER ");
            sb.append(TEMP_MEASURE);
            sb.append(" AS '2' ");
            sb.append("SELECT FILTER (");
            if (expName != null && dimensionName != null) {
                sb.append('{');
                sb.append(expName);
                sb.append(".MEMBERS }, ");
                sb.append("FIND( ");
                sb.append(dimensionName);
                sb.append(".currentMember.name,  ");
                sb.append('\"');
                sb.append(textToMatch);
                sb.append("\", ");
                sb.append("'i')) ");
                sb.append("ON COLUMNS FROM ");
                sb.append("[");
                sb.append(this.getCubeName());
                sb.append("] ");
                sb.append("WHERE ");
                sb.append(TEMP_MEASURE);
            }
            searchFilterMDX = sb.toString();
        }
        catch (MetadataException oe) {
            LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).error("Error generating contians search query");
            throw new ValueProviderException(RB.getStringResource("OLAPDataItemValueProvider.SearchFailedError.txt"));
        }
        return searchFilterMDX;
    }

    private String buildEqualsSearchQuery(SearchCriteria searchCriteria, boolean isNegated) throws ValueProviderException {
        String searchFilterMDX = null;
        try {
            String expName = null;
            String dimensionName = null;
            ExpressionInterface exp = this.getDataItem().getExpression();
            if (exp instanceof ResourceAwareStringExpression) {
                dimensionName = expName = BusinessQueryOLAPUtil.getHierarchyName((BusinessModel)this.getDataItem().getBusinessModel(), (DataItem)this.getDataItem());
            } else if (exp instanceof Hierarchy) {
                dimensionName = expName = ((OlapItem)exp).getUniqueName();
            }
            if (exp instanceof Level) {
                expName = ((OlapItem)exp).getUniqueName();
                dimensionName = ((OlapItem)exp).getDimensionName();
            }
            String textToMatch = searchCriteria.getTextToMatch();
            textToMatch = textToMatch.replaceAll("\"", "\"\"");
            StringBuffer sb = new StringBuffer();
            sb.append("WITH MEMBER ");
            sb.append(TEMP_MEASURE);
            sb.append(" AS '2' ");
            sb.append("SELECT FILTER (");
            if (expName != null && dimensionName != null) {
                sb.append('{');
                sb.append(expName);
                sb.append(".MEMBERS }, ");
                sb.append("SUBSTR( UPCASE( ");
                sb.append(dimensionName);
                sb.append(".currentMember.name),");
                sb.append("1 ");
                sb.append(") = ");
                sb.append('\"');
                sb.append(textToMatch.toUpperCase());
                sb.append("\") ");
                sb.append("ON COLUMNS FROM ");
                sb.append("[");
                sb.append(this.getCubeName());
                sb.append("] ");
                sb.append("WHERE ");
                sb.append(TEMP_MEASURE);
            }
            searchFilterMDX = sb.toString();
        }
        catch (MetadataException oe) {
            LoggerRepository2.getLogger((String)OLAPDataItemValueProvider.class.getName(), null).error("Error creating equals search query");
            throw new ValueProviderException(RB.getStringResource("OLAPDataItemValueProvider.SearchFailedError.txt"));
        }
        return searchFilterMDX;
    }

    private String _buildEqualsSearchQuery(SearchCriteria searchCriteria) throws ValueProviderException {
        Object operator = searchCriteria.getOperator();
        boolean isNegated = SearchCriteria.OPERATOR_NOT_EQUAL.equals(operator);
        return this.buildEqualsSearchQuery(searchCriteria, isNegated);
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setDescendentLevel(provider.consumeIntAttr("descendentLevel", -1));
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setIntAttr((Element)element, (String)"descendentLevel", (int)this.getDescendentLevel());
    }

    protected boolean validateAndStoreFilters(List filters, List allFiltersList) {
        if (filters != null && !filters.isEmpty()) {
            for (Object fi : filters) {
                if (fi instanceof FilterItem) {
                    try {
                        BusinessModel bm = this.getDataItem().getBusinessModel();
                        FilterItem nfi = bm.newFilterItem();
                        bm.addBusinessItem((BusinessItem)nfi);
                        nfi.setExpression((ExpressionInterface)((FilterItem)fi).getExpression().clone());
                        allFiltersList.add(nfi);
                    }
                    catch (CloneNotSupportedException se) {
                        this.getLogger2().warn(se.getMessage(), (Throwable)se);
                    }
                    catch (MetadataException me) {
                        this.getLogger2().warn(me.getMessage(), (Throwable)me);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Should be a Filter Item object");
            }
        }
        return true;
    }
}

