/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.valueprovider.dynamic.iq;

import com.sas.datatypes.DataTypeInterface;
import com.sas.models.MutableThresholdInterface;
import com.sas.prompts.DynamicListSearchInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.MemberValueValidatorInterface;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.util.iquery.PromptIQueryUtil;
import com.sas.prompts.valueprovider.dynamic.iq.OLAPDataItemValueProvider;
import com.sas.storage.valueprovider.ListSearchInterface;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueType;
import com.sas.storage.vr.dto.ColumnValueItem;
import com.sas.storage.vr.dto.DataSource;
import com.sas.storage.vr.dto.DynamicValueRetrieverConfiguration;
import com.sas.storage.vr.dto.QueryItem;
import com.sas.storage.vr.dto.QueryItemSearchCriteria;
import com.sas.storage.vr.dto.Search;
import com.sas.storage.vr.dto.SearchOperatorEnum;
import com.sas.storage.vr.dto.ValueDataTypeEnum;
import com.sas.storage.vr.dto.ValueRetrieverConfiguration;
import com.sas.svcs.formvr.client.ValueRetrieverExceptionHolder;
import com.sas.svcs.formvr.client.ValueRetrieverServiceInterface;
import com.sas.svcs.formvr.client.types.GetValuesAsListParameters;
import com.sas.svcs.formvr.client.types.GetValuesAsTreeParameters;
import com.sas.util.ResourceReferencesInterface;
import com.sas.util.ValidateArg;
import com.sas.util.ValueItem;
import com.sas.util.anno.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.TreeModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class OLAPDataItemVPtoVRConverter
implements MemberValueValidatorInterface,
ValueProviderInterface,
DynamicValueProviderInterface,
ListSearchInterface,
DynamicListSearchInterface,
ResourceReferencesInterface,
MutableThresholdInterface {
    private static Logger logger = LogManager.getLogger(OLAPDataItemVPtoVRConverter.class);
    private OLAPDataItemValueProvider delegate = null;
    private ValueRetrieverServiceInterface valueRetrieverProxy;

    public OLAPDataItemVPtoVRConverter(@NotNull ValueRetrieverServiceInterface proxy, @NotNull OLAPDataItemValueProvider valueProvider) {
        ValidateArg.notNull((Object)proxy, (String)"proxy");
        ValidateArg.notNull((Object)((Object)valueProvider), (String)"valueProvider");
        this.valueRetrieverProxy = proxy;
        this.delegate = valueProvider;
    }

    private Object ultimateGetValues(Locale locale, ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        logger.debug("ultimateGetValues for: " + this.delegate.getInfoMapUrl());
        DataSource ds = new DataSource();
        ds.setDataSourceLocation(this.delegate.getInfoMapUrl());
        ds.setDataSourceType(8L);
        ArrayList<QueryItem> ql = new ArrayList<QueryItem>();
        QueryItem qItem1 = new QueryItem();
        qItem1.setDataSource(ds);
        qItem1.setUniqueName(this.delegate.getDataItemId());
        qItem1.setDataType(ValueDataTypeEnum.STRING);
        ql.add(qItem1);
        qItem1.setTrimValues(true);
        DynamicValueRetrieverConfiguration dvrConfig = new DynamicValueRetrieverConfiguration();
        dvrConfig.setDynamicSource(true);
        dvrConfig.getQueryItems().add(qItem1);
        Object returnObject = null;
        try {
            if (returnType == ValueType.TREE || returnType == ValueType.TREETHENLIST) {
                returnObject = this.getValuesAsTree(dvrConfig, locale);
            }
            if (returnObject == null || returnType == ValueType.LIST) {
                returnObject = this.getValuesAsList(dvrConfig, locale, searchCriteria, index, count);
            }
        }
        catch (ValueRetrieverExceptionHolder e) {
            logger.error(e.getValueRetrieverException().getMessage(), (Throwable)e);
            throw PromptIQueryUtil.convertedValueProviderException(e);
        }
        return returnObject;
    }

    private Object getValuesAsList(DynamicValueRetrieverConfiguration dvrConfig, Locale locale, SearchCriteria searchCriteria, int index, int count) throws ValueRetrieverExceptionHolder {
        List result = null;
        if (null == searchCriteria) {
            GetValuesAsListParameters parameters = new GetValuesAsListParameters();
            parameters.setCount(count);
            parameters.setIndex(index);
            if (null != locale) {
                parameters.setLocale(locale.toString());
            }
            parameters.setValueRetrieverConfiguration((ValueRetrieverConfiguration)dvrConfig);
            logger.debug("Calling getValuesAsList() with these parameters: ");
            logger.debug(PromptIQueryUtil.prettyPrintGetValuesAsListParameters(parameters));
            result = this.valueRetrieverProxy.getValuesAsList(parameters);
        } else {
            GetValuesAsListParameters parameters = new GetValuesAsListParameters();
            parameters.setCount(count);
            parameters.setIndex(index);
            if (null != locale) {
                parameters.setLocale(locale.toString());
            }
            Search search = new Search();
            QueryItemSearchCriteria qic = PromptIQueryUtil.newQueryItemSearchCriteria(searchCriteria, dvrConfig.getQueryItems());
            ArrayList<QueryItemSearchCriteria> searchCriteriaList = new ArrayList<QueryItemSearchCriteria>();
            searchCriteriaList.add(qic);
            search.setSearchCriteriaList(searchCriteriaList);
            search.setOperator(SearchOperatorEnum.AND_OPERATOR);
            dvrConfig.setSearch(search);
            if (logger.isDebugEnabled()) {
                logger.debug("Calling getSearchValuesAsList() with these parameters: ");
                logger.debug(PromptIQueryUtil.prettyPrintGetMultiSearchValuesAsListParameters(parameters));
            }
            parameters.setValueRetrieverConfiguration((ValueRetrieverConfiguration)dvrConfig);
            result = this.valueRetrieverProxy.getValuesAsList(parameters);
        }
        return OLAPDataItemVPtoVRConverter.convertResults(result);
    }

    private TreeModel getValuesAsTree(DynamicValueRetrieverConfiguration dvrConfig, Locale locale) throws ValueRetrieverExceptionHolder {
        GetValuesAsTreeParameters parameters = new GetValuesAsTreeParameters();
        if (null != locale) {
            parameters.setLocale(locale.toString());
        }
        parameters.setValueRetrieverConfiguration((ValueRetrieverConfiguration)dvrConfig);
        if (logger.isDebugEnabled()) {
            logger.debug("Calling getValuesAsTree() with these parameters: ");
            logger.debug(PromptIQueryUtil.prettyPrintGetValuesAsTreeParameters(parameters));
        }
        List result = this.valueRetrieverProxy.getValuesAsTree(parameters);
        return PromptIQueryUtil.convertResultsToTree(result);
    }

    private Object getValues(Locale locale, ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, null, returnType, searchCriteria, index, count);
    }

    private Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.ultimateGetValues(locale, returnType, searchCriteria, index, count);
    }

    public boolean isValid(String memberName, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        this.delegate.isValid(memberName, dynamicPromptValueContext);
        return false;
    }

    public DataTypeInterface getDataType() throws ValueProviderException {
        return this.delegate.getDataType();
    }

    public Object getValues(Locale locale) throws ValueProviderException {
        return this.getValues(locale, ValueType.LIST, null, 0, -1);
    }

    public Object getValues(Locale locale, int index, int count) throws ValueProviderException {
        return this.getValues(locale, ValueType.LIST, null, index, count);
    }

    public Object getValues(Locale locale, ValueType returnType) throws ValueProviderException {
        return this.getValues(locale, returnType, null, 0, -1);
    }

    public Object getValues(Locale locale, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, returnType, null, index, count);
    }

    public boolean isValueDisplayed() {
        return this.delegate.isValueDisplayed();
    }

    public DataTypeInterface getDataType(DynamicPromptValueContextInterface dynamicValuesContext) throws ValueProviderException {
        return this.delegate.getDataType(dynamicValuesContext);
    }

    public Collection getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicValuesContext) throws ValueProviderException {
        return this.delegate.getDependentPrompts(locale, dynamicValuesContext);
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, returnType, null, 0, -1);
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, returnType, null, index, count);
    }

    public Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType) throws ValueProviderException {
        return this.ultimateGetValues(locale, returnType, null, 0, -1);
    }

    public Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.ultimateGetValues(locale, returnType, null, index, count);
    }

    public Object getValues(Locale locale, SearchCriteria searchCriterion) throws ValueProviderException {
        return this.getValues(locale, ValueType.LIST, searchCriterion, 0, -1);
    }

    public Object getValues(Locale locale, SearchCriteria searchCriterion, int index, int count) throws ValueProviderException {
        return this.getValues(locale, ValueType.LIST, searchCriterion, index, count);
    }

    public boolean isSearchable() throws ValueProviderException {
        return this.delegate.isSearchable();
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, ValueType.LIST, searchCriteria, 0, -1);
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, ValueType.LIST, searchCriteria, index, count);
    }

    public Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.ultimateGetValues(locale, ValueType.LIST, searchCriteria, index, count);
    }

    public boolean isSearchable(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        return true;
    }

    public List getReferencedResources(Class arg0, boolean arg1) {
        return this.delegate.getReferencedResources(arg0, arg1);
    }

    public void setThreshold(int arg0) {
        this.delegate.setThreshold(arg0);
    }

    public int getThreshold() {
        return this.delegate.getThreshold();
    }

    public Object clone() throws CloneNotSupportedException {
        OLAPDataItemVPtoVRConverter obj = (OLAPDataItemVPtoVRConverter)super.clone();
        try {
            obj.delegate = (OLAPDataItemValueProvider)((Object)this.delegate.clone());
            obj.valueRetrieverProxy = this.valueRetrieverProxy;
            return obj;
        }
        catch (CloneNotSupportedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return obj;
        }
    }

    private static List<ValueItem> convertResults(List<ColumnValueItem> result) {
        ArrayList<ValueItem> retVal = new ArrayList<ValueItem>();
        if (null != result && !result.isEmpty()) {
            List values = result.get(result.size() - 1).getRowData();
            List labels = Collections.emptyList();
            if (result.size() == 2) {
                labels = result.get(0).getRowData();
            }
            int i = 0;
            for (i = 0; i < values.size(); ++i) {
                ValueItem item = new ValueItem();
                item.setAttribute(ValueItem.PARENT, values.get(i));
                if (!labels.isEmpty() && labels.size() > i) {
                    Object label = labels.get(i);
                    if (label instanceof QueryItem) {
                        item.setValue((Object)((QueryItem)label).getUniqueName());
                        item.setLabel(((QueryItem)label).getLabel());
                    }
                    if (label instanceof String) {
                        item.setLabel((String)label);
                    }
                }
                retVal.add(item);
            }
        }
        return retVal;
    }
}

