/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.valueprovider.dynamic.iq;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.MapFolder;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.models.datasources.BaseDataSource;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.valueprovider.dynamic.BasePromptDynamicValueProvider;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.iq.RB;
import com.sas.prompts.valueprovider.dynamic.workspace.DataSourceColumnWithFormat;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.simplesqlmodel.ColumnInfo;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueType;
import com.sas.util.ListFactory;
import com.sas.util.SimpleTemplate;
import com.sas.util.ValueItem;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.PersistHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Element;

public class InfoMapItemsValueProvider
extends BasePromptDynamicValueProvider {
    private static final long serialVersionUID = 4036874564615874304L;
    protected transient InformationMap infoMap;
    protected String infoMapUrl;
    protected boolean isOLAP;
    protected boolean isFilterItems;
    private List filterList;
    private List dataItemList;

    public InfoMapItemsValueProvider() {
        this.filterList = null;
        this.dataItemList = null;
    }

    public InfoMapItemsValueProvider(boolean isFilterItems) {
        this.isFilterItems = isFilterItems;
        this.filterList = null;
        this.dataItemList = null;
    }

    public boolean isSearchable(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        return false;
    }

    public void setIsOLAP(boolean isOLAP) {
        this.isOLAP = isOLAP;
    }

    public boolean isOLAP() {
        return this.isOLAP;
    }

    public void setInformationMap(InformationMap infoMap) {
        this.infoMap = infoMap;
        this.infoMapUrl = null;
        this.filterList = null;
        this.dataItemList = null;
        try {
            if (((BriefInformationMap)infoMap).getStructure().isOLAP()) {
                this.isOLAP = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public InformationMap getInformationMap() {
        return this.infoMap;
    }

    public void setInfoMapUrl(String infoMapUrl) {
        this.infoMapUrl = PersistHelper.parseSBIPUrl((String)infoMapUrl);
        this.getLogger2().debug("setInfoMapUrl():", this.infoMapUrl);
        this.infoMap = null;
        this.filterList = null;
        this.dataItemList = null;
    }

    public String getInfoMapUrl() {
        return this.infoMapUrl;
    }

    @Override
    public Collection getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) {
        SimpleTemplate template = new SimpleTemplate(this.infoMapUrl);
        Map dependentNames = template.getNameDictionary();
        ArrayList dependentPrompts = new ArrayList();
        dependentPrompts.addAll(dependentNames.keySet());
        return dependentPrompts;
    }

    @Override
    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, ValueType.LIST, null, 0, -1);
    }

    @Override
    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, ValueType.LIST, searchCriteria, index, count);
    }

    @Override
    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, returnType, null, index, count);
    }

    @Override
    public Object getValues(Locale locale, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, null, returnType, index, count);
    }

    @Override
    public Object getValues(Locale locale, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, null, searchCriteria, index, count);
    }

    private Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        Object returnObject = null;
        try {
            if (this.infoMapUrl != null && this.infoMapUrl.length() > 0) {
                String mapName = this.infoMapUrl;
                if (this.dataprovider == null) {
                    this.dataprovider = dynamicPromptValueContext.getDataProvider();
                }
                if (this.dataprovider == null) {
                    throw new ValueProviderException(RB.getStringResource("InfoMapItemsValueProvider.noDataproviderError.txt"));
                }
                this.infoMap = ((DataProvider)this.dataprovider).getInformationMap(mapName);
            }
            if (this.infoMap == null) {
                throw new ValueProviderException(RB.getStringResource("InfoMapItemsValueProvider.noMapError.txt"));
            }
            if (returnType == ValueType.TREE || returnType == ValueType.TREETHENLIST) {
                returnObject = this.getValuesAsTree(this.infoMap);
            } else if (returnType == ValueType.LIST) {
                returnObject = this.getValuesAsList(this.infoMap, index, count);
            }
        }
        catch (ServerConnectionException se) {
            throw new ValueProviderException((Throwable)se, se.getMessage());
        }
        return returnObject;
    }

    protected Collection getValuesAsList(InformationMap infoMap, int index, int count) {
        List returnList;
        block21: {
            int size;
            int returnCount;
            block20: {
                returnList = Collections.EMPTY_LIST;
                if (index < 0 || count == 0) {
                    return returnList;
                }
                returnCount = count;
                try {
                    if (this.isFilterItems && this.filterList == null) {
                        this.filterList = new ArrayList();
                        List dil = infoMap.getObjects(true, FilterItem.class);
                        for (FilterItem di : dil) {
                            this.filterList.add(new ValueItem((Object)di.getLabel(), (Object)di.getID()));
                        }
                    } else if (this.dataItemList == null) {
                        List diList = infoMap.getObjects(true, DataItem.class);
                        this.dataItemList = ListFactory.newList();
                        boolean isOlapMap = infoMap.getStructure().isOLAP();
                        for (DataItem di : diList) {
                            if (di.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE || !di.isUsableInQuery()) continue;
                            if (isOlapMap) {
                                ValueItem valueItem = new ValueItem((Object)di.getLabel(), (Object)di.getID());
                                String path = InfoMapItemsValueProvider.getFolderPathForDataItem(infoMap, di);
                                if (path != null && path.length() != 0) {
                                    valueItem.setAttribute("DI_PATH", (Object)path);
                                }
                                this.dataItemList.add(valueItem);
                                continue;
                            }
                            BaseDataSource ds = new BaseDataSource(4L, this.infoMapUrl);
                            DataSourceColumnWithFormat dsColumn = new DataSourceColumnWithFormat((DataSourceInterface)ds, di.getID(), di.getLabel(), InfoMapItemsValueProvider.getDataSourceColumnType(di));
                            String format = di.getFormat();
                            if (format != null) {
                                dsColumn.setFormat(ColumnInfo.DEFAULT_FORMAT + " " + format);
                            } else {
                                dsColumn.setFormat(ColumnInfo.DEFAULT_FORMAT);
                            }
                            ValueItem valueItem = new ValueItem((Object)di.getLabel(), (Object)dsColumn);
                            if (infoMap.getBriefMap() != null) {
                                valueItem.setAttribute(ValueItem.PARENT, (Object)infoMap.getBriefMap().getName());
                                String path = InfoMapItemsValueProvider.getFolderPathForDataItem(infoMap, di);
                                if (path != null && path.length() != 0) {
                                    valueItem.setAttribute("DI_PATH", (Object)path);
                                }
                            } else {
                                valueItem.setAttribute(ValueItem.PARENT, (Object)infoMap.getLabel());
                            }
                            this.dataItemList.add(valueItem);
                        }
                    }
                }
                catch (Exception e) {
                    this.getLogger2().error(e.getMessage(), (Throwable)e);
                }
                if (!this.isFilterItems || this.filterList == null) break block20;
                int size2 = this.filterList.size();
                if (index >= size2) break block21;
                if (count > size2) {
                    returnCount = size2;
                }
                returnList = ListFactory.newList((int)returnCount);
                int i = index;
                for (int l = 0; l < returnCount; ++l) {
                    returnList.add(l, this.filterList.get(i));
                    ++i;
                }
                break block21;
            }
            if (this.dataItemList != null && index < (size = this.dataItemList.size())) {
                if (count > size || count < 0) {
                    returnCount = size;
                }
                returnList = ListFactory.newList((int)returnCount);
                int i = index;
                for (int l = 0; l < returnCount; ++l) {
                    returnList.add(l, this.dataItemList.get(i));
                    ++i;
                }
            }
        }
        return returnList;
    }

    private Object getValuesAsTree(InformationMap infoMap) throws ValueProviderException {
        try {
            MapFolder root = infoMap.getRootMapFolder();
            FolderNode rootNode = new FolderNode(root, infoMap.getLabel());
            DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
            return treeModel;
        }
        catch (MetadataException me) {
            throw new ValueProviderException((Throwable)me, me.getMessage());
        }
    }

    public static long getDataSourceColumnType(DataItem di) {
        int expType = di.getExpressionTypeIgnoringFormattingForced();
        long dt = -1L;
        switch (expType) {
            case 2: {
                dt = 2L;
                break;
            }
            case 3: {
                dt = 1L;
                break;
            }
            case 9: {
                dt = 1L;
                break;
            }
            case 4: {
                dt = 4L;
                break;
            }
            case 5: {
                dt = 8L;
                break;
            }
            case 6: {
                dt = 16L;
                break;
            }
            case 8: {
                dt = 4L;
                break;
            }
            case 7: {
                dt = 4L;
                break;
            }
            default: {
                dt = -1L;
            }
        }
        return dt;
    }

    public TreeModel getValuesAsTree() throws ValueProviderException {
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        InfoMapItemsValueProvider clone = (InfoMapItemsValueProvider)((Object)super.clone());
        clone.infoMap = this.infoMap;
        clone.infoMapUrl = this.infoMapUrl;
        clone.isOLAP = this.isOLAP;
        clone.isFilterItems = this.isFilterItems;
        return clone;
    }

    private static String getFolderPathForDataItem(InformationMap infoMap, DataItem dataItem) throws MetadataException {
        StringBuffer path = new StringBuffer();
        MapFolder root = infoMap.getRootMapFolder();
        MapFolder dataItemFolder = InfoMapItemsValueProvider.findMapFolderContainingDataItem(root, dataItem);
        if (dataItemFolder != null && dataItemFolder != root) {
            while (dataItemFolder != null && dataItemFolder != root) {
                path.insert(0, dataItemFolder.getLabel());
                if ((dataItemFolder = dataItemFolder.getParent()) == null || dataItemFolder == root) continue;
                path.insert(0, "/");
            }
        }
        return path.toString();
    }

    private static MapFolder findMapFolderContainingDataItem(MapFolder folder, DataItem dataItem) {
        List items = folder.getItems(DataItem.class);
        if (items != null) {
            for (DataItem di : items) {
                if (di != dataItem) continue;
                return folder;
            }
        }
        if ((items = folder.getSubfolders()) != null) {
            for (Object o : items) {
                MapFolder foundFolder;
                if (!(o instanceof MapFolder) || (foundFolder = InfoMapItemsValueProvider.findMapFolderContainingDataItem((MapFolder)o, dataItem)) == null) continue;
                return foundFolder;
            }
        }
        return null;
    }

    public String getDefinitionElementName() {
        return "InfoMapItemsValueProvider";
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        if (null != this.infoMapUrl) {
            XmlUtil.setAttr((Element)element, (String)"infoMapUrl", (String)("URL::" + this.infoMapUrl));
        }
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.infoMapUrl = PersistHelper.parseSBIPUrl((String)provider.consumeAttr("infoMapUrl"));
    }

    class FolderNode
    extends DefaultMutableTreeNode {
        private MapFolder folder;
        protected int childCount;
        protected boolean initialized;
        protected String name;

        public FolderNode(MapFolder folder) {
            this.folder = folder;
            this.name = folder.getLabel();
        }

        public FolderNode(MapFolder folder, String label) {
            this.folder = folder;
            this.name = label;
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public int getChildCount() {
            if (!this.initialized) {
                this.populateChildren();
                this.childCount = this.children.size();
            }
            return this.childCount;
        }

        @Override
        public boolean isLeaf() {
            return this.getChildCount() <= 0;
        }

        public Enumeration children() {
            if (!this.initialized) {
                this.populateChildren();
            }
            return super.children();
        }

        @Override
        public TreeNode getParent() {
            return super.getParent();
        }

        @Override
        public TreeNode getChildAt(int index) {
            if (!this.initialized) {
                this.populateChildren();
            }
            return super.getChildAt(index);
        }

        protected synchronized void populateChildren() {
            List items;
            if (this.children == null) {
                this.children = new Vector();
            }
            if ((items = this.folder.getItems(DataItem.class)) != null) {
                for (DataItem di : items) {
                    if (di.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE || !di.isUsableInQuery()) continue;
                    DefaultMutableTreeNode child = new DefaultMutableTreeNode(di);
                    child.setParent(this);
                    this.children.add(child);
                }
            }
            if ((items = this.folder.getSubfolders()) != null) {
                for (Object o : items) {
                    if (!(o instanceof MapFolder)) continue;
                    FolderNode mn = new FolderNode((MapFolder)o);
                    this.children.add(mn);
                }
            }
            this.initialized = true;
        }

        protected void createDummyNode(String name) {
            this.name = name;
            this.childCount = 0;
        }
    }
}

