/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.valueprovider.dynamic.iq;

import com.sas.MissingValues;
import com.sas.iquery.dataservices.DataServicesException;
import com.sas.iquery.dataservices.IQDataServices;
import com.sas.iquery.dataservices.IQDataServicesFactory;
import com.sas.iquery.dataservices.PossibleFilterValue;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Governing;
import com.sas.iquery.metadata.business.LookupByDataItem;
import com.sas.iquery.metadata.business.LookupNotAllowed;
import com.sas.iquery.metadata.expr.AbstractTimeValueExpression;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ConstantExpressionInterface;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.valueprovider.dynamic.DataProviderUtil;
import com.sas.prompts.valueprovider.dynamic.iq.BaseRelationalDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.RB;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.valueprovider.AllowUserValuesInterface;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueType;
import com.sas.util.ListFactory;
import com.sas.util.ValueItem;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class IQRelationalDataItemValueProvider
extends BaseRelationalDataItemValueProvider
implements AllowUserValuesInterface {
    private static final long serialVersionUID = -5076728818745256045L;
    private Governing governing;
    private boolean honorFilters;
    private boolean ignoreFormattingForced;
    private int dataToReturn;
    private boolean unwrapValues;
    private int exceptionFlag = 1;

    public IQRelationalDataItemValueProvider() {
        this(null, null, true, false, 3);
    }

    public IQRelationalDataItemValueProvider(DataItem dataItem) {
        this(dataItem, null, true, false, 3);
    }

    public IQRelationalDataItemValueProvider(DataItem valueDataItem, Governing governing, boolean honorFilters, boolean ignoreFormattingForced, int dataToReturn) {
        this(valueDataItem, governing, honorFilters, ignoreFormattingForced, dataToReturn, false);
    }

    public IQRelationalDataItemValueProvider(DataItem valueDataItem, Governing governing, boolean honorFilters, boolean ignoreFormattingForced, int dataToReturn, boolean unwrapValues) {
        this.setDataItem(valueDataItem);
        this.dataType = null;
        this.governing = governing;
        this.honorFilters = honorFilters;
        this.ignoreFormattingForced = ignoreFormattingForced;
        this.dataToReturn = dataToReturn;
        this.unwrapValues = unwrapValues;
        this.setThreshold(DataProviderUtil.DEFAULT_RELATIONAL_THRESHOLD);
    }

    public boolean getHonorFilters() {
        return this.honorFilters;
    }

    public void setHonorFilters(boolean honorFilters) {
        this.honorFilters = honorFilters;
    }

    public void setIgnoreFormattingForced(boolean ignoreFormattingForced) {
        this.ignoreFormattingForced = ignoreFormattingForced;
    }

    public boolean getIgnoreFormattingForced() {
        return this.ignoreFormattingForced;
    }

    public void setDataToReturn(int dataToReturn) {
        this.dataToReturn = dataToReturn;
    }

    public int getDataToReturn() {
        return this.dataToReturn;
    }

    public boolean isUnwrapValues() {
        return this.unwrapValues;
    }

    public void setUnwrapValues(boolean unwrapValues) {
        this.unwrapValues = unwrapValues;
    }

    @Override
    public boolean isSearchable(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        DataItem di;
        if (this.getHonorFilters() && (di = this.getDataItemFromID()) != null && di.getLookupType() instanceof LookupByDataItem) {
            return super.isSearchable(locale, dynamicPromptValueContext);
        }
        return false;
    }

    @Override
    public boolean isSearchable() throws ValueProviderException {
        DataItem di;
        if (this.getHonorFilters() && (di = this.getDataItemFromID()) != null && di.getLookupType() instanceof LookupByDataItem) {
            return super.isSearchable();
        }
        return false;
    }

    public boolean isAllowUserValues() {
        return this.getDataItem() != null && this.getDataItem().getLookupType() instanceof LookupNotAllowed;
    }

    @Override
    public void setDataItem(DataItem di) {
        super.setDataItem(di);
        this.governing = null;
    }

    @Override
    public Collection getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) {
        LinkedList dependentPrompts = new LinkedList();
        if (this.honorFilters) {
            try {
                this.allFilterList = new ArrayList();
                this.addBusinessQueryPrompts(dependentPrompts, dynamicPromptValueContext);
            }
            catch (ServerConnectionException serverConnectionException) {
                // empty catch block
            }
        }
        return dependentPrompts;
    }

    private void addBusinessQueryPrompts(List dependentPrompts, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ServerConnectionException {
        if (this.getDataItem() == null) {
            return;
        }
        BusinessModel businessModel = this.getDataItem().getBusinessModel();
        if (businessModel instanceof BusinessQuery) {
            BusinessQuery parentQuery = ((BusinessQuery)businessModel).getParentQuery();
            List parentFilters = parentQuery.getEffectiveFilters();
            this.addFilterPrompts(parentFilters, dynamicPromptValueContext);
        }
    }

    @Override
    protected boolean isFormattedSearch() {
        boolean isFormattedSearch = false;
        if (this.dataToReturn == 3 || this.dataToReturn == 1) {
            isFormattedSearch = true;
        }
        return isFormattedSearch;
    }

    @Override
    protected Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, returnType, searchCriteria, index, count);
    }

    @Override
    protected Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        if (returnType == ValueType.LIST || returnType == ValueType.TREETHENLIST) {
            return this.getValuesAsList(locale, dynamicPromptValueContext, searchCriteria, index, count);
        }
        throw new ValueProviderException(RB.getStringResource("IQRelationalDataItemValueProvider.invalidReturnTypeError.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValuesAsList(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        Object[] searchResults = EMPTY_VALUEITEM_ARRAY;
        DataSelection dataSelection = null;
        try {
            dataSelection = DataSelectionFactory.newDataSelection((BusinessModel)this.getDataItemFromID().getBusinessModel());
            DataItem di = this.createQueryItem(dataSelection, searchCriteria);
            searchResults = this.getValuesFromServer(locale, di, index, count);
        }
        finally {
            if (dataSelection != null) {
                dataSelection.dispose();
                dataSelection = null;
            }
        }
        return Arrays.asList(searchResults);
    }

    private DataItem createQueryItem(DataSelection dataSelection, SearchCriteria searchCriteria) throws ValueProviderException {
        try {
            ArrayList<FilterItem> effectiveFilters = new ArrayList<FilterItem>(2);
            DataItem di = this.getDataItemFromID();
            if (this.getHonorFilters()) {
                if (searchCriteria != null) {
                    FilterItem searchFilter = this.buildSearchFilter(dataSelection, searchCriteria);
                    dataSelection.addBusinessItem((BusinessItem)searchFilter);
                    effectiveFilters.add(searchFilter);
                    di = dataSelection.newDataItemReference(di);
                    dataSelection.addBusinessItem((BusinessItem)di);
                }
                if (!effectiveFilters.isEmpty()) {
                    dataSelection.setFilters(effectiveFilters);
                }
            } else {
                di = dataSelection.newDataItemReference(di);
                dataSelection.addBusinessItem((BusinessItem)di);
            }
            return di;
        }
        catch (MetadataException e) {
            ValueProviderException vpe = new ValueProviderException(this.getReasonsMessage(e.getReasons()));
            vpe.initCause((Throwable)e);
            throw vpe;
        }
    }

    protected Object[] getValuesFromServer(Locale locale, DataItem dataItem, int startKey, int count) throws ValueProviderException {
        try {
            DataItem di = dataItem;
            if (!di.isUsableInQuery()) {
                throw new ValueProviderException(this.getReasonsMessage(di.getReasonsUnusable()));
            }
            IQDataServices iqDataServices = IQDataServicesFactory.newService();
            if (this.governing == null) {
                this.governing = di.getBusinessModel().newGoverning();
            }
            this.governing.setOutputObservations(count > 0 ? startKey + count : count);
            List l = iqDataServices.getPossibleFilterValues(di, this.governing, this.honorFilters, this.ignoreFormattingForced, this.dataToReturn);
            int size = l.size();
            int numRowsToReturn = count > 0 ? Math.min(size, count) : size;
            int returnSize = Math.abs(numRowsToReturn - startKey);
            List returnList = ListFactory.newList((int)returnSize);
            for (int i = startKey; i < startKey + returnSize; ++i) {
                PossibleFilterValue pf = (PossibleFilterValue)l.get(i);
                String label = pf.getFormatted();
                Object unformattedValue = pf.getUnformatted();
                boolean wasNull = false;
                MissingValues mv = null;
                if (this.isUnwrapValues() && unformattedValue instanceof ConstantExpression && ((ConstantExpression)unformattedValue).isMissing()) {
                    wasNull = true;
                    mv = MissingValues.get((String)((ConstantExpressionInterface)unformattedValue).getValue());
                }
                if (wasNull) {
                    label = MissingValues.toDisplayString(mv, (Locale)locale);
                }
                if (this.isUnwrapValues()) {
                    if (wasNull) {
                        unformattedValue = mv;
                    } else if (unformattedValue instanceof ConstantExpressionInterface) {
                        unformattedValue = ((ConstantExpressionInterface)unformattedValue).getValue();
                    } else if (unformattedValue instanceof AbstractTimeValueExpression) {
                        unformattedValue = ((AbstractTimeValueExpression)unformattedValue).getValue();
                    } else if (unformattedValue instanceof StringExpression) {
                        unformattedValue = ((StringExpression)unformattedValue).getText();
                    }
                }
                if (this.isTrimLabels() && label != null) {
                    label = label.trim();
                }
                if (unformattedValue instanceof String && this.isTrimValues()) {
                    unformattedValue = ((String)unformattedValue).trim();
                }
                returnList.add(new ValueItem((Object)label, unformattedValue));
            }
            return returnList.toArray(EMPTY_VALUEITEM_ARRAY);
        }
        catch (DataServicesException de) {
            throw new ValueProviderException((Throwable)de, de.getDetailMessage(locale, this.exceptionFlag));
        }
        catch (MetadataException de) {
            throw new ValueProviderException((Throwable)de, de.getDetailMessage(locale, this.exceptionFlag));
        }
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setIgnoreFormattingForced(provider.consumeBooleanAttr("ignoreFormattingForced", false));
        this.setHonorFilters(provider.consumeBooleanAttr("honorFitlers", false));
        this.setDataToReturn(provider.consumeIntAttr("dataToReturn", 3));
        this.setUnwrapValues(provider.consumeBooleanAttr("unwrapValues", false));
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setBooleanAttr((Element)element, (String)"ignoreFormattingForced", (boolean)this.getIgnoreFormattingForced(), (boolean)false);
        XmlUtil.setBooleanAttr((Element)element, (String)"honorFitlers", (boolean)this.getHonorFilters(), (boolean)false);
        XmlUtil.setIntAttr((Element)element, (String)"dataToReturn", (int)this.getDataToReturn(), (int)3);
        XmlUtil.setBooleanAttr((Element)element, (String)"unwrapValues", (boolean)this.isUnwrapValues(), (boolean)false);
    }

    public String getDefinitionElementName() {
        return "IQRelationalDataItemValueProvider";
    }
}

