/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.valueprovider.dynamic.iq;

import com.sas.beans.PropertyChangeSource;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DateRangeType;
import com.sas.datatypes.DateType;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.StringType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.relational.DataItemFormattingExpression;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Contains;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Like;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.FindPromptValuesByPromptDefinitionIDVisitor;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptValuesVisitorInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.valueprovider.dynamic.iq.DataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.RB;
import com.sas.storage.simplesqlmodel.ColumnInfo;
import com.sas.storage.valueprovider.AllowUserValuesInterface;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.util.Strings;
import com.sas.util.ValueItem;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

public abstract class BaseRelationalDataItemValueProvider
extends DataItemValueProvider
implements AllowUserValuesInterface,
PropertyChangeSource {
    protected static final Object[] EMPTY_VALUEITEM_ARRAY = new ValueItem[0];
    protected static int MAX_CACHE_SIZE = DEFAULT_THRESHOLD * 10;
    private boolean trimLabels;
    private boolean trimValues;
    protected DataTypeInterface labelDataType;
    protected boolean formattedValues;
    protected PropertyChangeSupport propertyChangeSupport;
    protected ExpressionInterface valueItemExpression;

    public BaseRelationalDataItemValueProvider() {
        this(null);
    }

    public BaseRelationalDataItemValueProvider(DataItem dataItem) {
        this.setDataItem(dataItem);
        this.dataType = null;
        this.trimLabels = false;
        this.trimValues = false;
        this.propertyChangeSupport = new PropertyChangeSupport((Object)this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setTrimLabels(boolean trimLabels) {
        this.trimLabels = trimLabels;
    }

    public boolean isTrimLabels() {
        return this.trimLabels;
    }

    public void setTrimValues(boolean trimValues) {
        this.trimValues = trimValues;
    }

    public boolean isTrimValues() {
        return this.trimValues;
    }

    public void setQualifyLabelWithValue(boolean qualifyLabelWithValue) {
        this.setValueDisplayed(qualifyLabelWithValue);
    }

    public boolean isQualifyLabelWithValue() {
        return this.isValueDisplayed();
    }

    public boolean isSearchable() throws ValueProviderException {
        DataItem searchItem = this.getSearchItem(null);
        if (searchItem != null) {
            this.labelDataType = this.convertExpressionTypeToDataType(searchItem);
            return this.labelDataType instanceof StringType;
        }
        if (this.valueItemExpression != null) {
            return this.valueItemExpression.getExpressionType() == 3;
        }
        return false;
    }

    public boolean isSearchable(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        return this.isSearchable();
    }

    public DataTypeInterface getDataType() throws ValueProviderException {
        if (this.formattedValues) {
            return StringType.DEFAULT_INSTANCE;
        }
        DataItem valueDataItem = this.getDataItem();
        if (valueDataItem == null && this.valueItemExpression == null) {
            throw new ValueProviderException(RB.getStringResource("BaseRelationalDataItemValueProvider.DataItemNotSetError.txt"));
        }
        if (this.dataType == null) {
            if (this.valueItemExpression != null) {
                this.dataType = this.dataTypeForExpression(this.valueItemExpression.getExpressionType());
            } else if (valueDataItem != null) {
                this.dataType = this.convertExpressionTypeToDataType(valueDataItem);
            }
        }
        return this.dataType;
    }

    public DataTypeInterface getDataType(DynamicPromptValueContextInterface dynamicContext) throws ValueProviderException {
        return this.getDataType();
    }

    protected DataTypeInterface convertExpressionTypeToDataType(DataItem dataItem) {
        int expType = dataItem.getExpressionTypeIgnoringFormattingForced();
        DataTypeInterface dt = this.dataTypeForExpression(expType);
        return dt;
    }

    private DataTypeInterface dataTypeForExpression(int expType) {
        DoubleType dt;
        switch (expType) {
            case 2: {
                dt = DoubleType.DEFAULT_INSTANCE;
                break;
            }
            case 3: {
                dt = StringType.DEFAULT_INSTANCE;
                break;
            }
            case 9: {
                dt = StringType.DEFAULT_INSTANCE;
                break;
            }
            case 4: {
                dt = DateType.DEFAULT_INSTANCE;
                break;
            }
            case 5: {
                dt = TimeType.DEFAULT_INSTANCE;
                break;
            }
            case 6: {
                dt = TimeStampType.DEFAULT_INSTANCE;
                break;
            }
            case 8: {
                dt = DateRangeType.DEFAULT_INSTANCE_DATE;
                break;
            }
            case 7: {
                dt = DateRangeType.DEFAULT_INSTANCE_YEAR;
                break;
            }
            default: {
                dt = StringType.DEFAULT_INSTANCE;
            }
        }
        return dt;
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setTrimLabels(provider.consumeBooleanAttr("trimLabels", false));
        this.setTrimValues(provider.consumeBooleanAttr("trimValues", false));
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setBooleanAttr((Element)element, (String)"trimLabels", (boolean)this.isTrimLabels(), (boolean)false);
        XmlUtil.setBooleanAttr((Element)element, (String)"trimValues", (boolean)this.isTrimValues(), (boolean)false);
    }

    protected boolean isAllDependentPromptValuesSet(DynamicPromptValueContextInterface dynamicPromptValueContext, Locale locale, Map defintionValueMap) throws ValueProviderException {
        if (this.dependentPrompts == null || this.dependentPrompts.isEmpty()) {
            return true;
        }
        if (dynamicPromptValueContext == null) {
            return false;
        }
        try {
            PromptValuesInterface promptValues = dynamicPromptValueContext.getPromptValues();
            if (promptValues != null) {
                Iterator iter = this.dependentPrompts.iterator();
                while (iter.hasNext()) {
                    if (promptValues == null) {
                        return false;
                    }
                    Object obj = iter.next();
                    PromptDefinitionInterface dependentPrompt = null;
                    dependentPrompt = obj instanceof String ? promptValues.getPromptDefinition((String)obj, true) : (obj instanceof Prompt ? ((Prompt)obj).getPromptDefinition() : (PromptDefinitionInterface)obj);
                    Object promptValue = null;
                    if (promptValues.isPromptValueAvailable(dependentPrompt)) {
                        promptValue = promptValues.getPromptValue(dependentPrompt);
                    } else {
                        FindPromptValuesByPromptDefinitionIDVisitor visitor = new FindPromptValuesByPromptDefinitionIDVisitor(dependentPrompt.getPromptID());
                        promptValues.acceptPromptValuesVisitor((PromptValuesVisitorInterface)visitor);
                        PromptDefinitionInterface pd = visitor.getPromptDefinition();
                        if (pd != null) {
                            promptValue = promptValues.getPromptValue(pd);
                        }
                    }
                    if (defintionValueMap == null || promptValue == null) continue;
                    defintionValueMap.put(dependentPrompt, promptValue);
                }
                return true;
            }
        }
        catch (PromptValueNotFoundException pe) {
            return false;
        }
        return false;
    }

    protected static boolean isEmpty(StringBuffer s) {
        return s == null || s.length() == 0;
    }

    protected static boolean isFormatEmpty(String s) {
        int index;
        if (s != null && s.length() > 0 && (index = s.indexOf(ColumnInfo.DEFAULT_FORMAT)) >= 0) {
            s = s.length() > ColumnInfo.DEFAULT_FORMAT.length() ? s.substring(ColumnInfo.DEFAULT_FORMAT.length() + 1, s.length()) : null;
        }
        return BaseRelationalDataItemValueProvider.isEmpty(s);
    }

    protected static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    protected FilterItem buildSearchFilter(DataSelection searchQuery, SearchCriteria searchCriteria) throws ValueProviderException {
        FilterItem searchFilter = null;
        Object operator = searchCriteria.getOperator();
        if (this._isContainsSearch(searchCriteria)) {
            searchFilter = this._buildContainsSearchFilter(searchQuery, searchCriteria);
        } else if (this._isEqualsSearch(searchCriteria)) {
            searchFilter = this._buildEqualsSearchFilter(searchQuery, searchCriteria);
        } else if (SearchCriteria.OPERATOR_STARTS_WITH.equals(operator)) {
            searchFilter = this._buildStartsWithSearchFilter(searchQuery, searchCriteria);
        } else if (SearchCriteria.OPERATOR_ENDS_WITH.equals(operator)) {
            searchFilter = this._buildEndsWithSearchFilter(searchQuery, searchCriteria);
        } else if (SearchCriteria.OPERATOR_MATCH_PATTERN.equals(operator)) {
            searchFilter = this._buildMatchPatternSearchFilter(searchQuery, searchCriteria);
        }
        return searchFilter;
    }

    private boolean _isContainsSearch(SearchCriteria searchCriteria) {
        Object operator = searchCriteria.getOperator();
        return SearchCriteria.OPERATOR_CONTAINS.equals(operator) || SearchCriteria.OPERATOR_NOT_CONTAINS.equals(operator);
    }

    private boolean _isEqualsSearch(SearchCriteria searchCriteria) {
        Object operator = searchCriteria.getOperator();
        return SearchCriteria.OPERATOR_EQUAL.equals(operator) || SearchCriteria.OPERATOR_NOT_EQUAL.equals(operator);
    }

    private FilterItem _buildEqualsSearchFilter(DataSelection searchQuery, SearchCriteria searchCriteria) throws ValueProviderException {
        Object operator = searchCriteria.getOperator();
        boolean isNegated = SearchCriteria.OPERATOR_NOT_EQUAL.equals(operator);
        return this.buildEqualsSearchFilter(searchQuery, searchCriteria, isNegated);
    }

    protected DataItem getSearchItem(DataSelection dataselection) throws ValueProviderException {
        return this.getDataItem();
    }

    protected boolean isFormattedSearch() {
        return false;
    }

    private FilterItem buildEqualsSearchFilter(DataSelection searchQuery, SearchCriteria searchCriteria, boolean isNegated) throws ValueProviderException {
        try {
            DataItem searchItem = this.getSearchItem(searchQuery);
            BusinessModel searchBusinessModel = searchQuery.getBusinessModel();
            DataItemFormattingExpression diFormatRep = new DataItemFormattingExpression();
            diFormatRep.setDataItem(searchItem);
            diFormatRep.setIsFormatted(this.isFormattedSearch());
            diFormatRep.setIsCharacterFormattedWhenNoFormat(false);
            DataItemFormattingExpression whatToCompare = diFormatRep;
            String textToMatch = searchCriteria.getTextToMatch();
            if (!searchCriteria.isCaseSensitiveSearch()) {
                Function function = searchBusinessModel.getServerProperties().getFunctionByNameID(FunctionNameID.UPCASE);
                if (function == null) {
                    throw new ValueProviderException(RB.getStringResource("RelationalDataItemValueProvider.CaseSensitiveSearchNotSupportedError.txt"));
                }
                whatToCompare = new FunctionCall(function, new ExpressionInterface[]{whatToCompare});
                Locale queryLocale = searchBusinessModel.getDataLocale();
                textToMatch = textToMatch.toUpperCase(queryLocale);
            }
            ConstantExpression valueExpression = new ConstantExpression();
            valueExpression.setExpressionType(3);
            valueExpression.setValue(textToMatch);
            SimpleConditionalExpression_Comparison equalsExpression = new SimpleConditionalExpression_Comparison();
            equalsExpression.setLeftExpression((ExpressionInterface)whatToCompare);
            equalsExpression.setRightExpression((ExpressionInterface)valueExpression);
            equalsExpression.setComparisonOperator(ComparisonOperator.COMPARE_EQ);
            FilterItem searchFilter = searchQuery.newFilterItem();
            searchFilter.setExpression((ExpressionInterface)equalsExpression);
            return searchFilter;
        }
        catch (MetadataException mExc) {
            throw new ValueProviderException((Throwable)mExc, mExc.getMessage());
        }
    }

    private FilterItem _buildContainsSearchFilter(DataSelection searchQuery, SearchCriteria searchCriteria) throws ValueProviderException {
        try {
            DataItem searchItem = this.getSearchItem(searchQuery);
            BusinessModel businessModel = searchQuery.getBusinessModel();
            DataItemFormattingExpression diFormatRep = new DataItemFormattingExpression();
            diFormatRep.setDataItem(searchItem);
            diFormatRep.setIsFormatted(this.isFormattedSearch());
            diFormatRep.setIsCharacterFormattedWhenNoFormat(false);
            DataItemFormattingExpression whatToCompare = diFormatRep;
            String textToMatch = searchCriteria.getTextToMatch();
            if (!searchCriteria.isCaseSensitiveSearch()) {
                Function function = businessModel.getServerProperties().getFunctionByNameID(FunctionNameID.UPCASE);
                if (function == null) {
                    throw new ValueProviderException(RB.getStringResource("RelationalDataItemValueProvider.CaseSensitiveSearchNotSupportedError.txt"));
                }
                whatToCompare = new FunctionCall(function, new ExpressionInterface[]{whatToCompare});
                Locale queryLocale = businessModel.getDataLocale();
                textToMatch = textToMatch.toUpperCase(queryLocale);
            }
            ConstantExpression valueExpression = new ConstantExpression();
            valueExpression.setExpressionType(3);
            valueExpression.setValue(textToMatch);
            SimpleConditionalExpression_Contains containsExpression = new SimpleConditionalExpression_Contains(businessModel);
            containsExpression.setWhatToCompare((ExpressionInterface)whatToCompare);
            containsExpression.setWhatToContain((ExpressionInterface)valueExpression);
            FilterItem searchFilter = businessModel.newFilterItem();
            searchFilter.setExpression((ExpressionInterface)containsExpression);
            return searchFilter;
        }
        catch (MetadataException mExc) {
            throw new ValueProviderException((Throwable)mExc, mExc.getMessage());
        }
    }

    private FilterItem _buildStartsWithSearchFilter(DataSelection searchQuery, SearchCriteria searchCriteria) throws ValueProviderException {
        return this._buildLikeFilter(searchQuery, searchCriteria);
    }

    private FilterItem _buildEndsWithSearchFilter(DataSelection searchQuery, SearchCriteria searchCriteria) throws ValueProviderException {
        return this._buildLikeFilter(searchQuery, searchCriteria);
    }

    private FilterItem _buildMatchPatternSearchFilter(DataSelection searchQuery, SearchCriteria searchCriteria) throws ValueProviderException {
        return this._buildLikeFilter(searchQuery, searchCriteria);
    }

    private FilterItem _buildLikeFilter(DataSelection searchQuery, SearchCriteria searchCriteria) throws ValueProviderException {
        try {
            DataItem searchItem = this.getSearchItem(searchQuery);
            Object operator = searchCriteria.getOperator();
            DataItemFormattingExpression diFormatRep = new DataItemFormattingExpression();
            diFormatRep.setDataItem(searchItem);
            diFormatRep.setIsFormatted(this.isFormattedSearch());
            diFormatRep.setIsCharacterFormattedWhenNoFormat(false);
            DataItemFormattingExpression whatToCompare = diFormatRep;
            String text = searchCriteria.getTextToMatch();
            if (text != null) {
                BusinessModel bm = searchQuery.getBusinessModel();
                Function function = bm.getServerProperties().getFunctionByNameID(FunctionNameID.TRIM);
                if (function != null) {
                    whatToCompare = new FunctionCall(function, new ExpressionInterface[]{whatToCompare});
                }
                if (!searchCriteria.isCaseSensitiveSearch()) {
                    function = bm.getServerProperties().getFunctionByNameID(FunctionNameID.UPCASE);
                    if (function == null) {
                        throw new ValueProviderException(RB.getStringResource("RelationalDataItemValueProvider.CaseSensitiveSearchNotSupportedError.txt"));
                    }
                    whatToCompare = new FunctionCall(function, new ExpressionInterface[]{whatToCompare});
                    Locale queryLocale = bm.getDataLocale();
                    text = text.toUpperCase(queryLocale);
                }
                StringBuffer textToMatch = new StringBuffer(text);
                String likeIndicator = "%";
                String singleCharacterMatch = "_";
                if (SearchCriteria.OPERATOR_STARTS_WITH.equals(operator)) {
                    textToMatch.append("%");
                } else if (SearchCriteria.OPERATOR_ENDS_WITH.equals(operator)) {
                    textToMatch.insert(0, "%");
                } else if (SearchCriteria.OPERATOR_MATCH_PATTERN.equals(operator)) {
                    textToMatch = Strings.replace((StringBuffer)textToMatch, (String)"*", (String)"%");
                    textToMatch = Strings.replace((StringBuffer)textToMatch, (String)"?", (String)"_");
                }
                ConstantExpression valueExpression = new ConstantExpression();
                valueExpression.setExpressionType(3);
                valueExpression.setValue(textToMatch.toString());
                SimpleConditionalExpression_Like likeExpression = new SimpleConditionalExpression_Like();
                likeExpression.setWhatToCompare((ExpressionInterface)whatToCompare);
                likeExpression.setPatternExpression((ExpressionInterface)valueExpression);
                likeExpression.setIsNegated(false);
                FilterItem searchFilter = searchQuery.newFilterItem();
                searchFilter.setExpression((ExpressionInterface)likeExpression);
                return searchFilter;
            }
        }
        catch (MetadataException mExc) {
            throw new ValueProviderException((Throwable)mExc, mExc.getMessage());
        }
        return null;
    }

    public void setFormattedValues(boolean isFormatted) {
        this.formattedValues = isFormatted;
    }

    public boolean isFormattedValues() {
        return this.formattedValues;
    }

    protected String getReasonsMessage(List reasons) {
        StringBuffer reasonsText = new StringBuffer();
        for (int i = 0; i < reasons.size(); ++i) {
            Reason reason = (Reason)reasons.get(i);
            if (reasonsText.length() > 0) {
                reasonsText.append("\n");
            }
            reasonsText.append(reason.toString());
        }
        return reasonsText.toString();
    }
}

