/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.valueprovider.dynamic;

import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.IHostSystem;
import com.sas.iom.SAS.IHostSystemPackage.SoftwareInfoIndex;
import com.sas.iom.SAS.IUtilities;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iom.SASMDX.IMDXServerHelper;
import com.sas.iom.SASMDX.ISession;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.execution.OLAPConnectionResource;
import com.sas.iquery.metadata.IntelligentQueryMetadataService;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelReferenceInfo;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IOMIHelper;
import com.sas.metadata.remote.CredentialResolver;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdLibGenInterface;
import com.sas.metadata.remote.MdModelUtil;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.SASLibrary;
import com.sas.models.SequentialCache;
import com.sas.models.datasources.BaseDataSource;
import com.sas.models.datasources.BaseDataSourceColumn;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.ViewQueryCacheInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.valueprovider.dynamic.DataProviderUtil;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.valueprovider.dynamic.RB;
import com.sas.prompts.valueprovider.dynamic.iq.InfoMapItemsValueProvider;
import com.sas.rio.MVAConnection;
import com.sas.services.ServiceException;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.Server;
import com.sas.services.connection.omr.OMRConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.information.DAVRepositoryInterface;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.metadata.ColumnAttributes;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.DataTableInterface;
import com.sas.services.information.metadata.LogicalServerFilter;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRServerContext;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.services.information.metadata.SASLibraryInterface;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.services.information.metadata.prompt.UserContextEnabledObject;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContext;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.iquery.IQUeryUtil;
import com.sas.storage.iquery.InformationMapMetaData;
import com.sas.storage.jdbc.JDBCConnection;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.swing.models.ValueProviderModelAdapter;
import com.sas.text.SASFormat;
import com.sas.util.FileValidatorInterface;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.ValidateArg;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.xmlpersist.impl.PersistHelper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

public class DataProvider
implements PromptDataProviderInterface,
UserContextEnabledObject,
Serializable,
ViewQueryCacheInterface {
    static final long serialVersionUID = 6731865367132377253L;
    public static final String RB_KEY = "DataProvider.";
    private static String HFS_FILESYSTEM_OPTION = "OPTIONS FILESYSTEM=HFS;";
    private transient ServerInterface metadataServer = null;
    private transient CommonLoggerInterface logger = null;
    private Locale locale;
    private transient UserContextInterface userContext;
    private String repositoryID;
    private transient String omrHost;
    private transient int omrPort;
    private transient String omrUserName;
    private transient String omrPassword;
    transient ConnectionInterface omrConnection;
    private transient JDBCConnection jdbcConnection;
    private Map thresholdMap;
    private transient FSConnectionMap fsConnectionMap;
    private transient NonFSConnectionMap nonfsConnectionMap;
    private transient List serverList;
    private transient Map urlToDataSourceMap = new HashMap();
    private transient Map iqToMetadataMap = new HashMap();
    private transient Map libraryToServerMap = new HashMap();
    private transient Map adapterToCacheMap = new HashMap();
    private transient List sqlConnectionsList;
    private static final String TABLE_TEMPLATE = "<Templates> <RelationalSchema><DeployedComponents/></RelationalSchema> <PhysicalTable><TablePackage/></PhysicalTable> <ServerContext><UsingComponents/></ServerContext> <SASLibrary><DeployedComponents/></SASLibrary></Templates>";

    public DataProvider() {
        this.setThresholdMap(null);
        this.initURLToDataSourceMap();
    }

    public DataProvider(String userName, String password) {
        this.omrUserName = userName;
        try {
            this.omrPassword = SasPasswordString.encode((String)"sas001", (String)password);
        }
        catch (SasPasswordEncodingException spe) {
            this.omrPassword = password;
        }
        this.initURLToDataSourceMap();
    }

    public DataProvider(UserContextInterface userContext) {
        this.setUserContext(userContext);
        this.setThresholdMap(null);
        this.initURLToDataSourceMap();
    }

    public DataProvider(String omr_host, int omr_port, String omr_userName, String omr_password) {
        this.omrHost = omr_host;
        this.omrPort = omr_port;
        this.omrUserName = omr_userName;
        try {
            this.omrPassword = SasPasswordString.encode((String)"sas001", (String)omr_password);
        }
        catch (SasPasswordEncodingException spe) {
            this.omrPassword = omr_password;
        }
    }

    public void addViewCache(java.lang.Object viewOrAdapter, SequentialCache cache) {
        if (this.adapterToCacheMap == null) {
            this.adapterToCacheMap = new HashMap();
        }
        this.adapterToCacheMap.put(viewOrAdapter, cache);
    }

    public SequentialCache getViewCache(java.lang.Object viewOrAdapter) {
        SequentialCache cache = null;
        if (this.adapterToCacheMap.containsKey(viewOrAdapter)) {
            cache = (SequentialCache)this.adapterToCacheMap.get(viewOrAdapter);
        }
        return cache;
    }

    private void initURLToDataSourceMap() {
        if (this.urlToDataSourceMap == null) {
            this.urlToDataSourceMap = new HashMap();
        }
    }

    public void addDataSourceToCache(String url, java.lang.Object dataSource) {
        InformationMap infoMap;
        BusinessModelReferenceInfo refInfo;
        this.initURLToDataSourceMap();
        this.urlToDataSourceMap.put(url, dataSource);
        if ((UNTITLED_OLAP_INFORMATION_MAP.getDataSourceLocation().equals(url) || UNTITLED_RELATIONAL_INFORMATION_MAP.getDataSourceLocation().equals(url)) && dataSource instanceof InformationMap && (refInfo = (infoMap = (InformationMap)dataSource).getReferenceInfo()) != null && refInfo.getPersistentLocation() != null && refInfo.getPersistentLocation().trim().length() > 0) {
            this.urlToDataSourceMap.put(PersistHelper.parseSBIPUrl((String)refInfo.getPersistentLocation()), dataSource);
        }
    }

    java.lang.Object getDataSourceFromCache(String url) throws ServiceException, RemoteException, ServerConnectionException {
        java.lang.Object retVal = null;
        if (this.urlToDataSourceMap != null && (retVal = this.urlToDataSourceMap.get(url)) instanceof MetadataInterface && ((MetadataInterface)retVal).getState() > 2) {
            String msg = MessageFormat.format(RB.getStringResource("DataProvider.invalidDataSource.fmt"), url);
            throw new ServerConnectionException(msg);
        }
        return retVal;
    }

    public void removeDataSourceFromCache(String url) {
        if (this.urlToDataSourceMap != null) {
            this.urlToDataSourceMap.remove(url);
        }
    }

    public void clearDataSourceCache() {
        if (this.urlToDataSourceMap != null) {
            this.urlToDataSourceMap.clear();
        }
        this.initURLToDataSourceMap();
    }

    public ValueProviderInterface getValueProvider(ValueProviderInterface valueProvider) {
        return valueProvider;
    }

    public void setRepositoryID(String repositoryID) {
        this.repositoryID = repositoryID;
    }

    public CommonLoggerInterface getLogger(UserContextInterface userContext1) {
        if (null == this.logger) {
            this.logger = LoggerRepository2.getLogger((String)this.getClass().getName(), null);
        }
        return this.logger;
    }

    public CommonLoggerInterface getLogger() {
        return this.getLogger(this.userContext);
    }

    public void setThresholdMap(Map userMap) {
        this.initThresholdMap(userMap);
    }

    public Map getThresholdMap() {
        if (this.thresholdMap == null) {
            this.initThresholdMap(null);
        }
        return this.thresholdMap;
    }

    private void initThresholdMap(Map userMap) {
        if (this.thresholdMap == null) {
            this.thresholdMap = new HashMap();
        }
        Integer olapThreshold = DataProviderUtil.DEFAULT_OLAP_THRESHOLD;
        Integer relationalThreshold = DataProviderUtil.DEFAULT_RELATIONAL_THRESHOLD;
        Integer staticThreshold = DataProviderUtil.DEFAULT_STATIC_THRESHOLD;
        if (userMap != null) {
            if (userMap.containsKey(DataProviderUtil.OLAP_LIST_THRESHOLD)) {
                olapThreshold = (Integer)userMap.get(DataProviderUtil.OLAP_LIST_THRESHOLD);
                this.thresholdMap.put(DataProviderUtil.OLAP_LIST_THRESHOLD, olapThreshold);
            }
            if (userMap.containsKey(DataProviderUtil.RELATIONAL_LIST_THRESHOLD)) {
                relationalThreshold = (Integer)userMap.get(DataProviderUtil.RELATIONAL_LIST_THRESHOLD);
                this.thresholdMap.put(DataProviderUtil.RELATIONAL_LIST_THRESHOLD, relationalThreshold);
            }
            if (userMap.containsKey(DataProviderUtil.STATIC_LIST_THRESHOLD)) {
                staticThreshold = (Integer)userMap.get(DataProviderUtil.STATIC_LIST_THRESHOLD);
            }
        }
        this.thresholdMap.put("STATIC_LIST_THRESHOLD", staticThreshold);
    }

    private void establishOMRConnection() throws ServerConnectionException {
        if (this.omrConnection == null) {
            this.nonfsConnectionMap = new NonFSConnectionMap();
            try {
                if (this.omrUserName == null || this.omrPassword == null || this.omrHost == null || this.omrPort == 0) {
                    throw new ServerConnectionException(RB.getStringResource("invalidHostError.txt"));
                }
                String classID = "0217e202-b560-11db-ad91-001083ff6836";
                BridgeServer omrServer = new BridgeServer(classID, this.omrHost, this.omrPort);
                ManualConnectionFactoryConfiguration cxfConfig_omr = new ManualConnectionFactoryConfiguration((Server)omrServer);
                ConnectionFactoryManager cxfManager = new ConnectionFactoryManager();
                ConnectionFactoryInterface cxf_omr = cxfManager.getFactory((ConnectionFactoryConfiguration)cxfConfig_omr);
                this.omrConnection = cxf_omr.getConnection(this.omrUserName, this.omrPassword);
                if (this.repositoryID == null) {
                    this.setDefaultRepository(this.omrConnection);
                }
                this.nonfsConnectionMap.addConnection(this.omrConnection, classID, this.omrUserName);
            }
            catch (ConnectionFactoryException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                throw new ServerConnectionException((Throwable)e, e.getMessage());
            }
        }
    }

    public ISession getNonFSOLAPConnection(String logicalServerName, String userName, String password, String domain) throws ServerConnectionException {
        try {
            this.establishOMRConnection();
            java.lang.Object conn = this.nonfsConnectionMap.getConnection(logicalServerName, userName);
            if (conn != null && conn instanceof OLAPConnectionResource) {
                return ((OLAPConnectionResource)conn).getSession();
            }
            Object obj_omr = this.omrConnection.getObject();
            IOMI iOMI = IOMIHelper.narrow((Object)obj_omr);
            ConnectionFactoryManager cxfManager = new ConnectionFactoryManager();
            OMRConnectionFactoryConfiguration cxfConfig = new OMRConnectionFactoryConfiguration(iOMI, this.repositoryID, logicalServerName);
            ConnectionFactoryInterface cxf = cxfManager.getFactory((ConnectionFactoryConfiguration)cxfConfig);
            ConnectionInterface cx = cxf.getConnection(userName, password, domain);
            Object obj = cx.getObject();
            IMDXServer connection = IMDXServerHelper.narrow((Object)obj);
            if (this.locale == null) {
                this.locale = Locale.getDefault();
            }
            ISession isession = connection.CreateSession(this.locale.toString());
            this.nonfsConnectionMap.addConnection(isession, logicalServerName, userName);
            return isession;
        }
        catch (ConnectionFactoryException e) {
            this.getLogger(this.userContext).error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
        catch (GenericError e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
    }

    private void setDefaultRepository(ConnectionInterface omrConnection) {
        Object obj_omr = omrConnection.getObject();
        IOMI iOMI = IOMIHelper.narrow((Object)obj_omr);
        StringHolder Repositories = new StringHolder();
        int Flag = 0;
        String Options = "";
        try {
            iOMI.GetRepositories(Repositories, Flag, Options);
            String reposValue = Repositories.value;
            StringTokenizer tokens = new StringTokenizer(reposValue, " ");
            while (tokens.hasMoreElements()) {
                String token = tokens.nextToken();
                if (token.indexOf("Repository") < 0 || (token = tokens.nextToken()).indexOf("Id") < 0) continue;
                this.repositoryID = token.substring(token.indexOf("\"") + 1, token.lastIndexOf("\""));
                break;
            }
        }
        catch (GenericError e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    public Connection getNonFSWorkspaceConnection(String logicalServerName, String userName, String password, String domain) throws ServerConnectionException {
        try {
            this.establishOMRConnection();
            java.lang.Object conn = this.nonfsConnectionMap.getConnection(logicalServerName, userName);
            if (conn != null && conn instanceof Connection) {
                return (Connection)conn;
            }
            IWorkspace iWorkspace = this.nonfsConnectionMap.getIWorkspace(logicalServerName, userName);
            if (iWorkspace == null) {
                Object obj_omr = this.omrConnection.getObject();
                IOMI iOMI = IOMIHelper.narrow((Object)obj_omr);
                ConnectionFactoryManager cxfManager = new ConnectionFactoryManager();
                OMRConnectionFactoryConfiguration cxfConfig = new OMRConnectionFactoryConfiguration(iOMI, this.repositoryID, logicalServerName);
                ConnectionFactoryInterface cxf = cxfManager.getFactory((ConnectionFactoryConfiguration)cxfConfig);
                ConnectionInterface cx = cxf.getConnection(userName, password, domain);
                Object obj = cx.getObject();
                iWorkspace = IWorkspaceHelper.narrow((Object)obj);
                this.nonfsConnectionMap.addIWorkspace(iWorkspace, logicalServerName, userName);
            }
            Properties connectionProps = new Properties();
            MVAConnection workspaceConnection = new MVAConnection(iWorkspace, connectionProps);
            this.nonfsConnectionMap.addConnection(workspaceConnection, logicalServerName, userName);
            return workspaceConnection;
        }
        catch (ConnectionFactoryException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
        catch (SQLException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
    }

    public synchronized void setUserContext(UserContextInterface userContext) {
        if (!Util.equal((java.lang.Object)this.userContext, (java.lang.Object)userContext)) {
            this.userContext = userContext;
            this.clearDataSourceCache();
            if (userContext != null) {
                try {
                    this.locale = userContext.getLocale();
                    if (null == this.locale) {
                        this.locale = Locale.getDefault();
                    }
                    this.getLogger().debug("Using locale of:", this.locale.toString());
                }
                catch (RemoteException re) {
                    this.locale = Locale.getDefault();
                    this.getLogger(userContext).debug("Using default Locale");
                }
                catch (ServiceException re) {
                    this.locale = Locale.getDefault();
                    this.getLogger(userContext).debug("Using default Locale");
                }
                try {
                    this.setMetadataServer(userContext.getAuthServer());
                }
                catch (ServiceException e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
                catch (RemoteException e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public UserContextInterface getUserContext() {
        return this.userContext;
    }

    @Override
    public boolean isConnected(PromptDefinitionInterface definition) {
        if (definition instanceof ValueProviderDefinitionInterface && ((ValueProviderDefinitionInterface)definition).getValueProvider() instanceof DynamicValueProviderInterface) {
            if (this.userContext != null) {
                try {
                    if (!this.userContext.isDestroyed()) {
                        return true;
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public List getLogicalServers() throws ServerConnectionException {
        try {
            if (this.userContext == null) {
                return Collections.EMPTY_LIST;
            }
            if (this.serverList == null) {
                this.serverList = Collections.synchronizedList(new ArrayList());
                if (this.repositoryID != null) {
                    RepositoryInterface repos = this.userContext.getRepository(this.repositoryID);
                    this.addLogicalServersToList(repos, this.serverList, null);
                } else {
                    List repositories = this.userContext.getRepositories();
                    if (repositories != null) {
                        ArrayList idsAdded = new ArrayList();
                        for (RepositoryInterface repos : repositories) {
                            if (repos instanceof DAVRepositoryInterface) continue;
                            this.addLogicalServersToList(repos, this.serverList, idsAdded);
                        }
                    }
                }
            }
            this.getLogger().debug("getLogicalServers() returns", this.serverList.toString());
            return this.serverList;
        }
        catch (ServiceException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
        catch (RemoteException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
    }

    private void addLogicalServersToList(RepositoryInterface repos, List serverList, List idsAdded) throws ServiceException, RemoteException {
        if (idsAdded == null) {
            idsAdded = new ArrayList<String>();
        }
        if (null != repos) {
            List servers1 = repos.browseSearch((FilterInterface)new LogicalServerFilter());
            this.getLogger().debug("addLogicalServersToList() list is", servers1.toString());
            for (int i = 0; i < servers1.size(); ++i) {
                BrowseMetadata ls = (BrowseMetadata)servers1.get(i);
                String id = ls.getReposId() + "/" + ls.getNativeType();
                this.getLogger().debug("metadata id", id);
                if (idsAdded.contains(id)) continue;
                idsAdded.add(id);
                MetadataInterface metadata = repos.fetch(id);
                if (null != metadata) {
                    this.getLogger().debug("Metadata: " + metadata.getName());
                }
                if (!(metadata instanceof LogicalServerInterface)) continue;
                this.getLogger().debug("Added Logical Server:" + metadata.getName());
                serverList.add(metadata);
            }
        }
    }

    private synchronized java.lang.Object createConnection(LogicalServerInterface logicalServer) throws ServerConnectionException {
        try {
            IWorkspace iWorkspace = null;
            if (this.fsConnectionMap != null) {
                iWorkspace = this.fsConnectionMap.getIWorkspace(logicalServer, this.userContext);
            }
            if (iWorkspace == null) {
                String privilegedUserName = (String)this.userContext.getSessionContext().getAttribute("com.sas.services.connection.platform.privilegedUserNameKey");
                PlatformConnectionFactoryConfiguration config = PlatformConnectionFactoryConfiguration.createFactoryConfiguration((LogicalServerInterface)logicalServer, (SessionContextInterface)this.userContext.getSessionContext());
                PlatformConnectionFactoryInterface factory = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)config);
                ConnectionInterface connection = factory.getConnection(this.userContext);
                if (this.isOLAPServer(logicalServer)) {
                    Object obj = connection.getObject();
                    IMDXServer mdxServer = IMDXServerHelper.narrow((Object)obj);
                    ISession session = mdxServer.CreateSession(this.locale.toString());
                    if (this.fsConnectionMap == null) {
                        this.fsConnectionMap = new FSConnectionMap();
                    }
                    this.fsConnectionMap.addConnection((java.lang.Object)session, logicalServer, this.userContext);
                    return session;
                }
                Object obj = connection.getObject();
                iWorkspace = IWorkspaceHelper.narrow((Object)obj);
                if (this.fsConnectionMap == null) {
                    this.fsConnectionMap = new FSConnectionMap();
                }
                this.fsConnectionMap.addConnectionFactory(connection, logicalServer, this.userContext);
                this.fsConnectionMap.addIWorkspace(iWorkspace, logicalServer, this.userContext);
            }
            Properties connectionProps = new Properties();
            MVAConnection workspaceConnection = new MVAConnection(iWorkspace, connectionProps);
            if (this.sqlConnectionsList == null) {
                this.sqlConnectionsList = Collections.synchronizedList(new ArrayList());
            }
            this.sqlConnectionsList.add(workspaceConnection);
            return workspaceConnection;
        }
        catch (RemoteException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
        catch (SQLException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
        catch (ConnectionFactoryException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
        catch (GenericError e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
        catch (ServiceException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IWorkspace getIWorkspace(String logicalServerName) throws ServerConnectionException {
        IWorkspace iWorkspace = null;
        this.getLogger().debug("The requested logical server name is :", logicalServerName);
        try {
            LogicalServerInterface logicalServer = this.getLogicalServer(logicalServerName);
            if (this.fsConnectionMap == null) {
                this.fsConnectionMap = new FSConnectionMap();
            }
            FSConnectionMap fSConnectionMap = this.fsConnectionMap;
            synchronized (fSConnectionMap) {
                if (logicalServer == null) {
                    throw new ServerConnectionException(MessageFormat.format(RB.getStringResource("DataProvider.noServer.fmt"), logicalServerName));
                }
                if (this.userContext != null && this.fsConnectionMap != null && this.fsConnectionMap.containsKey(logicalServer)) {
                    iWorkspace = this.fsConnectionMap.getIWorkspace(logicalServer, this.userContext);
                }
                if (iWorkspace == null) {
                    PlatformConnectionFactoryConfiguration config = PlatformConnectionFactoryConfiguration.createFactoryConfiguration((LogicalServerInterface)logicalServer, (SessionContextInterface)this.userContext.getSessionContext());
                    PlatformConnectionFactoryInterface factory = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)config);
                    ConnectionInterface connection = null;
                    connection = factory.getConnection(this.userContext);
                    Object obj = connection.getObject();
                    iWorkspace = IWorkspaceHelper.narrow((Object)obj);
                    this.fsConnectionMap.addConnectionFactory(connection, logicalServer, this.userContext);
                    this.fsConnectionMap.addIWorkspace(iWorkspace, logicalServer, this.userContext);
                }
            }
        }
        catch (ConnectionFactoryException re) {
            this.getLogger().error(re.getMessage(), (Throwable)re);
            throw new ServerConnectionException((Throwable)re, re.getMessage());
        }
        catch (RemoteException re) {
            this.getLogger().error(re.getMessage(), (Throwable)re);
            throw new ServerConnectionException((Throwable)re, re.getMessage());
        }
        catch (ServiceException re) {
            this.getLogger().error(re.getMessage(), (Throwable)re);
            throw new ServerConnectionException((Throwable)re, re.getMessage());
        }
        return iWorkspace;
    }

    private synchronized LogicalServerInterface getLogicalServer(String logicalServerName) throws RemoteException, ServerConnectionException {
        if (this.serverList == null) {
            this.serverList = this.getLogicalServers();
        }
        for (LogicalServerInterface server : this.serverList) {
            if (!server.getName().equals(logicalServerName)) continue;
            this.getLogger().debug("Found and returning server named " + server.getName());
            return server;
        }
        return null;
    }

    @Override
    public java.lang.Object getConnection(LogicalServerInterface logicalServer) throws ServerConnectionException {
        java.lang.Object connection = null;
        try {
            if (this.fsConnectionMap != null) {
                connection = this.fsConnectionMap.getConnection(logicalServer, this.userContext);
            }
            if (connection == null || connection instanceof Connection && ((Connection)connection).isClosed()) {
                connection = this.createConnection(logicalServer);
            }
        }
        catch (SQLException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
        catch (RemoteException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
        catch (ServiceException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
        return connection;
    }

    @Override
    public java.lang.Object getConnection(String logicalServerName) throws ServerConnectionException {
        java.lang.Object connection = null;
        try {
            LogicalServerInterface logicalServer = this.getLogicalServer(logicalServerName);
            if (logicalServer == null) {
                String msg = MessageFormat.format(RB.getStringResource("DataProvider.noServer.fmt"), logicalServerName);
                throw new ServerConnectionException(msg);
            }
            if (this.userContext != null && logicalServer != null) {
                if (this.fsConnectionMap != null && this.fsConnectionMap.containsKey(logicalServer)) {
                    connection = this.fsConnectionMap.getConnection(logicalServer, this.userContext);
                }
                if (connection == null || connection instanceof Connection && ((Connection)connection).isClosed()) {
                    connection = this.createConnection(logicalServer);
                }
            }
        }
        catch (RemoteException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
        catch (SQLException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
        catch (ServiceException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
        return connection;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public Connection getConnectionForTableURL(String tableURL) throws ServerConnectionException {
        MVAConnection connection;
        block17: {
            connection = null;
            try {
                if (DataProvider.isEmpty(tableURL)) break block17;
                this.getLogger().debug("getConnectionForTableURL where url=", tableURL);
                String url = PersistHelper.parseSBIPUrl((String)tableURL);
                PhysicalTableInterface physicalTable = this.getPhysicalTable(url);
                SASLibraryInterface library = DataProviderUtil.getLibrary(physicalTable, this.locale);
                LogicalServerInterface ls = this.getLogicalServerForLibrary(library);
                this.getLogger().debug("getConnectionForTableURL library=", library.getName());
                if (ls != null) {
                    IWorkspace iw = this.getIWorkspace(ls.getName());
                    if (!library.isDBMSLibname()) {
                        Properties connectionProps = new Properties();
                        if (!library.isPreassigned()) {
                            String libname = this.getLibName(library);
                            connectionProps.put("librefs", libname);
                        }
                        try {
                            connection = new MVAConnection(iw, connectionProps);
                        }
                        catch (SQLException se) {
                            connection = new MVAConnection(iw.GetNewWorkspace(), connectionProps);
                        }
                        if (this.sqlConnectionsList == null) {
                            this.sqlConnectionsList = Collections.synchronizedList(new ArrayList());
                        }
                        this.sqlConnectionsList.add(connection);
                    } else {
                        Properties connectionProps = new Properties();
                        String libname = this.getLibName(library);
                        try {
                            iw.LanguageService().Submit(libname);
                        }
                        catch (GenericError e) {
                            this.getLogger().error(e.getMessage(), (Throwable)e);
                            throw new ServerConnectionException((Throwable)e, e.getMessage());
                        }
                        connection = new MVAConnection(iw, connectionProps);
                        if (this.sqlConnectionsList == null) {
                            this.sqlConnectionsList = Collections.synchronizedList(new ArrayList());
                        }
                        this.sqlConnectionsList.add(connection);
                    }
                }
                if (null == connection) {
                    String msg = MessageFormat.format(RB.getStringResource("DataProvider.noConnection.fmt", this.locale), library.getName());
                    throw new ServerConnectionException(msg);
                }
            }
            catch (ServiceException re) {
                this.getLogger().error(re.getMessage(), (Throwable)re);
                throw new ServerConnectionException((Throwable)re, re.getMessage());
            }
            catch (RemoteException re) {
                this.getLogger().error(re.getMessage(), (Throwable)re);
                throw new ServerConnectionException((Throwable)re, re.getMessage());
            }
            catch (SQLException se) {
                this.getLogger().error(se.getMessage(), (Throwable)se);
                throw new ServerConnectionException((Throwable)se, se.getLocalizedMessage());
            }
            catch (MdException re) {
                this.getLogger().error(re.getMessage(), (Throwable)re);
                throw new ServerConnectionException((Throwable)re, re.getMessage());
            }
            catch (GenericError e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                throw new ServerConnectionException((Throwable)e, e.getMessage());
            }
        }
        return connection;
    }

    private String getLibName(SASLibraryInterface library) throws ServiceException, RemoteException, MdException {
        SASLibrary sl = (SASLibrary)library.getRepositoryEntity();
        MdLibGenInterface libUtil = MdModelUtil.getInstance((CredentialResolver)this.userContext);
        String libname = libUtil.genLibname(sl);
        String engine = library.getEngine();
        StringBuffer sb = new StringBuffer(libname);
        if ("BASE".equalsIgnoreCase(engine)) {
            sb = Strings.replace((StringBuffer)sb, (String)"LIBNAME ", (String)"");
            sb = Strings.replace((StringBuffer)sb, (String)engine, (String)"");
            sb = Strings.replace((StringBuffer)sb, (String)";", (String)"");
        }
        return sb.toString();
    }

    public com.sas.storage.olap.MetadataInterface getOLAPMetadataFromIQ(BusinessModel businessModel) throws IQueryServicesException {
        if (this.iqToMetadataMap == null) {
            this.iqToMetadataMap = new HashMap();
        }
        if (this.iqToMetadataMap.containsKey(businessModel)) {
            return (com.sas.storage.olap.MetadataInterface)this.iqToMetadataMap.get(businessModel);
        }
        com.sas.storage.olap.MetadataInterface metadata = BusinessQueryOLAPUtil.getMetadataInterface((java.lang.Object)businessModel);
        this.iqToMetadataMap.put(businessModel, metadata);
        return metadata;
    }

    public ISession getOLAPConnection(String host, int port) throws ServerConnectionException {
        try {
            String classID = "f3f46472-1e31-11d5-87c2-00c04f38f9f6";
            BridgeServer server = new BridgeServer(classID, host, port);
            ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration((Server)server);
            ConnectionFactoryInterface cxf = ConnectionFactoryManager.getConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
            ConnectionInterface cx = cxf.getConnection(this.omrUserName, this.omrPassword);
            Object obj = cx.getObject();
            IMDXServer connection = IMDXServerHelper.narrow((Object)obj);
            if (this.locale == null) {
                this.locale = Locale.getDefault();
            }
            ISession isession = connection.CreateSession(this.locale.toString());
            return isession;
        }
        catch (ConnectionFactoryException ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
            throw new ServerConnectionException((Throwable)ex, ex.getMessage());
        }
        catch (GenericError ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
            throw new ServerConnectionException((Throwable)ex, ex.getMessage());
        }
    }

    public Connection getJDBCConnection(DynamicValueProviderInterface valueProvider) throws ServerConnectionException {
        try {
            if (this.jdbcConnection == null || this.jdbcConnection.isClosed()) {
                this.jdbcConnection = new JDBCConnection();
                this.jdbcConnection.setConnectionInfo(new Properties());
                this.jdbcConnection.setDatabaseURL("jdbc:sasiom://hoosier:8591");
                this.jdbcConnection.setDriverName("com.sas.rio.MVADriver");
                this.jdbcConnection.setUsername(this.omrUserName);
                this.jdbcConnection.setPassword(this.omrPassword);
            }
            return this.jdbcConnection;
        }
        catch (ClassNotFoundException ce) {
            this.getLogger().error(ce.getMessage(), (Throwable)ce);
            throw new ServerConnectionException((Throwable)ce, ce.getMessage());
        }
        catch (SQLException se) {
            this.getLogger().error(se.getMessage(), (Throwable)se);
            throw new ServerConnectionException((Throwable)se, se.getMessage());
        }
    }

    public String getCubeName(BusinessModel businessModel) {
        String cubeName = null;
        try {
            List dataSourceList = businessModel.getObjects(true, DataSource.class);
            for (DataSource ds : dataSourceList) {
                if (!ds.getStructure().isOLAP() || !(ds instanceof DataSourceCube)) continue;
                cubeName = ((DataSourceCube)ds).getCube().getCubeName();
            }
        }
        catch (MetadataException me) {
            this.getLogger().error(me.getMessage(), (Throwable)me);
        }
        return cubeName;
    }

    public LogicalServerInterface getLogicalServerForPathUrl(PhysicalTableInterface physicalTable) throws ServerConnectionException {
        SASLibraryInterface library = DataProviderUtil.getLibrary(physicalTable, this.locale);
        return this.getLogicalServerForLibrary(library);
    }

    public synchronized LogicalServerInterface getLogicalServerForLibrary(SASLibraryInterface library) throws ServerConnectionException {
        try {
            int size;
            int i;
            List workSpaceServers = library.getWorkspaceServers();
            if (workSpaceServers != null && !workSpaceServers.isEmpty()) {
                i = 0;
                size = workSpaceServers.size();
                while (i < size) {
                    LogicalServerInterface ls;
                    if (!this.isWorkspaceServer(ls = (LogicalServerInterface)workSpaceServers.get(i++))) continue;
                    return ls;
                }
            }
            if ((workSpaceServers = library.getServers()) != null && !workSpaceServers.isEmpty()) {
                i = 0;
                size = workSpaceServers.size();
                while (i < size) {
                    java.lang.Object possibleOMRServer;
                    if (!((possibleOMRServer = workSpaceServers.get(i++)) instanceof OMRServerContext)) continue;
                    OMRServerContext omr = (OMRServerContext)possibleOMRServer;
                    List svrs = omr.getServers();
                    int n = 0;
                    int omrSize = svrs.size();
                    while (n < omrSize) {
                        LogicalServerInterface ls;
                        if (!this.isPooledServer(ls = (LogicalServerInterface)svrs.get(i++))) continue;
                        return ls;
                    }
                }
            }
            if (this.libraryToServerMap != null && this.libraryToServerMap.containsKey(library)) {
                ServerContextInterface sc;
                List l;
                String lsName = (String)this.libraryToServerMap.get(library);
                LogicalServerInterface ls2 = this.getLogicalServer(lsName);
                if (ls2 != null) {
                    return ls2;
                }
                FilterComponent filterComponent = new FilterComponent("Name", 0, lsName);
                Filter filter = new Filter();
                filter.setOMRFlags(388);
                filter.setType("ServerContext");
                filter.setFilterComponent(filterComponent);
                List outList = this.metadataServer.search((FilterInterface)filter);
                if (outList != null && outList.size() > 0 && (l = (sc = (ServerContextInterface)outList.get(0)).getServers()) != null) {
                    for (LogicalServerInterface ls2 : l) {
                        if (!DataProviderUtil.isWorkspaceServer(ls2)) continue;
                        return ls2;
                    }
                }
            }
        }
        catch (ServiceException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
        catch (RemoteException re) {
            this.getLogger().error(re.getMessage(), (Throwable)re);
            throw new ServerConnectionException((Throwable)re, re.getMessage());
        }
        return null;
    }

    public void setDefaultServerforLibrary(SASLibraryInterface library, String serverName) {
        if (this.libraryToServerMap == null) {
            this.libraryToServerMap = new HashMap();
        }
        this.libraryToServerMap.put(library, serverName);
    }

    public PhysicalTableInterface getPhysicalTable2(String sbipURL) throws ServerConnectionException {
        PhysicalTableInterface physicalTable = null;
        if (this.userContext != null && sbipURL != null && sbipURL.length() > 0) {
            try {
                if (this.urlToDataSourceMap.containsKey(sbipURL)) {
                    return (PhysicalTableInterface)this.getDataSourceFromCache(sbipURL);
                }
                PathUrl url = this.newPathUrl(sbipURL);
                IntelligentQueryMetadataService queryService = (IntelligentQueryMetadataService)IntelligentQueryMetadataServiceFactory.newService();
                MetadataInterface m = queryService.getMetadataInterface(this.userContext.getSessionContext(), url);
                if (m == null) {
                    throw new ServerConnectionException(MessageFormat.format(RB.getStringResource("DataProvider.noTable.fmt"), sbipURL));
                }
                if (m instanceof PhysicalTableInterface) {
                    PhysicalTableInterface cachedPhysicalTable = (PhysicalTableInterface)m;
                    FilterComponent filterComponent = new FilterComponent("Id", 0, cachedPhysicalTable.getIdentifier());
                    Filter filter = new Filter();
                    filter.setOMRFlags(388);
                    filter.setOMRTemplate(TABLE_TEMPLATE);
                    filter.setType("PhysicalTable");
                    filter.setFilterComponent(filterComponent);
                    List outList = this.metadataServer.search((FilterInterface)filter);
                    if (outList.size() > 0) {
                        if (!(outList.get(0) instanceof PhysicalTableInterface)) {
                            throw new ServerConnectionException(MessageFormat.format(RB.getStringResource("DataProvider.noTable.fmt"), sbipURL));
                        }
                        physicalTable = (PhysicalTableInterface)outList.get(0);
                        this.addDataSourceToCache(sbipURL, physicalTable);
                    }
                }
            }
            catch (MetadataException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                throw new ServerConnectionException((Throwable)e, e.getMessage());
            }
            catch (RemoteException re) {
                this.getLogger().error(re.getMessage(), (Throwable)re);
                throw new ServerConnectionException((Throwable)re, re.getMessage());
            }
            catch (ServiceException re) {
                this.getLogger().error(re.getMessage(), (Throwable)re);
                throw new ServerConnectionException((Throwable)re, re.getMessage());
            }
        }
        return physicalTable;
    }

    @Override
    public synchronized PhysicalTableInterface getPhysicalTable(String sbipURL) throws ServerConnectionException {
        PhysicalTableInterface physicalTable = null;
        if (this.userContext != null && sbipURL != null && sbipURL.length() > 0) {
            try {
                if (this.urlToDataSourceMap != null && this.urlToDataSourceMap.containsKey(sbipURL)) {
                    return (PhysicalTableInterface)this.getDataSourceFromCache(sbipURL);
                }
                PathUrl url = this.newPathUrl(sbipURL);
                InformationServiceInterface infoService = UserContext.getInformationService();
                this.getLogger().debug("getPhysicalTable() attempting to getObjectByPath for:", sbipURL);
                MetadataInterface o = infoService.getObjectByPath(this.userContext, url);
                if (o instanceof PhysicalTableInterface) {
                    physicalTable = (PhysicalTableInterface)o;
                    this.addDataSourceToCache(sbipURL, physicalTable);
                }
            }
            catch (RemoteException re) {
                this.getLogger().error(re.getMessage(), (Throwable)re);
                throw new ServerConnectionException((Throwable)re, re.getMessage());
            }
            catch (ServiceException re) {
                this.getLogger().error(re.getMessage(), (Throwable)re);
                throw new ServerConnectionException((Throwable)re, re.getMessage());
            }
        }
        return physicalTable;
    }

    @Override
    public MetadataInterface getPhysicalCube(String sbipURL) throws ServerConnectionException {
        MetadataInterface physicalCube = null;
        if (this.userContext != null && sbipURL != null && sbipURL.length() > 0) {
            try {
                if (this.urlToDataSourceMap != null && this.urlToDataSourceMap.containsKey(sbipURL)) {
                    return (MetadataInterface)this.getDataSourceFromCache(sbipURL);
                }
                IntelligentQueryMetadataService queryService = (IntelligentQueryMetadataService)IntelligentQueryMetadataServiceFactory.newService();
                physicalCube = queryService.getMetadataInterface(this.userContext.getSessionContext(), this.newPathUrl(sbipURL));
                if (physicalCube == null) {
                    throw new ServerConnectionException(MessageFormat.format(RB.getStringResource("DataProvider.noCube.fmt"), sbipURL));
                }
                this.addDataSourceToCache(sbipURL, physicalCube);
            }
            catch (MetadataException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                throw new ServerConnectionException((Throwable)e, e.getMessage());
            }
            catch (RemoteException re) {
                this.getLogger().error(re.getMessage(), (Throwable)re);
                throw new ServerConnectionException((Throwable)re, re.getMessage());
            }
            catch (ServiceException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                throw new ServerConnectionException((Throwable)e, e.getMessage());
            }
        }
        return physicalCube;
    }

    public LogicalServerInterface getOLAPServer(String sbipUrl) throws ServerConnectionException {
        LogicalServerInterface logicalServer2 = null;
        try {
            MetadataInterface cube = this.getPhysicalCube(sbipUrl);
            java.lang.Object o = cube.getRepositoryEntity();
            if (o instanceof Cube) {
                OLAPSchema os = ((Cube)o).getAssociatedOLAPSchema();
                List servers = this.getLogicalServers();
                for (LogicalServerInterface logicalServer2 : servers) {
                    if (this.isOLAPServer(logicalServer2)) {
                        return logicalServer2;
                    }
                    logicalServer2 = null;
                }
            }
        }
        catch (RemoteException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            String msg = MessageFormat.format(RB.getStringResource("DataProvider.noTable.fmt"), sbipUrl);
            throw new ServerConnectionException((Throwable)e, msg);
        }
        catch (MdException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            String msg = MessageFormat.format(RB.getStringResource("DataProvider.noTable.fmt"), sbipUrl);
            throw new ServerConnectionException((Throwable)e, msg);
        }
        catch (ServiceException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            String msg = MessageFormat.format(RB.getStringResource("DataProvider.noTable.fmt"), sbipUrl);
            throw new ServerConnectionException((Throwable)e, msg);
        }
        return logicalServer2;
    }

    @Override
    public synchronized InformationMap getInformationMap(String infoMapUrl) throws ServerConnectionException {
        InformationMap informationMap = null;
        if (this.userContext != null && infoMapUrl != null && infoMapUrl.length() > 0) {
            try {
                if (this.urlToDataSourceMap != null && this.urlToDataSourceMap.containsKey(infoMapUrl)) {
                    return (InformationMap)this.getDataSourceFromCache(infoMapUrl);
                }
                informationMap = this.loadInformationMap(infoMapUrl);
                this.addDataSourceToCache(infoMapUrl, informationMap);
            }
            catch (MetadataException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                String msg = MessageFormat.format(RB.getStringResource("DataProvider.noInfoMap.fmt"), infoMapUrl);
                throw new ServerConnectionException((Throwable)e, msg);
            }
            catch (RemoteException re) {
                this.getLogger().error(re.getMessage(), (Throwable)re);
                String msg = MessageFormat.format(RB.getStringResource("DataProvider.noInfoMap.fmt"), infoMapUrl);
                throw new ServerConnectionException((Throwable)re, msg);
            }
            catch (ServiceException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                String msg = MessageFormat.format(RB.getStringResource("DataProvider.noInfoMap.fmt"), infoMapUrl);
                throw new ServerConnectionException((Throwable)e, msg);
            }
        }
        return informationMap;
    }

    protected InformationMap loadInformationMap(String infoMapUrl) throws MetadataException, RemoteException, ServiceException {
        IntelligentQueryMetadataService queryService = (IntelligentQueryMetadataService)IntelligentQueryMetadataServiceFactory.newService();
        SessionContextInterface sessionContext = this.userContext.getSessionContext();
        PathUrl url = this.newPathUrl(infoMapUrl);
        return queryService.getInformationMap(sessionContext, url);
    }

    @Override
    public boolean isMeasureDataItem(String dataSourceLocation, String dataItemId) throws ServerConnectionException {
        DataItem di = this.getDataItemFromId(dataSourceLocation, dataItemId);
        return di != null && di.getStructure() == StructureOfDataItem.STRUCTURE_COLUMN && di.getUsage() == DataItemActionType.USAGE_AGGREGATE;
    }

    public DataItem getDataItemFromId(String infoMapUrl, String dataItemId) throws ServerConnectionException {
        return this.getDataItemFromId(this.getInformationMap(infoMapUrl), dataItemId);
    }

    public synchronized DataItem getDataItemFromId(InformationMap im, String dataItemId) throws ServerConnectionException {
        if (dataItemId != null) {
            List diList = im.getObjects(true, DataItem.class);
            for (DataItem di : diList) {
                try {
                    if (!di.getID().equals(dataItemId) && !di.getLabel().equals(dataItemId)) continue;
                    return di;
                }
                catch (InvalidIDException ie) {
                    this.getLogger().error(ie.getMessage(), (Throwable)ie);
                    throw new ServerConnectionException((Throwable)ie, ie.getMessage());
                }
            }
        }
        return null;
    }

    public FilterItem getFilterItemFromId(String infoMapUrl, String filterItemId) throws ServerConnectionException {
        return DataProvider.getFilterItemFromId(this.getInformationMap(infoMapUrl), filterItemId);
    }

    public static FilterItem getFilterItemFromId(InformationMap im, String filterItemId) throws ServerConnectionException {
        if (im != null && filterItemId != null) {
            List diList = im.getObjects(true, FilterItem.class);
            for (FilterItem fi : diList) {
                try {
                    if (!fi.getID().equals(filterItemId) && !fi.getLabel().equals(filterItemId)) continue;
                    return fi;
                }
                catch (InvalidIDException ie) {
                    throw new ServerConnectionException((Throwable)ie, ie.getMessage());
                }
            }
        }
        return null;
    }

    public boolean isOLAP(String infoMapUrl) throws ServerConnectionException {
        InformationMap im = this.getInformationMap(infoMapUrl);
        return im.getStructure().isOLAP();
    }

    public boolean isOLAP(DataItem dataItem) {
        return dataItem.getStructure().isOLAP();
    }

    public static synchronized String getPathUrl(DataItem dataItem) {
        ValidateArg.notNull((java.lang.Object)dataItem, (String)"dataItem");
        BusinessModel bModel = dataItem.getBusinessModel();
        if (null != bModel) {
            return PersistHelper.parseSBIPUrl((String)bModel.getReferenceInfo().getPersistentLocation());
        }
        return null;
    }

    public synchronized void closeFSConnections(UserContextInterface userContext) throws RemoteException, GenericError, SQLException, ConnectionFactoryException {
        if (userContext == null || this.fsConnectionMap == null) {
            return;
        }
        Collection fsConnections = this.fsConnectionMap.values();
        for (UserToConnectionMap userToConnectionMap : fsConnections) {
            IWorkspace iWorkspace;
            if (!userToConnectionMap.containsKey(userContext)) continue;
            java.lang.Object connection = userToConnectionMap.getOLAPConnection(userContext);
            if (connection != null && connection instanceof ISession) {
                ((ISession)connection).Close();
                connection = null;
            }
            if ((connection = userToConnectionMap.getWorkspaceConnection(userContext)) != null && connection instanceof Connection) {
                if (!((Connection)connection).isClosed()) {
                    ((Connection)connection).close();
                }
                connection = null;
            }
            if ((iWorkspace = userToConnectionMap.getIWorkspace(userContext)) != null) {
                iWorkspace.Close();
            }
            if ((connection = userToConnectionMap.getConnectionFactory(userContext)) != null && connection instanceof ConnectionInterface) {
                ((ConnectionInterface)connection).close();
                connection = null;
            }
            userToConnectionMap.remove(userContext);
        }
    }

    public synchronized void closeNonFSConnections(String userName) throws RemoteException, GenericError, SQLException {
        if (userName == null || this.nonfsConnectionMap == null) {
            return;
        }
        Set serverToUserCol = this.nonfsConnectionMap.entrySet();
        for (Map.Entry entry : serverToUserCol) {
            UserToConnectionMap userMapping = (UserToConnectionMap)entry.getValue();
            if (!userMapping.containsKey(userName)) continue;
            java.lang.Object connection = userMapping.getConnection(userName);
            if (connection instanceof ConnectionInterface) {
                ((ConnectionInterface)connection).close();
            } else if (connection instanceof ISession) {
                ((ISession)connection).Close();
            }
            IWorkspace iWorkspace = userMapping.getIWorkspace(userName);
            iWorkspace.Close();
            userMapping.remove(userName);
        }
    }

    public void releaseIQMetadata() {
        if (this.iqToMetadataMap == null || this.iqToMetadataMap.isEmpty()) {
            return;
        }
        Collection values = this.iqToMetadataMap.values();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            BusinessQueryOLAPUtil.releaseMetadataInterface((com.sas.storage.olap.MetadataInterface)((com.sas.storage.olap.MetadataInterface)iter.next()));
        }
    }

    private void clearAdapterToCacheMap() {
        if (this.adapterToCacheMap != null) {
            Set c = this.adapterToCacheMap.keySet();
            for (java.lang.Object o : c) {
                if (!(o instanceof ValueProviderModelAdapter)) continue;
                ((ValueProviderModelAdapter)o).resetCache();
            }
            this.adapterToCacheMap.clear();
        }
    }

    private void closeSQLConnections() {
        try {
            if (this.sqlConnectionsList != null) {
                for (Connection connection : this.sqlConnectionsList) {
                    if (!connection.isClosed()) {
                        connection.close();
                    }
                    java.lang.Object var2_3 = null;
                }
                this.sqlConnectionsList.clear();
            }
        }
        catch (SQLException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.sqlConnectionsList != null) {
                this.sqlConnectionsList.clear();
            }
        }
    }

    public void close() throws ServerConnectionException {
        this.getLogger().debug("calling close()");
        try {
            if (this.omrConnection != null) {
                this.omrConnection.close();
                this.omrConnection = null;
            }
            this.closeSQLConnections();
            this.closeFSConnections(this.userContext);
            this.closeNonFSConnections(this.omrUserName);
            this.releaseIQMetadata();
            if (this.jdbcConnection != null) {
                this.jdbcConnection.close();
                this.jdbcConnection = null;
            }
            if (this.iqToMetadataMap != null) {
                this.iqToMetadataMap.clear();
            }
            if (this.libraryToServerMap != null) {
                this.libraryToServerMap.clear();
            }
            if (this.urlToDataSourceMap != null) {
                this.urlToDataSourceMap.clear();
            }
            this.clearAdapterToCacheMap();
        }
        catch (SQLException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, RB.getStringResource("closeConnectionError.txt"));
        }
        catch (RemoteException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, RB.getStringResource("closeConnectionError.txt"));
        }
        catch (GenericError e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, RB.getStringResource("closeConnectionError.txt"));
        }
        catch (ConnectionFactoryException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, RB.getStringResource("closeConnectionError.txt"));
        }
    }

    public boolean isOLAPServer(LogicalServerInterface logicalServer) throws RemoteException, ServiceException {
        return DataProviderUtil.isOLAPServer(logicalServer);
    }

    public boolean isWorkspaceServer(LogicalServerInterface logicalServer) throws RemoteException, ServiceException {
        return DataProviderUtil.isWorkspaceServer(logicalServer);
    }

    public boolean isStoredProcessServer(LogicalServerInterface logicalServer) throws RemoteException, ServiceException {
        return DataProviderUtil.isStoredProcessServer(logicalServer);
    }

    public boolean isPooledServer(LogicalServerInterface logicalServer) throws RemoteException, ServiceException {
        return DataProviderUtil.isPooledServer(logicalServer);
    }

    public final void setMetadataServer(ServerInterface server) {
        this.metadataServer = server;
    }

    protected PathUrl newPathUrl(String sbip) throws ServiceException, RemoteException {
        if (null != sbip && sbip.startsWith("SBIP")) {
            return new PathUrl(sbip);
        }
        if (null == this.metadataServer) {
            throw new ServiceException(RB.getStringResource("DataProvider.invalidUrl.txt"));
        }
        return PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this.metadataServer, (String)sbip);
    }

    public String getLibrefForLibrary(String sasFoldersURL) throws ServerConnectionException {
        String libref = null;
        SASLibraryInterface library = null;
        if (this.userContext == null || sasFoldersURL == null || sasFoldersURL.length() == 0) {
            throw new IllegalArgumentException();
        }
        try {
            if (this.urlToDataSourceMap != null && this.urlToDataSourceMap.containsKey(sasFoldersURL)) {
                library = (SASLibraryInterface)this.getDataSourceFromCache(sasFoldersURL);
            }
            if (library == null) {
                PathUrl url = this.newPathUrl(sasFoldersURL);
                InformationServiceInterface infoService = UserContext.getInformationService();
                this.getLogger().debug("getLibrefForLibrary() attempting to getObjectByPath for:", sasFoldersURL);
                MetadataInterface o = infoService.getObjectByPath(this.userContext, url);
                if (o instanceof SASLibraryInterface) {
                    library = (SASLibraryInterface)o;
                }
                if (library == null) {
                    this.getLogger().debug("getLibrefForLibrary() Unable to get libref for library:", sasFoldersURL);
                    String msg = MessageFormat.format(RB.getStringResource("DataProvider.noLibref.fmt"), sasFoldersURL);
                    throw new IllegalArgumentException(msg);
                }
            }
            SASLibrary saslib = (SASLibrary)library.getRepositoryEntity();
            libref = saslib.getLibref();
            this.addDataSourceToCache(sasFoldersURL, library);
        }
        catch (RemoteException re) {
            this.getLogger().error(re.getMessage(), (Throwable)re);
            throw new ServerConnectionException((Throwable)re, re.getMessage());
        }
        catch (ServiceException re) {
            this.getLogger().error(re.getMessage(), (Throwable)re);
            throw new ServerConnectionException((Throwable)re, re.getMessage());
        }
        return libref;
    }

    public DataSourceColumnInterface getDataSourceColumnForItem(DataSourceInterface dataSource, String column, Locale locale) throws ServerConnectionException {
        BaseDataSourceColumn dataSourceColumn = new BaseDataSourceColumn();
        dataSourceColumn.setDataSource(dataSource);
        dataSourceColumn.setColumnName(column);
        try {
            MetadataInterface mi;
            if (dataSource == null || column == null) {
                throw new IllegalArgumentException(RB.getStringResource("DataProvider.invalidSource.txt"));
            }
            ServerInterface server = this.userContext.getAuthServer();
            if (server == null) {
                throw new IllegalArgumentException(RB.getStringResource("DataProvider.invalidUser.txt"));
            }
            String location = dataSource.getDataSourceLocation();
            PathUrl pathUrl = null;
            try {
                pathUrl = PathUrl.newPathUrlFromExistingUrl((ServerInterface)server, (PathUrl)new PathUrl(location));
            }
            catch (IllegalArgumentException e) {
                pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)location);
            }
            if (pathUrl == null) {
                String msg = MessageFormat.format(RB.getStringResource("DataProvider.noPathUrl.fmt"), location);
                throw new IllegalArgumentException(msg);
            }
            if (pathUrl.getType() == null) {
                pathUrl.setType("");
            }
            if ((mi = server.getObjectByPath(pathUrl)) instanceof DataTableInterface) {
                List cols = ((DataTableInterface)mi).getColumns();
                for (ColumnInterface c : cols) {
                    ColumnAttributes ca;
                    if (!Strings.equal((String)column, (String)c.getName(), (boolean)false, (boolean)false) || (ca = c.getColumnAttributes()) == null) continue;
                    String ct = ca.getSasColumnType();
                    String format = ca.getSasFormat();
                    long columnType = -1L;
                    if (ct.equals("C")) {
                        columnType = 1L;
                    } else if (ct.equals("N")) {
                        SASFormat sasFormat = null;
                        if (format != null && format.length() > 0) {
                            sasFormat = SASFormat.getInstance((String)format, (Locale)locale);
                        }
                        columnType = sasFormat != null && sasFormat.isDateFormat() ? 4L : (sasFormat != null && sasFormat.isTimeFormat() ? 8L : (sasFormat != null && sasFormat.isDateTimeFormat() ? 16L : 2L));
                    }
                    dataSourceColumn.setColumnType(columnType);
                    if (ca.getDescription() != null && ca.getDescription().length() > 0) {
                        dataSourceColumn.setColumnLabel(ca.getDescription());
                    } else {
                        dataSourceColumn.setColumnLabel(ca.getColumnName());
                    }
                    return dataSourceColumn;
                }
                String msg = MessageFormat.format(RB.getStringResource("DataProvider.noColumn.fmt"), column);
                throw new IllegalArgumentException(msg);
            }
            if (mi instanceof BriefInformationMap) {
                InformationMap im = this.getInformationMap(location);
                if (im == null) {
                    String msg = MessageFormat.format(RB.getStringResource("DataProvider.noInfoMap.fmt"), location);
                    throw new IllegalArgumentException(msg);
                }
                List diList = im.getObjects(true, DataItem.class);
                for (DataItem di : diList) {
                    try {
                        if (!di.getID().equalsIgnoreCase(column) && !di.getLabel().equalsIgnoreCase(column)) continue;
                        dataSourceColumn.setColumnType(InfoMapItemsValueProvider.getDataSourceColumnType(di));
                        dataSourceColumn.setColumnLabel(di.getDescription(locale));
                        return dataSourceColumn;
                    }
                    catch (InvalidIDException invalidIDException) {
                    }
                }
                String msg = MessageFormat.format(RB.getStringResource("DataProvider.noDataItem.fmt"), column);
                throw new IllegalArgumentException(msg);
            }
            throw new IllegalArgumentException(RB.getStringResource("DataProvider.invalidUrl.txt"));
        }
        catch (RemoteException re) {
            this.getLogger().error(re.getMessage(), (Throwable)re);
            throw new ServerConnectionException((Throwable)re, re.getMessage());
        }
        catch (ServiceException re) {
            this.getLogger().error(re.getMessage(), (Throwable)re);
            throw new ServerConnectionException((Throwable)re, re.getMessage());
        }
    }

    private long getDataSourceType(MetadataInterface mi) throws ServiceException, RemoteException {
        String type = mi.getType();
        if ("InformationMap".equals(type)) {
            InformationMapMetaData metaData;
            if (this.userContext != null && (metaData = IQUeryUtil.getInfoMapMetaData(mi.getEntityKey(), mi.getModifyDate().getTime(), this.userContext.getAuthServer())) != null && metaData.isOLAP()) {
                return 8L;
            }
            return 4L;
        }
        if ("InformationMap.Relational".equals(type)) {
            return 4L;
        }
        if ("InformationMap.OLAP".equals(type)) {
            return 8L;
        }
        if ("Table".equals(type) || "PhysicalTable".equals(type)) {
            return 1L;
        }
        if ("Cube".equals(type)) {
            return 2L;
        }
        return -1L;
    }

    public DataSourceInterface getDataSourceByPath(String path, Locale locale) throws ServerConnectionException {
        try {
            if (path == null) {
                throw new IllegalArgumentException();
            }
            ServerInterface server = this.userContext.getAuthServer();
            PathUrl pathUrl = null;
            try {
                pathUrl = PathUrl.newPathUrlFromExistingUrl((ServerInterface)server, (PathUrl)new PathUrl(path));
            }
            catch (IllegalArgumentException e) {
                pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)path);
            }
            if (pathUrl == null) {
                String msg = MessageFormat.format(RB.getStringResource("DataProvider.invalidDataSource.fmt"), path);
                throw new IllegalArgumentException(msg);
            }
            MetadataInterface mi = server.getObjectByPath(pathUrl);
            if (mi == null) {
                throw new IllegalArgumentException();
            }
            long type = this.getDataSourceType(mi);
            if (pathUrl.getType() == null) {
                if (!pathUrl.isWritable()) {
                    pathUrl = new PathUrl(pathUrl.toString());
                }
                if (type == 2L) {
                    pathUrl.setType("Cube");
                } else if (type == 1L) {
                    pathUrl.setType("Table");
                } else if (type == 8L) {
                    pathUrl.setType("InformationMap");
                } else if (type == 4L) {
                    pathUrl.setType("InformationMap");
                }
            }
            BaseDataSource ds = new BaseDataSource(type, pathUrl.getAbsolutePath());
            return ds;
        }
        catch (RemoteException re) {
            this.getLogger().error(re.getMessage(), (Throwable)re);
            throw new ServerConnectionException((Throwable)re, re.getMessage());
        }
        catch (ServiceException re) {
            this.getLogger().error(re.getMessage(), (Throwable)re);
            throw new ServerConnectionException((Throwable)re, re.getMessage());
        }
    }

    @Override
    public java.lang.Object getRemoteFileModel() {
        return null;
    }

    @Override
    public java.lang.Object getIFileModel(String logicalServerName) {
        return null;
    }

    @Override
    public FileValidatorInterface getFileValidator(String logicalServerName) {
        return null;
    }

    @Override
    public synchronized String uploadFileContents(InputStream inputStream, String logicalServerName, String uploadPath, String shortName) throws IOException, ServerConnectionException {
        BufferedInputStream inFile = new BufferedInputStream(inputStream);
        int n = 0;
        boolean tot = false;
        byte[] buffer = new byte[4096];
        String fullUploadPath = "";
        IWorkspace workspace = this.getIWorkspace(logicalServerName);
        IFileService fileService = workspace.FileService();
        IUtilities utilities = workspace.Utilities();
        IHostSystem hostSystem = utilities.HostSystem();
        StringSeqHolder softwareInfo = new StringSeqHolder();
        VariableArray2dOfStringHolder hardwareInfo = new VariableArray2dOfStringHolder();
        try {
            hostSystem.GetInfo(softwareInfo, hardwareInfo);
            String hostFamily = softwareInfo.value[SoftwareInfoIndex.SoftwareInfoIndexOSFamily.value()];
            if (hostFamily.equals("OS")) {
                workspace.LanguageService().Submit(HFS_FILESYSTEM_OPTION);
            }
            if (uploadPath == null || "".equals(uploadPath)) {
                uploadPath = "/";
            }
            fullUploadPath = fileService.FullName(shortName, fileService.MakeDirectory(uploadPath, "temp"));
            IFileref file = fileService.AssignFileref("", "", fullUploadPath, "", new StringHolder());
            IBinaryStream fileStream = file.OpenBinaryStream(StreamOpenMode.StreamOpenModeForWriting);
            while ((n = inFile.read(buffer, 0, buffer.length)) >= 0) {
                fileStream.Write(buffer);
            }
            inFile.close();
            fileStream.Close();
        }
        catch (IOException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (GenericError e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
        return fullUploadPath;
    }

    private class UserToConnectionMap
    extends HashMap {
        private java.lang.Object[] mappingArray = new java.lang.Object[4];

        private UserToConnectionMap() {
        }

        private java.lang.Object getConnection(String userName) {
            java.lang.Object connection = null;
            if (this.containsKey(userName)) {
                java.lang.Object[] mapping = (java.lang.Object[])this.get(userName);
                connection = mapping[0];
            }
            return connection;
        }

        public void addConnection(java.lang.Object connection, String userName) {
            this.mappingArray[0] = connection;
            this.put(userName, this.mappingArray);
        }

        private IWorkspace getIWorkspace(String userName) {
            java.lang.Object[] mapping;
            IWorkspace iWorkspace = null;
            if (this.containsKey(userName) && (mapping = (java.lang.Object[])this.get(userName))[1] != null) {
                iWorkspace = (IWorkspace)mapping[1];
            }
            return iWorkspace;
        }

        public void addIWorkspace(IWorkspace iWorkspace, String userName) {
            this.mappingArray[1] = iWorkspace;
            this.put(userName, this.mappingArray);
        }

        public java.lang.Object getOLAPConnection(UserContextInterface userContext) {
            java.lang.Object connection = null;
            if (this.containsKey(userContext)) {
                java.lang.Object[] mapping = (java.lang.Object[])this.get(userContext);
                connection = mapping[0];
            }
            return connection;
        }

        public java.lang.Object getWorkspaceConnection(UserContextInterface userContext) {
            java.lang.Object connection = null;
            if (this.containsKey(userContext)) {
                java.lang.Object[] mapping = (java.lang.Object[])this.get(userContext);
                connection = mapping[1];
            }
            return connection;
        }

        public void addConnection(java.lang.Object connection, UserContextInterface userContext) {
            if (connection instanceof ISession) {
                this.mappingArray[0] = connection;
            } else if (connection instanceof Connection) {
                this.mappingArray[1] = connection;
            } else if (connection instanceof ConnectionInterface) {
                this.mappingArray[3] = connection;
            }
            this.put(userContext, this.mappingArray);
        }

        public IWorkspace getIWorkspace(UserContextInterface userContext) {
            IWorkspace iWorkspace = null;
            if (this.containsKey(userContext)) {
                java.lang.Object[] mapping = (java.lang.Object[])this.get(userContext);
                iWorkspace = (IWorkspace)mapping[2];
            }
            return iWorkspace;
        }

        public ConnectionInterface getConnectionFactory(UserContextInterface userContext) {
            ConnectionInterface conn = null;
            if (this.containsKey(userContext)) {
                java.lang.Object[] mapping = (java.lang.Object[])this.get(userContext);
                conn = (ConnectionInterface)mapping[3];
            }
            return conn;
        }

        public void addIWorkspace(IWorkspace iWorkspace, UserContextInterface userContext) {
            this.mappingArray[2] = iWorkspace;
            this.put(userContext, this.mappingArray);
        }

        public void addConnectionFactory(ConnectionInterface connectionFactory, UserContextInterface userContext) {
            this.mappingArray[3] = connectionFactory;
            this.put(userContext, this.mappingArray);
        }
    }

    private class NonFSConnectionMap
    extends HashMap {
        private UserToConnectionMap userMapping;

        private NonFSConnectionMap() {
        }

        public java.lang.Object getConnection(String logicalServerName, String userName) {
            java.lang.Object connection = null;
            if (this.containsKey(logicalServerName)) {
                UserToConnectionMap userMapping = (UserToConnectionMap)this.get(logicalServerName);
                connection = userMapping.getConnection(userName);
            }
            return connection;
        }

        public void addConnection(java.lang.Object connection, String logicalServerName, String userName) {
            if (this.userMapping == null) {
                this.userMapping = new UserToConnectionMap();
            }
            this.userMapping.addConnection(connection, userName);
            this.put(logicalServerName, this.userMapping);
        }

        public IWorkspace getIWorkspace(String logicalServerName, String userName) {
            IWorkspace iWorkspace = null;
            if (this.containsKey(logicalServerName)) {
                UserToConnectionMap userMapping = (UserToConnectionMap)this.get(logicalServerName);
                iWorkspace = userMapping.getIWorkspace(userName);
            }
            return iWorkspace;
        }

        public void addIWorkspace(IWorkspace iWorkspace, String logicalServerName, String userName) {
            if (this.userMapping == null) {
                this.userMapping = new UserToConnectionMap();
            }
            this.userMapping.addIWorkspace(iWorkspace, userName);
            this.put(logicalServerName, this.userMapping);
        }
    }

    private class FSConnectionMap
    extends HashMap {
        private UserToConnectionMap userMapping;

        private FSConnectionMap() {
        }

        public java.lang.Object getConnection(LogicalServerInterface logicalServer, UserContextInterface userContext) throws RemoteException, ServiceException {
            java.lang.Object connection = null;
            if (this.containsKey(logicalServer)) {
                UserToConnectionMap userMapping = (UserToConnectionMap)this.get(logicalServer);
                connection = DataProvider.this.isWorkspaceServer(logicalServer) ? userMapping.getWorkspaceConnection(userContext) : userMapping.getOLAPConnection(userContext);
            }
            return connection;
        }

        public void addConnection(java.lang.Object connection, LogicalServerInterface logicalServer, UserContextInterface userContext) {
            if (this.userMapping == null) {
                this.userMapping = new UserToConnectionMap();
            }
            this.userMapping.addConnection(connection, userContext);
            this.put(logicalServer, this.userMapping);
        }

        public void addConnection(java.lang.Object connection, LogicalServer logicalServer, UserContextInterface userContext) {
            if (this.userMapping == null) {
                this.userMapping = new UserToConnectionMap();
            }
            this.userMapping.addConnection(connection, userContext);
            this.put(logicalServer, this.userMapping);
        }

        public IWorkspace getIWorkspace(LogicalServerInterface logicalServer, UserContextInterface userContext) {
            IWorkspace connection = null;
            if (this.containsKey(logicalServer)) {
                UserToConnectionMap userMapping = (UserToConnectionMap)this.get(logicalServer);
                connection = userMapping.getIWorkspace(userContext);
            }
            return connection;
        }

        public void addIWorkspace(IWorkspace iWorkspace, LogicalServerInterface logicalServer, UserContextInterface userContext) {
            if (this.userMapping == null) {
                this.userMapping = new UserToConnectionMap();
            }
            this.userMapping.addIWorkspace(iWorkspace, userContext);
            this.put(logicalServer, this.userMapping);
        }

        public void addConnectionFactory(ConnectionInterface connection, LogicalServerInterface logicalServer, UserContextInterface userContext) {
            if (this.userMapping == null) {
                this.userMapping = new UserToConnectionMap();
            }
            this.userMapping.addConnection((java.lang.Object)connection, userContext);
            this.put(logicalServer, this.userMapping);
        }
    }
}

