/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.util.iquery;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DateType;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.IntegerType;
import com.sas.datatypes.StringType;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.CascadableFilter;
import com.sas.iquery.metadata.business.FilterCascade;
import com.sas.iquery.metadata.business.FilterCascadeContainer;
import com.sas.iquery.metadata.business.FilterCascadeInterface;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.MultipleConditionalExpression;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DefaultPromptComponentModel;
import com.sas.prompts.DynamicPromptValueContext;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.PromptComponentModelInterface;
import com.sas.prompts.PromptPropertiesPanelModelInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.simplesqlmodel.PromptValueOperand;
import com.sas.prompts.util.iquery.ConvenientMetadataEntityTreeNode;
import com.sas.prompts.util.iquery.RB;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.iq.DataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.RelationalDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.workspace.PromptColumnValueProvider;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.olap.tree.MetadataEntityTreeNode;
import com.sas.storage.olap.tree.MetadataTreeModel;
import com.sas.storage.simplesqlmodel.ColumnOperand;
import com.sas.storage.simplesqlmodel.Expression;
import com.sas.storage.simplesqlmodel.FormattedOperator;
import com.sas.storage.simplesqlmodel.MultiValueFormattedOperator;
import com.sas.storage.simplesqlmodel.OperandInterface;
import com.sas.storage.simplesqlmodel.OperatorInterface;
import com.sas.storage.simplesqlmodel.WhereClause;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.workspace.ColumnValueProvider;
import com.sas.storage.vr.dto.ColumnValueItem;
import com.sas.storage.vr.dto.DataSource;
import com.sas.storage.vr.dto.DynamicValueRetrieverConfiguration;
import com.sas.storage.vr.dto.MetadataTreeNode;
import com.sas.storage.vr.dto.QueryItem;
import com.sas.storage.vr.dto.QueryItemSearchCriteria;
import com.sas.storage.vr.dto.QueryProperty;
import com.sas.storage.vr.dto.Search;
import com.sas.storage.vr.dto.SearchOperatorEnum;
import com.sas.storage.vr.dto.ValueDataTypeEnum;
import com.sas.svcs.form.dto.DatePeriodDTO;
import com.sas.svcs.form.dto.MissingValuesDTO;
import com.sas.svcs.form.dto.SpecialValuesDTO;
import com.sas.svcs.formvr.client.ValueRetrieverExceptionHolder;
import com.sas.svcs.formvr.client.types.GetValuesAsListParameters;
import com.sas.svcs.formvr.client.types.GetValuesAsTreeParameters;
import com.sas.svcs.formvr.client.types.ValueRetrieverException;
import com.sas.text.Message;
import com.sas.util.DatePeriod;
import com.sas.util.ListFactory;
import com.sas.util.Util;
import com.sas.util.ValueItem;
import com.sas.util.anno.NotNull;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.MutableTreeNode;

public final class PromptIQueryUtil {
    public static FilterItem applyCascadingFilters(FilterItem filter) {
        ArrayList cascades = new ArrayList();
        ExpressionInterface expression = filter.getExpression();
        PromptIQueryUtil.processExpression(filter, expression, cascades);
        if (expression instanceof MultipleConditionalExpression) {
            ((MultipleConditionalExpression)expression).setCascades(cascades);
        }
        return filter;
    }

    private static void processExpression(FilterItem filter, ExpressionInterface expression, List cascades) {
        if (expression instanceof MultipleConditionalExpression) {
            int count = ((MultipleConditionalExpression)expression).getExpressionCount();
            for (int i = 0; i < count; ++i) {
                PromptIQueryUtil.processExpression(filter, ((MultipleConditionalExpression)expression).getExpression(i), cascades);
            }
        } else {
            FilterCascadeInterface cascade;
            List prompts = expression.getResources(Prompt.class, 65535);
            if (prompts != null && prompts.size() > 0 && (cascade = PromptIQueryUtil.buildCascadeRule(expression, prompts, filter.getExpression())) != null) {
                cascades.add(cascade);
            }
        }
    }

    private static FilterCascadeInterface buildCascadeRule(ExpressionInterface expression, List prompts, ExpressionInterface mainExpression) {
        MultipleConditionalExpression dependentFilterExpression;
        FilterCascade cascade = null;
        DependentFilter dependentFilter = PromptIQueryUtil.buildDependentFilter(expression, (MultipleConditionalExpression)mainExpression);
        if (dependentFilter != null && (dependentFilterExpression = dependentFilter.getDependentFilterExpression()).getExpressionCount() > 0) {
            for (Prompt prompt : prompts) {
                if (cascade == null) {
                    cascade = new FilterCascade();
                }
                cascade.setBusinessPrompt(prompt);
                cascade.setDependentFilter((CascadableFilter)dependentFilterExpression);
            }
        }
        return cascade;
    }

    private static DependentFilter buildDependentFilter(ExpressionInterface expression, MultipleConditionalExpression parentExpression) {
        DependentFilter dependentFilter = null;
        try {
            MultipleConditionalExpression dependentFilterExpression = (MultipleConditionalExpression)parentExpression.clone();
            dependentFilterExpression.clearExpressions();
            dependentFilter = new DependentFilter();
            dependentFilter.setDependentFilterExpression(dependentFilterExpression);
            int count = parentExpression.getExpressionCount();
            ExpressionInterface currentExpression = null;
            for (int i = 0; i < count; ++i) {
                currentExpression = parentExpression.getExpression(i);
                if (currentExpression instanceof MultipleConditionalExpression) {
                    DependentFilter tempDependentFilter = PromptIQueryUtil.buildDependentFilter(expression, (MultipleConditionalExpression)currentExpression);
                    if (tempDependentFilter.getDependentFilterExpression().getExpressionCount() > 0) {
                        dependentFilterExpression.addExpression((ExpressionInterface)tempDependentFilter.getDependentFilterExpression());
                    }
                    if (!tempDependentFilter.isFinished()) continue;
                    break;
                }
                if (expression.equals(currentExpression)) {
                    dependentFilter.setFinished(true);
                    break;
                }
                dependentFilterExpression.addExpression(currentExpression);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return dependentFilter;
    }

    public static void setupCascades(PromptPropertiesPanelModelInterface model, BusinessQuery query) {
        if (query != null) {
            List filters = query.getFilters();
            for (FilterItem filter : filters) {
                try {
                    PromptIQueryUtil.setupCascadesForFilter(model, filter);
                }
                catch (IllegalStateException ex) {
                    ArrayList<FilterItem> fs = new ArrayList<FilterItem>();
                    fs.add(filter);
                    Collection deps = PromptIQueryUtil.getDependentViewsForFilter(model, filter);
                    for (PromptViewInterface view : deps) {
                        for (FilterItem f : filters) {
                            if (fs.contains(f)) continue;
                            List prompts = f.getPrompts(65535);
                            for (Prompt prompt : prompts) {
                                if (view.getPromptDefinition() != prompt.getPromptDefinition()) continue;
                                fs.add(f);
                            }
                        }
                    }
                    String filterString = null;
                    for (FilterItem f : fs) {
                        if (filterString == null) {
                            filterString = f.getLabel(model.getLocale());
                            continue;
                        }
                        filterString = filterString + "\n" + f.getLabel(model.getLocale());
                    }
                    throw new IllegalStateException(Message.format((String)RB.getStringResource("PromptIQueryUtil.circularDependency.fmt.err.txt", model.getLocale()), filterString));
                }
            }
        }
    }

    public static void setupCascadesForFilter(PromptPropertiesPanelModelInterface model, FilterItem filter) {
        ExpressionInterface expression;
        if (filter != null && (expression = filter.getExpression()) instanceof FilterCascadeContainer) {
            FilterCascadeContainer mce = (FilterCascadeContainer)expression;
            List cascades = mce.getCascades(true);
            for (FilterCascadeInterface filterCascade : cascades) {
                Prompt p = filterCascade.getBusinessPrompt();
                if (p == null) continue;
                PromptDefinitionInterface def = p.getPromptDefinition();
                PromptViewInterface view = PromptUtil.findPromptView((PromptPropertiesPanelModelInterface)model, (PromptDefinitionInterface)def);
                ArrayList<ExpressionInterface> deps = new ArrayList<ExpressionInterface>();
                deps.add(filterCascade.getDependentFilter().getExpression());
                ((DefaultPromptComponentModel)view).setPromptViewFilterList(deps);
                Collection depPrompts = filterCascade.getDependentPrompts();
                if (depPrompts == null) continue;
                DynamicPromptValueContext dpvc = (DynamicPromptValueContext)((PromptComponentModelInterface)view).getDynamicPromptValuesContext();
                List depViews = ListFactory.newList((int)depPrompts.size());
                Iterator iterator2 = depPrompts.iterator();
                while (iterator2.hasNext()) {
                    PromptViewInterface depView = PromptUtil.findPromptView((PromptPropertiesPanelModelInterface)model, (PromptDefinitionInterface)((PromptDefinitionInterface)iterator2.next()));
                    if (depView == null || depViews.contains(depView)) continue;
                    Collection dps = PromptUtil.getAllDependentPrompts((PromptViewInterface)depView, (DynamicPromptValueContextInterface)dpvc, (boolean)true);
                    if (!dps.contains(view)) {
                        depViews.add(depView);
                        continue;
                    }
                    throw new IllegalStateException(RB.getStringResource("PromptIQueryUtil.circularDependency.err.txt", model.getLocale()));
                }
                dpvc.add(view, (Collection)depViews);
            }
        }
    }

    public static Collection getDependentViewsForFilter(PromptPropertiesPanelModelInterface model, FilterItem filter) {
        ExpressionInterface expression;
        if (filter != null && (expression = filter.getExpression()) instanceof FilterCascadeContainer) {
            FilterCascadeContainer mce = (FilterCascadeContainer)expression;
            List cascades = mce.getCascades(true);
            for (FilterCascadeInterface filterCascade : cascades) {
                Prompt p = filterCascade.getBusinessPrompt();
                if (p == null) continue;
                PromptDefinitionInterface def = p.getPromptDefinition();
                Collection depPrompts = filterCascade.getDependentPrompts();
                if (depPrompts == null) continue;
                PromptViewInterface view = PromptUtil.findPromptView((PromptPropertiesPanelModelInterface)model, (PromptDefinitionInterface)def);
                DynamicPromptValueContext dpvc = (DynamicPromptValueContext)((PromptComponentModelInterface)view).getDynamicPromptValuesContext();
                List depViews = ListFactory.newList((int)depPrompts.size());
                Iterator iterator2 = depPrompts.iterator();
                while (iterator2.hasNext()) {
                    PromptViewInterface depView = PromptUtil.findPromptView((PromptPropertiesPanelModelInterface)model, (PromptDefinitionInterface)((PromptDefinitionInterface)iterator2.next()));
                    if (depView == null || depViews.contains(depView)) continue;
                    depViews.add(depView);
                    Collection dps = PromptUtil.getAllDependentPrompts((PromptViewInterface)depView, (DynamicPromptValueContextInterface)dpvc, (boolean)true);
                    for (Object element : dps) {
                        if (depViews.contains(element)) continue;
                        depViews.add(element);
                    }
                }
                return depViews;
            }
        }
        return Collections.EMPTY_LIST;
    }

    private static FilterItem getFilterItem(PromptDefinitionInterface promptDef, DataProviderInterface dp, String filterItemId) throws ServerConnectionException {
        DataItemValueProvider vp;
        BusinessModel bm;
        FilterItem filterItem = null;
        if (promptDef instanceof ValueProviderDefinitionInterface && (bm = (vp = (DataItemValueProvider)((ValueProviderDefinitionInterface)promptDef).getValueProvider()).getDataItem().getBusinessModel()) instanceof InformationMap) {
            filterItem = DataProvider.getFilterItemFromId((InformationMap)bm, filterItemId);
        }
        return filterItem;
    }

    public static void setupFilterCascades(PromptDefinitionInterface promptDef, DataProviderInterface dataProvider, String filterItemId) throws ServerConnectionException {
        FilterItem filter = PromptIQueryUtil.getFilterItem(promptDef, dataProvider, filterItemId);
        ExpressionInterface expression = filter.getExpression();
        if (expression instanceof FilterCascadeContainer) {
            FilterCascadeContainer mce = (FilterCascadeContainer)expression;
            List cascades = mce.getCascades(true);
            for (FilterCascadeInterface filterCascade : cascades) {
                PromptDefinitionInterface iqPromptDef;
                Prompt iqPrompt = filterCascade.getBusinessPrompt();
                if (iqPrompt == null || !(iqPromptDef = iqPrompt.getPromptDefinition()).getPromptID().equals(promptDef.getPromptID())) continue;
                ArrayList<ExpressionInterface> deps = new ArrayList<ExpressionInterface>();
                deps.add(filterCascade.getDependentFilter().getExpression());
                if (!(promptDef instanceof ValueProviderDefinitionInterface)) continue;
                DataItemValueProvider vp = (DataItemValueProvider)((ValueProviderDefinitionInterface)promptDef).getValueProvider();
                vp.setFilterList(deps);
            }
        }
    }

    public static DataSource getDataSource(ValueProviderInterface source) {
        DataSource dataSource = new DataSource();
        if (source != null && source instanceof DynamicValueProviderInterface) {
            String path = null;
            if (source instanceof DataItemValueProvider) {
                path = ((DataItemValueProvider)source).getInfoMapUrl();
                dataSource.setDataSourceLocation(path);
                dataSource.setDataSourceType(4L);
            } else if (source instanceof PromptColumnValueProvider) {
                path = ((PromptColumnValueProvider)source).getTableUrl();
                dataSource.setDataSourceLocation(path);
                dataSource.setDataSourceType(1L);
            }
            if (path != null) {
                // empty if block
            }
        }
        return dataSource;
    }

    public static Search getCascadeCriteria(DynamicValueProviderInterface vp, PromptValuesInterface promptValues, DataSource dataSource, Locale locale) throws PromptValueNotFoundException {
        WhereClause wc = null;
        if (vp instanceof ColumnValueProvider) {
            wc = ((ColumnValueProvider)vp).getWhereClause();
        } else if (vp instanceof RelationalDataItemValueProvider) {
            wc = ((RelationalDataItemValueProvider)vp).getWhereClause();
        }
        if (wc != null) {
            Search search = new Search();
            search.setOperator(SearchOperatorEnum.AND_OPERATOR);
            OperandInterface operand = wc.getCondition();
            if (operand instanceof Expression) {
                search.getSearchCriteriaList().addAll(PromptIQueryUtil.getSearchCriteriaForExpression((Expression)operand, dataSource, promptValues, locale));
            }
            return search;
        }
        return null;
    }

    public static List<QueryItemSearchCriteria> getSearchCriteriaForExpression(Expression exp, DataSource dataSource, PromptValuesInterface promptValues, Locale locale) throws PromptValueNotFoundException {
        ArrayList<QueryItemSearchCriteria> list = new ArrayList<QueryItemSearchCriteria>();
        QueryItem qic = null;
        ArrayList<Object> compareExpression = null;
        List operands = exp.getOperands();
        for (OperandInterface op : operands) {
            if (op instanceof ColumnOperand) {
                ColumnOperand co = (ColumnOperand)op;
                qic = new QueryItem();
                qic.setDataSource(dataSource);
                qic.setUniqueName(co.getColumnName());
                qic.setFormat(co.getFormat());
                continue;
            }
            if (op instanceof PromptValueOperand) {
                PromptValueOperand pvo = (PromptValueOperand)op;
                PromptDefinitionInterface definition = pvo.getPromptDefinition();
                ValueDataTypeEnum vdte = PromptIQueryUtil.convertDataType(definition.getPromptDataType());
                qic.setDataType(vdte);
                if (promptValues == null || !promptValues.isPromptValueAvailable(definition)) continue;
                compareExpression = promptValues.getPromptValue(definition);
                if (compareExpression instanceof List) {
                    List l = compareExpression;
                    ArrayList<Object> rl = new ArrayList<Object>();
                    int cnt = l.size();
                    for (int i = 0; i < cnt; ++i) {
                        Object o = PromptIQueryUtil.getDTOForValue(l.get(i), false, locale);
                        rl.add(o);
                    }
                    compareExpression = rl;
                    continue;
                }
                compareExpression = PromptIQueryUtil.getExpressionDTO(compareExpression);
                continue;
            }
            if (!(op instanceof Expression)) continue;
            list.addAll(PromptIQueryUtil.getSearchCriteriaForExpression((Expression)op, dataSource, promptValues, locale));
        }
        if (qic != null) {
            OperandInterface op;
            QueryItemSearchCriteria sc = new QueryItemSearchCriteria();
            sc.setLeftExpression(qic);
            sc.setRightExpression(compareExpression);
            op = exp.getOperator();
            sc.setOperator(PromptIQueryUtil.searchOperatorForOperatorInterface((OperatorInterface)op));
            list.add(sc);
        }
        return list;
    }

    private static Object getExpressionDTO(Object compareExpression) {
        if (compareExpression instanceof SpecialValues) {
            compareExpression = SpecialValuesDTO.getSpecialValueDTO((SpecialValues)((SpecialValues)compareExpression));
        } else if (compareExpression instanceof MissingValues) {
            compareExpression = MissingValuesDTO.getMissingValuesDTO((MissingValues)((MissingValues)compareExpression));
        } else if (compareExpression instanceof DatePeriod) {
            compareExpression = DatePeriodDTO.getDatePeriodDTO((DatePeriod)((DatePeriod)compareExpression));
        }
        return compareExpression;
    }

    private static Object getDTOForValue(Object value, boolean wrapValue, Locale locale) {
        if (value instanceof SpecialValues) {
            value = SpecialValuesDTO.getSpecialValueDTO((SpecialValues)((SpecialValues)value));
        } else if (value instanceof MissingValues) {
            value = MissingValuesDTO.getMissingValuesDTO((MissingValues)((MissingValues)value));
        } else if (value instanceof DatePeriod) {
            value = DatePeriodDTO.getDatePeriodDTO((DatePeriod)((DatePeriod)value));
        } else if (value instanceof Color) {
            Color c = (Color)value;
            int colorValue = c.getRed() * 65536 + c.getGreen() * 256 + c.getBlue();
            value = colorValue;
        } else if (value instanceof Collection) {
            boolean change = false;
            Object[] newCol = new ArrayList();
            for (Object v : (Collection)value) {
                Object v2 = PromptIQueryUtil.getDTOForValue(v, wrapValue, locale);
                newCol.add(v2);
                if (v2 == v) continue;
                change = true;
            }
            if (change) {
                value = newCol;
            }
        } else if (value instanceof Object[]) {
            Object[] newArray = new Object[((Object[])value).length];
            for (int i = 0; i < ((Object[])value).length; ++i) {
                newArray[i] = PromptIQueryUtil.getDTOForValue(value[i], wrapValue, locale);
            }
            value = newArray;
        }
        return value;
    }

    public static String getSortDirectionForDI(@NotNull RelationalDataItemValueProvider vp, boolean isValueColumn) {
        String sortDirection = "";
        String sortFirst = vp.getSortFirst();
        if (Util.equal((Object)sortFirst, (Object)"Label_Value") && !isValueColumn) {
            sortDirection = vp.getSortOrder();
        } else if (Util.equal((Object)sortFirst, (Object)"Value_Label") && isValueColumn) {
            sortDirection = vp.getSortOrder();
        }
        return sortDirection;
    }

    public static List<ValueItem> convertResults(List<ColumnValueItem> result) {
        ArrayList<ValueItem> retVal = new ArrayList<ValueItem>();
        if (null != result && !result.isEmpty()) {
            List values = result.get(result.size() - 1).getRowData();
            List labels = Collections.emptyList();
            if (result.size() == 2) {
                labels = result.get(0).getRowData();
            }
            int i = 0;
            for (i = 0; i < values.size(); ++i) {
                Object label;
                ValueItem item = new ValueItem();
                item.setValue(values.get(i));
                if (labels.size() > i && (label = labels.get(i)) instanceof String) {
                    item.setLabel((String)label);
                }
                retVal.add(item);
            }
        }
        return retVal;
    }

    public static ValueProviderException convertedValueProviderException(ValueRetrieverExceptionHolder e) {
        ValueRetrieverException vpe = e.getValueRetrieverException();
        ValueProviderException retVal = new ValueProviderException(vpe.getMessage());
        return retVal;
    }

    public static String convert2Enum(@NotNull String operator) {
        if (operator.equals("CONTAINS")) {
            return "CONTAINS_OPERATOR";
        }
        if (operator.equals("EQUAL")) {
            return "EQUAL_OPERATOR";
        }
        if (operator.equals("STARTS WITH")) {
            return "STARTS_WITH_OPERATOR";
        }
        if (operator.equals("ENDS WITH")) {
            return "ENDS_WITH_OPERATOR";
        }
        if (operator.equals("MATCH PATTERN")) {
            return operator;
        }
        if (operator.equals("OPERATOR_NOT_EQUAL")) {
            return "NOT_EQUAL_OPERATOR";
        }
        if (operator.equals("OPERATOR_NOT_CONTAINS")) {
            return "NOT_CONTAINS_OPERATOR";
        }
        return null;
    }

    public static SearchOperatorEnum searchOperatorForOperatorInterface(OperatorInterface op) {
        if (op instanceof FormattedOperator) {
            return PromptIQueryUtil.convertFormattedOperator((FormattedOperator)op);
        }
        if (op instanceof MultiValueFormattedOperator) {
            return PromptIQueryUtil.convertMultiValueFormattedOperator((MultiValueFormattedOperator)op);
        }
        return null;
    }

    private static SearchOperatorEnum convertFormattedOperator(FormattedOperator op) {
        if (op == FormattedOperator.LIKE_OPERATOR) {
            return SearchOperatorEnum.LIKE_OPERATOR;
        }
        if (op == FormattedOperator.BETWEEN_OPERATOR) {
            return SearchOperatorEnum.BETWEEN_OPERATOR;
        }
        if (op == FormattedOperator.NOT_BETWEEN_OPERATOR) {
            return SearchOperatorEnum.NOT_BETWEEN_OPERATOR;
        }
        if (op == FormattedOperator.BETWEEN_OPERATOR_EXCLUSIVE) {
            return SearchOperatorEnum.BETWEEN_OPERATOR_EXCLUSIVE;
        }
        if (op == FormattedOperator.NOT_BETWEEN_OPERATOR_INCLUSIVE) {
            return SearchOperatorEnum.NOT_BETWEEN_OPERATOR_INCLUSIVE;
        }
        if (op == FormattedOperator.IS_NULL_OPERATOR) {
            return SearchOperatorEnum.IS_NULL_OPERATOR;
        }
        if (op == FormattedOperator.AND_OPERATOR) {
            return SearchOperatorEnum.AND_OPERATOR;
        }
        if (op == FormattedOperator.OR_OPERATOR) {
            return SearchOperatorEnum.OR_OPERATOR;
        }
        if (op == FormattedOperator.LESS_THAN_OPERATOR) {
            return SearchOperatorEnum.LESS_THAN_OPERATOR;
        }
        if (op == FormattedOperator.GREATER_THAN_OPERATOR) {
            return SearchOperatorEnum.GREATER_THAN_OPERATOR;
        }
        if (op == FormattedOperator.LESS_THAN_EQUAL_OPERATOR) {
            return SearchOperatorEnum.LESS_THAN_EQUAL_OPERATOR;
        }
        if (op == FormattedOperator.GREATER_THAN_EQUAL_OPERATOR) {
            return SearchOperatorEnum.GREATER_THAN_EQUAL_OPERATOR;
        }
        if (op == FormattedOperator.NOT_EQUAL_OPERATOR) {
            return SearchOperatorEnum.NOT_EQUAL_OPERATOR;
        }
        if (op == FormattedOperator.CONTAINS_OPERATOR) {
            return SearchOperatorEnum.CONTAINS_OPERATOR;
        }
        if (op == FormattedOperator.LESS_THAN_DATE_START_OPERATOR) {
            return SearchOperatorEnum.LESS_THAN_DATE_START_OPERATOR;
        }
        if (op == FormattedOperator.GREATER_THAN_EQUAL_DATE_START_OPERATOR) {
            return SearchOperatorEnum.GREATER_THAN_EQUAL_DATE_START_OPERATOR;
        }
        if (op == FormattedOperator.GREATER_THAN_DATE_END_OPERATOR) {
            return SearchOperatorEnum.GREATER_THAN_DATE_END_OPERATOR;
        }
        if (op == FormattedOperator.NOT_OPERATOR) {
            return SearchOperatorEnum.NOT_OPERATOR;
        }
        if (op == FormattedOperator.ANY_OPERATOR) {
            return SearchOperatorEnum.ANY_OPERATOR;
        }
        if (op == FormattedOperator.ALL_OPERATOR) {
            return SearchOperatorEnum.ALL_OPERATOR;
        }
        if (op == FormattedOperator.SOME_OPERATOR) {
            return SearchOperatorEnum.SOME_OPERATOR;
        }
        if (op == FormattedOperator.IN_OPERATOR) {
            return SearchOperatorEnum.IN_OPERATOR;
        }
        if (op == FormattedOperator.AVG_OPERATOR) {
            return SearchOperatorEnum.AVG_OPERATOR;
        }
        if (op == FormattedOperator.PUT_OPERATOR) {
            return SearchOperatorEnum.PUT_OPERATOR;
        }
        if (op == FormattedOperator.UPCASE_OPERATOR) {
            return SearchOperatorEnum.UPCASE_OPERATOR;
        }
        if (op == FormattedOperator.TRIM_OPERATOR) {
            return SearchOperatorEnum.TRIM_OPERATOR;
        }
        return SearchOperatorEnum.EQUAL_OPERATOR;
    }

    private static SearchOperatorEnum convertMultiValueFormattedOperator(MultiValueFormattedOperator op) {
        if (op == MultiValueFormattedOperator.LIKE_OPERATOR) {
            return SearchOperatorEnum.LIKE_OPERATOR;
        }
        if (op == MultiValueFormattedOperator.LESS_THAN_OPERATOR) {
            return SearchOperatorEnum.LESS_THAN_OPERATOR;
        }
        if (op == MultiValueFormattedOperator.GREATER_THAN_OPERATOR) {
            return SearchOperatorEnum.GREATER_THAN_OPERATOR;
        }
        if (op == MultiValueFormattedOperator.LESS_THAN_EQUAL_OPERATOR) {
            return SearchOperatorEnum.LESS_THAN_EQUAL_OPERATOR;
        }
        if (op == MultiValueFormattedOperator.GREATER_THAN_EQUAL_OPERATOR) {
            return SearchOperatorEnum.GREATER_THAN_EQUAL_OPERATOR;
        }
        if (op == MultiValueFormattedOperator.NOT_EQUAL_OPERATOR) {
            return SearchOperatorEnum.NOT_EQUAL_OPERATOR;
        }
        if (op == MultiValueFormattedOperator.CONTAINS_OPERATOR) {
            return SearchOperatorEnum.CONTAINS_OPERATOR;
        }
        if (op == MultiValueFormattedOperator.DATE_EQUAL_OPERATOR) {
            return SearchOperatorEnum.DATE_EQUAL_OPERATOR;
        }
        if (op == MultiValueFormattedOperator.DATE_LESS_THAN_OPERATOR) {
            return SearchOperatorEnum.DATE_LESS_THAN_OPERATOR;
        }
        if (op == MultiValueFormattedOperator.DATE_GREATER_THAN_OPERATOR) {
            return SearchOperatorEnum.DATE_GREATER_THAN_OPERATOR;
        }
        if (op == MultiValueFormattedOperator.DATE_LESS_THAN_EQUAL_OPERATOR) {
            return SearchOperatorEnum.DATE_LESS_THAN_EQUAL_OPERATOR;
        }
        if (op == MultiValueFormattedOperator.DATE_GREATER_THAN_EQUAL_OPERATOR) {
            return SearchOperatorEnum.DATE_GREATER_THAN_EQUAL_OPERATOR;
        }
        if (op == MultiValueFormattedOperator.DATE_NOT_EQUAL_OPERATOR) {
            return SearchOperatorEnum.DATE_NOT_EQUAL_OPERATOR;
        }
        return SearchOperatorEnum.EQUAL_OPERATOR;
    }

    public static String prettyPrintGetValuesAsListParameters(@NotNull GetValuesAsListParameters params) {
        String sep = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        if (null != params) {
            builder.append("GetValuesAsListParameters contains... ").append(sep);
            builder.append("Locale: ").append(params.getLocale()).append(sep);
            builder.append("Index: ").append(params.getIndex()).append(sep);
            builder.append("Count: ").append(params.getCount()).append(sep);
        }
        if (null != params.getValueRetrieverConfiguration() && params.getValueRetrieverConfiguration() instanceof DynamicValueRetrieverConfiguration) {
            builder.append(PromptIQueryUtil.prettyPrintQueryProperties((DynamicValueRetrieverConfiguration)params.getValueRetrieverConfiguration()));
            for (QueryItem item : ((DynamicValueRetrieverConfiguration)params.getValueRetrieverConfiguration()).getQueryItems()) {
                builder.append(PromptIQueryUtil.prettyPrintQueryItem(item));
            }
        }
        return builder.toString();
    }

    private static Object prettyPrintQueryProperties(DynamicValueRetrieverConfiguration dynamicValueRetrieverConfiguration) {
        List qp;
        String sep = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append("Query Properties...").append(sep);
        if (null != dynamicValueRetrieverConfiguration && null != (qp = dynamicValueRetrieverConfiguration.getQueryProperties())) {
            for (QueryProperty prop : qp) {
                builder.append(prop.getName()).append("--").append(prop.getValue()).append(sep);
            }
        }
        return builder.toString();
    }

    private static String prettyPrintQueryItemSearchCriteria(@NotNull QueryItemSearchCriteria params) {
        String sep = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append("QueryItemSearchCriteria...").append(sep);
        if (null != params.getLeftExpression()) {
            builder.append("Left Expression... ").append(sep);
            QueryItem item = params.getLeftExpression();
            builder.append(PromptIQueryUtil.prettyPrintQueryItem(item));
        }
        if (null != params.getOperator()) {
            builder.append("Operator: ").append(params.getOperator().toString()).append(sep);
        }
        if (null != params.getRightExpression()) {
            builder.append("Right Expression: ").append(params.getRightExpression().toString()).append(sep);
        }
        builder.append("Case Sensitive? ").append(params.isCaseSensitive()).append(sep);
        return builder.toString();
    }

    private static String prettyPrintQueryItem(@NotNull QueryItem params) {
        String sep = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append("QueryItem...").append(sep);
        builder.append("Name ").append(params.getUniqueName()).append(sep);
        if (null != params.getDataSource()) {
            DataSource item = params.getDataSource();
            builder.append("Data Source location: ").append(item.getDataSourceLocation()).append(sep);
            builder.append("Data Source type: ").append(item.getDataSourceType()).append(sep);
        }
        if (null != params.getDataType()) {
            builder.append("Data type: ").append(params.getDataType().toString()).append(sep);
        }
        if (null != params.getFormat()) {
            builder.append("Format: ").append(params.getFormat()).append(sep);
        }
        builder.append("Label: ").append(params.getLabel()).append(sep);
        builder.append("Sort direction: ").append(params.getSortDirection()).append(sep);
        builder.append("VR config ID: ").append(params.getVRConfigId()).append(sep);
        return builder.toString();
    }

    public static String prettyPrintGetMultiSearchValuesAsListParameters(@NotNull GetValuesAsListParameters params) {
        String sep = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        if (null != params) {
            builder.append("GetMultiSearchValuesAsListParameters contains... ").append(sep);
            builder.append("Locale: ").append(params.getLocale()).append(sep);
            builder.append("Index: ").append(params.getIndex()).append(sep);
            builder.append("Count: ").append(params.getCount()).append(sep);
            if (null != params.getValueRetrieverConfiguration() && params.getValueRetrieverConfiguration() instanceof DynamicValueRetrieverConfiguration) {
                DynamicValueRetrieverConfiguration dyrConfig = (DynamicValueRetrieverConfiguration)params.getValueRetrieverConfiguration();
                if (null != dyrConfig.getSearch()) {
                    builder.append(PromptIQueryUtil.prettyPrintSearch(dyrConfig.getSearch()));
                }
                builder.append(PromptIQueryUtil.prettyPrintQueryProperties(dyrConfig));
                for (QueryItem item : dyrConfig.getQueryItems()) {
                    builder.append(PromptIQueryUtil.prettyPrintQueryItem(item));
                }
            }
        }
        return builder.toString();
    }

    public static String prettyPrintGetValuesAsTreeParameters(@NotNull GetValuesAsTreeParameters params) {
        String sep = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        if (null != params) {
            builder.append("GetValuesAsTreeParameters contains... ").append(sep);
            builder.append("Locale: ").append(params.getLocale()).append(sep);
            if (null != params.getValueRetrieverConfiguration() && params.getValueRetrieverConfiguration() instanceof DynamicValueRetrieverConfiguration) {
                builder.append(PromptIQueryUtil.prettyPrintQueryProperties((DynamicValueRetrieverConfiguration)params.getValueRetrieverConfiguration()));
                for (QueryItem item : ((DynamicValueRetrieverConfiguration)params.getValueRetrieverConfiguration()).getQueryItems()) {
                    builder.append(PromptIQueryUtil.prettyPrintQueryItem(item));
                }
            }
        }
        return builder.toString();
    }

    private static String prettyPrintSearch(Search search) {
        String sep = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append("Search...").append(sep);
        if (null != search) {
            builder.append(search.getOperator()).append(sep);
            if (!search.getSearchCriteriaList().isEmpty()) {
                for (QueryItemSearchCriteria searchC : search.getSearchCriteriaList()) {
                    builder.append(PromptIQueryUtil.prettyPrintQueryItemSearchCriteria(searchC));
                }
            }
        }
        return builder.toString();
    }

    public static MetadataTreeModel convertResultsToTree(List<MetadataTreeNode> result) {
        ConvenientMetadataEntityTreeNode root = new ConvenientMetadataEntityTreeNode();
        root.setName(" ");
        ConvenientMetadataEntityTreeNode node = null;
        for (MetadataTreeNode dtn : result) {
            node = new ConvenientMetadataEntityTreeNode();
            PromptIQueryUtil.populateTreeNode(node, dtn);
            root.add((MutableTreeNode)((Object)node));
        }
        return new MetadataTreeModel((MetadataEntityTreeNode)root);
    }

    private static void populateTreeNode(ConvenientMetadataEntityTreeNode node, MetadataTreeNode dtn) {
        List list;
        if (null != node) {
            node.setName(dtn.getLabel());
        }
        if (null != (list = dtn.getChildren()) && !list.isEmpty()) {
            for (MetadataTreeNode subDtn : list) {
                ConvenientMetadataEntityTreeNode subNode = new ConvenientMetadataEntityTreeNode();
                PromptIQueryUtil.populateTreeNode(subNode, subDtn);
                node.add((MutableTreeNode)((Object)subNode));
            }
        }
    }

    public static QueryItemSearchCriteria newQueryItemSearchCriteria(@NotNull SearchCriteria searchCriteria, @NotNull List<QueryItem> list) {
        QueryItemSearchCriteria qisc = new QueryItemSearchCriteria();
        qisc.setOperator(SearchOperatorEnum.valueOf((String)PromptIQueryUtil.convert2Enum((String)searchCriteria.getOperator())));
        qisc.setRightExpression((Object)searchCriteria.getTextToMatch());
        if (list.size() >= 1) {
            QueryItem item = list.get(0);
            qisc.setLeftExpression(item);
        }
        return qisc;
    }

    private static ValueDataTypeEnum convertDataType(DataTypeInterface dt) {
        if (dt instanceof DoubleType) {
            return ValueDataTypeEnum.NUMBER;
        }
        if (dt instanceof IntegerType) {
            return ValueDataTypeEnum.NUMBER;
        }
        if (dt instanceof DateType) {
            return ValueDataTypeEnum.DATE;
        }
        if (dt instanceof StringType) {
            return ValueDataTypeEnum.STRING;
        }
        return null;
    }

    public static void promptsFromExpression(Expression exp, List<PromptDefinitionInterface> prompts) {
        List operands = exp.getOperands();
        for (OperandInterface e : operands) {
            if (e instanceof Expression) {
                PromptIQueryUtil.promptsFromExpression((Expression)e, prompts);
                continue;
            }
            if (!(e instanceof PromptValueOperand)) continue;
            prompts.add(((PromptValueOperand)e).getPromptDefinition());
        }
    }

    private static class DependentFilter {
        private MultipleConditionalExpression dependentFilterExpression = null;
        private boolean isFinished = false;

        public void setDependentFilterExpression(MultipleConditionalExpression dependentFilterExpression) {
            this.dependentFilterExpression = dependentFilterExpression;
        }

        public MultipleConditionalExpression getDependentFilterExpression() {
            return this.dependentFilterExpression;
        }

        public void setFinished(boolean isFinished) {
            this.isFinished = isFinished;
        }

        public boolean isFinished() {
            return this.isFinished;
        }
    }
}

