/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.util.iquery;

import com.sas.MissingValues;
import com.sas.datatypes.DataTypeInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.models.FileLocationInterface;
import com.sas.models.OLAPMemberNameInterface;
import com.sas.models.SASLibraryLocationInterface;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.MemberValueValidatorInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.SimplePromptValueValidator;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.DataSourceColumnDefinitionInterface;
import com.sas.prompts.definitions.DataSourceDefinitionInterface;
import com.sas.prompts.definitions.FileSelectionInterface;
import com.sas.prompts.definitions.OLAPMemberNameDefinitionInterface;
import com.sas.prompts.definitions.OutputFileDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SASLibraryDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.util.iquery.DataSourceUtil;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.prompt.UserContextEnabledObject;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.valueprovider.AllowUserValuesInterface;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueType;
import com.sas.util.SupportedSpecialValuesInterface;
import com.sas.util.ValueItem;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class DynamicPromptValueValidator
extends SimplePromptValueValidator {
    private DynamicPromptValueContextInterface context;
    private int maxRowsToSearch;
    private int searchRowCount;

    public DynamicPromptValueValidator() {
        this(null, Locale.US);
    }

    public DynamicPromptValueValidator(DynamicPromptValueContextInterface context, Locale locale) {
        super(locale);
        this.context = context;
        this.maxRowsToSearch = -1;
        this.searchRowCount = -1;
    }

    public int getMaxRowsToSearch() {
        return this.maxRowsToSearch;
    }

    public void setMaxRowsToSearch(int maxRowsToSearch) {
        this.maxRowsToSearch = maxRowsToSearch;
    }

    public int getSearchRowCount() {
        return this.searchRowCount;
    }

    public void setSearchRowCount(int searchRowCount) {
        if (searchRowCount < 0 && searchRowCount != -1) {
            throw new IllegalArgumentException();
        }
        this.searchRowCount = searchRowCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateValue(PromptDefinitionInterface definition, Object value) throws InvalidPromptValueException {
        super.validateValue(definition, value);
        if (!PromptUtil.isPromptValuesEqual((Object)value, null)) {
            try {
                UserContextInterface uc;
                if (definition instanceof FileSelectionInterface) {
                    PromptDataProviderInterface pdp;
                    DataProviderInterface dataprovider;
                    if (!(definition instanceof OutputFileDefinitionInterface) && this.context != null && (dataprovider = this.context.getDataProvider()) instanceof PromptDataProviderInterface && !DataSourceUtil.isExistingFile((pdp = (PromptDataProviderInterface)dataprovider).getIWorkspace(((FileLocationInterface)value).getServerName()), ((FileLocationInterface)value).getFileLocation())) {
                        throw new InvalidPromptValueException(definition, value, this.locale, null);
                    }
                } else if (definition instanceof SASLibraryDefinitionInterface) {
                    if (this.context != null && this.context.getDataProvider() instanceof UserContextEnabledObject && DataSourceUtil.getSASLibrary(uc = ((UserContextEnabledObject)this.context.getDataProvider()).getUserContext(), ((SASLibraryLocationInterface)value).getSASLibraryLocation()) == null) {
                        throw new InvalidPromptValueException(definition, value, this.locale, null);
                    }
                } else if (definition instanceof DataSourceDefinitionInterface) {
                    if (this.context != null && this.context.getDataProvider() instanceof UserContextEnabledObject && DataSourceUtil.getDataSource(uc = ((UserContextEnabledObject)this.context.getDataProvider()).getUserContext(), ((DataSourceInterface)value).getDataSourceLocation()) == null) {
                        throw new InvalidPromptValueException(definition, value, this.locale, null);
                    }
                } else if (definition instanceof DataSourceColumnDefinitionInterface && this.context != null && this.context.getDataProvider() instanceof PromptDataProviderInterface) {
                    uc = ((UserContextEnabledObject)this.context.getDataProvider()).getUserContext();
                    if (value instanceof Collection) {
                        Collection col = (Collection)value;
                        for (DataSourceColumnInterface dsc : col) {
                            this.validateDataSourceColumn(dsc, uc, (PromptDataProviderInterface)this.context.getDataProvider(), definition);
                        }
                    } else {
                        this.validateDataSourceColumn((DataSourceColumnInterface)value, uc, (PromptDataProviderInterface)this.context.getDataProvider(), definition);
                    }
                }
            }
            catch (ServiceException ex) {
                ArrayList<ValidationEntry> errorList = new ArrayList<ValidationEntry>(1);
                errorList.add(new ValidationEntry(0L, ex.getMessage()));
                throw new InvalidPromptValueException(definition, value, this.locale, errorList);
            }
            catch (RemoteException e) {
                ArrayList<ValidationEntry> errorList = new ArrayList<ValidationEntry>(1);
                errorList.add(new ValidationEntry(0L, e.getMessage()));
                throw new InvalidPromptValueException(definition, value, this.locale, errorList);
            }
            catch (IllegalArgumentException e) {
                ArrayList<ValidationEntry> errorList = new ArrayList<ValidationEntry>(1);
                errorList.add(new ValidationEntry(0L, e.getMessage()));
                throw new InvalidPromptValueException(definition, value, this.locale, errorList);
            }
            catch (ServerConnectionException e) {
                ArrayList<ValidationEntry> errorList = new ArrayList<ValidationEntry>(1);
                errorList.add(new ValidationEntry(0L, e.getMessage()));
                throw new InvalidPromptValueException(definition, value, this.locale, errorList);
            }
            catch (MetadataException e) {
                ArrayList<ValidationEntry> errorList = new ArrayList<ValidationEntry>(1);
                errorList.add(new ValidationEntry(0L, e.getMessage()));
                throw new InvalidPromptValueException(definition, value, this.locale, errorList);
            }
        }
        if (definition instanceof AllowUserValuesInterface && ((AllowUserValuesInterface)definition).isAllowUserValues()) {
            return;
        }
        if (value == null) {
            if (!definition.isRequired()) return;
            throw new InvalidPromptValueException(definition, value, this.locale, null);
        }
        boolean specialValueSupported = true;
        if (definition instanceof SupportedSpecialValuesInterface) {
            if (((SupportedSpecialValuesInterface)definition).getSupportedSpecialValues().isMissingValuesSupported()) {
                if (value instanceof Collection) {
                    ArrayList newValue = null;
                    for (Object v1 : (Collection)value) {
                        if (!(v1 instanceof MissingValues)) continue;
                        if (newValue == null) {
                            newValue = new ArrayList();
                            newValue.addAll((Collection)value);
                        }
                        newValue.remove(v1);
                    }
                    if (newValue != null) {
                        value = newValue;
                    }
                } else if (value instanceof MissingValues) {
                    return;
                }
            }
            if (value instanceof Collection && ((Collection)value).size() == 1 ? (specialValueSupported = ((SupportedSpecialValuesInterface)definition).getSupportedSpecialValues().isValueSupported(((Collection)value).iterator().next())) : (specialValueSupported = ((SupportedSpecialValuesInterface)definition).getSupportedSpecialValues().isValueSupported(value))) {
                return;
            }
        }
        if (definition instanceof ValueProviderDefinitionInterface) {
            ValueProviderInterface valueProvider = ((ValueProviderDefinitionInterface)definition).getValueProvider();
            if (valueProvider == null) throw new InvalidPromptValueException(definition, value, this.locale, null);
            if (valueProvider instanceof AllowUserValuesInterface && ((AllowUserValuesInterface)valueProvider).isAllowUserValues()) {
                return;
            }
            if (!(definition instanceof OLAPMemberNameDefinitionInterface ? !this.isValidTreeValue(definition, value) : !this.isValidListValue(definition, value))) return;
            throw new InvalidPromptValueException(definition, value, this.locale, null);
        }
        if (specialValueSupported) return;
        throw new InvalidPromptValueException(definition, value, this.locale, null);
    }

    private void validateDataSourceColumn(DataSourceColumnInterface dsc, UserContextInterface uc, PromptDataProviderInterface pdp, PromptDefinitionInterface definition) throws InvalidPromptValueException, ServiceException, RemoteException, IllegalArgumentException, ServerConnectionException, MetadataException {
        if (DataSourceUtil.getDataSource(uc, dsc.getDataSource().getDataSourceLocation()) == null) {
            throw new InvalidPromptValueException(definition, (Object)dsc, this.locale, null);
        }
        if (DataSourceUtil.getColumnType(uc, pdp, dsc.getDataSource(), dsc.getColumnName()) == -1L) {
            throw new InvalidPromptValueException(definition, (Object)dsc, this.locale, null);
        }
    }

    public boolean isValidListValue(PromptDefinitionInterface definition, Object value) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        if (value instanceof List) {
            valueList.addAll((List)value);
        } else {
            valueList.add(value);
        }
        ValueProviderInterface valueProvider = ((ValueProviderDefinitionInterface)definition).getValueProvider();
        try {
            int count = 100;
            if (this.getSearchRowCount() != -1) {
                count = this.getSearchRowCount();
            }
            int index = 0;
            boolean done = false;
            while (!done) {
                List values = null;
                if (valueProvider instanceof DynamicValueProviderInterface) {
                    if (this.context == null) {
                        return true;
                    }
                    DynamicValueProviderInterface dynamicValueProvider = (DynamicValueProviderInterface)valueProvider;
                    values = (List)dynamicValueProvider.getValues(this.locale, this.context, ValueType.LIST, index, count);
                } else {
                    values = (List)valueProvider.getValues(this.locale, ValueType.LIST, index, count);
                }
                Iterator i = valueList.iterator();
                while (i.hasNext()) {
                    Object singleValue = i.next();
                    if (!this.valueItemListContainsOneValue(definition.getPromptDataType(), values, singleValue)) continue;
                    i.remove();
                }
                index += values.size();
                if (values.size() < count) {
                    done = true;
                }
                if (this.getMaxRowsToSearch() == -1 || index < this.getMaxRowsToSearch()) continue;
                done = true;
            }
        }
        catch (ValueProviderException e) {
            return false;
        }
        return valueList.size() == 0;
    }

    public boolean isValidTreeValue(PromptDefinitionInterface definition, Object value) {
        if (value instanceof Collection) {
            Collection col = (Collection)value;
            for (Object iv : col) {
                if (this.isValidTreeIndividualValue(definition, iv)) continue;
                return false;
            }
            return true;
        }
        return this.isValidTreeIndividualValue(definition, value);
    }

    private boolean isValidTreeIndividualValue(PromptDefinitionInterface definition, Object value) {
        if (!(value instanceof OLAPMemberNameInterface)) {
            return false;
        }
        String uniqueName = ((OLAPMemberNameInterface)value).getUniqueName();
        ValueProviderInterface valueProvider = ((ValueProviderDefinitionInterface)definition).getValueProvider();
        if (valueProvider != null && valueProvider instanceof MemberValueValidatorInterface) {
            if (this.context == null) {
                return true;
            }
            try {
                return ((MemberValueValidatorInterface)valueProvider).isValid(uniqueName, this.context);
            }
            catch (ValueProviderException e) {
                return false;
            }
        }
        return false;
    }

    private boolean valueItemListContainsOneValue(DataTypeInterface dataType, List values, Object value) {
        for (ValueItem item : values) {
            Object itemValue = item.getValue();
            if (!PromptUtil.isPromptValuesEqual((Object)(itemValue = dataType.coerceValue(itemValue, this.locale)), (Object)value, (boolean)true)) continue;
            return true;
        }
        return false;
    }
}

