/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.ranking;

import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.storage.iquery.BusinessQueryAdapter;
import com.sas.storage.olap.OLAPDataSetInterface;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Util {
    public static Map dataItemNames(BusinessQuery dataModel, StructureOfDataItem structureType, Integer expressionType) throws InvalidIDException {
        Map dataItemNames = new HashMap();
        if (dataModel != null && structureType != null && (structureType.equals(StructureOfDataItem.STRUCTURE_COLUMN) || structureType.equals(StructureOfDataItem.STRUCTURE_DIMENSION) || structureType.equals(StructureOfDataItem.STRUCTURE_HIERARCHY) || structureType.equals(StructureOfDataItem.STRUCTURE_LEVEL) || structureType.equals(StructureOfDataItem.STRUCTURE_MEASURE))) {
            dataItemNames = Util.getDataItemNames(dataModel.getResultItems(), structureType, expressionType);
        }
        return dataItemNames;
    }

    public static Map dataItemNames(BusinessQuery dataModel, StructureOfDataItem structureType) throws InvalidIDException {
        return Util.dataItemNames(dataModel, structureType, null);
    }

    public static Map businessModeldataItemNames(BusinessModel dataModel, StructureOfDataItem structureType) throws InvalidIDException {
        Map dataItemNames = new HashMap();
        if (dataModel != null && structureType != null && (structureType.equals(StructureOfDataItem.STRUCTURE_COLUMN) || structureType.equals(StructureOfDataItem.STRUCTURE_DIMENSION) || structureType.equals(StructureOfDataItem.STRUCTURE_HIERARCHY) || structureType.equals(StructureOfDataItem.STRUCTURE_LEVEL) || structureType.equals(StructureOfDataItem.STRUCTURE_MEASURE))) {
            List di = dataModel.getObjects(1, DataItem.class);
            dataItemNames = Util.getDataItemNames(di, structureType);
        }
        return dataItemNames;
    }

    private static Map getDataItemNames(List dataItems, StructureOfDataItem structureType, Integer expressionType) throws InvalidIDException {
        HashMap<String, String> dataItemNames = new HashMap<String, String>();
        if (dataItems != null && structureType != null && (structureType.equals(StructureOfDataItem.STRUCTURE_COLUMN) || structureType.equals(StructureOfDataItem.STRUCTURE_DIMENSION) || structureType.equals(StructureOfDataItem.STRUCTURE_HIERARCHY) || structureType.equals(StructureOfDataItem.STRUCTURE_LEVEL) || structureType.equals(StructureOfDataItem.STRUCTURE_MEASURE))) {
            Iterator iterator = dataItems.iterator();
            DataItem dataItem = null;
            ExpressionInterface expr = null;
            StructureOfDataItem struct = null;
            while (iterator.hasNext()) {
                dataItem = (DataItem)iterator.next();
                if (dataItem == null || expressionType != null && (expr = dataItem.getExpression()) != null && expressionType.intValue() != expr.getExpressionType() || (struct = dataItem.getStructure()) == null || !struct.equals(structureType)) continue;
                dataItemNames.put(dataItem.getLabel(), dataItem.getID());
            }
        }
        return dataItemNames;
    }

    private static Map getDataItemNames(List dataItems, StructureOfDataItem structureType) throws InvalidIDException {
        return Util.getDataItemNames(dataItems, structureType, null);
    }

    public static Map OLAPDataItemNames(BusinessQuery dataModel) throws InvalidIDException {
        return Util.OLAPDataItemNames(dataModel, null);
    }

    public static Map OLAPDataItemNames(BusinessQuery dataModel, DataItemActionType actionType) throws InvalidIDException {
        HashMap<String, String> dataItemNames = new HashMap<String, String>();
        if (dataModel != null) {
            List dataItems = dataModel.getResultItems();
            Iterator iterator = dataItems.iterator();
            DataItem dataItem = null;
            StructureOfDataItem struct = null;
            String dataItemID = null;
            String dataItemLabel = null;
            while (iterator.hasNext()) {
                dataItem = (DataItem)iterator.next();
                if (dataItem == null || (struct = dataItem.getStructure()) == null || !struct.equals(StructureOfDataItem.STRUCTURE_DIMENSION) && !struct.equals(StructureOfDataItem.STRUCTURE_HIERARCHY) && !struct.equals(StructureOfDataItem.STRUCTURE_LEVEL)) continue;
                if (actionType != null) {
                    if (!dataItem.isActionSupported(actionType)) continue;
                    dataItemID = dataItem.getID();
                    dataItemLabel = dataItem.getLabel();
                    dataItemNames.put(dataItemLabel, dataItemID);
                    continue;
                }
                dataItemID = dataItem.getID();
                dataItemLabel = dataItem.getLabel();
                dataItemNames.put(dataItemLabel, dataItemID);
            }
        }
        return dataItemNames;
    }

    public static String getMeasureLabel(BusinessModel dataModel, String measureUniqueName) {
        String label = null;
        if (dataModel != null && measureUniqueName != null) {
            List dataItems = dataModel.getObjects(1, DataItem.class);
            Iterator iterator = dataItems.iterator();
            DataItem dataItem = null;
            ExpressionInterface expr = null;
            StructureOfDataItem struct = null;
            while (iterator.hasNext()) {
                dataItem = (DataItem)iterator.next();
                if (dataItem == null || (struct = dataItem.getStructure()) == null || !struct.equals(StructureOfDataItem.STRUCTURE_MEASURE) || (expr = dataItem.getExpression()) == null || !(expr instanceof Measure)) continue;
                try {
                    if (!measureUniqueName.equalsIgnoreCase(((Measure)expr).getMeasureUniqueName())) continue;
                    label = dataItem.getLabel();
                    break;
                }
                catch (MetadataException metadataException) {
                }
            }
        }
        return label;
    }

    public static boolean isRankSupported(BusinessQueryProviderInterface bqProvider) {
        boolean isRankSupported = false;
        if (bqProvider != null) {
            Map dataItemNames = null;
            BusinessQuery dataModel = bqProvider.getBusinessQuery();
            if (bqProvider instanceof OLAPDataSetInterface) {
                try {
                    dataItemNames = Util.OLAPDataItemNames(dataModel);
                }
                catch (InvalidIDException invalidIDException) {}
            } else if (bqProvider instanceof BusinessQueryAdapter) {
                try {
                    dataItemNames = Util.dataItemNames(dataModel, StructureOfDataItem.STRUCTURE_COLUMN, new Integer(2));
                }
                catch (InvalidIDException invalidIDException) {
                    // empty catch block
                }
            }
            if (dataItemNames != null) {
                Map dataItems = Util.getDataItemsMap(dataModel.getResultItems());
                Iterator dataItemIds = dataItemNames.values().iterator();
                String dataItemId = null;
                DataItem dataItem = null;
                while (dataItemIds.hasNext()) {
                    dataItemId = (String)dataItemIds.next();
                    if (!dataItems.containsKey(dataItemId) || (dataItem = (DataItem)dataItems.get(dataItemId)) == null || !dataItem.isActionSupported(DataItemActionType.STEP_RANK)) continue;
                    isRankSupported = true;
                    break;
                }
            }
        }
        return isRankSupported;
    }

    private static Map getDataItemsMap(List dataItemsList) {
        HashMap<String, DataItem> dataItemsMap = null;
        if (dataItemsList != null) {
            dataItemsMap = new HashMap<String, DataItem>();
            Iterator dataItems = dataItemsList.iterator();
            DataItem dataItem = null;
            while (dataItems.hasNext()) {
                dataItem = (DataItem)dataItems.next();
                if (dataItem == null) continue;
                try {
                    dataItemsMap.put(dataItem.getID(), dataItem);
                }
                catch (InvalidIDException invalidIDException) {}
            }
        }
        return dataItemsMap;
    }

    public static Map getRankEnabledDataItemNames(Collection dataItemIds, BusinessQuery dataModel) {
        HashMap<String, String> rankEnabledDataItemNames = null;
        Map dataItemsMap = null;
        if (dataItemIds != null && dataModel != null) {
            dataItemsMap = Util.getDataItemsMap(dataModel.getResultItems());
            rankEnabledDataItemNames = new HashMap<String, String>();
            Iterator ids = dataItemIds.iterator();
            String id = null;
            DataItem dataItem = null;
            while (ids.hasNext()) {
                id = (String)ids.next();
                if (!dataItemsMap.containsKey(id) || (dataItem = (DataItem)dataItemsMap.get(id)) == null || dataItem.getExpression() instanceof FractionOfTotalExpression || !dataItem.isActionSupported(DataItemActionType.STEP_RANK)) continue;
                rankEnabledDataItemNames.put(dataItem.getLabel(), id);
            }
        }
        return rankEnabledDataItemNames;
    }
}

