/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.ranking;

import com.sas.dataselectors.ranking.BaseRankingSelectorAdapter;
import com.sas.dataselectors.ranking.RelationalRankingSelectorInterface;
import com.sas.dataselectors.ranking.Util;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.step.relational.DataItemRankFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class RelationalRankingSelectorAdapter
extends BaseRankingSelectorAdapter
implements RelationalRankingSelectorInterface {
    private String rankingColumnName;
    private Map rankableColumnNames;

    public RelationalRankingSelectorAdapter() {
        HashMap rankStatuses = this.rankStatuses();
        if (rankStatuses == null) {
            rankStatuses = new HashMap();
            this.rankStatuses(rankStatuses);
        }
    }

    public Map rankableColumnNames() {
        if (this.rankableColumnNames == null && !this.dataModel.getInputStructure().isOLAP()) {
            try {
                this.rankableColumnNames = Util.getRankEnabledDataItemNames(Util.dataItemNames(this.dataModel, StructureOfDataItem.STRUCTURE_COLUMN, new Integer(2)).values(), this.dataModel);
            }
            catch (InvalidIDException invalidIDException) {
                // empty catch block
            }
        }
        return this.rankableColumnNames;
    }

    public void rankingColumnName(String name) {
        this.rankingColumnName = name;
    }

    public String rankingColumnName() {
        return this.rankingColumnName;
    }

    @Override
    public Map rankTypes() {
        HashMap<String, Integer> rankTypes = new HashMap<String, Integer>();
        rankTypes.put(this.bundle.getString(this.RB_KEY + "count.txt"), new Integer(0));
        return rankTypes;
    }

    @Override
    public String dataItemRankStatus(String dataItemID) {
        String rankStatus = null;
        if (dataItemID != null) {
            if (this.valuesFromDataModel()) {
                rankStatus = this.bundle.getString(this.RB_KEY + "noRanking.txt");
                Object filter = this.getRankFilter(dataItemID);
                if (filter instanceof DataItemRankFilter) {
                    String rankOrder = ((DataItemRankFilter)filter).getRankOrder() == 0 ? this.bundle.getString(this.RB_KEY + "topRadio.txt") : this.bundle.getString(this.RB_KEY + "bottomRadio.txt");
                    int rankValue = ((DataItemRankFilter)filter).getValue();
                    boolean isIncludeTies = ((DataItemRankFilter)filter).isIncludeTies();
                    rankStatus = com.sas.swing.visuals.dataselectors.Util.localizeRankStatus((String)rankOrder, (int)rankValue, (String)this.bundle.getString(this.RB_KEY + "count.txt"), (String)(isIncludeTies ? "1" : "0"), null, (Locale)this.getLocale());
                }
            } else {
                Map rankStatuses = this.rankStatuses();
                rankStatus = (String)rankStatuses.get(dataItemID);
            }
        }
        return rankStatus;
    }

    @Override
    protected void initDataItems() {
        Map map = null;
        try {
            map = Util.dataItemNames(this.dataModel(), StructureOfDataItem.STRUCTURE_COLUMN);
        }
        catch (InvalidIDException invalidIDException) {
            // empty catch block
        }
        HashMap dataItems = new HashMap();
        HashMap<String, Object> attribs = null;
        String dataItemID = null;
        Integer rankOrder = null;
        Integer rankValue = null;
        Integer rankType = null;
        Boolean ties = null;
        String desc = null;
        Iterator iterator = map.values().iterator();
        Iterator it2 = map.keySet().iterator();
        while (iterator.hasNext()) {
            desc = it2.hasNext() ? (String)it2.next() : null;
            dataItemID = (String)iterator.next();
            attribs = new HashMap<String, Object>();
            Object lastStep = this.getRankFilter(dataItemID);
            if (lastStep instanceof DataItemRankFilter) {
                rankOrder = new Integer(((DataItemRankFilter)lastStep).getRankOrder());
                rankValue = new Integer(((DataItemRankFilter)lastStep).getValue());
                rankType = new Integer(((DataItemRankFilter)lastStep).getRankType());
                ties = new Boolean(((DataItemRankFilter)lastStep).isIncludeTies());
            }
            attribs.put("desc", desc);
            attribs.put("rankOrder", rankOrder);
            attribs.put("rankValue", rankValue);
            attribs.put("rankType", rankType);
            attribs.put("ties", ties);
            dataItems.put(dataItemID, attribs);
        }
        this.dataItems(dataItems);
    }

    @Override
    public int countRankTypeValue() {
        return super.countRankTypeValue();
    }

    @Override
    public void setIncludeTies(String isIncludeTies) {
        super.setIncludeTies(isIncludeTies);
    }
}

