/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.ranking;

import com.sas.dataselectors.ranking.BaseRankingSelectorAdapter;
import com.sas.dataselectors.ranking.OLAPRankingSelectorInterface;
import com.sas.dataselectors.ranking.Util;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.step.olap.DataItemRankFilter;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.util.Strings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OLAPRankingSelectorAdapter
extends BaseRankingSelectorAdapter
implements OLAPRankingSelectorInterface {
    private String rankingMeasureName;
    private String rankingLevelName;
    private Map rankableMeasureNames;
    private Map businessModelMeasuresMapping;
    private Map rankableLevelNames;

    public OLAPRankingSelectorAdapter() {
        HashMap rankStatuses = this.rankStatuses();
        if (rankStatuses == null) {
            rankStatuses = new HashMap();
            this.rankStatuses(rankStatuses);
        }
    }

    public String rankingMeasureName() {
        return this.rankingMeasureName;
    }

    public String rankingLevelName() {
        return this.rankingLevelName;
    }

    public Map rankableLevelNames() {
        if (this.rankableLevelNames == null && this.dataModel.getInputStructure().isOLAP()) {
            try {
                this.rankableLevelNames = Util.OLAPDataItemNames(this.dataModel, DataItemActionType.STEP_RANK);
            }
            catch (InvalidIDException invalidIDException) {
                // empty catch block
            }
        }
        return this.rankableLevelNames;
    }

    public Map rankableMeasureNames() {
        if (this.rankableMeasureNames == null && this.dataModel.getInputStructure().isOLAP()) {
            this.rankableMeasureNames = new HashMap();
            this.businessModelMeasuresMapping = new HashMap();
            Map virginMeasures = null;
            try {
                virginMeasures = Util.businessModeldataItemNames(this.dataModel.getBusinessModel(), StructureOfDataItem.STRUCTURE_MEASURE);
            }
            catch (InvalidIDException invalidIDException) {
                // empty catch block
            }
            if (virginMeasures != null) {
                for (String measureDesc : virginMeasures.keySet()) {
                    String newId = new Long(com.sas.util.Util.getNumber()).toString();
                    HashMap measureAttrs = new HashMap();
                    measureAttrs.put("MEASURE_ID", virginMeasures.get(measureDesc));
                    measureAttrs.put("MEASURE_LABEL", measureDesc);
                    this.businessModelMeasuresMapping.put(newId, measureAttrs);
                    this.rankableMeasureNames.put(measureDesc, newId);
                }
            }
        }
        return this.rankableMeasureNames;
    }

    public void rankingMeasureName(String measureName) {
        this.rankingMeasureName = measureName;
    }

    public void rankingLevelName(String levelName) {
        this.rankingLevelName = levelName;
    }

    @Override
    public Map rankTypes() {
        HashMap<String, Integer> rankTypes = new HashMap<String, Integer>();
        rankTypes.put(this.bundle.getString(this.RB_KEY + "count.txt"), new Integer(0));
        rankTypes.put(this.bundle.getString(this.RB_KEY + "percent.txt"), new Integer(1));
        rankTypes.put(this.bundle.getString(this.RB_KEY + "sum.txt"), new Integer(2));
        return rankTypes;
    }

    @Override
    public String dataItemRankStatus(String dataItemID) {
        String rankStatus = null;
        if (dataItemID != null) {
            if (this.valuesFromDataModel()) {
                DataItem basedOnMeasureDataItem;
                List byRankNames;
                rankStatus = this.bundle.getString(this.RB_KEY + "noRanking.txt");
                Object filter = this.getRankFilter(dataItemID);
                if (filter instanceof DataItemRankFilter && (byRankNames = ((DataItemRankFilter)filter).getRankQualifiers()) != null && (basedOnMeasureDataItem = (DataItem)byRankNames.get(0)) != null) {
                    String basedOnMeasureDataItemID = null;
                    try {
                        basedOnMeasureDataItemID = basedOnMeasureDataItem.getID();
                    }
                    catch (InvalidIDException invalidIDException) {
                        // empty catch block
                    }
                    if (basedOnMeasureDataItemID != null) {
                        int nWhereClauses;
                        String localizedBasedOnMeasureDesc = this.getMeasureLabel(basedOnMeasureDataItemID);
                        int n = nWhereClauses = byRankNames.size() - 1 > 5 ? 5 : byRankNames.size() - 1;
                        if (nWhereClauses > 0) {
                            String[] whereClauses = new String[nWhereClauses];
                            for (int i = 0; i < nWhereClauses; ++i) {
                                try {
                                    whereClauses[i] = ((StringExpression)byRankNames.get(i + 1)).getText();
                                    continue;
                                }
                                catch (MetadataException metadataException) {
                                    // empty catch block
                                }
                            }
                            String[] dataItemsLabels = new String[whereClauses.length];
                            for (int k = 0; k < whereClauses.length; ++k) {
                                dataItemsLabels[k] = new Integer(k).toString();
                            }
                            String[] localizedWhereClauses = null;
                            if (dataItemsLabels != null) {
                                localizedWhereClauses = new String[nWhereClauses];
                                for (int i = 0; i < dataItemsLabels.length; ++i) {
                                    localizedWhereClauses[i] = this.getWhereValue(whereClauses[i]);
                                }
                            }
                            localizedBasedOnMeasureDesc = com.sas.swing.visuals.dataselectors.Util.localizeBasedOnMeasureDesc((String)localizedBasedOnMeasureDesc, (String[])localizedWhereClauses, (Locale)this.getLocale());
                        }
                        String rankOrder = ((DataItemRankFilter)filter).getRankOrder() == 0 ? this.bundle.getString(this.RB_KEY + "topRadio.txt") : this.bundle.getString(this.RB_KEY + "bottomRadio.txt");
                        String rankType = null;
                        boolean isIncludeTies = ((DataItemRankFilter)filter).isIncludeTies();
                        String useTies = "2";
                        switch (((DataItemRankFilter)filter).getRankType()) {
                            case 0: {
                                rankType = this.bundle.getString(this.RB_KEY + "count.txt");
                                useTies = isIncludeTies ? "1" : "0";
                                break;
                            }
                            case 1: {
                                rankType = this.bundle.getString(this.RB_KEY + "percent.txt");
                                break;
                            }
                            case 2: {
                                rankType = this.bundle.getString(this.RB_KEY + "sum.txt");
                            }
                        }
                        int rankValue = ((DataItemRankFilter)filter).getValue();
                        rankStatus = com.sas.swing.visuals.dataselectors.Util.localizeRankStatus((String)rankOrder, (int)rankValue, rankType, (String)useTies, (String)localizedBasedOnMeasureDesc, (Locale)this.getLocale());
                    }
                }
            } else {
                Map rankStatuses = this.rankStatuses();
                rankStatus = (String)rankStatuses.get(dataItemID);
            }
        }
        return rankStatus;
    }

    private String getMeasureLabel(String measureBMID) {
        String label = null;
        if (measureBMID != null) {
            Iterator keys = this.businessModelMeasuresMapping.keySet().iterator();
            Map attrs = null;
            while (keys.hasNext()) {
                attrs = (Map)this.businessModelMeasuresMapping.get(keys.next());
                if (!((String)attrs.get("MEASURE_ID")).equals(measureBMID)) continue;
                label = (String)attrs.get("MEASURE_LABEL");
                break;
            }
        }
        return label;
    }

    @Override
    protected void initDataItems() {
        this.initBusinessModelMeasuresMapping();
        Map map = null;
        try {
            map = Util.OLAPDataItemNames(this.dataModel());
        }
        catch (InvalidIDException invalidIDException) {
            // empty catch block
        }
        HashMap dataItems = new HashMap();
        HashMap filteredBasedOnMeasures = null;
        HashMap<String, Object> attribs = null;
        String dataItemID = null;
        Object lastStep = null;
        Iterator iterator = map.values().iterator();
        Iterator it2 = map.keySet().iterator();
        Integer rankOrder = null;
        Integer rankValue = null;
        Integer rankType = null;
        Boolean ties = null;
        List qualifiers = null;
        String desc = null;
        String adapterAssignedBasedOnMeasureId = null;
        while (iterator.hasNext()) {
            adapterAssignedBasedOnMeasureId = null;
            filteredBasedOnMeasures = null;
            desc = it2.hasNext() ? (String)it2.next() : null;
            dataItemID = (String)iterator.next();
            attribs = new HashMap<String, Object>();
            lastStep = this.getRankFilter(dataItemID);
            if (lastStep instanceof DataItemRankFilter) {
                rankOrder = new Integer(((DataItemRankFilter)lastStep).getRankOrder());
                rankValue = new Integer(((DataItemRankFilter)lastStep).getValue());
                rankType = new Integer(((DataItemRankFilter)lastStep).getRankType());
                ties = new Boolean(((DataItemRankFilter)lastStep).isIncludeTies());
                filteredBasedOnMeasures = new HashMap();
                qualifiers = ((DataItemRankFilter)lastStep).getRankQualifiers();
                if (qualifiers.size() > 1) {
                    String[] byRankNames = this.transformQaulifiersListToArray(qualifiers);
                    String[] whereValues = new String[byRankNames.length - 1];
                    for (int a = 0; a < whereValues.length; ++a) {
                        whereValues[a] = this.getWhereValue(byRankNames[a + 1]);
                    }
                    adapterAssignedBasedOnMeasureId = new Long(com.sas.util.Util.getNumber()).toString();
                    this.addFilteredBasedOnMeasure(filteredBasedOnMeasures, byRankNames, whereValues, adapterAssignedBasedOnMeasureId);
                } else {
                    DataItem basedOnMeasureDataItem = (DataItem)qualifiers.get(0);
                    if (basedOnMeasureDataItem != null) {
                        String basedOnMeasureDataItemID = null;
                        try {
                            basedOnMeasureDataItemID = basedOnMeasureDataItem.getID();
                        }
                        catch (InvalidIDException invalidIDException) {
                            // empty catch block
                        }
                        if (basedOnMeasureDataItemID != null) {
                            adapterAssignedBasedOnMeasureId = this.getAdapterAssignedMeasureId(basedOnMeasureDataItemID);
                        }
                    }
                }
            }
            attribs.put("desc", desc);
            attribs.put("rankOrder", rankOrder);
            attribs.put("rankValue", rankValue);
            attribs.put("rankType", rankType);
            attribs.put("ties", ties);
            if (filteredBasedOnMeasures != null) {
                attribs.put("filteredBasedOnMeasures", filteredBasedOnMeasures);
            }
            attribs.put("selectedBasedOnMeasureId", adapterAssignedBasedOnMeasureId);
            dataItems.put(dataItemID, attribs);
        }
        this.dataItems(dataItems);
    }

    private String[] transformQaulifiersListToArray(List qualifiers) {
        DataItem basedOnMeasureDataItem;
        String[] byRankNames = null;
        if (qualifiers != null && (basedOnMeasureDataItem = (DataItem)qualifiers.get(0)) != null) {
            byRankNames = new String[qualifiers.size()];
            String basedOnMeasureDataItemID = null;
            try {
                basedOnMeasureDataItemID = basedOnMeasureDataItem.getID();
            }
            catch (InvalidIDException invalidIDException) {
                // empty catch block
            }
            byRankNames[0] = basedOnMeasureDataItemID;
            int nQualifiers = qualifiers.size();
            if (nQualifiers > 1) {
                for (int i = 1; i < nQualifiers; ++i) {
                    try {
                        byRankNames[i] = ((StringExpression)qualifiers.get(i)).getText();
                        continue;
                    }
                    catch (MetadataException metadataException) {
                        // empty catch block
                    }
                }
            }
        }
        return byRankNames;
    }

    private void initBusinessModelMeasuresMapping() {
        this.businessModelMeasuresMapping = new HashMap();
        Map virginMeasures = null;
        try {
            virginMeasures = Util.businessModeldataItemNames(this.dataModel.getBusinessModel(), StructureOfDataItem.STRUCTURE_MEASURE);
        }
        catch (InvalidIDException invalidIDException) {
            // empty catch block
        }
        if (virginMeasures != null) {
            Iterator iterator = virginMeasures.keySet().iterator();
            String measureDesc = null;
            HashMap measureAttrs = null;
            while (iterator.hasNext()) {
                measureDesc = (String)iterator.next();
                measureAttrs = new HashMap();
                measureAttrs.put("MEASURE_ID", virginMeasures.get(measureDesc));
                measureAttrs.put("MEASURE_LABEL", measureDesc);
                this.businessModelMeasuresMapping.put(new Long(com.sas.util.Util.getNumber()).toString(), measureAttrs);
            }
        }
    }

    private String getAdapterAssignedMeasureId(String businessModelMeasureUniqueName) {
        String adapterAssignedBasedOnMeasureId = null;
        if (businessModelMeasureUniqueName != null) {
            Iterator iterator = this.businessModelMeasuresMapping.keySet().iterator();
            String currAdapterAssignedMeasureId = null;
            String measureID = null;
            while (iterator.hasNext()) {
                currAdapterAssignedMeasureId = (String)iterator.next();
                measureID = (String)((Map)this.businessModelMeasuresMapping.get(currAdapterAssignedMeasureId)).get("MEASURE_ID");
                if (!measureID.equals(businessModelMeasureUniqueName)) continue;
                adapterAssignedBasedOnMeasureId = currAdapterAssignedMeasureId;
                break;
            }
        }
        return adapterAssignedBasedOnMeasureId;
    }

    private void addFilteredBasedOnMeasure(Map filteredBasedOnMeasures, String[] qualifiers, String[] whereValues, String adapterAssignedBasedOnMeasureId) {
        if (filteredBasedOnMeasures != null && qualifiers != null && whereValues != null && adapterAssignedBasedOnMeasureId != null && qualifiers.length > 1) {
            HashMap<String, Object> filteredBasedOnMeasure = new HashMap<String, Object>();
            filteredBasedOnMeasures.put(adapterAssignedBasedOnMeasureId, filteredBasedOnMeasure);
            filteredBasedOnMeasure.put("BUSINESS_MODEL_MEASURE_UNIQUE_NAME", qualifiers[0]);
            HashMap whereClauses = new HashMap();
            filteredBasedOnMeasure.put("WHERE_CLAUSES", whereClauses);
            String[] wheres = new String[qualifiers.length - 1];
            for (int i = 1; i < qualifiers.length; ++i) {
                wheres[i - 1] = qualifiers[i];
            }
            String[] dataItemsLabels = new String[wheres.length];
            for (int k = 0; k < wheres.length; ++k) {
                dataItemsLabels[k] = this.getDataItemID(wheres[k]);
            }
            if (dataItemsLabels != null) {
                int nDataItemsLabels = dataItemsLabels.length;
                HashMap<String, String> newMap = null;
                for (int d = 0; d < nDataItemsLabels; ++d) {
                    newMap = new HashMap<String, String>();
                    whereClauses.put(dataItemsLabels[d], newMap);
                    newMap.put("WHERE_CLAUSE", wheres[d]);
                    newMap.put("WHERE_VALUE", whereValues[d]);
                }
            }
        }
    }

    public String measureDataItemID(String dataItemID) {
        DataItem basedOnMeasureDataItem;
        List qualifiers;
        String measureDataItemID = null;
        Object filter = this.getRankFilter(dataItemID);
        if (filter instanceof DataItemRankFilter && (qualifiers = ((DataItemRankFilter)filter).getRankQualifiers()) != null && (basedOnMeasureDataItem = (DataItem)qualifiers.get(0)) != null) {
            try {
                measureDataItemID = basedOnMeasureDataItem.getID();
            }
            catch (InvalidIDException invalidIDException) {
                // empty catch block
            }
        }
        return measureDataItemID;
    }

    public String[] whereClauses(String dataItemID) {
        int nRankNames;
        String[] whereClauses = null;
        Object filter = this.getRankFilter(dataItemID);
        List rankNames = null;
        if (filter instanceof DataItemRankFilter) {
            rankNames = ((DataItemRankFilter)filter).getRankQualifiers();
        }
        if (rankNames != null && (nRankNames = rankNames.size()) > 1) {
            int nw = nRankNames - 1;
            whereClauses = new String[nw];
            String whereClause = null;
            String id = null;
            String token = null;
            for (int a = 1; a < nRankNames; ++a) {
                whereClause = null;
                id = null;
                try {
                    whereClause = ((StringExpression)rankNames.get(a)).getText();
                }
                catch (MetadataException metadataException) {
                    // empty catch block
                }
                if (whereClause == null) continue;
                id = this.getDataItemID(whereClause);
                token = "";
                if (id != null) {
                    token = id + "\t" + whereClause + "\t" + this.getWhereValue(whereClause);
                }
                whereClauses[a - 1] = token;
            }
        }
        if (whereClauses == null) {
            whereClauses = new String[]{};
        }
        return whereClauses;
    }

    private String getDataItemID(String whereClause) {
        String id = null;
        DataItem dataItem = null;
        BusinessQuery bq = this.dataModel();
        Object model = this.getModel();
        if (model != null) {
            if (!(model instanceof BusinessQueryToOLAPDataSetAdapter)) {
                model = new BusinessQueryToOLAPDataSetAdapter(bq);
            }
        } else {
            model = new BusinessQueryToOLAPDataSetAdapter(bq);
        }
        if (model != null) {
            try {
                dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItem(bq, (BusinessQueryToOLAPDataSetAdapter)model, whereClause, 2);
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        if (dataItem != null) {
            try {
                id = dataItem.getID();
            }
            catch (InvalidIDException invalidIDException) {
                // empty catch block
            }
        }
        return id;
    }

    private String getWhereValue(String whereClause) {
        String value = null;
        if (whereClause != null) {
            Object model = this.getModel();
            if (model instanceof OLAPDataSetInterface) {
                MetadataInterface mi = null;
                try {
                    mi = ((OLAPDataSetInterface)model).getDatabaseMetadata();
                }
                catch (OLAPException oLAPException) {
                    // empty catch block
                }
                if (mi != null) {
                    String cubeName = null;
                    try {
                        cubeName = ((OLAPDataSetInterface)model).getCubeName();
                    }
                    catch (OLAPException oLAPException) {
                        // empty catch block
                    }
                    if (cubeName != null) {
                        MemberInterface member;
                        Filter filter = new Filter();
                        filter.setCubeName(cubeName);
                        filter.setUniqueMemberName(whereClause);
                        MemberInterface[] mia = null;
                        try {
                            mia = mi.getMembers(filter, 0, 1);
                        }
                        catch (OLAPException oLAPException) {
                            // empty catch block
                        }
                        if (mia != null && mia.length > 0 && (member = mia[0]) != null) {
                            try {
                                value = member.getLabel();
                            }
                            catch (OLAPException oLAPException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            if (value == null) {
                String[] splitted = null;
                String separator = "].[";
                String prefix = "[";
                String suffix = "]";
                splitted = Strings.split((String)whereClause, (String)prefix, (String)separator, (String)suffix);
                value = splitted[splitted.length - 1];
            }
        }
        return value;
    }

    @Override
    public int countRankTypeValue() {
        return super.countRankTypeValue();
    }

    @Override
    public void setIncludeTies(String isIncludeTies) {
        super.setIncludeTies(isIncludeTies);
    }

    public String getMeasureUniqueName(String adapterAssignedId) {
        String measureUniqueName = null;
        if (adapterAssignedId != null) {
            if (this.businessModelMeasuresMapping.containsKey(adapterAssignedId)) {
                measureUniqueName = (String)((Map)this.businessModelMeasuresMapping.get(adapterAssignedId)).get("MEASURE_ID");
            } else {
                Map dataItems = this.dataItems();
                Iterator keys = dataItems.keySet().iterator();
                Map filteredBasedOnMeasures = null;
                Map filteredBasedOnMeasure = null;
                while (keys.hasNext()) {
                    Map attribs = (Map)dataItems.get(keys.next());
                    if (!attribs.containsKey("filteredBasedOnMeasures") || !(filteredBasedOnMeasures = (Map)attribs.get("filteredBasedOnMeasures")).containsKey(adapterAssignedId)) continue;
                    filteredBasedOnMeasure = (Map)filteredBasedOnMeasures.get(adapterAssignedId);
                    measureUniqueName = (String)filteredBasedOnMeasure.get("BUSINESS_MODEL_MEASURE_UNIQUE_NAME");
                    break;
                }
            }
        }
        return measureUniqueName;
    }

    public String[][] getLocalizedBasedOnMeasures(String dataItemId) {
        String[][] localizedBasedOnMeasures = null;
        if (dataItemId != null) {
            int nBusinessModelMeasures;
            Map attribs;
            Map filteredBasedOnMeasures = null;
            Map dataItems = this.dataItems();
            if (dataItems.containsKey(dataItemId) && (attribs = (Map)dataItems.get(dataItemId)).containsKey("filteredBasedOnMeasures")) {
                filteredBasedOnMeasures = (Map)attribs.get("filteredBasedOnMeasures");
            }
            int nFilteredBasedOnMeasures = 0;
            if (filteredBasedOnMeasures != null) {
                nFilteredBasedOnMeasures = filteredBasedOnMeasures.size();
            }
            int nBasedOnMeasures = nBusinessModelMeasures = this.businessModelMeasuresMapping.size();
            if (nFilteredBasedOnMeasures > 0) {
                nBasedOnMeasures = nBasedOnMeasures + nFilteredBasedOnMeasures + 1;
            }
            if (nBasedOnMeasures > 0) {
                localizedBasedOnMeasures = new String[nBasedOnMeasures][3];
                int row = 0;
                Iterator adapterIds = null;
                if (nFilteredBasedOnMeasures > 0) {
                    adapterIds = filteredBasedOnMeasures.keySet().iterator();
                    Iterator basedOnMeasures = filteredBasedOnMeasures.values().iterator();
                    Map basedOnMeasure = null;
                    Iterator whereClauses = null;
                    int i = 0;
                    while (i < nFilteredBasedOnMeasures) {
                        localizedBasedOnMeasures[row][0] = (String)adapterIds.next();
                        basedOnMeasure = (Map)basedOnMeasures.next();
                        Map whereClausesMap = (Map)basedOnMeasure.get("WHERE_CLAUSES");
                        int nWhereClauses = whereClausesMap.size();
                        nWhereClauses = nWhereClauses > 5 ? 5 : nWhereClauses;
                        String[] localizedWhereClauses = new String[nWhereClauses];
                        whereClauses = whereClausesMap.values().iterator();
                        for (int a = 0; a < nWhereClauses; ++a) {
                            localizedWhereClauses[a] = (String)((Map)whereClauses.next()).get("WHERE_VALUE");
                        }
                        String measureOriginalUniqueName = (String)basedOnMeasure.get("BUSINESS_MODEL_MEASURE_UNIQUE_NAME");
                        String measureLabel = this.getMeasureLabel(measureOriginalUniqueName);
                        localizedBasedOnMeasures[row][1] = com.sas.swing.visuals.dataselectors.Util.localizeBasedOnMeasureDesc((String)measureLabel, (String[])localizedWhereClauses, (Locale)this.getLocale());
                        localizedBasedOnMeasures[row][2] = measureLabel;
                        ++i;
                        ++row;
                    }
                    localizedBasedOnMeasures[row][0] = "SEPARATOR";
                    localizedBasedOnMeasures[row][1] = this.bundle.getString(this.RB_KEY + "separationLine.txt");
                    localizedBasedOnMeasures[row][2] = "SEPARATOR";
                    ++row;
                }
                adapterIds = this.businessModelMeasuresMapping.keySet().iterator();
                String adapterAssignedMeasureID = null;
                String measureLabel = null;
                int i = 0;
                while (i < nBusinessModelMeasures) {
                    localizedBasedOnMeasures[row][0] = adapterAssignedMeasureID = (String)adapterIds.next();
                    localizedBasedOnMeasures[row][1] = measureLabel = (String)((Map)this.businessModelMeasuresMapping.get(adapterAssignedMeasureID)).get("MEASURE_LABEL");
                    localizedBasedOnMeasures[row][2] = measureLabel;
                    ++i;
                    ++row;
                }
            }
        }
        return localizedBasedOnMeasures;
    }

    public String getSelectedBasedOnMeasureId(String dataItemId) {
        Map dataItems;
        String selectedBasedOnMeasureId = null;
        if (dataItemId != null && (dataItems = this.dataItems()).containsKey(dataItemId)) {
            selectedBasedOnMeasureId = (String)((Map)dataItems.get(dataItemId)).get("selectedBasedOnMeasureId");
        }
        return selectedBasedOnMeasureId;
    }

    public void setBasedOnMeasureId(String basedOnMeasureId, String dataItemId) {
        Map dataItems;
        if (basedOnMeasureId != null && dataItemId != null && (dataItems = this.dataItems()).containsKey(dataItemId)) {
            ((Map)dataItems.get(dataItemId)).put("selectedBasedOnMeasureId", basedOnMeasureId);
        }
    }

    public void updateWhereClause(String dataItemId, String basedOnMeasureId, String[] whereClause, String[] whereValue) {
        Map dataItems;
        if (dataItemId != null && basedOnMeasureId != null && whereClause != null && whereValue != null && (dataItems = this.dataItems()).containsKey(dataItemId)) {
            Map attribs = (Map)dataItems.get(dataItemId);
            HashMap filteredBasedOnMeasures = (HashMap)attribs.get("filteredBasedOnMeasures");
            if (filteredBasedOnMeasures != null) {
                if (filteredBasedOnMeasures.containsKey(basedOnMeasureId)) {
                    if (whereClause.length > 0) {
                        if (whereClause[0].equalsIgnoreCase("")) {
                            Map filteredBasedOnMeasure = (Map)filteredBasedOnMeasures.get(basedOnMeasureId);
                            String verginMeasureName = (String)filteredBasedOnMeasure.get("BUSINESS_MODEL_MEASURE_UNIQUE_NAME");
                            Iterator keys = this.businessModelMeasuresMapping.keySet().iterator();
                            String key = null;
                            while (keys.hasNext()) {
                                key = (String)keys.next();
                                if (!((String)((Map)this.businessModelMeasuresMapping.get(key)).get("MEASURE_ID")).equals(verginMeasureName)) continue;
                                attribs.put("selectedBasedOnMeasureId", key);
                                break;
                            }
                            filteredBasedOnMeasures.remove(basedOnMeasureId);
                            if (filteredBasedOnMeasures.size() == 0) {
                                attribs.remove("filteredBasedOnMeasures");
                            }
                        } else {
                            Map filteredBasedOnMeasure = (Map)filteredBasedOnMeasures.get(basedOnMeasureId);
                            HashMap whereClauses = new HashMap();
                            filteredBasedOnMeasure.put("WHERE_CLAUSES", whereClauses);
                            String[] dataItemsLabels = new String[whereClause.length];
                            for (int k = 0; k < whereClause.length; ++k) {
                                dataItemsLabels[k] = this.getDataItemID(whereClause[k]);
                            }
                            if (dataItemsLabels != null) {
                                HashMap<String, String> newMap = null;
                                for (int i = 0; i < dataItemsLabels.length; ++i) {
                                    newMap = new HashMap<String, String>();
                                    whereClauses.put(dataItemsLabels[i], newMap);
                                    newMap.put("WHERE_CLAUSE", whereClause[i]);
                                    newMap.put("WHERE_VALUE", whereValue[i]);
                                }
                            }
                        }
                    }
                } else if (whereClause.length > 0 && !whereClause[0].equalsIgnoreCase("")) {
                    String newId = new Long(com.sas.util.Util.getNumber()).toString();
                    String[] qualifiers = new String[whereClause.length + 1];
                    qualifiers[0] = (String)((Map)this.businessModelMeasuresMapping.get(basedOnMeasureId)).get("MEASURE_ID");
                    for (int i = 0; i < whereClause.length; ++i) {
                        qualifiers[i + 1] = whereClause[i];
                    }
                    this.addFilteredBasedOnMeasure(filteredBasedOnMeasures, qualifiers, whereValue, newId);
                    attribs.put("selectedBasedOnMeasureId", newId);
                }
            } else if (whereClause.length > 0 && !whereClause[0].equalsIgnoreCase("")) {
                filteredBasedOnMeasures = new HashMap();
                attribs.put("filteredBasedOnMeasures", filteredBasedOnMeasures);
                String newId = new Long(com.sas.util.Util.getNumber()).toString();
                String[] qualifiers = new String[whereClause.length + 1];
                qualifiers[0] = (String)((Map)this.businessModelMeasuresMapping.get(basedOnMeasureId)).get("MEASURE_ID");
                for (int i = 0; i < whereClause.length; ++i) {
                    qualifiers[i + 1] = whereClause[i];
                }
                this.addFilteredBasedOnMeasure(filteredBasedOnMeasures, qualifiers, whereValue, newId);
                attribs.put("selectedBasedOnMeasureId", newId);
            }
        }
    }

    public String[][] getMeasuresWhereClauses(String dataItemId) {
        String[][] measuresWhereClauses = null;
        if (dataItemId != null) {
            int nBusinessModelMeasures;
            Map attribs;
            Map filteredBasedOnMeasures = null;
            Map dataItems = this.dataItems();
            if (dataItems.containsKey(dataItemId) && (attribs = (Map)dataItems.get(dataItemId)).containsKey("filteredBasedOnMeasures")) {
                filteredBasedOnMeasures = (Map)attribs.get("filteredBasedOnMeasures");
            }
            int nFilteredBasedOnMeasures = 0;
            if (filteredBasedOnMeasures != null) {
                nFilteredBasedOnMeasures = filteredBasedOnMeasures.size();
            }
            int nBasedOnMeasures = nBusinessModelMeasures = this.businessModelMeasuresMapping.size();
            if (nFilteredBasedOnMeasures > 0) {
                nBasedOnMeasures += nFilteredBasedOnMeasures;
            }
            if (nBasedOnMeasures > 0) {
                measuresWhereClauses = new String[nBasedOnMeasures][4];
                int row = 0;
                Iterator adapterIds = null;
                String adapterAssignedMeasureID = null;
                if (nFilteredBasedOnMeasures > 0) {
                    adapterIds = filteredBasedOnMeasures.keySet().iterator();
                    Iterator basedOnMeasures = filteredBasedOnMeasures.values().iterator();
                    Map basedOnMeasure = null;
                    Iterator whereClauseIds = null;
                    int i = 0;
                    while (i < nFilteredBasedOnMeasures) {
                        measuresWhereClauses[row][0] = adapterAssignedMeasureID = (String)adapterIds.next();
                        basedOnMeasure = (Map)basedOnMeasures.next();
                        Map whereClausesMap = (Map)basedOnMeasure.get("WHERE_CLAUSES");
                        int nWhereClauses = whereClausesMap.size();
                        whereClauseIds = whereClausesMap.keySet().iterator();
                        String whereClause = null;
                        String whereValue = null;
                        String whereID = null;
                        String token = null;
                        Map whereClauseMap = null;
                        for (int a = 0; a < nWhereClauses; ++a) {
                            token = (String)whereClauseIds.next();
                            whereID = whereID == null ? token : whereID + "\t" + token;
                            whereClauseMap = (Map)whereClausesMap.get(token);
                            token = (String)whereClauseMap.get("WHERE_CLAUSE");
                            whereClause = whereClause == null ? token : whereClause + "\t" + token;
                            token = (String)whereClauseMap.get("WHERE_VALUE");
                            whereValue = whereValue == null ? token : whereValue + "\t" + token;
                        }
                        measuresWhereClauses[row][1] = whereClause;
                        measuresWhereClauses[row][2] = whereValue;
                        measuresWhereClauses[row][3] = whereID;
                        ++i;
                        ++row;
                    }
                }
                adapterIds = this.businessModelMeasuresMapping.keySet().iterator();
                int i = 0;
                while (i < nBusinessModelMeasures) {
                    measuresWhereClauses[row][0] = adapterAssignedMeasureID = (String)adapterIds.next();
                    measuresWhereClauses[row][1] = "";
                    measuresWhereClauses[row][2] = "";
                    measuresWhereClauses[row][3] = "";
                    ++i;
                    ++row;
                }
            }
        }
        return measuresWhereClauses;
    }
}

