/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.ranking;

import com.sas.dataselectors.ranking.RankingSelectorInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.step.olap.DataItemRankFilter;
import com.sas.swing.visuals.dataselectors.Util;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public abstract class BaseRankingSelectorAdapter
implements RankingSelectorInterface {
    private boolean isTop = true;
    private boolean isPercentage = true;
    private int rankingCount = 10;
    protected BusinessQuery dataModel;
    private boolean isIncludeTies;
    private String includeTies;
    private int rankType;
    protected boolean valuesFromDataModel;
    protected Object model;
    private boolean isOLAP = false;
    protected Map rankStatuses;
    protected Locale locale;
    protected String RB_KEY = "RankingSelector.";
    protected ResourceBundle bundle;
    protected Map dataItems;

    public boolean topRanking() {
        return this.isTop;
    }

    public int rankingCount() {
        return this.rankingCount;
    }

    public boolean percentageRanking() {
        return this.isPercentage;
    }

    public void topRanking(boolean isTop) {
        this.isTop = isTop;
    }

    public void percentageRanking(boolean isPercentage) {
        this.isPercentage = isPercentage;
    }

    public void rankingCount(int count) {
        if (count > 0) {
            this.rankingCount = count;
        }
    }

    protected Map dataItems() {
        return this.dataItems;
    }

    protected void dataItems(Map dataItems) {
        this.dataItems = dataItems;
    }

    public void dataModel(BusinessQuery model) {
        if (this.dataModel != model && model != null) {
            this.dataModel = model;
            if (model.getInputStructure().isOLAP()) {
                this.isOLAP = true;
            }
            this.initDataItems();
        }
    }

    public BusinessQuery dataModel() {
        return this.dataModel;
    }

    protected abstract void initDataItems();

    public void includeTies(boolean isIncludeTies) {
        this.isIncludeTies = isIncludeTies;
    }

    public boolean includeTies() {
        return this.isIncludeTies;
    }

    public void setIncludeTies(String isIncludeTies) {
        this.includeTies = isIncludeTies;
    }

    public String getIncludeTies() {
        return this.includeTies;
    }

    public void rankType(int rankType) {
        if (this.isOLAP) {
            if (rankType == 0 || rankType == 1 || rankType == 2) {
                this.rankType = rankType;
            }
        } else if (rankType == 0) {
            this.rankType = rankType;
        }
    }

    public int rankType() {
        return this.rankType;
    }

    public abstract Map rankTypes();

    public boolean valuesFromDataModel() {
        return this.valuesFromDataModel;
    }

    public void valuesFromDataModel(boolean valuesFromDataModel) {
        this.valuesFromDataModel = valuesFromDataModel;
    }

    public abstract String dataItemRankStatus(String var1);

    protected void rankStatuses(Map rankStatuses) {
        this.rankStatuses = rankStatuses;
    }

    protected Map rankStatuses() {
        return this.rankStatuses;
    }

    public String rankOrder(String dataItemID) {
        String rankOrder = null;
        Object filter = this.getRankFilter(dataItemID);
        if (filter != null) {
            if (this.isOLAP) {
                if (filter instanceof DataItemRankFilter) {
                    int order = ((DataItemRankFilter)filter).getRankOrder();
                    if (order == 0) {
                        rankOrder = "T";
                    } else if (order == 1) {
                        rankOrder = "B";
                    }
                }
            } else if (filter instanceof com.sas.iquery.metadata.business.step.relational.DataItemRankFilter) {
                int order = ((com.sas.iquery.metadata.business.step.relational.DataItemRankFilter)filter).getRankOrder();
                if (order == 0) {
                    rankOrder = "T";
                } else if (order == 1) {
                    rankOrder = "B";
                }
            }
        }
        return rankOrder;
    }

    public int rankValue(String dataItemID) {
        int rankValue = -9999;
        Object filter = this.getRankFilter(dataItemID);
        if (filter != null) {
            if (this.isOLAP) {
                if (filter instanceof DataItemRankFilter) {
                    rankValue = ((DataItemRankFilter)filter).getValue();
                }
            } else if (filter instanceof com.sas.iquery.metadata.business.step.relational.DataItemRankFilter) {
                rankValue = ((com.sas.iquery.metadata.business.step.relational.DataItemRankFilter)filter).getValue();
            }
        }
        return rankValue;
    }

    public int rankType(String dataItemID) {
        int rankType = -9999;
        Object filter = this.getRankFilter(dataItemID);
        if (filter != null) {
            if (this.isOLAP) {
                if (filter instanceof DataItemRankFilter) {
                    rankType = ((DataItemRankFilter)filter).getRankType();
                }
            } else if (filter instanceof com.sas.iquery.metadata.business.step.relational.DataItemRankFilter) {
                rankType = ((com.sas.iquery.metadata.business.step.relational.DataItemRankFilter)filter).getRankType();
            }
        }
        return rankType;
    }

    public boolean includeTies(String dataItemID) {
        boolean includeTies = false;
        Object filter = this.getRankFilter(dataItemID);
        if (filter != null) {
            if (this.isOLAP) {
                if (filter instanceof DataItemRankFilter) {
                    includeTies = ((DataItemRankFilter)filter).isIncludeTies();
                }
            } else if (filter instanceof com.sas.iquery.metadata.business.step.relational.DataItemRankFilter) {
                includeTies = ((com.sas.iquery.metadata.business.step.relational.DataItemRankFilter)filter).isIncludeTies();
            }
        }
        return includeTies;
    }

    public String getIncludeTies(String dataItemID) {
        String includeTies = "0";
        Object filter = this.getRankFilter(dataItemID);
        if (filter != null) {
            if (this.isOLAP) {
                if (filter instanceof DataItemRankFilter && ((DataItemRankFilter)filter).isIncludeTies()) {
                    includeTies = "1";
                }
            } else if (filter instanceof com.sas.iquery.metadata.business.step.relational.DataItemRankFilter && ((com.sas.iquery.metadata.business.step.relational.DataItemRankFilter)filter).isIncludeTies()) {
                includeTies = "1";
            }
        }
        return includeTies;
    }

    public int countRankTypeValue() {
        if (this.isOLAP) {
            return 0;
        }
        return 0;
    }

    protected Object getRankFilter(String dataItemID) {
        Object filter = null;
        List steps = this.getDataItemSteps(dataItemID);
        if (steps != null) {
            Iterator iterator = steps.iterator();
            Object step = null;
            while (iterator.hasNext()) {
                step = iterator.next();
                if (this.isOLAP) {
                    if (!(step instanceof DataItemRankFilter)) continue;
                    filter = step;
                    break;
                }
                if (!(step instanceof com.sas.iquery.metadata.business.step.relational.DataItemRankFilter)) continue;
                filter = step;
                break;
            }
        }
        return filter;
    }

    private List getDataItemSteps(String dataItemID) {
        List steps = null;
        BusinessQuery dataModel = this.dataModel();
        DataItem dataItem = null;
        try {
            dataItem = (DataItem)dataModel.getBusinessModel().getBusinessItemByID(dataItemID);
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        if (dataItem != null) {
            steps = dataItem.getSteps();
        }
        return steps;
    }

    public void setModel(Object model) {
        this.model = model;
    }

    public Object getModel() {
        return this.model;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        if (locale != null) {
            this.bundle = ResourceBundle.getBundle("com.sas.swing.visuals.dataselectors.ranking.Resources", locale);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLocalizedInfoText(String rankOrder, int rankValue, int rankType, String includeTies, String basedOnDesc) {
        String infoText = null;
        if (rankOrder != null) {
            rankOrder = rankOrder.equalsIgnoreCase("T") ? this.bundle.getString(this.RB_KEY + "topRadio.txt") : this.bundle.getString(this.RB_KEY + "bottomRadio.txt");
        }
        String remoteRankTypeInfo = this.bundle.getString(this.RB_KEY + "count.txt");
        if (this.isOLAP) {
            switch (rankType) {
                case 1: {
                    remoteRankTypeInfo = this.bundle.getString(this.RB_KEY + "percent.txt");
                    break;
                }
                case 2: {
                    remoteRankTypeInfo = this.bundle.getString(this.RB_KEY + "sum.txt");
                }
            }
        }
        infoText = Util.localizeRankStatus((String)rankOrder, (int)rankValue, (String)remoteRankTypeInfo, (String)includeTies, (String)basedOnDesc, (Locale)this.getLocale());
        return infoText;
    }

    public String getLocalizedText(String text) {
        String localizedText = null;
        if (text != null && this.bundle != null) {
            localizedText = this.bundle.getString(this.RB_KEY + text);
        }
        return localizedText;
    }
}

