/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.qualifiers;

import com.sas.dataselectors.LabeledStringValueInterface;
import com.sas.dataselectors.filters.OLAPMemberDeferredRetrievalTreeNode;
import com.sas.dataselectors.filters.OLAPMemberTreeModel;
import com.sas.dataselectors.qualifiers.OLAPDimensionTreeModel;
import com.sas.dataselectors.qualifiers.QualifiersSelectorInterface;
import com.sas.dataselectors.ranking.Util;
import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.Metadata;
import com.sas.swing.dataselectors.editors.QualifiersEditorInterface;
import com.sas.util.log.LoggerRepository2;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class QualifiersSelectorAdapter
implements QualifiersSelectorInterface,
QualifiersEditorInterface {
    private String[] items;
    private String[] values;
    private String[] descriptions;
    private TreeModel[] treemodels;
    private TreePath[] treepaths;
    private String[] selectedValues;
    private String[] rootNames;
    private MemberInterface[][] selectedPath;
    private BusinessQuery businessQuery;
    private BusinessModel businessModel;
    private MetadataInterface metadata;
    private DimensionInterface[] dimensions;
    private String cubeName;
    private String itemName;
    private String skipItem;
    private Map initialValues;
    private String clear;
    private String itemLabel;
    private String itemsLabel;
    private String itemsNameColumnLabel;
    private String itemsValueColumnLabel;

    public QualifiersSelectorAdapter(BusinessQuery query, Map map) {
        this.setBusinessQuery(query);
        this.setBusinessModel(query.getBusinessModel());
        this.init(map);
    }

    public QualifiersSelectorAdapter(BusinessQuery query) {
        this.setBusinessQuery(query);
        this.setBusinessModel(query.getBusinessModel());
        try {
            this.init(Util.OLAPDataItemNames(query));
        }
        catch (InvalidIDException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    public QualifiersSelectorAdapter(BusinessModel model) {
        this.setBusinessModel(model);
        try {
            this.loadDimensions(model);
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    public QualifiersSelectorAdapter() {
    }

    public void init(Map map) {
        if (map != null) {
            this.createArrays(map.size());
            int i = 0;
            for (String description : map.keySet()) {
                String name = (String)map.get(description);
                this.items[i] = description;
                this.values[i] = name;
                ++i;
            }
        }
    }

    private void createArrays(int len) {
        this.items = new String[len];
        this.values = new String[len];
        this.treemodels = new TreeModel[len];
        this.descriptions = new String[len];
        this.treepaths = new TreePath[len];
        this.selectedValues = new String[len];
        this.selectedPath = new MemberInterface[len][];
    }

    public BusinessQuery getBusinessQuery() {
        return this.businessQuery;
    }

    public void setBusinessQuery(BusinessQuery model) {
        this.businessQuery = model;
    }

    public BusinessModel getBusinessModel() {
        return this.businessModel;
    }

    public void setBusinessModel(BusinessModel businessModel) {
        this.businessModel = businessModel;
    }

    private void loadDimensions(BusinessModel model) throws MetadataException, OLAPException {
        MetadataInterface metadata = this.getMetadata();
        Filter filter = new Filter();
        filter.setCubeName(this.getCubeName());
        DimensionInterface[] allDimensions = metadata.getDimensions(filter);
        int len = allDimensions.length - 1;
        this.dimensions = new DimensionInterface[len];
        this.createArrays(len);
        int j = 0;
        for (int i = 0; i < allDimensions.length; ++i) {
            DimensionInterface dimension = allDimensions[i];
            if (dimension.getType() == 2) continue;
            if (j >= this.dimensions.length) {
                System.out.println("No Measures found in Dimensions");
                break;
            }
            this.dimensions[j] = dimension;
            this.items[j] = dimension.getDescription();
            this.values[j] = dimension.getName();
            ++j;
        }
    }

    public String getCubeName() {
        try {
            if (this.cubeName == null) {
                this.cubeName = OLAPConnectionInfoUtil.getCube((BusinessModel)this.businessModel).getCubeName();
            }
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        return this.cubeName;
    }

    public int getNumberOfItems() {
        return this.items != null ? this.items.length : 0;
    }

    public String getName(int item) {
        return this.items[item];
    }

    public String getDescription(int item) {
        return this.descriptions[item];
    }

    public String getValue(int item) {
        return this.values[item];
    }

    public TreeModel getTreeModel(int item) {
        TreeModel tm = this.treemodels[item];
        if (tm != null) {
            return tm;
        }
        try {
            if (this.businessQuery != null) {
                String dataItemID = this.values[item];
                DataItem dataItem = this.getDataItem(dataItemID);
                this.treemodels[item] = this.getTreeModel(dataItem);
                return this.treemodels[item];
            }
            this.treemodels[item] = this.getTreeModel(this.dimensions[item]);
            return this.treemodels[item];
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public DataItem getDataItem(String id) throws MetadataException {
        DataItem dataItem = (DataItem)this.getBusinessModel().getBusinessItemByID(id);
        return dataItem;
    }

    public TreeModel getTreeModel(DataItem dataItem) {
        try {
            MetadataInterface metadata = this.getMetadata();
            return new OLAPMemberTreeModel(dataItem, metadata);
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public TreeModel getTreeModel(DimensionInterface dimension) throws MetadataException, OLAPException {
        return new OLAPDimensionTreeModel(new OLAPMemberTreeModel(dimension));
    }

    public MetadataInterface getMetadata() throws OLAPException, MetadataException {
        if (this.metadata != null) {
            return this.metadata;
        }
        try {
            this.metadata = BusinessQueryOLAPUtil.getMetadataInterface((Object)this.getBusinessModel());
        }
        catch (IQueryServicesException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        if (this.metadata != null) {
            return this.metadata;
        }
        BusinessQueryToOLAPDataSetAdapter olap = new BusinessQueryToOLAPDataSetAdapter(this.businessQuery);
        this.metadata = olap.getDatabaseMetadata();
        if (this.metadata != null) {
            return this.metadata;
        }
        this.metadata = new Metadata((IMDXServer)olap.getConnection());
        return this.metadata;
    }

    public void releaseMetadata() {
        if (this.metadata != null) {
            BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)this.metadata);
        }
    }

    public int getIndexForTreeValue(String name) throws MetadataException, OLAPException {
        MemberInterface[] members = OLAPMemberTreeModel.getMemberArrayForPathNodeList(this.getMetadata(), this.getCubeName(), name);
        String value = this.businessQuery != null ? members[0].getFilter().getUniqueMemberName() : members[0].getFilter().getUniqueDimensionName();
        int lbIndex = this.getIndexForRootName(value);
        if (lbIndex >= 0) {
            this.selectedPath[lbIndex] = members;
        }
        return lbIndex;
    }

    private int getIndexForRootName(String rootName) throws MetadataException, OLAPException {
        for (int i = 0; i < this.items.length; ++i) {
            if (!rootName.equals(this.getRootName(i))) continue;
            return i;
        }
        return -1;
    }

    private String getRootName(int index) throws MetadataException, OLAPException {
        if (this.businessQuery != null) {
            String rootName = this.basicGetRootName(index);
            if (rootName != null) {
                return rootName;
            }
            this.rootNames[index] = rootName = BusinessQueryOLAPUtil.getUniqueNameWithHierarchyAllMember((DataItem)this.getDataItem(this.getValue(index)));
            return rootName;
        }
        return this.dimensions[index].getUniqueName();
    }

    private String basicGetRootName(int index) {
        if (this.rootNames == null) {
            this.rootNames = new String[this.items.length];
        }
        String dimensionName = this.rootNames[index];
        return dimensionName;
    }

    public Object getSelectedNodeFor(int index, TreeModel treemodel) throws OLAPException {
        OLAPMemberTreeModel olapTree;
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(treemodel.getRoot());
        if (treemodel instanceof OLAPMemberTreeModel) {
            olapTree = (OLAPMemberTreeModel)treemodel;
        } else if (treemodel instanceof OLAPDimensionTreeModel) {
            OLAPDimensionTreeModel dimTree = (OLAPDimensionTreeModel)treemodel;
            olapTree = dimTree.getModel();
        } else {
            return null;
        }
        OLAPMemberTreeModel.getTreePathNodeList(olapTree, this.selectedPath[index], list);
        return list.size() > 0 ? list.get(list.size() - 1) : null;
    }

    public void showEditor(Object userData) {
    }

    public boolean isEditOK() {
        return true;
    }

    public void itemLabel(String label) {
        this.itemLabel = label;
    }

    public void itemName(String name) {
        this.itemName = name;
    }

    public void itemsLabel(String label) {
        this.itemsLabel = label;
    }

    public void itemsNameColumnLabel(String label) {
        this.itemsNameColumnLabel = label;
    }

    public void itemsValueColumnLabel(String label) {
        this.itemsValueColumnLabel = label;
    }

    public void clearButtonText(String text) {
        this.clear = text;
    }

    public void skipItem(String itemID) {
        this.setSkipItem(itemID);
    }

    public Map selectedValues() {
        return null;
    }

    public void initialValues(Map values) {
        this.setInitialValues(values);
    }

    public void size(int width, int height) {
    }

    public void itemsListHeight(int height) {
    }

    public Map getInitialValues() {
        return this.initialValues;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getSkipItem() {
        return this.skipItem;
    }

    public void setInitialValues(Map map) {
        this.initialValues = map;
        this.setSelectedValues(new ArrayList(map.values()));
    }

    public void setItemName(String string) {
        this.itemName = string;
    }

    public void setSkipItem(String string) {
        this.skipItem = string;
    }

    public void setSelectedValues(List newValues) {
        int i;
        for (i = 0; i < this.values.length; ++i) {
            this.selectedPath[i] = null;
            this.selectedValues[i] = null;
            this.descriptions[i] = null;
        }
        for (i = 0; i < newValues.size(); ++i) {
            this.setSelectedValue((String)newValues.get(i));
        }
    }

    public TreePath getTreePath(int item) {
        TreePath path = this.treepaths[item];
        if (path != null) {
            return path;
        }
        if (this.selectedValues[item] == null) {
            return null;
        }
        try {
            Object node = this.getSelectedNodeFor(item, this.treemodels[item]);
            return new TreePath(this.buildTreePath(node));
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void setSelectedValue(String value) {
        int item = this.findTreeWithNode(value);
        if (item < 0) {
            try {
                item = this.getIndexForTreeValue(value);
                if (item >= 0) {
                    this.selectedValues[item] = value;
                    MemberInterface[] members = this.selectedPath[item];
                    MemberInterface member = members[members.length - 1];
                    this.descriptions[item] = member.getLabel();
                }
            }
            catch (Exception e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getSelectedValue(int item) {
        return this.selectedValues[item];
    }

    private int findTreeWithNode(String name) {
        int index = -1;
        for (int i = 0; i < this.treemodels.length; ++i) {
            Object node;
            TreeModel model = this.getTreeModel(i);
            if (model == null || (node = this.findNodeInTree(model, name)) == null) continue;
            index = i;
            Object[] path = this.buildTreePath(node);
            this.treepaths[i] = new TreePath(path);
            this.descriptions[i] = ((LabeledStringValueInterface)node).getLabel();
            this.selectedValues[i] = ((LabeledStringValueInterface)node).getValue();
            break;
        }
        return index;
    }

    private Object[] buildTreePath(Object node) {
        DefaultMutableTreeNode tnode = (DefaultMutableTreeNode)node;
        Object[] path = new Object[tnode.getLevel() + 1];
        for (int p = path.length - 1; p >= 0; --p) {
            path[p] = tnode;
            tnode = (DefaultMutableTreeNode)tnode.getParent();
        }
        return path;
    }

    private Object findNodeInTree(TreeModel model, String name) {
        Object rootobj = model.getRoot();
        return this.findNode(rootobj, name);
    }

    private Object findNode(Object rootobj, String name) {
        if (name.equals(((LabeledStringValueInterface)rootobj).getValue())) {
            return rootobj;
        }
        if (!(rootobj instanceof OLAPMemberDeferredRetrievalTreeNode)) {
            return null;
        }
        OLAPMemberDeferredRetrievalTreeNode root = (OLAPMemberDeferredRetrievalTreeNode)rootobj;
        if (!root.getInitialized()) {
            return null;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            TreeNode childobj = root.getChildAt(i);
            Object found = this.findNode(childobj, name);
            if (found == null) continue;
            return found;
        }
        return null;
    }
}

