/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.propertyeditor;

import com.sas.beans.PropertyChangeSupport;
import com.sas.dataselectors.filters.BusinessQueryToAdvancedFilterModelAdapter;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterValueInterface;
import com.sas.dataselectors.propertyeditor.DefaultPropertyValue;
import com.sas.dataselectors.propertyeditor.RB;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeTypeInterface;
import com.sas.entities.AttributeTypeUtility;
import com.sas.entities.EntityRB;
import com.sas.entities.EntityUtil;
import com.sas.entities.RemoteEntityInterface;
import com.sas.entities.persist.ConfigurationXMLPersistenceUtility;
import com.sas.entities.persist.EntityHelper;
import com.sas.entities.persist.ParsedConfigurationXMLObject;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.swing.visuals.dataselectors.propertyeditor.EntityAttributeValueModelInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.PropertyValueInterface;
import com.sas.util.transforms.ObjectToStringTransform;
import com.sas.util.transforms.StringToMissingValuesTransform;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class EntityAttributeValueSelectorAdapter
implements EntityAttributeValueModelInterface {
    public static final String RB_KEY = "EntityAttributeValueSelectorAdapter.";
    protected PropertyChangeSupport propertyChangeSupport;
    protected BusinessQuery query;
    protected RemoteEntityInterface entity;
    protected Map currentValues;
    protected Map selectionModeMap;
    protected Map availableValues;
    protected Object applicationData;
    protected Map businessQueryExtendedProperties;
    protected Map supplementalProperties;
    protected Map editorInstructionTextMap;
    protected Map propertyEditorInstructionText;
    protected Map defaultEditorMap;
    protected Map queryInfo;
    protected Map dvHandlers;
    protected Map attributesMap;
    protected String emptyStringText;

    public EntityAttributeValueSelectorAdapter(RemoteEntityInterface entity) {
        this(entity, null, null);
    }

    public EntityAttributeValueSelectorAdapter(RemoteEntityInterface entity, Map dvHandlers, Map queryInfo) {
        this.entity = entity;
        this.dvHandlers = dvHandlers;
        this.queryInfo = queryInfo;
        this.initializeComponents();
    }

    public EntityAttributeValueSelectorAdapter(BusinessQuery businessQuery) {
        this(businessQuery, null, null);
    }

    public EntityAttributeValueSelectorAdapter(BusinessQuery businessQuery, Map dvHandlers, Map queryInfo) {
        this.query = businessQuery;
        if (this.query != null) {
            this.entity = this.query.getEntity();
        }
        this.initializeComponents();
        this.setBusinessQueryExtendedProperties();
    }

    protected void initializeComponents() {
        this.currentValues = new HashMap();
        this.availableValues = new HashMap();
        this.supplementalProperties = new HashMap();
        this.propertyEditorInstructionText = new HashMap();
        this.attributesMap = new HashMap();
        this.createDefaultEditorInstructionText();
        this.createDefaultEditorMappings();
        this.emptyStringText = "  ";
    }

    protected void setBusinessQueryExtendedProperties() {
        this.businessQueryExtendedProperties = new HashMap();
        if (this.entity == null) {
            return;
        }
        try {
            AttributeDescriptorInterface[] attributes = this.entity.getAttributeDescriptors();
            for (int i = 0; i < attributes.length; ++i) {
                AttributeDescriptorInterface adi = attributes[i];
                if (!adi.isVisible()) continue;
                this.businessQueryExtendedProperties.put(adi.getName(), new HashMap());
            }
        }
        catch (RemoteException re) {
            return;
        }
        if (this.query != null) {
            BusinessQueryToAdvancedFilterModelAdapter adapter = new BusinessQueryToAdvancedFilterModelAdapter(this.query);
            for (FilterLogicTestNodeInterface filterItem : adapter.getSelectionTree().getUnderstoodTestNodeList()) {
                for (Object value : filterItem.getTestValuesList()) {
                    if (!adapter.isPromptedValue(value) || !(value instanceof FilterValueInterface) || !((value = ((FilterValueInterface)value).getData()) instanceof Prompt)) continue;
                    String promptName = ((Prompt)value).getLabel();
                    String dataItemLabel = filterItem.getFilterItem().getItemLabel();
                    if (!this.businessQueryExtendedProperties.containsKey(promptName)) continue;
                    Map supMap = (Map)this.businessQueryExtendedProperties.get(promptName);
                    String filterName = adapter.getFilterLabel();
                    supMap.put("supplementalProperty_filterName", filterName);
                    ArrayList<String> dataItems = (ArrayList<String>)supMap.get("supplementalProperty_dataItem");
                    if (dataItems == null) {
                        dataItems = new ArrayList<String>();
                        supMap.put("supplementalProperty_dataItem", dataItems);
                    }
                    if (dataItems.contains(dataItemLabel)) continue;
                    dataItems.add(dataItemLabel);
                }
            }
        }
    }

    public Map getProperties(Locale locale) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.entity != null) {
            try {
                AttributeDescriptorInterface[] attributes = this.entity.getAttributeDescriptors();
                for (int i = 0; i < attributes.length; ++i) {
                    AttributeDescriptorInterface adi = attributes[i];
                    if (!adi.isVisible()) continue;
                    properties.put(adi.getName(), adi.getLabel(locale));
                    this.currentValues.put(adi.getName(), this.entity.getAttribute(adi.getName()));
                    this.attributesMap.put(adi.getName(), adi);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return properties;
    }

    public String getEditor(String propertyName, String context) {
        String editor = null;
        if (this.entity != null) {
            try {
                AttributeDescriptorInterface attribute = this.entity.getAttributeDescriptor(propertyName);
                editor = attribute.getEditor(context);
                if (editor == null) {
                    int type = this.getSelectionMode(propertyName);
                    Map editors = (Map)this.defaultEditorMap.get(context);
                    if (editors != null) {
                        editor = (String)editors.get(new Integer(type));
                    }
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return editor;
    }

    public void setValue(String property, Object value) {
        if (value instanceof List) {
            int listSize = ((List)value).size();
            for (int i = 0; i < listSize; ++i) {
                Object o = ((List)value).get(i);
                if (!(o instanceof PropertyValueInterface)) continue;
                ((List)value).set(i, ((PropertyValueInterface)o).getUnformattedValue());
            }
            this.validateValue(value, property, true);
            this.currentValues.put(property, value);
        } else if (value instanceof PropertyValueInterface) {
            this.validateValue(((PropertyValueInterface)value).getUnformattedValue(), property, true);
            this.currentValues.put(property, ((PropertyValueInterface)value).getUnformattedValue());
        } else {
            this.validateValue(value, property, true);
            this.currentValues.put(property, value);
        }
    }

    public boolean validateValue(Object value, String propertyName, boolean throwException) {
        AttributeDescriptorInterface adi = (AttributeDescriptorInterface)this.attributesMap.get(propertyName);
        int selectionMode = this.getSelectionMode(propertyName);
        if (selectionMode == 2) {
            int listSize = ((List)value).size();
            if (listSize == 0) {
                if (throwException) {
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "noItemSelected.err.txt"));
                }
                return false;
            }
        } else if (selectionMode == 1 && value == null) {
            if (throwException) {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "noItemSelected.err.txt"));
            }
            return false;
        }
        try {
            if (!AttributeTypeUtility.validateAttributeValue((Object)value, (AttributeDescriptorInterface)adi, (boolean)throwException)) {
                return false;
            }
            if (!adi.isRequired()) {
                return true;
            }
            if (this.getType(propertyName) == 0) {
                if (value == null || value.toString().trim().length() == 0) {
                    throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource((String)"blankValueNotValid.ex.txt"), propertyName));
                }
                return true;
            }
            return true;
        }
        catch (IllegalArgumentException iae) {
            if (this.getType(propertyName) == 2 || this.getType(propertyName) == 3) {
                if (value instanceof List) {
                    List multiValues = (List)value;
                    boolean goodValue = true;
                    int size = multiValues.size();
                    for (int i = 0; i < size; ++i) {
                        Object o = multiValues.get(i);
                        if (!AttributeTypeUtility.isValidMissingValueString(o)) {
                            return AttributeTypeUtility.validateAttributeValue(o, (AttributeDescriptorInterface)adi, (boolean)throwException);
                        }
                        multiValues.set(i, StringToMissingValuesTransform.defaultInstance.transform(o));
                        goodValue = true;
                    }
                    return goodValue;
                }
                if (AttributeTypeUtility.isValidMissingValueString((Object)value)) {
                    return true;
                }
                if (throwException) {
                    throw iae;
                }
                return false;
            }
            if (adi.isRequired()) {
                if (throwException) {
                    throw new IllegalArgumentException(iae.getLocalizedMessage());
                }
                return false;
            }
            if (this.validatePreviousValueForOptionalAttribute(value, adi)) {
                this.currentValues.remove(propertyName);
                return true;
            }
            throw new IllegalArgumentException(iae.getLocalizedMessage());
        }
    }

    protected boolean validatePreviousValueForOptionalAttribute(Object value, AttributeDescriptorInterface adi) {
        if (!adi.isDefaultValueHasBeenSet()) {
            String attributeName = adi.getName();
            int type = this.getType(adi.getName());
            try {
                if (type == 5) {
                    return this.entity.getAttribute(attributeName) == null && (value == null || value.toString().trim().equals(""));
                }
                if (type == 6) {
                    return this.entity.getStringAttribute(attributeName, adi.getStringDefault()) == null && (value == null || value.toString().equals(""));
                }
                return false;
            }
            catch (RemoteException re) {
                return false;
            }
        }
        return false;
    }

    public List getAvailableValues(String propertyName) {
        if (this.availableValues.containsKey(propertyName)) {
            return (List)this.availableValues.get(propertyName);
        }
        try {
            AttributeDescriptorInterface adi = this.entity.getAttributeDescriptor(propertyName);
            String configXML = adi.getConfigurationXML();
            if (configXML == null) {
                ArrayList list = new ArrayList();
                this.availableValues.put(propertyName, list);
                return list;
            }
            ParsedConfigurationXMLObject parsedObject = ConfigurationXMLPersistenceUtility.createParsedConfigurationXMLObject((String)configXML, (Map)this.dvHandlers);
            Map valuesLabelMap = null;
            if (parsedObject.getDynamicValuesProvider() != null) {
                String queryType = parsedObject.getQueryType();
                try {
                    if (this.queryInfo != null) {
                        valuesLabelMap = parsedObject.getDynamicValuesProvider().getMapOfValues(this.queryInfo.get(queryType));
                    }
                    valuesLabelMap = parsedObject.getDynamicValuesProvider().getMapOfValues(null);
                }
                catch (IllegalArgumentException iae) {
                    IllegalArgumentException newException = new IllegalArgumentException(iae.getMessage());
                    newException.initCause(iae);
                    throw newException;
                }
                catch (IllegalStateException ise) {
                    IllegalStateException newException = new IllegalStateException(ise.getMessage());
                    newException.initCause(ise);
                    throw newException;
                }
            } else {
                valuesLabelMap = parsedObject.getEnumerationValuesLabelsMap(Locale.getDefault());
            }
            ArrayList<DefaultPropertyValue> propertyValuesList = new ArrayList<DefaultPropertyValue>();
            if (valuesLabelMap != null) {
                Iterator iter = valuesLabelMap.keySet().iterator();
                int sqlType = this.getType(propertyName);
                while (iter.hasNext()) {
                    Object value = iter.next();
                    String label = (String)ObjectToStringTransform.defaultInstance.transform(valuesLabelMap.get(value));
                    if (label != null && label.length() == 0) {
                        label = this.getTextForEmptyStringLabel();
                    }
                    String transformedValue = null;
                    transformedValue = sqlType == 7 || sqlType == 8 ? (String)value : AttributeTypeUtility.transformValueToSASFormat(value, (AttributeTypeInterface)adi.getType());
                    if (label != null) {
                        label = label.trim();
                    }
                    propertyValuesList.add(new DefaultPropertyValue(label, transformedValue));
                }
                this.availableValues.put(propertyName, propertyValuesList);
            }
            return propertyValuesList;
        }
        catch (RemoteException re) {
            return new ArrayList();
        }
    }

    public void commitChanges() {
        if (this.entity != null) {
            for (String attributeName : this.currentValues.keySet()) {
                Object value = this.currentValues.get(attributeName);
                AttributeDescriptorInterface adi = (AttributeDescriptorInterface)this.attributesMap.get(attributeName);
                try {
                    if (!AttributeTypeUtility.validateAttributeValue(value, (AttributeDescriptorInterface)this.entity.getAttributeDescriptor(attributeName), (boolean)true)) continue;
                    this.entity.setAttribute(attributeName, value);
                }
                catch (Exception ex) {
                    int sqlType;
                    AttributeTypeInterface ati = adi.getType();
                    if (ati == null || value == null || (sqlType = ati.getSQLType()) != 8 && sqlType != 6) continue;
                    if (value instanceof List) {
                        int listSize = ((List)value).size();
                        for (int i = 0; i < listSize; ++i) {
                            Object o = ((List)value).get(i);
                            if (!AttributeTypeUtility.isValidMissingValueString(o)) continue;
                            ((List)value).set(i, StringToMissingValuesTransform.defaultInstance.transform(o));
                        }
                        try {
                            this.entity.setAttribute(attributeName, StringToMissingValuesTransform.defaultInstance.transform(value));
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (!AttributeTypeUtility.isValidMissingValueString(value)) continue;
                    try {
                        this.entity.setAttribute(attributeName, StringToMissingValuesTransform.defaultInstance.transform(value));
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void cancel() {
        this.currentValues.clear();
        this.getProperties(Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSelectedValues(String propertyName) {
        ArrayList<DefaultPropertyValue> selectedValuesList = new ArrayList<DefaultPropertyValue>();
        if (this.entity == null) {
            return selectedValuesList;
        }
        try {
            if (!this.availableValues.containsKey(propertyName)) {
                this.getAvailableValues(propertyName);
            }
            Object currentValue = this.currentValues.get(propertyName);
            AttributeDescriptorInterface adi = this.entity.getAttributeDescriptor(propertyName);
            AttributeTypeInterface ati = adi.getType();
            int sqlType = this.getType(propertyName);
            String transformedValue = null;
            if (currentValue instanceof List) {
                for (Object value : (List)currentValue) {
                    transformedValue = sqlType == 7 || sqlType == 8 ? value : AttributeTypeUtility.transformValueToSASFormat(value, (AttributeTypeInterface)adi.getType());
                    selectedValuesList.add(new DefaultPropertyValue(this.getLabelForValue(propertyName, transformedValue), transformedValue));
                }
            } else {
                transformedValue = sqlType == 7 || sqlType == 8 ? (String)currentValue : AttributeTypeUtility.transformValueToSASFormat(currentValue, (AttributeTypeInterface)adi.getType());
                selectedValuesList.add(new DefaultPropertyValue(this.getLabelForValue(propertyName, transformedValue), transformedValue));
            }
        }
        catch (RemoteException remoteException) {}
        finally {
            return selectedValuesList;
        }
    }

    private String getLabelForValue(String propertyName, Object value) {
        if (!this.availableValues.containsKey(propertyName)) {
            this.getAvailableValues(propertyName);
        }
        String label = null;
        List vals = (List)this.availableValues.get(propertyName);
        if (vals != null && vals.size() > 0) {
            for (DefaultPropertyValue val : vals) {
                if (!val.getUnformattedValue().equals(value)) continue;
                label = val.getFormattedValue();
                if (label == null && value != null) {
                    label = value.toString();
                }
                break;
            }
        } else {
            label = value != null ? value.toString() : "";
        }
        return label;
    }

    private int getSelectionMode(String propertyName) {
        try {
            if (this.selectionModeMap == null) {
                this.selectionModeMap = new HashMap();
            }
            if (this.selectionModeMap.containsKey(propertyName)) {
                return (Integer)this.selectionModeMap.get(propertyName);
            }
            AttributeDescriptorInterface adi = this.entity.getAttributeDescriptor(propertyName);
            AttributeTypeInterface ati = adi.getType();
            int sqlType = ati.getSQLType();
            String configXML = adi.getConfigurationXML();
            if (sqlType == 16) {
                return 3;
            }
            if (configXML == null) {
                if (sqlType == 91 || sqlType == 92 || sqlType == 93) {
                    return 4;
                }
                this.selectionModeMap.put(propertyName, new Integer(0));
                return 0;
            }
            ParsedConfigurationXMLObject parsedObject = ConfigurationXMLPersistenceUtility.createParsedConfigurationXMLObject((String)configXML, (Map)this.dvHandlers);
            if (parsedObject.hasEnumeration()) {
                if (EntityHelper.isMultipleValuesAllowed((AttributeDescriptorInterface)adi, null)) {
                    this.selectionModeMap.put(propertyName, new Integer(2));
                    return 2;
                }
                this.selectionModeMap.put(propertyName, new Integer(1));
                return 1;
            }
            if (sqlType == 91 || sqlType == 92 || sqlType == 93) {
                return 4;
            }
            this.selectionModeMap.put(propertyName, new Integer(0));
            return 0;
        }
        catch (RemoteException re) {
            return Integer.MAX_VALUE;
        }
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    public void setApplicationData(Object data) {
        this.applicationData = data;
    }

    public Map getSupplementalProperties(String propertyName) {
        Map props;
        if (this.supplementalProperties.containsKey(propertyName)) {
            return (Map)this.supplementalProperties.get(propertyName);
        }
        LinkedHashMap<String, String> propMap = new LinkedHashMap<String, String>();
        if (this.query != null && (props = (Map)this.businessQueryExtendedProperties.get(propertyName)) != null) {
            List dataItems;
            String filterName = (String)props.get("supplementalProperty_filterName");
            if (filterName != null && filterName.length() > 0) {
                propMap.put(RB.getStringResource(RB_KEY, "filterName.txt"), filterName);
            }
            if ((dataItems = (List)props.get("supplementalProperty_dataItem")) != null && dataItems.size() > 0) {
                String dataItemsString = "";
                Iterator iter = dataItems.iterator();
                while (iter.hasNext()) {
                    String element = (String)iter.next();
                    if (element != null && element.length() > 0) {
                        dataItemsString = dataItemsString + element;
                    }
                    if (!iter.hasNext()) continue;
                    dataItemsString = dataItemsString + ", ";
                }
                if (dataItemsString.length() > 0) {
                    propMap.put(RB.getStringResource(RB_KEY, "dataItems.txt"), dataItemsString);
                }
            }
        }
        try {
            Object obj;
            AttributeDescriptorInterface adi;
            if (this.entity != null && EntityUtil.attributeDescriptorHasSupplementalProperty((AttributeDescriptorInterface)(adi = this.entity.getAttributeDescriptor(propertyName)), (String)"SASEditorExtendedProperties") && (obj = adi.getSupplementalProperty("SASEditorExtendedProperties")) instanceof Map) {
                Map userPropertyMap = (Map)obj;
                for (Object propLabel : userPropertyMap.keySet()) {
                    Object propValue = userPropertyMap.get(propLabel);
                    propMap.put(propLabel.toString(), propValue.toString());
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.supplementalProperties.put(propertyName, propMap);
        return propMap;
    }

    public String getTextForEmptyStringLabel() {
        return this.emptyStringText;
    }

    public void setTextForEmptyStringLabel(String emptyStringText) {
        this.emptyStringText = emptyStringText;
    }

    public int getType(String propertyName) {
        try {
            AttributeDescriptorInterface adi = this.entity.getAttributeDescriptor(propertyName);
            AttributeTypeInterface ati = adi.getType();
            int sqlType = ati.getSQLType();
            if (sqlType == 12) {
                if (AttributeTypeUtility.isColorStringClass((AttributeTypeInterface)ati)) {
                    return 6;
                }
                return 0;
            }
            if (sqlType == 8) {
                return 2;
            }
            if (sqlType == 6) {
                return 3;
            }
            if (sqlType == 16) {
                return 4;
            }
            if (sqlType == 4) {
                return 1;
            }
            if (sqlType == 91) {
                return 5;
            }
            if (sqlType == 92) {
                return 7;
            }
            if (sqlType == 93) {
                return 8;
            }
            return Integer.MAX_VALUE;
        }
        catch (RemoteException re) {
            return Integer.MAX_VALUE;
        }
    }

    public void setEditorInstructionText(Map editorInformationTextMap) {
        this.editorInstructionTextMap = editorInformationTextMap;
    }

    public String getEditorInstructionText(String propertyName) {
        Integer type;
        if (this.propertyEditorInstructionText.containsKey(propertyName)) {
            return (String)this.propertyEditorInstructionText.get(propertyName);
        }
        String instructionText = null;
        if (this.entity != null) {
            try {
                Object obj;
                AttributeDescriptorInterface adi = this.entity.getAttributeDescriptor(propertyName);
                if (EntityUtil.attributeDescriptorHasSupplementalProperty((AttributeDescriptorInterface)adi, (String)"SASEditorInstructionText") && (obj = adi.getSupplementalProperty("SASEditorInstructionText")) instanceof String) {
                    instructionText = (String)obj;
                }
            }
            catch (RemoteException adi) {
                // empty catch block
            }
        }
        if (instructionText == null && this.editorInstructionTextMap.containsKey(type = new Integer(this.getType(propertyName)))) {
            instructionText = this.editorInstructionTextMap.get(type).toString();
        }
        if (instructionText != null) {
            this.propertyEditorInstructionText.put(propertyName, instructionText);
        }
        return instructionText;
    }

    protected void createDefaultEditorInstructionText() {
        this.editorInstructionTextMap = new HashMap();
        this.editorInstructionTextMap.put(new Integer(6), RB.getStringResource(RB_KEY, "colorHelp.txt"));
        this.editorInstructionTextMap.put(new Integer(5), RB.getStringResource(RB_KEY, "dateHelp.txt"));
    }

    protected void createDefaultEditorMappings() {
        this.defaultEditorMap = new HashMap();
        HashMap<Integer, String> jspEditorMap = new HashMap<Integer, String>();
        jspEditorMap.put(new Integer(0), "com.sas.servlet.tbeans.dataselectors.propertyeditor.editors.html.TextEntryPropertyEditor");
        jspEditorMap.put(new Integer(2), "com.sas.servlet.tbeans.dataselectors.propertyeditor.editors.html.CheckBoxListPropertyEditor");
        jspEditorMap.put(new Integer(1), "com.sas.servlet.tbeans.dataselectors.propertyeditor.editors.html.ListBoxViewPropertyEditor");
        this.defaultEditorMap.put("JSPPanel", jspEditorMap);
        HashMap<Integer, String> swingEditorMap = new HashMap<Integer, String>();
        swingEditorMap.put(new Integer(0), "com.sas.swing.visuals.dataselectors.propertyeditor.TextFieldEditorPanel");
        swingEditorMap.put(new Integer(2), "com.sas.swing.visuals.dataselectors.propertyeditor.MultiSelectionListEditorPanel");
        swingEditorMap.put(new Integer(1), "com.sas.swing.visuals.dataselectors.propertyeditor.SingleSelectionListEditorPanel");
        swingEditorMap.put(new Integer(3), "com.sas.swing.visuals.dataselectors.propertyeditor.RadioButtonEditorPanel");
        swingEditorMap.put(new Integer(4), "com.sas.swing.visuals.dataselectors.propertyeditor.DateEditorPanel");
        this.defaultEditorMap.put("JavaPanel", swingEditorMap);
    }

    public void setEditorMapping(int type, String context, String editorClassName) {
        if (!context.equals("JSPPanel") && !context.equals("JavaPanel")) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "editorMap.txt"));
        }
        Map editors = (Map)this.defaultEditorMap.get(context);
        editors.put(new Integer(type), editorClassName);
    }

    public AttributeDescriptorInterface getAttributeDescriptor(String propertyName) {
        return (AttributeDescriptorInterface)this.attributesMap.get(propertyName);
    }

    public boolean isRequired(String propertyName) {
        return ((AttributeDescriptorInterface)this.attributesMap.get(propertyName)).isRequired();
    }

    private Object ObjectToMissingValuesTransform(Object value, String propertyName) {
        if (value == null) {
            return null;
        }
        if ((this.getType(propertyName) == 2 || this.getType(propertyName) == 3) && AttributeTypeUtility.isValidMissingValueString((Object)ObjectToStringTransform.defaultInstance.transform(value))) {
            return StringToMissingValuesTransform.defaultInstance.transform(value);
        }
        return value;
    }
}

