/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.memberproperties;

import com.sas.dataselectors.memberproperties.MemberPropertiesSelectorDataSourceInterface;
import com.sas.dataselectors.memberproperties.MemberPropertyItem;
import com.sas.dataselectors.memberproperties.NodeInfo;
import com.sas.dataselectors.memberproperties.RB;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PropertyInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MemberPropertiesSelectorOLAPDataSource
implements MemberPropertiesSelectorDataSourceInterface {
    private String RB_KEY = "MemberPropertiesSelectorOLAPDataSource.";
    private Locale locale;
    private Map dimensionUniqueNameToLabelMap;
    private Map dimensionNameToUniqueNameMap;
    private Map levelUniqueNameToLabelMap;
    private Map hierarchyUniqueNameToLabelMap;
    protected BusinessQueryProviderInterface model;

    public MemberPropertiesSelectorOLAPDataSource() {
        this(null);
    }

    public MemberPropertiesSelectorOLAPDataSource(BusinessQueryProviderInterface model) {
        this.setModel(model);
    }

    protected void setModel(BusinessQueryProviderInterface model) {
        this.model = model;
    }

    protected BusinessQueryProviderInterface getModel() {
        return this.model;
    }

    public List getAvailableProperties() {
        ArrayList availableProperties = new ArrayList();
        BusinessQueryProviderInterface model = this.getModel();
        this.validateModel(model);
        OLAPDataSetInterface olapDataSet = (OLAPDataSetInterface)model;
        try {
            MetadataInterface metadata = olapDataSet.getDatabaseMetadata();
            Filter metaFilter = new Filter();
            metaFilter.setCubeName(olapDataSet.getCubeName());
            this.initMetaDataNameMaps(metadata, metaFilter);
            AxisInterface[] axes = olapDataSet.getResultSetMetadata().getAxes(0, -1);
            for (int i = 0; i < axes.length; ++i) {
                this.populateAvailableListForAxis(availableProperties, axes[i], metaFilter, metadata);
            }
        }
        catch (OLAPException oe) {
            throw new RuntimeException(oe);
        }
        return availableProperties;
    }

    private List getVisibleHierarchyNames(AxisInterface axis) {
        ArrayList<String> visibleHierarchies = new ArrayList<String>();
        if (axis == null) {
            return visibleHierarchies;
        }
        String[] hierarchyNames = null;
        try {
            hierarchyNames = axis.getHierarchyNames();
        }
        catch (OLAPException oe) {
            throw new RuntimeException(oe);
        }
        if (hierarchyNames == null) {
            return visibleHierarchies;
        }
        for (int i = 0; i < hierarchyNames.length; ++i) {
            if (visibleHierarchies.contains(hierarchyNames[i])) continue;
            visibleHierarchies.add(hierarchyNames[i]);
        }
        return visibleHierarchies;
    }

    private void populateAvailableListForAxis(List dimensionNodeList, AxisInterface axis, Filter filter, MetadataInterface metadata) {
        try {
            if (axis.getAxisNumber() == -1) {
                return;
            }
        }
        catch (OLAPException oe) {
            throw new RuntimeException(oe);
        }
        List visibleHierarchies = this.getVisibleHierarchyNames(axis);
        int numberOfHierarchies = visibleHierarchies.size();
        for (int i = 0; i < numberOfHierarchies; ++i) {
            filter.setUniqueHierarchyName((String)visibleHierarchies.get(i));
            List levelNodeInfos = this.getNodeInfosForLevelsWithProperties(filter, metadata, this.levelUniqueNameToLabelMap);
            filter.setUniqueHierarchyName(null);
            int numberOfLevels = levelNodeInfos.size();
            if (numberOfLevels <= 0) continue;
            NodeInfo dimensionNodeInfo = new NodeInfo();
            dimensionNodeInfo.setText((String)this.hierarchyUniqueNameToLabelMap.get((String)visibleHierarchies.get(i)));
            dimensionNodeInfo.setUniqueName((String)visibleHierarchies.get(i));
            for (int j = 0; j < numberOfLevels; ++j) {
                dimensionNodeInfo.add((NodeInfo)levelNodeInfos.get(j));
            }
            dimensionNodeList.add(dimensionNodeInfo);
        }
    }

    private List getNodeInfosForLevelsWithProperties(Filter filter, MetadataInterface metadata, Map levelNameToLabelMap) {
        ArrayList<NodeInfo> levelNodeInfos = new ArrayList<NodeInfo>();
        try {
            LevelInterface[] levels = metadata.getLevels(filter);
            if (levels == null) {
                return levelNodeInfos;
            }
            for (int i = 0; i < levels.length; ++i) {
                LevelInterface level = levels[i];
                if (level.getHierarchy().getDimension().getType() == 2) continue;
                String uniqueLevelName = level.getUniqueName();
                filter.setUniqueLevelName(uniqueLevelName);
                List memberPropertyNodeInfos = this.getMemberPropertyNodeInfos(filter, metadata);
                filter.setUniqueLevelName(null);
                int numberOfProperties = memberPropertyNodeInfos.size();
                if (numberOfProperties <= 0) continue;
                NodeInfo levelNodeInfo = new NodeInfo();
                levelNodeInfo.setText((String)levelNameToLabelMap.get(uniqueLevelName));
                levelNodeInfo.setUniqueName(uniqueLevelName);
                for (int j = 0; j < numberOfProperties; ++j) {
                    levelNodeInfo.add((NodeInfo)memberPropertyNodeInfos.get(j));
                }
                levelNodeInfos.add(levelNodeInfo);
            }
        }
        catch (OLAPException oe) {
            throw new RuntimeException(oe);
        }
        return levelNodeInfos;
    }

    private List getMemberPropertyNodeInfos(Filter filter, MetadataInterface metadata) {
        ArrayList<NodeInfo> propertyNodeInfos = new ArrayList<NodeInfo>();
        PropertyInterface[] properties = null;
        try {
            properties = metadata.getProperties(filter);
            if (properties == null) {
                return propertyNodeInfos;
            }
            for (int i = 0; i < properties.length; ++i) {
                NodeInfo propertyNodeInfo = new NodeInfo();
                propertyNodeInfo.setText(properties[i].getLabel());
                propertyNodeInfo.setUniqueName(properties[i].getName());
                propertyNodeInfo.setAllowsChildren(false);
                propertyNodeInfos.add(propertyNodeInfo);
            }
        }
        catch (OLAPException oe) {
            throw new RuntimeException(oe);
        }
        return propertyNodeInfos;
    }

    private void initMetaDataNameMaps(MetadataInterface metadata, Filter filter) {
        int i;
        this.dimensionUniqueNameToLabelMap = new HashMap();
        this.dimensionNameToUniqueNameMap = new HashMap();
        try {
            DimensionInterface[] dimensions = metadata.getDimensions(filter);
            for (i = 0; i < dimensions.length; ++i) {
                this.dimensionUniqueNameToLabelMap.put(dimensions[i].getUniqueName(), dimensions[i].getLabel());
                this.dimensionNameToUniqueNameMap.put(dimensions[i].getName(), dimensions[i].getUniqueName());
            }
        }
        catch (OLAPException oe) {
            throw new RuntimeException(oe);
        }
        this.hierarchyUniqueNameToLabelMap = new HashMap();
        try {
            HierarchyInterface[] hierarchies = metadata.getHierarchies(filter);
            for (i = 0; i < hierarchies.length; ++i) {
                this.hierarchyUniqueNameToLabelMap.put(hierarchies[i].getUniqueName(), hierarchies[i].getLabel());
            }
        }
        catch (OLAPException oe) {
            throw new RuntimeException(oe);
        }
        this.levelUniqueNameToLabelMap = new HashMap();
        try {
            LevelInterface[] levels = metadata.getLevels(filter);
            for (i = 0; i < levels.length; ++i) {
                this.levelUniqueNameToLabelMap.put(levels[i].getUniqueName(), levels[i].getLabel());
            }
        }
        catch (OLAPException oe) {
            throw new RuntimeException(oe);
        }
    }

    public List getProperties() {
        ArrayList currentList = new ArrayList();
        BusinessQueryProviderInterface bqProvider = this.getModel();
        this.validateModel(bqProvider);
        OLAPDataSetInterface olapDataSet = (OLAPDataSetInterface)bqProvider;
        BusinessQuery businessQuery = bqProvider.getBusinessQuery();
        try {
            MetadataInterface metadata = olapDataSet.getDatabaseMetadata();
            Filter metaFilter = new Filter();
            metaFilter.setCubeName(olapDataSet.getCubeName());
            this.initMetaDataNameMaps(metadata, metaFilter);
            AxisInterface[] axes = olapDataSet.getResultSetMetadata().getAxes(0, -1);
            List resultItems = businessQuery.getResultItems();
            int numberOfItems = resultItems.size();
            for (int i = 0; i < numberOfItems; ++i) {
                DataItem dataItem = (DataItem)resultItems.get(i);
                this.populateCurrentList(currentList, dataItem, metaFilter, metadata, businessQuery, axes);
            }
        }
        catch (OLAPException oe) {
            throw new RuntimeException(oe);
        }
        return currentList;
    }

    private String getUniqueHierarchyNameFromDimensionName(String dimensionName, AxisInterface[] axes) {
        try {
            int axisPosition = 0;
            int namePosition = -1;
            for (int i = 0; i < axes.length && namePosition == -1; ++i) {
                String[] dimensionNames = axes[i].getDimensionNames();
                if (dimensionNames == null) continue;
                for (int j = 0; j < dimensionNames.length && namePosition == -1; ++j) {
                    if (!dimensionName.equals(dimensionNames[j])) continue;
                    namePosition = j;
                    axisPosition = i;
                }
            }
            if (namePosition == -1) {
                return null;
            }
            String[] hierarchyUniqueNames = axes[axisPosition].getHierarchyNames();
            return hierarchyUniqueNames[namePosition];
        }
        catch (OLAPException oe) {
            throw new RuntimeException(oe);
        }
    }

    private void populateCurrentList(List currentList, DataItem dataItem, Filter metaFilter, MetadataInterface metadata, BusinessQuery businessQuery, AxisInterface[] axes) {
        if (dataItem == null) {
            return;
        }
        try {
            boolean isMeasure = BusinessQueryOLAPUtil.isInMeasureDimension((BusinessModel)businessQuery.getBusinessModel(), (DataItem)dataItem);
            if (isMeasure) {
                return;
            }
            String dimensionName = BusinessQueryOLAPUtil.getDimensionName((BusinessModel)businessQuery.getBusinessModel(), (DataItem)dataItem);
            if (dimensionName == null) {
                return;
            }
            String uniqueHierarchyName = this.getUniqueHierarchyNameFromDimensionName(dimensionName, axes);
            metaFilter.setUniqueHierarchyName(uniqueHierarchyName);
            PropertyInterface[] properties = metadata.getProperties(metaFilter);
            List memberProperties = dataItem.getMemberProperties();
            int numberOfProperties = memberProperties.size();
            for (int i = 0; i < numberOfProperties; ++i) {
                String propertyName = (String)memberProperties.get(i);
                if (properties == null) continue;
                for (int j = 0; j < properties.length; ++j) {
                    PropertyInterface property = properties[j];
                    if (!propertyName.equals(property.getName())) continue;
                    String uniqueLevelName = property.getLevel().getUniqueName();
                    NodeInfo dimensionNodeInfo = this.getDimensionNodeInfo(currentList, uniqueHierarchyName, (String)this.hierarchyUniqueNameToLabelMap.get(uniqueHierarchyName));
                    NodeInfo levelNodeInfo = this.getLevelNodeInfo(dimensionNodeInfo, uniqueLevelName, (String)this.levelUniqueNameToLabelMap.get(uniqueLevelName));
                    NodeInfo nodeInfo = this.getPropertyNodeInfo(levelNodeInfo, property.getName(), property.getLabel());
                }
            }
        }
        catch (MetadataException mde) {
            throw new RuntimeException(mde);
        }
        catch (OLAPException oe) {
            throw new RuntimeException(oe);
        }
    }

    private NodeInfo getDimensionNodeInfo(List list, String uniqueName, String text) {
        if (list == null || uniqueName == null) {
            return null;
        }
        NodeInfo dimensionNodeInfo = this.findNodeInfo(list, uniqueName, true);
        if (dimensionNodeInfo == null) {
            dimensionNodeInfo = this.newNodeInfo(uniqueName, text, true);
            list.add(dimensionNodeInfo);
        }
        return dimensionNodeInfo;
    }

    private NodeInfo getLevelNodeInfo(NodeInfo dimensionNodeInfo, String uniqueName, String text) {
        if (dimensionNodeInfo == null || uniqueName == null) {
            return null;
        }
        NodeInfo levelNodeInfo = this.findNodeInfo(dimensionNodeInfo.getChildren(), uniqueName, true);
        if (levelNodeInfo == null) {
            levelNodeInfo = this.newNodeInfo(uniqueName, text, true);
            dimensionNodeInfo.add(levelNodeInfo);
        }
        return levelNodeInfo;
    }

    private NodeInfo getPropertyNodeInfo(NodeInfo levelNodeInfo, String uniqueName, String text) {
        if (levelNodeInfo == null || text == null) {
            return null;
        }
        NodeInfo propertyNodeInfo = this.findNodeInfo(levelNodeInfo.getChildren(), text, false);
        if (propertyNodeInfo == null) {
            propertyNodeInfo = this.newNodeInfo(uniqueName, text, false);
            levelNodeInfo.add(propertyNodeInfo);
        }
        return propertyNodeInfo;
    }

    private NodeInfo findNodeInfo(List list, String key, boolean uniqueKey) {
        if (list == null || key == null) {
            return null;
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            NodeInfo nodeInfo = (NodeInfo)list.get(i);
            if (!(uniqueKey ? key.equals(nodeInfo.getUniqueName()) : key.equals(nodeInfo.getText()))) continue;
            return nodeInfo;
        }
        return null;
    }

    private NodeInfo newNodeInfo(String uniqueName, String text, boolean allowsChildren) {
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.setText(text);
        nodeInfo.setUniqueName(uniqueName);
        nodeInfo.setAllowsChildren(allowsChildren);
        return nodeInfo;
    }

    public void commit() {
        BusinessQueryProviderInterface model = this.getModel();
        this.validateModel(model);
        BusinessQuery businessQuery = model.getBusinessQuery();
        try {
            model.refreshBusinessQuery(businessQuery);
        }
        catch (IntelligentQueryException iqe) {
            throw new RuntimeException(iqe);
        }
    }

    public void addItem(MemberPropertyItem itemInfo) {
        BusinessQueryProviderInterface model = this.getModel();
        this.validateModel(model);
        OLAPDataSetInterface olapDataSet = (OLAPDataSetInterface)model;
        try {
            DataItem dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItem(model.getBusinessQuery(), (OLAPDataSetInterface)model, itemInfo.getUniqueLevelName(), 3);
            ArrayList<String> memberProperties = new ArrayList<String>(dataItem.getMemberProperties());
            if (!memberProperties.contains(itemInfo.getPropertyName())) {
                memberProperties.add(itemInfo.getPropertyName());
            }
            dataItem.setMemberProperties(memberProperties);
        }
        catch (OLAPException oe) {
            throw new RuntimeException(oe);
        }
        catch (MetadataException me) {
            throw new RuntimeException(me);
        }
    }

    public void removeAllItems() {
        BusinessQueryProviderInterface businessQueryProvider = this.getModel();
        this.validateModel(businessQueryProvider);
        BusinessQuery businessQuery = businessQueryProvider.getBusinessQuery();
        try {
            List resultItems = businessQuery.getResultItems();
            int numberOfItems = resultItems.size();
            for (int i = 0; i < numberOfItems; ++i) {
                DataItem dataItem = (DataItem)resultItems.get(i);
                if (dataItem.getExpression() == null || !(dataItem.getExpression() instanceof Hierarchy)) continue;
                dataItem.setMemberProperties(new ArrayList());
            }
        }
        catch (MetadataException me) {
            throw new RuntimeException(me);
        }
    }

    private void validateModel(BusinessQueryProviderInterface bqProvider) {
        if (bqProvider == null) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"nullModel.txt", (Locale)this.getLocale()));
        }
        if (!(bqProvider instanceof OLAPDataSetInterface)) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"invalidModel.txt", (Locale)this.getLocale()));
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

