/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.memberproperties;

import com.sas.dataselectors.memberproperties.MemberPropertiesSelectorDataSourceInterface;
import com.sas.dataselectors.memberproperties.MemberPropertiesSelectorInterface;
import com.sas.dataselectors.memberproperties.MemberPropertiesSelectorOLAPDataSource;
import com.sas.dataselectors.memberproperties.MemberPropertyItem;
import com.sas.dataselectors.memberproperties.NodeInfo;
import com.sas.dataselectors.memberproperties.RB;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.util.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MemberPropertiesSelectorOLAPAdapter
implements MemberPropertiesSelectorInterface {
    private String RB_KEY = "MemberPropertiesSelectorOLAPAdapter.";
    private Locale locale;
    private String expandedLevel;
    private Map eventInfo = new HashMap();
    protected MemberPropertiesSelectorDataSourceInterface dataSource;
    protected List properties;

    public MemberPropertiesSelectorOLAPAdapter() {
        this(null);
    }

    public MemberPropertiesSelectorOLAPAdapter(MemberPropertiesSelectorDataSourceInterface dataSource) {
        this.setDataSource(dataSource);
    }

    protected void setDataSource(MemberPropertiesSelectorDataSourceInterface dataSource) {
        this.dataSource = dataSource;
    }

    protected MemberPropertiesSelectorDataSourceInterface getDataSource() {
        return this.dataSource;
    }

    public List getAvailableProperties() {
        MemberPropertiesSelectorDataSourceInterface dataSource = this.getDataSource();
        if (dataSource == null) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"nullDataSource.txt", (Locale)this.getLocale()));
        }
        List availableProperties = dataSource.getAvailableProperties();
        this.expandNodes(availableProperties);
        return availableProperties;
    }

    private void expandNodes(List availableProperties) {
        if (availableProperties == null || availableProperties.size() <= 0) {
            return;
        }
        String expandedLevel = this.getExpandedLevel();
        if (expandedLevel == null) {
            this.expandFirstLevel(availableProperties);
            return;
        }
        boolean exandableNodeInfoFound = false;
        int numOfDimensions = availableProperties.size();
        for (int i = 0; i < numOfDimensions && !exandableNodeInfoFound; ++i) {
            NodeInfo dimensionNodeInfo = (NodeInfo)availableProperties.get(i);
            List levelNodeInfos = dimensionNodeInfo.getChildren();
            int numOfLevels = levelNodeInfos.size();
            for (int j = 0; j < numOfLevels && !exandableNodeInfoFound; ++j) {
                NodeInfo levelNodeInfo = (NodeInfo)levelNodeInfos.get(j);
                if (!expandedLevel.equals(levelNodeInfo.getUniqueName())) continue;
                levelNodeInfo.setExpanded(true);
                dimensionNodeInfo.setExpanded(true);
                exandableNodeInfoFound = true;
            }
        }
        if (!exandableNodeInfoFound) {
            this.expandFirstLevel(availableProperties);
        }
    }

    private void expandFirstLevel(List availableProperties) {
        if (availableProperties == null || availableProperties.size() <= 0) {
            return;
        }
        NodeInfo firstDimensionNodeInfo = (NodeInfo)availableProperties.get(0);
        List levelNodeInfos = firstDimensionNodeInfo.getChildren();
        if (levelNodeInfos == null) {
            return;
        }
        NodeInfo firstLevelNodeInfo = (NodeInfo)levelNodeInfos.get(0);
        firstLevelNodeInfo.setExpanded(true);
        firstDimensionNodeInfo.setExpanded(true);
    }

    public List getProperties() {
        MemberPropertiesSelectorDataSourceInterface dataSource = this.getDataSource();
        if (dataSource == null) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"nullDataSource.txt", (Locale)this.getLocale()));
        }
        List currentProperties = dataSource.getProperties();
        this.expandNodes(currentProperties);
        return currentProperties;
    }

    public void setProperties(List properties) {
        MemberPropertiesSelectorDataSourceInterface dataSource = this.getDataSource();
        if (dataSource == null) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"nullDataSource.txt", (Locale)this.getLocale()));
        }
        this.properties = this.transformIfNecessary(properties);
    }

    public void setExpandedLevel(String expandedLevel) {
        this.expandedLevel = expandedLevel;
    }

    public String getExpandedLevel() {
        return this.expandedLevel;
    }

    public Map commit() {
        block3: {
            this.eventInfo.clear();
            MemberPropertiesSelectorDataSourceInterface dataSource = this.getDataSource();
            if (dataSource == null) {
                throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"nullDataSource.txt", (Locale)this.getLocale()));
            }
            try {
                dataSource.removeAllItems();
                this.addItems(this.properties);
                dataSource.commit();
            }
            catch (RuntimeException rte) {
                if (this.eventInfo.containsKey("EXCEPTION_OCCURRED")) break block3;
                this.eventInfo.put("EXCEPTION_OCCURRED", rte);
            }
        }
        return this.eventInfo;
    }

    private void addItems(List newItemsInfo) {
        if (newItemsInfo == null) {
            return;
        }
        int size = newItemsInfo.size();
        for (int i = 0; i < size; ++i) {
            this.getDataSource().addItem((MemberPropertyItem)newItemsInfo.get(i));
        }
    }

    public Object getPropertiesBean() {
        return null;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        if (this.getDataSource() != null) {
            this.getDataSource().setLocale(locale);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static MemberPropertiesSelectorInterface createDefaultAdapter(BusinessQueryProviderInterface model) {
        MemberPropertiesSelectorOLAPAdapter adapter = null;
        if (model instanceof BusinessQueryToOLAPDataSetAdapter) {
            MemberPropertiesSelectorOLAPDataSource dataSource = new MemberPropertiesSelectorOLAPDataSource(model);
            adapter = new MemberPropertiesSelectorOLAPAdapter(dataSource);
        }
        return adapter;
    }

    private List transformIfNecessary(List newItems) {
        if (newItems == null) {
            return null;
        }
        if (newItems.size() == 0 || newItems.get(0) instanceof MemberPropertyItem) {
            return newItems;
        }
        return this.parseItems(newItems);
    }

    private List parseItems(List items) {
        ArrayList<MemberPropertyItem> itemsInfo = new ArrayList<MemberPropertyItem>();
        if (items == null) {
            return itemsInfo;
        }
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            itemsInfo.add(this.parseItem((String)items.get(i)));
        }
        return itemsInfo;
    }

    private MemberPropertyItem parseItem(String item) {
        String[] tokens = Strings.split((String)item, (String)"<<", (String)">><<", (String)">>");
        MemberPropertyItem itemInfo = new MemberPropertyItem();
        itemInfo.setUniqueDimensionName(tokens[0]);
        itemInfo.setUniqueLevelName(tokens[1]);
        itemInfo.setPropertyName(tokens[2]);
        return itemInfo;
    }
}

