/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.format;

import com.sas.dataselectors.format.RB;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.iquery.metadata.serverprop.formats.SASFormatCategory;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescription;
import com.sas.iquery.metadata.serverprop.formats.SASFormatException;
import com.sas.models.formats.FormatDescription;
import com.sas.swing.visuals.dataselectors.format.FormatAdapterInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BusinessModelFormatAdapter
implements FormatAdapterInterface {
    private BusinessModel businessModel;
    private ServerProperties serverProperties;
    private boolean serverPropertiesSet;

    public BusinessModelFormatAdapter(BusinessModel businessModel) {
        this.businessModel = businessModel;
    }

    public Map getFormatTypes(int dataType, Locale locale) {
        boolean numeric = false;
        boolean dateTime = false;
        boolean currency = false;
        boolean character = false;
        if (dataType == 8 || dataType == 2 || dataType == -5 || dataType == 3 || dataType == 6 || dataType == 4 || dataType == -6 || dataType == 5 || dataType == 91 || dataType == 92 || dataType == 93 || dataType == 1111) {
            numeric = true;
            dateTime = true;
            currency = true;
        }
        if (dataType == 1 || dataType == 1111 || dataType == 12) {
            character = true;
        }
        LinkedHashMap<SASFormatCategory, String> map = new LinkedHashMap<SASFormatCategory, String>();
        if (numeric || dateTime || currency || character) {
            this.setServerProperties();
            try {
                List formats;
                if (numeric && (formats = this.serverProperties.getSASFormatDescriptions(SASFormatCategory.NUMERIC_CATEGORY, locale)).size() > 0) {
                    map.put(SASFormatCategory.NUMERIC_CATEGORY, RB.getStringResource("BusinessQueryFormatAdapter.Numeric.txt", locale));
                }
                if (dateTime && (formats = this.serverProperties.getSASFormatDescriptions(SASFormatCategory.DATE_TIME_CATEGORY, locale)).size() > 0) {
                    map.put(SASFormatCategory.DATE_TIME_CATEGORY, RB.getStringResource("BusinessQueryFormatAdapter.DateTime.txt", locale));
                }
                if (currency && (formats = this.serverProperties.getSASFormatDescriptions(SASFormatCategory.CURRENCY_CONVERSION_CATEGORY, locale)).size() > 0) {
                    map.put(SASFormatCategory.CURRENCY_CONVERSION_CATEGORY, RB.getStringResource("BusinessQueryFormatAdapter.CurrencyConversion.txt", locale));
                }
                if (character && (formats = this.serverProperties.getSASFormatDescriptions(SASFormatCategory.CHARACTER_CATEGORY, locale)).size() > 0) {
                    map.put(SASFormatCategory.CHARACTER_CATEGORY, RB.getStringResource("BusinessQueryFormatAdapter.Character.txt", locale));
                }
            }
            catch (SASFormatException e) {
                IllegalStateException ise = new IllegalStateException(e.getLocalizedMessage());
                ise.initCause(e);
                throw ise;
            }
        }
        return map;
    }

    public List getFormatByType(Object formatCategory, Locale locale) {
        this.setServerProperties();
        ArrayList<FormatDescription> list = new ArrayList<FormatDescription>();
        try {
            List formats = null;
            formats = formatCategory != null ? this.serverProperties.getSASFormatDescriptions((SASFormatCategory)formatCategory, locale) : this.serverProperties.getSASFormatDescriptions(locale);
            Iterator it = formats.iterator();
            while (it.hasNext()) {
                FormatDescription fd = new FormatDescription();
                SASFormatDescription sfd = (SASFormatDescription)it.next();
                fd.setBaseFormatName(sfd.getBaseFormatName());
                fd.setExample(sfd.getExample());
                fd.setDescription(sfd.getDescription());
                fd.setMinWidth(sfd.getMinWidth());
                fd.setMaxWidth(sfd.getMaxWidth());
                fd.setDefaultWidth(sfd.getDefaultWidth());
                fd.setMinDecimalWidth(sfd.getMinDecimalWidth());
                fd.setMaxDecimalWidth(sfd.getMaxDecimalWidth());
                fd.setDefaultDecimalWidth(sfd.getDefaultDecimalWidth());
                fd.setDecimalWidthSupported(sfd.isDecimalWidthSupported());
                list.add(fd);
            }
        }
        catch (SASFormatException e) {
            IllegalStateException ise = new IllegalStateException(e.getLocalizedMessage());
            ise.initCause(e);
            throw ise;
        }
        return list;
    }

    private void setServerProperties() {
        if (this.serverProperties == null) {
            try {
                this.serverProperties = this.businessModel.getServerProperties();
            }
            catch (MetadataException e) {
                IllegalStateException ise = new IllegalStateException(e.getLocalizedMessage());
                ise.initCause(e);
                throw ise;
            }
            if (this.serverProperties == null) {
                throw new IllegalStateException("businessModel.getServerProperties() returned null");
            }
        }
    }
}

