/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters.tree;

import com.sas.dataselectors.filters.ConditionalRelationType;
import com.sas.dataselectors.filters.FilterLogicBaseNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTreeInterface;
import com.sas.dataselectors.filters.FilterObjectFactoryInterface;
import com.sas.dataselectors.filters.tree.FilterReferenceNode;
import com.sas.dataselectors.filters.tree.LogicalConditionNodeInterface;
import com.sas.dataselectors.filters.tree.NotNodeInterface;
import com.sas.iquery.metadata.business.step.CompoundStep;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberFilter;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;

public class LogicTreeToStepModelTransform
implements TransformInterface {
    private static final boolean DEBUG = false;
    FilterObjectFactoryInterface factory;

    public LogicTreeToStepModelTransform() {
        this(null);
    }

    public LogicTreeToStepModelTransform(FilterObjectFactoryInterface factory) {
        this.factory = factory;
    }

    public FilterObjectFactoryInterface getFactory() {
        return this.factory;
    }

    public void setFactory(FilterObjectFactoryInterface factory) {
        this.factory = factory;
    }

    public Object transform(Object source) throws TransformException {
        Object result = null;
        if (source != null) {
            FilterLogicBaseNodeInterface root;
            if (source instanceof FilterLogicTreeInterface) {
                FilterLogicTreeInterface tree = (FilterLogicTreeInterface)source;
                root = (FilterLogicBaseNodeInterface)tree.getRoot();
            } else if (source instanceof FilterLogicBaseNodeInterface) {
                root = (FilterLogicBaseNodeInterface)source;
            } else {
                throw new IllegalArgumentException("Invalid class type! You must specify a FilterLogicTreeInterface.");
            }
            if (result == null) {
                result = this.processNode(root);
            }
        }
        return result;
    }

    protected Object processNode(FilterLogicBaseNodeInterface root) throws TransformException {
        Object result = null;
        if (root instanceof FilterReferenceNode) {
            result = root.getUserObject();
        } else if (root instanceof FilterLogicTestNodeInterface) {
            result = this.processTestNode((FilterLogicTestNodeInterface)root);
        } else if (root instanceof LogicalConditionNodeInterface) {
            result = this.processLogicalConditionNode((LogicalConditionNodeInterface)root);
        } else if (root instanceof NotNodeInterface) {
            result = this.processNotNode((NotNodeInterface)root);
        } else if (root != null) {
            throw new TransformException("Illegal FilterLogicTreeInterface tree structure!");
        }
        return result;
    }

    protected Object processNotNode(NotNodeInterface root) throws TransformException {
        Object result = null;
        Object child = this.processNode(root.getChildLogicNodeAt(0));
        if (child instanceof CompoundStep) {
            ((CompoundStep)child).setNegated(true);
            result = child;
        } else if (child instanceof StepInterface) {
            if (child instanceof DataItemMemberFilter) {
                DataItemMemberFilter step = (DataItemMemberFilter)child;
                step.setIsNegated(true);
                result = step;
            } else {
                CompoundStep step = this.newCompoundStep();
                step.setNegated(true);
                step.addStep((StepInterface)child);
                result = step;
            }
        }
        return result;
    }

    protected Object processLogicalConditionNode(LogicalConditionNodeInterface root) throws TransformException {
        CompoundStep result = null;
        int count = root.getChildCount();
        if (count > 0) {
            CompoundStep step = this.createCompoundStep(root);
            for (int i = 0; i < count; ++i) {
                FilterLogicBaseNodeInterface childNode = root.getChildLogicNodeAt(i);
                Object child = this.processNode(childNode);
                if (!(child instanceof StepInterface)) continue;
                step.addStep((StepInterface)child);
                result = step;
            }
        }
        return result;
    }

    protected Object processTestNode(FilterLogicTestNodeInterface testNode) throws TransformException {
        StepInterface step;
        StepInterface result = null;
        if (testNode != null && this.factory.updateSimpleFilterFromTestNode(step = this.newStep(testNode), testNode)) {
            result = step;
        }
        return result;
    }

    protected CompoundStep createCompoundStep(LogicalConditionNodeInterface node) {
        CompoundStep filter = this.newCompoundStep(node.getLogicalCondition());
        return filter;
    }

    protected CompoundStep newCompoundStep() {
        return this.newCompoundStep(null);
    }

    protected CompoundStep newCompoundStep(ConditionalRelationType relationship) {
        CompoundStep filter = this.factory.newCompoundStep();
        if (relationship != null) {
            filter.setConditionType(relationship.toString());
        }
        return filter;
    }

    protected StepInterface newStep(FilterLogicTestNodeInterface testNode) {
        StepInterface step = this.factory.newFilterStep(testNode);
        return step;
    }
}

