/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters.tree;

import com.sas.dataselectors.filters.BaseAdvancedFilterObjectFactory;
import com.sas.dataselectors.filters.ConditionalRelationType;
import com.sas.dataselectors.filters.FilterLogicBaseNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTreeInterface;
import com.sas.dataselectors.filters.FilterObjectFactoryInterface;
import com.sas.dataselectors.filters.tree.FilterReferenceNode;
import com.sas.dataselectors.filters.tree.LogicalConditionNodeInterface;
import com.sas.dataselectors.filters.tree.NotNodeInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.CompoundFilter;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.MultipleConditionalExpression;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.util.ArrayList;
import java.util.List;

public class LogicTreeToFilterItemTransform
implements TransformInterface {
    FilterObjectFactoryInterface factory;
    private CommonLoggerInterface log = LoggerRepository2.getLogger((String)this.getClass().getName(), null);

    public LogicTreeToFilterItemTransform() {
        this(null);
    }

    public LogicTreeToFilterItemTransform(FilterObjectFactoryInterface factory) {
        this.factory = factory;
    }

    public FilterObjectFactoryInterface getFactory() {
        return this.factory;
    }

    public void setFactory(FilterObjectFactoryInterface factory) {
        this.factory = factory;
    }

    public Object transform(Object source) throws TransformException {
        Object result = null;
        if (source != null) {
            FilterLogicBaseNodeInterface root;
            if (source instanceof FilterLogicTreeInterface) {
                FilterLogicTreeInterface tree = (FilterLogicTreeInterface)source;
                root = (FilterLogicBaseNodeInterface)tree.getRoot();
            } else if (source instanceof FilterLogicBaseNodeInterface) {
                root = (FilterLogicBaseNodeInterface)source;
            } else {
                throw new IllegalArgumentException("Invalid class type! You must specify a FilterLogicTreeInterface.");
            }
            this.log.debug("Beginning transform of FilterLogicTree: " + source, " (id=" + source.hashCode() + ")");
            if (result == null) {
                result = this.processNode(root);
            }
            if (result instanceof ExpressionInterface) {
                result = this.createFilterItem(root, (ExpressionInterface)result);
            }
            if (result instanceof FilterItem) {
                FilterItem newItem = (FilterItem)result;
                newItem.setIsHidden(false);
            }
            this.log.debug("Transform complete.");
        }
        return result;
    }

    protected Object processNode(FilterLogicBaseNodeInterface root) throws TransformException {
        this.log.debug("_DEBUG_: Processing root logic node: " + root);
        Object result = null;
        if (root instanceof FilterReferenceNode) {
            result = root.getUserObject();
        } else if (root instanceof FilterLogicTestNodeInterface) {
            result = this.processTestNode((FilterLogicTestNodeInterface)root);
        } else if (root instanceof LogicalConditionNodeInterface) {
            result = this.processLogicalConditionNode((LogicalConditionNodeInterface)root);
        } else if (root instanceof NotNodeInterface) {
            result = this.processNotNode((NotNodeInterface)root);
        } else if (root != null) {
            throw new TransformException("Illegal FilterLogicTreeInterface tree structure!");
        }
        return result;
    }

    protected Object processNotNode(NotNodeInterface root) throws TransformException {
        Object result = null;
        Object child = this.processNode(root.getChildLogicNodeAt(0));
        if (child instanceof CompoundFilter) {
            ((CompoundFilter)child).setIsNegated(true);
            result = child;
        } else if (child instanceof FilterItem) {
            CompoundFilter notFilter = this.newCompoundFilter();
            notFilter.setIsNegated(true);
            notFilter.setRelationType(null);
            notFilter.setLeftFilter((FilterItem)child);
            notFilter.setRightFilter(null);
            result = notFilter;
        } else if (child instanceof ExpressionInterface) {
            this.log.debug("Creating CompoundConditionalExpression!");
            CompoundConditionalExpression expr = new CompoundConditionalExpression();
            expr.setRelationType(null);
            expr.setLeftExpression((ExpressionInterface)child);
            expr.setRightExpression(null);
            expr.setIsNegated(true);
            result = expr;
        }
        return result;
    }

    private void addExpressions(MultipleConditionalExpression mce, List expressions) {
        for (ExpressionInterface expr : expressions) {
            if (expr instanceof MultipleConditionalExpression && ((MultipleConditionalExpression)expr).getRelationType() == mce.getRelationType()) {
                this.addExpressions(mce, ((MultipleConditionalExpression)expr).getExpressionList());
                continue;
            }
            mce.addExpression(expr);
        }
    }

    protected Object processLogicalConditionNode(LogicalConditionNodeInterface root) throws TransformException {
        Object result = null;
        int count = root.getChildCount();
        if (count > 0) {
            Object child;
            ArrayList<Object> childFilters = new ArrayList<Object>(count);
            boolean includesNonExpression = false;
            for (int i = 0; i < count; ++i) {
                FilterLogicBaseNodeInterface childNode = root.getChildLogicNodeAt(i);
                child = this.processNode(childNode);
                if (!(child instanceof ExpressionInterface)) {
                    includesNonExpression = true;
                }
                childFilters.add(child);
            }
            if (!includesNonExpression) {
                MultipleConditionalExpression mce = this.newMultipleConditionalExpression(root.getLogicalCondition());
                this.addExpressions(mce, childFilters);
                result = mce;
            } else {
                Object curr = childFilters.get(0);
                for (int i = 1; i < count; ++i) {
                    CompoundFilter parent;
                    Object prev = curr;
                    child = childFilters.get(i);
                    if (prev instanceof ExpressionInterface && child instanceof ExpressionInterface) {
                        this.log.debug("_DEBUG_: Creating CompoundConditionalExpression!");
                        parent = new CompoundConditionalExpression();
                        parent.setRelationType(this.convertLogicalCondition(root.getLogicalCondition()));
                        parent.setLeftExpression((ExpressionInterface)prev);
                        parent.setRightExpression((ExpressionInterface)child);
                        curr = parent;
                        continue;
                    }
                    if (prev instanceof ExpressionInterface) {
                        prev = this.createFilterItem(root.getChildLogicNodeAt(i), (ExpressionInterface)prev);
                    }
                    if (child instanceof ExpressionInterface) {
                        child = this.createFilterItem(root.getChildLogicNodeAt(i), (ExpressionInterface)child);
                    }
                    parent = this.createCompoundFilter(root);
                    parent.setLeftFilter((FilterItem)prev);
                    parent.setRightFilter((FilterItem)child);
                    curr = parent;
                }
                result = curr;
            }
        }
        return result;
    }

    protected FilterItem createFilterItem(FilterLogicBaseNodeInterface node, ExpressionInterface expr) throws TransformException {
        FilterItem filter = this.newFilterItem();
        try {
            this.updateFilterItem(filter, node.getFilterLabel(), node.getFilterDescription(), expr);
        }
        catch (MetadataException e) {
            TransformException t = new TransformException();
            t.initCause((Throwable)e);
            throw t;
        }
        return filter;
    }

    protected CompoundFilter createCompoundFilter(LogicalConditionNodeInterface node) {
        CompoundFilter filter = this.newCompoundFilter(node.getLogicalCondition());
        return filter;
    }

    protected Object processTestNode(FilterLogicTestNodeInterface testNode) {
        ExpressionInterface result = null;
        if (testNode != null) {
            result = this.newFilterExpression(testNode);
        }
        return result;
    }

    protected com.sas.iquery.metadata.expr.ConditionalRelationType convertLogicalCondition(ConditionalRelationType type) {
        com.sas.iquery.metadata.expr.ConditionalRelationType nativeType = null;
        if (type == ConditionalRelationType.AND) {
            nativeType = com.sas.iquery.metadata.expr.ConditionalRelationType.AND;
        } else if (type == ConditionalRelationType.OR) {
            nativeType = com.sas.iquery.metadata.expr.ConditionalRelationType.OR;
        }
        return nativeType;
    }

    protected boolean updateFilterItem(FilterItem filterItem, FilterLogicTestNodeInterface testNode) {
        if (filterItem != null) {
            String name = testNode.getFilterLabel();
            String description = testNode.getFilterDescription();
            ExpressionInterface result = this.newFilterExpression(testNode);
            if (result != null) {
                try {
                    this.updateFilterItem(filterItem, name, description, result);
                    return true;
                }
                catch (MetadataException metadataException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    protected void updateFilterItem(FilterItem filterItem, String name, String description, ExpressionInterface expr) throws MetadataException {
        filterItem.setLabel(name);
        filterItem.setDescription(description);
        filterItem.setExpression(expr);
    }

    protected FilterItem newFilterItem() {
        FilterItem filter = this.factory.newFilterItem();
        filter.setIsHidden(true);
        return filter;
    }

    protected CompoundFilter newCompoundFilter() {
        return this.newCompoundFilter(null);
    }

    protected CompoundFilter newCompoundFilter(ConditionalRelationType relationship) {
        CompoundFilter filter = this.factory.newCompoundFilter();
        filter.setIsHidden(true);
        filter.setRelationType(this.convertLogicalCondition(relationship));
        return filter;
    }

    protected MultipleConditionalExpression newMultipleConditionalExpression() {
        MultipleConditionalExpression mce = new MultipleConditionalExpression();
        return mce;
    }

    protected MultipleConditionalExpression newMultipleConditionalExpression(ConditionalRelationType relationship) {
        MultipleConditionalExpression mce = this.newMultipleConditionalExpression();
        mce.setRelationType(this.convertLogicalCondition(relationship));
        return mce;
    }

    protected ExpressionInterface newFilterExpression(FilterLogicTestNodeInterface testNode) {
        ExpressionInterface expression = null;
        if (testNode != null) {
            expression = ((BaseAdvancedFilterObjectFactory)this.factory).newFilterExpression(testNode);
        }
        return expression;
    }
}

