/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters.tree;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.CompoundFilter;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.impl.Utils;
import java.util.HashMap;
import java.util.Map;

public class IQUtil {
    private IQUtil() {
    }

    public static void printTree(FilterItem root) {
        IQUtil.printTree(root, "", "ROOT-", new HashMap());
    }

    private static void printTree(FilterItem root, String spacer, String prefix, Map visited) {
        CompoundFilter filter;
        System.out.println("_DEBUG_:" + spacer + prefix + IQUtil.toDebugNodeString(root));
        if (root instanceof CompoundFilter && ((filter = (CompoundFilter)root).getLeftFilter() != null || filter.getRightFilter() != null)) {
            if (visited.get(root) != null) {
                System.out.println("_DEBUG_:" + spacer + "  RECURSIVE NODE LINK <stopping here>");
            } else {
                visited.put(root, Boolean.TRUE);
                IQUtil.printTree(filter.getLeftFilter(), spacer + "  ", "L-", visited);
                IQUtil.printTree(filter.getRightFilter(), spacer + "  ", "R-", visited);
            }
        }
    }

    private static String toDebugNodeString(FilterItem node) {
        if (node == null) {
            return "NODE: <EMPTY>  [" + Utils.toString((Object)node) + "]";
        }
        if (node instanceof CompoundFilter) {
            CompoundFilter cf = (CompoundFilter)node;
            String NOT = "";
            String CONDITION = "GROUP ";
            if (cf.isNegated()) {
                NOT = "NOT ";
            }
            if (cf.getRelationType() != null) {
                CONDITION = cf.getRelationType() + " ";
            }
            return "NODE: " + NOT + CONDITION + "  [" + Utils.toString((Object)node) + "] (id=" + node.hashCode() + ")";
        }
        ExpressionInterface expr = node.getExpression();
        if (expr != null) {
            return "LEAF: " + Utils.toString((Object)expr) + " (id=" + node.hashCode() + ")";
        }
        return "LEAF: <EMPTY>  [" + Utils.toString((Object)node) + "]  (id=" + node.hashCode() + ")";
    }

    public static int addFilterItemsToBusinessModel(BusinessModel model, FilterItem root) throws MetadataException {
        return IQUtil.addFilterItemsToBusinessModel(model, root, true);
    }

    public static int addFilterItemsToBusinessModel(BusinessModel model, FilterItem root, boolean includeBaseModels) throws MetadataException {
        int count = 0;
        if (model != null && root != null) {
            if (root instanceof CompoundFilter) {
                CompoundFilter cf = (CompoundFilter)root;
                count += IQUtil.addFilterItemsToBusinessModel(model, cf.getLeftFilter());
                count += IQUtil.addFilterItemsToBusinessModel(model, cf.getRightFilter());
            }
            if (!model.contains(includeBaseModels, (BusinessModelObject)root)) {
                model.addBusinessItem((BusinessItem)root);
                ++count;
            }
        }
        return count;
    }
}

