/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters.tree;

import com.sas.dataselectors.filters.AbstractFilterLogicBaseNode;
import com.sas.dataselectors.filters.ConditionalRelationType;
import com.sas.dataselectors.filters.DefaultFilterLogicTestNode;
import com.sas.dataselectors.filters.DefaultFilterLogicTree;
import com.sas.dataselectors.filters.FilterConditionInterface;
import com.sas.dataselectors.filters.FilterItemInterface;
import com.sas.dataselectors.filters.FilterItemListInterface;
import com.sas.dataselectors.filters.FilterLogicBaseNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterObjectFactoryInterface;
import com.sas.dataselectors.filters.tree.FilterReferenceNode;
import com.sas.dataselectors.filters.tree.LogicalConditionNode;
import com.sas.dataselectors.filters.tree.NotNode;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.CompoundFilter;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.MultipleConditionalExpression;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_In;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_TestForNull;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.swing.dataselectors.editors.FilterItemEditorInterface;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.tree.MutableTreeNode;

public class FilterItemToLogicTreeTransform
implements TransformInterface {
    FilterObjectFactoryInterface factory;
    FilterItemListInterface filterItemList;
    private CommonLoggerInterface log = LoggerRepository2.getLogger((String)this.getClass().getName(), null);

    public FilterItemToLogicTreeTransform() {
        this(null, null);
    }

    public FilterItemToLogicTreeTransform(FilterObjectFactoryInterface factory) {
        this(factory, null);
    }

    public FilterItemToLogicTreeTransform(FilterObjectFactoryInterface factory, FilterItemListInterface filterItemList) {
        this.factory = factory;
        this.filterItemList = filterItemList;
    }

    public FilterObjectFactoryInterface getFactory() {
        return this.factory;
    }

    public void setFactory(FilterObjectFactoryInterface factory) {
        this.factory = factory;
    }

    public Object transform(Object o) throws TransformException {
        DefaultFilterLogicTree tree = null;
        if (o != null) {
            if (!(o instanceof FilterItem)) {
                throw new IllegalArgumentException("Invalid class type! You must specify a FilterItem.");
            }
            FilterItem item = (FilterItem)o;
            this.log.debug("_DEBUG_: Beginning transform of FilterItem " + item.getLabel());
            AbstractFilterLogicBaseNode root = item instanceof CompoundFilter ? this.transformFilter((CompoundFilter)item) : this.transformFilter(item);
            this.log.debug("Transform complete, constructing tree...");
            boolean modifiable = !item.isReadOnly();
            tree = item instanceof CompoundFilter ? new DefaultFilterLogicTree((FilterLogicBaseNodeInterface)root, modifiable, true, true) : new DefaultFilterLogicTree((FilterLogicBaseNodeInterface)root, modifiable);
        }
        return tree;
    }

    private AbstractFilterLogicBaseNode transformFilter(FilterItem fi) throws TransformException {
        ExpressionInterface expr = fi.getExpression();
        this.log.debug("Transforming FilterItem:", Utils.toString((Object)expr));
        AbstractFilterLogicBaseNode newNode = null;
        if (expr instanceof MultipleConditionalExpression) {
            MultipleConditionalExpression mcExpr = (MultipleConditionalExpression)expr;
            newNode = this.transformMultipleConditionalExpression(mcExpr);
        } else if (expr instanceof CompoundConditionalExpression) {
            newNode = this.transformCompoundConditionalExpression((CompoundConditionalExpression)expr);
        } else {
            FilterLogicTestNodeInterface testNode = this.factory.newTestNode(fi, this.filterItemList);
            newNode = this.newFilterLogicBaseNode(fi.getExpression(), testNode, false);
        }
        return newNode;
    }

    private AbstractFilterLogicBaseNode transformExpression(ExpressionInterface expr) throws TransformException {
        AbstractFilterLogicBaseNode node;
        if (expr instanceof MultipleConditionalExpression) {
            node = this.transformMultipleConditionalExpression((MultipleConditionalExpression)expr);
        } else if (expr instanceof CompoundConditionalExpression) {
            node = this.transformCompoundConditionalExpression((CompoundConditionalExpression)expr);
        } else if (expr instanceof ConditionalExpression) {
            node = this.transformSingularConditionalExpression((ConditionalExpression)expr);
        } else if (expr instanceof FunctionCall) {
            node = this.transformFunctionCall((FunctionCall)expr);
        } else if (expr instanceof ResourceAwareStringExpression) {
            FilterLogicTestNodeInterface testNode = this.factory.newTestNode(null, null, expr, FilterItemEditorInterface.class, false, null, this.filterItemList);
            node = this.newFilterLogicBaseNode(expr, testNode, true);
        } else {
            if (expr == null) {
                throw new TransformException("Expression is null!!");
            }
            throw new TransformException("Unhandled expression type \"" + expr.getClass().getSimpleName() + "\"!!");
        }
        return node;
    }

    private AbstractFilterLogicBaseNode transformFunctionCall(FunctionCall call) throws TransformException {
        AbstractFilterLogicBaseNode result = null;
        if (call != null) {
            FilterLogicTestNodeInterface testNode = this.factory.newTestNode(null, null, call, this.filterItemList);
            result = this.newFilterLogicBaseNode((ExpressionInterface)call, testNode, true);
        }
        return result;
    }

    private AbstractFilterLogicBaseNode transformSingularConditionalExpression(ConditionalExpression expr) throws TransformException {
        AbstractFilterLogicBaseNode result = null;
        if (expr != null) {
            if (expr instanceof SimpleConditionalExpression_Comparison) {
                FilterLogicTestNodeInterface testNode = this.factory.newTestNode(null, null, (SimpleConditionalExpression_Comparison)expr, this.filterItemList);
                result = this.newFilterLogicBaseNode((ExpressionInterface)expr, testNode, true);
            } else if (expr instanceof SimpleConditionalExpression_In) {
                FilterLogicTestNodeInterface testNode = this.factory.newTestNode(null, null, (SimpleConditionalExpression_In)expr, this.filterItemList);
                result = this.newFilterLogicBaseNode((ExpressionInterface)expr, testNode, true);
            } else if (expr instanceof SimpleConditionalExpression_TestForNull) {
                FilterLogicTestNodeInterface testNode = this.factory.newTestNode(null, null, (SimpleConditionalExpression_TestForNull)expr, this.filterItemList);
                result = this.newFilterLogicBaseNode((ExpressionInterface)expr, testNode, true);
            } else {
                result = this.newFilterLogicBaseNode((ExpressionInterface)expr, null, true);
            }
        }
        return result;
    }

    private AbstractFilterLogicBaseNode transformMultipleConditionalExpression(MultipleConditionalExpression expr) throws TransformException {
        LogicalConditionNode result = null;
        if (expr != null) {
            com.sas.iquery.metadata.expr.ConditionalRelationType relationship = expr.getRelationType();
            LogicalConditionNode node = this.newLogicalConditionNode((Object)expr, relationship, false);
            ExpressionInterface[] expressions = expr.getExpressions();
            for (int i = 0; i < expressions.length; ++i) {
                AbstractFilterLogicBaseNode child = this.transformExpression(expressions[i]);
                node.add((MutableTreeNode)child);
            }
            if (expr.isNegated()) {
                result = this.newNotNode(expr);
                result.add((MutableTreeNode)node);
            } else {
                result = node;
            }
        }
        return result;
    }

    private AbstractFilterLogicBaseNode transformCompoundConditionalExpression(CompoundConditionalExpression expr) throws TransformException {
        LogicalConditionNode result = null;
        if (expr != null) {
            CompoundConditionalExpression ccExpr = expr;
            com.sas.iquery.metadata.expr.ConditionalRelationType relationship = ccExpr.getRelationType();
            ExpressionInterface[] expressions = new ExpressionInterface[]{ccExpr.getLeftExpression(), ccExpr.getRightExpression()};
            if (relationship == null) {
                AbstractFilterLogicBaseNode child;
                if (expressions[1] != null && expressions[0] == null) {
                    expressions[0] = expressions[1];
                }
                if ((child = this.transformExpression(expressions[0])) instanceof LogicalConditionNode) {
                    ((LogicalConditionNode)child).setExplicitlyCreated(true);
                }
                if (ccExpr.isNegated()) {
                    result = this.newNotNode(ccExpr);
                    result.add((MutableTreeNode)child);
                } else {
                    result = child;
                }
            } else {
                LogicalConditionNode node = this.newLogicalConditionNode((Object)ccExpr, relationship, false);
                for (int i = 0; i < expressions.length; ++i) {
                    AbstractFilterLogicBaseNode child = this.transformExpression(expressions[i]);
                    if (child == null) continue;
                    node.add((MutableTreeNode)child);
                }
                if (ccExpr.isNegated()) {
                    result = this.newNotNode(ccExpr);
                    result.add((MutableTreeNode)node);
                } else {
                    result = node;
                }
            }
        }
        return result;
    }

    private AbstractFilterLogicBaseNode transformFilter(CompoundFilter cf) throws TransformException {
        return this.transform(cf, false);
    }

    private AbstractFilterLogicBaseNode transform(CompoundFilter cf, boolean explicit) throws TransformException {
        com.sas.iquery.metadata.expr.ConditionalRelationType relationship = cf.getRelationType();
        this.log.debug("Transforming CompoundFilter[" + relationship + "]:", Utils.toString((Object)cf));
        AbstractFilterLogicBaseNode root = null;
        int count = this.getChildCount(cf);
        if (count == 1) {
            if (relationship != null) {
                throw new TransformException("Invalid filter model structure!");
            }
            root = this.processSingleChild(cf);
        } else if (count == 2) {
            CompoundFilter temp;
            if (relationship == null) {
                throw new TransformException("Invalid filter model structure!");
            }
            if (cf.isNegated()) {
                root = this.newNotNode(cf);
            }
            ArrayList<FilterItem> childrenToProcess = new ArrayList<FilterItem>();
            Stack<Object> groupParents = new Stack<Object>();
            groupParents.push(cf);
            FilterItem currCF = cf.getLeftFilter();
            while (currCF instanceof CompoundFilter && !(temp = (CompoundFilter)currCF).isNegated() && temp.getRelationType() == relationship && this.getChildCount(temp) >= 2 && temp.isHidden()) {
                groupParents.push(currCF);
                currCF = temp.getLeftFilter();
            }
            if (currCF != null) {
                childrenToProcess.add(currCF);
            }
            while (!groupParents.isEmpty()) {
                CompoundFilter parent = (CompoundFilter)groupParents.pop();
                if (parent.getRightFilter() == null) continue;
                childrenToProcess.add(parent.getRightFilter());
            }
            LogicalConditionNode node = this.newLogicalConditionNode((Object)cf, relationship, explicit);
            int childCount = childrenToProcess.size();
            for (int i = 0; i < childCount; ++i) {
                FilterItem item = (FilterItem)childrenToProcess.get(i);
                AbstractFilterLogicBaseNode child = item instanceof CompoundFilter ? this.transform((CompoundFilter)item, true) : this.transformFilter(item);
                if (child == null) continue;
                node.add((MutableTreeNode)child);
            }
            if (null == root) {
                root = node;
            } else if (node != null) {
                root.add((MutableTreeNode)node);
            }
        }
        return root;
    }

    private AbstractFilterLogicBaseNode processSingleChild(CompoundFilter cf) throws TransformException {
        NotNode root = null;
        if (cf.isNegated()) {
            root = this.newNotNode(cf);
        }
        FilterItem child = this.children(cf)[0];
        AbstractFilterLogicBaseNode childNode = null;
        childNode = child instanceof CompoundFilter ? this.transform((CompoundFilter)child, true) : this.transformFilter(child);
        if (null == root) {
            root = childNode;
        } else if (childNode != null) {
            root.add((MutableTreeNode)childNode);
        }
        return root;
    }

    private boolean hasOnlyOneChild(CompoundFilter filter) {
        return 1 == this.getChildCount(filter);
    }

    private int getChildCount(CompoundFilter filter) {
        int count = 0;
        if (filter.getLeftFilter() != null) {
            ++count;
        }
        if (filter.getRightFilter() != null) {
            ++count;
        }
        return count;
    }

    private FilterItem[] children(CompoundFilter filter) {
        ArrayList<FilterItem> list = new ArrayList<FilterItem>(2);
        if (filter.getLeftFilter() != null) {
            list.add(filter.getLeftFilter());
        }
        if (filter.getRightFilter() != null) {
            list.add(filter.getRightFilter());
        }
        return list.toArray(new FilterItem[0]);
    }

    private boolean hasOnlyOneChild(CompoundConditionalExpression ccExpr) {
        return 1 == this.getChildCount(ccExpr);
    }

    private int getChildCount(CompoundConditionalExpression ccExpr) {
        int count = 0;
        if (ccExpr.getLeftExpression() != null) {
            ++count;
        }
        if (ccExpr.getRightExpression() != null) {
            ++count;
        }
        return count;
    }

    protected LogicalConditionNode newLogicalConditionNode(Object userObject, com.sas.iquery.metadata.expr.ConditionalRelationType relationship, boolean explicit) {
        LogicalConditionNode node = com.sas.iquery.metadata.expr.ConditionalRelationType.AND == relationship ? this.newLogicalConditionNode(userObject, ConditionalRelationType.AND, explicit) : this.newLogicalConditionNode(userObject, ConditionalRelationType.OR, explicit);
        return node;
    }

    protected LogicalConditionNode newLogicalConditionNode(Object userObject, ConditionalRelationType lc, boolean explicitlyCreated) {
        LogicalConditionNode node = new LogicalConditionNode(lc, explicitlyCreated, userObject);
        return node;
    }

    protected NotNode newNotNode(Object userObject) {
        NotNode node = new NotNode(userObject);
        return node;
    }

    protected FilterReferenceNode newFilterReferenceNode(Object userObject) {
        FilterReferenceNode node = new FilterReferenceNode(userObject);
        return node;
    }

    protected FilterLogicTestNodeInterface newTestNode(Object userObject, FilterItemInterface item, List qualifiers, FilterConditionInterface condition, List values) {
        DefaultFilterLogicTestNode node = new DefaultFilterLogicTestNode(userObject);
        node.setFilterItem(item);
        node.setFilterItemQualifiers(qualifiers);
        node.setCondition(condition);
        node.setTestValuesList(values);
        return node;
    }

    private AbstractFilterLogicBaseNode newFilterLogicBaseNode(ExpressionInterface expr, FilterLogicTestNodeInterface testNode, boolean createDefaultIfNull) throws TransformException {
        if (testNode == null && createDefaultIfNull) {
            FilterItem fi = this.factory.newFilterItem();
            try {
                fi.setExpression(expr);
                testNode = this.factory.newTestNode(fi, this.filterItemList);
            }
            catch (MetadataException e) {
                String text = this.textOf(expr);
                TransformException x = new TransformException("Error setting FilterItem expression: " + text);
                x.initCause((Throwable)e);
                throw x;
            }
        }
        if (testNode == null) {
            String text = this.textOf(expr);
            throw new TransformException("Error setting FilterItem expression: " + text);
        }
        DefaultFilterLogicTestNode result = null;
        result = new DefaultFilterLogicTestNode(testNode);
        return result;
    }

    private String textOf(ExpressionInterface expr) {
        String text;
        try {
            text = StringExpressionUtil.getInstance().getReadableText(expr);
        }
        catch (Throwable e1) {
            try {
                text = StringExpressionUtil.getInstance().getText(expr);
            }
            catch (Throwable e2) {
                text = String.valueOf(expr);
            }
        }
        return text;
    }
}

