/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters.timebased;

import com.sas.dataselectors.filters.BaseFilterObjectFactory;
import com.sas.dataselectors.filters.DateAndTimeUtil;
import com.sas.dataselectors.filters.DefaultFilterLogicTestNode;
import com.sas.dataselectors.filters.DefaultFilterValue;
import com.sas.dataselectors.filters.FilterConditionInterface;
import com.sas.dataselectors.filters.FilterItemInterface;
import com.sas.dataselectors.filters.FilterItemListInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterValueInterface;
import com.sas.dataselectors.filters.timebased.RelativeTimeFilterData;
import com.sas.dataselectors.filters.timebased.RelativeTimeFilterValueFormatter;
import com.sas.dataselectors.filters.timebased.TimeCondition;
import com.sas.dataselectors.filters.timebased.TimePeriod;
import com.sas.dataselectors.filters.timebased.TimePeriodType;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.expr.AbstractTimeValueExpression;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.DateValueExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.TimeValueExpression;
import com.sas.iquery.metadata.expr.TimestampValueExpression;
import com.sas.iquery.metadata.expr.relational.AbstractRelativeTimeValueExpression;
import com.sas.iquery.metadata.expr.relational.DataItemFormattingExpression;
import com.sas.iquery.metadata.expr.relational.RelativeDateValueExpression;
import com.sas.iquery.metadata.expr.relational.RelativeTimestampValueExpression;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Between;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.expr.relational.TimeShiftAlignment;
import com.sas.iquery.metadata.expr.relational.TimeShiftDirection;
import com.sas.iquery.metadata.expr.relational.TimeShiftUnit;
import com.sas.prompts.definitions.BaseDefinitionRangeInterface;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class IQRelativeTimeFilterUtil {
    private static final RelativeTimeFilterValueFormatter _relativeTimeFilterFormatter = new RelativeTimeFilterValueFormatter();
    private static StringExpressionUtil _stringExpressionUtil = StringExpressionUtil.getInstance();
    private static Locale locale = Locale.getDefault();
    private static Map periodTypeMap = new HashMap();
    private static Map shiftUnitMap = new HashMap();

    private static List generateExpressionsFromValues(List filterValues, long itemType) {
        ArrayList exprList;
        if (filterValues != null) {
            exprList = new ArrayList(filterValues.size());
            for (Object valObj : filterValues) {
                ExpressionInterface valueExpr;
                if (valObj instanceof FilterValueInterface) {
                    valObj = ((FilterValueInterface)valObj).getData();
                }
                if (valObj instanceof Date) {
                    valueExpr = IQRelativeTimeFilterUtil.generateExpressionFromValue((Date)valObj, (int)itemType);
                    valObj = valueExpr;
                }
                if (valObj instanceof RelativeTimeFilterData) {
                    valueExpr = IQRelativeTimeFilterUtil.generateExpressionFromValue((RelativeTimeFilterData)valObj, (int)itemType);
                    valObj = valueExpr;
                }
                if (!(valObj instanceof ExpressionInterface)) continue;
                exprList.add(valObj);
            }
        } else {
            exprList = null;
        }
        return exprList;
    }

    private static ExpressionInterface generateExpressionFromValue(Date date, int type) {
        DateValueExpression expr;
        if (date != null) {
            switch (type) {
                case 4: {
                    expr = new DateValueExpression(date);
                    break;
                }
                case 6: {
                    expr = new TimestampValueExpression(date);
                    break;
                }
                case 5: {
                    expr = new TimeValueExpression(date);
                    break;
                }
                default: {
                    expr = null;
                    break;
                }
            }
        } else {
            expr = null;
        }
        return expr;
    }

    public static ExpressionInterface generateExpressionFromValue(RelativeTimeFilterData data, int type) {
        Object expr = null;
        if (data != null) {
            TimePeriod period = data.getPeriod();
            TimeShiftAlignment alignment = TimeShiftAlignment.NONE;
            if (data.getDaySelectedInTimePeriod() == 1) {
                alignment = TimeShiftAlignment.BEGINNING_OF;
            } else if (data.getDaySelectedInTimePeriod() == 2) {
                alignment = TimeShiftAlignment.END_OF;
            }
            if (TimePeriod.PERIOD_TODAY == period) {
                expr = (long)type == 6L ? (alignment == TimeShiftAlignment.NONE ? RelativeTimestampValueExpression.DATETIME : new RelativeTimestampValueExpression((ExpressionInterface)RelativeTimestampValueExpression.DATETIME, TimeShiftUnit.DAY, TimeShiftDirection.CURRENT, 0, alignment)) : RelativeDateValueExpression.TODAY;
            } else if (TimePeriod.PERIOD_YESTERDAY == period) {
                expr = (long)type == 6L ? new RelativeTimestampValueExpression((ExpressionInterface)RelativeTimestampValueExpression.DATETIME, TimeShiftUnit.DAY, TimeShiftDirection.PREVIOUS, 1, alignment) : RelativeDateValueExpression.YESTERDAY;
            } else if (TimePeriod.PERIOD_TOMORROW == period) {
                expr = (long)type == 6L ? new RelativeTimestampValueExpression((ExpressionInterface)RelativeTimestampValueExpression.DATETIME, TimeShiftUnit.DAY, TimeShiftDirection.NEXT, 1, alignment) : RelativeDateValueExpression.TOMORROW;
            } else if (TimePeriod.PERIOD_CURRENT_DATETIME == period) {
                expr = RelativeTimestampValueExpression.DATETIME;
            } else if (TimePeriod.PERIOD_CURRENT_DATETIME_LAST_YEAR == period) {
                expr = new RelativeTimestampValueExpression((ExpressionInterface)RelativeTimestampValueExpression.DATETIME, TimeShiftUnit.YEAR, TimeShiftDirection.PREVIOUS, 1, TimeShiftAlignment.NONE);
            } else if (TimePeriod.PERIOD_CURRENT_MINUTE == period) {
                expr = IQRelativeTimeFilterUtil.getCurrentPeriodExpression(type, TimeShiftUnit.MINUTE, alignment);
            } else if (TimePeriod.PERIOD_CURRENT_HOUR == period) {
                expr = IQRelativeTimeFilterUtil.getCurrentPeriodExpression(type, TimeShiftUnit.HOUR, alignment);
            } else if (TimePeriod.PERIOD_CURRENT_WEEK == period) {
                expr = IQRelativeTimeFilterUtil.getCurrentPeriodExpression(type, TimeShiftUnit.WEEK, alignment);
            } else if (TimePeriod.PERIOD_CURRENT_MONTH == period) {
                expr = IQRelativeTimeFilterUtil.getCurrentPeriodExpression(type, TimeShiftUnit.MONTH, alignment);
            } else if (TimePeriod.PERIOD_CURRENT_QUARTER == period) {
                expr = IQRelativeTimeFilterUtil.getCurrentPeriodExpression(type, TimeShiftUnit.QUARTER, alignment);
            } else if (TimePeriod.PERIOD_CURRENT_YEAR == period) {
                expr = IQRelativeTimeFilterUtil.getCurrentPeriodExpression(type, TimeShiftUnit.YEAR, alignment);
            } else if (TimePeriod.PERIOD_CURRENT_DAY_LAST_YEAR == period) {
                expr = IQRelativeTimeFilterUtil.getCurrentPeriodLastYearExpression(type, TimeShiftUnit.DAY, alignment);
            } else if (TimePeriod.PERIOD_CURRENT_WEEK_LAST_YEAR == period) {
                expr = IQRelativeTimeFilterUtil.getCurrentPeriodLastYearExpression(type, TimeShiftUnit.WEEK, alignment);
            } else if (TimePeriod.PERIOD_CURRENT_MONTH_LAST_YEAR == period) {
                expr = IQRelativeTimeFilterUtil.getCurrentPeriodLastYearExpression(type, TimeShiftUnit.MONTH, alignment);
            } else if (TimePeriod.PERIOD_CURRENT_QUARTER_LAST_YEAR == period) {
                expr = IQRelativeTimeFilterUtil.getCurrentPeriodLastYearExpression(type, TimeShiftUnit.QUARTER, alignment);
            } else if (TimePeriod.PERIOD_LAST_HOUR == period) {
                expr = IQRelativeTimeFilterUtil.getLastPeriodExpression(type, TimeShiftUnit.HOUR, alignment);
            } else if (TimePeriod.PERIOD_LAST_MINUTE == period) {
                expr = IQRelativeTimeFilterUtil.getLastPeriodExpression(type, TimeShiftUnit.MINUTE, alignment);
            } else if (TimePeriod.PERIOD_NEXT_MINUTE == period) {
                expr = IQRelativeTimeFilterUtil.getNextPeriodExpression(type, TimeShiftUnit.MINUTE, alignment);
            } else if (TimePeriod.PERIOD_LAST_WEEK == period) {
                expr = IQRelativeTimeFilterUtil.getLastPeriodExpression(type, TimeShiftUnit.WEEK, alignment);
            } else if (TimePeriod.PERIOD_LAST_MONTH == period) {
                expr = IQRelativeTimeFilterUtil.getLastPeriodExpression(type, TimeShiftUnit.MONTH, alignment);
            } else if (TimePeriod.PERIOD_LAST_QUARTER == period) {
                expr = IQRelativeTimeFilterUtil.getLastPeriodExpression(type, TimeShiftUnit.QUARTER, alignment);
            } else if (TimePeriod.PERIOD_LAST_YEAR == period) {
                expr = IQRelativeTimeFilterUtil.getLastPeriodExpression(type, TimeShiftUnit.YEAR, alignment);
            } else if (TimePeriod.PERIOD_N_PERIODS_AGO == period) {
                TimeShiftUnit timeShiftUnit = IQRelativeTimeFilterUtil.getShiftUnit(data.getPeriodType());
                expr = (long)type == 6L ? new RelativeTimestampValueExpression((ExpressionInterface)RelativeTimestampValueExpression.DATETIME, timeShiftUnit, TimeShiftDirection.PREVIOUS, data.getMultiplier(), TimeShiftAlignment.NONE) : new RelativeDateValueExpression((ExpressionInterface)RelativeDateValueExpression.TODAY, timeShiftUnit, TimeShiftDirection.PREVIOUS, data.getMultiplier(), TimeShiftAlignment.NONE);
            } else if (TimePeriod.PERIOD_N_PERIODS_FROM_NOW == period) {
                TimeShiftUnit timeShiftUnit = IQRelativeTimeFilterUtil.getShiftUnit(data.getPeriodType());
                expr = (long)type == 6L ? new RelativeTimestampValueExpression((ExpressionInterface)RelativeTimestampValueExpression.DATETIME, timeShiftUnit, TimeShiftDirection.NEXT, data.getMultiplier(), TimeShiftAlignment.NONE) : new RelativeDateValueExpression((ExpressionInterface)RelativeDateValueExpression.TODAY, timeShiftUnit, TimeShiftDirection.NEXT, data.getMultiplier(), TimeShiftAlignment.NONE);
            }
        }
        return expr;
    }

    protected static ExpressionInterface getCurrentPeriodExpression(int type, TimeShiftUnit timeShiftUnit, TimeShiftAlignment alignment) {
        if ((long)type == 6L) {
            return new RelativeTimestampValueExpression((ExpressionInterface)RelativeTimestampValueExpression.DATETIME, timeShiftUnit, TimeShiftDirection.CURRENT, 0, alignment);
        }
        return new RelativeDateValueExpression((ExpressionInterface)RelativeDateValueExpression.TODAY, timeShiftUnit, TimeShiftDirection.CURRENT, 0, alignment);
    }

    protected static ExpressionInterface getCurrentPeriodLastYearExpression(int type, TimeShiftUnit timeShiftUnit, TimeShiftAlignment alignment) {
        if ((long)type == 6L) {
            RelativeTimestampValueExpression currentDateLastYear = new RelativeTimestampValueExpression((ExpressionInterface)RelativeTimestampValueExpression.DATETIME, TimeShiftUnit.YEAR, TimeShiftDirection.PREVIOUS, 1, TimeShiftAlignment.NONE);
            return new RelativeTimestampValueExpression((ExpressionInterface)currentDateLastYear, timeShiftUnit, TimeShiftDirection.CURRENT, 0, alignment);
        }
        RelativeDateValueExpression currentDayLastYear = new RelativeDateValueExpression((ExpressionInterface)RelativeDateValueExpression.TODAY, TimeShiftUnit.YEAR, TimeShiftDirection.PREVIOUS, 1, TimeShiftAlignment.NONE);
        if (timeShiftUnit == TimeShiftUnit.DAY) {
            return currentDayLastYear;
        }
        return new RelativeDateValueExpression((ExpressionInterface)currentDayLastYear, timeShiftUnit, TimeShiftDirection.CURRENT, 0, alignment);
    }

    protected static ExpressionInterface getLastPeriodExpression(int type, TimeShiftUnit timeShiftUnit, TimeShiftAlignment alignment) {
        if ((long)type == 6L) {
            return new RelativeTimestampValueExpression((ExpressionInterface)RelativeTimestampValueExpression.DATETIME, timeShiftUnit, TimeShiftDirection.PREVIOUS, 1, alignment);
        }
        return new RelativeDateValueExpression((ExpressionInterface)RelativeDateValueExpression.TODAY, timeShiftUnit, TimeShiftDirection.PREVIOUS, 1, alignment);
    }

    protected static ExpressionInterface getNextPeriodExpression(int type, TimeShiftUnit timeShiftUnit, TimeShiftAlignment alignment) {
        if ((long)type == 6L) {
            return new RelativeTimestampValueExpression((ExpressionInterface)RelativeTimestampValueExpression.DATETIME, timeShiftUnit, TimeShiftDirection.NEXT, 1, alignment);
        }
        return new RelativeDateValueExpression((ExpressionInterface)RelativeDateValueExpression.TODAY, timeShiftUnit, TimeShiftDirection.NEXT, 1, alignment);
    }

    public static FilterLogicTestNodeInterface newTestNode(ExpressionInterface expression, BaseFilterObjectFactory factory, FilterItemListInterface filterItemList) {
        return IQRelativeTimeFilterUtil.newTestNode(expression, factory, filterItemList, locale);
    }

    public static FilterLogicTestNodeInterface newTestNode(ExpressionInterface expression, BaseFilterObjectFactory factory, FilterItemListInterface filterItemList, Locale locale) {
        FilterLogicTestNodeInterface testNode = expression instanceof SimpleConditionalExpression_Comparison ? IQRelativeTimeFilterUtil.newTestNodeFromComparison((SimpleConditionalExpression_Comparison)expression, factory, filterItemList, locale) : (expression instanceof SimpleConditionalExpression_Between ? IQRelativeTimeFilterUtil.newTestNodeFromBetween((SimpleConditionalExpression_Between)expression, factory, filterItemList, locale) : null);
        return testNode;
    }

    private static FilterLogicTestNodeInterface newTestNodeFromBetween(SimpleConditionalExpression_Between between, BaseFilterObjectFactory factory, FilterItemListInterface filterItemList, Locale locale) {
        DefaultFilterLogicTestNode testNode = null;
        if (between != null && between.getWhatToCompare() != null) {
            int type;
            ExpressionInterface whatToCompare = between.getWhatToCompare();
            if (whatToCompare instanceof DataItemFormattingExpression) {
                DataItem dataItem = ((DataItemFormattingExpression)whatToCompare).getDataItem();
                whatToCompare = dataItem;
            }
            if ((type = whatToCompare.getExpressionType()) == 4 || type == 6) {
                ArrayList<ExpressionInterface> exprValues = new ArrayList<ExpressionInterface>(2);
                exprValues.add(between.getLeftExpression());
                exprValues.add(between.getRightExpression());
                List dateTimeValues = IQRelativeTimeFilterUtil.generateValuesFromExpressions(exprValues, whatToCompare, locale);
                if (dateTimeValues != null) {
                    FilterItemInterface item = factory.findMatchingFilterItem(filterItemList, whatToCompare);
                    if (item == null) {
                        item = factory.convertToFilterItem(whatToCompare, null, filterItemList);
                    }
                    if (item != null) {
                        testNode = new DefaultFilterLogicTestNode();
                        testNode.setFilterItem(item);
                        TimeCondition condObj = TimeCondition.CONDITION_RANGE;
                        if (RelativeDateValueExpression.TODAY.equals((Object)between.getLeftExpression())) {
                            condObj = TimeCondition.CONDITION_RANGE;
                        } else if (RelativeTimestampValueExpression.DATETIME.equals((Object)between.getLeftExpression())) {
                            condObj = TimeCondition.CONDITION_RANGE;
                        } else if (!RelativeDateValueExpression.TODAY.equals((Object)between.getRightExpression()) && !RelativeTimestampValueExpression.DATETIME.equals((Object)between.getRightExpression())) {
                            condObj = TimeCondition.CONDITION_RANGE;
                        }
                        FilterConditionInterface condition = factory.findMatchingConditionObject(item, condObj, false);
                        if (condition == null) {
                            return null;
                        }
                        testNode.setCondition(condition);
                        testNode.setTestValuesList(dateTimeValues);
                    }
                }
            }
        }
        return testNode;
    }

    protected static RelativeTimeFilterData getRelativeTimeFilterDataFromValue(Object value) {
        DefaultFilterValue dfv;
        if (value instanceof DefaultFilterValue && (dfv = (DefaultFilterValue)value).getUnformattedValue() instanceof RelativeTimeFilterData) {
            return (RelativeTimeFilterData)dfv.getUnformattedValue();
        }
        return null;
    }

    private static FilterLogicTestNodeInterface newTestNodeFromComparison(SimpleConditionalExpression_Comparison comparison, BaseFilterObjectFactory factory, FilterItemListInterface filterItemList, Locale locale) {
        DefaultFilterLogicTestNode testNode = null;
        if (comparison != null) {
            ExpressionInterface whatToCompare = comparison.getLeftExpression();
            ArrayList<ExpressionInterface> exprValues = new ArrayList<ExpressionInterface>(1);
            exprValues.add(comparison.getRightExpression());
            List dateTimeValues = IQRelativeTimeFilterUtil.generateValuesFromExpressions(exprValues, whatToCompare, locale);
            if (dateTimeValues != null) {
                boolean isNegated;
                ComparisonOperator condObject;
                FilterConditionInterface condition;
                FilterItemInterface item = factory.findMatchingFilterItem(filterItemList, whatToCompare);
                if (item == null) {
                    item = factory.convertToFilterItem(whatToCompare, null, filterItemList);
                }
                if (item != null && (condition = factory.findMatchingConditionObject(item, condObject = comparison.getComparisonOperator(), isNegated = comparison.isNegated())) != null) {
                    testNode = new DefaultFilterLogicTestNode();
                    testNode.setFilterItem(item);
                    testNode.setCondition(condition);
                    testNode.setTestValuesList(dateTimeValues);
                }
            }
        }
        return testNode;
    }

    public static List generateValuesFromExpressions(List exprList, ExpressionInterface dataExpr) {
        return IQRelativeTimeFilterUtil.generateValuesFromExpressions(exprList, dataExpr, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List generateValuesFromExpressions(List exprList, ExpressionInterface dataExpr, Locale locale) {
        ArrayList<DefaultFilterValue> values;
        if (exprList != null && dataExpr != null) {
            int dataType = dataExpr.getExpressionType();
            values = new ArrayList<DefaultFilterValue>(exprList.size());
            for (ExpressionInterface expr : exprList) {
                DefaultFilterValue newValue;
                String formattedValue;
                if (expr instanceof AbstractTimeValueExpression) {
                    AbstractTimeValueExpression abstractTimeValue = (AbstractTimeValueExpression)expr;
                    Comparable<Double> unformattedValue = abstractTimeValue.getExplicitDoubleValue() != null ? abstractTimeValue.getExplicitDoubleValue() : abstractTimeValue.getValue();
                    StringExpressionUtil stringExpressionUtil = _stringExpressionUtil;
                    synchronized (stringExpressionUtil) {
                        Locale saveLocale = _stringExpressionUtil.getFormatLocale();
                        _stringExpressionUtil.setFormatLocale(locale);
                        String sasFormatText = DateAndTimeUtil.getFilterItemSASFormatText(dataExpr);
                        if (sasFormatText == null) {
                            sasFormatText = StringExpressionUtil.getDefaultSASFormatText((int)dataType);
                        }
                        try {
                            formattedValue = _stringExpressionUtil.getReadableText(expr, sasFormatText);
                            if (formattedValue != null) {
                                formattedValue = formattedValue.trim();
                            }
                        }
                        catch (MetadataException e) {
                            formattedValue = expr.toString();
                        }
                        finally {
                            _stringExpressionUtil.setFormatLocale(saveLocale);
                        }
                    }
                    newValue = new DefaultFilterValue((Object)expr, formattedValue, dataType, expr.getClass(), (Object)unformattedValue);
                    values.add(newValue);
                    continue;
                }
                if (expr instanceof ConstantExpression && ".".equals(((ConstantExpression)expr).getValue())) {
                    DefaultFilterValue newValue2 = new DefaultFilterValue((Object)expr, ".", dataType, expr.getClass(), (Object)".");
                    values.add(newValue2);
                    continue;
                }
                RelativeTimeFilterData data = IQRelativeTimeFilterUtil.generateDataFromExpression(expr);
                if (data == null) {
                    values = null;
                    break;
                }
                Format formatter = IQRelativeTimeFilterUtil.getRelativeTimeFilterValueFormatter(exprList, locale);
                formattedValue = formatter.format(data);
                newValue = new DefaultFilterValue((Object)expr, formattedValue, dataType, expr.getClass(), (Object)data);
                values.add(newValue);
            }
        } else {
            values = null;
        }
        return values;
    }

    public static Format getRelativeTimeFilterValueFormatter(List expressions, Locale locale) {
        _relativeTimeFilterFormatter.setLocale(locale);
        _relativeTimeFilterFormatter.setFilterCondition(TimeCondition.CONDITION_RANGE);
        if (expressions != null && expressions.size() == 2) {
            AbstractRelativeTimeValueExpression rtv;
            Object leftExpression = expressions.get(0);
            Object rightExpression = expressions.get(1);
            if (RelativeDateValueExpression.TODAY.equals(leftExpression)) {
                if (rightExpression instanceof AbstractRelativeTimeValueExpression) {
                    _relativeTimeFilterFormatter.setFilterCondition(TimeCondition.CONDITION_NEXT_N_PERIODS);
                }
            } else if (RelativeDateValueExpression.TODAY.equals(rightExpression) && leftExpression instanceof AbstractRelativeTimeValueExpression && (rtv = (AbstractRelativeTimeValueExpression)leftExpression).getShiftDirection() == TimeShiftDirection.PREVIOUS) {
                _relativeTimeFilterFormatter.setFilterCondition(TimeCondition.CONDITION_LAST_N_PERIODS);
            }
        }
        return _relativeTimeFilterFormatter;
    }

    public static RelativeTimeFilterData generateDataFromExpression(ExpressionInterface expr) {
        if (expr != null) {
            if (RelativeDateValueExpression.TODAY.equals((Object)expr)) {
                return new RelativeTimeFilterData(TimePeriod.PERIOD_TODAY);
            }
            if (RelativeDateValueExpression.TOMORROW.equals((Object)expr)) {
                return new RelativeTimeFilterData(TimePeriod.PERIOD_TOMORROW);
            }
            if (RelativeDateValueExpression.YESTERDAY.equals((Object)expr)) {
                return new RelativeTimeFilterData(TimePeriod.PERIOD_YESTERDAY);
            }
            if (RelativeTimestampValueExpression.DATETIME.equals((Object)expr)) {
                return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_DATETIME);
            }
            if (expr instanceof RelativeDateValueExpression) {
                TimePeriod shiftTimePeriod;
                RelativeTimeFilterData shiftData;
                RelativeDateValueExpression rdv = (RelativeDateValueExpression)expr;
                ExpressionInterface shiftFrom = rdv.getShiftingFrom();
                TimeShiftUnit shiftUnit = rdv.getShiftUnit();
                TimeShiftDirection shiftDirection = rdv.getShiftDirection();
                int shiftMultiplier = rdv.getShiftMultiplier();
                TimeShiftAlignment alignment = rdv.getAlignment();
                if (shiftFrom.equals(RelativeDateValueExpression.TODAY)) {
                    if (shiftUnit == TimeShiftUnit.YEAR && shiftDirection == TimeShiftDirection.PREVIOUS && shiftMultiplier == 1 && alignment == TimeShiftAlignment.NONE) {
                        return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_DAY_LAST_YEAR);
                    }
                    if (shiftDirection == TimeShiftDirection.CURRENT && shiftMultiplier == 0) {
                        if (shiftUnit == TimeShiftUnit.YEAR) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_YEAR);
                        }
                        if (shiftUnit == TimeShiftUnit.QUARTER) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_QUARTER);
                        }
                        if (shiftUnit == TimeShiftUnit.MONTH) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_MONTH);
                        }
                        if (shiftUnit == TimeShiftUnit.WEEK) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_WEEK);
                        }
                    }
                    if (shiftDirection == TimeShiftDirection.PREVIOUS && shiftMultiplier == 1) {
                        if (shiftUnit == TimeShiftUnit.YEAR) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_LAST_YEAR, TimePeriodType.YEARS, 1);
                        }
                        if (shiftUnit == TimeShiftUnit.QUARTER) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_LAST_QUARTER, TimePeriodType.QUARTERS, 1);
                        }
                        if (shiftUnit == TimeShiftUnit.MONTH) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_LAST_MONTH, TimePeriodType.MONTHS, 1);
                        }
                        if (shiftUnit == TimeShiftUnit.WEEK) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_LAST_WEEK, TimePeriodType.WEEKS, 1);
                        }
                    }
                }
                if ((shiftData = IQRelativeTimeFilterUtil.generateDataFromExpression(shiftFrom)) != null && (shiftTimePeriod = shiftData.getPeriod()) == TimePeriod.PERIOD_CURRENT_DAY_LAST_YEAR) {
                    if (shiftUnit == TimeShiftUnit.QUARTER) {
                        return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_QUARTER_LAST_YEAR);
                    }
                    if (shiftUnit == TimeShiftUnit.MONTH) {
                        return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_MONTH_LAST_YEAR);
                    }
                    if (shiftUnit == TimeShiftUnit.WEEK) {
                        return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_WEEK_LAST_YEAR);
                    }
                }
                if (shiftFrom.equals(RelativeDateValueExpression.TODAY)) {
                    if (shiftDirection == TimeShiftDirection.PREVIOUS) {
                        return new RelativeTimeFilterData(TimePeriod.PERIOD_N_PERIODS_AGO, IQRelativeTimeFilterUtil.getPeriodType(shiftUnit), shiftMultiplier);
                    }
                    if (shiftDirection == TimeShiftDirection.NEXT) {
                        return new RelativeTimeFilterData(TimePeriod.PERIOD_N_PERIODS_FROM_NOW, IQRelativeTimeFilterUtil.getPeriodType(shiftUnit), shiftMultiplier);
                    }
                }
            } else if (expr instanceof RelativeTimestampValueExpression) {
                TimePeriod shiftTimePeriod;
                RelativeTimeFilterData shiftData;
                RelativeTimestampValueExpression rtv = (RelativeTimestampValueExpression)expr;
                ExpressionInterface shiftFrom = rtv.getShiftingFrom();
                TimeShiftUnit shiftUnit = rtv.getShiftUnit();
                TimeShiftDirection shiftDirection = rtv.getShiftDirection();
                int shiftMultiplier = rtv.getShiftMultiplier();
                TimeShiftAlignment alignment = rtv.getAlignment();
                if (shiftFrom.equals(RelativeTimestampValueExpression.DATETIME)) {
                    if (shiftUnit == TimeShiftUnit.DAY && shiftMultiplier == 0) {
                        return new RelativeTimeFilterData(TimePeriod.PERIOD_TODAY);
                    }
                    if (shiftUnit == TimeShiftUnit.DAY && shiftMultiplier == 1 && shiftDirection == TimeShiftDirection.PREVIOUS && alignment != TimeShiftAlignment.NONE) {
                        return new RelativeTimeFilterData(TimePeriod.PERIOD_YESTERDAY);
                    }
                    if (shiftUnit == TimeShiftUnit.DAY && shiftMultiplier == 1 && shiftDirection == TimeShiftDirection.NEXT && alignment != TimeShiftAlignment.NONE) {
                        return new RelativeTimeFilterData(TimePeriod.PERIOD_TOMORROW);
                    }
                    if (shiftUnit == TimeShiftUnit.YEAR && shiftDirection == TimeShiftDirection.PREVIOUS && shiftMultiplier == 1 && alignment == TimeShiftAlignment.NONE) {
                        return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_DATETIME_LAST_YEAR);
                    }
                    if (shiftDirection == TimeShiftDirection.CURRENT && shiftMultiplier == 0) {
                        if (shiftUnit == TimeShiftUnit.YEAR) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_YEAR);
                        }
                        if (shiftUnit == TimeShiftUnit.QUARTER) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_QUARTER);
                        }
                        if (shiftUnit == TimeShiftUnit.MONTH) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_MONTH);
                        }
                        if (shiftUnit == TimeShiftUnit.WEEK) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_WEEK);
                        }
                        if (shiftUnit == TimeShiftUnit.HOUR) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_HOUR);
                        }
                        if (shiftUnit == TimeShiftUnit.MINUTE) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_MINUTE);
                        }
                    }
                    if (shiftDirection == TimeShiftDirection.PREVIOUS && shiftMultiplier == 1) {
                        if (shiftUnit == TimeShiftUnit.MINUTE) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_LAST_MINUTE);
                        }
                        if (shiftUnit == TimeShiftUnit.HOUR) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_LAST_HOUR);
                        }
                        if (shiftUnit == TimeShiftUnit.WEEK) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_LAST_WEEK);
                        }
                        if (shiftUnit == TimeShiftUnit.MONTH) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_LAST_MONTH);
                        }
                        if (shiftUnit == TimeShiftUnit.QUARTER) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_LAST_QUARTER);
                        }
                        if (shiftUnit == TimeShiftUnit.YEAR) {
                            return new RelativeTimeFilterData(TimePeriod.PERIOD_LAST_YEAR);
                        }
                    }
                    if (shiftDirection == TimeShiftDirection.NEXT && shiftMultiplier == 1 && shiftUnit == TimeShiftUnit.MINUTE) {
                        return new RelativeTimeFilterData(TimePeriod.PERIOD_NEXT_MINUTE);
                    }
                }
                if ((shiftData = IQRelativeTimeFilterUtil.generateDataFromExpression(shiftFrom)) != null && (shiftTimePeriod = shiftData.getPeriod()) == TimePeriod.PERIOD_CURRENT_DATETIME_LAST_YEAR) {
                    if (shiftUnit == TimeShiftUnit.DAY) {
                        return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_DAY_LAST_YEAR);
                    }
                    if (shiftUnit == TimeShiftUnit.WEEK) {
                        return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_WEEK_LAST_YEAR);
                    }
                    if (shiftUnit == TimeShiftUnit.MONTH) {
                        return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_MONTH_LAST_YEAR);
                    }
                    if (shiftUnit == TimeShiftUnit.QUARTER) {
                        return new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_QUARTER_LAST_YEAR);
                    }
                }
                if (shiftFrom.equals(RelativeTimestampValueExpression.DATETIME)) {
                    if (shiftDirection == TimeShiftDirection.PREVIOUS) {
                        return new RelativeTimeFilterData(TimePeriod.PERIOD_N_PERIODS_AGO, IQRelativeTimeFilterUtil.getPeriodType(shiftUnit), shiftMultiplier);
                    }
                    if (shiftDirection == TimeShiftDirection.NEXT) {
                        return new RelativeTimeFilterData(TimePeriod.PERIOD_N_PERIODS_FROM_NOW, IQRelativeTimeFilterUtil.getPeriodType(shiftUnit), shiftMultiplier);
                    }
                }
            }
        }
        return null;
    }

    private static synchronized Map getPeriodTypeMap() {
        if (periodTypeMap.isEmpty()) {
            periodTypeMap.put(TimeShiftUnit.DAY, TimePeriodType.DAYS);
            periodTypeMap.put(TimeShiftUnit.HOUR, TimePeriodType.HOURS);
            periodTypeMap.put(TimeShiftUnit.MINUTE, TimePeriodType.MINUTES);
            periodTypeMap.put(TimeShiftUnit.MONTH, TimePeriodType.MONTHS);
            periodTypeMap.put(TimeShiftUnit.QUARTER, TimePeriodType.QUARTERS);
            periodTypeMap.put(TimeShiftUnit.SECOND, TimePeriodType.SECONDS);
            periodTypeMap.put(TimeShiftUnit.WEEK, TimePeriodType.WEEKS);
            periodTypeMap.put(TimeShiftUnit.YEAR, TimePeriodType.YEARS);
        }
        return periodTypeMap;
    }

    public static TimePeriodType getPeriodType(TimeShiftUnit shiftUnit) {
        return (TimePeriodType)IQRelativeTimeFilterUtil.getPeriodTypeMap().get(shiftUnit);
    }

    private static synchronized Map getShiftUnitMap() {
        if (shiftUnitMap.isEmpty()) {
            shiftUnitMap.put(TimePeriodType.DAYS, TimeShiftUnit.DAY);
            shiftUnitMap.put(TimePeriodType.HOURS, TimeShiftUnit.HOUR);
            shiftUnitMap.put(TimePeriodType.MINUTES, TimeShiftUnit.MINUTE);
            shiftUnitMap.put(TimePeriodType.MONTHS, TimeShiftUnit.MONTH);
            shiftUnitMap.put(TimePeriodType.QUARTERS, TimeShiftUnit.QUARTER);
            shiftUnitMap.put(TimePeriodType.SECONDS, TimeShiftUnit.SECOND);
            shiftUnitMap.put(TimePeriodType.WEEKS, TimeShiftUnit.WEEK);
            shiftUnitMap.put(TimePeriodType.YEARS, TimeShiftUnit.YEAR);
        }
        return shiftUnitMap;
    }

    public static TimeShiftUnit getShiftUnit(TimePeriodType periodType) {
        return (TimeShiftUnit)IQRelativeTimeFilterUtil.getShiftUnitMap().get(periodType);
    }

    public static ConditionalExpression newFilterExpression(FilterLogicTestNodeInterface testNode, ExpressionInterface itemExpr, TimeCondition condition, List valueObjects, int exprType) {
        boolean isRangePrompt;
        SimpleConditionalExpression_Between expression = null;
        boolean bl = isRangePrompt = valueObjects != null && valueObjects.size() == 1 && valueObjects.get(0) instanceof Prompt && BaseDefinitionRangeInterface.class.isAssignableFrom(((Prompt)valueObjects.get(0)).getPromptDefinition().getClass());
        if (testNode != null && condition != null && itemExpr != null && valueObjects != null && (valueObjects.size() >= 2 || isRangePrompt)) {
            DataItem di;
            List valueExpressions = IQRelativeTimeFilterUtil.generateExpressionsFromValues(valueObjects, exprType);
            SimpleConditionalExpression_Between between = new SimpleConditionalExpression_Between();
            between.setWhatToCompare(itemExpr);
            between.setLeftExpression((ExpressionInterface)valueExpressions.get(0));
            if (isRangePrompt) {
                between.setRightExpression(null);
            } else {
                between.setRightExpression((ExpressionInterface)valueExpressions.get(1));
            }
            if (itemExpr instanceof DataItem && (di = (DataItem)itemExpr).isFormattingForced()) {
                between.setFormattingForcedOverridden(true);
                between.setFormattingForcedOverrideValue(false);
            }
            expression = between;
        }
        return expression;
    }
}

