/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.filters.DataRetrievalError;
import com.sas.dataselectors.filters.FilterValuesInterface;
import com.sas.dataselectors.filters.OLAPMemberTreeNode;
import com.sas.dataselectors.filters.RB;
import com.sas.iquery.dataservices.DataServicesException;
import com.sas.iquery.dataservices.IQDataServices;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class OLAPMemberDeferredRetrievalTreeNode
extends OLAPMemberTreeNode
implements FilterValuesInterface {
    private static final boolean DEBUG = false;
    boolean _initialized = false;
    ValueGetter _getter;
    MetadataInterface _metadata;
    String _cubeName;
    int _hierarchyStructure = 0;
    int levelDepth;
    protected Collection _values;
    protected Iterator _valuesIterator;

    OLAPMemberDeferredRetrievalTreeNode() {
        this._initialized = true;
    }

    public boolean getInitialized() {
        return this._initialized;
    }

    void setValueGetter(ValueGetter getter) {
        this._getter = getter;
        this._initialized = false;
    }

    public OLAPMemberDeferredRetrievalTreeNode(HierarchyInterface hierarchy) throws OLAPException {
        super(hierarchy);
        this._getter = new HierarchyValueGetter(hierarchy);
        this._hierarchyStructure = hierarchy.getStructure();
    }

    public OLAPMemberDeferredRetrievalTreeNode(DimensionInterface dimension) throws OLAPException {
        super(dimension);
        this._getter = new DimensionValueGetter(dimension);
    }

    public OLAPMemberDeferredRetrievalTreeNode(LevelInterface level) throws OLAPException {
        super(level);
        this._getter = new LevelValueGetter(level);
    }

    public OLAPMemberDeferredRetrievalTreeNode(LevelInterface level, int hierarchyStructure) throws OLAPException {
        this(level);
        this._hierarchyStructure = hierarchyStructure;
    }

    public OLAPMemberDeferredRetrievalTreeNode(MemberInterface member) throws OLAPException {
        super(member);
        this._getter = new MemberValueGetter(member);
    }

    public OLAPMemberDeferredRetrievalTreeNode(MemberInterface member, int hierarchyStructure) throws OLAPException {
        this(member);
        this._hierarchyStructure = hierarchyStructure;
    }

    public OLAPMemberDeferredRetrievalTreeNode(MemberInterface member, MemberInterface[] children) throws OLAPException {
        super(member);
        this._getter = new MemberValueGetter(member, children);
    }

    public OLAPMemberDeferredRetrievalTreeNode(MemberInterface member, boolean useGetter) throws OLAPException {
        super(member);
        if (useGetter) {
            this._getter = new MemberValueGetter(member);
        } else {
            this._getter = null;
            this._initialized = true;
        }
    }

    public OLAPMemberDeferredRetrievalTreeNode(DataItem dataItem, MetadataInterface metadata) throws MetadataException {
        super(dataItem);
        this._metadata = metadata;
        this._getter = new DataItemValueGetter(dataItem);
    }

    public OLAPMemberDeferredRetrievalTreeNode(DataItem dataItem, MetadataInterface metadata, int levelDepth) throws MetadataException {
        this(dataItem, metadata);
        this._getter.setLevelDepth(levelDepth);
    }

    public OLAPMemberDeferredRetrievalTreeNode(TupleElementInterface element, MetadataInterface metadata, String cubeName) throws OLAPException {
        super(element);
        this._metadata = metadata;
        this._cubeName = cubeName;
        this._getter = new TupleElementValueGetter(element, cubeName);
    }

    public OLAPMemberDeferredRetrievalTreeNode(TupleElementInterface element, MetadataInterface metadata, String cubeName, int structure) throws OLAPException {
        this(element, metadata, cubeName);
        this._hierarchyStructure = structure;
    }

    public void setLevelDepth(int levelDepth) {
        this.levelDepth = levelDepth;
        this._getter.setLevelDepth(levelDepth);
    }

    protected synchronized boolean doInit() {
        if (!this._initialized && this._getter != null) {
            try {
                this._initialized = true;
                this._getter.getValues(this);
                if (this.children != null) {
                    this._values = Collections.unmodifiableCollection(this.children);
                    this._valuesIterator = this._values.iterator();
                }
            }
            catch (Exception e) {
                this._initialized = false;
                throw new DataRetrievalError(RB.getStringResource((String)"BaseFilterObjectFactory.", (String)"ErrorGettingValues.txt"), (Throwable)e);
            }
        }
        return this._initialized;
    }

    public Enumeration children() {
        if (!this._initialized) {
            this.doInit();
        }
        return super.children();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        if (!this._initialized) {
            this.doInit();
        }
        return super.getChildAt(childIndex);
    }

    @Override
    public int getChildCount() {
        int count = !this._initialized && this._getter != null ? this._getter.getChildCount() : super.getChildCount();
        return count;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (!this._initialized) {
            this.doInit();
        }
        return super.getIndex(node);
    }

    @Override
    public TreeNode getParent() {
        return super.getParent();
    }

    @Override
    public boolean isLeaf() {
        if (this._getter != null) {
            return !this._getter.hasChildren();
        }
        return super.isLeaf();
    }

    @Override
    public void insert(MutableTreeNode node, int index) {
        super.insert(node, index);
    }

    @Override
    public void remove(int index) {
        if (!this._initialized) {
            this.doInit();
        }
        super.remove(index);
    }

    @Override
    public void remove(MutableTreeNode node) {
        if (!this._initialized) {
            this.doInit();
        }
        super.remove(node);
    }

    @Override
    public void removeFromParent() {
        if (!this._initialized) {
            this.doInit();
        }
        super.removeFromParent();
    }

    @Override
    public void setParent(MutableTreeNode node) {
        super.setParent(node);
    }

    public Enumeration breadthFirstEnumeration() {
        if (!this._initialized) {
            this.doInit();
        }
        return super.breadthFirstEnumeration();
    }

    public Enumeration depthFirstEnumeration() {
        if (!this._initialized) {
            this.doInit();
        }
        return super.depthFirstEnumeration();
    }

    @Override
    public TreeNode getChildAfter(TreeNode aChild) {
        if (!this._initialized) {
            this.doInit();
        }
        return super.getChildAfter(aChild);
    }

    @Override
    public TreeNode getChildBefore(TreeNode aChild) {
        if (!this._initialized) {
            this.doInit();
        }
        return super.getChildBefore(aChild);
    }

    @Override
    public TreeNode getFirstChild() {
        if (!this._initialized) {
            this.doInit();
        }
        return super.getFirstChild();
    }

    @Override
    public DefaultMutableTreeNode getFirstLeaf() {
        if (!this._initialized) {
            this.doInit();
        }
        return super.getFirstLeaf();
    }

    @Override
    public TreeNode getLastChild() {
        if (!this._initialized) {
            this.doInit();
        }
        return super.getLastChild();
    }

    @Override
    public DefaultMutableTreeNode getLastLeaf() {
        if (!this._initialized) {
            this.doInit();
        }
        return super.getLastLeaf();
    }

    @Override
    public int getLeafCount() {
        if (!this._initialized) {
            this.doInit();
        }
        return super.getLeafCount();
    }

    @Override
    public DefaultMutableTreeNode getNextLeaf() {
        if (!this._initialized) {
            this.doInit();
        }
        return super.getNextLeaf();
    }

    @Override
    public DefaultMutableTreeNode getNextNode() {
        if (!this._initialized) {
            this.doInit();
        }
        return super.getNextNode();
    }

    @Override
    public DefaultMutableTreeNode getPreviousLeaf() {
        if (!this._initialized) {
            this.doInit();
        }
        return super.getPreviousLeaf();
    }

    @Override
    public DefaultMutableTreeNode getPreviousNode() {
        if (!this._initialized) {
            this.doInit();
        }
        return super.getPreviousNode();
    }

    @Override
    public boolean isNodeChild(TreeNode aNode) {
        if (!this._initialized) {
            this.doInit();
        }
        return super.isNodeChild(aNode);
    }

    public Enumeration postorderEnumeration() {
        if (!this._initialized) {
            this.doInit();
        }
        return super.postorderEnumeration();
    }

    public Enumeration preorderEnumeration() {
        if (!this._initialized) {
            this.doInit();
        }
        return super.preorderEnumeration();
    }

    @Override
    public void removeAllChildren() {
        super.removeAllChildren();
        this._initialized = false;
    }

    String _getCubeName(DataItem item) throws MetadataException {
        if (item != null) {
            this._cubeName = BusinessQueryOLAPUtil.getCubeName((BusinessModel)item.getBusinessModel(), (DataItem)item);
        }
        return this._cubeName;
    }

    public List getFirstValues(long lThreshold) throws DataRetrievalError {
        if (!this._initialized) {
            this.doInit();
        }
        if (this._values != null) {
            this._valuesIterator = this._values.iterator();
        }
        return this.getNextValues(lThreshold);
    }

    public List getNextValues(long lThreshold) throws DataRetrievalError {
        if (!this._initialized) {
            this.doInit();
        }
        ArrayList temp = null;
        if (this._valuesIterator != null) {
            temp = new ArrayList();
            int i = 0;
            while (this._valuesIterator.hasNext()) {
                temp.add(this._valuesIterator.next());
                if (lThreshold <= 0L || (long)(++i) < lThreshold) continue;
                break;
            }
        }
        return temp;
    }

    public boolean hasMoreValues() {
        if (!this._initialized) {
            this.doInit();
        }
        return this._valuesIterator == null ? false : this._valuesIterator.hasNext();
    }

    public String getListLabel() {
        return this.getLabel();
    }

    class LevelDataItemValueGetter
    extends ValueGetter {
        DataItem _item;
        List _members;
        Map _pathMap;
        MemberInterface _root;
        List _children;

        public LevelDataItemValueGetter(DataItem item) throws MetadataException {
            this._members = null;
            this._root = null;
            this._children = null;
            this._item = item;
            OLAPMemberDeferredRetrievalTreeNode.this._getCubeName(item);
        }

        private void _loadMembers() {
            if (this._members == null) {
                this._pathMap = null;
                IQDataServices iqds = new IQDataServices();
                try {
                    if (this.levelDepth < 0) {
                        this._members = iqds.getMembers(this._item, -1);
                    } else {
                        List temp = iqds.getMembers(this._item, -1);
                        this._members = new ArrayList();
                        int size = temp.size();
                        for (int i = 0; i < size; ++i) {
                            TupleElementInterface tupleElem = (TupleElementInterface)temp.get(i);
                            try {
                                if (tupleElem.getLevelDepth() > this.levelDepth) continue;
                                this._members.add(tupleElem);
                                continue;
                            }
                            catch (OLAPException oe) {
                                this._members = temp;
                            }
                        }
                    }
                }
                catch (DataServicesException e) {
                    throw new DataRetrievalError(RB.getStringResource((String)"BaseFilterObjectFactory.", (String)"ErrorGettingValues.txt"), (Throwable)e);
                }
            }
        }

        private Map _loadPathMap() {
            HashMap map = new HashMap(this._members.size());
            try {
                for (int i = 0; i < this._members.size(); ++i) {
                    TupleElementInterface tupleElem = (TupleElementInterface)this._members.get(i);
                    ElementWrapper wrapper = new ElementWrapper(tupleElem);
                    if (map.containsKey(wrapper)) continue;
                    int level_depth = tupleElem.getLevelDepth();
                    Filter filter = new Filter();
                    filter.setUniqueMemberName(tupleElem.getName());
                    filter.setTreeOperator(Filter.ANCESTORS_TREE_OPERATOR | Filter.SIBLINGS_TREE_OPERATOR);
                    filter.setCubeName(OLAPMemberDeferredRetrievalTreeNode.this._cubeName);
                    MemberInterface[] members = OLAPMemberDeferredRetrievalTreeNode.this._metadata.getMembers(filter, 0, -1);
                    ArrayList<MemberInterface> path = new ArrayList<MemberInterface>(members.length);
                    ArrayList<MemberInterface> siblings = new ArrayList<MemberInterface>(members.length);
                    for (int j = 0; j < members.length; ++j) {
                        if (members[j].getLevel().getDepth() < level_depth) {
                            path.add(members[j]);
                            if (this._root != null) continue;
                            this._root = members[j];
                            continue;
                        }
                        siblings.add(members[j]);
                    }
                    Iterator j = siblings.iterator();
                    while (j.hasNext()) {
                        map.put(new ElementWrapper((MemberInterface)j.next()), path);
                    }
                    map.put(new ElementWrapper(tupleElem), path);
                }
            }
            catch (OLAPException e) {
                throw new DataRetrievalError(RB.getStringResource((String)"BaseFilterObjectFactory.", (String)"ErrorGettingValues.txt"), (Throwable)e);
            }
            return map;
        }

        private void _processPathMap() {
            this._children = new ArrayList();
            HashMap<ElementWrapper, OLAPMemberTreeNode> treeMap = new HashMap<ElementWrapper, OLAPMemberTreeNode>();
            try {
                for (int i = 0; i < this._members.size(); ++i) {
                    TupleElementInterface tupleElem = (TupleElementInterface)this._members.get(i);
                    List pathMembers = (List)this._pathMap.get(new ElementWrapper(tupleElem));
                    DefaultMutableTreeNode pNode = null;
                    for (MemberInterface member : pathMembers) {
                        OLAPMemberTreeNode treeNode = (OLAPMemberTreeNode)treeMap.get(new ElementWrapper(member));
                        if (treeNode == null) {
                            treeNode = new OLAPMemberDeferredRetrievalTreeNode(member, false);
                            treeMap.put(new ElementWrapper(member), treeNode);
                            if (pNode != null) {
                                pNode.add(treeNode);
                            } else {
                                this._children.add(treeNode);
                            }
                        }
                        pNode = treeNode;
                    }
                    pNode.add(new OLAPMemberTreeNode(tupleElem));
                }
            }
            catch (OLAPException e) {
                throw new DataRetrievalError(RB.getStringResource((String)"BaseFilterObjectFactory.", (String)"ErrorGettingValues.txt"), (Throwable)e);
            }
        }

        @Override
        public void getValues(MutableTreeNode root) throws Exception {
            this._loadMembers();
            if (this._pathMap == null) {
                this._pathMap = this._loadPathMap();
                this._processPathMap();
            }
            for (int i = 0; i < this._children.size(); ++i) {
                root.insert((MutableTreeNode)this._children.get(i), i);
            }
        }

        @Override
        public int getChildCount() {
            this._loadMembers();
            if (this._pathMap == null) {
                this._pathMap = this._loadPathMap();
                this._processPathMap();
            }
            return this._children == null ? 0 : this._children.size();
        }

        class ElementWrapper {
            Object _element;
            String _name;

            public ElementWrapper(TupleElementInterface element) throws OLAPException {
                this._element = element;
                this._name = element.getName();
            }

            public ElementWrapper(MemberInterface element) throws OLAPException {
                this._element = element;
                this._name = element.getUniqueName();
            }

            public String getName() {
                return this._name;
            }

            public boolean equals(Object other) {
                return other instanceof ElementWrapper && ((ElementWrapper)other)._name.equals(this._name);
            }

            public int hashCode() {
                return this._name.hashCode();
            }
        }
    }

    class TupleElementValueGetter
    extends ValueGetter {
        TupleElementInterface _element;
        MemberInterface[] _members;

        public TupleElementValueGetter(TupleElementInterface element) {
            this._element = element;
            this._members = null;
        }

        public TupleElementValueGetter(TupleElementInterface element, String cubeName) {
            this._element = element;
            OLAPMemberDeferredRetrievalTreeNode.this._cubeName = cubeName;
            this._members = null;
        }

        public TupleElementValueGetter(TupleElementInterface element, int childrenDepth) {
            this._element = element;
            this._members = null;
            this.levelDepth = childrenDepth;
        }

        private void loadData() throws OLAPException {
            if (this._members == null) {
                Filter filter = new Filter();
                filter.setUniqueMemberName(this._element.getName());
                filter.setTreeOperator(Filter.CHILDREN_TREE_OPERATOR);
                if (OLAPMemberDeferredRetrievalTreeNode.this._cubeName != null) {
                    filter.setCubeName(OLAPMemberDeferredRetrievalTreeNode.this._cubeName);
                }
                MemberInterface[] temp = OLAPMemberDeferredRetrievalTreeNode.this._metadata.getMembers(filter, 0, -1);
                this._members = this.levelDepth < 0 || temp != null && temp.length > 0 && temp[0].getLevel().getDepth() <= this.levelDepth ? temp : new MemberInterface[0];
            }
        }

        @Override
        public void getValues(MutableTreeNode root) throws Exception {
            this.loadData();
            for (int i = 0; i < this._members.length; ++i) {
                OLAPMemberDeferredRetrievalTreeNode n = new OLAPMemberDeferredRetrievalTreeNode(this._members[i], OLAPMemberDeferredRetrievalTreeNode.this._hierarchyStructure);
                if (this.levelDepth >= 0) {
                    n.setLevelDepth(this.levelDepth);
                }
                root.insert(n, i);
            }
        }

        @Override
        public boolean hasChildren() {
            if (this._members != null) {
                return this._members.length != 0;
            }
            try {
                if (this.levelDepth < 0 || this._element.getLevelDepth() < this.levelDepth) {
                    return this._element.getChildCount() != 0;
                }
                return false;
            }
            catch (OLAPException e) {
                throw new DataRetrievalError(RB.getStringResource((String)"BaseFilterObjectFactory.", (String)"ErrorGettingValues.txt"), (Throwable)e);
            }
        }

        @Override
        public int getChildCount() {
            int count = 0;
            if (this._members != null) {
                count = this._members.length;
            } else {
                try {
                    if (this.levelDepth < 0 || this._element.getLevelDepth() < this.levelDepth) {
                        count = this._element.getChildCount();
                    }
                    if (count > 0) {
                        this.loadData();
                        count = this._members.length;
                    }
                }
                catch (OLAPException e) {
                    throw new DataRetrievalError(RB.getStringResource((String)"BaseFilterObjectFactory.", (String)"ErrorGettingValues.txt"), (Throwable)e);
                }
            }
            return count;
        }
    }

    class DataItemValueGetter
    extends ValueGetter {
        DataItem _item;
        List _members;

        public DataItemValueGetter(DataItem item) {
            this._members = null;
            this._item = item;
        }

        public DataItemValueGetter(DataItem item, int childrenDepth) {
            this._members = null;
            this._item = item;
            this.levelDepth = childrenDepth;
        }

        private void _loadMembers() {
            block14: {
                if (this._members == null) {
                    IQDataServices iqds = new IQDataServices();
                    try {
                        if (this.levelDepth < 0) {
                            this._members = iqds.getMembers(this._item, -1);
                        } else {
                            List temp = iqds.getMembers(this._item, -1);
                            this._members = new ArrayList();
                            int size = temp.size();
                            for (int i = 0; i < size; ++i) {
                                TupleElementInterface tupleElem = (TupleElementInterface)temp.get(i);
                                try {
                                    if (tupleElem.getLevelDepth() > this.levelDepth) continue;
                                    this._members.add(tupleElem);
                                    continue;
                                }
                                catch (OLAPException oe) {
                                    this._members = temp;
                                }
                            }
                        }
                    }
                    catch (DataServicesException e) {
                        throw new DataRetrievalError(RB.getStringResource((String)"BaseFilterObjectFactory.", (String)"ErrorGettingValues.txt"), (Throwable)e);
                    }
                    if (this._members.size() > 0) {
                        TupleElementInterface tupleElem = (TupleElementInterface)this._members.get(0);
                        try {
                            if (this.levelDepth >= 0 && tupleElem.getLevelDepth() > this.levelDepth) break block14;
                            Filter filter = new Filter();
                            String uniqueMemberName = tupleElem.getName();
                            OLAPMemberDeferredRetrievalTreeNode.this._cubeName = OLAPMemberDeferredRetrievalTreeNode.this._getCubeName(this._item);
                            filter.setCubeName(OLAPMemberDeferredRetrievalTreeNode.this._cubeName);
                            filter.setUniqueMemberName(uniqueMemberName);
                            try {
                                HierarchyInterface[] hierarchies;
                                MemberInterface[] mList = OLAPMemberDeferredRetrievalTreeNode.this._metadata.getMembers(filter, 0, 1);
                                if (mList.length > 0 && (hierarchies = OLAPMemberDeferredRetrievalTreeNode.this._metadata.getHierarchies(filter = mList[0].getFilter())).length > 0) {
                                    OLAPMemberDeferredRetrievalTreeNode.this._hierarchyStructure = hierarchies[0].getStructure();
                                }
                            }
                            catch (Exception e) {
                                this._members.remove(tupleElem);
                            }
                        }
                        catch (Exception e) {
                            throw new DataRetrievalError(RB.getStringResource((String)"BaseFilterObjectFactory.", (String)"ErrorGettingValues.txt"), (Throwable)e);
                        }
                    }
                }
            }
        }

        @Override
        public void getValues(MutableTreeNode root) throws Exception {
            this._loadMembers();
            for (int i = 0; i < this._members.size(); ++i) {
                TupleElementInterface tupleElem = (TupleElementInterface)this._members.get(i);
                OLAPMemberDeferredRetrievalTreeNode node = new OLAPMemberDeferredRetrievalTreeNode(tupleElem, OLAPMemberDeferredRetrievalTreeNode.this._metadata, OLAPMemberDeferredRetrievalTreeNode.this._cubeName, OLAPMemberDeferredRetrievalTreeNode.this._hierarchyStructure);
                if (this.levelDepth >= 0) {
                    node.setLevelDepth(this.levelDepth);
                }
                root.insert(node, i);
            }
        }

        @Override
        public int getChildCount() {
            this._loadMembers();
            return this._members.size();
        }
    }

    class MemberValueGetter
    extends ValueGetter {
        MemberInterface _member;
        MemberInterface[] _children;

        public MemberValueGetter(MemberInterface member) {
            this(member, null);
        }

        public MemberValueGetter(MemberInterface member, MemberInterface[] children) {
            this._member = member;
            this._children = children;
        }

        public MemberValueGetter(MemberInterface member, int levelDepth) {
            this(member, null);
            this.levelDepth = levelDepth;
        }

        private void loadData() throws OLAPException {
            if (this._children == null) {
                if (this.levelDepth < 0) {
                    this._children = this._member.getChildren();
                } else {
                    MemberInterface[] mem = this._member.getChildren();
                    ArrayList<MemberInterface> l = new ArrayList<MemberInterface>();
                    for (int i = 0; i < mem.length; ++i) {
                        if (this.levelDepth >= 0 && mem[i].getLevel().getDepth() > this.levelDepth) continue;
                        l.add(mem[i]);
                    }
                    this._children = l.toArray(new MemberInterface[0]);
                }
            }
        }

        @Override
        public void getValues(MutableTreeNode root) throws Exception {
            if (this.getChildCount() > 0) {
                this.loadData();
                OLAPMemberTreeNode n = null;
                for (int i = 0; i < this._children.length; ++i) {
                    if (this._children[i].getChildCount() == 0) {
                        n = new OLAPMemberTreeNode(this._children[i]);
                    } else {
                        n = new OLAPMemberDeferredRetrievalTreeNode(this._children[i], OLAPMemberDeferredRetrievalTreeNode.this._hierarchyStructure);
                        if (this.levelDepth >= 0) {
                            ((OLAPMemberDeferredRetrievalTreeNode)n).setLevelDepth(this.levelDepth);
                        }
                    }
                    root.insert(n, i);
                }
            }
        }

        @Override
        public boolean hasChildren() {
            if (this._children != null) {
                return this._children.length != 0;
            }
            try {
                if (this.levelDepth < 0 || this._member.getLevel().getDepth() < this.levelDepth) {
                    return this._member.getChildCount() != 0;
                }
                return false;
            }
            catch (OLAPException e) {
                throw new DataRetrievalError(RB.getStringResource((String)"BaseFilterObjectFactory.", (String)"ErrorGettingValues.txt"), (Throwable)e);
            }
        }

        @Override
        public int getChildCount() {
            int count;
            if (this._children != null) {
                count = this._children.length;
            } else {
                try {
                    int childCount = this._member.getChildCount();
                    if (childCount == 0) {
                        count = 0;
                        this._children = new MemberInterface[0];
                    } else {
                        MemberInterface[] mem = this._member.getChildren();
                        ArrayList<MemberInterface> l = new ArrayList<MemberInterface>();
                        for (int i = 0; i < mem.length; ++i) {
                            if (this.levelDepth >= 0 && mem[i].getLevel().getDepth() > this.levelDepth) continue;
                            l.add(mem[i]);
                        }
                        count = l.size();
                        if (count > 0) {
                            this.loadData();
                            count = this._children.length;
                        }
                    }
                }
                catch (OLAPException e) {
                    throw new DataRetrievalError(RB.getStringResource((String)"BaseFilterObjectFactory.", (String)"ErrorGettingValues.txt"), (Throwable)e);
                }
            }
            return count;
        }
    }

    class LevelValueGetter
    extends ValueGetter {
        LevelInterface _level;

        public LevelValueGetter(LevelInterface level) {
            this._level = level;
        }

        @Override
        public void getValues(MutableTreeNode root) throws Exception {
            MemberInterface[] members = this._level.getMembers();
            for (int i = 0; i < members.length; ++i) {
                OLAPMemberDeferredRetrievalTreeNode n = new OLAPMemberDeferredRetrievalTreeNode(members[i], OLAPMemberDeferredRetrievalTreeNode.this._hierarchyStructure);
                if (this.levelDepth > 0) {
                    n.setLevelDepth(this.levelDepth);
                }
                root.insert(n, i);
            }
        }

        @Override
        public int getChildCount() {
            try {
                return this._level.getMemberCount();
            }
            catch (OLAPException e) {
                throw new DataRetrievalError(RB.getStringResource((String)"BaseFilterObjectFactory.", (String)"ErrorGettingValues.txt"), (Throwable)e);
            }
        }
    }

    class HierarchyValueGetter
    extends ValueGetter {
        HierarchyInterface _hierarchy;
        LevelInterface[] _levels;

        public HierarchyValueGetter(HierarchyInterface hierarchy) {
            this._hierarchy = hierarchy;
            this._levels = null;
        }

        private synchronized void loadValues() throws OLAPException {
            if (this._levels == null) {
                this._levels = this._hierarchy.getLevels();
            }
        }

        @Override
        public void getValues(MutableTreeNode root) throws Exception {
            this.loadValues();
            if (this._levels != null) {
                for (int i = 0; i < this._levels.length; ++i) {
                    OLAPMemberDeferredRetrievalTreeNode n = new OLAPMemberDeferredRetrievalTreeNode(this._levels[i], OLAPMemberDeferredRetrievalTreeNode.this._hierarchyStructure);
                    if (this.levelDepth > 0) {
                        n.setLevelDepth(this.levelDepth);
                    }
                    root.insert(n, i);
                }
            }
        }

        @Override
        public int getChildCount() {
            try {
                this.loadValues();
                return this._levels != null ? this._levels.length : 0;
            }
            catch (OLAPException e) {
                throw new DataRetrievalError(RB.getStringResource((String)"BaseFilterObjectFactory.", (String)"ErrorGettingValues.txt"), (Throwable)e);
            }
        }
    }

    class DimensionValueGetter
    extends ValueGetter {
        DimensionInterface _dimension;
        HierarchyInterface[] _hierarchies;

        public DimensionValueGetter(DimensionInterface dimension) {
            this._dimension = dimension;
            this._hierarchies = null;
        }

        private void _loadMembers() throws OLAPException {
            if (this._hierarchies == null && this._dimension != null) {
                this._hierarchies = this._dimension.getHierarchies();
            }
        }

        @Override
        public void getValues(MutableTreeNode root) throws Exception {
            this._loadMembers();
            for (int i = 0; i < this._hierarchies.length; ++i) {
                OLAPMemberDeferredRetrievalTreeNode n = new OLAPMemberDeferredRetrievalTreeNode(this._hierarchies[i]);
                if (this.levelDepth > 0) {
                    n.setLevelDepth(this.levelDepth);
                }
                root.insert(n, i);
            }
        }

        @Override
        public int getChildCount() {
            try {
                this._loadMembers();
                return this._hierarchies.length;
            }
            catch (OLAPException e) {
                throw new DataRetrievalError(RB.getStringResource((String)"BaseFilterObjectFactory.", (String)"ErrorGettingValues.txt"), (Throwable)e);
            }
        }
    }

    abstract class ValueGetter {
        public int levelDepth = -1;

        ValueGetter() {
        }

        public abstract void getValues(MutableTreeNode var1) throws Exception;

        public abstract int getChildCount();

        public boolean hasChildren() {
            return this.getChildCount() != 0;
        }

        public void setLevelDepth(int levelDepth) {
            this.levelDepth = levelDepth;
        }
    }
}

