/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.filters.FilterItemInterface;
import com.sas.dataselectors.filters.FilterItemListInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterObjectFactoryInterface;
import com.sas.iquery.metadata.business.CompoundFilter;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FilterItemSimpleTree {
    FilterObjectFactoryInterface _filterObjectFactory = null;
    FilterItem _rootFilterItem = null;
    FilterItemListInterface _filterItemList = null;
    SimpleTreeNode _rootSimpleTree = null;
    Map _mapOfTestNodesToTreeNodes = new HashMap();
    List _listOfUnderstoodTestNodes = new ArrayList();
    boolean _enforceRootConditionType = false;
    ConditionalRelationType _rootConditionalRelationType = null;
    List _filterNodesToRemove = new ArrayList();

    public FilterItemSimpleTree(FilterItem filter, FilterItemListInterface filterItemList, boolean enforceAsAllSameType, FilterObjectFactoryInterface filterObjectFactory) {
        this._enforceRootConditionType = enforceAsAllSameType;
        this._rootFilterItem = filter;
        this._filterItemList = filterItemList;
        this._filterObjectFactory = filterObjectFactory;
        if (this._rootFilterItem != null) {
            if (this._rootFilterItem instanceof CompoundFilter) {
                CompoundFilter cf = (CompoundFilter)this._rootFilterItem;
                this._rootConditionalRelationType = cf.getRelationType();
            }
            this._rootSimpleTree = new SimpleTreeNode(this._rootFilterItem, this._filterItemList);
        }
        if (this._enforceRootConditionType && this._rootConditionalRelationType == null) {
            this._rootConditionalRelationType = ConditionalRelationType.AND;
        }
    }

    public boolean commitTree() {
        Iterator iter = this._filterNodesToRemove.iterator();
        while (iter.hasNext()) {
            FilterItem item = (FilterItem)iter.next();
            this._filterObjectFactory.removeFilterItem(item);
            iter.remove();
        }
        if (this._rootSimpleTree != null) {
            return this._rootSimpleTree.commitNode();
        }
        return true;
    }

    public FilterItem getRootFilterItem() {
        if (this._rootSimpleTree == null) {
            return null;
        }
        return this._rootSimpleTree._filterItem;
    }

    public void refreshNodeList() {
        this._mapOfTestNodesToTreeNodes.clear();
        this._listOfUnderstoodTestNodes.clear();
        List validSimpleTreeLeafNodes = null;
        if (this._rootSimpleTree != null) {
            validSimpleTreeLeafNodes = this._rootSimpleTree.listUnderstoodLeafNodes();
        }
        if (validSimpleTreeLeafNodes == null) {
            return;
        }
        for (SimpleTreeNode treeNode : validSimpleTreeLeafNodes) {
            this._listOfUnderstoodTestNodes.add(treeNode._testNode);
            this._mapOfTestNodesToTreeNodes.put(treeNode._testNode, treeNode);
        }
    }

    public List getUnderstoodTestNodeList() {
        return this._listOfUnderstoodTestNodes;
    }

    public FilterItemInterface findMatchingFilterItem(Object itemObject) {
        return this._filterObjectFactory.findMatchingFilterItem(this._filterItemList, itemObject);
    }

    public boolean areAllNodesUnderstood() {
        if (this._rootSimpleTree == null) {
            return true;
        }
        return this._rootSimpleTree.areAllNodesUnderstood();
    }

    public Object setLeafAt(int index, FilterLogicTestNodeInterface testNode) {
        Object oldTestNode = this._listOfUnderstoodTestNodes.get(index);
        SimpleTreeNode treeNode = (SimpleTreeNode)this._mapOfTestNodesToTreeNodes.get(oldTestNode);
        treeNode.updateNode(testNode);
        this._listOfUnderstoodTestNodes.set(index, testNode);
        this._mapOfTestNodesToTreeNodes.remove(oldTestNode);
        this._mapOfTestNodesToTreeNodes.put(testNode, treeNode);
        return oldTestNode;
    }

    public Object removeLeafAt(int index) {
        Object oldTestNode = this._listOfUnderstoodTestNodes.get(index);
        SimpleTreeNode treeNode = (SimpleTreeNode)this._mapOfTestNodesToTreeNodes.get(oldTestNode);
        this._filterNodesToRemove.add(treeNode._filterItem);
        treeNode.removeNode();
        if (treeNode == this._rootSimpleTree) {
            this._rootSimpleTree = null;
        }
        this._listOfUnderstoodTestNodes.remove(index);
        this._mapOfTestNodesToTreeNodes.remove(oldTestNode);
        return oldTestNode;
    }

    public void addLeafAt(int index, FilterLogicTestNodeInterface testNode) {
        int treeSize = this._listOfUnderstoodTestNodes.size();
        if (index == -1) {
            index = treeSize;
        }
        SimpleTreeNode treeNode = this.newTestTreeNode(testNode);
        if (this._rootSimpleTree == null) {
            this._rootSimpleTree = treeNode;
        } else if (this._rootSimpleTree._isLeaf) {
            this._rootSimpleTree = this.newCompoundTreeNode(this._rootSimpleTree, treeNode);
        } else if (this._rootSimpleTree._left == null && this._rootSimpleTree._right == null) {
            this._rootSimpleTree.updateNode(treeNode, null);
        } else if (this._rootSimpleTree._left == null) {
            this._rootSimpleTree.updateNode(this._rootSimpleTree._right, treeNode);
        } else if (this._rootSimpleTree._right == null) {
            this._rootSimpleTree.updateNode(this._rootSimpleTree._left, treeNode);
        } else if (index == this._listOfUnderstoodTestNodes.size()) {
            this._rootSimpleTree = this.newCompoundTreeNode(this._rootSimpleTree, treeNode);
        } else {
            SimpleTreeNode compoundTreeNode = null;
            SimpleTreeNode nodeToBumpRight = (SimpleTreeNode)this._listOfUnderstoodTestNodes.get(index);
            SimpleTreeNode parentNode = nodeToBumpRight._parent;
            if (parentNode == null) {
                this._rootSimpleTree = compoundTreeNode = this.newCompoundTreeNode(nodeToBumpRight, treeNode);
            } else {
                SimpleTreeNode parentRightNode = parentNode._right;
                SimpleTreeNode parentLeftNode = parentNode._left;
                compoundTreeNode = nodeToBumpRight == parentLeftNode ? this.newCompoundTreeNode(treeNode, parentLeftNode) : this.newCompoundTreeNode(parentLeftNode, treeNode);
                parentNode.updateNode(compoundTreeNode, parentRightNode);
            }
        }
        this._listOfUnderstoodTestNodes.add(index, testNode);
        this._mapOfTestNodesToTreeNodes.put(testNode, treeNode);
    }

    SimpleTreeNode newTestTreeNode(FilterLogicTestNodeInterface testNode) {
        FilterItem filterItem = this._filterObjectFactory.newFilterItem();
        if (filterItem == null) {
            return null;
        }
        SimpleTreeNode treeNode = new SimpleTreeNode(filterItem, this._filterItemList);
        treeNode.updateNode(testNode);
        return treeNode;
    }

    SimpleTreeNode newCompoundTreeNode(SimpleTreeNode left, SimpleTreeNode right) {
        CompoundFilter compoundFilter = this._filterObjectFactory.newCompoundFilter();
        SimpleTreeNode compoundTreeNode = new SimpleTreeNode((FilterItem)compoundFilter, this._filterItemList);
        compoundTreeNode.updateNode(left, right);
        return compoundTreeNode;
    }

    private class SimpleTreeNode {
        public boolean _isDirty = false;
        public boolean _isLeaf = false;
        public boolean _isUnderstood = false;
        public SimpleTreeNode _left = null;
        public SimpleTreeNode _right = null;
        public SimpleTreeNode _parent = null;
        public ExpressionInterface _expression = null;
        public boolean _isCompoundConditional = false;
        public FilterItem _filterItem = null;
        public boolean _isCompoundFilter = false;
        public FilterLogicTestNodeInterface _testNode = null;

        public SimpleTreeNode(FilterItem filter, FilterItemListInterface filterItemList) {
            boolean ok = this.initNode(filter, filterItemList);
        }

        public SimpleTreeNode(ExpressionInterface expression, FilterItemListInterface filterItemList) {
            throw new UnsupportedOperationException("Expression tree editting is not supported");
        }

        boolean initNode(FilterItem filter, FilterItemListInterface filterItemList) {
            boolean ok = false;
            if (filter == null) {
                this._isLeaf = true;
                this._isUnderstood = false;
                ok = false;
            } else if (filter instanceof CompoundFilter) {
                ok = this.initNode((CompoundFilter)filter, filterItemList);
            } else {
                this._filterItem = filter;
                ExpressionInterface expression = filter.getExpression();
                if (expression == null) {
                    this._isLeaf = true;
                    this._isUnderstood = true;
                    ok = true;
                } else {
                    if (expression instanceof CompoundConditionalExpression) {
                        throw new IllegalArgumentException("Compound Conditional Expression not allowed");
                    }
                    ok = this.initNode(expression, filterItemList);
                }
            }
            return ok;
        }

        boolean initNode(CompoundFilter compoundFilter, FilterItemListInterface filterItemList) {
            FilterItem right;
            this._filterItem = compoundFilter;
            this._isCompoundFilter = true;
            ConditionalRelationType condType = compoundFilter.getRelationType();
            boolean isNegated = compoundFilter.isNegated();
            if (isNegated) {
                this._isLeaf = true;
                this._isUnderstood = false;
                return false;
            }
            if (condType != null) {
                if (FilterItemSimpleTree.this._rootConditionalRelationType == null) {
                    FilterItemSimpleTree.this._rootConditionalRelationType = condType;
                } else if (FilterItemSimpleTree.this._enforceRootConditionType && FilterItemSimpleTree.this._rootConditionalRelationType != condType) {
                    throw new IllegalArgumentException("AND/OR disagreement: A Simple FilterLogicList cannot be built from this filter, all conjunctions must be the same");
                }
            }
            this._isLeaf = false;
            FilterItem left = compoundFilter.getLeftFilter();
            if (left != null) {
                this._left = new SimpleTreeNode(left, filterItemList);
                this._left._parent = this;
            }
            if ((right = compoundFilter.getRightFilter()) != null) {
                this._right = new SimpleTreeNode(right, filterItemList);
                this._right._parent = this;
            }
            this._isUnderstood = true;
            return true;
        }

        boolean initNode(ExpressionInterface expression, FilterItemListInterface filterItemList) {
            boolean ok = false;
            if (!(expression instanceof ConditionalExpression)) {
                this._isLeaf = true;
                this._isUnderstood = false;
                ok = false;
            } else {
                ok = this.initNode((ConditionalExpression)expression, filterItemList);
            }
            return ok;
        }

        boolean initNode(ConditionalExpression condExpr, FilterItemListInterface filterItemList) {
            this._expression = condExpr;
            if (condExpr instanceof CompoundConditionalExpression) {
                throw new IllegalArgumentException("Compound Conditional Expression not allowed");
            }
            this._isLeaf = true;
            this._testNode = FilterItemSimpleTree.this._filterObjectFactory.newTestNode(this._filterItem, filterItemList);
            this._isUnderstood = this._testNode != null;
            return this._isUnderstood;
        }

        public void updateNode(FilterLogicTestNodeInterface testNode) {
            this._isDirty = true;
            this._testNode = testNode;
            this._isUnderstood = true;
        }

        public void updateNode(SimpleTreeNode newLeft, SimpleTreeNode newRight) {
            if (!this._isCompoundFilter && !this._isCompoundConditional) {
                throw new UnsupportedOperationException("Cannot change logic tree node from simple to compound");
            }
            this._left = newLeft;
            this._right = newRight;
            newLeft._parent = this;
            newRight._parent = this;
            this._isDirty = true;
            newLeft._isDirty = true;
            newRight._isDirty = true;
            this._isUnderstood = true;
        }

        public void removeNode() {
            SimpleTreeNode parent = this._parent;
            SimpleTreeNode left = this._left;
            SimpleTreeNode right = this._right;
            this._left = null;
            this._right = null;
            this._parent = null;
            this._filterItem = null;
            this._expression = null;
            this._isCompoundFilter = false;
            this._isCompoundConditional = false;
            this._isDirty = true;
            this._isLeaf = true;
            this._isUnderstood = false;
            if (left != null) {
                left.removeNode();
            }
            if (right != null) {
                right.removeNode();
            }
            if (parent != null) {
                if (parent._left == this) {
                    parent._left = null;
                }
                if (parent._right == this) {
                    parent._right = null;
                }
                if (parent._left == null && parent._right == null) {
                    parent.removeNode();
                }
            }
        }

        public boolean commitNode() {
            if (!this._isUnderstood) {
                return true;
            }
            boolean ok = false;
            if (this._testNode != null) {
                ok = this.commitAsSimpleFilterCondition();
            } else if (this._left == null && this._right == null) {
                ok = this.commitAsClearedFilterCondition();
            } else if (this._isCompoundFilter) {
                ok = this.commitAsCompoundFilter();
            } else if (this._isCompoundConditional) {
                ok = this.commitAsCompoundConditionalFilter();
            } else {
                return false;
            }
            return ok;
        }

        boolean commitAsSimpleFilterCondition() {
            boolean ok = FilterItemSimpleTree.this._filterObjectFactory.updateSimpleFilterFromTestNode(this._filterItem, this._testNode);
            if (!ok) {
                return false;
            }
            this._expression = this._filterItem.getExpression();
            this._isLeaf = true;
            this._right = null;
            this._left = null;
            this._isCompoundConditional = false;
            this._isCompoundFilter = false;
            this._isUnderstood = true;
            return true;
        }

        boolean commitAsClearedFilterCondition() {
            if (this._filterItem != null && !FilterItemSimpleTree.this._filterObjectFactory.clearFilterCondition(this._filterItem)) {
                return false;
            }
            this._isLeaf = true;
            this._right = null;
            this._left = null;
            this._isCompoundConditional = false;
            this._isCompoundFilter = false;
            this._isUnderstood = true;
            return true;
        }

        boolean commitAsCompoundFilter() {
            FilterItem rightResult;
            if (this._left != null && !this._left.commitNode()) {
                return false;
            }
            if (this._right != null && !this._right.commitNode()) {
                return false;
            }
            FilterItem leftResult = this._left != null ? this._left._filterItem : null;
            FilterItem filterItem = rightResult = this._right != null ? this._right._filterItem : null;
            if (this._filterItem != null && !FilterItemSimpleTree.this._filterObjectFactory.updateCompoundFilter(this._filterItem, leftResult, rightResult, FilterItemSimpleTree.this._rootConditionalRelationType, false)) {
                return false;
            }
            this._isLeaf = false;
            this._isCompoundConditional = false;
            this._isCompoundFilter = true;
            this._isUnderstood = true;
            return true;
        }

        boolean commitAsCompoundConditionalFilter() {
            return false;
        }

        public List listUnderstoodLeafNodes() {
            ArrayList<SimpleTreeNode> result = new ArrayList<SimpleTreeNode>();
            if (this._isLeaf) {
                if (this._isUnderstood) {
                    result.add(this);
                }
            } else {
                List rightNodes;
                List leftNodes;
                if (this._left != null && (leftNodes = this._left.listUnderstoodLeafNodes()) != null && leftNodes.size() > 0) {
                    result.addAll(leftNodes);
                }
                if (this._right != null && (rightNodes = this._right.listUnderstoodLeafNodes()) != null && rightNodes.size() > 0) {
                    result.addAll(rightNodes);
                }
            }
            return result;
        }

        public boolean areAllNodesUnderstood() {
            if (!this._isUnderstood) {
                return false;
            }
            if (this._left != null && !this._left.areAllNodesUnderstood()) {
                return false;
            }
            return this._right == null || this._right.areAllNodesUnderstood();
        }
    }
}

