/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.filters.AbstractFilterItemSimpleListBase;
import com.sas.dataselectors.filters.FilterItemListInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterObjectFactoryInterface;
import com.sas.dataselectors.filters.SimpleFilterLogicTreeInterface;
import com.sas.dataselectors.filters.tree.LogicTreeToFilterItemTransform;
import com.sas.dataselectors.filters.tree.LogicTreeToStepModelTransform;
import com.sas.dataselectors.filters.tree.OLAPFilterToLogicTreeTransform;
import com.sas.dataselectors.filters.tree.SimpleFilterLogicTree;
import com.sas.dataselectors.filters.tree.SimpleFilterLogicTreeAdapter;
import com.sas.util.transforms.TransformInterface;

public class FilterItemRootToAdvancedList
extends AbstractFilterItemSimpleListBase {
    SimpleFilterLogicTreeInterface _filterLogicTree = null;

    public FilterItemRootToAdvancedList(FilterItemListInterface filterItemList, Object rootFilterItem, boolean enforceAsAllSameType, FilterObjectFactoryInterface filterObjectFactory, boolean useStepModel) {
        super(filterItemList);
        Object outTransform;
        OLAPFilterToLogicTreeTransform inTransform;
        SimpleFilterLogicTree simpleLogic = new SimpleFilterLogicTree();
        if (useStepModel) {
            inTransform = new OLAPFilterToLogicTreeTransform(filterObjectFactory, filterItemList);
            outTransform = new LogicTreeToStepModelTransform(filterObjectFactory);
        } else {
            inTransform = new OLAPFilterToLogicTreeTransform(filterObjectFactory, filterItemList);
            outTransform = new LogicTreeToFilterItemTransform(filterObjectFactory);
        }
        SimpleFilterLogicTreeAdapter tree = new SimpleFilterLogicTreeAdapter(simpleLogic, (TransformInterface)inTransform, (TransformInterface)outTransform);
        tree.setFilterObject(rootFilterItem);
        this.setFilterLogicTree((SimpleFilterLogicTreeInterface)tree);
    }

    public FilterItemRootToAdvancedList(FilterItemListInterface filterItemList, SimpleFilterLogicTreeInterface filterTree) {
        super(filterItemList);
        this.setFilterLogicTree(filterTree);
    }

    public boolean commitChanges() {
        if (this._filterLogicTree != null) {
            return this._filterLogicTree.commitTree();
        }
        return false;
    }

    public Object getRootFilterObject() {
        if (this._filterLogicTree != null) {
            return this._filterLogicTree.getRootFilterItem();
        }
        return null;
    }

    protected Object setTestNodeAt(int index, FilterLogicTestNodeInterface testNode) {
        if (this._filterLogicTree != null) {
            FilterLogicTestNodeInterface result = this._filterLogicTree.setLeafAt(index, testNode);
            this._filterTestNodeList = this._filterLogicTree.getUnderstoodTestNodeList();
            return result;
        }
        return null;
    }

    protected Object removeTestNodeAt(int index) {
        if (this._filterLogicTree != null) {
            FilterLogicTestNodeInterface result = this._filterLogicTree.removeLeafAt(index);
            this._filterTestNodeList = this._filterLogicTree.getUnderstoodTestNodeList();
            return result;
        }
        return null;
    }

    protected void addTestNodeAt(int index, FilterLogicTestNodeInterface testNode) {
        if (this._filterLogicTree != null) {
            this._filterLogicTree.addLeafAt(index, testNode);
            this._filterTestNodeList = this._filterLogicTree.getUnderstoodTestNodeList();
        }
    }

    protected Object getTestNodeAt(int index) {
        return super.getTestNodeAt(index);
    }

    public SimpleFilterLogicTreeInterface getFilterLogicTree() {
        return this._filterLogicTree;
    }

    public SimpleFilterLogicTreeInterface setFilterLogicTree(SimpleFilterLogicTreeInterface newTree) {
        SimpleFilterLogicTreeInterface oldTree = this._filterLogicTree;
        this._filterLogicTree = newTree;
        if (this._filterLogicTree != null) {
            this._filterLogicTree.refreshNodeList();
            if (!this._filterLogicTree.areAllNodesUnderstood()) {
                throw new IllegalArgumentException("Cannot load filter from Data Selection because not all conditions in filter understood");
            }
            this._filterTestNodeList = this._filterLogicTree.getUnderstoodTestNodeList();
        }
        return oldTree;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        if (this._filterLogicTree != null) {
            return this._filterLogicTree.getUnderstoodTestNodeList().size();
        }
        return super.size();
    }

    public void clear() {
        if (this._filterLogicTree != null) {
            this._filterLogicTree.clear();
        }
        this._filterTestNodeList = this._filterLogicTree.getUnderstoodTestNodeList();
    }
}

