/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.filters.AbstractFilterableListModel;
import com.sas.dataselectors.filters.AdvancedFilterModelInterface;
import com.sas.dataselectors.filters.BusinessQueryToAdvancedFilterModelAdapter;
import com.sas.dataselectors.filters.DefaultFilterableItem;
import com.sas.dataselectors.filters.DefaultPersistentFilter;
import com.sas.dataselectors.filters.FilterLogicBaseNodeInterface;
import com.sas.dataselectors.filters.FilterableItemInterface;
import com.sas.dataselectors.filters.SimpleFilterLogicTreeInterface;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.CompoundFilter;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.olap.BaseFilterExpression;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeRangeFilterExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BusinessQueryToFilterableListModelAdapter
extends AbstractFilterableListModel {
    public BusinessQueryToFilterableListModelAdapter() {
    }

    public BusinessQueryToFilterableListModelAdapter(BusinessQuery dataSource) {
        super((Object)dataSource);
    }

    public BusinessQueryToFilterableListModelAdapter(BusinessQuery dataSource, Object initialFilter) {
        super((Object)dataSource, initialFilter);
    }

    public BusinessQueryToFilterableListModelAdapter(BusinessQuery dataSource, int environment) {
        super((Object)dataSource, environment);
    }

    protected List getFilterableObjects() {
        List<Object> filterables = null;
        if (this._dataSource != null && this._dataSource instanceof BusinessQuery) {
            BusinessQuery bq = (BusinessQuery)this._dataSource;
            if (bq.getInputStructure().isOLAP()) {
                filterables = new ArrayList();
                List objects = bq.getResultItems();
                if (objects != null) {
                    for (DataItem item : objects) {
                        if (item.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE || !item.isActionSupported(DataItemActionType.STEP_MEMBER_FILTER)) continue;
                        filterables.add(item);
                    }
                }
            } else {
                filterables = Collections.singletonList(this._dataSource);
            }
        }
        return filterables;
    }

    protected FilterableItemInterface createFilterableItem(Object filterable) {
        DefaultFilterableItem item = null;
        if (filterable instanceof BusinessQuery) {
            BusinessQuery bq = (BusinessQuery)filterable;
            String label = null;
            String description = null;
            BusinessModel bm = bq.getBusinessModel();
            if (bm != null) {
                label = bm.getLabel();
                description = bm.getDescription();
            }
            FilterableItemAdvancedFilterModelAdapter filterModel = new FilterableItemAdvancedFilterModelAdapter(bq);
            item = new DefaultFilterableItem(label, description, (Object)bq, (AdvancedFilterModelInterface)filterModel);
        } else if (filterable instanceof DataItem) {
            DataItem dataItem = (DataItem)filterable;
            String label = dataItem.getLabel();
            String description = dataItem.getDescription();
            FilterableItemAdvancedFilterModelAdapter filterModel = new FilterableItemAdvancedFilterModelAdapter((BusinessQuery)this._dataSource, dataItem, this.environment);
            item = new DefaultFilterableItem(label, description, (Object)dataItem, (AdvancedFilterModelInterface)filterModel);
        }
        return item;
    }

    public boolean commitChanges() {
        List filterables = this.getFilterableItems();
        boolean commitOk = false;
        if (filterables != null && filterables.size() > 0) {
            boolean allCommit = true;
            for (FilterableItemInterface item : filterables) {
                AdvancedFilterModelInterface model = item.getFilterModel();
                if (model instanceof FilterableItemAdvancedFilterModelAdapter) {
                    FilterableItemAdvancedFilterModelAdapter adapter = (FilterableItemAdvancedFilterModelAdapter)model;
                    if (adapter.fullCommit()) continue;
                    allCommit = false;
                    continue;
                }
                if (model.commitChanges()) continue;
                allCommit = false;
            }
            commitOk = allCommit;
        }
        return commitOk;
    }

    public void cancel() {
        List filterables = this.getFilterableItems();
        if (filterables != null && filterables.size() > 0) {
            for (FilterableItemInterface item : filterables) {
                AdvancedFilterModelInterface model = item.getFilterModel();
                if (model instanceof FilterableItemAdvancedFilterModelAdapter) {
                    FilterableItemAdvancedFilterModelAdapter adapter = (FilterableItemAdvancedFilterModelAdapter)model;
                    adapter.fullCancel();
                    continue;
                }
                model.cancel();
            }
        }
    }

    public void clearFilter(int index) {
        super.clearFilter(index);
    }

    private class FilterableItemAdvancedFilterModelAdapter
    extends BusinessQueryToAdvancedFilterModelAdapter {
        SimpleFilterLogicTreeInterface _savedTree;

        public FilterableItemAdvancedFilterModelAdapter(BusinessQuery businessQuery) {
            super(businessQuery);
            this._savedTree = null;
            this._saveTree();
        }

        public FilterableItemAdvancedFilterModelAdapter(BusinessQuery businessQuery, int environment) {
            super(businessQuery, environment);
            this._savedTree = null;
            this._saveTree();
        }

        public FilterableItemAdvancedFilterModelAdapter(BusinessQuery businessQuery, DataItem olapDataItem) {
            super(businessQuery, (Object)olapDataItem);
            this._savedTree = null;
            this._saveTree();
        }

        public FilterableItemAdvancedFilterModelAdapter(BusinessQuery businessQuery, DataItem olapDataItem, int environment) {
            super(businessQuery, (Object)olapDataItem, environment);
            this._savedTree = null;
            this._saveTree();
        }

        private void _saveTree() {
            this._savedTree = this._logicTree != null ? this._logicTree.copy(true) : null;
        }

        private FilterLogicBaseNodeInterface _getRootCopy() {
            if (this._savedTree == null) {
                return null;
            }
            SimpleFilterLogicTreeInterface copy = this._savedTree.copy(true);
            return copy.getRoot();
        }

        @Override
        public void cancel() {
            this._logicTree.setRoot(this._getRootCopy());
            this._logicTree.refreshNodeList();
        }

        @Override
        public boolean commitChanges() {
            this._saveTree();
            return true;
        }

        @Override
        public void clear(boolean commit) {
            super.clear(commit);
            this._saveTree();
        }

        public boolean fullCommit() {
            return super.commitChanges();
        }

        public void fullCancel() {
            super.cancel();
        }

        @Override
        public List getPersistentFilterList() {
            ArrayList<DefaultPersistentFilter> filters = null;
            if (this._businessModel != null) {
                filters = new ArrayList<DefaultPersistentFilter>();
                int flags = 0;
                if (this._businessQuery != null) {
                    flags |= 1;
                }
                List sourceList = this._businessModel.getObjects(flags, FilterItem.class);
                for (FilterItem item : sourceList) {
                    if (!this.canImportFilter(item)) continue;
                    String label = item.getLabel();
                    String desc = item.getDescription();
                    filters.add(new DefaultPersistentFilter((Object)item, label, desc));
                }
            }
            return filters;
        }

        private boolean canImportFilter(FilterItem item) {
            ExpressionInterface exp;
            if (!item.isHidden() && item.isUsableInQuery() && !(item instanceof CompoundFilter) && ((exp = item.getExpression()) instanceof MemberFilterExpression || exp instanceof TimeFilterExpression || exp instanceof TimeRangeFilterExpression)) {
                ExpressionInterface what = ((BaseFilterExpression)exp).getWhatToCompare();
                if (what == this._initialFilterObject || what.equals(this._initialFilterObject)) {
                    return true;
                }
                if (this._initialFilterObject instanceof DataItem && what instanceof DataItem) {
                    ExpressionInterface exp2;
                    DataItem di1 = (DataItem)what;
                    DataItem di2 = (DataItem)this._initialFilterObject;
                    ExpressionInterface exp1 = di1.getExpression();
                    if (exp1 == (exp2 = di2.getExpression()) || exp1.equals(exp2)) {
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

