/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.filters.AbstractFilterItemListBase;
import com.sas.dataselectors.filters.BaseFilterObjectFactory;
import com.sas.dataselectors.filters.FilterObjectFactoryInterface;
import com.sas.iquery.dataservices.IQDataServices;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import java.util.List;
import java.util.Map;

public class BusinessQueryToFilterItemListAdapter
extends AbstractFilterItemListBase {
    BusinessQuery _businessQuery = null;
    IQDataServices _dataService = null;
    FilterObjectFactoryInterface _filterObjectFactory = null;
    boolean _initComplete = false;

    public BusinessQueryToFilterItemListAdapter(FilterObjectFactoryInterface filterObjectFactory, BusinessQuery businessQuery) {
        IQDataServices iqDataService = this.initDataService(businessQuery);
        this.init(filterObjectFactory, businessQuery, iqDataService);
    }

    public BusinessQueryToFilterItemListAdapter(FilterObjectFactoryInterface filterObjectFactory, BusinessQuery businessQuery, IQDataServices dataService) {
        this.init(filterObjectFactory, businessQuery, dataService);
    }

    private void init(FilterObjectFactoryInterface filterObjectFactory, BusinessQuery businessQuery, IQDataServices dataService) {
        this._filterObjectFactory = filterObjectFactory;
        this.setDataService(dataService);
        this.setBusinessQuery(businessQuery);
        this._initComplete = true;
        this.refresh();
    }

    protected IQDataServices initDataService(BusinessQuery businessQuery) {
        IQDataServices iqDataService = null;
        BusinessModel businessModel = null;
        if (businessQuery != null) {
            businessModel = businessQuery.getBusinessModel();
        }
        iqDataService = BaseFilterObjectFactory.initDataService(businessModel);
        return iqDataService;
    }

    public BusinessQuery getBusinessQuery() {
        return this._businessQuery;
    }

    public void setBusinessQuery(BusinessQuery businessQuery) {
        this._businessQuery = businessQuery;
        this.refresh();
    }

    public IQDataServices getDataService() {
        return this._dataService;
    }

    public void setDataService(IQDataServices dataService) {
        this._dataService = dataService;
        this.refresh();
    }

    public void refresh() {
        if (!this._initComplete) {
            return;
        }
        Map mapOfItems = this.getFilterItemLookupMap();
        List listOfItems = this._filterObjectFactory.getFilterableItems(true, mapOfItems);
        this.setFilterItemLookupMap(mapOfItems);
        this.setFilterItemList(listOfItems);
    }
}

