/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.filters.BaseAdvancedFilterObjectFactory;
import com.sas.dataselectors.filters.DefaultAdvancedFilterModelAdapter;
import com.sas.dataselectors.filters.FilterException;
import com.sas.dataselectors.filters.FilterItemInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterValueInterface;
import com.sas.dataselectors.filters.timebased.RelativeTimeFilterData;
import com.sas.iquery.dataservices.DataServicesException;
import com.sas.iquery.dataservices.IQDataServices;
import com.sas.iquery.dataservices.IQDataServicesFactory;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.storage.iquery.BusinessQueryAdapter;
import com.sas.swing.dataselectors.editors.FilterItemEditorInterface;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class BusinessQueryToAdvancedFilterModelAdapter
extends DefaultAdvancedFilterModelAdapter {
    private static final boolean DEBUG = false;

    public BusinessQueryToAdvancedFilterModelAdapter() {
        this((BusinessQuery)null);
    }

    public BusinessQueryToAdvancedFilterModelAdapter(BusinessQuery businessQuery) {
        this(businessQuery, null);
    }

    public BusinessQueryToAdvancedFilterModelAdapter(BusinessQuery businessQuery, int environment) {
        this(businessQuery, null, environment);
    }

    public BusinessQueryToAdvancedFilterModelAdapter(BusinessQuery businessQuery, Object initialFilter) {
        this(businessQuery, initialFilter, null);
    }

    public BusinessQueryToAdvancedFilterModelAdapter(BusinessQuery businessQuery, Object initialFilter, Locale locale) {
        super(businessQuery, initialFilter, locale);
    }

    public BusinessQueryToAdvancedFilterModelAdapter(BusinessQuery businessQuery, Object initialFilter, int environment) {
        super(businessQuery, initialFilter, environment);
    }

    public BusinessQueryToAdvancedFilterModelAdapter(BusinessQueryAdapter adapter) {
        this(adapter.getModel());
    }

    public BusinessQueryToAdvancedFilterModelAdapter(BusinessQueryProviderInterface bqProvider) {
        this(bqProvider.getBusinessQuery());
    }

    @Override
    protected String getFilterQualifierSkipID(Object nativeItem) throws FilterException {
        String itemID = null;
        if (nativeItem instanceof DataItem) {
            DataItem dataItem = (DataItem)nativeItem;
            try {
                itemID = dataItem.getID();
            }
            catch (Exception e) {
                throw new FilterException((Throwable)e);
            }
        }
        return itemID;
    }

    @Override
    public Object getRootFilterObject() {
        Object filterObject = super.getRootFilterObject();
        if (filterObject instanceof FilterItem) {
            ((FilterItem)filterObject).setIsHidden(true);
        }
        return filterObject;
    }

    @Override
    public boolean isValidFilter(FilterLogicTestNodeInterface testNode) throws FilterException {
        boolean isValid;
        if (!this.isOLAP()) {
            isValid = super.isValidFilter(testNode);
        } else {
            isValid = false;
            if (testNode != null) {
                StepInterface newStep = ((BaseAdvancedFilterObjectFactory)this._filterObjectFactory).newFilterStep(testNode);
                this._filterObjectFactory.updateSimpleFilterFromTestNode(newStep, testNode);
                if (newStep != null) {
                    DataItem baseDataItem = this.getSourceDataItem();
                    List oldSteps = baseDataItem.getSteps();
                    try {
                        baseDataItem.setSteps(Collections.singletonList(newStep));
                        IQDataServices dataService = IQDataServicesFactory.newService();
                        dataService.verify((BusinessItem)baseDataItem);
                        isValid = true;
                    }
                    catch (DataServicesException dse) {
                        throw new FilterException((Throwable)dse);
                    }
                    catch (MetadataException me) {
                        throw new FilterException((Throwable)me);
                    }
                    finally {
                        try {
                            baseDataItem.setSteps(oldSteps);
                        }
                        catch (MetadataException metadataException) {}
                    }
                }
            }
        }
        return isValid;
    }

    private DataItem getSourceDataItem() {
        FilterItemInterface baseItem = (FilterItemInterface)this.getDataSource().getFilterItemList().get(0);
        DataItem item = baseItem.getItem() instanceof DataItem ? (DataItem)baseItem.getItem() : null;
        return item;
    }

    @Override
    protected boolean isFilterImportable(List testNodeList) {
        for (FilterLogicTestNodeInterface element : testNodeList) {
            Object condObj;
            long type = element.getFilterItem().getItemType();
            if (type == 4L || type == 6L || type == 4L) {
                List values = element.getTestValuesList();
                if (values == null) continue;
                for (Object o : values) {
                    if (o instanceof FilterValueInterface) {
                        o = ((FilterValueInterface)o).getUnformattedValue();
                    }
                    if (!(o instanceof RelativeTimeFilterData)) continue;
                    return false;
                }
                continue;
            }
            if (element.getCondition() == null || (condObj = element.getCondition().getCondition()) != FilterItemEditorInterface.class) continue;
            return false;
        }
        return super.isFilterImportable(testNodeList);
    }
}

