/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.filters.AbstractSimpleLogicListAdapterBase;
import com.sas.dataselectors.filters.BusinessQueryFilterObjectFactory;
import com.sas.dataselectors.filters.BusinessQueryToFilterItemListAdapter;
import com.sas.dataselectors.filters.DefaultFilterItemList;
import com.sas.dataselectors.filters.FilterBaseModelData;
import com.sas.dataselectors.filters.FilterItemRootToSimpleList;
import com.sas.dataselectors.filters.FilterObjectFactoryInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.FilterItem;
import java.util.ArrayList;
import java.util.List;

public class BusinessQueryFilterItemToSimpleLogicListAdapter
extends AbstractSimpleLogicListAdapterBase {
    protected BusinessQuery _businessQuery = null;
    protected FilterObjectFactoryInterface _filterObjectFactory = null;

    public BusinessQueryFilterItemToSimpleLogicListAdapter(BusinessQuery businessQuery, FilterBaseModelData baseModel) {
        this(new BusinessQueryFilterObjectFactory(businessQuery, baseModel), businessQuery);
    }

    public BusinessQueryFilterItemToSimpleLogicListAdapter(FilterObjectFactoryInterface filterObjectFactory, BusinessQuery businessQuery) {
        this._filterObjectFactory = filterObjectFactory;
        this._businessQuery = businessQuery;
        this.readFilterList();
    }

    public BusinessQueryFilterItemToSimpleLogicListAdapter() {
    }

    void readFilterList() {
        if (this._businessQuery == null) {
            this._filterItemList = new DefaultFilterItemList();
            return;
        }
        this._filterItemList = new BusinessQueryToFilterItemListAdapter(this._filterObjectFactory, this._businessQuery);
        List filters = this._businessQuery.getFilters();
        FilterItem rootFilterItem = null;
        if (filters != null && filters.size() > 0 && filters.get(0) instanceof FilterItem) {
            rootFilterItem = (FilterItem)filters.get(0);
        }
        if (rootFilterItem != null) {
            super.setFilterListLabel(rootFilterItem.getLabel());
            super.setFilterListDescription(rootFilterItem.getDescription());
        }
        this._filterItemSimpleList = new FilterItemRootToSimpleList(rootFilterItem, this._filterItemList, true, this._filterObjectFactory);
    }

    public boolean commitChanges() {
        if (this._businessQuery == null) {
            return false;
        }
        ArrayList<FilterItem> filters = this._businessQuery.getFilters();
        if (filters == null) {
            filters = new ArrayList<FilterItem>();
        }
        FilterItem newRootFilter = null;
        if (this._filterItemSimpleList != null) {
            Object obj;
            if (!this._filterItemSimpleList.commitChanges()) {
                return false;
            }
            StructureOfData sod = this._businessQuery.getInputStructure();
            if (sod != null && sod.isRelational() && (obj = this._filterItemSimpleList.getRootFilterObject()) != null) {
                if (obj instanceof FilterItem) {
                    newRootFilter = (FilterItem)obj;
                } else if (filters.size() > 0 && filters.get(0) instanceof FilterItem) {
                    newRootFilter = (FilterItem)filters.get(0);
                }
            }
        }
        if (filters.size() == 0) {
            filters.add(newRootFilter);
        } else {
            filters.set(0, newRootFilter);
        }
        try {
            this._businessQuery.setFilters(filters);
            return true;
        }
        catch (MetadataException metadataException) {
            return false;
        }
    }

    public BusinessQuery getBusinessQuery() {
        return this._businessQuery;
    }

    public FilterObjectFactoryInterface getFilterObjectFactory() {
        return this._filterObjectFactory;
    }

    public void setBusinessQuery(BusinessQuery businessQuery) {
        this._businessQuery = businessQuery;
    }

    public void setFilterObjectFactory(FilterObjectFactoryInterface filterObjectFactory) {
        this._filterObjectFactory = filterObjectFactory;
    }
}

