/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.filters.DefaultAdvancedFilterModelAdapter;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.MapFolder;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;

public class BusinessModelToAdvancedFilterModelAdapter
extends DefaultAdvancedFilterModelAdapter {
    private CommonLoggerInterface log = null;

    public BusinessModelToAdvancedFilterModelAdapter() {
        this(null, null);
    }

    public BusinessModelToAdvancedFilterModelAdapter(BusinessModel businessModel) {
        this(businessModel, null);
    }

    public BusinessModelToAdvancedFilterModelAdapter(BusinessModel businessModel, FilterItem initialFilter) {
        super(businessModel, (Object)initialFilter);
        ServicesLogFactory f = new ServicesLogFactory(businessModel.getSession());
        this.log = LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), (LoggerFactoryInterface)f);
        this.log.debug("BusinessModel & FilterItem Constructor");
        if (initialFilter == null) {
            this.setSelectionCursor(-1);
        } else if (this.getSelectionCount() == 1) {
            this.setSelectionCursor(0);
        }
    }

    @Override
    protected void applyFilterLabel() {
        Object rootFilter = this.getRootFilterObject();
        if (rootFilter != null && rootFilter instanceof BusinessModelObject) {
            try {
                BusinessModelObject bmObj = (BusinessModelObject)rootFilter;
                bmObj.setLabel(this._filterLabel);
                if (this._newFilter) {
                    String id = this._businessModel.generateIntraModelID(this._filterLabel);
                    bmObj.setIntraModelID(id);
                    this.log.debug("InraModelID=", bmObj.getIntraModelID());
                }
            }
            catch (MetadataException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public boolean commitChanges() {
        boolean success = false;
        MapFolder oldFolder = null;
        try {
            Object newObject;
            if (this._initialFilterObject instanceof FilterItem) {
                oldFolder = ((InformationMap)((FilterItem)this._initialFilterObject).getBusinessModel()).getMapFolderContaining((BusinessItem)((FilterItem)this._initialFilterObject));
            }
            if ((success = super.commitChanges()) && (newObject = this.getRootFilterObject()) != this._initialFilterObject && newObject instanceof BusinessItem) {
                BusinessItem bmNew = (BusinessItem)newObject;
                MapFolder newFolder = ((InformationMap)bmNew.getBusinessModel()).getMapFolderContaining(bmNew);
                if (oldFolder != null && !oldFolder.equals(newFolder)) {
                    oldFolder.addBusinessItem(bmNew);
                }
            }
        }
        catch (MetadataException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return success;
    }
}

