/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.filters.DataRetrievalError;
import com.sas.dataselectors.filters.DateAndTimeUtil;
import com.sas.dataselectors.filters.DefaultFilterCondition;
import com.sas.dataselectors.filters.DefaultFilterConditionList;
import com.sas.dataselectors.filters.DefaultFilterItem;
import com.sas.dataselectors.filters.DefaultFilterLogicTestNode;
import com.sas.dataselectors.filters.DefaultFilterQualifier;
import com.sas.dataselectors.filters.DefaultFilterQualifierList;
import com.sas.dataselectors.filters.DefaultFilterValue;
import com.sas.dataselectors.filters.FilterBaseModelData;
import com.sas.dataselectors.filters.FilterConditionInterface;
import com.sas.dataselectors.filters.FilterConditionListInterface;
import com.sas.dataselectors.filters.FilterException;
import com.sas.dataselectors.filters.FilterItemInterface;
import com.sas.dataselectors.filters.FilterItemListInterface;
import com.sas.dataselectors.filters.FilterItemLookupInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterObjectFactoryInterface;
import com.sas.dataselectors.filters.FilterQualifierInterface;
import com.sas.dataselectors.filters.FilterQualifierListInterface;
import com.sas.dataselectors.filters.FilterValueFormatProvider;
import com.sas.dataselectors.filters.FilterValueInterface;
import com.sas.dataselectors.filters.FilterValuesInterface;
import com.sas.dataselectors.filters.MemberPropertyQualifierData;
import com.sas.dataselectors.filters.RB;
import com.sas.dataselectors.filters.SystemVariable;
import com.sas.dataselectors.filters.timebased.IQRelativeTimeFilterUtil;
import com.sas.dataselectors.filters.timebased.RelativeTimeFilterData;
import com.sas.dataselectors.filters.timebased.RelativeTimeFilterValueFormatter;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeBasedFilterAdapter;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeBasedFilterAdapterInterface;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeFilterUtil;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataservices.DataServicesException;
import com.sas.iquery.dataservices.IQDataServices;
import com.sas.iquery.dataservices.IQDataServicesFactory;
import com.sas.iquery.dataservices.PossibleFilterValue;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.CompoundFilter;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Governing;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.LookupValue;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.RootDataItem;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.step.CompoundStep;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.BaseFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberPropertiesFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemRankFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeRangeFilter;
import com.sas.iquery.metadata.expr.AbstractTimeValueExpression;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.DateValueExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.TimeValueExpression;
import com.sas.iquery.metadata.expr.TimestampValueExpression;
import com.sas.iquery.metadata.expr.olap.DataBasedFilterExpression;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeRangeFilterExpression;
import com.sas.iquery.metadata.expr.relational.AbstractRelativeTimeValueExpression;
import com.sas.iquery.metadata.expr.relational.DataItemFormattingExpression;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Between;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Contains;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_In;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Like;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_TestForNull;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.Member;
import com.sas.iquery.metadata.physical.OlapItem;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.storage.iquery.IQUeryUtil;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PropertyInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.valueprovider.ValueProviderUtil;
import com.sas.swing.dataselectors.editors.FilterItemEditorInterface;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import com.sas.util.ListFactory;
import com.sas.util.UncheckedException;
import com.sas.util.ValueItem;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.rmi.RemoteException;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.tree.DefaultMutableTreeNode;

public class BaseFilterObjectFactory
implements FilterObjectFactoryInterface {
    public static final int DEFAULT_GOVERNING_LIMIT = 10000;
    protected BusinessModel _businessModel = null;
    protected IQDataServices _dataService = null;
    protected ResourceScope _scope = ResourceScope.BUSINESS_SCOPE;
    int _governingLimit = 10000;
    Locale _locale = null;
    DateAndTimeUtil _dateAndTimeUtil;
    private CommonLoggerInterface log = null;
    protected int environment = 0;
    protected FilterBaseModelData _baseModel;
    public static final ResourceScope DEFAULT_SCOPE = ResourceScope.BUSINESS_SCOPE;
    private static StringExpressionUtil _stringExpressionUtil = StringExpressionUtil.getInstance();
    private FilterItemInterface templateQualifierItem = null;
    public static final String RB_KEY2 = "DefaultFilterCondition.";
    public static final String RB_KEY = "BaseFilterObjectFactory.";
    public FilterConditionInterface IS_EQUALS = DefaultFilterCondition.getConditionFromRB((String)"DefaultFilterCondition.IS_EQUALS", (Object)ComparisonOperator.COMPARE_EQ, (boolean)false);
    public FilterConditionInterface IS_NOT_EQUALS = DefaultFilterCondition.getConditionFromRB((String)"DefaultFilterCondition.IS_NOT_EQUALS", (Object)ComparisonOperator.COMPARE_NEQ, (boolean)false);
    public FilterConditionInterface IS_IN_LIST = DefaultFilterCondition.getConditionFromRB((String)"DefaultFilterCondition.IS_IN_LIST", SimpleConditionalExpression_In.class, (boolean)false);
    public FilterConditionInterface IS_NOT_IN_LIST = DefaultFilterCondition.getConditionFromRB((String)"DefaultFilterCondition.IS_NOT_IN_LIST", SimpleConditionalExpression_In.class, (boolean)true);
    public FilterConditionInterface IS_LESS_THAN = DefaultFilterCondition.getConditionFromRB((String)"DefaultFilterCondition.IS_LESS_THAN", (Object)ComparisonOperator.COMPARE_LT, (boolean)false);
    public FilterConditionInterface IS_LESS_THAN_OR_EQUAL = DefaultFilterCondition.getConditionFromRB((String)"DefaultFilterCondition.IS_LESS_THAN_OR_EQUAL", (Object)ComparisonOperator.COMPARE_LE, (boolean)false);
    public FilterConditionInterface IS_GREATER_THAN = DefaultFilterCondition.getConditionFromRB((String)"DefaultFilterCondition.IS_GREATER_THAN", (Object)ComparisonOperator.COMPARE_GT, (boolean)false);
    public FilterConditionInterface IS_GREATER_THAN_OR_EQUAL = DefaultFilterCondition.getConditionFromRB((String)"DefaultFilterCondition.IS_GREATER_THAN_OR_EQUAL", (Object)ComparisonOperator.COMPARE_GE, (boolean)false);
    public FilterConditionInterface IS_BETWEEN = DefaultFilterCondition.getConditionFromRB((String)"DefaultFilterCondition.IS_BETWEEN", SimpleConditionalExpression_Between.class, (boolean)false);
    public FilterConditionInterface IS_NOT_BETWEEN = DefaultFilterCondition.getConditionFromRB((String)"DefaultFilterCondition.IS_NOT_BETWEEN", SimpleConditionalExpression_Between.class, (boolean)true);
    public FilterConditionInterface IS_NULL = DefaultFilterCondition.getConditionFromRB((String)"DefaultFilterCondition.IS_NULL", SimpleConditionalExpression_TestForNull.class, (boolean)false);
    public FilterConditionInterface IS_NOT_NULL = DefaultFilterCondition.getConditionFromRB((String)"DefaultFilterCondition.IS_NOT_NULL", SimpleConditionalExpression_TestForNull.class, (boolean)true);
    public FilterConditionInterface CODE_BLOCK = DefaultFilterCondition.getConditionFromRB((String)"DefaultFilterCondition.CODE_BLOCK", FilterItemEditorInterface.class, (boolean)false);
    public FilterConditionInterface IS_BEFORE = DefaultFilterCondition.getConditionFromRB((String)"DefaultFilterCondition.IS_BEFORE", (Object)ComparisonOperator.COMPARE_LT, (boolean)false);
    public FilterConditionInterface IS_BEFORE_OR_EQUAL = DefaultFilterCondition.getConditionFromRB((String)"DefaultFilterCondition.IS_BEFORE_OR_EQUAL", (Object)ComparisonOperator.COMPARE_LE, (boolean)false);
    public FilterConditionInterface IS_AFTER = DefaultFilterCondition.getConditionFromRB((String)"DefaultFilterCondition.IS_AFTER", (Object)ComparisonOperator.COMPARE_GT, (boolean)false);
    public FilterConditionInterface IS_AFTER_OR_EQUAL = DefaultFilterCondition.getConditionFromRB((String)"DefaultFilterCondition.IS_AFTER_OR_EQUAL", (Object)ComparisonOperator.COMPARE_GE, (boolean)false);

    public BaseFilterObjectFactory(FilterBaseModelData baseModel, ResourceScope scope) {
        this._baseModel = baseModel;
        this._scope = scope;
        this._dateAndTimeUtil = new DateAndTimeUtil();
        if (baseModel != null && baseModel.model instanceof BusinessModel) {
            this._businessModel = (BusinessModel)baseModel.model;
            ServicesLogFactory f = new ServicesLogFactory(this._businessModel.getSession());
            this.log = LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)f);
            this._dataService = BaseFilterObjectFactory.initDataService(this._businessModel);
        }
        if (this.log == null) {
            this.log = LoggerRepository2.getLogger((String)this.getClass().getName(), null);
        }
    }

    @Override
    public boolean enforceBooleanPrecedence() {
        if (this._businessModel != null) {
            return !this._businessModel.getStructure().isOLAP();
        }
        return false;
    }

    protected boolean isOLAP() {
        if (this._businessModel != null) {
            return this._businessModel.getStructure().isOLAP();
        }
        return false;
    }

    ResourceScope getResourceScope() {
        return this._scope;
    }

    void setResourceScope(ResourceScope scope) {
        this._scope = scope;
    }

    static String getExpressionUtilText(ExpressionInterface expression) {
        String text;
        if (expression instanceof AbstractTimeValueExpression) {
            text = expression.toString();
        } else {
            try {
                text = expression instanceof ResourceAwareStringExpression ? _stringExpressionUtil.getText(expression, ResourceScope.BUSINESS_SCOPE, null) : _stringExpressionUtil.getReadableText(expression);
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)BaseFilterObjectFactory.class.getName(), null).error("_DEBUG_:Unable to generate expression text!", (Throwable)e);
                text = null;
            }
        }
        return text;
    }

    ExpressionInterface newExpressionUtilExpression(String text, int type) {
        ExpressionInterface expression = null;
        try {
            expression = _stringExpressionUtil.newExpression(this._businessModel, text, type, this.getResourceScope());
        }
        catch (MetadataException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return expression;
    }

    public static IQDataServices initDataService(BusinessModel businessModel) {
        IntelligentQueryMetadataServiceInterface iqueryMetadataService = null;
        if (businessModel != null) {
            iqueryMetadataService = businessModel.getMetadataService();
        }
        if (iqueryMetadataService == null) {
            try {
                iqueryMetadataService = IntelligentQueryMetadataServiceFactory.newService();
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)BaseFilterObjectFactory.class.getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        IQDataServices iqDataService = null;
        try {
            iqDataService = IQDataServicesFactory.newService();
            if (iqueryMetadataService != null) {
                iqDataService.setService(iqueryMetadataService);
            }
        }
        catch (DataServicesException e) {
            LoggerRepository2.getLogger((String)BaseFilterObjectFactory.class.getName(), null).error(e.getMessage(), (Throwable)e);
        }
        return iqDataService;
    }

    public List getDataItems(boolean includeBaseModels) {
        List items = this._businessModel.getObjects(includeBaseModels ? 1 : 0, DataItem.class);
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            DataItem item = (DataItem)iter.next();
            if (item.isUsableInQuery()) continue;
            iter.remove();
        }
        return items;
    }

    @Override
    public FilterItem newFilterItem() {
        FilterItem filterItem = null;
        try {
            filterItem = this._businessModel.newFilterItem();
            filterItem.setIsHidden(true);
        }
        catch (MetadataException me) {
            throw new RuntimeException(me.getMessage());
        }
        return filterItem;
    }

    @Override
    public StepInterface newFilterStep(FilterLogicTestNodeInterface testNode) {
        Object stepItem = null;
        if (testNode != null) {
            List qualifiers = testNode.getFilterItemQualifiers();
            if (qualifiers != null && qualifiers.size() > 0) {
                stepItem = ((FilterQualifierInterface)qualifiers.get(0)).getQualifier() instanceof MemberPropertyQualifierData ? new DataItemMemberPropertiesFilter() : new DataItemDataBasedFilter();
            } else {
                if (OLAPTimeFilterUtil.isOLAPRelativeTimeCondition(testNode)) {
                    stepItem = this.getTimeFilter(testNode);
                }
                if (stepItem == null) {
                    stepItem = new DataItemMemberFilter();
                    ((DataItemMemberFilter)stepItem).setMemberFilterType(0);
                }
            }
            if (stepItem instanceof BaseFilter) {
                ((BaseFilter)stepItem).setActionType(0);
            }
        }
        return stepItem;
    }

    private StepInterface getTimeFilter(FilterLogicTestNodeInterface testNode) {
        Object item;
        StepInterface step = null;
        if (testNode != null && (item = testNode.getFilterItem().getItem()) instanceof DataItem) {
            List steps = ((DataItem)item).getSteps();
            Iterator iterator = steps.iterator();
            StepInterface currentStep = null;
            while (iterator.hasNext()) {
                currentStep = (StepInterface)iterator.next();
                if (!(currentStep instanceof DataItemTimeFilter) && !(currentStep instanceof DataItemTimeRangeFilter)) continue;
                step = currentStep;
                break;
            }
        }
        return step;
    }

    @Override
    public CompoundFilter newCompoundFilter() {
        CompoundFilter compoundFilter = null;
        try {
            compoundFilter = this._businessModel.newCompoundFilter();
            compoundFilter.setIsHidden(true);
        }
        catch (MetadataException me) {
            throw new RuntimeException(me.getMessage());
        }
        return compoundFilter;
    }

    @Override
    public CompoundStep newCompoundStep() {
        CompoundStep step = new CompoundStep();
        return step;
    }

    @Override
    public void removeFilterItem(Object filterItem) {
        try {
            List list = this._businessModel.removeBusinessItem((BusinessItem)filterItem);
        }
        catch (MetadataException me) {
            this.log.error("_DEBUG_:Unable to remove BusinessItem!", (Throwable)me);
            throw new RuntimeException(me.getMessage());
        }
    }

    public void addFilterItem(FilterItem filterItem) {
        try {
            this._businessModel.addBusinessItem((BusinessItem)filterItem);
        }
        catch (MetadataException me) {
            throw new RuntimeException(me.getMessage());
        }
    }

    public ServerProperties getServerProperties() {
        ServerProperties serverProperties = null;
        try {
            if (this._businessModel != null) {
                serverProperties = this._businessModel.getServerProperties();
            }
        }
        catch (MetadataException e) {
            throw new UncheckedException((Throwable)e, null);
        }
        return serverProperties;
    }

    static ExpressionInterface newConstantExpression(int expressionType) {
        return BaseFilterObjectFactory.newConstantExpression("", expressionType);
    }

    public static ConstantExpression newConstantExpression(String value, int type) {
        ConstantExpression expression = new ConstantExpression();
        expression.setValue(value);
        expression.setExpressionType(type);
        return expression;
    }

    public static StringExpression newStringExpression(String text) {
        return BaseFilterObjectFactory.newStringExpression(text, 3);
    }

    public static StringExpression newStringExpression(String text, int type) {
        StringExpression expression = new StringExpression();
        expression.setText(text);
        expression.setExpressionType(type);
        return expression;
    }

    @Override
    public boolean updateSimpleFilterFromTestNode(Object filterItemObject, FilterLogicTestNodeInterface testNode) {
        if (filterItemObject instanceof FilterItem) {
            return this.updateSimpleFilterFromTestNode((FilterItem)filterItemObject, testNode);
        }
        if (filterItemObject instanceof StepInterface) {
            return this.updateSimpleFilterFromTestNode((StepInterface)filterItemObject, testNode);
        }
        return false;
    }

    @Override
    public boolean updateSimpleFilterFromTestNode(FilterItem filterItem, FilterLogicTestNodeInterface testNode) {
        String name = testNode.getFilterLabel();
        String description = testNode.getFilterDescription();
        ConditionalExpression result = null;
        result = this.newConditionalExpression(testNode);
        if (result == null) {
            return false;
        }
        if (filterItem != null) {
            if (!this.updateSimpleFilter(filterItem, name, description, (ExpressionInterface)result)) {
                return false;
            }
            if (this._businessModel != null) {
                this.addFilterItem(filterItem);
            }
        }
        return true;
    }

    private Object getStringOrExpressionFromValue(FilterValueInterface value) {
        Object retval = null;
        if (value != null) {
            retval = value.getData() instanceof StringExpression ? value.getData() : value.getUnformattedValue();
        }
        return retval;
    }

    protected List getExpressionListFromTestNodeValues(FilterLogicTestNodeInterface testNode) {
        List valueList = testNode.getTestValuesList();
        ExpressionInterface[] expressions = null;
        if (valueList != null) {
            expressions = new ExpressionInterface[valueList.size()];
            for (int i = 0; i < valueList.size(); ++i) {
                FilterValueInterface filterValue;
                Object valueObject = valueList.get(i);
                if (valueObject instanceof ValueItem) {
                    valueObject = ((ValueItem)valueObject).getValue();
                }
                if (valueObject instanceof FilterValueInterface) {
                    valueObject = this.getStringOrExpressionFromValue((FilterValueInterface)valueObject);
                }
                if (valueObject instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)valueObject;
                    valueObject = treeNode.getUserObject();
                }
                if (valueObject instanceof FilterValueInterface && !((valueObject = (filterValue = (FilterValueInterface)valueObject).getData()) instanceof OlapItem) && !(valueObject instanceof Prompt)) {
                    valueObject = filterValue.getUnformattedValue();
                }
                if (valueObject instanceof OlapItem) {
                    try {
                        valueObject = ((OlapItem)valueObject).getUniqueName();
                    }
                    catch (MetadataException metadataException) {}
                } else if (valueObject instanceof ValueItem) {
                    valueObject = ((ValueItem)valueObject).getValue();
                }
                if (valueObject == null) continue;
                if (!(valueObject instanceof ExpressionInterface)) {
                    valueObject = BaseFilterObjectFactory.newStringExpression(valueObject.toString());
                }
                expressions[i] = (ExpressionInterface)valueObject;
            }
        }
        return Arrays.asList(expressions);
    }

    protected List getStringExpressionListFromTestNodeValues(FilterLogicTestNodeInterface testNode) {
        List valueList = testNode.getTestValuesList();
        ArrayList<Object> expList = null;
        if (valueList != null) {
            expList = new ArrayList<Object>(valueList.size());
            for (int i = 0; i < valueList.size(); ++i) {
                Object valueObject = valueList.get(i);
                if (valueObject instanceof ValueItem) {
                    valueObject = ((ValueItem)valueObject).getValue();
                }
                if (valueObject instanceof FilterValueInterface) {
                    valueObject = this.getStringOrExpressionFromValue((FilterValueInterface)valueObject);
                }
                if (valueObject instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)valueObject;
                    valueObject = treeNode.getUserObject();
                }
                if (valueObject instanceof FilterValueInterface) {
                    valueObject = ((FilterValueInterface)valueObject).getUnformattedValue();
                }
                if (valueObject instanceof StringExpression) {
                    expList.add(valueObject);
                    continue;
                }
                if (valueObject == null) continue;
                expList.add(valueObject.toString());
            }
        }
        return this.createStringExpressionList(expList, (int)this.getItemType(testNode));
    }

    private Object __getExpressionForQualifierObject(Object valueObject) {
        if (valueObject instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)valueObject;
            valueObject = treeNode.getUserObject();
        }
        if (valueObject instanceof FilterQualifierInterface) {
            valueObject = ((FilterQualifierInterface)valueObject).getQualifier();
        }
        if (valueObject instanceof DataItem) {
            valueObject = ((DataItem)valueObject).getExpression();
        }
        if (valueObject instanceof Measure) {
            try {
                valueObject = ((Measure)valueObject).getUniqueName();
            }
            catch (MetadataException metadataException) {
                // empty catch block
            }
        }
        if (valueObject instanceof StringExpression) {
            return valueObject;
        }
        if (valueObject != null) {
            return BaseFilterObjectFactory.newStringExpression(valueObject.toString());
        }
        return null;
    }

    protected List createStringExpressionList(List values) {
        return this.createStringExpressionList(values, 3);
    }

    protected List createStringExpressionList(List values, int type) {
        ArrayList expList = new ArrayList();
        if (values != null) {
            for (Object obj : values) {
                if (obj instanceof StringExpression) {
                    expList.add(obj);
                    continue;
                }
                expList.add(BaseFilterObjectFactory.newStringExpression(obj.toString(), type));
            }
        }
        return expList;
    }

    protected List getMemberListFromTestNodeQualifiers(FilterLogicTestNodeInterface testNode) {
        FilterQualifierInterface testQ;
        List valueList = testNode.getFilterItemQualifiers();
        if (valueList != null && valueList.size() == 1 && (testQ = (FilterQualifierInterface)valueList.get(0)) != null && testQ.getQualifier() instanceof List) {
            valueList = (List)testQ.getQualifier();
        }
        ArrayList<Object> members = null;
        if (valueList != null) {
            members = new ArrayList<Object>(valueList.size());
            for (int i = 0; i < valueList.size(); ++i) {
                Object valueObject = valueList.get(i);
                if (valueObject instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)valueObject;
                    valueObject = treeNode.getUserObject();
                }
                if (valueObject instanceof FilterQualifierInterface) {
                    valueObject = ((FilterQualifierInterface)valueObject).getQualifier();
                }
                if (valueObject instanceof DataItem) {
                    members.add(valueObject);
                    continue;
                }
                members.add(this.__getExpressionForQualifierObject(valueObject));
            }
        }
        return members;
    }

    protected ComparisonOperator getComparisonOperator(FilterLogicTestNodeInterface testNode) {
        FilterConditionInterface condition;
        ComparisonOperator compOp = null;
        if (testNode != null && (condition = testNode.getCondition()) != null && condition.getCondition() instanceof ComparisonOperator) {
            compOp = (ComparisonOperator)condition.getCondition();
        }
        return compOp;
    }

    public boolean updateSimpleFilterFromTestNode(StepInterface filterStep, FilterLogicTestNodeInterface testNode) {
        FilterConditionInterface condition = testNode.getCondition();
        if (condition != null && filterStep != null) {
            if (filterStep instanceof DataItemMemberFilter) {
                DataItemMemberFilter filter = (DataItemMemberFilter)filterStep;
                List memberNameList = this.getStringExpressionListFromTestNodeValues(testNode);
                filter.setIsNegated(condition.isConditionObjectNegated());
                filter.setMemberNames(memberNameList);
            } else if (filterStep instanceof DataItemDataBasedFilter) {
                DataItemDataBasedFilter filter = (DataItemDataBasedFilter)filterStep;
                List memberList = this.getMemberListFromTestNodeQualifiers(testNode);
                List valueList = this.getStringExpressionListFromTestNodeValues(testNode);
                ComparisonOperator operator = this.getComparisonOperator(testNode);
                filter.setLeftExpression(memberList);
                filter.setRightExpression(valueList);
                filter.setOperator(operator);
            } else if (filterStep instanceof DataItemMemberPropertiesFilter) {
                DataItemMemberPropertiesFilter filter = (DataItemMemberPropertiesFilter)filterStep;
                String propName = null;
                List qualifiers = testNode.getFilterItemQualifiers();
                if (qualifiers != null && !qualifiers.isEmpty()) {
                    FilterQualifierInterface qualifier = (FilterQualifierInterface)qualifiers.get(0);
                    MemberPropertyQualifierData data = (MemberPropertyQualifierData)qualifier.getQualifier();
                    try {
                        propName = data.getProperty().getName();
                    }
                    catch (OLAPException e) {
                        propName = null;
                    }
                }
                List valueList = this.getStringExpressionListFromTestNodeValues(testNode);
                ComparisonOperator operator = this.getComparisonOperator(testNode);
                filter.setMemberPropertyName(propName);
                filter.setRightExpression(valueList);
                filter.setOperator(operator);
            }
        }
        return true;
    }

    protected long getItemType(FilterLogicTestNodeInterface testNode) {
        long type = 0L;
        if (testNode != null && testNode.getFilterItem() != null) {
            FilterItemInterface item = testNode.getFilterItem();
            FilterItemInterface qualifiedItem = null;
            List qList = testNode.getFilterItemQualifiers();
            if (qList != null && qList.size() > 0) {
                qualifiedItem = item.getQualifiedItem(qList);
            }
            type = qualifiedItem == null ? item.getItemType() : qualifiedItem.getItemType();
        }
        return type;
    }

    public boolean updateSimpleFilter(FilterItem filterItem, String name, String description, ExpressionInterface result) {
        if (filterItem != null) {
            try {
                filterItem.setLabel(name);
                filterItem.setDescription(description);
                filterItem.setExpression(result);
                return true;
            }
            catch (MetadataException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public CompoundFilter newCoumpoundFilter(FilterItem left, FilterItem right, ConditionalRelationType relationType, boolean isNegated) {
        CompoundFilter compoundFilter = this.newCompoundFilter();
        boolean success = this.updateCompoundFilter((FilterItem)compoundFilter, left, right, relationType, isNegated);
        return compoundFilter;
    }

    @Override
    public boolean updateCompoundFilter(FilterItem filterItem, FilterItem left, FilterItem right, ConditionalRelationType relationType, boolean isNegated) {
        if (!(filterItem instanceof CompoundFilter)) {
            return false;
        }
        CompoundFilter compoundFilter = (CompoundFilter)filterItem;
        compoundFilter.setLeftFilter(left);
        compoundFilter.setRightFilter(right);
        compoundFilter.setIsNegated(isNegated);
        if (left == null || right == null) {
            compoundFilter.setRelationType(null);
        } else {
            compoundFilter.setRelationType(relationType);
        }
        return true;
    }

    @Override
    public boolean updateCompoundStep(CompoundStep compoundFilter, StepInterface left, StepInterface right, ConditionalRelationType relationType, boolean isNegated) {
        if (compoundFilter == null) {
            return false;
        }
        compoundFilter.addStep(left);
        if (right != null) {
            compoundFilter.addStep(right);
        }
        if (left != null || right != null) {
            compoundFilter.setConditionType(relationType.getPersistentForm());
        }
        compoundFilter.setNegated(isNegated);
        return true;
    }

    @Override
    public FilterItemInterface findMatchingFilterItem(FilterItemListInterface fili, Object itemObject) {
        FilterItemInterface found = null;
        if (fili instanceof FilterItemLookupInterface) {
            found = ((FilterItemLookupInterface)fili).lookupFilterItem(itemObject);
        }
        return found;
    }

    public FilterConditionInterface findMatchingConditionObject(FilterItemInterface filterItem, Object conditionObject, boolean isNegated, List qualifiers) {
        FilterConditionListInterface fcli = null;
        if (qualifiers == null || qualifiers.size() == 0) {
            fcli = filterItem.getConditionList();
        } else {
            FilterItemInterface qualifiedItem = filterItem.getQualifiedItem(qualifiers);
            if (qualifiedItem != null) {
                fcli = qualifiedItem.getConditionList();
            } else {
                this.log.debug("_DEBUG_: Qualified Item was NULL!");
                return null;
            }
        }
        return this.findMatchingConditionObject(conditionObject, isNegated, fcli);
    }

    @Override
    public FilterConditionInterface findMatchingConditionObject(FilterItemInterface filterItem, Object conditionObject, boolean isNegated) {
        FilterConditionListInterface fcli = filterItem.getConditionList();
        return this.findMatchingConditionObject(conditionObject, isNegated, fcli);
    }

    public FilterConditionInterface findMatchingConditionObject(Object conditionObject, boolean isNegated, FilterConditionListInterface fcli) {
        FilterConditionInterface found = null;
        ArrayList conditions = fcli.getConditionList();
        List extraConditions = this.getAlternateConditions();
        if (extraConditions != null) {
            conditions = new ArrayList(conditions);
            conditions.addAll(extraConditions);
        }
        for (Object condition : conditions) {
            FilterConditionInterface fci;
            if (!(condition instanceof FilterConditionInterface) || (fci = (FilterConditionInterface)condition).getCondition() != conditionObject || fci.isConditionObjectNegated() != isNegated) continue;
            found = fci;
            break;
        }
        return found;
    }

    protected List getAlternateConditions() {
        return null;
    }

    @Override
    public boolean clearFilterCondition(FilterItem filterItem) {
        if (filterItem != null) {
            try {
                filterItem.setExpression(null);
                return true;
            }
            catch (MetadataException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public boolean updateCompoundConditionalFilter(FilterItem filterItem, ExpressionInterface expression, ExpressionInterface exprLeft, ExpressionInterface exprRight, ConditionalRelationType relationType, boolean isNegated) {
        if (filterItem != null) {
            CompoundConditionalExpression compExpr = null;
            if (expression instanceof CompoundConditionalExpression) {
                compExpr = (CompoundConditionalExpression)expression;
                compExpr.setLeftExpression(exprLeft);
                compExpr.setRightExpression(exprRight);
                compExpr.setIsNegated(isNegated);
                compExpr.setRelationType(relationType);
            } else {
                compExpr = this.newCompoundConditionalExpression(exprLeft, exprRight, relationType, isNegated);
                expression = compExpr;
            }
            if (exprLeft == null || exprRight == null) {
                compExpr.setRelationType(null);
            }
            try {
                filterItem.setExpression(expression);
                return true;
            }
            catch (MetadataException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public CompoundConditionalExpression newCompoundConditionalExpression(ExpressionInterface exprLeft, ExpressionInterface exprRight, ConditionalRelationType relationType, boolean isNegated) {
        CompoundConditionalExpression compoundExpression = new CompoundConditionalExpression();
        compoundExpression.setLeftExpression(exprLeft);
        compoundExpression.setRightExpression(exprRight);
        if (exprLeft != null && exprRight != null) {
            compoundExpression.setRelationType(relationType);
        }
        compoundExpression.setIsNegated(isNegated);
        return compoundExpression;
    }

    public ConditionalExpression newConditionalExpression(FilterLogicTestNodeInterface testNode) {
        SimpleConditionalExpression_In expression = null;
        FilterConditionInterface condition = testNode.getCondition();
        FilterItemInterface item = testNode.getFilterItem();
        List qualifiers = testNode.getFilterItemQualifiers();
        List values = testNode.getTestValuesList();
        if (item == null) {
            return null;
        }
        if (condition == null) {
            return null;
        }
        Object itemObject = item.getItem();
        int exprType = 0;
        if (itemObject instanceof ExpressionInterface) {
            exprType = ((ExpressionInterface)itemObject).getExpressionType();
        }
        if (itemObject instanceof DataItem) {
            DataItem di = (DataItem)itemObject;
            exprType = di.getExpressionTypeIgnoringFormattingForced();
        }
        Object conditionObject = condition.getCondition();
        boolean conditionNegated = condition.isConditionObjectNegated();
        int argumentCount = condition.getConditionArgumentCount();
        ArrayList<Object> valueObjects = new ArrayList<Object>();
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            if (value instanceof FilterValueInterface) {
                value = ((FilterValueInterface)value).getUnformattedValue();
            }
            if (!(value instanceof ExpressionInterface)) {
                ConstantExpression constant = new ConstantExpression();
                if (value == null) {
                    constant.setValue(null);
                } else {
                    constant.setValue(value.toString());
                }
                constant.setExpressionType(exprType);
                value = constant;
            }
            valueObjects.add(value);
        }
        if (conditionObject instanceof ComparisonOperator) {
            ExpressionInterface rightExpr = BaseFilterObjectFactory.newConstantExpression(exprType);
            if (valueObjects != null && valueObjects.size() > 0) {
                rightExpr = (ExpressionInterface)valueObjects.get(0);
            }
            SimpleConditionalExpression_Comparison compExpr = new SimpleConditionalExpression_Comparison();
            compExpr.setComparisonOperator((ComparisonOperator)conditionObject);
            compExpr.setIsNegated(conditionNegated);
            compExpr.setLeftExpression((ExpressionInterface)itemObject);
            compExpr.setRightExpression(rightExpr);
            if (exprType != ((ExpressionInterface)itemObject).getExpressionType()) {
                compExpr.setFormattingForcedOverridden(true);
                compExpr.setFormattingForcedOverrideValue(false);
            }
            expression = compExpr;
        } else if (conditionObject == SimpleConditionalExpression_In.class) {
            SimpleConditionalExpression_In inExpr = new SimpleConditionalExpression_In();
            inExpr.setIsNegated(conditionNegated);
            inExpr.setWhatToCompare((ExpressionInterface)itemObject);
            inExpr.setComparisonList(valueObjects);
            expression = inExpr;
        } else if (conditionObject == SimpleConditionalExpression_Between.class) {
            ExpressionInterface leftExpr = BaseFilterObjectFactory.newConstantExpression(exprType);
            ExpressionInterface rightExpr = BaseFilterObjectFactory.newConstantExpression(exprType);
            if (valueObjects != null) {
                if (valueObjects.size() > 0) {
                    leftExpr = (ExpressionInterface)valueObjects.get(0);
                }
                if (valueObjects.size() > 1) {
                    rightExpr = (ExpressionInterface)valueObjects.get(1);
                }
            }
            SimpleConditionalExpression_Between betweenExpr = new SimpleConditionalExpression_Between();
            betweenExpr.setIsNegated(conditionNegated);
            betweenExpr.setWhatToCompare((ExpressionInterface)itemObject);
            betweenExpr.setLeftExpression(leftExpr);
            betweenExpr.setRightExpression(rightExpr);
            expression = betweenExpr;
        } else if (conditionObject == SimpleConditionalExpression_TestForNull.class) {
            SimpleConditionalExpression_TestForNull nullExpr = new SimpleConditionalExpression_TestForNull();
            nullExpr.setIsNegated(conditionNegated);
            nullExpr.setWhatToCompare((ExpressionInterface)itemObject);
            expression = nullExpr;
        } else {
            return null;
        }
        return expression;
    }

    public FilterQualifierInterface findMatchingFilterQualifier(FilterItemInterface filterItem, Object searchValue) {
        FilterQualifierListInterface filterQualifierList;
        if (filterItem != null && (filterQualifierList = filterItem.getQualifierList()) != null) {
            List values = filterQualifierList.getFilterQualifierList();
            for (int i = 0; i < values.size(); ++i) {
                ExpressionInterface expr;
                String exprText;
                FilterQualifierInterface qualifier = (FilterQualifierInterface)values.get(i);
                Object testValue = searchValue;
                Object testObject = qualifier.getQualifier();
                if (testObject == testValue) {
                    return qualifier;
                }
                if (testValue == null) continue;
                String measureName = null;
                if (testObject instanceof Measure) {
                    try {
                        measureName = ((Measure)testObject).getUniqueName();
                    }
                    catch (MetadataException metadataException) {
                        // empty catch block
                    }
                }
                if (testValue instanceof ExpressionInterface && (exprText = BaseFilterObjectFactory.getExpressionUtilText(expr = (ExpressionInterface)testValue)) != null) {
                    testValue = exprText;
                }
                if (testValue instanceof OlapItem) {
                    OlapItem olapItem = (OlapItem)testValue;
                    try {
                        if (olapItem.getUniqueName().equals(measureName)) {
                            return qualifier;
                        }
                    }
                    catch (MetadataException metadataException) {
                        // empty catch block
                    }
                }
                if (!testValue.toString().equals(measureName)) continue;
                return qualifier;
            }
        }
        return null;
    }

    public List createFilterQualifierListFromNativeList(List nativeList, FilterItemInterface filterItem) {
        ArrayList<FilterQualifierInterface> qualifierList = new ArrayList<FilterQualifierInterface>(1);
        if (nativeList != null) {
            ArrayList<FilterQualifierInterface> tempQualifierList = new ArrayList<FilterQualifierInterface>(nativeList.size());
            for (Object nativeObject : nativeList) {
                FilterQualifierInterface qualifier = this.findMatchingFilterQualifier(filterItem, nativeObject);
                if (qualifier == null) {
                    qualifier = this.createFilterQualifierFromNative(nativeObject);
                }
                tempQualifierList.add(qualifier);
            }
            if (tempQualifierList.size() > 1) {
                FilterQualifierInterface qual = this.createFilterQualifierFromNative(tempQualifierList);
                qualifierList.add(qual);
            } else {
                qualifierList = tempQualifierList;
            }
        }
        return qualifierList;
    }

    public FilterQualifierInterface createFilterQualifierFromNative(Object nativeObject) {
        FilterQualifierInterface value = null;
        if (nativeObject instanceof FilterQualifierInterface) {
            value = (FilterQualifierInterface)nativeObject;
        } else if (nativeObject instanceof ExpressionInterface) {
            ExpressionInterface expr = (ExpressionInterface)nativeObject;
            String formattedValue = null;
            formattedValue = BaseFilterObjectFactory.getExpressionUtilText(expr);
            value = new DefaultFilterQualifier(formattedValue, nativeObject);
        } else if (nativeObject instanceof PropertyInterface) {
            PropertyInterface property = (PropertyInterface)nativeObject;
            try {
                MemberPropertyQualifierData data = new MemberPropertyQualifierData(null, property);
                String label = data.createLabel(this.getLocale());
                value = new DefaultFilterQualifier(label, (Object)data);
            }
            catch (OLAPException e) {
                value = null;
            }
        } else if (nativeObject instanceof List) {
            Object first;
            List qList = (List)nativeObject;
            if (qList.size() > 0 && (first = qList.get(0)) instanceof FilterQualifierInterface) {
                FilterQualifierInterface primaryQualifier = (FilterQualifierInterface)first;
                StringBuffer innerText = new StringBuffer();
                for (FilterQualifierInterface qualifier : qList.subList(1, qList.size())) {
                    if (innerText.length() > 0) {
                        innerText.append(", ");
                    }
                    innerText.append(qualifier.getQualifierLabel());
                }
                String labelFormat = RB.getStringResource((String)"BaseFilterObjectFactory.QualifierLabel.txt.fmt", (Locale)this._locale);
                String label = MessageFormat.format(labelFormat, primaryQualifier.getQualifierLabel(), innerText.toString());
                value = new DefaultFilterQualifier(label, (Object)qList);
            }
        } else {
            value = new DefaultFilterQualifier(nativeObject.toString(), nativeObject);
        }
        return value;
    }

    public FilterValueInterface findMatchingFilterValue(FilterItemInterface filterItem, Object searchValue) throws DataRetrievalError {
        FilterValuesInterface filterValueList;
        if (filterItem != null && (filterValueList = filterItem.getActualValues()) != null) {
            List values = filterValueList.getFirstValues(0L);
            for (int i = 0; i < values.size(); ++i) {
                ExpressionInterface expr;
                String exprText;
                FilterValueInterface testValue = (FilterValueInterface)values.get(i);
                if (testValue.getData() == searchValue) {
                    return testValue;
                }
                if (searchValue == null) continue;
                if (searchValue instanceof ExpressionInterface && (exprText = BaseFilterObjectFactory.getExpressionUtilText(expr = (ExpressionInterface)searchValue)) != null) {
                    searchValue = exprText;
                }
                if (searchValue instanceof OlapItem) {
                    OlapItem olapItem = (OlapItem)searchValue;
                    try {
                        if (olapItem.getUniqueName().equals(testValue.getUnformattedValue())) {
                            return testValue;
                        }
                    }
                    catch (MetadataException metadataException) {
                        // empty catch block
                    }
                }
                if (searchValue.toString().equals(testValue.getUnformattedValue())) {
                    return testValue;
                }
                if (!searchValue.toString().equals(testValue.getFormattedValue())) continue;
                return testValue;
            }
        }
        return null;
    }

    public List createFilterValueListFromNativeList(List nativeList, FilterItemInterface filterItem) {
        ArrayList<FilterValueInterface> valueList = null;
        if (nativeList != null) {
            valueList = new ArrayList<FilterValueInterface>(nativeList.size());
            for (Object nativeObject : nativeList) {
                FilterValueInterface value = null;
                try {
                    value = this.findMatchingFilterValue(filterItem, nativeObject);
                }
                catch (DataRetrievalError e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
                if (value == null) {
                    long type = filterItem != null ? BaseFilterObjectFactory.getAdjustedFilterItemType(filterItem) : 0L;
                    value = this.createFilterValueFromNative(nativeObject, type, null);
                }
                valueList.add(value);
            }
        }
        return valueList;
    }

    protected List createFilterValueList(FilterItemInterface filterItem) {
        Object ada;
        List valueList = null;
        FilterValuesInterface filterValues = filterItem.getPossibleValues();
        List values = null;
        if (filterValues.hasMoreValues() && (values = filterValues.getFirstValues(0L)) != null && values.size() == 1 && (ada = values.get(0)) instanceof OLAPTimeBasedFilterAdapterInterface) {
            OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)ada;
            DefaultFilterValue filterValue = new DefaultFilterValue((Object)adapter, String.valueOf(adapter.hashCode()), 6, null, (Object)String.valueOf(adapter.hashCode()));
            valueList = ListFactory.newList();
            valueList.add(filterValue);
        }
        return valueList;
    }

    public FilterValueInterface createFilterValueFromNative(Object nativeObject, FilterLogicTestNodeInterface testNode) {
        FilterItemInterface filterItem;
        if (nativeObject instanceof FilterValueInterface) {
            return (FilterValueInterface)nativeObject;
        }
        FilterValueInterface value = null;
        if (testNode != null && (filterItem = testNode.getFilterItem()) != null) {
            long type = BaseFilterObjectFactory.getAdjustedFilterItemType(filterItem);
            if (type == 4L || type == 6L || type == 5L) {
                nativeObject = this.createExpressionFromNative(nativeObject, (int)type);
            }
            String sasFormatText = DateAndTimeUtil.getFilterItemSASFormatText(filterItem);
            value = this.createFilterValueFromNative(nativeObject, type, sasFormatText);
        }
        if (value == null) {
            value = this.createFilterValueFromNative(nativeObject);
        }
        return value;
    }

    public FilterValueInterface newFilterValue(Object nativeObject, FilterLogicTestNodeInterface testNode) {
        return this.createFilterValueFromNative(nativeObject, testNode);
    }

    public FilterValueInterface createFilterValueFromNative(Object nativeObject) {
        String sasFormatText = DateAndTimeUtil.getFilterItemSASFormatText(nativeObject);
        return this.createFilterValueFromNative(nativeObject, 0L, sasFormatText);
    }

    public FilterValueInterface createFilterValueFromNative(Object nativeObject, long itemType, String sasFormatText) {
        return this.createFilterValueFromNative(nativeObject, itemType, sasFormatText, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterValueInterface createFilterValueFromNative(Object nativeObject, long itemType, String sasFormatText, boolean formatValue) {
        if (nativeObject instanceof FilterValueInterface) {
            return (FilterValueInterface)nativeObject;
        }
        if (!(nativeObject instanceof ExpressionInterface) && nativeObject instanceof Date) {
            Object atve = null;
            atve = itemType == 5L ? new TimeValueExpression((Date)nativeObject) : (itemType == 6L ? new TimestampValueExpression((Date)nativeObject) : new DateValueExpression((Date)nativeObject));
            nativeObject = atve;
        }
        String formattedValue = null;
        Comparable<Double> unformattedValue = null;
        int dataType = (int)itemType;
        Class<?> nativeClass = null;
        String msgFormat = null;
        Locale locale = this.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (nativeObject instanceof ExpressionInterface) {
            Format formatter;
            ArrayList<ExpressionInterface> expList;
            RelativeTimeFilterData relativeTimeData;
            FunctionCall fCall;
            List args;
            ExpressionInterface expr = (ExpressionInterface)nativeObject;
            try {
                dataType = expr.getExpressionType();
            }
            catch (Exception e) {
                dataType = 0;
            }
            if (expr instanceof FunctionCall && (args = (fCall = (FunctionCall)expr).getArguments()).size() == 1) {
                if (args.get(0) instanceof FunctionCall) {
                    FunctionCall fc = (FunctionCall)args.get(0);
                    args = fc.getArguments();
                }
                if (args != null && args.get(0) instanceof Prompt) {
                    expr = (Prompt)args.get(0);
                }
            }
            if (formatValue || expr instanceof AbstractTimeValueExpression) {
                fCall = _stringExpressionUtil;
                synchronized (fCall) {
                    if (expr instanceof FunctionCall) {
                        formattedValue = BaseFilterObjectFactory.formatFunctionCall((FunctionCall)expr);
                    } else {
                        Locale saveLocale = _stringExpressionUtil.getFormatLocale();
                        _stringExpressionUtil.setFormatLocale(locale);
                        if (sasFormatText == null) {
                            sasFormatText = StringExpressionUtil.getDefaultSASFormatText((int)dataType);
                        }
                        try {
                            formattedValue = expr instanceof ResourceAwareStringExpression ? _stringExpressionUtil.getText(expr, ResourceScope.BUSINESS_SCOPE, null) : _stringExpressionUtil.getReadableText(expr, sasFormatText);
                        }
                        catch (MetadataException e) {
                            formattedValue = expr.toString();
                        }
                        finally {
                            _stringExpressionUtil.setFormatLocale(saveLocale);
                        }
                    }
                }
            }
            try {
                formattedValue = expr instanceof FunctionCall ? BaseFilterObjectFactory.formatFunctionCall((FunctionCall)expr) : (expr instanceof ConstantExpression && ((ConstantExpression)expr).getExpressionType() == 3 ? expr.toString() : _stringExpressionUtil.getReadableText(expr, "$80."));
            }
            catch (MetadataException e) {
                formattedValue = expr.toString();
            }
            nativeClass = nativeObject.getClass();
            if (!(formattedValue == null || expr instanceof ConstantExpression && ((ConstantExpression)expr).getExpressionType() == 3)) {
                formattedValue = formattedValue.trim();
            }
            if (expr instanceof AbstractTimeValueExpression) {
                AbstractTimeValueExpression abstractTimeValue = (AbstractTimeValueExpression)expr;
                unformattedValue = abstractTimeValue.getExplicitDoubleValue() != null ? abstractTimeValue.getExplicitDoubleValue() : abstractTimeValue.getValue();
            } else if (expr instanceof AbstractRelativeTimeValueExpression) {
                relativeTimeData = IQRelativeTimeFilterUtil.generateDataFromExpression(expr);
                unformattedValue = relativeTimeData;
                if (relativeTimeData != null) {
                    expList = new ArrayList<ExpressionInterface>(1);
                    expList.add(expr);
                    formatter = IQRelativeTimeFilterUtil.getRelativeTimeFilterValueFormatter(expList, locale);
                    formattedValue = formatter.format(unformattedValue);
                }
            } else if (expr instanceof ConstantExpression) {
                unformattedValue = ((ConstantExpression)expr).getValue();
            } else if (formattedValue != null && expr instanceof Prompt) {
                if (IQUeryUtil.isSystemIdentityPrompt((Prompt)expr)) {
                    PromptDefinitionInterface promptDefinition = ((Prompt)expr).getPromptDefinition();
                    SystemVariable sv = new SystemVariable(1, promptDefinition.getPromptLabel(this.getLocale()), promptDefinition.getPromptDescription(this.getLocale()), (Object)expr);
                    String example = "";
                    if (this._businessModel instanceof InformationMap) {
                        InformationMap map = (InformationMap)this._businessModel;
                        try {
                            RepositoryInterface repos = map.getRepository();
                            if (repos instanceof OMIRepositoryInterface) {
                                SessionContextInterface sessionContext = map.getSession();
                                ServicesLogFactory factory = new ServicesLogFactory(sessionContext);
                                example = IQUeryUtil.getIdentityDrivenPropertyValue((OMIRepositoryInterface)repos, (LoggerFactoryInterface)factory, promptDefinition.getPromptLabel(this.getLocale()));
                            }
                        }
                        catch (ServiceException serviceException) {
                        }
                        catch (RemoteException remoteException) {
                        }
                        catch (MetadataException metadataException) {
                            // empty catch block
                        }
                    }
                    if (example != null && example.length() > 0) {
                        sv.setExample((Object)example);
                    }
                    nativeObject = sv;
                } else {
                    unformattedValue = expr;
                }
            } else {
                relativeTimeData = IQRelativeTimeFilterUtil.generateDataFromExpression(expr);
                if (relativeTimeData != null) {
                    unformattedValue = relativeTimeData;
                    expList = new ArrayList(1);
                    expList.add(expr);
                    formatter = IQRelativeTimeFilterUtil.getRelativeTimeFilterValueFormatter(expList, locale);
                    formattedValue = formatter.format(unformattedValue);
                } else {
                    unformattedValue = formattedValue != null && !(expr instanceof Prompt) && !(expr instanceof FunctionCall) ? formattedValue : expr;
                }
            }
        } else if (nativeObject != null) {
            formattedValue = nativeObject.toString();
            unformattedValue = formattedValue;
        }
        DefaultFilterValue newValue = new DefaultFilterValue(nativeObject, formattedValue, dataType, nativeClass, (Object)unformattedValue, msgFormat);
        return newValue;
    }

    public static String formatFunctionCall(FunctionCall expr) {
        if (expr == null) {
            return null;
        }
        String formattedValue = null;
        try {
            FunctionNameID id = expr.getFunction().getFunctionNameID();
            if (id == FunctionNameID.STRIP || id == FunctionNameID.UPCASE) {
                Object funcArg = expr.getArguments().get(0);
                if (funcArg instanceof FunctionCall && ((FunctionCall)funcArg).getFunction().getFunctionNameID() == FunctionNameID.UPCASE) {
                    funcArg = ((FunctionCall)funcArg).getArguments().get(0);
                }
                if (funcArg instanceof ConstantExpression) {
                    formattedValue = funcArg.toString();
                    if (id == FunctionNameID.STRIP) {
                        formattedValue = formattedValue.trim();
                    }
                } else if (funcArg instanceof DataItemFormattingExpression) {
                    DataItem dataItem = ((DataItemFormattingExpression)funcArg).getDataItem();
                    formattedValue = dataItem.getLabel();
                } else {
                    formattedValue = _stringExpressionUtil.getReadableText((ExpressionInterface)expr);
                }
            } else {
                formattedValue = _stringExpressionUtil.getReadableText((ExpressionInterface)expr);
            }
        }
        catch (MetadataException e) {
            formattedValue = expr.toString();
        }
        return formattedValue;
    }

    @Override
    public FilterLogicTestNodeInterface newTestNode(DataItem dataItem, StepInterface filterObject, FilterItemListInterface filterItemList) {
        return this.newTestNode(null, dataItem, filterObject, filterItemList);
    }

    public FilterLogicTestNodeInterface newTestNode(BusinessQuery bq, DataItem dataItem, StepInterface filterObject, FilterItemListInterface filterItemList) {
        DataItemMemberFilter filter;
        String name = null;
        String desc = null;
        Object conditionObject = null;
        boolean isNegated = false;
        List values = null;
        FilterItemInterface filterItem = this.findMatchingFilterItem(filterItemList, dataItem);
        if (filterItem == null) {
            return null;
        }
        List<FilterQualifierInterface> filterLogicQualifiers = null;
        if (filterObject instanceof DataItemMemberFilter) {
            filter = (DataItemMemberFilter)filterObject;
            conditionObject = ComparisonOperator.COMPARE_EQ;
            values = this.createValueItemListFromMemberNameList(filter.getMemberNames(), filterItem);
            isNegated = filter.isNegated();
        } else if (filterObject instanceof DataItemDataBasedFilter) {
            filter = (DataItemDataBasedFilter)filterObject;
            conditionObject = filter.getOperator();
            List nativeQualifierList = filter.getLeftExpression();
            List<FilterQualifierInterface> qualifierList = null;
            qualifierList = this.createFilterQualifierListFromNativeList(nativeQualifierList, filterItem);
            filterLogicQualifiers = qualifierList != null && qualifierList.size() > 1 ? Collections.singletonList(this.createFilterQualifierFromNative(qualifierList)) : qualifierList;
            List nativeValueList = filter.getRightExpression();
            values = this.createFilterValueListFromNativeList(nativeValueList, filterItem);
        } else if (filterObject instanceof DataItemMemberPropertiesFilter) {
            filter = (DataItemMemberPropertiesFilter)filterObject;
            conditionObject = filter.getOperator();
            String propName = filter.getMemberPropertyName();
            FilterQualifierInterface qualifier = this.getQualifierFromPropertyName(filterItem.getQualifierList(), propName);
            if (qualifier == null) {
                return null;
            }
            filterLogicQualifiers = Collections.singletonList(qualifier);
            List nativeValueList = filter.getRightExpression();
            values = this.createFilterValueListFromNativeList(nativeValueList, filterItem);
        } else if (filterObject instanceof DataItemTimeFilter) {
            filter = (DataItemTimeFilter)filterObject;
            conditionObject = this.getRelativeTimeFilterConditionObject(filterItem);
            values = this.createFilterValueList(filterItem);
        } else if (filterObject instanceof DataItemTimeRangeFilter) {
            filter = (DataItemTimeRangeFilter)filterObject;
            conditionObject = this.getRelativeTimeFilterConditionObject(filterItem);
            values = this.createFilterValueList(filterItem);
        }
        FilterConditionInterface filterLogicCondition = this.findMatchingConditionObject(filterItem, conditionObject, isNegated, filterLogicQualifiers);
        if (filterLogicCondition == null) {
            return null;
        }
        DefaultFilterLogicTestNode testNode = new DefaultFilterLogicTestNode(filterItem, filterLogicQualifiers, filterLogicCondition, values);
        if (name != null) {
            testNode.setFilterLabel(name);
        }
        if (desc != null) {
            testNode.setFilterDescription(desc);
        }
        return testNode;
    }

    private Object getRelativeTimeFilterConditionObject(FilterItemInterface filterItem) {
        Object relativeTimeFilterCondition = null;
        List conditions = filterItem.getConditionList().getConditionList();
        Iterator iter = conditions.iterator();
        Object condition = null;
        FilterConditionInterface fci = null;
        Object curCondition = null;
        while (iter.hasNext()) {
            condition = iter.next();
            if (!(condition instanceof FilterConditionInterface) || !((curCondition = (fci = (FilterConditionInterface)condition).getCondition()) instanceof Class) || !"com.sas.swing.visuals.dataselectors.filters.OLAPRelativeTimeFilterPanel".equals(((Class)curCondition).getName())) continue;
            relativeTimeFilterCondition = curCondition;
            break;
        }
        return relativeTimeFilterCondition;
    }

    private FilterQualifierInterface getQualifierFromPropertyName(FilterQualifierListInterface qualifierList, String propName) {
        List qualifiers;
        FilterQualifierInterface qualifier = null;
        if (qualifierList != null && propName != null && (qualifiers = qualifierList.getFilterQualifierList()) != null) {
            for (FilterQualifierInterface q : qualifiers) {
                MemberPropertyQualifierData data;
                if (q == null || !(q.getQualifier() instanceof MemberPropertyQualifierData) || (data = (MemberPropertyQualifierData)q.getQualifier()) == null || data.getProperty() == null) continue;
                try {
                    String testName = data.getProperty().getName();
                    if (!propName.equals(testName)) continue;
                    qualifier = q;
                    break;
                }
                catch (OLAPException oLAPException) {
                }
            }
        }
        return qualifier;
    }

    @Override
    public FilterLogicTestNodeInterface newTestNode(DataItem dataItem, FilterItemListInterface filterItemList) {
        FilterLogicTestNodeInterface testNode = null;
        if (dataItem != null) {
            StepInterface filterStep = this.getFilterStep(dataItem);
            testNode = this.newTestNode(dataItem, filterStep, filterItemList);
        }
        return testNode;
    }

    public StepInterface getFilterStep(DataItem dataItem) {
        List stepList;
        StepInterface step = null;
        int index = -1;
        if (dataItem != null && (stepList = dataItem.getSteps()) != null) {
            for (index = stepList.size() - 1; index >= 0; --index) {
                StepInterface aStep = (StepInterface)stepList.get(index);
                if (aStep instanceof CompoundStep || aStep instanceof DataItemMemberFilter || aStep instanceof DataItemDataBasedFilter || aStep instanceof DataItemMemberPropertiesFilter || aStep instanceof DataItemTimeFilter || aStep instanceof DataItemTimeRangeFilter) {
                    step = aStep;
                    break;
                }
                if (aStep instanceof DataItemRankFilter) continue;
                step = null;
                break;
            }
        }
        return step;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterLogicTestNodeInterface newTestNode(FilterItem filter, FilterItemListInterface filterItemList) {
        ExpressionInterface expression;
        FilterLogicTestNodeInterface testNode = null;
        String name = null;
        String desc = null;
        if (!(filter instanceof CompoundFilter) && (testNode = IQRelativeTimeFilterUtil.newTestNode(expression = filter.getExpression(), this, filterItemList, this._locale)) == null) {
            if (expression instanceof SimpleConditionalExpression_Comparison) {
                testNode = this.newTestNode(name, desc, (SimpleConditionalExpression_Comparison)expression, filterItemList);
            } else if (expression instanceof SimpleConditionalExpression_In) {
                testNode = this.newTestNode(name, desc, (SimpleConditionalExpression_In)expression, filterItemList);
            } else if (expression instanceof SimpleConditionalExpression_Between) {
                testNode = this.newTestNode(name, desc, (SimpleConditionalExpression_Between)expression, filterItemList);
            } else if (expression instanceof SimpleConditionalExpression_TestForNull) {
                testNode = this.newTestNode(name, desc, (SimpleConditionalExpression_TestForNull)expression, filterItemList);
            } else if (expression instanceof SimpleConditionalExpression_Contains) {
                testNode = this.newTestNode(name, desc, (SimpleConditionalExpression_Contains)expression, filterItemList);
            } else if (expression instanceof SimpleConditionalExpression_Like) {
                testNode = this.newTestNode(name, desc, (SimpleConditionalExpression_Like)expression, filterItemList);
            } else if (expression instanceof ResourceAwareStringExpression) {
                testNode = this.newTestNode(name, desc, expression, FilterItemEditorInterface.class, false, null, filterItemList);
            } else if (expression instanceof FunctionCall) {
                testNode = this.newTestNode(name, desc, (FunctionCall)expression, filterItemList);
            } else if (expression instanceof MemberFilterExpression) {
                testNode = this.newTestNode(name, desc, (MemberFilterExpression)expression, filterItemList);
            } else if (expression instanceof DataBasedFilterExpression) {
                testNode = this.newTestNode(name, desc, (DataBasedFilterExpression)expression, filterItemList);
            } else if (expression instanceof TimeFilterExpression) {
                testNode = this.newTestNode(name, desc, (TimeFilterExpression)expression, filterItemList);
            } else if (expression instanceof TimeRangeFilterExpression) {
                testNode = this.newTestNode(name, desc, (TimeRangeFilterExpression)expression, filterItemList);
            }
            if (testNode == null && expression != null) {
                StringExpressionUtil stringExpressionUtil = _stringExpressionUtil;
                synchronized (stringExpressionUtil) {
                    try {
                        ResourceScope scope = this.getResourceScope();
                        int type = expression.getExpressionType();
                        String text = _stringExpressionUtil.getText(expression, scope, this._businessModel);
                        ExpressionInterface expr = _stringExpressionUtil.newExpression(this._businessModel, text, type, scope);
                        testNode = this.newTestNode(name, desc, expr, FilterItemEditorInterface.class, false, null, filterItemList);
                    }
                    catch (MetadataException e) {
                        this.log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return testNode;
    }

    public FilterLogicTestNodeInterface newTestNode(String name, String desc, MemberFilterExpression filterExpression, FilterItemListInterface filterItemList) {
        ArrayList values;
        ExpressionInterface item = filterExpression.getWhatToCompare();
        FilterItemInterface filterItem = this.findMatchingFilterItem(filterItemList, item);
        ComparisonOperator conditionObject = ComparisonOperator.COMPARE_EQ;
        boolean isNegated = filterExpression.isNegated();
        List memNames = filterExpression.getMemberNames();
        if (memNames != null && memNames.size() == 1 && memNames.get(0) instanceof Prompt) {
            values = new ArrayList(1);
            values.add(memNames.get(0));
        } else {
            values = this.createValueItemListFromMemberNameList(memNames, filterItem);
        }
        return this.newTestNode(name, desc, item, conditionObject, isNegated, values, filterItemList);
    }

    public FilterLogicTestNodeInterface newTestNode(String name, String desc, DataBasedFilterExpression filterExpr, FilterItemListInterface filterItemList) {
        ExpressionInterface item = filterExpr.getWhatToFilter();
        FilterItemInterface filterItem = this.findMatchingFilterItem(filterItemList, item);
        ComparisonOperator conditionObject = filterExpr.getComparisonOperator();
        boolean isNegated = filterExpr.isNegated();
        List values = this.createFilterValueListFromNativeList(filterExpr.getRightExpression(), filterItem);
        List qualifiers = this.createFilterQualifierListFromNativeList(filterExpr.getLeftExpression(), filterItem);
        return this.newTestNode(name, desc, item, qualifiers, conditionObject, isNegated, values, filterItemList);
    }

    public FilterLogicTestNodeInterface newTestNode(String name, String desc, TimeFilterExpression filterExpression, FilterItemListInterface filterItemList) {
        return null;
    }

    public FilterLogicTestNodeInterface newTestNode(String name, String desc, TimeRangeFilterExpression filterExpression, FilterItemListInterface filterItemList) {
        return null;
    }

    @Override
    public FilterLogicTestNodeInterface newTestNode(String name, String desc, FunctionCall fCall, FilterItemListInterface filterItemList) {
        Object item = null;
        FunctionNameID conditionObject = null;
        boolean isNegated = false;
        List values = new ArrayList();
        List qualifiers = null;
        if (fCall != null) {
            List args = fCall.getArguments();
            item = args.get(0);
            conditionObject = fCall.getFunction().getFunctionNameID();
            if (args.size() > 1) {
                values = args.subList(1, args.size());
            }
        }
        return this.newTestNode(name, desc, item, qualifiers, conditionObject, isNegated, values, filterItemList);
    }

    @Override
    public FilterLogicTestNodeInterface newTestNode(String name, String desc, SimpleConditionalExpression_Comparison compExpr, FilterItemListInterface filterItemList) {
        DataItem item = null;
        ComparisonOperator conditionObject = compExpr.getComparisonOperator();
        boolean isNegated = compExpr.isNegated();
        ArrayList<ExpressionInterface> values = new ArrayList<ExpressionInterface>();
        ExpressionInterface valueExpr = null;
        ExpressionInterface leftExpr = compExpr.getLeftExpression();
        ExpressionInterface rightExpr = compExpr.getRightExpression();
        if (leftExpr instanceof FunctionCall) {
            FunctionCall fCall = (FunctionCall)leftExpr;
            try {
                Object arg0;
                if (fCall.getFunction().getFunctionNameID() == FunctionNameID.STRIP && (arg0 = fCall.getArguments().get(0)) instanceof DataItemFormattingExpression) {
                    leftExpr = (DataItemFormattingExpression)arg0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (leftExpr instanceof DataItemFormattingExpression) {
            item = ((DataItemFormattingExpression)leftExpr).getDataItem();
            valueExpr = rightExpr;
        } else if (leftExpr instanceof DataItem) {
            item = leftExpr;
            valueExpr = rightExpr;
        } else if (rightExpr instanceof DataItem) {
            item = rightExpr;
            valueExpr = leftExpr;
        } else if (leftExpr instanceof ResourceAwareStringExpression) {
            item = leftExpr;
            valueExpr = rightExpr;
        } else if (rightExpr instanceof ResourceAwareStringExpression) {
            item = rightExpr;
            valueExpr = leftExpr;
        } else {
            return null;
        }
        values.add(valueExpr);
        return this.newTestNode(name, desc, item, conditionObject, isNegated, values, filterItemList);
    }

    @Override
    public FilterLogicTestNodeInterface newTestNode(String name, String desc, SimpleConditionalExpression_In inExpr, FilterItemListInterface filterItemList) {
        ExpressionInterface item = inExpr.getWhatToCompare();
        Class<SimpleConditionalExpression_In> conditionObject = SimpleConditionalExpression_In.class;
        boolean isNegated = inExpr.isNegated();
        List values = inExpr.getComparisonList();
        return this.newTestNode(name, desc, item, conditionObject, isNegated, values, filterItemList);
    }

    @Override
    public FilterLogicTestNodeInterface newTestNode(String name, String desc, SimpleConditionalExpression_Between betweenExpr, FilterItemListInterface filterItemList) {
        ExpressionInterface item = betweenExpr.getWhatToCompare();
        Class<SimpleConditionalExpression_Between> conditionObject = SimpleConditionalExpression_Between.class;
        boolean isNegated = betweenExpr.isNegated();
        ArrayList<ExpressionInterface> values = new ArrayList<ExpressionInterface>();
        values.add(betweenExpr.getLeftExpression());
        values.add(betweenExpr.getRightExpression());
        return this.newTestNode(name, desc, item, conditionObject, isNegated, values, filterItemList);
    }

    public FilterLogicTestNodeInterface newTestNode(String name, String desc, SimpleConditionalExpression_Contains containsExpr, FilterItemListInterface filterItemList) {
        ExpressionInterface item = containsExpr.getWhatToCompare();
        Class<SimpleConditionalExpression_Contains> conditionObject = SimpleConditionalExpression_Contains.class;
        boolean isNegated = containsExpr.isNegated();
        ArrayList<ExpressionInterface> values = new ArrayList<ExpressionInterface>();
        values.add(containsExpr.getWhatToContain());
        return this.newTestNode(name, desc, item, conditionObject, isNegated, values, filterItemList);
    }

    public FilterLogicTestNodeInterface newTestNode(String name, String desc, SimpleConditionalExpression_Like likeExpr, FilterItemListInterface filterItemList) {
        ExpressionInterface item = likeExpr.getWhatToCompare();
        Class<SimpleConditionalExpression_Like> conditionObject = SimpleConditionalExpression_Like.class;
        boolean isNegated = likeExpr.isNegated();
        ArrayList<ExpressionInterface> values = new ArrayList<ExpressionInterface>();
        values.add(likeExpr.getPatternExpression());
        return this.newTestNode(name, desc, item, conditionObject, isNegated, values, filterItemList);
    }

    @Override
    public FilterLogicTestNodeInterface newTestNode(String name, String desc, SimpleConditionalExpression_TestForNull nullExpr, FilterItemListInterface filterItemList) {
        ExpressionInterface item = nullExpr.getWhatToCompare();
        Class<SimpleConditionalExpression_TestForNull> conditionObject = SimpleConditionalExpression_TestForNull.class;
        boolean isNegated = nullExpr.isNegated();
        List values = null;
        return this.newTestNode(name, desc, item, conditionObject, isNegated, values, filterItemList);
    }

    @Override
    public FilterLogicTestNodeInterface newTestNode(String name, String desc, Object item, Object conditionObject, boolean isNegated, List values, FilterItemListInterface filterItemList) {
        return this.newTestNode(name, desc, item, null, conditionObject, isNegated, values, filterItemList);
    }

    public FilterLogicTestNodeInterface newTestNode(String name, String desc, Object item, List qualifiers, Object conditionObject, boolean isNegated, List values, FilterItemListInterface filterItemList) {
        FilterItemInterface filterLogicItem = this.findMatchingFilterItem(filterItemList, item);
        if (filterLogicItem == null) {
            return null;
        }
        List filterLogicQualifiers = qualifiers;
        FilterConditionInterface filterLogicCondition = this.findMatchingConditionObject(filterLogicItem, conditionObject, isNegated, qualifiers);
        if (filterLogicCondition == null) {
            return null;
        }
        String sasFormatText = DateAndTimeUtil.getFilterItemSASFormatText(filterLogicItem);
        long itemType = BaseFilterObjectFactory.getAdjustedFilterItemType(filterLogicItem);
        ArrayList<FilterValueInterface> valuesList = null;
        if (values != null) {
            valuesList = new ArrayList<FilterValueInterface>(values.size());
            for (Object v : values) {
                valuesList.add(this.createFilterValueFromNative(v, itemType, sasFormatText));
            }
            values = null;
        }
        DefaultFilterLogicTestNode testNode = new DefaultFilterLogicTestNode(filterLogicItem, filterLogicQualifiers, filterLogicCondition, valuesList);
        if (name != null) {
            testNode.setFilterLabel(name);
        }
        if (desc != null) {
            testNode.setFilterDescription(desc);
        }
        return testNode;
    }

    private FilterItemInterface getQualifierItemTemplate() {
        if (this.templateQualifierItem == null) {
            this.templateQualifierItem = new DefaultFilterItem("<Qualifying Measure Template>", this.getOLAPMeasureConditionList(), true, (List)null, (List)null);
            ((DefaultFilterItem)this.templateQualifierItem).setItemType(2L);
        }
        return this.templateQualifierItem;
    }

    public FilterQualifierListInterface getQualifiers(List items) {
        ArrayList<DefaultFilterQualifier> listOfItems = new ArrayList<DefaultFilterQualifier>();
        if (items == null) {
            return null;
        }
        for (DataItem dataItem : items) {
            if (dataItem == null) continue;
            DefaultFilterQualifier qualifier = null;
            String itemName = dataItem.getLabel();
            ExpressionInterface expression = dataItem.getExpression();
            if (expression instanceof Measure) {
                qualifier = new DefaultFilterQualifier(itemName + " <Measure Qualifier>", (Object)dataItem);
            }
            if (qualifier == null) continue;
            listOfItems.add(qualifier);
        }
        if (listOfItems.size() == 0) {
            return null;
        }
        DefaultFilterQualifierList result = new DefaultFilterQualifierList(listOfItems);
        return result;
    }

    public List getDataServiceValues(DataItem dataItem) {
        if (this._dataService == null) {
            this.log.debug("_DEBUG_: No data service to get values of " + dataItem.getLabel());
            return null;
        }
        List filterItemValues = null;
        filterItemValues = this.isOLAP() ? new DeferredRetrievalList(this._dataService, dataItem) : Collections.EMPTY_LIST;
        return filterItemValues;
    }

    public FilterValueInterface newFilterDataValue(PossibleFilterValue value) {
        String formattedValue = "";
        Object unformattedValue = null;
        Object data = null;
        int dataType = -1;
        if (value != null) {
            try {
                formattedValue = value.getFormatted();
                if (formattedValue != null) {
                    formattedValue = formattedValue.trim();
                }
            }
            catch (DataServicesException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            try {
                data = value.getUnformatted();
            }
            catch (DataServicesException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            dataType = data instanceof ExpressionInterface ? ((ExpressionInterface)data).getExpressionType() : value.getJDBCType();
        }
        Class<?> format = null;
        if (data != null) {
            format = data.getClass();
            unformattedValue = data instanceof AbstractTimeValueExpression ? ((AbstractTimeValueExpression)data).getExplicitDoubleValue() : data.toString();
        }
        DefaultFilterValue result = new DefaultFilterValue(data, formattedValue, dataType, format, unformattedValue);
        return result;
    }

    public FilterValueInterface newFilterDataValue(LookupValue value, DataItem dataItem) {
        String formattedValue = "";
        Object unformattedValue = null;
        Object data = null;
        int dataType = -1;
        if (value != null) {
            formattedValue = value.getFormattedValue();
            if (formattedValue != null) {
                formattedValue = formattedValue.trim();
            }
            if ((data = value.getUnformattedValue()) instanceof ExpressionInterface) {
                dataType = ((ExpressionInterface)data).getExpressionType();
            } else {
                dataType = dataItem.getExpressionTypeIgnoringFormattingForced();
                switch (dataType) {
                    case 2: 
                    case 3: {
                        data = BaseFilterObjectFactory.newConstantExpression(data.toString(), dataType);
                        break;
                    }
                    default: {
                        if (!".".equals(data)) break;
                        data = BaseFilterObjectFactory.newConstantExpression(".", dataType);
                    }
                }
            }
        }
        Class<?> format = null;
        if (data != null) {
            format = data.getClass();
            switch (dataType) {
                case 4: 
                case 5: 
                case 6: {
                    String doubleTxt = value.getUnformattedValue();
                    if (doubleTxt == null) break;
                    try {
                        Double timeVal = Double.valueOf(doubleTxt);
                        unformattedValue = timeVal;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                default: {
                    unformattedValue = data.toString();
                }
            }
            if (unformattedValue == null) {
                unformattedValue = data.toString();
            }
        }
        DefaultFilterValue result = new DefaultFilterValue(data, formattedValue, dataType, format, unformattedValue);
        return result;
    }

    @Override
    public List getFilterableItems(boolean includeBaseModels, Map filterItemLookup) {
        ArrayList<FilterItemInterface> listOfItems = new ArrayList<FilterItemInterface>();
        if (this._businessModel == null) {
            return listOfItems;
        }
        List items = this.getDataItems(includeBaseModels);
        if (items == null) {
            return listOfItems;
        }
        FilterQualifierListInterface qualifiers = this.getQualifiers(items);
        for (DataItem dataItem : items) {
            if (dataItem == null) continue;
            String msg = "";
            FilterItemInterface filterItem = null;
            String itemName = dataItem.getLabel();
            ExpressionInterface expression = dataItem.getExpression();
            if (expression != null) {
                filterItem = this.convertToFilterableItem(expression, itemName, dataItem, qualifiers);
                if (filterItem == null) {
                    msg = "Could not convert Expression to FilterItemInterface (expression=" + expression + ")";
                }
            } else {
                msg = "DataItem's Expression is null";
            }
            if (filterItem != null) {
                listOfItems.add(filterItem);
                if (filterItemLookup == null) continue;
                filterItemLookup.put(dataItem, filterItem);
                continue;
            }
            Class<?> itemClass = dataItem.getClass();
            String itemClassName = itemClass.getName();
            this.log.warn("_DEBUG_:###" + msg + ", class = " + itemClassName + " for " + itemName + " [" + dataItem + "]");
        }
        return listOfItems;
    }

    public FilterItemInterface convertToFilterableItem(Measure olapMeasure, String itemName, DataItem dataItem, FilterQualifierListInterface qualifiers) {
        DefaultFilterItem filterItem = null;
        filterItem = new DefaultFilterItem(itemName + " <Measure>", this.getOLAPMeasureConditionList(), true, (List)null, null);
        if (filterItem != null) {
            filterItem.setItem((Object)dataItem);
            if (qualifiers != null) {
                filterItem.setQualifierList(qualifiers);
                filterItem.setQualifiedItem(this.getQualifierItemTemplate());
            }
        }
        return filterItem;
    }

    public FilterItemInterface convertToFilterableItem(Member olapMember, String itemName, DataItem dataItem, FilterQualifierListInterface qualifiers) {
        DefaultFilterItem filterItem = null;
        int childrenCardinality = -1;
        try {
            childrenCardinality = olapMember.getChildrenCardinality();
        }
        catch (MetadataException me) {
            this.log.error("_DEBUG_: could not get Child Cardinality of Member=" + itemName, (Throwable)me);
        }
        this.log.debug("_DEBUG_:     " + itemName + ": Child Cardinality = " + childrenCardinality);
        List childMembers = null;
        if (childrenCardinality > 0) {
            try {
                childMembers = olapMember.getChildrenMembers();
            }
            catch (MetadataException me) {
                this.log.error("_DEBUG_: IGNORE: could not get Child Members of Member=" + itemName, (Throwable)me);
            }
            if (childMembers != null && childMembers.size() == 0) {
                childMembers = null;
            }
        }
        if (childMembers != null) {
            filterItem = new DefaultFilterItem(itemName + " <Member>", this.getOLAPMemberConditionList(), false, (List)null, childMembers);
            if (qualifiers != null) {
                filterItem.setQualifierList(qualifiers);
                filterItem.setQualifiedItem(this.getQualifierItemTemplate());
            }
        }
        if (filterItem != null) {
            filterItem.setItem((Object)dataItem);
        }
        return filterItem;
    }

    public FilterItemInterface convertToFilterableItem(Level olapLevel, String itemName, DataItem dataItem, FilterQualifierListInterface qualifiers) {
        DefaultFilterItem filterItem = null;
        List levelMembers = null;
        try {
            levelMembers = olapLevel.getMembers();
        }
        catch (MetadataException me) {
            this.log.error("_DEBUG_:### Could not get Members of Level=" + itemName, (Throwable)me);
            return null;
        }
        if (levelMembers != null && levelMembers.size() == 0) {
            levelMembers = null;
        }
        filterItem = new DefaultFilterItem(itemName + " <Level>", this.getOLAPMemberConditionList(), false, (List)null, levelMembers);
        if (qualifiers != null) {
            filterItem.setQualifierList(qualifiers);
            filterItem.setQualifiedItem(this.getQualifierItemTemplate());
        }
        if (filterItem != null) {
            filterItem.setItem((Object)dataItem);
        }
        return filterItem;
    }

    public FilterItemInterface convertToFilterableItem(Hierarchy olapHierarchy, String itemName, DataItem dataItem, FilterQualifierListInterface qualifiers) {
        DefaultFilterItem filterItem = null;
        List hierarchyLevels = null;
        try {
            hierarchyLevels = olapHierarchy.getLevels();
        }
        catch (MetadataException me) {
            this.log.error("_DEBUG_:### Could not get Levels of Hierarchy=" + itemName, (Throwable)me);
            return null;
        }
        if (hierarchyLevels != null && hierarchyLevels.size() == 0) {
            hierarchyLevels = null;
        }
        filterItem = new DefaultFilterItem(itemName + " <Hierarchy>", this.getOLAPMemberConditionList(), false, (List)null, hierarchyLevels);
        if (qualifiers != null) {
            filterItem.setQualifierList(qualifiers);
            filterItem.setQualifiedItem(this.getQualifierItemTemplate());
        }
        if (filterItem != null) {
            filterItem.setItem((Object)dataItem);
        }
        return filterItem;
    }

    public FilterItemInterface convertToFilterableItem(Dimension olapDimension, String itemName, DataItem dataItem, FilterQualifierListInterface qualifiers) {
        DefaultFilterItem filterItem = null;
        List dimensionHeirs = null;
        try {
            dimensionHeirs = olapDimension.getHierarchies();
        }
        catch (MetadataException me) {
            this.log.error("_DEBUG_:### Could not get Hierarchies of Dimension=" + itemName, (Throwable)me);
            return null;
        }
        if (dimensionHeirs != null && dimensionHeirs.size() == 0) {
            dimensionHeirs = null;
        }
        if (this.log.isDebugEnabled() && dimensionHeirs != null) {
            Object obj = dimensionHeirs.get(0);
            this.log.debug("_DEBUG_:  --- class of Dimension Hierarchy 1 = " + obj.getClass().getName());
            if (obj instanceof Hierarchy) {
                Hierarchy olapDimensionHierarchy = (Hierarchy)obj;
                try {
                    this.log.debug("_DEBUG_:  Dimension Hierarchy Name = " + olapDimensionHierarchy.getHierarchyCaption());
                }
                catch (MetadataException e) {
                    this.log.error("_DEBUG_: Error getting hierarchy info!", (Throwable)e);
                }
            }
        }
        filterItem = new DefaultFilterItem(itemName, this.getOLAPMemberConditionList(), false, (List)null, dimensionHeirs);
        if (qualifiers != null) {
            filterItem.setQualifierList(qualifiers);
            filterItem.setQualifiedItem(this.getQualifierItemTemplate());
        }
        if (filterItem != null) {
            filterItem.setItem((Object)dataItem);
        }
        return filterItem;
    }

    public FilterItemInterface convertToFilterableItem(StringExpression stringExpression, String itemName, DataItem dataItem, FilterQualifierListInterface qualifiers) {
        List dataValues;
        boolean isOlap = false;
        if (this._businessModel != null && this._businessModel.getStructure() != null) {
            isOlap = this._businessModel.getStructure().isOLAP();
        }
        if (this.log.isDebugEnabled()) {
            String msg = isOlap ? "<OLAP - StringExpression>" : "<Relational - StringExpression>";
            this.log.debug("_DEBUG_:   " + msg + " Name = " + BaseFilterObjectFactory.getExpressionUtilText((ExpressionInterface)stringExpression));
        }
        DefaultFilterItem filterItem = null;
        filterItem = new DefaultFilterItem(itemName, isOlap ? this.getOLAPMeasureConditionList() : this.getRelationalConditions((ExpressionInterface)stringExpression), true, (List)null, dataValues = this.getDataServiceValues(dataItem));
        if (filterItem != null) {
            filterItem.setItem((Object)dataItem);
            filterItem.setQualifierList(qualifiers);
        }
        return filterItem;
    }

    public FilterItemInterface convertToFilterableItem(Column columnItem, String itemName, DataItem dataItem, FilterQualifierListInterface qualifiers) {
        DefaultFilterItem filterItem = null;
        List dataValues = this.getDataServiceValues(dataItem);
        filterItem = new DefaultFilterItem(itemName, this.getRelationalConditions((ExpressionInterface)columnItem), true, (List)null, dataValues);
        if (filterItem != null) {
            filterItem.setItem((Object)dataItem);
            filterItem.setQualifierList(qualifiers);
        }
        return filterItem;
    }

    public FilterItemInterface convertToFilterableItem(ConstantExpression constantExpression, String itemName, DataItem dataItem, FilterQualifierListInterface qualifiers) {
        DefaultFilterItem filterItem = null;
        List dataValues = this.getDataServiceValues(dataItem);
        filterItem = new DefaultFilterItem(itemName + " <ConstantExpression>", this.getRelationalConditions((ExpressionInterface)constantExpression), true, (List)null, dataValues);
        if (filterItem != null) {
            filterItem.setItem((Object)dataItem);
            filterItem.setQualifierList(qualifiers);
        }
        return filterItem;
    }

    public FilterItemInterface convertToFilterableItem(FunctionCall functionCall, String itemName, DataItem dataItem, FilterQualifierListInterface qualifiers) {
        DefaultFilterItem filterItem = null;
        List dataValues = this.getDataServiceValues(dataItem);
        filterItem = new DefaultFilterItem(itemName + " <FunctionCall>", this.getRelationalConditions((ExpressionInterface)functionCall), true, (List)null, dataValues);
        if (filterItem != null) {
            filterItem.setItem((Object)dataItem);
            filterItem.setQualifierList(qualifiers);
        }
        return filterItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterItemInterface convertToFilterableItem(ExpressionInterface expression, String itemName, DataItem dataItem, FilterQualifierListInterface qualifiers) {
        FilterItemInterface filterItem;
        RootDataItem localItem;
        block48: {
            localItem = null;
            if (dataItem == null && !(expression instanceof ResourceAwareStringExpression)) {
                try {
                    localItem = this._businessModel.newDataItem();
                    localItem.setExpression(expression);
                    this._businessModel.addBusinessItem((BusinessItem)localItem);
                    dataItem = localItem;
                }
                catch (MetadataException me) {
                    this.log.error("_DEBUG_: Unable to create/init local DataItem: " + me.getMessage(), (Throwable)me);
                    return null;
                }
            }
            filterItem = null;
            try {
                Object itemClass;
                if (expression instanceof Measure) {
                    filterItem = this.convertToFilterableItem((Measure)expression, itemName, dataItem, qualifiers);
                } else if (expression instanceof Member) {
                    filterItem = this.convertToFilterableItem((Member)expression, itemName, dataItem, qualifiers);
                } else if (expression instanceof Level) {
                    filterItem = this.convertToFilterableItem((Level)expression, itemName, dataItem, qualifiers);
                } else if (expression instanceof Hierarchy) {
                    filterItem = this.convertToFilterableItem((Hierarchy)expression, itemName, dataItem, qualifiers);
                } else if (expression instanceof Dimension) {
                    filterItem = this.convertToFilterableItem((Dimension)expression, itemName, dataItem, qualifiers);
                } else if (expression instanceof StringExpression) {
                    filterItem = this.convertToFilterableItem((StringExpression)expression, itemName, dataItem, qualifiers);
                } else if (expression instanceof Column) {
                    filterItem = this.convertToFilterableItem((Column)expression, itemName, dataItem, qualifiers);
                } else if (expression instanceof ConstantExpression) {
                    filterItem = this.convertToFilterableItem((ConstantExpression)expression, itemName, dataItem, qualifiers);
                } else if (expression instanceof FunctionCall) {
                    filterItem = this.convertToFilterableItem((FunctionCall)expression, itemName, dataItem, qualifiers);
                } else if (!(expression instanceof CompoundConditionalExpression || expression instanceof SimpleConditionalExpression_In || expression instanceof SimpleConditionalExpression_Between || expression instanceof SimpleConditionalExpression_Comparison || expression instanceof SimpleConditionalExpression_TestForNull || expression instanceof ConditionalExpression || !this.log.isDebugEnabled())) {
                    itemClass = expression.getClass();
                    String itemClassName = ((Class)itemClass).getName();
                    this.log.error("_DEBUG_:###  Unknown Expression class = " + itemClassName + " for " + itemName + " [" + dataItem + "]");
                }
                if (dataItem != null) {
                    this.setFilterItemProperties(filterItem, dataItem);
                } else if (expression instanceof ResourceAwareStringExpression) {
                    this.setFilterItemProperties(filterItem, (ResourceAwareStringExpression)expression);
                }
                if (localItem == null) {
                    itemClass = filterItem;
                    return itemClass;
                }
                if (filterItem == null) break block48;
                try {
                    FilterValuesInterface valueList = filterItem.getActualValues();
                    if (valueList != null && valueList instanceof DeferredRetrievalList) {
                        ((DeferredRetrievalList)valueList).retrieve();
                        ((DeferredRetrievalList)valueList)._dataItem = null;
                    }
                    if ((valueList = filterItem.getPossibleValues()) != null) {
                        if (valueList instanceof DeferredRetrievalList) {
                            ((DeferredRetrievalList)valueList).retrieve();
                            ((DeferredRetrievalList)valueList)._dataItem = null;
                        } else {
                            valueList.getFirstValues(0L);
                        }
                    }
                }
                catch (DataRetrievalError e) {
                    if (filterItem instanceof DefaultFilterItem) {
                        ((DefaultFilterItem)filterItem).setActualValues((Collection)null);
                        ((DefaultFilterItem)filterItem).setPossibleValues((Collection)null);
                    }
                    throw e;
                }
                finally {
                    if (filterItem instanceof DefaultFilterItem) {
                        ((DefaultFilterItem)filterItem).setItem((Object)dataItem.getExpression());
                    }
                }
            }
            finally {
                if (localItem != null) {
                    try {
                        this._businessModel.removeBusinessItem((BusinessItem)localItem);
                    }
                    catch (MetadataException e) {
                        this.log.error("_DEBUG_:Unable to remove temporary DataItem from BusinessModel:\n  IntraModelID=" + localItem.getIntraModelID(), (Throwable)e);
                    }
                }
            }
        }
        localItem = null;
        dataItem = null;
        return filterItem;
    }

    protected void setFilterItemProperties(FilterItemInterface filterItem, DataItem dataItem) {
        if (filterItem != null && dataItem != null && filterItem instanceof DefaultFilterItem) {
            FilterValueFormatter formatter;
            DefaultFilterItem editableItem = (DefaultFilterItem)filterItem;
            int expType = dataItem.getExpressionType();
            expType = dataItem.getExpressionTypeIgnoringFormattingForced();
            editableItem.setItemType((long)expType);
            String sasFormatText = dataItem.getFormat();
            switch (expType) {
                case 4: 
                case 5: 
                case 6: {
                    formatter = new FilterValueFormatter(sasFormatText, expType, DateAndTimeUtil.GMT_ZONE);
                    formatter.setFormatter(RelativeTimeFilterData.class, (Format)new RelativeTimeFilterValueFormatter(this._locale));
                    editableItem.setUserValueFormatter((Format)formatter);
                    break;
                }
            }
            if (this.isOLAP() && this.isTimeDimension(dataItem)) {
                editableItem.setItemType(6L);
                formatter = new FilterValueFormatter(sasFormatText, expType, DateAndTimeUtil.GMT_ZONE);
                formatter.setFormatter(OLAPTimeBasedFilterAdapter.class, (Format)new RelativeTimeFilterValueFormatter(this._locale));
                editableItem.setUserValueFormatter((Format)formatter);
            }
        }
    }

    protected void setFilterItemProperties(FilterItemInterface filterItem, ResourceAwareStringExpression expression) {
        if (filterItem != null && expression != null && filterItem instanceof DefaultFilterItem) {
            DefaultFilterItem editableItem = (DefaultFilterItem)filterItem;
            int expType = expression.getExpressionType();
            editableItem.setItemType((long)expType);
            switch (expType) {
                case 4: 
                case 5: 
                case 6: {
                    FilterValueFormatter formatter = new FilterValueFormatter(null, expType, DateAndTimeUtil.GMT_ZONE);
                    formatter.setFormatter(RelativeTimeFilterData.class, (Format)new RelativeTimeFilterValueFormatter(this._locale));
                    editableItem.setUserValueFormatter((Format)formatter);
                    break;
                }
            }
        }
    }

    public FilterConditionListInterface getRelationalConditions(ExpressionInterface expression) {
        return this.getRelationalConditions(expression, false);
    }

    public FilterConditionListInterface getRelationalConditions(DataItem item) {
        return this.getRelationalConditions((ExpressionInterface)item, item.isFormattingForced());
    }

    public FilterConditionListInterface getRelationalConditions(ExpressionInterface expression, boolean forcedFormatting) {
        DefaultFilterConditionList model = new DefaultFilterConditionList();
        if (expression != null) {
            FilterConditionInterface[] conditions = null;
            this.log.debug("_DEBUG_:Expression type: " + expression.getExpressionType());
            switch (expression.getExpressionType()) {
                case 3: {
                    conditions = this.getRelationalCharacterConditions(forcedFormatting);
                    break;
                }
                case 0: {
                    conditions = this.getRelationalConditions(forcedFormatting);
                    break;
                }
                default: {
                    conditions = this.getRelationalNumericConditions(forcedFormatting);
                }
            }
            model.setConditionList(Arrays.asList(conditions));
        }
        return model;
    }

    public FilterConditionInterface[] getRelationalConditions(boolean forcedFormatting) {
        FilterConditionInterface[] conditions = forcedFormatting ? new FilterConditionInterface[]{this.IS_EQUALS, this.IS_NOT_EQUALS, this.IS_IN_LIST, this.IS_NOT_IN_LIST, this.IS_LESS_THAN, this.IS_LESS_THAN_OR_EQUAL, this.IS_GREATER_THAN, this.IS_GREATER_THAN_OR_EQUAL, this.IS_BETWEEN, this.IS_NOT_BETWEEN} : new FilterConditionInterface[]{this.IS_EQUALS, this.IS_NOT_EQUALS, this.IS_IN_LIST, this.IS_NOT_IN_LIST, this.IS_LESS_THAN, this.IS_LESS_THAN_OR_EQUAL, this.IS_GREATER_THAN, this.IS_GREATER_THAN_OR_EQUAL, this.IS_BETWEEN, this.IS_NOT_BETWEEN, this.IS_NULL, this.IS_NOT_NULL};
        return conditions;
    }

    public FilterConditionInterface[] getRelationalCharacterConditions(boolean forcedFormatting) {
        return this.getRelationalConditions(forcedFormatting);
    }

    public FilterConditionInterface[] getRelationalNumericConditions(boolean forcedFormatting) {
        return this.getRelationalConditions(forcedFormatting);
    }

    public FilterConditionListInterface getOLAPMeasureConditionList() {
        Object[] conditionsAll = new Object[]{this.IS_EQUALS, this.IS_NOT_EQUALS, this.IS_IN_LIST, this.IS_NOT_IN_LIST, this.IS_LESS_THAN, this.IS_LESS_THAN_OR_EQUAL, this.IS_GREATER_THAN, this.IS_GREATER_THAN_OR_EQUAL, this.IS_BETWEEN, this.IS_NOT_BETWEEN, this.IS_NULL, this.IS_NOT_NULL};
        DefaultFilterConditionList model = new DefaultFilterConditionList();
        model.setConditionList(Arrays.asList(conditionsAll));
        return model;
    }

    public FilterConditionListInterface getOLAPMemberConditionList() {
        Object[] conditionsWithOnlyEquivalence = new Object[]{this.IS_EQUALS, this.IS_NOT_EQUALS, this.IS_IN_LIST, this.IS_NOT_IN_LIST};
        DefaultFilterConditionList model = new DefaultFilterConditionList();
        model.setConditionList(Arrays.asList(conditionsWithOnlyEquivalence));
        return model;
    }

    public FilterItemInterface createFilterItemFromNative(Object data, FilterItemListInterface fili) {
        FilterItemInterface newItem = null;
        if (data != null) {
            if (data instanceof FilterItemInterface) {
                return (FilterItemInterface)data;
            }
            if (fili != null && (newItem = this.findMatchingFilterItem(fili, data)) != null) {
                return newItem;
            }
            ExpressionInterface expression = null;
            String itemName = null;
            DataItem dataItem = null;
            FilterQualifierListInterface qualifiers = null;
            if (data instanceof FilterValueInterface) {
                FilterValueInterface filterValue = (FilterValueInterface)data;
                if (filterValue.getData() instanceof ExpressionInterface) {
                    expression = (ExpressionInterface)filterValue.getData();
                }
                itemName = filterValue.getFormattedValue();
                if (expression instanceof DataItem) {
                    dataItem = (DataItem)expression;
                }
            } else if (data instanceof DataItem) {
                dataItem = (DataItem)data;
                expression = dataItem.getExpression();
                itemName = dataItem.getLabel();
            } else if (data instanceof ExpressionInterface) {
                expression = (ExpressionInterface)data;
                itemName = BaseFilterObjectFactory.getExpressionUtilText(expression);
            }
            if (expression != null) {
                newItem = this.convertToFilterableItem(expression, itemName, dataItem, qualifiers);
            }
        }
        return newItem;
    }

    public FilterItemInterface convertToFilterItem(Object item, DataItem dataItem, FilterItemListInterface filterItemList) {
        FilterItemInterface newItem = this.createFilterItemFromNative(item, filterItemList);
        return newItem;
    }

    @Override
    public int getMaxOutputObservations() {
        return this._governingLimit;
    }

    @Override
    public void setMaxOutputObservations(int max) {
        this._governingLimit = max;
    }

    @Override
    public void setLocale(Locale locale) {
        if (this._locale != locale) {
            this._locale = locale;
            this._dateAndTimeUtil.setLocale(locale);
            FilterConditionInterface[] conditionsAll = new FilterConditionInterface[]{this.IS_AFTER, this.IS_AFTER_OR_EQUAL, this.IS_BEFORE, this.IS_BEFORE_OR_EQUAL, this.IS_BETWEEN, this.IS_EQUALS, this.IS_GREATER_THAN, this.IS_GREATER_THAN_OR_EQUAL, this.IS_IN_LIST, this.IS_LESS_THAN, this.IS_LESS_THAN_OR_EQUAL, this.IS_NOT_BETWEEN, this.IS_NOT_EQUALS, this.IS_NOT_IN_LIST, this.IS_NOT_NULL, this.IS_NULL};
            for (int i = 0; i < conditionsAll.length; ++i) {
                conditionsAll[i].setLocale(locale);
            }
        }
    }

    @Override
    public Locale getLocale() {
        return this._locale;
    }

    protected static long getAdjustedFilterItemType(FilterItemInterface item) {
        long type = 0L;
        if (item != null) {
            type = item.getItemType();
        }
        return type;
    }

    public ExpressionInterface createExpressionFromNative(Object nativeObject, int expressionType) {
        return this.createExpressionFromNative(nativeObject, expressionType, true);
    }

    public ExpressionInterface createExpressionFromNative(Object nativeObject, int expressionType, boolean userCreated) {
        ConstantExpression expression = null;
        Locale locale = this.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (nativeObject != null) {
            if (nativeObject instanceof ExpressionInterface) {
                expression = (ExpressionInterface)nativeObject;
            } else if (nativeObject instanceof RelativeTimeFilterData) {
                expression = IQRelativeTimeFilterUtil.generateExpressionFromValue((RelativeTimeFilterData)nativeObject, expressionType);
            } else {
                switch (expressionType) {
                    case 4: {
                        DateValueExpression timeExpression = new DateValueExpression();
                        if (nativeObject instanceof Double) {
                            Double timeVal = (Double)nativeObject;
                            Date newDate = this._dateAndTimeUtil.createJavaDateFromSASDate(timeVal);
                            timeExpression.setValue(newDate);
                            timeExpression.setExplicitDoubleValue(timeVal);
                        } else {
                            Date date = BaseFilterObjectFactory.getDateOrNullFromNative(nativeObject, expressionType, locale);
                            timeExpression.setValue(date);
                        }
                        expression = timeExpression;
                        break;
                    }
                    case 5: {
                        TimeValueExpression timeExpression = new TimeValueExpression();
                        if (nativeObject instanceof Double) {
                            Double timeVal = (Double)nativeObject;
                            Date newDate = this._dateAndTimeUtil.createJavaDateFromSASTime(timeVal);
                            timeExpression.setValue(newDate);
                            timeExpression.setExplicitDoubleValue(timeVal);
                        } else {
                            Date date = BaseFilterObjectFactory.getDateOrNullFromNative(nativeObject, expressionType, locale);
                            timeExpression.setValue(date);
                        }
                        expression = timeExpression;
                        break;
                    }
                    case 6: {
                        TimestampValueExpression timeExpression = new TimestampValueExpression();
                        if (nativeObject instanceof Double) {
                            Double timeVal = (Double)nativeObject;
                            Date newDate = this._dateAndTimeUtil.createJavaDateFromSASDateTime(timeVal);
                            timeExpression.setValue(newDate);
                            timeExpression.setExplicitDoubleValue(timeVal);
                        } else {
                            Date date = BaseFilterObjectFactory.getDateOrNullFromNative(nativeObject, expressionType, locale);
                            timeExpression.setValue(date);
                        }
                        expression = timeExpression;
                        break;
                    }
                    case 3: 
                    case 11: {
                        if (userCreated) {
                            expression = BaseFilterObjectFactory.newStringExpression(nativeObject.toString(), expressionType);
                            break;
                        }
                        expression = BaseFilterObjectFactory.newConstantExpression(nativeObject.toString(), expressionType);
                        break;
                    }
                    default: {
                        if (userCreated) {
                            expression = BaseFilterObjectFactory.newStringExpression(nativeObject.toString(), expressionType);
                            break;
                        }
                        expression = BaseFilterObjectFactory.newConstantExpression(nativeObject.toString(), expressionType);
                        break;
                    }
                }
            }
        } else {
            expression = BaseFilterObjectFactory.newConstantExpression(null, expressionType);
        }
        return expression;
    }

    public Date createJavaDateFromSASDate(double value) {
        return this._dateAndTimeUtil.createJavaDateFromSASDate(value);
    }

    public Date createJavaDateFromSASTime(double value) {
        return this._dateAndTimeUtil.createJavaDateFromSASTime(value);
    }

    public Date createJavaDateFromSASDateTime(double value) {
        return this._dateAndTimeUtil.createJavaDateFromSASDateTime(value);
    }

    public static Date getDateOrNullFromNative(Object nativeObject, int expressionType, Locale locale) {
        if (nativeObject instanceof Date) {
            return (Date)nativeObject;
        }
        TimeZone timezone = DateAndTimeUtil.GMT_ZONE;
        Date date = null;
        if (nativeObject != null) {
            String text = nativeObject.toString();
            try {
                String sasFormatText = StringExpressionUtil.getDefaultSASFormatText((int)expressionType);
                date = StringExpressionUtil.parseDateFromString((String)text, (String)sasFormatText, (Locale)locale, (TimeZone)timezone);
            }
            catch (ParseException e) {
                date = null;
            }
            if (date == null) {
                try {
                    DateFormat dateFormatter = null;
                    switch (expressionType) {
                        case 4: {
                            dateFormatter = DateFormat.getDateInstance(2, locale);
                            break;
                        }
                        case 5: {
                            dateFormatter = DateFormat.getTimeInstance(2, locale);
                            break;
                        }
                        default: {
                            dateFormatter = DateFormat.getDateTimeInstance(2, 2, locale);
                        }
                    }
                    date = StringExpressionUtil.parseDateFromString((String)text, (DateFormat)dateFormatter, (TimeZone)timezone);
                }
                catch (ParseException e) {
                    Class<?> itemClass = nativeObject.getClass();
                    String itemClassName = itemClass.getName();
                    LoggerRepository2.getLogger((String)BaseFilterObjectFactory.class.getName(), null).warn("_DEBUG_:### PARSE FAILURE class = " + itemClassName + " for type " + expressionType + " [" + nativeObject + "]");
                    LoggerRepository2.getLogger((String)BaseFilterObjectFactory.class.getName(), null).error(e.getMessage(), (Throwable)e);
                    date = null;
                }
            }
        }
        return date;
    }

    public void wrapValueListDates(FilterLogicTestNodeInterface testNode) {
        if (testNode != null && testNode.getTestValuesList() != null) {
            List values = testNode.getTestValuesList();
            for (int i = 0; i < values.size(); ++i) {
                Object o = values.get(i);
                if (!(o instanceof Date)) continue;
                FilterItemInterface item = testNode.getFilterItem();
                long type = BaseFilterObjectFactory.getAdjustedFilterItemType(item);
                String sasFormatText = DateAndTimeUtil.getFilterItemSASFormatText(item);
                o = this.createFilterValueFromNative(o, type, sasFormatText);
                values.set(i, o);
            }
        }
    }

    protected static String getFilterItemSASFormatText(Object item) {
        return DateAndTimeUtil.getFilterItemSASFormatText(item);
    }

    public void setFilterBaseModelData(FilterBaseModelData baseModel) {
        if (this._baseModel != baseModel) {
            if (this._baseModel != null) {
                this._baseModel.releaseResources();
            }
            this._baseModel = baseModel;
        }
    }

    public MetadataInterface getMetadataInterface() throws FilterException {
        MetadataInterface metadata = null;
        if (this._baseModel != null) {
            metadata = this._baseModel.createMetadata();
        }
        return metadata;
    }

    public void releaseResources() {
        if (this._baseModel != null) {
            this._baseModel.releaseResources();
        }
    }

    public Map getLevelProperties(OLAPDataSetInterface model, DataItem di) throws OLAPException {
        return this.getLevelProperties(model.getDatabaseMetadata(), di, model.getCubeName());
    }

    public Map getLevelProperties(MetadataInterface metadata, DataItem di) throws OLAPException {
        String cubeName = this.getCubeName(di);
        return this.getLevelProperties(metadata, di, cubeName);
    }

    public Map getLevelProperties(MetadataInterface metadata, DataItem di, String cubeName) throws OLAPException {
        HashMap levelPropMap = null;
        String hierarchyName = this.getHierarchyName(di);
        if (hierarchyName != null) {
            levelPropMap = new HashMap();
            Filter f = new Filter();
            f.setCubeName(cubeName);
            f.setUniqueHierarchyName(hierarchyName);
            PropertyInterface[] properties = metadata.getProperties(f);
            for (int i = 0; i < properties.length; ++i) {
                LevelInterface l = properties[i].getLevel();
                List propList = !levelPropMap.containsKey(l) ? new ArrayList() : (List)levelPropMap.get(l);
                propList.add(properties[i]);
                levelPropMap.put(l, propList);
            }
        }
        return levelPropMap;
    }

    private String getHierarchyName(DataItem di) {
        String hierName = null;
        try {
            ExpressionInterface ex = di.getExpression();
            if (di.getStructure() == StructureOfDataItem.STRUCTURE_HIERARCHY && ex instanceof Hierarchy) {
                hierName = ((Hierarchy)ex).getHierarchyUniqueName();
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return hierName;
    }

    private String getCubeName(DataItem di) {
        String name = null;
        ExpressionInterface ex = di.getExpression();
        if (ex instanceof OlapItem) {
            try {
                name = ((OlapItem)ex).getCubeName();
            }
            catch (MetadataException metadataException) {}
        } else {
            BusinessModel bm = di.getBusinessModel();
            try {
                name = BusinessQueryOLAPUtil.getCubeName((BusinessModel)bm, (DataItem)di);
            }
            catch (MetadataException metadataException) {
                // empty catch block
            }
        }
        return name;
    }

    protected boolean isTimeDimension(DataItem item) {
        try {
            return IQUeryUtil.isTimeDimension(this._businessModel, item);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(int environment) {
        this.environment = environment;
    }

    public static DataItem getDataItem(FilterItemInterface filterItem) {
        DataItem dataItem = null;
        if (filterItem != null) {
            Object item = filterItem.getItem();
            if (item instanceof DataItemFormattingExpression) {
                dataItem = ((DataItemFormattingExpression)item).getDataItem();
                item = dataItem;
            } else if (item instanceof DataItemReference) {
                dataItem = ((DataItemReference)item).getBaseDataItem();
            } else if (item instanceof DataItem) {
                dataItem = (DataItem)item;
            }
        }
        return dataItem;
    }

    private List createValueItemListFromMemberNameList(List memberNames, FilterItemInterface filterItem) {
        ArrayList<ValueItem> valueList = null;
        DataItem dataItem = BaseFilterObjectFactory.getDataItem(filterItem);
        if (memberNames != null && dataItem != null) {
            valueList = new ArrayList<ValueItem>(memberNames.size());
            for (Object o : memberNames) {
                try {
                    String name = ((StringExpression)o).getText();
                    ValueItem value = BaseFilterObjectFactory.createValueItemFromUniqueMemberID(dataItem, name);
                    valueList.add(value);
                }
                catch (OLAPException oLAPException) {
                }
                catch (MetadataException metadataException) {}
            }
        }
        return valueList;
    }

    public static ValueItem createValueItemFromUniqueMemberID(DataItem dataItem, String memberName) throws MetadataException, OLAPException {
        BusinessModel bm = dataItem.getBusinessModel();
        MetadataInterface metadata = null;
        try {
            metadata = BusinessQueryOLAPUtil.getMetadataInterface((Object)bm);
            String cubeName = BusinessQueryOLAPUtil.getCubeName((BusinessModel)bm, (DataItem)dataItem);
            Filter f = new Filter();
            f.setCubeName(cubeName);
            f.setUniqueMemberName(memberName);
            MemberInterface[] members = metadata.getMembers(f, 0, 1);
            if (members != null && members.length > 0) {
                ValueItem valueItem = BaseFilterObjectFactory.createValueItem(members[0]);
                return valueItem;
            }
        }
        catch (IQueryServicesException ie) {
            throw new MetadataException((Throwable)ie, ie.getMessage());
        }
        finally {
            if (metadata != null) {
                BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)metadata);
            }
        }
        return null;
    }

    public static ValueItem createValueItem(TupleElementInterface tupleElement) throws OLAPException {
        ValueItem vi;
        if (tupleElement == null) {
            vi = null;
        } else {
            vi = new ValueItem((Object)tupleElement.getLabel(), (Object)tupleElement.getName());
            List path = Collections.EMPTY_LIST;
            if (tupleElement.getLevelDepth() > 1) {
                path = ValueProviderUtil.splitOLAPName((String)tupleElement.getName());
            }
            vi.setAttribute(ValueItem.PARENT, (Object)path);
        }
        return vi;
    }

    private static ValueItem createValueItem(MemberInterface member) throws OLAPException {
        ValueItem vi;
        if (member == null) {
            vi = null;
        } else {
            vi = new ValueItem((Object)member.getLabel(), (Object)member.getUniqueName());
            List path = Collections.EMPTY_LIST;
            if (member.getLevel().getDepth() >= 1) {
                path = ValueProviderUtil.splitOLAPName((String)member.getUniqueName());
            }
            vi.setAttribute(ValueItem.PARENT, (Object)path);
        }
        return vi;
    }

    class FilterValueFormatter
    extends Format
    implements FilterValueFormatProvider {
        Format _formatter = null;
        Map _formatMap = null;
        String _sasFormatText = null;
        int _expType = 0;
        Locale _locale = null;
        TimeZone _timezone = null;

        FilterValueFormatter(Format format) {
            this._formatter = format;
            this._formatMap = new HashMap(2);
        }

        FilterValueFormatter(String sasFormatText, int expType) {
            this(sasFormatText, expType, TimeZone.getDefault());
        }

        FilterValueFormatter(String sasFormatText, int expType, TimeZone timezone) {
            this(sasFormatText, expType, null, timezone);
        }

        FilterValueFormatter(String sasFormatText, int expType, Locale locale, TimeZone timezone) {
            this._sasFormatText = sasFormatText;
            this._expType = expType;
            this._locale = locale;
            this._timezone = timezone;
            this._formatMap = new HashMap(2);
        }

        Object getObjectToFormat(Object input) {
            if (input instanceof FilterValueInterface) {
                FilterValueInterface filterValue = (FilterValueInterface)input;
                Object unformattedValue = filterValue.getUnformattedValue();
                input = unformattedValue instanceof RelativeTimeFilterData ? unformattedValue : ((FilterValueInterface)input).getData();
            }
            if (input instanceof ValueItem) {
                ValueItem valueItem = (ValueItem)input;
                input = valueItem.getValue();
            }
            if (input instanceof AbstractTimeValueExpression) {
                input = ((AbstractTimeValueExpression)input).getValue();
            }
            return input;
        }

        public void setFormatter(Class className, Format format) {
            this._formatMap.put(className, format);
        }

        public Format getFormatter(Class className) {
            return (Format)this._formatMap.get(className);
        }

        synchronized Format getFormatter() {
            SASFormat formatter;
            if (this._formatter != null) {
                return this._formatter;
            }
            Locale locale = this._locale;
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if ((formatter = StringExpressionUtil.getSASFormat((String)this._sasFormatText, (Locale)locale)) == null) {
                String sasFormatText = StringExpressionUtil.getDefaultSASFormatText((int)this._expType);
                formatter = StringExpressionUtil.getSASFormat((String)sasFormatText, (Locale)locale);
            }
            return formatter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            StringBuffer buf;
            StringExpressionUtil stringExpressionUtil = _stringExpressionUtil;
            synchronized (stringExpressionUtil) {
                Format format = null;
                if (obj instanceof ValueItem && BaseFilterObjectFactory.this.isOLAP()) {
                    String formattedValue = ((ValueItem)obj).getLabel().toString().trim();
                    return toAppendTo.append(formattedValue);
                }
                Object objectToFormat = this.getObjectToFormat(obj);
                if (objectToFormat != null) {
                    format = this.getFormatter(objectToFormat.getClass());
                }
                if (format != null) {
                    buf = format.format(objectToFormat, toAppendTo, pos);
                } else {
                    format = this.getFormatter();
                    if (format instanceof SASDateTimeFormat) {
                        SASDateTimeFormat formatter = (SASDateTimeFormat)format;
                        Class<SASDateTimeFormat> clazz = SASDateTimeFormat.class;
                        synchronized (SASDateTimeFormat.class) {
                            TimeZone timezone = this._timezone;
                            if (timezone == null) {
                                timezone = TimeZone.getDefault();
                            }
                            TimeZone save = formatter.getTimeZone();
                            try {
                                formatter.setTimeZone(timezone);
                                if (objectToFormat instanceof Date && formatter.isTimeFormat()) {
                                    objectToFormat = TimeValueExpression.newTimeOnlyValue((Date)((Date)objectToFormat));
                                }
                                buf = formatter.format(objectToFormat, toAppendTo, pos);
                            }
                            finally {
                                formatter.setTimeZone(save);
                            }
                            // ** MonitorExit[var9_10] (shouldn't be in output)
                        }
                    }
                    buf = format.format(objectToFormat, toAppendTo, pos);
                }
                {
                }
            }
            return buf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object parseObject(String source, ParsePosition pos) {
            Object obj;
            StringExpressionUtil stringExpressionUtil = _stringExpressionUtil;
            synchronized (stringExpressionUtil) {
                Format format = this.getFormatter();
                if (format instanceof SASDateTimeFormat) {
                    SASDateTimeFormat formatter = (SASDateTimeFormat)format;
                    Class<SASDateTimeFormat> clazz = SASDateTimeFormat.class;
                    synchronized (SASDateTimeFormat.class) {
                        TimeZone timezone = this._timezone;
                        if (timezone == null) {
                            timezone = TimeZone.getDefault();
                        }
                        TimeZone save = formatter.getTimeZone();
                        try {
                            formatter.setTimeZone(timezone);
                            obj = formatter.parseObject(source, pos);
                        }
                        finally {
                            formatter.setTimeZone(save);
                        }
                        // ** MonitorExit[var7_6] (shouldn't be in output)
                    }
                }
                obj = format.parseObject(source, pos);
                {
                }
            }
            return obj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AttributedCharacterIterator formatToCharacterIterator(Object obj) {
            AttributedCharacterIterator iter;
            StringExpressionUtil stringExpressionUtil = _stringExpressionUtil;
            synchronized (stringExpressionUtil) {
                Format format = this.getFormatter();
                if (format instanceof SASDateTimeFormat) {
                    SASDateTimeFormat formatter = (SASDateTimeFormat)format;
                    Class<SASDateTimeFormat> clazz = SASDateTimeFormat.class;
                    synchronized (SASDateTimeFormat.class) {
                        TimeZone timezone = this._timezone;
                        if (timezone == null) {
                            timezone = TimeZone.getDefault();
                        }
                        TimeZone save = formatter.getTimeZone();
                        try {
                            formatter.setTimeZone(timezone);
                            iter = formatter.formatToCharacterIterator(this.getObjectToFormat(obj));
                        }
                        finally {
                            formatter.setTimeZone(save);
                        }
                        // ** MonitorExit[var6_5] (shouldn't be in output)
                    }
                }
                iter = format.formatToCharacterIterator(this.getObjectToFormat(obj));
                {
                }
            }
            return iter;
        }
    }

    class DeferredRetrievalList
    implements List {
        boolean _isRetrieved = false;
        List _retrievedValues = null;
        IQDataServices _dataService;
        DataItem _dataItem;

        DeferredRetrievalList() {
            this._dataItem = null;
            this._dataService = null;
        }

        public DeferredRetrievalList(IQDataServices dataService, DataItem dataItem) {
            this._dataService = dataService;
            this._dataItem = dataItem;
        }

        public boolean isRetrieved() {
            return this._isRetrieved;
        }

        private DataItem createNonAggregatedCopy(BusinessModel model, DataItem item) {
            RootDataItem copy;
            try {
                copy = model.newDataItem();
                copy.setExpression(item.getExpression());
                copy.setFormat(item.getFormat());
                copy.setUsage(item.getUsage());
                copy.setFormattingForced(false);
            }
            catch (MetadataException e) {
                BaseFilterObjectFactory.this.log.error(e.getMessage(), (Throwable)e);
                copy = null;
            }
            return copy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void retrieve() throws DataRetrievalError {
            List dataServiceValues;
            block12: {
                if (this.isRetrieved()) {
                    return;
                }
                this._retrievedValues = new ArrayList();
                this._isRetrieved = true;
                dataServiceValues = null;
                try {
                    Governing governor = BaseFilterObjectFactory.this._businessModel.newGoverning();
                    governor.setOutputObservations(BaseFilterObjectFactory.this._governingLimit);
                    DataItem queryItem = this.createNonAggregatedCopy(BaseFilterObjectFactory.this._businessModel, this._dataItem);
                    if (queryItem == null) {
                        dataServiceValues = this._dataService.getPossibleFilterValues(this._dataItem, governor);
                        break block12;
                    }
                    BaseFilterObjectFactory.this._businessModel.addBusinessItem((BusinessItem)queryItem);
                    try {
                        dataServiceValues = this._dataService.getPossibleFilterValues(queryItem, governor);
                    }
                    finally {
                        BaseFilterObjectFactory.this._businessModel.removeBusinessItem((BusinessItem)queryItem);
                    }
                }
                catch (DataServicesException e) {
                    BaseFilterObjectFactory.this.log.error("_DEBUG_:### Could not get values for " + this._dataItem.getLabel() + ", " + e.getMessage(), (Throwable)e);
                    throw new DataRetrievalError(RB.getStringResource((String)BaseFilterObjectFactory.RB_KEY, (String)"ErrorGettingValues.txt", (Locale)BaseFilterObjectFactory.this._locale), (Throwable)e);
                }
                catch (MetadataException e) {
                    throw new DataRetrievalError(RB.getStringResource((String)BaseFilterObjectFactory.RB_KEY, (String)"ErrorGettingValues.txt", (Locale)BaseFilterObjectFactory.this._locale), (Throwable)e);
                }
                catch (Exception e) {
                    throw new DataRetrievalError(RB.getStringResource((String)BaseFilterObjectFactory.RB_KEY, (String)"ErrorGettingValues.txt", (Locale)BaseFilterObjectFactory.this._locale), (Throwable)e);
                }
            }
            if (dataServiceValues != null) {
                BaseFilterObjectFactory.this.log.debug("_DEBUG_: Number of actual values for  " + this._dataItem.getLabel() + " = " + dataServiceValues.size());
                Iterator it = dataServiceValues.iterator();
                PossibleFilterValue fvalue = null;
                while (it.hasNext()) {
                    fvalue = (PossibleFilterValue)it.next();
                    FilterValueInterface foo = BaseFilterObjectFactory.this.newFilterDataValue(fvalue);
                    this._retrievedValues.add(foo);
                }
            } else {
                BaseFilterObjectFactory.this.log.warn("_DEBUG_:### No support for values of " + this._dataItem.getLabel());
            }
        }

        @Override
        public Iterator iterator() {
            return new DeferredIterator();
        }

        public ListIterator listIterator() {
            return new DeferredListIterator();
        }

        public ListIterator listIterator(int index) {
            return new DeferredListIterator(index);
        }

        @Override
        public int size() {
            this.retrieve();
            return this._retrievedValues.size();
        }

        @Override
        public boolean isEmpty() {
            this.retrieve();
            return this._retrievedValues.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            this.retrieve();
            return this._retrievedValues.contains(o);
        }

        @Override
        public Object[] toArray() {
            this.retrieve();
            return this._retrievedValues.toArray();
        }

        @Override
        public Object[] toArray(Object[] a) {
            this.retrieve();
            return this._retrievedValues.toArray(a);
        }

        @Override
        public boolean add(Object o) {
            this.retrieve();
            return this._retrievedValues.add(o);
        }

        @Override
        public boolean remove(Object o) {
            this.retrieve();
            return this._retrievedValues.remove(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            this.retrieve();
            return this._retrievedValues.containsAll(c);
        }

        @Override
        public boolean addAll(Collection c) {
            this.retrieve();
            return this._retrievedValues.addAll(c);
        }

        public boolean addAll(int index, Collection c) {
            this.retrieve();
            return this._retrievedValues.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection c) {
            this.retrieve();
            return this._retrievedValues.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            this.retrieve();
            return this._retrievedValues.retainAll(c);
        }

        @Override
        public boolean equals(Object o) {
            this.retrieve();
            return this._retrievedValues.equals(o);
        }

        @Override
        public int hashCode() {
            this.retrieve();
            return this._retrievedValues.hashCode();
        }

        public Object get(int index) {
            this.retrieve();
            return this._retrievedValues.get(index);
        }

        public Object set(int index, Object element) {
            this.retrieve();
            return this._retrievedValues.set(index, element);
        }

        public Object remove(int index) {
            this.retrieve();
            return this._retrievedValues.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            this.retrieve();
            return this._retrievedValues.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            this.retrieve();
            return this._retrievedValues.lastIndexOf(o);
        }

        public List subList(int fromIndex, int toIndex) {
            this.retrieve();
            return this._retrievedValues.subList(fromIndex, toIndex);
        }

        @Override
        public void clear() {
            this.retrieve();
            this._retrievedValues.clear();
        }

        public void add(int index, Object element) {
            this.retrieve();
            this._retrievedValues.add(index, element);
        }

        class DeferredIterator
        implements Iterator {
            ListIterator _listIterator = null;

            DeferredIterator() {
                if (DeferredRetrievalList.this.isRetrieved()) {
                    this.load();
                }
            }

            void load() {
                DeferredRetrievalList.this.retrieve();
                if (this._listIterator == null) {
                    this._listIterator = DeferredRetrievalList.this._retrievedValues.listIterator();
                }
            }

            @Override
            public boolean hasNext() {
                this.load();
                return this._listIterator.hasNext();
            }

            public Object next() {
                this.load();
                return this._listIterator.next();
            }

            @Override
            public void remove() {
                this.load();
                this._listIterator.remove();
            }
        }

        class DeferredListIterator
        implements ListIterator {
            int _iterStartIndex = -1;
            ListIterator _listIterator = null;

            DeferredListIterator() {
                if (DeferredRetrievalList.this.isRetrieved()) {
                    this.load();
                }
            }

            DeferredListIterator(int index) {
                this._iterStartIndex = index;
                if (DeferredRetrievalList.this.isRetrieved()) {
                    this.load();
                }
            }

            void load() {
                DeferredRetrievalList.this.retrieve();
                if (this._listIterator == null) {
                    this._listIterator = this._iterStartIndex == -1 ? DeferredRetrievalList.this._retrievedValues.listIterator() : DeferredRetrievalList.this._retrievedValues.listIterator(this._iterStartIndex);
                }
            }

            @Override
            public boolean hasNext() {
                this.load();
                return this._listIterator.hasNext();
            }

            @Override
            public Object next() {
                this.load();
                return this._listIterator.next();
            }

            @Override
            public boolean hasPrevious() {
                this.load();
                return this._listIterator.hasPrevious();
            }

            public Object previous() {
                this.load();
                return this._listIterator.previous();
            }

            @Override
            public int nextIndex() {
                this.load();
                return this._listIterator.nextIndex();
            }

            @Override
            public int previousIndex() {
                this.load();
                return this._listIterator.previousIndex();
            }

            @Override
            public void remove() {
                this.load();
                this._listIterator.remove();
            }

            public void set(Object o) {
                this.load();
                this._listIterator.set(o);
            }

            public void add(Object o) {
                this.load();
                this._listIterator.add(o);
            }
        }
    }
}

