/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.filters.BaseAdvancedFilterObjectFactory;
import com.sas.dataselectors.filters.BaseFilterObjectFactory;
import com.sas.dataselectors.filters.DefaultFilterConditionList;
import com.sas.dataselectors.filters.DefaultFilterQualifier;
import com.sas.dataselectors.filters.DefaultFilterQualifierList;
import com.sas.dataselectors.filters.FilterBaseModelData;
import com.sas.dataselectors.filters.FilterConditionInterface;
import com.sas.dataselectors.filters.FilterConditionListInterface;
import com.sas.dataselectors.filters.FilterException;
import com.sas.dataselectors.filters.FilterQualifierListInterface;
import com.sas.dataselectors.filters.MemberPropertyQualifierData;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PropertyInterface;
import com.sas.util.log.LoggerRepository2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AdvancedBusinessQueryFilterObjectFactory
extends BaseAdvancedFilterObjectFactory {
    private static boolean DEBUG = false;
    protected DataItem _dataItem = null;
    private List _alternateConditions = null;

    public AdvancedBusinessQueryFilterObjectFactory(BusinessQuery businessQuery, FilterBaseModelData baseModel) {
        super(businessQuery, baseModel, BaseFilterObjectFactory.DEFAULT_SCOPE);
        LoggerRepository2.getLogger((String)this.getClass().getName(), null).debug("_DEBUG_:AdvancedBusinessQueryFilterObjectFactory: BusinessQuery Constructor");
    }

    public AdvancedBusinessQueryFilterObjectFactory(BusinessQuery businessQuery, FilterBaseModelData baseModel, DataItem dataItem) {
        this(businessQuery, baseModel);
        this._dataItem = dataItem;
        LoggerRepository2.getLogger((String)this.getClass().getName(), null).debug("_DEBUG_:AdvancedBusinessQueryFilterObjectFactory: BusinessQuery & DataItem Constructor");
    }

    @Override
    public List getEligibleFilterItems(boolean includeBaseModels) {
        ArrayList<DataItem> list = null;
        if (this._businessQuery != null) {
            list = new ArrayList<DataItem>();
            if (this._dataItem != null && this._dataItem.getStructure() != StructureOfDataItem.STRUCTURE_MEASURE) {
                list.add(this._dataItem);
            } else {
                boolean olap = this._businessModel.getStructure().isOLAP();
                List objects = this._businessQuery.getResultItems();
                if (objects != null) {
                    for (DataItem item : objects) {
                        if (!this._isItemEligible(item, olap)) continue;
                        list.add(item);
                    }
                }
                if (!olap && (objects = Utils.filterObjects((BusinessModel)this._businessModel, (boolean)true, DataItem.class)) != null) {
                    for (DataItem item : objects) {
                        if (!this._isItemEligible(item, olap) || list.contains(item)) continue;
                        list.add(item);
                    }
                }
            }
        }
        return list;
    }

    private boolean _isItemEligible(DataItem dataItem, boolean isOlap) {
        if (!dataItem.isUsableInQuery() || dataItem.getExpression() instanceof FractionOfTotalExpression) {
            return false;
        }
        if (dataItem.getStructure() != StructureOfDataItem.STRUCTURE_MEASURE) {
            if (DEBUG) {
                System.out.println("_DEBUG_: Testing item for eligibility: " + dataItem.getLabel() + ", olap=" + isOlap + ", filter supported=" + dataItem.isActionSupported(DataItemActionType.STEP_MEMBER_FILTER));
            }
            if (!isOlap || isOlap && dataItem.isActionSupported(DataItemActionType.STEP_MEMBER_FILTER)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterQualifierListInterface getQualifiers(List itemList) {
        StructureOfData structure;
        DefaultFilterQualifierList result = null;
        ArrayList<DefaultFilterQualifier> list = null;
        if (itemList != null && !itemList.isEmpty() && (structure = this._businessModel.getStructure()) != null && structure.isOLAP()) {
            DataItem hierarchyItem = (DataItem)itemList.get(0);
            try {
                MetadataInterface metadata = this.getMetadataInterface();
                Map propMap = this.getLevelProperties(metadata, hierarchyItem);
                if (propMap != null) {
                    list = new ArrayList<DefaultFilterQualifier>();
                    Set keys = propMap.keySet();
                    for (LevelInterface level : keys) {
                        List propertyList = (List)propMap.get(level);
                        for (PropertyInterface property : propertyList) {
                            MemberPropertyQualifierData data = new MemberPropertyQualifierData(hierarchyItem, level, property);
                            String label = data.createLabel(this.getLocale());
                            DefaultFilterQualifier qualifier = new DefaultFilterQualifier(label, (Object)data);
                            list.add(qualifier);
                        }
                    }
                }
            }
            catch (FilterException filterException) {
            }
            catch (OLAPException oLAPException) {
            }
            finally {
                this.releaseResources();
            }
        }
        if (list != null && list.size() > 0) {
            result = new DefaultFilterQualifierList((List)list);
        }
        return result;
    }

    @Override
    public FilterConditionListInterface getRelationalConditions(ExpressionInterface expression, boolean forcedFormatting) {
        DefaultFilterConditionList model = new DefaultFilterConditionList();
        if (expression != null) {
            boolean useForcedFormattingConditionSet;
            int exprType;
            FilterConditionInterface[] conditions = null;
            if (!forcedFormatting && expression instanceof DataItem && ((DataItem)expression).isFormattingForced()) {
                exprType = ((DataItem)expression).getExpressionTypeIgnoringFormattingForced();
                useForcedFormattingConditionSet = true;
            } else {
                exprType = expression.getExpressionType();
                useForcedFormattingConditionSet = false;
            }
            LoggerRepository2.getLogger((String)this.getClass().getName(), null).debug("_DEBUG_:Generating relational conditions, Expression type: " + exprType);
            switch (exprType) {
                case 3: {
                    conditions = this.getRelationalCharacterConditions(useForcedFormattingConditionSet);
                    break;
                }
                case 0: {
                    conditions = this.getRelationalConditions(useForcedFormattingConditionSet);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    conditions = this.getRelationalTimeConditions();
                    break;
                }
                default: {
                    conditions = this.getRelationalNumericConditions(useForcedFormattingConditionSet);
                }
            }
            model.setConditionList(Arrays.asList(conditions));
        }
        return model;
    }

    @Override
    protected synchronized List getAlternateConditions() {
        if (this._alternateConditions == null) {
            this._alternateConditions = Arrays.asList(this.ALT_CONTAINS, this.ALT_NOT_CONTAINS, this.ALT_LIKE, this.ALT_NOT_LIKE, this.IS_NOT_EQUALS, this.IS_EQUALS, this.CODE_BLOCK);
        }
        return this._alternateConditions;
    }
}

