/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.filters.BaseAdvancedFilterObjectFactory;
import com.sas.dataselectors.filters.DefaultFilterQualifier;
import com.sas.dataselectors.filters.DefaultFilterQualifierList;
import com.sas.dataselectors.filters.FilterBaseModelData;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterQualifierListInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.MapFolder;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.parser.ExpressionIdentifier;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.oma.OMAMeasure;
import com.sas.util.log.LoggerRepository2;
import java.util.ArrayList;
import java.util.List;

public class AdvancedBusinessModelFilterObjectFactory
extends BaseAdvancedFilterObjectFactory {
    private static final boolean DEBUG = false;

    public AdvancedBusinessModelFilterObjectFactory(FilterBaseModelData baseModel) {
        super(baseModel, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE);
    }

    public AdvancedBusinessModelFilterObjectFactory(BusinessModel model) {
        super(new FilterBaseModelData(model), ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE);
    }

    @Override
    public List getEligibleFilterItems(boolean includeBaseModels) {
        List list = super.getEligibleFilterItems(includeBaseModels);
        if (list != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                DataItem item = (DataItem)list.get(i);
                if (this._businessModel.getStructure().isOLAP() && !item.isActionSupported(DataItemActionType.STEP_MEMBER_FILTER)) {
                    list.remove(i);
                    continue;
                }
                if (item.getStructure() != StructureOfDataItem.STRUCTURE_MEASURE) continue;
                list.remove(i);
            }
        }
        return list;
    }

    @Override
    public FilterQualifierListInterface getQualifiers(List itemList) {
        DefaultFilterQualifierList result = null;
        ArrayList<DefaultFilterQualifier> list = null;
        if (this._businessModel != null) {
            list = new ArrayList<DefaultFilterQualifier>();
            List objects = this._businessModel.getObjects(1, DataSourceCube.class);
            if (objects != null) {
                for (DataSourceCube cubeSource : objects) {
                    try {
                        List measures = cubeSource.getMeasures();
                        for (Measure m : measures) {
                            list.add(new DefaultFilterQualifier(m.getMeasureCaption(), (Object)m));
                        }
                    }
                    catch (MetadataException e) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            if ((objects = Utils.filterObjects((BusinessModel)this._businessModel, (boolean)true, DataItem.class)) != null) {
                for (DataItem item : objects) {
                    if (item.getStructure() != StructureOfDataItem.STRUCTURE_MEASURE || !item.isCalculatedItem()) continue;
                    boolean add = true;
                    if (!item.isUsableInQuery()) {
                        add = false;
                    } else {
                        ExpressionIdentifier id;
                        BusinessModelResource resource;
                        ResourceAwareStringExpression strExpression;
                        List identifiers;
                        ExpressionInterface expression = item.getExpression();
                        if (expression instanceof ResourceAwareStringExpression && (identifiers = (strExpression = (ResourceAwareStringExpression)expression).getExpressionIdentifiers()) != null && identifiers.size() == 1 && (resource = (id = (ExpressionIdentifier)identifiers.get(0)).getBusinessModelResource()) instanceof OMAMeasure && list.contains(new DefaultFilterQualifier(item.getLabel(), (Object)resource))) {
                            add = false;
                        }
                    }
                    if (!add) continue;
                    list.add(new DefaultFilterQualifier(item.getLabel(), (Object)item));
                }
            }
        }
        if (list != null && list.size() > 0) {
            result = new DefaultFilterQualifierList(list);
        }
        return result;
    }

    @Override
    public boolean updateSimpleFilterFromTestNode(FilterItem filterItem, FilterLogicTestNodeInterface testNode) {
        boolean isOk = super.updateSimpleFilterFromTestNode(filterItem, testNode);
        if (testNode.getParentLogicNode() == null && this._businessModel instanceof InformationMap) {
            boolean isVisible = testNode.getParentLogicNode() == null;
            InformationMap map = (InformationMap)this._businessModel;
            MapFolder folder = null;
            try {
                folder = map.getMapFolderContaining((BusinessItem)filterItem);
                if (folder == null && isVisible) {
                    folder = map.getRootMapFolder();
                }
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
            try {
                if (folder != null) {
                    if (isVisible) {
                        folder.addBusinessItem((BusinessItem)filterItem);
                    } else {
                        folder.removeBusinessItem((BusinessItem)filterItem);
                    }
                }
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return isOk;
    }
}

