/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filterandrank;

import com.sas.beans.PropertyChangeEvent;
import com.sas.beans.PropertyChangeSupport;
import com.sas.dataselectors.filterandrank.FilterAndRankModelInterface;
import com.sas.dataselectors.filterandrank.FilterAxisEnum;
import com.sas.dataselectors.filterandrank.FilterOperatorEnum;
import com.sas.dataselectors.filterandrank.RB;
import com.sas.dataselectors.filterandrank.RankOrderEnum;
import com.sas.dataselectors.filterandrank.RankTypeEnum;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryRankFilter;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.text.Message;
import com.sas.util.ChainedException;
import com.sas.util.log.LoggerRepository2;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class FilterAndRankModel
implements FilterAndRankModelInterface {
    public static final String RB_KEY = "FilterAndRankModel.";
    protected PropertyChangeSupport propertyChangeSupport = null;
    BusinessQuery query;
    TupleElementInterface element;
    String cubeName;
    StepInterface rowStep;
    StepInterface colStep;
    private static StringExpressionUtil expressionUtil = StringExpressionUtil.getInstance();

    public FilterAndRankModel() {
        this(null);
    }

    public FilterAndRankModel(BusinessQuery query) {
        this.query = query;
        this.element = null;
        this.cubeName = null;
        this.rowStep = this.getModelStep(FilterAxisEnum.ROWS);
        this.colStep = this.getModelStep(FilterAxisEnum.COLUMNS);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport((Object)this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.processPropertyChange((java.beans.PropertyChangeEvent)evt);
        }
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(propName, oldValue, newValue);
        }
    }

    public Object getBusinessQuery() {
        return this.query;
    }

    public void setBusinessQuery(BusinessQuery query) {
        if (this.query != query) {
            BusinessQuery oldValue = this.query;
            this.query = query;
            this.cubeName = null;
            this.rowStep = this.getModelStep(FilterAxisEnum.ROWS);
            this.colStep = this.getModelStep(FilterAxisEnum.COLUMNS);
            this.firePropertyChange("businessQuery", oldValue, query);
        }
    }

    public boolean applyChanges() throws ChainedException {
        boolean changed = false;
        try {
            if (null != this.query) {
                if (this.setModelStep(this.rowStep, FilterAxisEnum.ROWS)) {
                    changed = true;
                }
                if (this.setModelStep(this.colStep, FilterAxisEnum.COLUMNS)) {
                    changed = true;
                }
            }
        }
        catch (MetadataException me) {
            throw new ChainedException((Throwable)me, me.getMessage());
        }
        return changed;
    }

    public TupleElementInterface getTupleElement() {
        return this.element;
    }

    public void setTupleElement(TupleElementInterface element) {
        if (this.element != element) {
            TupleElementInterface oldValue = this.element;
            this.element = element;
            this.firePropertyChange("tupleElement", oldValue, element);
        }
    }

    public FilterAxisEnum getFilterAxis() throws OLAPException {
        FilterAxisEnum value = null;
        if (this.element != null) {
            TupleInterface tuple = this.element.getTuple();
            int axis = tuple.getAxis().getAxisNumber();
            switch (axis) {
                case 0: {
                    value = FilterAxisEnum.ROWS;
                    break;
                }
                case 1: {
                    value = FilterAxisEnum.COLUMNS;
                }
            }
        }
        return value;
    }

    public String getTupleElementLabel() {
        String label = null;
        TupleElementInterface tupleElement = this.getTupleElement();
        if (null != tupleElement) {
            try {
                TupleInterface tuple = tupleElement.getTuple();
                TupleElementInterface[] elements = tuple.getElements(0, -1);
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < elements.length; ++i) {
                    if (i > 0) {
                        sb.append('.');
                    }
                    sb.append(elements[i].getLabel());
                }
                label = sb.toString();
            }
            catch (OLAPException e) {
                try {
                    label = tupleElement.getLabel();
                }
                catch (OLAPException e1) {
                    label = "<error>";
                }
            }
            if (label != null) {
                label = label.trim();
            }
        }
        return label;
    }

    public Object getStep(FilterAxisEnum role) {
        Object step = FilterAxisEnum.ROWS == role ? this.rowStep : (FilterAxisEnum.COLUMNS == role ? this.colStep : null);
        return step;
    }

    private StepInterface getModelStep(FilterAxisEnum role) {
        StepInterface step = null;
        if (null != this.query && null != role) {
            List stepList = this.query.getSteps(FilterAndRankModel.getRole(role));
            step = stepList.isEmpty() ? null : stepList.get(0);
        }
        return step;
    }

    public String getStepText(FilterAxisEnum role, Locale locale) {
        StepInterface step = (StepInterface)this.getStep(role);
        String text = this.getStepText(step, locale);
        if (text != null) {
            text = text.trim();
        }
        return text;
    }

    protected String getStepText(StepInterface step, Locale locale) {
        String text = null;
        if (step != null) {
            if (step instanceof BusinessQueryRankFilter) {
                text = this.getRankStepText((BusinessQueryRankFilter)step, locale);
            } else if (step instanceof BusinessQueryDataBasedFilter) {
                text = this.getFilterStepText((BusinessQueryDataBasedFilter)step, locale);
            }
        }
        return text;
    }

    private String getFilterStepText(BusinessQueryDataBasedFilter filter, Locale locale) {
        String format = RB.getStringResource((String)RB_KEY, (String)"filterFormat.txt.fmt", (Locale)locale);
        String member = null;
        String opText = null;
        String value = null;
        List leftExprList = filter.getLeftExpression();
        ComparisonOperator op = filter.getOperator();
        List rightExprList = filter.getRightExpression();
        FilterOperatorEnum foe = FilterAndRankModel.getFilterOperator(op);
        if (null != foe) {
            opText = foe.getSqlText();
        }
        member = this.getReadableTextForMembers(leftExprList, locale, ".");
        StringBuffer sb = new StringBuffer();
        for (Object o : rightExprList) {
            if (!(o instanceof StringExpression)) continue;
            try {
                String temp = ((StringExpression)o).getText();
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(temp);
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        value = sb.toString();
        String text = Message.format((String)format, (Object)member, (Object)opText, (Object)value);
        return text;
    }

    private String getRankStepText(BusinessQueryRankFilter filter, Locale locale) {
        String text;
        String order = null;
        String value = null;
        String type = null;
        String member = null;
        RankOrderEnum roe = FilterAndRankModel.getRankOrder(filter.getRankOrder());
        if (null != roe) {
            order = roe.getLabel(locale);
        }
        value = Integer.toString(filter.getValue());
        RankTypeEnum rte = FilterAndRankModel.getRankType(filter.getRankType());
        if (null != rte) {
            type = rte.getLabel(locale);
        }
        member = this.getReadableTextForMembers(filter.getRankQualifiers(), locale, ".");
        if (RankTypeEnum.SUM == rte) {
            String format = filter.isIncludeTies() ? RB.getStringResource((String)RB_KEY, (String)"rankSumWithTiesFormat.txt.fmt", (Locale)locale) : RB.getStringResource((String)RB_KEY, (String)"rankSumWithoutTiesFormat.txt.fmt", (Locale)locale);
            text = Message.format((String)format, (Object)order, (Object)value, (Object)member);
        } else {
            String format = filter.isIncludeTies() ? RB.getStringResource((String)RB_KEY, (String)"rankWithTiesFormat.txt.fmt", (Locale)locale) : RB.getStringResource((String)RB_KEY, (String)"rankWithoutTiesFormat.txt.fmt", (Locale)locale);
            text = Message.format((String)format, (Object)order, (Object)value, (Object)type, (Object)member);
        }
        return text;
    }

    private String getMemberText(List qualifiers) {
        StringBuffer text = new StringBuffer();
        if (null != qualifiers) {
            int size = qualifiers.size();
            for (int i = 0; i < size; ++i) {
                Object o = qualifiers.get(i);
                if (!(o instanceof StringExpression)) continue;
                if (i > 0) {
                    text.append('.');
                }
                try {
                    text.append(expressionUtil.getReadableText((ExpressionInterface)((StringExpression)o)));
                    continue;
                }
                catch (MetadataException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return text.toString();
    }

    public boolean setStep(Object step, FilterAxisEnum role) {
        StepInterface stepObj = (StepInterface)step;
        if (null != role) {
            Object oldValue = this.getStep(role);
            if (oldValue != step) {
                if (FilterAxisEnum.ROWS == role) {
                    this.rowStep = stepObj;
                } else if (FilterAxisEnum.COLUMNS == role) {
                    this.colStep = stepObj;
                }
                String property = FilterAxisEnum.COLUMNS == role ? "columnStep" : "rowStep";
                this.firePropertyChange(property, oldValue, step);
            }
            return true;
        }
        return false;
    }

    private boolean setModelStep(StepInterface step, FilterAxisEnum role) throws MetadataException {
        StepInterface oldValue;
        if (null != this.query && null != role && (oldValue = this.getModelStep(role)) != step) {
            List<Object> stepList = step == null ? new ArrayList(0) : Collections.singletonList(step);
            this.query.setSteps(stepList, FilterAndRankModel.getRole(role));
            return true;
        }
        return false;
    }

    private boolean clearModelStep(FilterAxisEnum role) throws MetadataException {
        if (null != this.query && null != role) {
            this.query.setSteps(new ArrayList(0), FilterAndRankModel.getRole(role));
            return true;
        }
        return false;
    }

    public boolean clearStep(FilterAxisEnum role) {
        Object oldValue;
        if (null != role && (oldValue = this.getStep(role)) != null) {
            if (FilterAxisEnum.ROWS == role) {
                this.rowStep = null;
            } else if (FilterAxisEnum.COLUMNS == role) {
                this.colStep = null;
            }
            String property = FilterAxisEnum.COLUMNS == role ? "columnStep" : "rowStep";
            this.firePropertyChange(property, oldValue, null);
            return true;
        }
        return false;
    }

    public boolean clearAllSteps() {
        boolean success = true;
        if (!this.clearStep(FilterAxisEnum.COLUMNS)) {
            success = false;
        }
        if (!this.clearStep(FilterAxisEnum.ROWS)) {
            success = false;
        }
        return success;
    }

    private List createQualifierList(TupleElementInterface element) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (element != null) {
            try {
                TupleInterface tuple = element.getTuple();
                TupleElementInterface[] elements = tuple.getElements(0, -1);
                for (int i = 0; i < elements.length; ++i) {
                    if (elements[i].isContextual()) continue;
                    DataItem di = BusinessQueryToOLAPDataSetAdapter.findDataItem(this.query, null, elements[i], 1);
                    if (di != null && di.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE) {
                        list.add(di);
                        continue;
                    }
                    list.add(this.createMemberNameExpression(elements[i].getName()));
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return list;
    }

    public Object createFilterStep(FilterOperatorEnum operator, String value) {
        BusinessQueryDataBasedFilter filter = null;
        if (null != this.element) {
            List leftExprList = this.createQualifierList(this.element);
            ComparisonOperator filterOp = FilterAndRankModel.getComparisonOperator(operator);
            filter = new BusinessQueryDataBasedFilter(leftExprList, filterOp, (Object)value);
        }
        return filter;
    }

    public Object createRankStep(RankOrderEnum rankOrder, int value, boolean includeTies, RankTypeEnum rankType) {
        BusinessQueryRankFilter filter = null;
        String order = FilterAndRankModel.getIQRankOrder(rankOrder);
        String type = FilterAndRankModel.getIQRankType(rankType);
        if (order != null && type != null) {
            if (rankType == RankTypeEnum.COUNT) {
                if (value > 0) {
                    filter = new BusinessQueryRankFilter(order, value, includeTies);
                }
            } else if (rankType == RankTypeEnum.PERCENT) {
                if (value > 0 && value <= 100) {
                    filter = new BusinessQueryRankFilter(order, value);
                }
            } else if (rankType == RankTypeEnum.SUM && value >= 0) {
                filter = new BusinessQueryRankFilter(order, value);
            }
            if (filter != null) {
                filter.setRankType(type);
                if (null != this.element) {
                    filter.setRankQualifiers(this.createQualifierList(this.element));
                }
            }
        }
        return filter;
    }

    private ExpressionInterface createMemberNameExpression(String memberName) {
        StringExpression member = new StringExpression();
        member.setText(memberName);
        member.setExpressionType(3);
        return member;
    }

    public static String getIQRankType(RankTypeEnum rankType) {
        String type = RankTypeEnum.COUNT == rankType ? "Count" : (RankTypeEnum.PERCENT == rankType ? "Percent" : (RankTypeEnum.SUM == rankType ? "Sum" : null));
        return type;
    }

    public static RankTypeEnum getRankType(String iqRankType) {
        Object type = "Count".equals(iqRankType) ? RankTypeEnum.COUNT : ("Percent".equals(iqRankType) ? RankTypeEnum.PERCENT : ("Sum".equals(iqRankType) ? RankTypeEnum.SUM : null));
        return type;
    }

    public static String getIQRankOrder(RankOrderEnum rankOrder) {
        String order = RankOrderEnum.TOP == rankOrder ? "Top" : (RankOrderEnum.BOTTOM == rankOrder ? "Bottom" : null);
        return order;
    }

    public static RankOrderEnum getRankOrder(String iqRankOrder) {
        Object order = "Top".equals(iqRankOrder) ? RankOrderEnum.TOP : ("Bottom".equals(iqRankOrder) ? RankOrderEnum.BOTTOM : null);
        return order;
    }

    public static Role getRole(FilterAxisEnum role) {
        Object iqRole = FilterAxisEnum.COLUMNS == role ? Role.COLUMN : (FilterAxisEnum.ROWS == role ? Role.ROW : null);
        return iqRole;
    }

    public static ComparisonOperator getComparisonOperator(FilterOperatorEnum op) {
        Object iqOp = FilterOperatorEnum.EQ == op ? ComparisonOperator.COMPARE_EQ : (FilterOperatorEnum.NE == op ? ComparisonOperator.COMPARE_NEQ : (FilterOperatorEnum.LT == op ? ComparisonOperator.COMPARE_LT : (FilterOperatorEnum.GT == op ? ComparisonOperator.COMPARE_GT : (FilterOperatorEnum.LE == op ? ComparisonOperator.COMPARE_LE : (FilterOperatorEnum.GE == op ? ComparisonOperator.COMPARE_GE : null)))));
        return iqOp;
    }

    public static FilterOperatorEnum getFilterOperator(ComparisonOperator iqOp) {
        Object op = ComparisonOperator.COMPARE_EQ == iqOp ? FilterOperatorEnum.EQ : (ComparisonOperator.COMPARE_NEQ == iqOp ? FilterOperatorEnum.NE : (ComparisonOperator.COMPARE_LT == iqOp ? FilterOperatorEnum.LT : (ComparisonOperator.COMPARE_GT == iqOp ? FilterOperatorEnum.GT : (ComparisonOperator.COMPARE_LE == iqOp ? FilterOperatorEnum.LE : (ComparisonOperator.COMPARE_GE == iqOp ? FilterOperatorEnum.GE : null)))));
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getReadableTextForMembers(List list, Locale locale, String separator) {
        String text = "";
        MetadataInterface metadata = null;
        if (this.cubeName == null) {
            this.cubeName = this.getCubeName();
        }
        int kSize = list.size();
        for (int k = 0; k < kSize; ++k) {
            String memberText = null;
            Object obj = list.get(k);
            try {
                if (obj instanceof StringExpression) {
                    String readableText = expressionUtil.getReadableText((ExpressionInterface)((StringExpression)obj));
                    Filter filter = new Filter();
                    filter.setTreeOperator(Filter.ANCESTORS_TREE_OPERATOR | Filter.SELF_TREE_OPERATOR);
                    filter.setUniqueMemberName(readableText);
                    filter.setCubeName(this.cubeName);
                    if (metadata == null) {
                        metadata = BusinessQueryOLAPUtil.getMetadataInterface((Object)this.query);
                    }
                    MemberInterface[] members = metadata.getMembers(filter, 0, -1);
                    for (int i = 0; i < members.length; ++i) {
                        if (members[i].getType() == 2) continue;
                        String label = members[i].getLabel().trim();
                        if (memberText != null) {
                            memberText = memberText + ".";
                            memberText = memberText + label;
                            continue;
                        }
                        memberText = label;
                    }
                } else if (obj instanceof DataItem) {
                    memberText = ((DataItem)obj).getLabel();
                }
            }
            catch (Exception e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error("_DEBUG_:An error occurred while generating member name text!", (Throwable)e);
            }
            finally {
                if (metadata != null) {
                    BusinessQueryOLAPUtil.releaseMetadataInterface(metadata);
                }
            }
            if (memberText == null) continue;
            if (k != 0) {
                text = text + separator;
            }
            text = text + memberText;
        }
        return text;
    }

    private String getCubeName() {
        List dataSources;
        String name = null;
        if (this.query != null && (dataSources = this.query.getBusinessModel().getObjects(true, DataSourceCube.class)).size() > 0) {
            try {
                name = ((DataSourceCube)dataSources.get(0)).getCube().getCubeName();
            }
            catch (Exception e) {
                name = null;
            }
        }
        return name;
    }
}

