/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.exceptionhighlighting;

import com.sas.dataselectors.exceptionhighlighting.ExceptionHighlightingUtil;
import com.sas.rpf.data.Level;
import com.sas.rpf.exception.ParseException;
import com.sas.rpf.expr.ExpressionBuilderFactory;
import com.sas.rpf.expr.ExpressionBuilderInterface;
import com.sas.rpf.expr.ExpressionElementInterface;
import com.sas.rpf.expr.ExpressionInterface;
import com.sas.rpf.expr.ExpressionUtilInterface;
import com.sas.rpf.expr.PrimitiveInterface;
import com.sas.rpf.expr.SerializationException;
import com.sas.util.log.LoggerRepository2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExpressionUtil {
    public static void main(String[] args) {
        ArrayList<String> levels = new ArrayList<String>();
        levels.add("[D].[H].[L]");
        levels.add("[D].[H].[L2]");
        levels.add("[D2].[H2].[L2]");
        levels.add("[D3].[H].[L1]");
        levels.add("[D3].[H].[L2]");
        levels.add("[D3].[H].[L3]");
        levels.add("[D4].[H].[L1]");
        ArrayList<String> simpleLevels = new ArrayList<String>();
        simpleLevels.add("[D].[H].[L]");
        simpleLevels.add("[D2].[H2].[L]");
        ExpressionInterface simple = ExpressionUtil.simpleExpression("$w", "<=", "555");
        ExpressionUtil.printExpression(simple);
        ExpressionInterface simpleWithSimpleLevels = ExpressionUtil.simpleExpression("$w", "<=", "40", simpleLevels);
        ExpressionUtil.printExpression(simpleWithSimpleLevels);
        ExpressionInterface simpleWithLevels = ExpressionUtil.simpleExpression("$w", "<=", "40", levels);
        ExpressionUtil.printExpression(simpleWithLevels);
        ExpressionInterface between = ExpressionUtil.betweenExpression("$w", "10", "555");
        ExpressionUtil.printExpression(between);
        ExpressionInterface betweenWithLevels = ExpressionUtil.betweenExpression("$w", "10", "555", levels);
        ExpressionUtil.printExpression(betweenWithLevels);
        System.exit(1);
    }

    private static void printExpression(ExpressionInterface expression) {
        try {
            String expressionString = null;
            expressionString = expression.getExpressionString();
            System.out.println("");
            System.out.println("---------------------------------------");
            System.out.println("Expression=" + expressionString);
            System.out.println("SimplifiedExpression=" + ExpressionUtil.simplifyExpression(expressionString));
            System.out.println("Measure=" + ExpressionUtil.getMeasure(expressionString));
            if (ExpressionUtil.isBetweenCondition(expressionString)) {
                System.out.println("Condition=Between");
                System.out.println("MinValue=" + ExpressionUtil.getMinValue(expressionString));
                System.out.println("MaxValue=" + ExpressionUtil.getMaxValue(expressionString));
            } else {
                System.out.println("Condition=" + ExpressionUtil.getCondition(expressionString));
                System.out.println("Value=" + ExpressionUtil.getValue(expressionString));
            }
            System.out.println("Levels=" + ExpressionUtil.getLevels(expressionString));
            System.out.println("---------------------------------------");
            System.out.println("");
        }
        catch (SerializationException e) {
            LoggerRepository2.getLogger((String)ExpressionUtil.class.getName(), null).error(e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            LoggerRepository2.getLogger((String)ExpressionUtil.class.getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    public static ExpressionInterface betweenExpression(String varName, String minValue, String maxValue) {
        return ExpressionUtil.betweenExpression(varName, minValue, maxValue, null);
    }

    public static ExpressionInterface betweenExpression(String varName, String minValue, String maxValue, List levels) {
        ExpressionInterface expression = null;
        ExpressionBuilderInterface expressionBuilder = ExpressionBuilderFactory.getExpressionBuilder();
        ArrayList levelCombinations = new ArrayList();
        if (levels != null && levels.size() > 0) {
            levelCombinations = (ArrayList)ExpressionUtil.generateCombinations(ExpressionUtil.getLevelMap(levels));
        }
        ArrayList levelCombo = null;
        if (levelCombinations.size() > 1) {
            Iterator levelComboIterator = levelCombinations.iterator();
            ExpressionInterface[] initialExpressions = new ExpressionInterface[2];
            int i = 0;
            while (levelComboIterator.hasNext()) {
                ++i;
                levelCombo = (ArrayList)levelComboIterator.next();
                PrimitiveInterface leftVar1 = expressionBuilder.newVariable(ExpressionUtil.getVarName(varName), (List)levelCombo);
                PrimitiveInterface leftVar2 = expressionBuilder.newVariable(ExpressionUtil.getVarName(varName), (List)levelCombo);
                PrimitiveInterface minVal = null;
                minVal = ExpressionUtil.getVarName(minValue) != null ? expressionBuilder.newVariable(ExpressionUtil.getVarName(minValue), (List)levelCombo) : expressionBuilder.newNumber(new Double(minValue).doubleValue());
                PrimitiveInterface maxVal = null;
                maxVal = ExpressionUtil.getVarName(maxValue) != null ? expressionBuilder.newVariable(ExpressionUtil.getVarName(maxValue), (List)levelCombo) : expressionBuilder.newNumber(new Double(maxValue).doubleValue());
                ExpressionInterface tempExpression = expressionBuilder.paren(expressionBuilder.and(ExpressionUtil.simpleExpression(leftVar1, ">=", minVal), ExpressionUtil.simpleExpression(leftVar2, "<=", maxVal)));
                if (i == 1 || i == 2) {
                    initialExpressions[i - 1] = tempExpression;
                }
                if (i == 2) {
                    expression = expressionBuilder.or(initialExpressions[0], initialExpressions[1]);
                }
                if (i <= 2) continue;
                expression = expressionBuilder.or(expression, tempExpression);
            }
        } else {
            if (levelCombinations.size() == 1) {
                levelCombo = (ArrayList)levelCombinations.get(0);
            }
            PrimitiveInterface leftVar1 = expressionBuilder.newVariable(ExpressionUtil.getVarName(varName), (List)levelCombo);
            PrimitiveInterface leftVar2 = expressionBuilder.newVariable(ExpressionUtil.getVarName(varName), (List)levelCombo);
            PrimitiveInterface minVal = null;
            minVal = ExpressionUtil.getVarName(minValue) != null ? expressionBuilder.newVariable(ExpressionUtil.getVarName(minValue), (List)levelCombo) : expressionBuilder.newNumber(new Double(minValue).doubleValue());
            PrimitiveInterface maxVal = null;
            maxVal = ExpressionUtil.getVarName(maxValue) != null ? expressionBuilder.newVariable(ExpressionUtil.getVarName(maxValue), (List)levelCombo) : expressionBuilder.newNumber(new Double(maxValue).doubleValue());
            expression = expressionBuilder.and(ExpressionUtil.simpleExpression(leftVar1, ">=", minVal), ExpressionUtil.simpleExpression(leftVar2, "<=", maxVal));
        }
        return expression;
    }

    public static ExpressionInterface simpleExpression(String leftVarName, String condition, String rightVarName) {
        return ExpressionUtil.simpleExpression(leftVarName, condition, rightVarName, null);
    }

    public static ExpressionInterface simpleExpression(String leftVarName, String condition, String rightVarName, List levels) {
        return ExpressionUtil.simpleExpression(leftVarName, condition, rightVarName, levels, true);
    }

    public static ExpressionInterface simpleExpression(String leftVarName, String condition, String rightVarName, List levels, boolean isMeasure) {
        ExpressionInterface expression = null;
        ExpressionBuilderInterface expressionBuilder = ExpressionBuilderFactory.getExpressionBuilder();
        ArrayList levelCombinations = new ArrayList();
        if (levels != null && levels.size() > 0) {
            levelCombinations = (ArrayList)ExpressionUtil.generateCombinations(ExpressionUtil.getLevelMap(levels));
        }
        ArrayList levelCombo = null;
        if (levelCombinations.size() > 1) {
            Iterator levelComboIterator = levelCombinations.iterator();
            ExpressionInterface[] initialExpressions = new ExpressionInterface[2];
            int i = 0;
            while (levelComboIterator.hasNext()) {
                ++i;
                levelCombo = (ArrayList)levelComboIterator.next();
                PrimitiveInterface leftVar = expressionBuilder.newVariable(ExpressionUtil.getVarName(leftVarName), (List)levelCombo);
                PrimitiveInterface rightVar = null;
                if (!condition.equals("==missing")) {
                    rightVar = ExpressionUtil.getVarName(rightVarName) != null ? expressionBuilder.newVariable(ExpressionUtil.getVarName(rightVarName), (List)levelCombo) : (isMeasure ? expressionBuilder.newNumber(new Double(rightVarName).doubleValue()) : expressionBuilder.newCharacter(rightVarName));
                }
                ExpressionInterface tempExpression = ExpressionUtil.simpleExpression(leftVar, condition, rightVar);
                if (i == 1 || i == 2) {
                    initialExpressions[i - 1] = tempExpression;
                }
                if (i == 2) {
                    expression = expressionBuilder.or(initialExpressions[0], initialExpressions[1]);
                }
                if (i <= 2) continue;
                expression = expressionBuilder.or(expression, tempExpression);
            }
        } else {
            if (levelCombinations.size() == 1) {
                levelCombo = (ArrayList)levelCombinations.get(0);
            }
            PrimitiveInterface leftVar = expressionBuilder.newVariable(ExpressionUtil.getVarName(leftVarName), (List)levelCombo);
            PrimitiveInterface rightVar = null;
            if (!condition.equals("==missing")) {
                rightVar = ExpressionUtil.getVarName(rightVarName) != null ? expressionBuilder.newVariable(ExpressionUtil.getVarName(rightVarName), (List)levelCombo) : (isMeasure ? expressionBuilder.newNumber(new Double(rightVarName).doubleValue()) : expressionBuilder.newCharacter(rightVarName));
            }
            expression = ExpressionUtil.simpleExpression(leftVar, condition, rightVar);
        }
        return expression;
    }

    public static ExpressionInterface simpleExpression(PrimitiveInterface left, String condition, PrimitiveInterface right) {
        ExpressionInterface expression = null;
        ExpressionBuilderInterface expressionBuilder = ExpressionBuilderFactory.getExpressionBuilder();
        if (condition.equals("==")) {
            expression = expressionBuilder.eq(left, right);
        } else if (condition.equals(">")) {
            expression = expressionBuilder.gt(left, right);
        } else if (condition.equals(">=")) {
            expression = expressionBuilder.ge(left, right);
        } else if (condition.equals("<")) {
            expression = expressionBuilder.lt(left, right);
        } else if (condition.equals("<=")) {
            expression = expressionBuilder.le(left, right);
        } else if (condition.equals("!=")) {
            expression = expressionBuilder.ne(left, right);
        } else if (condition.equals("==missing")) {
            expression = expressionBuilder.eq(left, expressionBuilder.newMissing());
        }
        return expression;
    }

    private static String getVarName(String varName) {
        if (varName.length() > 0 && varName.charAt(0) == '$') {
            return varName.substring(1);
        }
        return null;
    }

    private static List generateCombinations(Map levelMap) {
        Object[] levelLists = levelMap.values().toArray();
        ArrayList result = new ArrayList();
        List levels = (List)levelLists[0];
        for (int i = 0; i < levels.size(); ++i) {
            Level level = (Level)levels.get(i);
            ArrayList<Level> prefix = new ArrayList<Level>();
            prefix.add(level);
            ExpressionUtil.generateCombinations(1, levelLists, prefix, result);
        }
        return result;
    }

    private static void generateCombinations(int i, Object[] levelLists, List prefix, List result) {
        if (levelLists.length == 1) {
            result.add(prefix);
        } else if (i == levelLists.length - 1) {
            List levels = (List)levelLists[i];
            for (int levelIdx = 0; levelIdx < levels.size(); ++levelIdx) {
                ArrayList current = new ArrayList(prefix);
                current.add(levels.get(levelIdx));
                result.add(current);
            }
        } else {
            List levels = (List)levelLists[i];
            for (int levelIdx = 0; levelIdx < levels.size(); ++levelIdx) {
                Level level = (Level)levels.get(levelIdx);
                ArrayList<Level> current = new ArrayList<Level>(prefix);
                current.add(level);
                ExpressionUtil.generateCombinations(i + 1, levelLists, current, result);
            }
        }
    }

    public static Map getLevelMap(List levels) {
        LinkedHashMap<String, ArrayList<Level>> levelMap = new LinkedHashMap<String, ArrayList<Level>>();
        for (String uniqueLevelName : levels) {
            String dimensionName = ExceptionHighlightingUtil.getDimensionName((String)uniqueLevelName);
            String hierarchyName = ExceptionHighlightingUtil.getHierarchyName((String)uniqueLevelName);
            String levelName = ExceptionHighlightingUtil.getLevelName((String)uniqueLevelName);
            Level level = new Level(dimensionName, hierarchyName, levelName);
            String key = dimensionName + "_" + hierarchyName;
            ArrayList<Level> levelsInMap = (ArrayList<Level>)levelMap.get(key);
            if (levelsInMap == null) {
                levelsInMap = new ArrayList<Level>();
                levelMap.put(key, levelsInMap);
            }
            levelsInMap.add(level);
        }
        return levelMap;
    }

    public static boolean isBetweenCondition(String exprString) throws ParseException {
        ExpressionInterface expression = ExpressionBuilderFactory.createExpression((String)ExpressionUtil.simplifyExpression(exprString));
        return expression.getLeftExpression().hasChildren();
    }

    public static String getCondition(String exprString) throws ParseException {
        ExpressionInterface expression = ExpressionBuilderFactory.createExpression((String)ExpressionUtil.simplifyExpression(exprString));
        return expression.getOperator();
    }

    public static String getMeasure(String exprString) throws ParseException {
        ExpressionInterface expression = ExpressionBuilderFactory.createExpression((String)ExpressionUtil.simplifyExpression(exprString));
        ExpressionElementInterface expressionElt = expression.getLeftExpression();
        if (expressionElt.hasChildren()) {
            expressionElt = ((ExpressionInterface)expressionElt).getLeftExpression();
        }
        return ExpressionUtil.getElementValue(expressionElt);
    }

    public static String getValue(String exprString) throws ParseException {
        ExpressionInterface expression = ExpressionBuilderFactory.createExpression((String)ExpressionUtil.simplifyExpression(exprString));
        ExpressionElementInterface expressionElt = expression.getLeftExpression();
        expressionElt = expressionElt.hasChildren() ? ((ExpressionInterface)expressionElt).getRightExpression() : expression.getRightExpression();
        return ExpressionUtil.getElementValue(expressionElt);
    }

    public static String getMinValue(String exprString) throws ParseException {
        ExpressionInterface expression = ExpressionBuilderFactory.createExpression((String)ExpressionUtil.simplifyExpression(exprString));
        ExpressionElementInterface expressionElt = expression.getLeftExpression();
        expressionElt = ((ExpressionInterface)expressionElt).getRightExpression();
        return ExpressionUtil.getElementValue(expressionElt);
    }

    public static String getMaxValue(String exprString) throws ParseException {
        ExpressionInterface expression = ExpressionBuilderFactory.createExpression((String)ExpressionUtil.simplifyExpression(exprString));
        ExpressionElementInterface expressionElt = expression.getRightExpression();
        expressionElt = ((ExpressionInterface)expressionElt).getRightExpression();
        return ExpressionUtil.getElementValue(expressionElt);
    }

    public static List getLevels(String exprString) throws ParseException {
        ArrayList<String> levels = new ArrayList<String>();
        ExpressionInterface expression = ExpressionBuilderFactory.createExpression((String)exprString);
        if (exprString.equals(ExpressionUtil.simplifyExpression(exprString))) {
            ExpressionElementInterface expressionElt = expression.getLeftExpression();
            if (expressionElt.hasChildren()) {
                expressionElt = ((ExpressionInterface)expressionElt).getLeftExpression();
            }
            for (Level lev : ExpressionBuilderFactory.getExpressionUtil().getLevels(expressionElt)) {
                levels.add("[" + lev.getDimension() + "].[" + lev.getHierarchy() + "].[" + lev.getLevel() + "]");
            }
        } else {
            HashMap levelMap = new HashMap();
            ExpressionUtil.getLevels(expression, levelMap);
            levels.addAll(levelMap.values());
        }
        return levels;
    }

    private static void getLevels(ExpressionInterface expression, Map levels) {
        if (expression.getOperator().equals("(")) {
            ExpressionUtil.getLevels((ExpressionInterface)expression.getLeftExpression(), levels);
        } else if (expression.getOperator().equals("||")) {
            ExpressionUtil.getLevels((ExpressionInterface)expression.getLeftExpression(), levels);
            ExpressionUtil.getLevels((ExpressionInterface)expression.getRightExpression(), levels);
        } else {
            ExpressionElementInterface expressionElt = expression.getLeftExpression();
            if (expressionElt.hasChildren()) {
                expressionElt = ((ExpressionInterface)expressionElt).getLeftExpression();
            }
            for (Level lev : ExpressionBuilderFactory.getExpressionUtil().getLevels(expressionElt)) {
                String uniqueLevelName = "[" + lev.getDimension() + "].[" + lev.getHierarchy() + "].[" + lev.getLevel() + "]";
                levels.put(uniqueLevelName, uniqueLevelName);
            }
        }
    }

    public static String getElementValue(ExpressionElementInterface expressionElt) {
        String value = null;
        ExpressionUtilInterface expressionUtil = ExpressionBuilderFactory.getExpressionUtil();
        if (expressionElt.getType() == 18) {
            value = "$" + expressionUtil.getVariable(expressionElt).getName();
        } else {
            try {
                value = expressionElt.getExpressionString();
            }
            catch (SerializationException e) {
                LoggerRepository2.getLogger((String)ExpressionUtil.class.getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    private static String simplifyExpression(String exprString) {
        String simplifiedExpression = exprString;
        ExpressionInterface expression = null;
        try {
            expression = ExpressionBuilderFactory.createExpression((String)exprString);
            if (expression != null && expression.getOperator().equals("||")) {
                while (expression.getLeftExpression().hasChildren() && expression.getOperator() != "&&") {
                    expression = (ExpressionInterface)expression.getLeftExpression();
                }
                simplifiedExpression = expression.getExpressionString();
            }
        }
        catch (ParseException e) {
            LoggerRepository2.getLogger((String)ExpressionUtil.class.getName(), null).error(e.getMessage(), (Throwable)e);
        }
        catch (SerializationException e) {
            LoggerRepository2.getLogger((String)ExpressionUtil.class.getName(), null).error(e.getMessage(), (Throwable)e);
        }
        return simplifiedExpression;
    }
}

