/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.exceptionhighlighting;

import com.sas.dataselectors.exceptionhighlighting.ExceptionHighlightingOLAPRuleInterface;
import com.sas.dataselectors.exceptionhighlighting.ExceptionHighlightingRule;
import com.sas.dataselectors.exceptionhighlighting.ExpressionUtil;
import com.sas.rpf.expr.SerializationException;
import com.sas.util.log.LoggerRepository2;
import java.util.ArrayList;

public class ExceptionHighlightingOLAPRule
extends ExceptionHighlightingRule
implements ExceptionHighlightingOLAPRuleInterface {
    protected String applyToSelectedIndex;
    protected String[] selectedLevels;

    @Override
    public String getExpression() {
        String expression = null;
        boolean isMeasure = this.isMeasure();
        ArrayList<String> expLevels = null;
        if (this.selectedLevels != null) {
            expLevels = new ArrayList<String>();
            for (int i = 0; i < this.selectedLevels.length; ++i) {
                expLevels.add(this.selectedLevels[i]);
            }
        }
        if (this.getCondition().equals("between")) {
            String expMeasure = "$" + this.getMeasure();
            String expMin = this.getMinValue();
            String expMax = this.getMaxValue();
            if (!this.isMinValueUserDefined()) {
                expMin = "$" + expMin;
            }
            if (!this.isMaxValueUserDefined()) {
                expMax = "$" + expMax;
            }
            try {
                expression = ExpressionUtil.betweenExpression(expMeasure, expMin, expMax, expLevels).getExpressionString();
            }
            catch (SerializationException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        } else {
            String expMeasure = "$" + this.getMeasure();
            String expValue = this.getValue();
            if (isMeasure && !this.isValueUserDefined()) {
                expValue = "$" + expValue;
            }
            if (this.getCondition().equals("==missing")) {
                expValue = "";
            }
            try {
                expression = ExpressionUtil.simpleExpression(expMeasure, this.getCondition(), expValue, expLevels, isMeasure).getExpressionString();
            }
            catch (SerializationException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        return expression;
    }

    public String getApplyToSelectedIndex() {
        return this.applyToSelectedIndex;
    }

    public void setApplyToSelectedIndex(String applyToSelectedIndex) {
        this.applyToSelectedIndex = applyToSelectedIndex;
    }

    public String[] getSelectedLevels() {
        return this.selectedLevels;
    }

    public void setSelectedLevels(String[] selectedLevels) {
        this.selectedLevels = selectedLevels;
    }
}

