/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.dataitems;

import com.sas.dataselectors.dataitems.BusinessModelTreeModelFactory;
import com.sas.dataselectors.dataitems.DataItemSelectorInterface;
import com.sas.dataselectors.dataitems.DataItemTreeNodeInfo;
import com.sas.dataselectors.dataitems.RB;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.MetadataNotChangeableException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.swing.visuals.dataselectors.dataitems.DisabledNode;
import com.sas.util.RoleInterface;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class TableRoles
implements DataItemSelectorInterface {
    public static final String COLUMN = "column";
    public static final String SLICER = "slicer";
    public static final String FILTER = "filter";
    private BusinessQuery _businessQuery;
    protected BusinessModel _businessModel;
    private ArrayList _roles;
    private Map _dataItemMap;
    protected List dataItemRefList;
    protected List originalItemList;
    protected String queryType;
    protected String[] selectedItems;
    Locale _locale;
    public static final String RB_KEY = "TableRoles.";
    public static final String RB_KEY2 = "OLAPTableRoles.";
    protected InformationMap iMap;
    private CommonLoggerInterface log = null;

    public TableRoles(BusinessQuery businessQuery) {
        this(businessQuery, null);
    }

    public TableRoles(BusinessQuery businessQuery, InformationMap imap) {
        ServicesLogFactory f = null;
        if (null != imap) {
            f = null != imap.getSession() ? new ServicesLogFactory(imap.getSession()) : new ServicesLogFactory();
        }
        this.log = LoggerRepository2.getLogger((String)TableRoles.class.getName(), f);
        this._businessQuery = businessQuery;
        this._businessModel = businessQuery.getBusinessModel();
        this.dataItemRefList = new ArrayList();
        this.originalItemList = null;
        this.mapDataSource();
        if (businessQuery != null && this.iMap == null) {
            BusinessModel bqmodel = businessQuery.getBusinessModel();
            while (!(bqmodel instanceof InformationMap)) {
                bqmodel = bqmodel.getBaseModel();
            }
            if (bqmodel instanceof InformationMap) {
                this.iMap = (InformationMap)bqmodel;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addRole(String name, String label, String description, int minRoleItemCount, int maxRoleItemCount) {
        if (name == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullRoleName.txt", this._locale));
        }
        if (label == null) {
            label = name;
        }
        if (description == null) {
            description = label;
        }
        if (!this.isValidRole(name)) throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidRoleType.txt", this._locale));
        if (this.getRole(name, label) != null) throw new IllegalStateException(RB.getStringResource(RB_KEY, "duplicateRole.txt", this._locale));
        try {
            Role role = new Role(name, label, description, minRoleItemCount, maxRoleItemCount);
            this.getRolesList().add(role);
            return;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected boolean isValidRole(String name) {
        return COLUMN.equals(name) || SLICER.equals(name) || FILTER.equals(name);
    }

    protected ArrayList getRolesList() {
        if (this._roles == null) {
            this._roles = new ArrayList();
        }
        return this._roles;
    }

    public void removeAllRoles() {
        this.getRolesList().clear();
    }

    public RoleInterface[] getRoles() {
        ArrayList rolesList = this.getRolesList();
        RoleInterface[] roleInterfaceArray = new RoleInterface[]{};
        if (rolesList.size() == 0) {
            return roleInterfaceArray;
        }
        return rolesList.toArray(roleInterfaceArray);
    }

    public List getRoleItems() {
        ArrayList roleItems = new ArrayList();
        if (this._businessModel != null) {
            List dataItems = Utils.filterObjects((BusinessModel)this._businessModel, (boolean)true, DataItem.class);
            int numitems = dataItems.size();
            for (Object dataitem : dataItems) {
                if (!((DataItem)dataitem).isUsableInQuery()) continue;
                roleItems.add(dataitem);
            }
        }
        return roleItems;
    }

    protected List getRoleItems(boolean isFilterRole) {
        ArrayList roleItems = new ArrayList();
        if (this._businessModel != null) {
            if (isFilterRole) {
                roleItems.add(this._businessQuery.getFilters());
            } else {
                List dataItems = this._businessModel.getObjects(true, DataItem.class);
                for (Object dataitem : dataItems) {
                    if (!((DataItem)dataitem).isUsableInQuery()) continue;
                    roleItems.add(dataitem);
                }
            }
        }
        return roleItems;
    }

    protected List removeItemsNotSupportingDetail(List items) {
        ArrayList<DataItem> detailItemList = new ArrayList<DataItem>();
        for (int i = 0; i < items.size(); ++i) {
            DataItem item = (DataItem)items.get(i);
            if (!item.isActionSupported(DataItemActionType.USAGE_DETAIL)) continue;
            detailItemList.add(item);
        }
        return detailItemList;
    }

    protected List removeDuplicateItems(List allDataItems) {
        ArrayList<DataItem> parentItemList = new ArrayList<DataItem>();
        ArrayList<DataItem> removeItemList = new ArrayList<DataItem>();
        for (DataItem item : allDataItems) {
            if (item instanceof DataItemReference) {
                DataItem dataItem = ((DataItemReference)item).getBaseDataItem();
                if (parentItemList.contains(dataItem)) {
                    removeItemList.add(item);
                } else {
                    parentItemList.add(dataItem);
                }
                parentItemList.add(item);
                continue;
            }
            parentItemList.add(item);
        }
        for (Object e : removeItemList) {
            allDataItems.remove(e);
        }
        return allDataItems;
    }

    protected List revertRefsToBaseItems(List allDataItems) {
        ArrayList<DataItem> baseItemList = new ArrayList<DataItem>();
        for (DataItem item : allDataItems) {
            if (item instanceof DataItemReference) {
                DataItem parentitem = ((DataItemReference)item).getBaseDataItem();
                baseItemList.add(parentitem);
                continue;
            }
            baseItemList.add(item);
        }
        return baseItemList;
    }

    public void mapDataSource() {
        if (this._dataItemMap == null) {
            this._dataItemMap = new HashMap();
        } else {
            this._dataItemMap.clear();
        }
        List allItems = this.getRoleItems();
        for (DataItem dataitem : allItems) {
            String thisid = null;
            try {
                thisid = dataitem.getID();
            }
            catch (InvalidIDException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            this._dataItemMap.put(thisid, dataitem);
            if (!(dataitem instanceof DataItemReference)) continue;
            DataItem baseDataItem = ((DataItemReference)dataitem).getBaseDataItem();
            String baseid = null;
            try {
                baseid = baseDataItem.getID();
            }
            catch (InvalidIDException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            this._dataItemMap.put(baseid, baseDataItem);
        }
    }

    public Object getItemFromItemMap(String itemid) {
        DataItem itemFromMap = null;
        Map itemmap = this.getDataItemMap();
        Collection valueSet = itemmap.values();
        for (DataItem item : valueSet) {
            if (!(item instanceof DataItemReference)) continue;
            DataItem parentItem = ((DataItemReference)item).getBaseDataItem();
            try {
                if (!itemid.equals(parentItem.getID())) continue;
                itemFromMap = item;
            }
            catch (InvalidIDException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (itemFromMap == null) {
            itemFromMap = (DataItem)itemmap.get(itemid);
        }
        return itemFromMap;
    }

    public String getBaseItemId(String itemid) {
        Object itemFromMap = null;
        Map itemmap = this.getDataItemMap();
        Collection valueSet = itemmap.values();
        for (DataItem item : valueSet) {
            if (!(item instanceof DataItemReference)) continue;
            try {
                if (!itemid.equals(item.getID())) continue;
                DataItem parentItem = ((DataItemReference)item).getBaseDataItem();
                return parentItem.getID();
            }
            catch (InvalidIDException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public boolean isThisItemAReferenceInItemMap(String itemid) {
        Map itemmap = this.getDataItemMap();
        Collection valueSet = itemmap.values();
        for (DataItem item : valueSet) {
            try {
                if (!item.getID().equalsIgnoreCase(itemid) || !(item instanceof DataItemReference)) continue;
                return true;
            }
            catch (InvalidIDException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public boolean isThisItemInAvailableList(String itemid, RoleInterface role) {
        List availableItems = role.getAvailableRoleItems();
        String thisid = null;
        for (DataItem item : availableItems) {
            try {
                thisid = item.getID();
            }
            catch (InvalidIDException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            if (!thisid.equalsIgnoreCase(itemid)) continue;
            return true;
        }
        return false;
    }

    public boolean isThisItemInRoleRefList(String itemid, RoleInterface role) {
        List reflist = ((Role)role).getDataItemReferenceList();
        String thisid = null;
        for (DataItem item : reflist) {
            try {
                thisid = item.getID();
            }
            catch (InvalidIDException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            if (!thisid.equalsIgnoreCase(itemid)) continue;
            return true;
        }
        return false;
    }

    protected List getOriginalItemList() {
        return this.originalItemList;
    }

    public Map getDataItemMap() {
        return this._dataItemMap;
    }

    public void setDataItemMap(Map map) {
        this._dataItemMap = map;
    }

    public static String getID(Object object) {
        String id = null;
        if (object != null) {
            id = Integer.toHexString(System.identityHashCode(object));
        }
        return id;
    }

    public void setSelectedItemsQueryType(String queryType) {
        RoleInterface[] rolesUsed = this.getRoles();
        DataItemActionType usage = null;
        if (queryType.equalsIgnoreCase("group")) {
            usage = DataItemActionType.USAGE_CATEGORY;
        } else if (queryType.equalsIgnoreCase("detail")) {
            usage = DataItemActionType.USAGE_DETAIL;
        }
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            RoleInterface thisrole = rolesUsed[i];
            List selecteditems = thisrole.getRoleItems();
            int count2 = selecteditems.size();
            for (int j = 0; j < count2; ++j) {
                DataItem thisitem = (DataItem)selecteditems.get(i);
                try {
                    if (!thisitem.isActionSupported(usage)) continue;
                    thisitem.setUsage(usage);
                    continue;
                }
                catch (MetadataException e) {
                    throw new IllegalArgumentException("Item does not support usage");
                }
            }
        }
    }

    protected List removeNotUsableItems(List allDataItems) {
        Iterator iter = allDataItems.iterator();
        while (iter.hasNext()) {
            DataItem item = (DataItem)iter.next();
            if (item.isUsableInQuery()) continue;
            iter.remove();
        }
        return allDataItems;
    }

    public TreeModel getAvailableTreeModel(TransformInterface transform, String selectedRole) {
        String querytype;
        RoleInterface[] rolesUsed = this.getRoles();
        List availableItems = null;
        List allItems = Utils.filterObjects((BusinessModel)this._businessModel, (boolean)true, DataItem.class);
        allItems = this.removeNotUsableItems(allItems);
        allItems = this.removeDuplicateItems(allItems);
        if (this.originalItemList == null) {
            this.setOriginalItemList(allItems);
        }
        if (selectedRole != null) {
            int count = rolesUsed.length;
            for (int i = 0; i < count; ++i) {
                if (!rolesUsed[i].getRoleName().equalsIgnoreCase(selectedRole) && !rolesUsed[i].getRoleLabel().equalsIgnoreCase(selectedRole)) continue;
                availableItems = rolesUsed[i].getAvailableRoleItems();
                break;
            }
        } else {
            availableItems = rolesUsed[0].getAvailableRoleItems();
        }
        if ((querytype = this.getQueryType()) != null && querytype.equalsIgnoreCase("detail")) {
            availableItems = this.removeItemsNotSupportingDetail(availableItems);
        }
        TreeModel tm = BusinessModelTreeModelFactory.getTreeModel(allItems, availableItems, transform, false, this.getLocale(), null, this.iMap);
        return tm;
    }

    protected void dumpThisItemList(List items) {
        for (int i = 0; i < items.size(); ++i) {
            try {
                DataItem thisitem = (DataItem)items.get(i);
                System.out.println("This item is " + thisitem.getLabel() + " id is " + thisitem.getID());
                if (thisitem instanceof DataItemReference) {
                    System.out.println("item is a DIR");
                    continue;
                }
                System.out.println("item is not a DIR");
                continue;
            }
            catch (MetadataException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void setOriginalItemList(List allItems) {
        this.originalItemList = new ArrayList();
        DataItem thisitem = null;
        String thisid = null;
        for (int i = 0; i < allItems.size(); ++i) {
            thisitem = (DataItem)allItems.get(i);
            try {
                thisid = thisitem.getID();
            }
            catch (InvalidIDException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            this.originalItemList.add(thisid);
        }
    }

    public List getAvailableEnabledNodeIds(String selectedRole) {
        String queryType;
        RoleInterface[] rolesUsed = this.getRoles();
        List availableItems = null;
        List roleDataItemRefList = null;
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            if (!rolesUsed[i].getRoleName().equalsIgnoreCase(selectedRole)) continue;
            availableItems = rolesUsed[i].getAvailableRoleItems();
            availableItems = this.removeDuplicateItems(availableItems);
            roleDataItemRefList = ((Role)rolesUsed[i]).getDataItemReferenceList();
            break;
        }
        if ((queryType = this.getQueryType()).equalsIgnoreCase("detail")) {
            availableItems = this.removeItemsNotSupportingDetail(availableItems);
        }
        ArrayList<String> availableIds = new ArrayList<String>();
        DataItem thisitem = null;
        String thisid = null;
        for (int i = 0; i < availableItems.size(); ++i) {
            thisitem = (DataItem)availableItems.get(i);
            try {
                thisid = thisitem.getID();
            }
            catch (InvalidIDException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            availableIds.add(thisid);
        }
        return availableIds;
    }

    public void cleanUp(String mode) {
        RoleInterface[] rolesUsed = this.getRoles();
        List roleDataItemRefList = null;
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            roleDataItemRefList = ((Role)rolesUsed[i]).getDataItemReferenceList();
            int count2 = roleDataItemRefList.size();
            for (int j = 0; j < count2; ++j) {
                DataItemReference ref = (DataItemReference)roleDataItemRefList.get(j);
                try {
                    this._businessModel.removeBusinessItem((BusinessItem)ref);
                    continue;
                }
                catch (MetadataException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
            roleDataItemRefList = null;
        }
    }

    private DataItemReference getDataItemReference(DataItem item, List reflist) {
        try {
            String originalItemId = item.getID();
            Iterator iter = reflist.iterator();
            String thisid = null;
            String refid = null;
            while (iter.hasNext()) {
                DataItemReference ref = (DataItemReference)iter.next();
                refid = ref.getID();
                DataItem baseitem = ref.getBaseDataItem();
                thisid = baseitem.getID();
                if (!thisid.equalsIgnoreCase(originalItemId)) continue;
                return ref;
            }
        }
        catch (InvalidIDException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private String getIdFromDataItemRefList(String itemid) {
        RoleInterface[] rolesUsed = this.getRoles();
        List roleDataItemRefList = null;
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            roleDataItemRefList = ((Role)rolesUsed[i]).getDataItemReferenceList();
            Iterator iter = roleDataItemRefList.iterator();
            String thisid = null;
            String refid = null;
            try {
                while (iter.hasNext()) {
                    DataItemReference ref = (DataItemReference)iter.next();
                    refid = ref.getID();
                    if (!refid.equals(itemid)) continue;
                    DataItem baseitem = ref.getBaseDataItem();
                    while (baseitem instanceof DataItemReference) {
                        baseitem = ((DataItemReference)baseitem).getBaseDataItem();
                    }
                    thisid = baseitem.getID();
                    return thisid;
                }
                continue;
            }
            catch (InvalidIDException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return itemid;
    }

    public List getAllAvailableNodeIds(boolean useOriginalIds) {
        List allItems = Utils.filterObjects((BusinessModel)this._businessModel, (boolean)true, DataItem.class);
        allItems = this.removeNotUsableItems(allItems);
        ArrayList<String> allIds = new ArrayList<String>();
        ArrayList<DataItem> calcItemRefList = new ArrayList<DataItem>();
        String thisid = null;
        DataItem thisitem = null;
        for (int i = 0; i < allItems.size(); ++i) {
            thisitem = (DataItem)allItems.get(i);
            try {
                thisid = thisitem.getID();
                if (useOriginalIds) {
                    thisid = this.getIdFromDataItemRefList(thisid);
                }
            }
            catch (InvalidIDException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            if (thisitem instanceof DataItemReference && thisitem.isCalculatedItem()) {
                calcItemRefList.add(thisitem);
            }
            allIds.add(thisid);
        }
        for (int j = 0; j < calcItemRefList.size(); ++j) {
            DataItem baseitem = ((DataItemReference)calcItemRefList.get(j)).getBaseDataItem();
            try {
                thisid = baseitem.getID();
                if (!allIds.contains(thisid)) continue;
                allIds.remove(thisid);
                continue;
            }
            catch (InvalidIDException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return allIds;
    }

    protected List removeCalculatedItemBaseItems(List listOfItems) {
        int numItems = listOfItems.size();
        ArrayList calcItemList = new ArrayList();
        for (int i = 0; i < numItems; ++i) {
            Object thisitem = listOfItems.get(i);
            if (!(thisitem instanceof DataItemReference) || !((DataItem)thisitem).isCalculatedItem()) continue;
            calcItemList.add(thisitem);
        }
        int numCalcItems = calcItemList.size();
        for (int i = 0; i < numCalcItems; ++i) {
            Object ref = calcItemList.get(i);
            DataItem baseitem = ((DataItemReference)ref).getBaseDataItem();
            if (!listOfItems.contains(baseitem)) continue;
            listOfItems.remove(baseitem);
        }
        return listOfItems;
    }

    public List getAvailableItemInfoList(String selectedRole) {
        return null;
    }

    public List getSelectedItemInfoList(String selectedRole) {
        return null;
    }

    public TreeModel getSelectedTreeModel(TransformInterface transform, String selectedRole) {
        DataItemTreeNodeInfo rootinfo = new DataItemTreeNodeInfo("selected_rootnode", "selected_rootnode", "selected_rootnode");
        Object selectedRootNode = new DisabledNode((Object)rootinfo);
        if (transform != null) {
            try {
                selectedRootNode = (DefaultMutableTreeNode)transform.transform(selectedRootNode);
            }
            catch (TransformException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        RoleInterface[] availableRoles = this.getRoles();
        int numRoles = availableRoles.length;
        String roleLabel = null;
        String roleName = null;
        List selectedItems = null;
        for (int i = 0; i < numRoles; ++i) {
            roleLabel = availableRoles[i].getRoleLabel();
            roleName = availableRoles[i].getRoleName();
            selectedItems = availableRoles[i].getRoleItems();
            TreeNode rolenode = BusinessModelTreeModelFactory.getSelectedModelNode(roleLabel, roleName, selectedItems, transform, selectedRole);
            if (numRoles > 1) {
                ((DefaultMutableTreeNode)selectedRootNode).add((DefaultMutableTreeNode)rolenode);
                continue;
            }
            int numberOfChildren = rolenode.getChildCount();
            for (int j = 0; j < numberOfChildren; ++j) {
                ((DefaultMutableTreeNode)selectedRootNode).add((DefaultMutableTreeNode)rolenode.getChildAt(0));
            }
        }
        DefaultTreeModel selectedModel = new DefaultTreeModel((TreeNode)selectedRootNode);
        return selectedModel;
    }

    protected List getAvailableRoleItems(RoleInterface role) {
        boolean isFilterRole = FILTER.equals(role.getRoleName());
        List allAvailableRoleItems = this.getRoleItems(isFilterRole);
        List currentRoleItems = role.getRoleItems();
        if (role.getMaxRoleItemCount() != 0 && currentRoleItems.size() == role.getMaxRoleItemCount()) {
            allAvailableRoleItems.clear();
            return allAvailableRoleItems;
        }
        RoleInterface[] roles = this.getRoles();
        if (roles.length > 1) {
            int count = roles.length;
            for (int i = 0; i < count; ++i) {
                List roleItems = roles[i].getRoleItems();
                int count2 = roleItems.size();
                for (int j = 0; j < count2; ++j) {
                    if (!allAvailableRoleItems.contains(roleItems.get(j))) continue;
                    allAvailableRoleItems.remove(roleItems.get(j));
                }
            }
        }
        return allAvailableRoleItems;
    }

    public RoleInterface getRole(String name, String label) {
        if (name == null || this.getRoles().length == 0) {
            return null;
        }
        ArrayList rolesList = this.getRolesList();
        int count = rolesList.size();
        for (int i = 0; i < count; ++i) {
            RoleInterface role = (RoleInterface)rolesList.get(i);
            if (!name.equals(role.getRoleName()) || !label.equalsIgnoreCase(role.getRoleLabel())) continue;
            return role;
        }
        return null;
    }

    protected boolean hasValidRoles() {
        RoleInterface[] roles = this.getRoles();
        int count = roles.length;
        for (int i = 0; i < count; ++i) {
            List roleItems = roles[i].getRoleItems();
            int roleMinCount = roles[i].getMinRoleItemCount();
            int roleMaxCount = roles[i].getMaxRoleItemCount();
            if (!(roleItems.size() == 0 ? roleMinCount != 0 : roleItems.size() < roleMinCount || roleItems.size() > roleMaxCount && roleMaxCount != 0)) continue;
            return false;
        }
        return true;
    }

    public String getStatusMessage() {
        if (!this.hasValidRoles()) {
            return RB.getStringResource(RB_KEY, "inValidRole.txt", this._locale);
        }
        return null;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
        RoleInterface[] allRoles = this.getRoles();
        for (int i = 0; i < allRoles.length; ++i) {
            RoleInterface thisrole = allRoles[i];
            if (thisrole.getRoleName().equalsIgnoreCase(COLUMN)) {
                ((Role)thisrole).setRoleLabel(RB.getStringResource(RB_KEY, "columnRoleLabel.txt", this._locale));
                continue;
            }
            if (!thisrole.getRoleName().equalsIgnoreCase("row")) continue;
            ((Role)thisrole).setRoleLabel(RB.getStringResource(RB_KEY2, "rowRoleLabel.txt", this._locale));
        }
    }

    public boolean isCalculatedItemSelected() {
        RoleInterface[] rolesUsed = this.getRoles();
        List selectedItems = null;
        DataItem thisitem = null;
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            selectedItems = rolesUsed[i].getRoleItems();
            int count2 = selectedItems.size();
            for (int j = 0; j < count2; ++j) {
                thisitem = (DataItem)selectedItems.get(j);
                if (!thisitem.isCalculatedItem()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean queryItemsSupportDetailUsage() {
        RoleInterface[] rolesUsed = this.getRoles();
        List selectedItems = null;
        DataItem thisitem = null;
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            selectedItems = rolesUsed[i].getRoleItems();
            int count2 = selectedItems.size();
            for (int j = 0; j < count2; ++j) {
                thisitem = (DataItem)selectedItems.get(j);
                if (thisitem.isActionSupported(DataItemActionType.USAGE_DETAIL)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean allQueryItemsAreDetailUsage() {
        RoleInterface[] rolesUsed = this.getRoles();
        List selectedItems = null;
        DataItem thisitem = null;
        boolean returnValue = true;
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            selectedItems = rolesUsed[i].getRoleItems();
            if (selectedItems.size() == 0) {
                returnValue = false;
            }
            int count2 = selectedItems.size();
            for (int j = 0; j < count2; ++j) {
                thisitem = (DataItem)selectedItems.get(j);
                if (thisitem.getUsage() == DataItemActionType.USAGE_DETAIL) continue;
                returnValue = false;
                break;
            }
            if (!returnValue) break;
        }
        return returnValue;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public boolean isItemMoveUpValid() {
        return true;
    }

    public boolean isItemMoveDownValid() {
        return true;
    }

    public List getMoveTargetRoles() {
        return null;
    }

    public void setSelectedItems(String[] items) {
        this.selectedItems = items;
    }

    protected class Role
    implements RoleInterface {
        private String _name;
        private String _label;
        private String _description;
        private int _minCount;
        private int _maxCount;
        protected ArrayList _roleItems;
        private List dataItemRefList;

        public Role(String name, String label, String description, int minCount, int maxCount) throws IllegalArgumentException {
            if (name == null) {
                throw new IllegalArgumentException(RB.getStringResource(TableRoles.RB_KEY, "nullRoleName.txt", TableRoles.this._locale));
            }
            this._name = name;
            if (label == null) {
                throw new IllegalArgumentException(RB.getStringResource(TableRoles.RB_KEY, "nullRoleLabel.txt", TableRoles.this._locale));
            }
            this._label = label;
            this._description = description == null ? this._label : description;
            if (minCount < 0) {
                throw new IllegalArgumentException(RB.getStringResource(TableRoles.RB_KEY, "negativeMinimumCount.txt", TableRoles.this._locale));
            }
            this._minCount = minCount;
            if (maxCount < 0) {
                throw new IllegalArgumentException(RB.getStringResource(TableRoles.RB_KEY, "negativeMaximumCount.txt", TableRoles.this._locale));
            }
            this._maxCount = maxCount;
            this._roleItems = new ArrayList();
            this.dataItemRefList = new ArrayList();
        }

        public List getDataItemReferenceList() {
            return this.dataItemRefList;
        }

        public String getRoleName() {
            return this._name;
        }

        public String getRoleLabel() {
            return this._label;
        }

        public void setRoleLabel(String label) {
            this._label = label;
        }

        public String getRoleDetailedLabel() {
            return this._label;
        }

        public void setRoleDetailedLabel(String label) {
        }

        public String getRoleDescription() {
            return this._description;
        }

        public int getMinRoleItemCount() {
            return this._minCount;
        }

        public int getMaxRoleItemCount() {
            return this._maxCount;
        }

        public String getRoleOpenedIcon() {
            return null;
        }

        public String getRoleClosedIcon() {
            return null;
        }

        public String getRoleDisabledIcon() {
            return null;
        }

        public List getAvailableRoleItems() {
            return TableRoles.this.getAvailableRoleItems(this);
        }

        public List getRoleItems() {
            ArrayList items = new ArrayList();
            int count = this._roleItems.size();
            for (int i = 0; i < count; ++i) {
                items.add(this._roleItems.get(i));
            }
            return items;
        }

        public void moveRoleItem(Object item, int index) {
            int moveindex;
            int currentItemIndex = this._roleItems.indexOf(item);
            if (currentItemIndex >= 0 && (moveindex = currentItemIndex + index) >= 0 && moveindex < this._roleItems.size()) {
                Collections.swap(this._roleItems, currentItemIndex, currentItemIndex + index);
            }
        }

        public void addRoleItem(Object item) {
            this.addRoleItem(item, null);
        }

        public void addRoleItem(Object item, List availableRoleItems) {
            if (availableRoleItems == null) {
                availableRoleItems = TableRoles.this.getAvailableRoleItems(this);
            }
            RoleInterface[] roles = TableRoles.this.getRoles();
            int numroles = roles.length;
            List lastObjectsAdded = TableRoles.this._businessModel.getObjects(false, DataItem.class);
            List allObjects = TableRoles.this._businessModel.getObjects(true, DataItem.class);
            boolean inAvailableItems = false;
            if (availableRoleItems.contains(item)) {
                inAvailableItems = true;
            }
            if (inAvailableItems) {
                try {
                    if (!lastObjectsAdded.contains(item) || lastObjectsAdded.contains(item) && (this._roleItems.contains(item) || !allObjects.contains(item))) {
                        DataItemReference ref = TableRoles.this._businessModel.newDataItemReference((DataItem)item);
                        this.dataItemRefList.add(ref);
                        this._roleItems.add(ref);
                        TableRoles.this._businessModel.addBusinessItem((BusinessItem)ref);
                        TableRoles.this._dataItemMap.put(ref.getID(), ref);
                    } else if (lastObjectsAdded.contains(item)) {
                        this._roleItems.add(item);
                    }
                }
                catch (MetadataNotChangeableException e) {
                    TableRoles.this.log.error(e.getMessage(), (Throwable)e);
                }
                catch (MetadataException e) {
                    TableRoles.this.log.error(e.getMessage(), (Throwable)e);
                }
            } else {
                throw new IllegalArgumentException(RB.getStringResource(TableRoles.RB_KEY, "itemNotAvailable.txt", TableRoles.this._locale));
            }
        }

        private DataItem getItemFromDataItemReferenceList(DataItemReference item, List reflist) {
            DataItem baseitem = item.getBaseDataItem();
            int numrefs = reflist.size();
            DataItemReference ref = null;
            for (int i = 0; i < numrefs; ++i) {
                DataItem baseitemtoref;
                Object myitem = reflist.get(i);
                if (!(myitem instanceof DataItemReference) || baseitem != (baseitemtoref = (ref = item).getBaseDataItem())) continue;
                return ref;
            }
            return item;
        }

        private DataItem getItemFromDataItemReferenceList(DataItem item, List reflist) {
            int numrefs = reflist.size();
            DataItemReference ref = null;
            for (int i = 0; i < numrefs; ++i) {
                DataItem baseitemtoref;
                Object myitem = reflist.get(i);
                if (!(myitem instanceof DataItemReference) || item != (baseitemtoref = (ref = (DataItemReference)reflist.get(i)).getBaseDataItem())) continue;
                return ref;
            }
            return null;
        }

        public List addRoleItems(List items) {
            List availableRoleItems = TableRoles.this.getAvailableRoleItems(this);
            ArrayList itemsNotAdded = new ArrayList();
            int count = items.size();
            for (int i = 0; i < count; ++i) {
                try {
                    this.addRoleItem(items.get(i), availableRoleItems);
                    continue;
                }
                catch (Exception e) {
                    itemsNotAdded.add(items.get(i));
                }
            }
            if (itemsNotAdded.size() == 0) {
                return null;
            }
            return itemsNotAdded;
        }

        public void removeRoleItem(Object item) {
            List refList = this.getDataItemReferenceList();
            DataItemReference ref = null;
            DataItem baseDataItem = null;
            if (refList.contains(item)) {
                try {
                    TableRoles.this._businessModel.removeBusinessItem((BusinessItem)((DataItem)item));
                }
                catch (MetadataException e) {
                    TableRoles.this.log.error(e.getMessage(), (Throwable)e);
                }
                refList.remove(item);
            } else {
                for (int i = 0; i < refList.size(); ++i) {
                    ref = (DataItemReference)refList.get(i);
                    baseDataItem = ref.getBaseDataItem();
                    if (baseDataItem == item) {
                        try {
                            TableRoles.this._businessModel.removeBusinessItem((BusinessItem)ref);
                        }
                        catch (MetadataException e) {
                            TableRoles.this.log.error(e.getMessage(), (Throwable)e);
                        }
                        refList.remove(ref);
                        break;
                    }
                    ref = null;
                }
            }
            if (this._roleItems.contains(item)) {
                this._roleItems.remove(item);
            } else if (this._roleItems.contains(ref)) {
                this._roleItems.remove(ref);
            }
            TableRoles.this.mapDataSource();
        }

        public void removeAllRoleItems() {
            this._roleItems.clear();
        }

        public String toString() {
            return " name= " + this.getRoleName() + " label= " + this.getRoleLabel() + " description= " + this.getRoleDescription() + " minRoleItemCount= " + this.getMinRoleItemCount() + " maxRoleItemCount= " + this.getMaxRoleItemCount() + " has " + this.getRoleItems().size() + " role items";
        }
    }
}

