/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.dataitems;

import com.sas.dataselectors.dataitems.BaseDataItemSelectorModel;
import com.sas.dataselectors.dataitems.BusinessModelTreeModelFactory;
import com.sas.dataselectors.dataitems.RB;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.MetadataNotChangeableException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.util.RoleInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.TransformInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class DataItemSelectorModel
extends BaseDataItemSelectorModel {
    private BusinessQuery _businessQuery;
    protected BusinessModel _businessModel;
    protected InformationMap iMap;
    public static final String RB_KEY = "DataItemSelectorModel.";

    public DataItemSelectorModel() {
    }

    public DataItemSelectorModel(BusinessQuery businessQuery) {
        this(businessQuery, null);
    }

    public DataItemSelectorModel(BusinessQuery businessQuery, InformationMap imap) {
        this._businessQuery = businessQuery;
        this._businessModel = businessQuery.getBusinessModel();
        this.originalItemList = null;
        this.mapDataSource();
        if (businessQuery != null && this.iMap == null) {
            BusinessModel bqmodel = businessQuery.getBusinessModel();
            while (!(bqmodel instanceof InformationMap)) {
                bqmodel = bqmodel.getBaseModel();
            }
            if (bqmodel instanceof InformationMap) {
                this.iMap = (InformationMap)bqmodel;
            }
        }
    }

    @Override
    public List getRoleItems() {
        ArrayList roleItems = new ArrayList();
        if (this._businessModel != null) {
            List dataItems = Utils.filterObjects((BusinessModel)this._businessModel, (boolean)true, DataItem.class);
            int numitems = dataItems.size();
            for (Object dataitem : dataItems) {
                if (!((DataItem)dataitem).isUsableInQuery()) continue;
                roleItems.add(dataitem);
            }
        }
        return roleItems;
    }

    @Override
    public RoleInterface[] getRoles() {
        if (this._rolesList == null) {
            this.createRoles();
        }
        return this._rolesList.toArray(new BaseDataItemSelectorModel.Role[0]);
    }

    @Override
    public TreeModel getAvailableTreeModel(TransformInterface transform, String selectedRole) {
        String querytype;
        RoleInterface[] rolesUsed = this.getRoles();
        List availableItems = null;
        List allItems = this.getRoleItems();
        allItems = this.removeNotUsableItems(allItems);
        allItems = this.removeDuplicateItems(allItems);
        if (this.originalItemList == null) {
            this.setOriginalItemList(allItems);
        }
        if (selectedRole != null) {
            int count = rolesUsed.length;
            for (int i = 0; i < count; ++i) {
                if (!rolesUsed[i].getRoleName().equalsIgnoreCase(selectedRole) && !rolesUsed[i].getRoleLabel().equalsIgnoreCase(selectedRole)) continue;
                availableItems = rolesUsed[i].getAvailableRoleItems();
                break;
            }
        } else {
            availableItems = rolesUsed[0].getAvailableRoleItems();
        }
        if ((querytype = this.getQueryType()) != null && querytype.equalsIgnoreCase("detail")) {
            availableItems = this.removeItemsNotSupportingDetail(availableItems);
        }
        return this.getAvailableTreeModel(allItems, availableItems, transform);
    }

    @Override
    public void cleanUp(String mode) {
        RoleInterface[] rolesUsed = this.getRoles();
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            List roleDataItemRefList = ((BaseDataItemSelectorModel.Role)rolesUsed[i]).getDataItemReferenceList();
            int count2 = roleDataItemRefList.size();
            for (int j = 0; j < count2; ++j) {
                DataItemReference ref = (DataItemReference)roleDataItemRefList.get(j);
                try {
                    this._businessModel.removeBusinessItem((BusinessItem)ref);
                    continue;
                }
                catch (MetadataException e) {
                    LoggerRepository2.getLogger((String)DataItemSelectorModel.class.getName(), null).error(e.getMessage(), (Throwable)e);
                }
            }
            roleDataItemRefList = null;
        }
    }

    @Override
    protected TreeModel getAvailableTreeModel(List allItems, List availableItems, TransformInterface transform) {
        return BusinessModelTreeModelFactory.getTreeModel(allItems, availableItems, transform, false, this.getLocale(), null, this.iMap);
    }

    @Override
    protected TreeNode getSelectedTreeNode(RoleInterface role, TransformInterface transform, String selectedRole) {
        return BusinessModelTreeModelFactory.getSelectedModelNode(role.getRoleLabel(), role.getRoleName(), role.getRoleItems(), transform, selectedRole);
    }

    @Override
    protected List removeNotUsableItems(List allDataItems) {
        Iterator iter = allDataItems.iterator();
        while (iter.hasNext()) {
            DataItem item = (DataItem)iter.next();
            if (item.isUsableInQuery()) continue;
            iter.remove();
        }
        return allDataItems;
    }

    @Override
    protected List removeDuplicateItems(List allItems) {
        ArrayList<DataItem> parentItemList = new ArrayList<DataItem>();
        ArrayList<DataItem> removeItemList = new ArrayList<DataItem>();
        for (DataItem item : allItems) {
            if (item instanceof DataItemReference) {
                DataItem dataItem = ((DataItemReference)item).getBaseDataItem();
                if (parentItemList.contains(dataItem)) {
                    removeItemList.add(item);
                } else {
                    parentItemList.add(dataItem);
                }
                parentItemList.add(item);
                continue;
            }
            parentItemList.add(item);
        }
        for (Object e : removeItemList) {
            allItems.remove(e);
        }
        return allItems;
    }

    @Override
    protected List removeItemsNotSupportingDetail(List items) {
        ArrayList<DataItem> detailItemList = new ArrayList<DataItem>();
        for (int i = 0; i < items.size(); ++i) {
            DataItem item = (DataItem)items.get(i);
            if (!item.isActionSupported(DataItemActionType.USAGE_DETAIL)) continue;
            detailItemList.add(item);
        }
        return detailItemList;
    }

    @Override
    protected void setOriginalItemList(List allItems) {
        this.originalItemList = new ArrayList();
        Object thisid = null;
        for (int i = 0; i < allItems.size(); ++i) {
            this.originalItemList.add(this.getItemID(allItems.get(i)));
        }
    }

    @Override
    protected String getItemID(Object item) {
        DataItem thisitem = (DataItem)item;
        try {
            return thisitem.getID();
        }
        catch (InvalidIDException e) {
            LoggerRepository2.getLogger((String)DataItemSelectorModel.class.getName(), null).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    protected String getItemLabel(Object item) {
        DataItem thisitem = (DataItem)item;
        return thisitem.getLabel();
    }

    @Override
    protected String getItemDescription(Object item) {
        DataItem thisitem = (DataItem)item;
        return thisitem.getDescription();
    }

    @Override
    protected String getItemCategory(Object item) {
        DataItem thisitem = (DataItem)item;
        StructureOfDataItem sodi = thisitem.getStructure();
        if (sodi.equals(StructureOfDataItem.STRUCTURE_HIERARCHY)) {
            return RB.getStringResource(RB_KEY, "hierarchies.txt", this._locale);
        }
        if (sodi.equals(StructureOfDataItem.STRUCTURE_DIMENSION)) {
            return RB.getStringResource(RB_KEY, "hierarchies.txt", this._locale);
        }
        if (sodi.equals(StructureOfDataItem.STRUCTURE_LEVEL)) {
            return RB.getStringResource(RB_KEY, "levels.txt", this._locale);
        }
        if (sodi.equals(StructureOfDataItem.STRUCTURE_MEASURE)) {
            return RB.getStringResource(RB_KEY, "measures.txt", this._locale);
        }
        return null;
    }

    @Override
    protected String getItemDefaultImage(Object item) {
        DataItem thisitem = (DataItem)item;
        StructureOfDataItem sodi = thisitem.getStructure();
        if (sodi.equals(StructureOfDataItem.STRUCTURE_HIERARCHY)) {
            return RB.getStringResource(RB_KEY, "hierarchy.icon", this._locale);
        }
        if (sodi.equals(StructureOfDataItem.STRUCTURE_DIMENSION)) {
            return RB.getStringResource(RB_KEY, "dimension.icon", this._locale);
        }
        if (sodi.equals(StructureOfDataItem.STRUCTURE_LEVEL)) {
            return RB.getStringResource(RB_KEY, "level.icon", this._locale);
        }
        if (sodi.equals(StructureOfDataItem.STRUCTURE_MEASURE)) {
            return RB.getStringResource(RB_KEY, "measure.icon", this._locale);
        }
        return null;
    }

    @Override
    protected String getItemDisabledImage(Object item) {
        DataItem thisitem = (DataItem)item;
        StructureOfDataItem sodi = thisitem.getStructure();
        if (sodi.equals(StructureOfDataItem.STRUCTURE_HIERARCHY)) {
            return RB.getStringResource(RB_KEY, "hierarchyDisabled.icon", this._locale);
        }
        if (sodi.equals(StructureOfDataItem.STRUCTURE_DIMENSION)) {
            return RB.getStringResource(RB_KEY, "dimensionDisabled.icon", this._locale);
        }
        if (sodi.equals(StructureOfDataItem.STRUCTURE_LEVEL)) {
            return RB.getStringResource(RB_KEY, "levelDisabled.icon", this._locale);
        }
        if (sodi.equals(StructureOfDataItem.STRUCTURE_MEASURE)) {
            return RB.getStringResource(RB_KEY, "measureDisabled.icon", this._locale);
        }
        return null;
    }

    @Override
    protected boolean isCalculatedItem(Object item) {
        DataItem thisitem = (DataItem)item;
        return thisitem.isCalculatedItem();
    }

    @Override
    protected boolean isDetailUsageSupported(Object item) {
        DataItem thisitem = (DataItem)item;
        return thisitem.isActionSupported(DataItemActionType.USAGE_DETAIL);
    }

    @Override
    protected boolean isItemUsageDetail(Object item) {
        DataItem thisitem = (DataItem)item;
        return thisitem.getUsage() == DataItemActionType.USAGE_DETAIL;
    }

    @Override
    protected boolean isItemActionSupported(Object item, String queryType) {
        DataItem thisitem = (DataItem)item;
        DataItemActionType usage = null;
        if (queryType.equalsIgnoreCase("group")) {
            usage = DataItemActionType.USAGE_CATEGORY;
        } else if (queryType.equalsIgnoreCase("detail")) {
            usage = DataItemActionType.USAGE_DETAIL;
        }
        return thisitem.isActionSupported(usage);
    }

    @Override
    protected void setItemUsage(Object item, String queryType) {
        DataItem thisitem = (DataItem)item;
        DataItemActionType usage = null;
        if (queryType.equalsIgnoreCase("group")) {
            usage = DataItemActionType.USAGE_CATEGORY;
        } else if (queryType.equalsIgnoreCase("detail")) {
            usage = DataItemActionType.USAGE_DETAIL;
        }
        try {
            thisitem.setUsage(usage);
        }
        catch (MetadataException e) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "itemNotSupportUsage.ex.txt", this._locale));
        }
    }

    @Override
    protected Object getBaseItem(Object item) {
        Object baseItem = item;
        while (baseItem instanceof DataItemReference) {
            baseItem = ((DataItemReference)baseItem).getBaseDataItem();
        }
        return baseItem;
    }

    @Override
    protected String getRoleLabel(String role) {
        return null;
    }

    @Override
    protected boolean isItemAReference(Object item) {
        return item instanceof DataItemReference;
    }

    @Override
    protected boolean isMeasure(Object item) {
        if (!(item instanceof DataItem)) {
            return false;
        }
        DataItem dataItem = (DataItem)item;
        DataItemActionType usage = dataItem.getUsage();
        while (usage == DataItemActionType.USAGE_DETAIL && dataItem instanceof DataItemReference) {
            dataItem = ((DataItemReference)dataItem).getBaseDataItem();
            usage = dataItem.getUsage();
        }
        return usage == DataItemActionType.USAGE_AGGREGATE;
    }

    @Override
    protected void addItemToRole(Object item, RoleInterface role, List roleList, Map itemMap) {
        List lastObjectsAdded = this._businessModel.getObjects(false, DataItem.class);
        List allObjects = this._businessModel.getObjects(true, DataItem.class);
        try {
            if (!lastObjectsAdded.contains(item) || lastObjectsAdded.contains(item) && (roleList.contains(item) || !allObjects.contains(item))) {
                if (item instanceof DataItemReference) {
                    item = ((DataItemReference)item).getBaseDataItem();
                }
                DataItemReference ref = this._businessModel.newDataItemReference((DataItem)item);
                ((BaseDataItemSelectorModel.Role)role).getDataItemReferenceList().add(ref);
                roleList.add(ref);
                this._businessModel.addBusinessItem((BusinessItem)ref);
                itemMap.put(ref.getID(), ref);
            } else if (lastObjectsAdded.contains(item)) {
                roleList.add(item);
            }
        }
        catch (MetadataNotChangeableException e) {
            LoggerRepository2.getLogger((String)DataItemSelectorModel.class.getName(), null).error(e.getMessage(), (Throwable)e);
        }
        catch (MetadataException e) {
            LoggerRepository2.getLogger((String)DataItemSelectorModel.class.getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void removeItemFromRole(Object item, List roleList, List refList) {
        DataItemReference ref = null;
        if (refList.contains(item)) {
            try {
                this._businessModel.removeBusinessItem((BusinessItem)((DataItem)item));
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)DataItemSelectorModel.class.getName(), null).error(e.getMessage(), (Throwable)e);
            }
            refList.remove(item);
        } else {
            for (int i = 0; i < refList.size(); ++i) {
                ref = (DataItemReference)refList.get(i);
                DataItem baseDataItem = ref.getBaseDataItem();
                if (baseDataItem == item) {
                    try {
                        this._businessModel.removeBusinessItem((BusinessItem)ref);
                    }
                    catch (MetadataException e) {
                        LoggerRepository2.getLogger((String)DataItemSelectorModel.class.getName(), null).error(e.getMessage(), (Throwable)e);
                    }
                    refList.remove(ref);
                    break;
                }
                ref = null;
            }
        }
        if (roleList.contains(item)) {
            roleList.remove(item);
        } else if (roleList.contains(ref)) {
            roleList.remove(ref);
        }
    }

    protected void createRoles() {
        this._rolesList = new ArrayList();
    }

    @Override
    public List getMoveTargetRoles() {
        if (this.getRoleItems() == null) {
            return null;
        }
        RoleInterface[] roles = this.getRoles();
        List<RoleInterface> rolesListFixedSize = Arrays.asList(roles);
        ArrayList<RoleInterface> rolesList = new ArrayList<RoleInterface>(rolesListFixedSize);
        String[] highlightedItems = this.getSelectedItems();
        RoleInterface currentRole = null;
        for (int i = 0; i < highlightedItems.length; ++i) {
            Object item = this.getItemFromItemMap(highlightedItems[i]);
            if (item == null) continue;
            if (currentRole == null) {
                currentRole = this.findRoleForItem(item);
                continue;
            }
            RoleInterface itemRole = this.findRoleForItem(item);
            if (itemRole == null || currentRole.equals(itemRole)) continue;
            currentRole = null;
            break;
        }
        if (currentRole != null) {
            rolesList.remove(currentRole);
        }
        return rolesList;
    }
}

