/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.calculations.percent;

import com.sas.dataselectors.calculations.percent.PercentCalculationsSelectorDataSource;
import com.sas.dataselectors.calculations.percent.RB;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class PercentCalculationsSelectorOLAPDataSource
extends PercentCalculationsSelectorDataSource {
    private static final String RB_KEY = "PercentCalculationsSelectorOLAPDataSource.";

    public PercentCalculationsSelectorOLAPDataSource() {
        this(null);
    }

    public PercentCalculationsSelectorOLAPDataSource(BusinessQueryProviderInterface model) {
        this.setModel(model);
    }

    @Override
    public boolean isOLAP() {
        return true;
    }

    @Override
    public Map getNumerators() {
        LinkedHashMap<String, String> numerators = new LinkedHashMap<String, String>();
        BusinessQueryProviderInterface model = this.getModel();
        if (model == null) {
            throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"nullModel.txt", (Locale)this.getLocale()));
        }
        if (model.getBusinessQuery() instanceof DataSelection) {
            DataSelection ds = (DataSelection)model.getBusinessQuery();
            for (DataItem dataItem : ds.getResultItems()) {
                if (!PercentCalculationsSelectorOLAPDataSource.isValidNumerator(dataItem, ds)) continue;
                numerators.put(dataItem.getIntraModelID(), dataItem.getLabel());
            }
        }
        return numerators;
    }

    public static boolean isValidNumerator(DataItem dataItem, DataSelection dataSelection) {
        if (!dataItem.getStructure().equals(StructureOfDataItem.STRUCTURE_MEASURE)) {
            return false;
        }
        if (dataItem.getExpression() instanceof FractionOfTotalExpression) {
            return false;
        }
        try {
            Role role = dataSelection.getResultItemRole(dataItem);
            if (role.equals(Role.BACKGROUND) || role.equals(Role.HIDDEN) || role.equals(Role.PAGE)) {
                return false;
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public Map getDenominators() {
        LinkedHashMap<Integer, String> denominators = new LinkedHashMap<Integer, String>();
        BusinessQueryProviderInterface model = this.getModel();
        if (model == null) {
            throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"nullModel.txt", (Locale)this.getLocale()));
        }
        denominators.put(new Integer(1), RB.getStringResource((String)RB_KEY, (String)"grandTotal.txt", (Locale)this.getLocale()));
        denominators.put(new Integer(2), RB.getStringResource((String)RB_KEY, (String)"rowTotal.txt", (Locale)this.getLocale()));
        denominators.put(new Integer(4), RB.getStringResource((String)RB_KEY, (String)"rowSubtotals.txt", (Locale)this.getLocale()));
        denominators.put(new Integer(3), RB.getStringResource((String)RB_KEY, (String)"columnTotal.txt", (Locale)this.getLocale()));
        denominators.put(new Integer(5), RB.getStringResource((String)RB_KEY, (String)"columnSubtotals.txt", (Locale)this.getLocale()));
        return denominators;
    }

    @Override
    protected String getResourceKeyForDenominatorType(int denominatorType) {
        if (denominatorType == 3) {
            return "columnTotal.txt";
        }
        if (denominatorType == 5) {
            return "columnSubtotals.txt";
        }
        if (denominatorType == 2) {
            return "rowTotal.txt";
        }
        if (denominatorType == 4) {
            return "rowSubtotals.txt";
        }
        return "grandTotal.txt";
    }
}

