/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.calculateditems;

import com.sas.dataselectors.calculateditems.RB;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class TimeFunctions {
    public static final String RB_KEY = "TimeFunctions.";
    public static final String NONE = "NONE";
    public static final String DIFFERENCE_PREVIOUS_PERIOD = "DIFFERENCE_PREVIOUS_PERIOD";
    public static final String DIFFERENCE_PREVIOUS_YEAR = "DIFFERENCE_PREVIOUS_YEAR";
    public static final String DIFFERENCE_PERIOD = "DIFFERENCE_PERIOD";
    public static final String DIFFERENCE_YEAR = "DIFFERENCE_YEAR";
    public static final String PERCENTCHANGE_PREVIOUS_PERIOD = "PERCENTCHANGE_PREVIOUS_PERIOD";
    public static final String PERCENTCHANGE_PREVIOUS_YEAR = "PERCENTCHANGE_PREVIOUS_YEAR";
    public static final String PERCENTCHANGE_PERIOD = "PERCENTCHANGE_PERIOD";
    public static final String PERCENTCHANGE_YEAR = "PERCENTCHANGE_YEAR";
    public static final String CUMULATIVE = "CUMULATIVE";
    public static final String CUMULATIVE_DEFAULT_PERIOD = "CUMULATIVE";
    public static final String CUMULATIVE_BASE_PERIOD = "CUMULATIVE_BASE_PERIOD";
    private static String[] EMPTY_STRING_ARRAY = new String[0];
    private Map timeFunctionMap = new LinkedHashMap(7);
    private Map timeExpressionMap = new LinkedHashMap(7);
    private Locale locale;

    private void populateFunctions() {
        String selectedMeasure = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"selectedMeasure.txt", (Locale)this.locale);
        String selectedPeriod = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"selectedPeriod.txt", (Locale)this.locale);
        this.timeFunctionMap.put(RB.getStringResource((String)RB_KEY, (String)"TimeFunction_None.txt", (Locale)this.locale), NONE);
        this.timeFunctionMap.put(RB.getStringResource((String)RB_KEY, (String)"TimeFunction_DifferencePreviousPeriod.txt", (Locale)this.locale), DIFFERENCE_PREVIOUS_PERIOD);
        this.timeFunctionMap.put(RB.getStringResource((String)RB_KEY, (String)"TimeFunction_DifferenceParallelPeriod.txt", (Locale)this.locale), DIFFERENCE_PREVIOUS_YEAR);
        this.timeFunctionMap.put(RB.getStringResource((String)RB_KEY, (String)"TimeFunction_RatioPreviousPeriod.txt", (Locale)this.locale), PERCENTCHANGE_PREVIOUS_PERIOD);
        this.timeFunctionMap.put(RB.getStringResource((String)RB_KEY, (String)"TimeFunction_RatioParallelPeriod.txt", (Locale)this.locale), PERCENTCHANGE_PREVIOUS_YEAR);
        this.timeFunctionMap.put(RB.getStringResource((String)RB_KEY, (String)"TimeFunction_CumulativeDefaultPeriod.txt", (Locale)this.locale), "CUMULATIVE");
        this.timeFunctionMap.put(RB.getStringResource((String)RB_KEY, (String)"TimeFunction_CumulativeBasePeriod.txt", (Locale)this.locale), CUMULATIVE_BASE_PERIOD);
        this.timeExpressionMap.put(RB.getStringResource((String)RB_KEY, (String)"TimeExpression_None.txt", (Locale)this.locale), NONE);
        this.timeExpressionMap.put(MessageFormat.format(RB.getStringResource((String)RB_KEY, (String)"TimeExpression_DifferencePreviousPeriod.txt", (Locale)this.locale), selectedMeasure), DIFFERENCE_PREVIOUS_PERIOD);
        this.timeExpressionMap.put(MessageFormat.format(RB.getStringResource((String)RB_KEY, (String)"TimeExpression_DifferenceParallelPeriod.txt", (Locale)this.locale), selectedMeasure), DIFFERENCE_PREVIOUS_YEAR);
        this.timeExpressionMap.put(MessageFormat.format(RB.getStringResource((String)RB_KEY, (String)"TimeExpression_RatioPreviousPeriod.txt", (Locale)this.locale), selectedMeasure), PERCENTCHANGE_PREVIOUS_PERIOD);
        this.timeExpressionMap.put(MessageFormat.format(RB.getStringResource((String)RB_KEY, (String)"TimeExpression_RatioParallelPeriod.txt", (Locale)this.locale), selectedMeasure), PERCENTCHANGE_PREVIOUS_YEAR);
        this.timeExpressionMap.put(MessageFormat.format(RB.getStringResource((String)RB_KEY, (String)"TimeExpression_CumulativeDefaultPeriod.txt", (Locale)this.locale), selectedMeasure), "CUMULATIVE");
        this.timeExpressionMap.put(MessageFormat.format(RB.getStringResource((String)RB_KEY, (String)"TimeExpression_CumulativeBasePeriod.txt", (Locale)this.locale), selectedPeriod, selectedMeasure), CUMULATIVE_BASE_PERIOD);
    }

    public TimeFunctions(Locale locale) {
        this.setLocale(locale);
        this.populateFunctions();
    }

    public TimeFunctions() {
        this(null);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
    }

    public String getTimeFunctionLabel(String desc) {
        if (this.timeFunctionMap.containsKey(desc)) {
            return desc;
        }
        String key = "";
        for (Map.Entry me : this.timeFunctionMap.entrySet()) {
            String value = (String)me.getValue();
            if (!value.equals(desc)) continue;
            key = (String)me.getKey();
            break;
        }
        return key;
    }

    public String getTimeFunction(String label) {
        if (this.timeFunctionMap.containsKey(label)) {
            return (String)this.timeFunctionMap.get(label);
        }
        return label;
    }

    public String[] getTimeFunctionLabels() {
        return this.timeFunctionMap.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public String[] getTimeFunctionNames() {
        return this.timeFunctionMap.values().toArray(EMPTY_STRING_ARRAY);
    }

    public String[] getTimeExpressionLabels() {
        return this.timeExpressionMap.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public String getTimeExpression(String functionName) {
        if (this.timeExpressionMap.containsKey(functionName)) {
            return functionName;
        }
        String key = "";
        for (Map.Entry me : this.timeExpressionMap.entrySet()) {
            String value = (String)me.getValue();
            if (!value.equals(functionName)) continue;
            key = (String)me.getKey();
            break;
        }
        return key;
    }

    public static void main(String[] args) {
    }
}

