/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.calculateditems;

import com.sas.expressions.visuals.Operation;
import com.sas.expressions.visuals.OperationList;
import com.sas.iquery.metadata.serverprop.Category;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionSignature;
import com.sas.iquery.metadata.serverprop.Operator;
import com.sas.iquery.metadata.serverprop.Parameter;
import com.sas.iquery.metadata.serverprop.ParameterType;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ServerPropertiesOperationList
extends OperationList {
    ServerProperties _serverProperties = null;

    public ServerPropertiesOperationList(ServerProperties serverProperties) {
        this._serverProperties = serverProperties;
        this.buildList();
    }

    private void buildList() {
        HashMap operationsByCategory = new HashMap();
        ArrayList<Category> categories = new ArrayList<Category>();
        List operatorList = this._serverProperties.getOperators();
        for (Operator operator : operatorList) {
            List signatures = operator.getSignatures();
            FunctionSignature signature = null;
            Iterator k = signatures.iterator();
            if (!k.hasNext()) continue;
            signature = (FunctionSignature)k.next();
            List argTypes = signature.getParameters();
            ServerOperation operation = new ServerOperation(operator.getID(), operator.getLabel(), operator.getSyntaxToken(), operator.getToolTip(), signature.getDefaultSyntaxTemplate(), argTypes);
            Category category = operator.getCategory();
            List<ServerOperation> operationsInCategory = null;
            if (operationsByCategory.containsKey(category)) {
                operationsInCategory = (List)operationsByCategory.get(category);
            } else {
                operationsInCategory = new ArrayList();
                operationsByCategory.put(category, operationsInCategory);
                categories.add(category);
            }
            operationsInCategory.add(operation);
        }
        Iterator iterCats = categories.iterator();
        while (iterCats.hasNext()) {
            Category category = (Category)iterCats.next();
            List operations = (List)operationsByCategory.get(category);
            for (Operation operation : operations) {
                this.add(operation);
            }
            if (!iterCats.hasNext()) continue;
            this.add(null);
        }
    }

    private void printFunction(Function function) {
        System.out.println("printFunction(), function: " + function);
        System.out.println("\t argumentCount: " + function.getArgumentCount());
        System.out.println("\t category: " + function.getCategory());
        System.out.println("\t ** categoryName: " + function.getCategory().getLabel());
        System.out.println("\t description: " + function.getDescription());
        System.out.println("\t displayName: " + function.getLabel());
        System.out.println("\t id: " + function.getID());
        System.out.println("\t id: " + function.getNameID());
        List signatures = function.getSignatures();
        FunctionSignature signature2 = null;
        for (FunctionSignature signature2 : signatures) {
            List argTypes = signature2.getParameters();
            ParameterType returnType = signature2.getReturnType();
            System.out.println("\t syntaxTemplate: " + signature2.getDefaultSyntaxTemplate());
            System.out.println("\t FS return type name: " + returnType.toString());
            System.out.println("\t FS return type desc: " + returnType.getDescription());
            for (Parameter p : argTypes) {
                ParameterType pt = p.getType();
                System.out.println("\t\t ParameterType name: " + pt.getLabel());
                System.out.println("\t\t ParameterType desc: " + pt.getDescription());
                System.out.println("\t\t Parameter isEnumerated: " + p.isEnumerated());
                System.out.println("\t\t Parameter getEnumerationList " + p.getEnumerationList());
                System.out.println("\t\t Parameter isVarying: " + p.isVarying());
                System.out.println("\t\t Parameter toString " + p.toString());
            }
        }
        System.out.println("\t syntaxToken: " + function.getSyntaxToken());
        System.out.println("\t toolTip: " + function.getToolTip());
        System.out.println();
    }

    private class ServerOperation
    extends Operation {
        public ServerOperation(String name, String displayName, String symbol, String toolTip, String fmtString, List args) {
            super(name, displayName, symbol, toolTip, fmtString, args);
        }

        protected String getArgDisplayName(Object obj) {
            String text = "";
            if (obj instanceof ParameterType) {
                ParameterType parameterType = (ParameterType)obj;
                text = parameterType.getLabel();
            } else {
                text = super.getArgDisplayName(obj);
            }
            return text;
        }
    }
}

