/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.calculateditems;

import com.sas.dataselectors.calculateditems.DataSourceTreeNode;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.physical.Hierarchy;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class DataSourceTreeCellRenderer
extends DefaultTreeCellRenderer {
    protected static Font m_defaultFont;
    protected static Font m_boldDefaultFont;
    protected static ImageIcon m_dataSourceIcon;

    public DataSourceTreeCellRenderer(JTree source) {
        if (m_dataSourceIcon == null) {
            source.setRowHeight(16);
        } else {
            source.setRowHeight(Math.max(16, m_dataSourceIcon.getIconHeight() + 2));
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (!(value instanceof DataSourceTreeNode)) {
            return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        DataSourceTreeNode node = (DataSourceTreeNode)value;
        Object origData = node.getOriginalObject();
        String stringValue = node.getDisplayName();
        if (tree.hasFocus() && tree.getSelectionCount() == 0 && row == 0) {
            hasFocus = true;
        }
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        this.setText(stringValue);
        this.setIcon(null);
        String tipText = node.getToolTip();
        if (tipText != null && tipText.length() > 0 && !tipText.equals(stringValue)) {
            this.setToolTipText(tipText);
        } else {
            this.setToolTipText(null);
        }
        boolean setBold = false;
        if (value instanceof Hierarchy || origData instanceof Hierarchy) {
            setBold = true;
        }
        Icon icon = node.getImageIcon(expanded);
        this.setIcon(icon);
        if (leaf) {
            this.setLeafIcon(this.getIcon());
        } else if (expanded) {
            this.setOpenIcon(this.getIcon());
        } else {
            this.setClosedIcon(this.getIcon());
        }
        if (m_defaultFont == null) {
            m_defaultFont = this.getFont();
        }
        if (m_defaultFont != null && m_boldDefaultFont == null) {
            m_boldDefaultFont = new Font(m_defaultFont.getName(), 1, m_defaultFont.getSize());
        }
        if (setBold) {
            this.setFont(m_boldDefaultFont);
        } else {
            this.setFont(m_defaultFont);
        }
        if (selected) {
            this.setForeground(SystemColor.textHighlightText);
        } else {
            this.setForeground(SystemColor.textText);
        }
        this.setEnabled(true);
        this.selected = selected;
        this.setComponentOrientation(tree.getComponentOrientation());
        return this;
    }

    @Override
    public void paint(Graphics g) {
        Icon currentI = this.getIcon();
        if (currentI != null && this.getText() != null) {
            int offset = currentI.getIconWidth() + this.getIconTextGap();
            g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
        } else {
            g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        super.paint(g);
    }

    private static boolean checkResourcesForPrompts(List resources) {
        if (resources == null) {
            return false;
        }
        boolean hasPrompt = false;
        for (int i = 0; i < resources.size(); ++i) {
            Object res = resources.get(i);
            if (!(res instanceof Prompt)) continue;
            hasPrompt = true;
        }
        return hasPrompt;
    }

    static {
        m_dataSourceIcon = null;
    }
}

