/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.calculateditems;

import com.sas.dataselectors.calculateditems.BaseCalculatedItemListAdapter;
import com.sas.dataselectors.calculateditems.BusinessQueryCalculatedObjectFactory;
import com.sas.dataselectors.calculateditems.CalculatedObjectFactoryInterface;
import com.sas.dataselectors.calculateditems.LevelNodeInfo;
import com.sas.dataselectors.calculateditems.NodeInfo;
import com.sas.dataselectors.format.BusinessModelFormatAdapter;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.OlapItem;
import com.sas.iquery.metadata.serverprop.ServerAttribute;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.storage.iquery.IQUeryUtil;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.swing.visuals.dataselectors.format.FormatAdapterInterface;
import java.util.List;
import java.util.Locale;

public class BusinessQueryToCalculatedItemListAdapter
extends BaseCalculatedItemListAdapter {
    private BusinessQuery businessQuery;
    private FormatAdapterInterface formatAdapter;
    int maxNameLength = Integer.MAX_VALUE;
    boolean maxNameLengthCalculated;
    private BusinessQueryProviderInterface model;

    public BusinessQueryToCalculatedItemListAdapter(BusinessQueryProviderInterface businessQueryProvider) {
        this(businessQueryProvider.getBusinessQuery(), new BusinessQueryCalculatedObjectFactory(businessQueryProvider.getBusinessQuery()));
        this.model = businessQueryProvider;
    }

    public BusinessQueryToCalculatedItemListAdapter(BusinessQueryProviderInterface businessQueryProvider, Locale locale) {
        this(businessQueryProvider.getBusinessQuery(), new BusinessQueryCalculatedObjectFactory(businessQueryProvider.getBusinessQuery(), locale));
        this.model = businessQueryProvider;
    }

    public BusinessQueryToCalculatedItemListAdapter(BusinessQuery businessQuery) {
        this(businessQuery, new BusinessQueryCalculatedObjectFactory(businessQuery));
    }

    private BusinessQueryToCalculatedItemListAdapter(BusinessQuery businessQuery, CalculatedObjectFactoryInterface factory) {
        super(factory);
        this.businessQuery = businessQuery;
    }

    @Override
    public FormatAdapterInterface getFormatAdapter() {
        if (this.formatAdapter == null) {
            this.formatAdapter = new BusinessModelFormatAdapter(this.businessQuery.getBusinessModel());
        }
        return this.formatAdapter;
    }

    @Override
    public int getMaxLengthOfItemName() {
        if (!this.maxNameLengthCalculated) {
            ServerProperties serverProperties;
            this.maxNameLengthCalculated = true;
            try {
                serverProperties = this.businessQuery.getBusinessModel().getServerProperties();
                String maxLengthStr = serverProperties.getServerAttributeValue(ServerAttribute.CAPTION_LABEL_MAX_LENGTH);
                if (maxLengthStr == null) {
                    throw new IllegalStateException("ServerAttribute.CAPTION_LABEL_MAX_LENGTH is not present");
                }
                this.maxNameLength = Integer.parseInt(maxLengthStr) - 2;
            }
            catch (MetadataException me) {
                IllegalStateException ise = new IllegalStateException(me.getLocalizedMessage());
                ise.initCause(me);
                throw ise;
            }
            catch (NumberFormatException nfe) {
                IllegalStateException ise = new IllegalStateException(nfe.getLocalizedMessage());
                ise.initCause(nfe);
                throw ise;
            }
            if (serverProperties == null) {
                throw new IllegalStateException("businessQuery.getBusinessModel().getServerProperties() returned null");
            }
            this.maxNameLengthCalculated = true;
        }
        return this.maxNameLength;
    }

    public DataItem getTimeDataItem() {
        try {
            boolean isOLAP = this.getLevelHasMembers();
            if (isOLAP) {
                List itemList = this.businessQuery.getResultItems();
                int size = itemList.size();
                for (int i = 0; i < size; ++i) {
                    DataItem di = (DataItem)itemList.get(i);
                    if (!IQUeryUtil.isTimeDimension(this.businessQuery.getBusinessModel(), di)) continue;
                    return di;
                }
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean isTimeDimensionPresent() {
        return this.getTimeDataItem() != null;
    }

    @Override
    public Object getTimeHierarchy() {
        try {
            DataItem timeDI = this.getTimeDataItem();
            String hierName = null;
            ExpressionInterface exp = timeDI.getExpression();
            if (exp instanceof Hierarchy) {
                hierName = ((OlapItem)exp).getUniqueName();
            } else if (exp instanceof ResourceAwareStringExpression) {
                hierName = BusinessQueryOLAPUtil.getHierarchyName((BusinessModel)this.businessQuery.getBusinessModel(), (DataItem)timeDI);
            }
            if (hierName != null) {
                OLAPDataSetInterface olapDataSet = (OLAPDataSetInterface)this.model;
                Filter f = new Filter();
                f.setCubeName(olapDataSet.getCubeName());
                f.setUniqueHierarchyName(hierName);
                HierarchyInterface[] hierarchies = olapDataSet.getDatabaseMetadata().getHierarchies(f);
                if (hierarchies != null && hierarchies.length > 0) {
                    LevelInterface[] levels = hierarchies[0].getLevels();
                    LevelNodeInfo n = new LevelNodeInfo(levels[1]);
                    return n;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private NodeInfo getMemberNodeInfo(MemberInterface member) {
        try {
            NodeInfo memberNodeInfo = new NodeInfo();
            String memberLabel = member.getLabel();
            if (member.getChildCount() > 0) {
                MemberInterface[] children = member.getChildren();
                for (int j = 0; j < children.length; ++j) {
                    memberNodeInfo.add(this.getMemberNodeInfo(children[j]));
                }
            }
            return memberNodeInfo;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

