/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.calculateditems;

import com.sas.dataselectors.calculateditems.BaseCalculatedItemAdapter;
import com.sas.dataselectors.calculateditems.CalculatedItemInterface;
import com.sas.dataselectors.calculateditems.CalculatedItemV2Interface;
import com.sas.dataselectors.calculateditems.CalculatedObjectFactoryInterface;
import com.sas.dataselectors.calculateditems.DataSourceTreeModel;
import com.sas.dataselectors.calculateditems.DataSourceTreeNode;
import com.sas.dataselectors.calculateditems.RB;
import com.sas.dataselectors.calculateditems.ServerPropertiesFunctionTree;
import com.sas.dataselectors.filters.DefaultFilterValue;
import com.sas.dataselectors.filters.FilterValueInterface;
import com.sas.expressions.visuals.DataSourceTreeInterface;
import com.sas.expressions.visuals.DefaultFunctionTree;
import com.sas.expressions.visuals.DefaultOperationList;
import com.sas.expressions.visuals.FunctionTreeInterface;
import com.sas.expressions.visuals.OperationListInterface;
import com.sas.iquery.dataservices.DataServicesException;
import com.sas.iquery.dataservices.IQDataServices;
import com.sas.iquery.dataservices.IQDataServicesFactory;
import com.sas.iquery.dataservices.PossibleFilterValue;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.NamedObjectInterface;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Governing;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.MapFolder;
import com.sas.iquery.metadata.business.RootDataItem;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.expr.AbstractTimeValueExpression;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.metadata.expr.ParseExpressionException;
import com.sas.iquery.metadata.expr.ResourceIdentificationException;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.olap.TimeExpressionMeasure;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.Member;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.serverprop.ConnectionType;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.util.ChainedException;
import com.sas.util.UncheckedException;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class BaseCalculatedObjectFactory
implements CalculatedObjectFactoryInterface {
    public static final String RB_KEY = "BaseCalculatedObjectFactory.";
    BusinessModel _businessModel = null;
    ServerProperties _serverProperties = null;
    OperationListInterface _operationList = null;
    FunctionTreeInterface _functionTree = null;
    DataSourceTreeInterface _physicalDataSourceTree = null;
    DataSourceTreeInterface _dataItemDataSourceTree = null;
    private Locale locale;
    static StringExpressionUtil _stringExpressionUtil = null;
    private CommonLoggerInterface log = null;
    protected HashMap parseExpressionMap;
    ResourceScope _scope = ResourceScope.BUSINESS_SCOPE;
    public static String ERROR_NOMETADATASERVICE = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"ErrorMessage.NoMetadataService.txt");
    public static String ERROR_NODATASERVICES = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"ErrorMessage.NoDataServices.txt");
    public static String ERROR_REMOVINGDATAITEM = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"ErrorMessage.RemovingDataItem.txt");
    public static String ERROR_CREATINGDATAITEM = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"ErrorMessage.CreatingDataItem.txt");
    public static String ERROR_ADDINGDATAITEM = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"ErrorMessage.AddingDataItem.txt");
    public static String ERROR_UPDATINGDATAITEM = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"ErrorMessage.UpdatingDataItem.txt");
    public static String ERROR_UPDATINGEXPR = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"ErrorMessage.UpdatingExpr.txt");
    public static String ERROR_FINDINGICONIMAGE = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"ErrorMessage.FindingIconImage.txt");
    public static String ERROR_PARSINGEXPRTEXT = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"ErrorMessage.ParsngExprText.txt");
    public static String ERROR_FORMATTINGEXPRTEXT = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"ErrorMessage.FormattingExprText.txt");
    private Map _cachedDataItemLevelsNamed = null;
    private Map _cachedDataItemLevelsNamedMembers = new HashMap();
    int _simpleDuplicateStartIndex = INDEX_SIMPLE_DUPLICATE_START;
    String _simpleDuplicateNameFormat = FORMAT_SIMPLE_DUPLICATE_NAME;
    String _simpleDisplayNameFormat = FORMAT_SIMPLE_DISPLAYNAME;
    private boolean _inittedDST = false;
    private ResourceScope _scopeOfDST = null;
    private DataSourceTreeInterface _dataSourceTree = null;
    public Map _cachedChildrenLists = new HashMap();
    protected DataSelection _timeDateSyntaxDataSelection = null;
    protected Map _timeDateLookupCache = new HashMap();
    public static String ERROR_TYPENOTSET = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"ErrorMessage.TypeNotSet.txt");
    public static String ERROR_TYPEINVALID = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"ErrorMessage.TypeInvalid.txt");
    public static String ERROR_INVALIDITEM = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"ErrorMessage.InvalidItem.txt");
    public static String ERROR_INVALIDEXPR = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"ErrorMessage.InvalidExpr.txt");
    public static String ERROR_INVALIDITEM_LABEL = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"ErrorMessage.InvalidItem.Label.txt");
    public static int MAXIMUM_OLAPLABELLENGTH = 30;
    public static String ERROR_INVALIDITEM_OLAPLABELLENGTH = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"ErrorMessage.InvalidItem.OlapLabelLength.fmt.txt");
    public String lastInvalidCalculatedItemMessage = null;
    public static String IMAGENAME_OBJECT_DATASOURCE = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_OBJECT_DATASOURCE.image");
    public static String IMAGENAME_OBJECT_COLLECTION = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_OBJECT_COLLECTION.image");
    public static String IMAGENAME_FOLDER_CLOSED = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_FOLDER_CLOSED.image");
    public static String IMAGENAME_FOLDER_OPENED = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_FOLDER_OPENED.image");
    public static String IMAGENAME_OBJECT_DATASET = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_OBJECT_DATASET.image");
    public static String IMAGENAME_OBJECT_TYPE_COLUMN = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_OBJECT_TYPE_COLUMN.image");
    public static String IMAGENAME_OBJECT_TYPE_PROMPT = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_OBJECT_TYPE_PROMPT.image");
    public static String IMAGENAME_OBJECT_CUBE = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_OBJECT_CUBE.image");
    public static String IMAGENAME_OBJECT_CUBE_LEVEL = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_OBJECT_CUBE_LEVEL.image");
    public static String IMAGENAME_OBJECT_CUBE_DIMENSION = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_OBJECT_CUBE_DIMENSION.image");
    public static String IMAGENAME_OBJECT_CUBE_HIERARCHY = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_OBJECT_CUBE_HIERARCHY.image");
    public static String IMAGENAME_OBJECT_CUBE_MEASURE = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_OBJECT_CUBE_MEASURE.image");
    public static String IMAGENAME_OBJECT_FILTER = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_OBJECT_FILTER.image");
    public static String IMAGENAME_OBJECT_PROMPTED_FILTER = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_OBJECT_PROMPTED_FILTER.image");
    public static String IMAGENAME_OBJECT_MEASURE = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_OBJECT_MEASURE.image");
    public static String IMAGENAME_OBJECT_DETAIL = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_OBJECT_DETAIL.image");
    public static String IMAGENAME_OBJECT_CATEGORY = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_OBJECT_CATEGORY.image");
    public static String IMAGENAME_OBJECT_PROMPTED_MEASURE = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_OBJECT_PROMPTED_MEASURE.image");
    public static String IMAGENAME_OBJECT_PROMPTED_DETAIL = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_OBJECT_PROMPTED_MEASURE.image");
    public static String IMAGENAME_OBJECT_PROMPTED_CATEGORY = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_OBJECT_PROMPTED_CATEGORY.image");
    public static String IMAGENAME_COLUMN_TYPE_CHARACTER = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_COLUMN_TYPE_CHARACTER.image");
    public static String IMAGENAME_COLUMN_TYPE_NUMERIC = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_COLUMN_TYPE_NUMERIC.image");
    public static String IMAGENAME_COLUMN_TYPE_DATE = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_COLUMN_TYPE_DATE.image");
    public static String IMAGENAME_COLUMN_TYPE_TIME = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_COLUMN_TYPE_TIME.image");
    public static String IMAGENAME_COLUMN_TYPE_TIMESTAMP = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_COLUMN_TYPE_TIMESTAMP.image");
    public static String IMAGENAME_MEMBER_TYPE_CHARACTER = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_MEMBER_TYPE_CHARACTER.image");
    public static String IMAGENAME_MEMBER_TYPE_NUMERIC = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_MEMBER_TYPE_NUMERIC.image");
    public static String IMAGENAME_MEMBER_TYPE_DATE = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_MEMBER_TYPE_DATE.image");
    public static String IMAGENAME_MEMBER_TYPE_TIME = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_MEMBER_TYPE_TIME.image");
    public static String IMAGENAME_MEMBER_TYPE_TIMESTAMP = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"IMAGENAME_MEMBER_TYPE_TIMESTAMP.image");
    private Map cachedImageNamesExpanded = null;
    private Map cachedImageNamesCollapsed = null;
    private CalculatedObjectFactoryInterface.ImageIconFactoryInterface _imageIconFactory = null;
    private Map cachedImageIcons = null;
    private static final int INDEX_SIMPLE_DUPLICATE_START = Integer.parseInt(RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"INDEX_SIMPLE_DUPLICATE_START.notrans"));
    private static final String FORMAT_SIMPLE_DUPLICATE_NAME = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"FORMAT_SIMPLE_DUPLICATE_NAME.fmt.txt");
    private static final String FORMAT_SIMPLE_DISPLAYNAME = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"FORMAT_SIMPLE_DISPLAYNAME.fmt.txt");
    public static String LABEL_CALCITEM_TYPE_NOT_SET = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"LABEL_CALCITEM_TYPE_NOT_SET.txt");
    public static String LABEL_CALCITEM_TYPE_BITSTRING = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"LABEL_CALCITEM_TYPE_BITSTRING.txt");
    public static String LABEL_CALCITEM_TYPE_NUMERIC = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"LABEL_CALCITEM_TYPE_NUMERIC.txt");
    public static String LABEL_CALCITEM_TYPE_CHARACTER = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"LABEL_CALCITEM_TYPE_CHARACTER.txt");
    public static String LABEL_CALCITEM_TYPE_DATE = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"LABEL_CALCITEM_TYPE_DATE.txt");
    public static String LABEL_CALCITEM_TYPE_TIME = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"LABEL_CALCITEM_TYPE_TIME.txt");
    public static String LABEL_CALCITEM_TYPE_TIMESTAMP = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"LABEL_CALCITEM_TYPE_TIMESTAMP.txt");
    public static String LABEL_CALCITEM_TYPE_INTERVAL_YM = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"LABEL_CALCITEM_TYPE_INTERVAL_YM.txt");
    public static String LABEL_CALCITEM_TYPE_INTERVAL_DT = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"LABEL_CALCITEM_TYPE_INTERVAL_DT.txt");
    public static String LABEL_CALCITEM_TYPE_BOOLEAN = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"LABEL_CALCITEM_TYPE_BOOLEAN.txt");
    public static String LABEL_CALCITEM_TYPE_OLAP_MEASURE = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"LABEL_CALCITEM_TYPE_OLAP_MEASURE.txt");
    public static String LABEL_CALCITEM_TYPE_OLAP_CATEGORY = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"LABEL_CALCITEM_TYPE_OLAP_CATEGORY.txt");
    private static final String PHYSICAL_TREE_LABEL = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"PHYSICAL_TREE_LABEL.txt");
    private static final String PHYSICAL_TREE_DESC = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"PHYSICAL_TREE_DESC.txt");
    private static final String BUSINESS_TREE_LABEL = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"BUSINESS_TREE_LABEL.txt");
    private static final String BUSINESS_TREE_DESC = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"BUSINESS_TREE_DESC.txt");
    private static final String PROPERTY_FILE_TAG_FOR_MDX = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"PROPERTY_FILE_TAG_FOR_MDX.notrans");
    private static final String PROPERTY_FILE_TAG_FOR_SQL = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"PROPERTY_FILE_TAG_FOR_SQL.notrans");
    private static final String DISPLAYNAME_TAG_HIERARCHY = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"DISPLAYNAME_TAG_HIERARCHY.fmt.txt");
    private static final String DISPLAYNAME_TAG_NORMALDIMENSIONS = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"DISPLAYNAME_TAG_NORMALDIMENSIONS.fmt.txt");
    private static final String DISPLAYNAME_TAG_MEASURESDIMENSION = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"DISPLAYNAME_TAG_MEASURESDIMENSION.fmt.txt");
    private static final String TIPTEXT_TAG_DEFAULT = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"TIPTEXT_TAG_DEFAULT.fmt.txt");
    private static final String TIPTEXT_TAG_CONDITIONAL = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"TIPTEXT_TAG_CONDITIONAL.fmt.txt");
    private static final String TIPTEXT_TAG_DATAITEM = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"TIPTEXT_TAG_DATAITEM.fmt.txt");
    private static final String TIPTEXT_TAG_EXPRESSION = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"TIPTEXT_TAG_EXPRESSION.fmt.txt");
    private static final String TIPTEXT_TAG_PHYSICAL_DIMENSION_NORMAL = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"TIPTEXT_TAG_PHYSICAL_DIMENSION_NORMAL.fmt.txt");
    private static final String TIPTEXT_TAG_PHYSICAL_DIMENSION_MEASURES = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"TIPTEXT_TAG_PHYSICAL_DIMENSION_MEASURES.fmt.txt");
    private static final String TIPTEXT_TAG_PHYSICAL_HIERARCHY_DEFAULT = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"TIPTEXT_TAG_PHYSICAL_HIERARCHY_DEFAULT.fmt.txt");
    private static final String TIPTEXT_TAG_PHYSICAL_HIERARCHY_OTHER = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"TIPTEXT_TAG_PHYSICAL_HIERARCHY_OTHER.fmt.txt");
    private static final String TIPTEXT_TAG_PHYSICAL_MEASURE = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"TIPTEXT_TAG_PHYSICAL_MEASURE.fmt.txt");
    private static final String TIPTEXT_TAG_PHYSICAL_LEVEL = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"TIPTEXT_TAG_PHYSICAL_LEVEL.fmt.txt");
    private static final String TIPTEXT_TAG_PHYSICAL_MEMBER = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"TIPTEXT_TAG_PHYSICAL_MEMBER.fmt.txt");
    private static final String TIPTEXT_TAG_PHYSICAL_COLUMN = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"TIPTEXT_TAG_PHYSICAL_COLUMN.fmt.txt");
    private static final String TIPTEXT_TAG_PHYSICAL_DATASOURCE_TABLE = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"TIPTEXT_TAG_PHYSICAL_DATASOURCE_TABLE.fmt.txt");
    private static final String TIPTEXT_TAG_PHYSICAL_DATASOURCE_CUBE = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"TIPTEXT_TAG_PHYSICAL_DATASOURCE_CUBE.fmt.txt");
    private static final String TIPTEXT_TAG_PHYSICAL_DATASOURCE_OTHER = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"TIPTEXT_TAG_PHYSICAL_DATASOURCE_OTHER.fmt.txt");
    public Exception lastInvalidExpressionException = null;
    private static final String defaultMaxPhysicalValuesToLoadString = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"MaximumPhysicalValuesToLoad.num.notrans");
    public static final int DEFAULT_GOVERNING_LIMIT = Integer.parseInt(defaultMaxPhysicalValuesToLoadString);
    protected int _maxPhysicalValuestoLoad = DEFAULT_GOVERNING_LIMIT;
    protected boolean _isTypeChangeWarningIgnored = true;

    public BaseCalculatedObjectFactory(BusinessModel businessModel, ResourceScope scope) {
        this(businessModel, scope, null);
    }

    public BaseCalculatedObjectFactory(BusinessModel businessModel, ResourceScope scope, Locale locale) {
        _stringExpressionUtil = StringExpressionUtil.getInstance();
        this._scope = scope;
        this._businessModel = businessModel;
        this.locale = locale;
        this._init();
    }

    protected void _init() {
        this.parseExpressionMap = new HashMap();
        try {
            this._serverProperties = this._businessModel.getServerProperties();
        }
        catch (MetadataException e) {
            throw new UncheckedException((Throwable)e, null);
        }
        ServicesLogFactory f = new ServicesLogFactory(this._businessModel.getSession());
        this.log = LoggerRepository2.getLogger((String)BaseCalculatedObjectFactory.class.getName(), (LoggerFactoryInterface)f);
    }

    public static IntelligentQueryMetadataServiceInterface getIQueryMetadataService(BusinessModel businessModel) {
        IntelligentQueryMetadataServiceInterface iqueryMetadataService = null;
        if (businessModel != null) {
            iqueryMetadataService = businessModel.getMetadataService();
        }
        if (iqueryMetadataService == null) {
            try {
                iqueryMetadataService = IntelligentQueryMetadataServiceFactory.newService();
            }
            catch (MetadataException me) {
                LoggerRepository2.getLogger((String)BaseCalculatedObjectFactory.class.getName(), null).error(ERROR_NOMETADATASERVICE, (Throwable)me);
            }
        }
        return iqueryMetadataService;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    @Override
    public boolean getLevelHasMembers() {
        return this._businessModel.getStructure().isOLAP();
    }

    @Override
    public String[] getMeasureNames() {
        Map measureNameMap = this.getMeasureNameMap();
        ArrayList<String> names = new ArrayList<String>();
        Set setOfKeys = measureNameMap.keySet();
        for (String displayName : setOfKeys) {
            names.add(displayName);
        }
        int numMeasures = names.size();
        String[] measureNames = names.toArray(new String[numMeasures]);
        Arrays.sort(measureNames, new Comparator(){

            public int compare(Object o1, Object o2) {
                int result = 0;
                if (o1 == null) {
                    result = o2 == null ? 0 : -1;
                } else if (o2 == null) {
                    result = 1;
                } else {
                    String o1string = o1.toString();
                    String o2string = o2.toString();
                    result = o1string.compareTo(o2string);
                }
                return result;
            }

            @Override
            public boolean equals(Object obj) {
                boolean result = this == obj;
                return result;
            }
        });
        return measureNames;
    }

    @Override
    public Map getMeasureNameMap() {
        List itemList = this.getDataItems(true);
        List calcItemList = this.getBusinessModelCalculatedItemObjects(false);
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        HashMap<String, Integer> dupCountMap = new HashMap<String, Integer>();
        ArrayList<DataItem> delayRenameList = new ArrayList<DataItem>();
        Integer startDup = new Integer(this.getSimpleDuplicateStartIndex() - 1);
        String formatDup = this.getSimpleDuplicateNameFormat();
        for (DataItem dataItem : itemList) {
            boolean isMeasure;
            boolean isLocal = calcItemList.contains(dataItem);
            if (isLocal || !(isMeasure = this._isDataItemMeasure(dataItem))) continue;
            String displayName = dataItem.getLabel();
            if (dupCountMap.containsKey(displayName)) {
                delayRenameList.add(dataItem);
                continue;
            }
            dupCountMap.put(displayName, startDup);
            String insertValue = null;
            insertValue = this.getExpressionUtilText((ExpressionInterface)dataItem);
            if (insertValue == null) {
                insertValue = displayName;
            }
            lookupMap.put(displayName, insertValue);
        }
        for (DataItem dataItem : delayRenameList) {
            String origDisplayName = dataItem.getLabel();
            Integer count = (Integer)dupCountMap.get(origDisplayName);
            int dupCount = count;
            String displayName = origDisplayName;
            while (dupCountMap.containsKey(displayName)) {
                displayName = MessageFormat.format(formatDup, origDisplayName, Integer.toString(++dupCount));
            }
            dupCountMap.put(origDisplayName, new Integer(dupCount));
            dupCountMap.put(displayName, new Integer(dupCount));
            String insertValue = null;
            insertValue = this.getExpressionUtilText((ExpressionInterface)dataItem);
            if (insertValue == null) {
                insertValue = displayName;
            }
            lookupMap.put(displayName, insertValue);
        }
        return lookupMap;
    }

    @Override
    public String[] getLevelNames(boolean includeHierarchyName) {
        Map levelNameMap = this.getLevelNameMap(includeHierarchyName);
        ArrayList<String> names = new ArrayList<String>();
        Set setOfKeys = levelNameMap.keySet();
        for (String displayName : setOfKeys) {
            names.add(displayName);
        }
        int numLevels = names.size();
        String[] levelNames = names.toArray(new String[numLevels]);
        Arrays.sort(levelNames, new Comparator(){

            public int compare(Object o1, Object o2) {
                int result = 0;
                if (o1 == null) {
                    result = o2 == null ? 0 : -1;
                } else if (o2 == null) {
                    result = 1;
                } else {
                    String o1string = o1.toString();
                    String o2string = o2.toString();
                    result = o1string.compareTo(o2string);
                }
                return result;
            }

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }
        });
        return levelNames;
    }

    @Override
    public Map getLevelNameMap(boolean includeHierarchyName) {
        if (this._cachedDataItemLevelsNamed == null) {
            this._cachedDataItemLevelsNamed = new HashMap();
        }
        this._cachedDataItemLevelsNamed.clear();
        this._cachedDataItemLevelsNamedMembers.clear();
        List itemList = this.getDataItems(true);
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        HashMap<String, Integer> dupCountMap = new HashMap<String, Integer>();
        ArrayList<DataItem> delayRenameList = new ArrayList<DataItem>();
        Integer startDup = new Integer(this.getSimpleDuplicateStartIndex() - 1);
        String formatDup = this.getSimpleDuplicateNameFormat();
        for (DataItem dataItem : itemList) {
            if (!this._isDataItemLevel(dataItem)) continue;
            String displayName = this._simpleLevelNameFormat(dataItem, includeHierarchyName);
            if (dupCountMap.containsKey(displayName)) {
                delayRenameList.add(dataItem);
                continue;
            }
            dupCountMap.put(displayName, startDup);
            String insertValue = null;
            insertValue = this.getExpressionUtilText((ExpressionInterface)dataItem);
            if (insertValue == null) {
                insertValue = displayName;
            }
            lookupMap.put(displayName, insertValue);
            this._cachedDataItemLevelsNamed.put(displayName, dataItem);
        }
        for (DataItem dataItem : delayRenameList) {
            String origDisplayName = this._simpleLevelNameFormat(dataItem, includeHierarchyName);
            Integer count = (Integer)dupCountMap.get(origDisplayName);
            int dupCount = count;
            String displayName = origDisplayName;
            while (dupCountMap.containsKey(displayName)) {
                displayName = MessageFormat.format(formatDup, origDisplayName, Integer.toString(++dupCount));
            }
            dupCountMap.put(origDisplayName, new Integer(dupCount));
            dupCountMap.put(displayName, new Integer(dupCount));
            String insertValue = null;
            insertValue = this.getExpressionUtilText((ExpressionInterface)dataItem);
            if (insertValue == null) {
                insertValue = displayName;
            }
            lookupMap.put(displayName, insertValue);
            this._cachedDataItemLevelsNamed.put(displayName, dataItem);
        }
        return lookupMap;
    }

    @Override
    public String[] getMemberNames(String levelName) {
        if (this._cachedDataItemLevelsNamed == null) {
            throw new UnsupportedOperationException("Level name cache not initialized by getLevelNameMap(...)");
        }
        List<String> names = new ArrayList();
        if (this._cachedDataItemLevelsNamedMembers.containsKey(levelName)) {
            names = (List)this._cachedDataItemLevelsNamedMembers.get(levelName);
        } else if (this._cachedDataItemLevelsNamed.containsKey(levelName)) {
            DataItem item = (DataItem)this._cachedDataItemLevelsNamed.get(levelName);
            ExpressionInterface expression = item.getExpression();
            if (expression instanceof Level) {
                Level level = (Level)expression;
                List members = null;
                try {
                    members = level.getMembers();
                }
                catch (MetadataException metadataException) {
                    // empty catch block
                }
                if (members != null) {
                    ListIterator iterator = members.listIterator();
                    while (iterator.hasNext()) {
                        Member member = (Member)iterator.next();
                        String displayName = null;
                        displayName = this.getExpressionUtilText((ExpressionInterface)member);
                        if (displayName == null) continue;
                        names.add(displayName);
                    }
                }
            }
            this._cachedDataItemLevelsNamed.put(levelName, names);
        }
        int numMembers = names.size();
        String[] memberNames = names.toArray(new String[numMembers]);
        Arrays.sort(memberNames, new Comparator(){

            public int compare(Object o1, Object o2) {
                int result = 0;
                if (o1 == null) {
                    result = o2 == null ? 0 : -1;
                } else if (o2 == null) {
                    result = 1;
                } else {
                    String o1string = o1.toString();
                    String o2string = o2.toString();
                    result = o1string.compareTo(o2string);
                }
                return result;
            }

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }
        });
        return memberNames;
    }

    public int getSimpleDuplicateStartIndex() {
        return this._simpleDuplicateStartIndex;
    }

    public void setSimpleDuplicateStartIndex(int index) {
        this._simpleDuplicateStartIndex = index;
    }

    public String getSimpleDuplicateNameFormat() {
        return this._simpleDuplicateNameFormat;
    }

    public void setSimpleDuplicateNameFormat(String format) {
        this._simpleDuplicateNameFormat = format;
    }

    public String getSimpleDisplayNameFormat() {
        return this._simpleDisplayNameFormat;
    }

    public void setSimpleDisplayNameFormat(String format) {
        this._simpleDisplayNameFormat = format;
    }

    private boolean _isDataItemMeasure(DataItem dataItem) {
        if (dataItem == null) {
            return false;
        }
        boolean hasMembers = this.getLevelHasMembers();
        int type = dataItem.getExpressionType();
        boolean typeNumeric = type == 2;
        DataItemActionType usage = dataItem.getUsage();
        if (usage != DataItemActionType.USAGE_CATEGORY) {
            if (!hasMembers) {
                if (typeNumeric) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean _isDataItemLevel(DataItem dataItem) {
        if (dataItem == null) {
            return false;
        }
        boolean hasMembers = this.getLevelHasMembers();
        if (!hasMembers) {
            if (dataItem.getExpressionType() == 3) {
                return true;
            }
        } else {
            ExpressionInterface expression = dataItem.getExpression();
            if (expression instanceof Level) {
                return true;
            }
            if (dataItem.getStructure().equals(StructureOfDataItem.STRUCTURE_LEVEL)) {
                return true;
            }
        }
        return false;
    }

    private String _simpleLevelNameFormat(DataItem dataItem, boolean includeHierarchyName) {
        String displayName = dataItem.getLabel();
        String displayNameFormat = this.getSimpleDisplayNameFormat();
        if (dataItem.getExpression() instanceof Level) {
            Level level = (Level)dataItem.getExpression();
            if (includeHierarchyName) {
                try {
                    String uniqueName = level.getUniqueName();
                    int dot = uniqueName.lastIndexOf(46);
                    if (dot > 0) {
                        uniqueName = uniqueName.substring(dot - 1);
                        displayName = MessageFormat.format(displayNameFormat, displayName, uniqueName);
                    }
                }
                catch (MetadataException metadataException) {
                    // empty catch block
                }
            }
        }
        return displayName;
    }

    @Override
    public DataSourceTreeInterface getPhysicalDataSourceTree() {
        if (this._physicalDataSourceTree == null) {
            boolean usePhysical = true;
            this._physicalDataSourceTree = new DataSourceTreeModel(PHYSICAL_TREE_LABEL, PHYSICAL_TREE_DESC, this, usePhysical);
        }
        return this._physicalDataSourceTree;
    }

    @Override
    public DataSourceTreeInterface getBusinessDataSourceTree() {
        if (this._dataItemDataSourceTree == null) {
            boolean usePhysical = false;
            this._dataItemDataSourceTree = new DataSourceTreeModel(BUSINESS_TREE_LABEL, BUSINESS_TREE_DESC, this, usePhysical);
        }
        return this._dataItemDataSourceTree;
    }

    @Override
    public DataSourceTreeInterface getPromptDataSourceTree() {
        return null;
    }

    @Override
    public DataSourceTreeInterface getDataSourceTree() {
        ResourceScope resourceScope = this.getResourceScope();
        if (this._inittedDST && this._scopeOfDST != resourceScope) {
            this._inittedDST = false;
        }
        if (!this._inittedDST) {
            this._inittedDST = true;
            this._scopeOfDST = resourceScope;
            if (resourceScope == ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE) {
                DataSourceTreeInterface physicalDST = this.getPhysicalDataSourceTree();
                DataSourceTreeInterface businessDST = this.getBusinessDataSourceTree();
                DataSourceTreeInterface[] subTrees = new DataSourceTreeInterface[]{businessDST, physicalDST};
                this._dataSourceTree = new DataSourceTreeModel(subTrees);
            } else {
                this._dataSourceTree = resourceScope == ResourceScope.PHYSICAL_SCOPE ? this.getPhysicalDataSourceTree() : this.getBusinessDataSourceTree();
            }
        }
        return this._dataSourceTree;
    }

    @Override
    public FunctionTreeInterface getFunctionListTree() {
        if (this._functionTree == null) {
            this._functionTree = this._serverProperties != null ? new ServerPropertiesFunctionTree(this._serverProperties) : (this._businessModel.getStructure().isOLAP() ? new DefaultFunctionTree(PROPERTY_FILE_TAG_FOR_MDX) : new DefaultFunctionTree(PROPERTY_FILE_TAG_FOR_SQL));
        }
        return this._functionTree;
    }

    @Override
    public OperationListInterface getOperationList() {
        if (this._operationList == null) {
            this._operationList = this._businessModel.getStructure().isOLAP() ? new DefaultOperationList(PROPERTY_FILE_TAG_FOR_MDX) : new DefaultOperationList(PROPERTY_FILE_TAG_FOR_SQL);
        }
        return this._operationList;
    }

    @Override
    public List getDataItems(boolean includeBaseModels) {
        List dataItems = this._businessModel.getObjects(includeBaseModels ? 1 : 0, DataItem.class);
        Iterator iter = dataItems.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ++i;
            DataItem dataItem = (DataItem)iter.next();
            if (!(dataItem instanceof DataItemReference) && dataItem.isUsableInQuery() && !(dataItem.getExpression() instanceof FractionOfTotalExpression)) continue;
            iter.remove();
        }
        return dataItems;
    }

    @Override
    public List getBusinessModelCalculatedItemObjects(boolean includeBaseModels) {
        ArrayList<DataItem> items = new ArrayList<DataItem>();
        List bmObjects = this.getDataItems(includeBaseModels);
        for (int i = 0; i < bmObjects.size(); ++i) {
            DataItem dataItem = (DataItem)bmObjects.get(i);
            ExpressionInterface expression = dataItem.getExpression();
            if (!dataItem.isCalculatedItem() && !(expression instanceof TimeExpressionMeasure) || expression == null || !(expression instanceof StringExpression) && !(expression instanceof ConstantExpression) && !(expression instanceof TimeExpressionMeasure)) continue;
            items.add(dataItem);
        }
        return items;
    }

    @Override
    public void removeBusinessModelCalculatedItemObject(Object bmObject) {
        if (bmObject instanceof DataItem) {
            try {
                this._businessModel.removeBusinessItem((BusinessItem)((DataItem)bmObject));
            }
            catch (MetadataException e) {
                this.log.error(ERROR_REMOVINGDATAITEM, (Throwable)e);
            }
        }
    }

    @Override
    public Object newBusinessModelCalculatedItemObject() {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    @Override
    public Object newBusinessModelCalculatedItemObject(CalculatedItemInterface item) {
        if (item == null) {
            return null;
        }
        RootDataItem dataItem = null;
        try {
            dataItem = this._businessModel.newDataItem();
        }
        catch (MetadataException e) {
            this.log.error(ERROR_CREATINGDATAITEM, (Throwable)e);
            return null;
        }
        boolean ok = this.updateBusinessModelObjectFromCalculatedItem(dataItem, item);
        if (!ok) {
            return null;
        }
        try {
            this._businessModel.addBusinessItem((BusinessItem)dataItem);
        }
        catch (MetadataException e) {
            this.log.error(ERROR_ADDINGDATAITEM, (Throwable)e);
            return null;
        }
        return dataItem;
    }

    @Override
    public CalculatedItemInterface newCalculatedItem(CalculatedItemInterface toBeCloned) {
        CalculatedItemInterface item = this.newCalculatedItemFromBusinessObject(null);
        item.setId(null);
        item.setLabel(toBeCloned.getLabel());
        item.setDescription(toBeCloned.getDescription());
        item.setExpression(toBeCloned.getExpression());
        item.setExpressionType(toBeCloned.getExpressionType());
        item.setFormat(toBeCloned.getFormat());
        if (toBeCloned instanceof CalculatedItemV2Interface) {
            ((CalculatedItemV2Interface)item).setLocale(this.locale);
            ((CalculatedItemV2Interface)item).setMeasureExpression((Object)((CalculatedItemV2Interface)toBeCloned).getExpression());
            ((CalculatedItemV2Interface)item).setTimeFunction(((CalculatedItemV2Interface)toBeCloned).getTimeFunction());
            ((CalculatedItemV2Interface)item).setBasePeriod(((CalculatedItemV2Interface)toBeCloned).getBasePeriod());
        }
        return item;
    }

    @Override
    public boolean updateCalculatedItemFromExprValues(CalculatedItemInterface item, String id, String label, String desc, int exprType, String text) {
        boolean isOLAP = this.getLevelHasMembers();
        int calcType = item.convertToCalcItemType(exprType, isOLAP);
        return this.updateCalculatedItemFromCalcValues(item, id, label, desc, calcType, text);
    }

    @Override
    public boolean updateCalculatedItemFromCalcValues(CalculatedItemInterface item, String id, String label, String desc, int calcType, String text) {
        item.setId(id);
        item.setLabel(label);
        item.setDescription(desc);
        item.setExpression(text);
        item.setExpressionType(calcType);
        return true;
    }

    @Override
    public boolean updateCalculatedItemFromBusinessModelObject(CalculatedItemInterface item, Object bmObject) {
        boolean isOLAP = this.getLevelHasMembers();
        ExpressionInterface exprFound = null;
        int expressionType = 0;
        if (bmObject instanceof DataItem) {
            DataItem dataItem = (DataItem)bmObject;
            String dataItemId = dataItem.getIntraModelID();
            item.setId(dataItemId);
            item.setLabel(dataItem.getLabel());
            item.setDescription(dataItem.getDescription());
            item.setFormat(dataItem.getFormat());
            exprFound = dataItem.getExpression();
            expressionType = this.getDataItemExpressionType(dataItem, isOLAP);
        } else if (bmObject instanceof ExpressionInterface) {
            exprFound = (ExpressionInterface)bmObject;
            expressionType = exprFound.getExpressionType();
        }
        if (exprFound != null) {
            ExpressionInterface expression = exprFound;
            String textExpression = null;
            if (expression != null) {
                if (expression instanceof ConstantExpression) {
                    ConstantExpression constantExpr = (ConstantExpression)expression;
                    textExpression = constantExpr.getValue();
                } else if (expression instanceof TimeExpressionMeasure) {
                    ((CalculatedItemV2Interface)item).setLocale(this.locale);
                    ((CalculatedItemV2Interface)item).setTimeFunction(((TimeExpressionMeasure)expression).getFunction());
                    ((CalculatedItemV2Interface)item).setMeasureExpression((Object)((TimeExpressionMeasure)expression).getMeasure());
                    ((CalculatedItemV2Interface)item).setBasePeriod(((TimeExpressionMeasure)expression).getPeriod());
                    textExpression = ((BaseCalculatedItemAdapter)item).getExpressionAreaString();
                } else {
                    textExpression = this.getExpressionUtilText(expression);
                }
            }
            if (textExpression == null) {
                textExpression = "";
            }
            int newType = item.convertToCalcItemType(expressionType, isOLAP);
            item.setExpression(textExpression);
            item.setExpressionType(newType);
        }
        return true;
    }

    int getDataItemExpressionType(DataItem dataItem, boolean isOLAP) {
        StructureOfDataItem struc;
        int expressionType = dataItem.getExpressionType();
        if (isOLAP && expressionType == 2 && !(struc = dataItem.getStructure()).equals(StructureOfDataItem.STRUCTURE_MEASURE)) {
            expressionType = 3;
        }
        return expressionType;
    }

    public static boolean setFormat(DataItem dataItem, String format) {
        String oldFormat = dataItem.getFormat();
        if (oldFormat == null && format == null) {
            return true;
        }
        if (oldFormat != null && format != null && oldFormat.trim().compareTo(format.trim()) == 0) {
            return true;
        }
        if (!dataItem.isActionSupported(DataItemActionType.OTHER_FORMAT)) {
            return false;
        }
        try {
            dataItem.setFormat(format);
        }
        catch (MetadataException e) {
            LoggerRepository2.getLogger((String)BaseCalculatedObjectFactory.class.getName(), null).error(ERROR_UPDATINGDATAITEM, (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean updateBusinessModelObjectFromCalculatedItem(Object bmObject, CalculatedItemInterface item) {
        boolean isOLAP = this.getLevelHasMembers();
        if (bmObject instanceof DataItem) {
            DataItem dataItem = (DataItem)bmObject;
            int calculatedItemType = item.getExpressionType();
            int newType = item.convertToExpressionType(calculatedItemType, isOLAP);
            String textExpression = item.getExpression();
            DataItemActionType sortDirection = dataItem.getSortDirection();
            try {
                String newId = item.getId();
                String newLabel = item.getLabel();
                if (newId == null) {
                    newId = this._businessModel.generateIntraModelID(newLabel);
                    dataItem.setIntraModelID(newId);
                    item.setId(newId);
                }
                dataItem.setLabel(newLabel);
                dataItem.setDescription(item.getDescription());
            }
            catch (MetadataException e) {
                this.log.error(ERROR_UPDATINGDATAITEM, (Throwable)e);
                return false;
            }
            boolean isTimeCalc = false;
            if (item instanceof CalculatedItemV2Interface) {
                isTimeCalc = ((CalculatedItemV2Interface)item).isTimeBasedItem();
            }
            ExpressionInterface expression = null;
            if (textExpression != null && textExpression.length() > 0 && !isTimeCalc) {
                expression = this.newExpressionUtilExpression(textExpression, newType);
            } else if (isTimeCalc) {
                expression = new TimeExpressionMeasure((DataItem)((CalculatedItemV2Interface)item).getMeasureExpression(), ((CalculatedItemV2Interface)item).getTimeFunction());
                String bp = ((CalculatedItemV2Interface)item).getBasePeriod();
                if (bp != null && bp.length() > 0) {
                    ((TimeExpressionMeasure)expression).setPeriod(bp);
                }
            }
            if (expression == null) {
                return false;
            }
            try {
                dataItem.setExpression(expression);
                String format = item.getFormat();
                if (format == null && (format = this.getFormatFromResources(dataItem)) != null) {
                    item.setFormat(format);
                }
                BaseCalculatedObjectFactory.setFormat(dataItem, format);
                if (sortDirection != DataItemActionType.SORT_NONE) {
                    dataItem.setSortDirection(sortDirection);
                }
            }
            catch (MetadataException e) {
                this.log.error(ERROR_UPDATINGEXPR, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public String getFormatFromResources(Object bmObject) {
        String format;
        block1: {
            DataItem childDataItem;
            format = null;
            if (!(bmObject instanceof BusinessModelResourceReferencer)) break block1;
            BusinessModelResourceReferencer bmrReferencer = (BusinessModelResourceReferencer)bmObject;
            List resources = bmrReferencer.getResources(DataItem.class, 2);
            Iterator iter = resources.iterator();
            while (iter.hasNext() && (format = (childDataItem = (DataItem)iter.next()).getFormat()) == null) {
            }
        }
        return format;
    }

    @Override
    public String[] getExpressionTypeNames() {
        boolean isOLAP = this.getLevelHasMembers();
        return BaseCalculatedObjectFactory.getCalcItemTypeNames(isOLAP);
    }

    public static String[] getCalcItemTypeNames(boolean isOLAP) {
        String[] returnNames = isOLAP ? new String[]{LABEL_CALCITEM_TYPE_OLAP_MEASURE, LABEL_CALCITEM_TYPE_OLAP_CATEGORY} : new String[]{LABEL_CALCITEM_TYPE_NOT_SET, LABEL_CALCITEM_TYPE_NUMERIC, LABEL_CALCITEM_TYPE_CHARACTER, LABEL_CALCITEM_TYPE_DATE, LABEL_CALCITEM_TYPE_TIME, LABEL_CALCITEM_TYPE_TIMESTAMP};
        return returnNames;
    }

    @Override
    public int[] getExpressionTypeValues() {
        boolean isOLAP = this.getLevelHasMembers();
        return BaseCalculatedObjectFactory.getCalcItemTypeValues(isOLAP);
    }

    public static int[] getCalcItemTypeValues(boolean isOLAP) {
        int[] returnValues = isOLAP ? new int[]{-2, -3} : new int[]{0, 2, 3, 4, 5, 6};
        return returnValues;
    }

    public static int convertToCalcItemType(int expressionType, boolean isOLAP) {
        int newType = -1;
        if (isOLAP) {
            switch (expressionType) {
                case 0: {
                    newType = 0;
                    break;
                }
                case 3: {
                    newType = -3;
                    break;
                }
                default: {
                    newType = -2;
                    break;
                }
            }
        } else {
            switch (expressionType) {
                case 0: {
                    newType = 0;
                    break;
                }
                case 3: {
                    newType = 3;
                    break;
                }
                case 2: {
                    newType = 2;
                    break;
                }
                case 5: {
                    newType = 5;
                    break;
                }
                case 4: {
                    newType = 4;
                    break;
                }
                case 6: {
                    newType = 6;
                    break;
                }
                case 8: {
                    newType = 8;
                    break;
                }
                case 7: {
                    newType = 7;
                    break;
                }
                case 1: {
                    newType = 1;
                    break;
                }
                case 9: {
                    newType = 9;
                    break;
                }
                default: {
                    newType = 0;
                }
            }
        }
        return newType;
    }

    public static String getExpressionTypeLabel(int expressionType, boolean isOlap) {
        String result = null;
        if (isOlap) {
            switch (expressionType) {
                case 0: {
                    result = LABEL_CALCITEM_TYPE_NOT_SET;
                    break;
                }
                case 3: {
                    result = LABEL_CALCITEM_TYPE_OLAP_CATEGORY;
                    break;
                }
                default: {
                    result = LABEL_CALCITEM_TYPE_OLAP_MEASURE;
                    break;
                }
            }
        } else {
            switch (expressionType) {
                case 0: {
                    result = LABEL_CALCITEM_TYPE_NOT_SET;
                    break;
                }
                case 3: {
                    result = LABEL_CALCITEM_TYPE_CHARACTER;
                    break;
                }
                case 2: {
                    result = LABEL_CALCITEM_TYPE_NUMERIC;
                    break;
                }
                case 5: {
                    result = LABEL_CALCITEM_TYPE_TIME;
                    break;
                }
                case 4: {
                    result = LABEL_CALCITEM_TYPE_DATE;
                    break;
                }
                case 6: {
                    result = LABEL_CALCITEM_TYPE_TIMESTAMP;
                    break;
                }
                case 8: {
                    result = LABEL_CALCITEM_TYPE_INTERVAL_DT;
                    break;
                }
                case 7: {
                    result = LABEL_CALCITEM_TYPE_INTERVAL_YM;
                    break;
                }
                case 1: {
                    result = LABEL_CALCITEM_TYPE_BITSTRING;
                    break;
                }
                case 9: {
                    result = LABEL_CALCITEM_TYPE_BOOLEAN;
                    break;
                }
                default: {
                    result = LABEL_CALCITEM_TYPE_NOT_SET;
                }
            }
        }
        return result;
    }

    public static int convertToExpressionType(int calculatedItemType, boolean isOLAP) {
        int newType = -1;
        if (isOLAP) {
            switch (calculatedItemType) {
                case 0: {
                    newType = 0;
                    break;
                }
                case -3: {
                    newType = 3;
                    break;
                }
                default: {
                    newType = 2;
                    break;
                }
            }
        } else {
            switch (calculatedItemType) {
                case 0: {
                    newType = 0;
                    break;
                }
                case 3: {
                    newType = 3;
                    break;
                }
                case 2: {
                    newType = 2;
                    break;
                }
                case 5: {
                    newType = 5;
                    break;
                }
                case 4: {
                    newType = 4;
                    break;
                }
                case 6: {
                    newType = 6;
                    break;
                }
                case 8: {
                    newType = 8;
                    break;
                }
                case 7: {
                    newType = 7;
                    break;
                }
                case 1: {
                    newType = 1;
                    break;
                }
                case 9: {
                    newType = 9;
                    break;
                }
                default: {
                    newType = 0;
                }
            }
        }
        return newType;
    }

    @Override
    public List getDataSources(boolean includeBaseModels) {
        return this._businessModel.getObjects(includeBaseModels ? 1 : 0, DataSource.class);
    }

    private String _getObjectName(Object item) {
        String namedObjectName = null;
        String text = null;
        if (item instanceof NamedObjectInterface) {
            namedObjectName = ((NamedObjectInterface)item).getLabel();
        }
        if (namedObjectName != null) {
            text = namedObjectName;
        } else if (item instanceof Member) {
            try {
                text = ((Member)item).getMemberName();
            }
            catch (MetadataException e) {
                this.log.error("", (Throwable)e);
                text = item.toString();
            }
        } else {
            text = item instanceof MapFolder ? ((MapFolder)item).getLabel() : item.toString();
        }
        return text;
    }

    @Override
    public String getBusinessObjectDisplayName(Object item) {
        String text;
        block6: {
            text = this._getObjectName(item);
            if (item instanceof Dimension) {
                try {
                    Dimension d = (Dimension)item;
                    if (d.getDimensionType() == 1) {
                        text = MessageFormat.format(DISPLAYNAME_TAG_MEASURESDIMENSION, text);
                        break block6;
                    }
                    text = MessageFormat.format(DISPLAYNAME_TAG_NORMALDIMENSIONS, text);
                }
                catch (MetadataException metadataException) {}
            } else if (item instanceof Hierarchy) {
                text = MessageFormat.format(DISPLAYNAME_TAG_HIERARCHY, text);
            }
        }
        return text;
    }

    @Override
    public String getBusinessObjectDescription(Object bmObject) {
        String namedObjectDescription = null;
        String text = null;
        if (bmObject instanceof NamedObjectInterface) {
            namedObjectDescription = ((NamedObjectInterface)bmObject).getDescription();
        }
        text = namedObjectDescription != null ? namedObjectDescription : (bmObject instanceof MapFolder ? ((MapFolder)bmObject).getDescription() : "");
        return text;
    }

    private Object _getRootImplObject(Object bmObject) {
        DataItem dataItem;
        ExpressionInterface expr;
        Object item = bmObject;
        if (item instanceof DataItem && (expr = (dataItem = (DataItem)item).getExpression()) != null) {
            item = expr;
        }
        return item;
    }

    @Override
    public String getBusinessObjectTipText(Object bmObject) {
        String tip_3_BasedOnText;
        String tip_2_Desc;
        String tip_1_Insert;
        String tip_0_Label;
        String tipFormat;
        block27: {
            Object item = bmObject;
            Object basedOn = this._getRootImplObject(bmObject);
            tipFormat = TIPTEXT_TAG_DEFAULT;
            tip_0_Label = this._getObjectName(item);
            tip_1_Insert = this.getBusinessObjectInsertName(item);
            tip_2_Desc = this.getBusinessObjectDescription(item);
            tip_3_BasedOnText = "";
            if (basedOn instanceof ExpressionInterface) {
                tip_3_BasedOnText = this.getExpressionUtilText((ExpressionInterface)basedOn);
            }
            if (item instanceof Dimension) {
                try {
                    Dimension d = (Dimension)item;
                    if (d.getDimensionType() == 1) {
                        tipFormat = TIPTEXT_TAG_PHYSICAL_DIMENSION_MEASURES;
                        break block27;
                    }
                    tipFormat = TIPTEXT_TAG_PHYSICAL_DIMENSION_NORMAL;
                }
                catch (MetadataException d) {}
            } else if (item instanceof Member) {
                tipFormat = TIPTEXT_TAG_PHYSICAL_MEMBER;
            } else if (item instanceof Measure) {
                tipFormat = TIPTEXT_TAG_PHYSICAL_MEASURE;
            } else if (item instanceof Level) {
                tipFormat = TIPTEXT_TAG_PHYSICAL_LEVEL;
            } else if (item instanceof ConditionalExpression) {
                tipFormat = TIPTEXT_TAG_CONDITIONAL;
            } else if (item instanceof Column) {
                tipFormat = TIPTEXT_TAG_PHYSICAL_COLUMN;
            } else if (item instanceof Hierarchy) {
                boolean isDefHier = false;
                try {
                    List hierarchies;
                    Dimension dim = ((Hierarchy)item).getOwningDimension();
                    if (dim != null && (hierarchies = dim.getHierarchies()) != null && hierarchies.size() > 0) {
                        isDefHier = item.equals(hierarchies.get(0));
                    }
                }
                catch (MetadataException e) {
                    this.log.error("", (Throwable)e);
                }
                tipFormat = isDefHier ? TIPTEXT_TAG_PHYSICAL_HIERARCHY_DEFAULT : TIPTEXT_TAG_PHYSICAL_HIERARCHY_OTHER;
            } else if (item instanceof DataSource) {
                StructureOfData sod = ((DataSource)item).getStructure();
                tipFormat = sod.isRelational() ? TIPTEXT_TAG_PHYSICAL_DATASOURCE_TABLE : (sod.isOLAP() ? TIPTEXT_TAG_PHYSICAL_DATASOURCE_CUBE : TIPTEXT_TAG_PHYSICAL_DATASOURCE_OTHER);
            } else if (item instanceof DataItem) {
                tipFormat = TIPTEXT_TAG_DATAITEM;
            } else if (item instanceof ExpressionInterface) {
                tipFormat = TIPTEXT_TAG_EXPRESSION;
            }
        }
        if (tip_0_Label == null) {
            tip_0_Label = "";
        }
        String tipText = MessageFormat.format(tipFormat, tip_0_Label, tip_1_Insert, tip_2_Desc, tip_3_BasedOnText);
        tipText = tipText.trim();
        return tipText;
    }

    @Override
    public String getBusinessObjectInsertName(Object item) {
        String insertName = null;
        if (item != null) {
            insertName = "";
            if (item instanceof ExpressionInterface) {
                insertName = this.getExpressionUtilText((ExpressionInterface)item);
            } else if (item instanceof DataSource) {
                insertName = ((DataSource)item).getIntraModelID();
            }
        }
        return insertName;
    }

    @Override
    public boolean canBusinessModelObjectHaveChildren(Object bmObject) {
        boolean returnValue = false;
        Object item = this._getRootImplObject(bmObject);
        if (item instanceof Measure) {
            returnValue = false;
        }
        if (item instanceof Member) {
            try {
                int childrenCardinality = ((Member)item).getChildrenCardinality();
                returnValue = childrenCardinality > 0;
            }
            catch (MetadataException e) {
                this.log.error("", (Throwable)e);
            }
        } else if (item instanceof Level || item instanceof Dimension || item instanceof Hierarchy || item instanceof Cube || item instanceof Table) {
            returnValue = true;
        }
        return returnValue;
    }

    @Override
    public List getBusinessModelObjectChildren(Object bmObject) {
        Object item = this._getRootImplObject(bmObject);
        if (item instanceof Measure) {
            return new ArrayList();
        }
        List values = null;
        if (item instanceof Table) {
            values = this._getChildren((Table)item);
        } else if (item instanceof Cube) {
            values = this._getChildren((Cube)item);
        } else if (item instanceof Dimension) {
            values = this._getChildren((Dimension)item);
        } else if (item instanceof Hierarchy) {
            values = this._getChildren((Hierarchy)item);
        } else if (item instanceof Level) {
            values = this._getChildren((Level)item);
        } else if (item instanceof Member) {
            values = this._getChildren((Member)item);
        }
        ArrayList returnValues = new ArrayList();
        if (values != null) {
            returnValues.addAll(values);
        }
        return returnValues;
    }

    private List _getChildren(Table metaTable) {
        if (this._cachedChildrenLists.containsKey(metaTable)) {
            return (List)this._cachedChildrenLists.get(metaTable);
        }
        try {
            List values = metaTable.getColumns();
            this._cachedChildrenLists.put(metaTable, values);
            return values;
        }
        catch (MetadataException e) {
            this.log.error("", (Throwable)e);
            return null;
        }
    }

    private List _getValues(Table table) {
        List tableColumns = this._getChildren(table);
        if (tableColumns != null && tableColumns.size() == 0) {
            tableColumns = null;
        }
        return this.convertBusinessObjectListToValuesList(tableColumns, "{0}");
    }

    private List _getChildren(Cube metaCube) {
        if (this._cachedChildrenLists.containsKey(metaCube)) {
            return (List)this._cachedChildrenLists.get(metaCube);
        }
        try {
            List values = metaCube.getDimensions();
            this._cachedChildrenLists.put(metaCube, values);
            return values;
        }
        catch (MetadataException e) {
            this.log.error("", (Throwable)e);
            return null;
        }
    }

    private List _getChildren(Dimension dimension) {
        if (this._cachedChildrenLists.containsKey(dimension)) {
            return (List)this._cachedChildrenLists.get(dimension);
        }
        try {
            List values = null;
            values = dimension.getDimensionType() == 1 ? dimension.getOwningCube().getMeasures() : dimension.getHierarchies();
            this._cachedChildrenLists.put(dimension, values);
            return values;
        }
        catch (MetadataException e) {
            this.log.error("", (Throwable)e);
            return null;
        }
    }

    private List _getValues(Dimension olapDimension) {
        List valuesFound = this._getChildren(olapDimension);
        if (valuesFound != null && valuesFound.size() == 0) {
            valuesFound = null;
        }
        return this.convertBusinessObjectListToValuesList(valuesFound, "{0}");
    }

    private List _getChildren(Hierarchy heirarchy) {
        if (this._cachedChildrenLists.containsKey(heirarchy)) {
            return (List)this._cachedChildrenLists.get(heirarchy);
        }
        try {
            List levels = heirarchy.getLevels();
            return levels;
        }
        catch (MetadataException e) {
            this.log.error("", (Throwable)e);
            return null;
        }
    }

    private List _getValues(Hierarchy olapHierarchy) {
        List hierarchyLevels = this._getChildren(olapHierarchy);
        if (hierarchyLevels != null && hierarchyLevels.size() == 0) {
            hierarchyLevels = null;
        }
        return this.convertBusinessObjectListToValuesList(hierarchyLevels, "{0}");
    }

    private List _getChildren(Level level) {
        if (this._cachedChildrenLists.containsKey(level)) {
            return (List)this._cachedChildrenLists.get(level);
        }
        try {
            List values = level.getMembers();
            this._cachedChildrenLists.put(level, values);
            return values;
        }
        catch (MetadataException e) {
            this.log.error("", (Throwable)e);
            return null;
        }
    }

    private List _getValues(Level olapLevel) {
        List levelMembers = this._getChildren(olapLevel);
        if (levelMembers != null && levelMembers.size() == 0) {
            levelMembers = null;
        }
        return this.convertBusinessObjectListToValuesList(levelMembers, "{0}");
    }

    private List _getChildren(Member member) {
        if (this._cachedChildrenLists.containsKey(member)) {
            return (List)this._cachedChildrenLists.get(member);
        }
        int childrenCardinality = -1;
        try {
            childrenCardinality = member.getChildrenCardinality();
        }
        catch (MetadataException me) {
            this.log.error("", (Throwable)me);
        }
        if (childrenCardinality > 0) {
            try {
                List values = member.getChildrenMembers();
                this._cachedChildrenLists.put(member, values);
                return values;
            }
            catch (MetadataException e) {
                this.log.error("", (Throwable)e);
            }
        }
        return null;
    }

    private List _getValues(Member olapMember) {
        List childMembers = this._getChildren(olapMember);
        if (childMembers != null && childMembers.size() == 0) {
            childMembers = null;
        }
        return this.convertBusinessObjectListToValuesList(childMembers, "{0}");
    }

    @Override
    public boolean canBusinessModelObjectHaveValues(Object bmObject) {
        if (bmObject instanceof DataItem) {
            Object rootDataItem = this._getRootImplObject(bmObject);
            return !(rootDataItem instanceof Measure);
        }
        if (bmObject instanceof Measure) {
            return false;
        }
        if (bmObject instanceof Member || bmObject instanceof Level || bmObject instanceof Hierarchy || bmObject instanceof Dimension || bmObject instanceof Table) {
            return true;
        }
        return bmObject instanceof ExpressionInterface;
    }

    @Override
    public List getBusinessModelObjectValues(Object bmObject) {
        DataItem dataItem = null;
        ExpressionInterface expression = null;
        if (bmObject instanceof DataItem) {
            dataItem = (DataItem)bmObject;
            return this.getDataServiceValues(dataItem);
        }
        if (bmObject instanceof ExpressionInterface) {
            expression = (ExpressionInterface)bmObject;
        }
        if (expression instanceof Measure) {
            return null;
        }
        List values = null;
        if (expression instanceof Member || expression instanceof Level || expression instanceof Dimension || bmObject instanceof Hierarchy || bmObject instanceof Table) {
            if (expression instanceof Member) {
                values = this._getValues((Member)expression);
            } else if (expression instanceof Level) {
                values = this._getValues((Level)expression);
            } else if (bmObject instanceof Hierarchy) {
                values = this._getValues((Hierarchy)bmObject);
            } else if (expression instanceof Dimension) {
                values = this._getValues((Dimension)expression);
            } else if (bmObject instanceof Table) {
                values = this._getValues((Table)bmObject);
            }
            return values;
        }
        if (expression != null) {
            List dataValues = null;
            try {
                int maxValues = this.getMaxOutputObservations();
                dataValues = BaseCalculatedObjectFactory.getExpressionValues(this._businessModel, expression, maxValues);
            }
            catch (DataServicesException e) {
                boolean interruption = BaseCalculatedObjectFactory.isInterruptedGetPossibleFilterValues(e);
                if (!interruption) {
                    this.log.error("", (Throwable)e);
                }
            }
            catch (MetadataException e) {
                this.log.error("", (Throwable)e);
            }
            return dataValues;
        }
        return null;
    }

    protected List convertBusinessObjectListToValuesList(List businessObjects, String formatString) {
        ArrayList<DefaultFilterValue> valuesList = new ArrayList<DefaultFilterValue>();
        if (businessObjects != null) {
            for (int i = 0; i < businessObjects.size(); ++i) {
                Object object = businessObjects.get(i);
                String name = this._getObjectName(object);
                name = name.trim();
                String insertValue = this.getBusinessObjectInsertName(object);
                DefaultFilterValue value = new DefaultFilterValue(object, name, 0, object.getClass(), (Object)insertValue, formatString);
                if (value == null) continue;
                valuesList.add(value);
            }
        }
        return valuesList;
    }

    protected List getDataServiceValues(DataItem dataItem) {
        List dataServiceValues = null;
        int maxValues = this.getMaxOutputObservations();
        dataServiceValues = BaseCalculatedObjectFactory.getDataItemValues(dataItem, maxValues);
        return dataServiceValues;
    }

    @Override
    public String getBusinessModelObjectValuesToInsert(Object item) {
        Object unformatted = null;
        if (item instanceof FilterValueInterface) {
            FilterValueInterface fvi = (FilterValueInterface)item;
            Object data = fvi.getData();
            if (data instanceof PossibleFilterValue) {
                item = data;
            } else {
                unformatted = fvi.getUnformattedValue();
                if (unformatted == null) {
                    return fvi.getFormattedValue();
                }
            }
        }
        if (unformatted == null && item instanceof PossibleFilterValue) {
            PossibleFilterValue pfv = (PossibleFilterValue)item;
            try {
                unformatted = pfv.getUnformatted();
                if (unformatted == null) {
                    return pfv.getFormatted();
                }
            }
            catch (DataServicesException e) {
                return item.toString();
            }
        }
        if (unformatted instanceof AbstractTimeValueExpression) {
            if (this._timeDateLookupCache.containsKey(unformatted)) {
                unformatted = this._timeDateLookupCache.get(unformatted);
            } else {
                AbstractTimeValueExpression atve = (AbstractTimeValueExpression)unformatted;
                if (this._timeDateSyntaxDataSelection == null) {
                    this._timeDateSyntaxDataSelection = DataSelectionFactory.newDataSelection((BusinessModel)this._businessModel);
                }
                String generated = null;
                try {
                    generated = atve.generateQueryText(this._timeDateSyntaxDataSelection, ConnectionType.IOM);
                }
                catch (MetadataException e) {
                    return item.toString();
                }
                if (generated != null) {
                    this._timeDateLookupCache.put(unformatted, generated);
                    unformatted = generated;
                }
            }
        }
        if (unformatted != null) {
            return unformatted.toString();
        }
        String value = this.getBusinessObjectInsertName(item);
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public String getLastInvalidCalculatedItemMessage() {
        return this.lastInvalidCalculatedItemMessage;
    }

    @Override
    public boolean validateCalculatedItem(CalculatedItemInterface item) {
        return this.validateCalculatedItem(item, true);
    }

    @Override
    public boolean validateCalculatedItem(CalculatedItemInterface item, boolean validateText) {
        this.lastInvalidExpressionException = null;
        this.lastInvalidCalculatedItemMessage = null;
        if (item == null) {
            this.lastInvalidCalculatedItemMessage = ERROR_INVALIDITEM;
            return false;
        }
        String label = item.getLabel();
        if (label == null || label.length() == 0) {
            this.lastInvalidCalculatedItemMessage = ERROR_INVALIDITEM_LABEL;
            return false;
        }
        try {
            int exprType = item.convertToExpressionType(item.getExpressionType(), this.getLevelHasMembers());
            RootDataItem dataItem = this._businessModel.newDataItem();
            ExpressionInterface expression = this.parseExpression(item.getExpression(), exprType);
            dataItem.setExpression(expression);
            dataItem.setLabel(label);
        }
        catch (MetadataException e) {
            this.lastInvalidCalculatedItemMessage = e.getLocalizedMessage();
            this.lastInvalidExpressionException = e;
            return false;
        }
        int calcType = item.getExpressionType();
        if (calcType == 0) {
            this.lastInvalidCalculatedItemMessage = ERROR_TYPENOTSET;
            return false;
        }
        boolean typeOk = false;
        int[] validTypes = this.getExpressionTypeValues();
        for (int i = 0; i < validTypes.length; ++i) {
            if (calcType != validTypes[i]) continue;
            typeOk = true;
            break;
        }
        if (!typeOk) {
            this.lastInvalidCalculatedItemMessage = ERROR_TYPEINVALID;
            return false;
        }
        boolean exprOk = true;
        exprOk = this.validateItemCalculation(item, validateText);
        return exprOk;
    }

    @Override
    public boolean validateItemCalculation(CalculatedItemInterface item) {
        return this.validateItemCalculation(item, true);
    }

    public boolean validateItemCalculation(CalculatedItemInterface item, boolean validateTextOnServer) {
        this.lastInvalidExpressionException = null;
        this.lastInvalidCalculatedItemMessage = null;
        String expr = item.getExpression();
        if (expr == null) {
            // empty if block
        }
        if (expr == null) {
            this.lastInvalidExpressionException = new NullPointerException(ERROR_INVALIDEXPR);
            this.lastInvalidCalculatedItemMessage = ERROR_INVALIDEXPR;
            return false;
        }
        int calcType = item.getExpressionType();
        boolean isOLAP = this.getLevelHasMembers();
        int exprType = item.convertToExpressionType(calcType, isOLAP);
        ExpressionInterface expression = this.parseExpression(expr, exprType);
        try {
            if (item instanceof CalculatedItemV2Interface && ((CalculatedItemV2Interface)item).isTimeBasedItem()) {
                Object measure = ((CalculatedItemV2Interface)item).getMeasureExpression();
                if (measure == null) {
                    this.lastInvalidCalculatedItemMessage = ERROR_INVALIDITEM;
                    return false;
                }
                expression = new TimeExpressionMeasure((DataItem)measure, ((CalculatedItemV2Interface)item).getTimeFunction());
            }
        }
        catch (Exception e) {
            this.lastInvalidCalculatedItemMessage = ERROR_INVALIDITEM;
            return false;
        }
        if (expression == null) {
            this.lastInvalidCalculatedItemMessage = this.lastInvalidExpressionException.getMessage();
            return false;
        }
        if (validateTextOnServer && !((CalculatedItemV2Interface)item).isTimeBasedItem()) {
            boolean exprOk = this.validateCalculatedItemOnServer(item);
            if (this.lastInvalidExpressionException != null) {
                this.lastInvalidCalculatedItemMessage = this.lastInvalidExpressionException.getMessage();
            }
            if (!exprOk) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getBusinessModelObjectImageName(Object value, boolean expanded) {
        if (this.cachedImageNamesExpanded == null) {
            this.cachedImageNamesExpanded = new HashMap();
        }
        if (this.cachedImageNamesCollapsed == null) {
            this.cachedImageNamesCollapsed = new HashMap();
        }
        Map cachedImageNames = null;
        cachedImageNames = expanded ? this.cachedImageNamesExpanded : this.cachedImageNamesCollapsed;
        if (value == null) {
            return null;
        }
        String name = null;
        if (cachedImageNames.containsKey(value)) {
            name = (String)cachedImageNames.get(value);
        } else {
            if (value instanceof Column) {
                Column metaCol = (Column)value;
                int type = 0;
                try {
                    type = metaCol.getExpressionType();
                }
                catch (Throwable t) {
                    this.log.error("", t);
                }
                if (type == 3) {
                    name = IMAGENAME_COLUMN_TYPE_CHARACTER;
                } else if (type == 2) {
                    name = IMAGENAME_COLUMN_TYPE_NUMERIC;
                } else if (type == 6) {
                    name = IMAGENAME_COLUMN_TYPE_TIMESTAMP;
                } else if (type == 5) {
                    name = IMAGENAME_COLUMN_TYPE_TIME;
                } else if (type == 4) {
                    name = IMAGENAME_COLUMN_TYPE_DATE;
                }
            } else if (value instanceof Dimension) {
                name = IMAGENAME_OBJECT_CUBE_DIMENSION;
            } else if (value instanceof Hierarchy) {
                name = IMAGENAME_OBJECT_CUBE_HIERARCHY;
            } else if (value instanceof Level) {
                name = IMAGENAME_OBJECT_CUBE_LEVEL;
            } else if (value instanceof Measure) {
                name = IMAGENAME_OBJECT_CUBE_MEASURE;
            } else if (value instanceof Member) {
                Member member = (Member)value;
                int type = member.getExpressionType();
                if (type == 3) {
                    name = IMAGENAME_MEMBER_TYPE_CHARACTER;
                } else if (type == 2) {
                    name = IMAGENAME_MEMBER_TYPE_NUMERIC;
                } else if (type == 6) {
                    name = IMAGENAME_MEMBER_TYPE_TIMESTAMP;
                } else if (type == 5) {
                    name = IMAGENAME_MEMBER_TYPE_TIME;
                } else if (type == 4) {
                    name = IMAGENAME_MEMBER_TYPE_DATE;
                }
                if (name == null) {
                    name = IMAGENAME_OBJECT_TYPE_COLUMN;
                }
            } else if (value instanceof DataSource) {
                DataSource ds = (DataSource)value;
                name = ds.getStructure().isRelational() ? IMAGENAME_OBJECT_DATASET : (ds.getStructure().isOLAP() ? IMAGENAME_OBJECT_CUBE : IMAGENAME_OBJECT_DATASOURCE);
            } else if (value instanceof String) {
                name = expanded ? IMAGENAME_FOLDER_OPENED : IMAGENAME_FOLDER_CLOSED;
            } else if (value instanceof MapFolder) {
                name = expanded ? IMAGENAME_FOLDER_OPENED : IMAGENAME_FOLDER_CLOSED;
            } else if (value instanceof FilterItem) {
                boolean hasPrompt;
                FilterItem fItem = (FilterItem)value;
                List prompts = fItem.getPrompts(65535);
                boolean bl = hasPrompt = prompts != null && !prompts.isEmpty();
                name = hasPrompt ? IMAGENAME_OBJECT_PROMPTED_FILTER : IMAGENAME_OBJECT_FILTER;
            } else if (value instanceof DataItem) {
                DataItem dItem = (DataItem)value;
                DataItemActionType usage = dItem.getUsage();
                name = usage == DataItemActionType.USAGE_DETAIL ? IMAGENAME_OBJECT_DETAIL : (usage == DataItemActionType.USAGE_CATEGORY ? IMAGENAME_OBJECT_CATEGORY : IMAGENAME_OBJECT_MEASURE);
            } else if (value instanceof BusinessModel) {
                name = IMAGENAME_OBJECT_COLLECTION;
            }
            cachedImageNames.put(value, name);
        }
        return name;
    }

    public CalculatedObjectFactoryInterface.ImageIconFactoryInterface getImageIconFactory() {
        return this._imageIconFactory;
    }

    public void setImageIconFactory(CalculatedObjectFactoryInterface.ImageIconFactoryInterface imageIconFactory) {
        this._imageIconFactory = imageIconFactory;
    }

    public Icon getImageIconByImageName(String imageName) {
        if (this.cachedImageIcons == null) {
            this.cachedImageIcons = new HashMap();
        }
        if (imageName == null) {
            return null;
        }
        Icon icon = null;
        if (this.cachedImageIcons.containsKey(imageName)) {
            icon = (ImageIcon)this.cachedImageIcons.get(imageName);
        } else {
            CalculatedObjectFactoryInterface.ImageIconFactoryInterface imageIconFactory = this.getImageIconFactory();
            if (imageIconFactory == null) {
                return null;
            }
            try {
                icon = imageIconFactory.getImageIconByImageName(imageName);
            }
            catch (Exception e) {
                this.log.error(ERROR_FINDINGICONIMAGE, (Throwable)e);
            }
            this.cachedImageIcons.put(imageName, icon);
        }
        return icon;
    }

    @Override
    public Icon getImageIconFromIqVisualsBundle(String imageName) {
        return this.getImageIconByImageName(imageName);
    }

    @Override
    public ResourceScope getResourceScope() {
        return this._scope;
    }

    @Override
    public void setResourceScope(ResourceScope scope) {
        this._scope = scope;
    }

    @Override
    public String getExpressionUtilText(ExpressionInterface expression) {
        try {
            return _stringExpressionUtil.getText(expression, this.getResourceScope(), this._businessModel);
        }
        catch (MetadataException e) {
            this.log.error(ERROR_PARSINGEXPRTEXT, (Throwable)e);
            return null;
        }
    }

    @Override
    public ExpressionInterface newExpressionUtilExpression(String text, int type) {
        ExpressionInterface expression = null;
        try {
            expression = _stringExpressionUtil.newExpression(this._businessModel, text, type, this.getResourceScope());
        }
        catch (MetadataException e) {
            this.log.error(ERROR_FORMATTINGEXPRTEXT, (Throwable)e);
        }
        return expression;
    }

    @Override
    public Exception getLastInvalidExpressionException() {
        return this.lastInvalidExpressionException;
    }

    public ExpressionInterface parseExpression(String text, int type) {
        String key = type + text;
        Object value = this.parseExpressionMap.get(key);
        if (value != null) {
            return (ExpressionInterface)value;
        }
        this.lastInvalidExpressionException = null;
        ExpressionInterface expression = null;
        try {
            expression = _stringExpressionUtil.newExpression(this._businessModel, text, type, this.getResourceScope());
        }
        catch (ParseExpressionException pee) {
            this.lastInvalidExpressionException = pee;
        }
        catch (ResourceIdentificationException rie) {
            this.lastInvalidExpressionException = rie;
        }
        catch (MetadataException me) {
            this.lastInvalidExpressionException = me;
        }
        this.parseExpressionMap.put(key, expression);
        return expression;
    }

    public boolean validateExpression(ExpressionInterface expression) {
        this.lastInvalidExpressionException = null;
        boolean isOK = true;
        try {
            BaseCalculatedObjectFactory.validateExpression(this._businessModel, expression);
        }
        catch (MetadataException me) {
            this.lastInvalidExpressionException = me;
            isOK = false;
        }
        catch (DataServicesException dse) {
            this.lastInvalidExpressionException = dse;
            int reasonCode = dse.getReasonCode();
            if (reasonCode == -1) {
                isOK = true;
            }
            if (reasonCode == -2) {
                isOK = true;
                if (this.isTypeChangeWarningIgnored()) {
                    this.lastInvalidExpressionException = null;
                }
            }
            isOK = false;
        }
        return isOK;
    }

    public static void validateExpression(BusinessModel sourceModel, ExpressionInterface expression) throws DataServicesException, MetadataException {
        IQDataServices dataService = IQDataServicesFactory.newService();
        dataService.verify(sourceModel, expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateCalculatedItemOnServer(CalculatedItemInterface calculatedItem) {
        boolean valid = false;
        this.lastInvalidExpressionException = null;
        DataItem dataItem = this.convertToDataItem(calculatedItem);
        if (dataItem != null && this._businessModel != null) {
            try {
                this._businessModel.addBusinessItem((BusinessItem)dataItem);
                IQDataServices dataService = IQDataServicesFactory.newService();
                dataService.verify((BusinessItem)dataItem);
                valid = true;
            }
            catch (DataServicesException dse) {
                this.lastInvalidExpressionException = dse;
                int reasonCode = dse.getReasonCode();
                if (reasonCode == -1) {
                    valid = true;
                } else if (reasonCode == -2) {
                    valid = true;
                    if (this.isTypeChangeWarningIgnored()) {
                        this.lastInvalidExpressionException = null;
                    }
                }
            }
            catch (MetadataException me) {
                this.lastInvalidExpressionException = me;
            }
            finally {
                try {
                    this._businessModel.removeBusinessItem((BusinessItem)dataItem);
                }
                catch (MetadataException dse) {}
            }
        }
        return valid;
    }

    protected DataItem convertToDataItem(CalculatedItemInterface calculatedItem) {
        if (this._businessModel == null || calculatedItem == null) {
            return null;
        }
        try {
            RootDataItem dataItem = this._businessModel.newDataItem();
            dataItem.setLabel(calculatedItem.getLabel());
            int dataItemExpressionType = calculatedItem.convertToExpressionType(calculatedItem.getExpressionType(), this.getLevelHasMembers());
            ExpressionInterface expression = this.parseExpression(calculatedItem.getExpression(), dataItemExpressionType);
            dataItem.setExpression(expression);
            dataItem.setDescription(calculatedItem.getDescription());
            dataItem.setFormat(calculatedItem.getFormat());
            return dataItem;
        }
        catch (MetadataException me) {
            this.lastInvalidExpressionException = me;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getExpressionValues(BusinessModel sourceModel, ExpressionInterface expression, int maxValues) throws DataServicesException, MetadataException {
        IQDataServices dataService = IQDataServicesFactory.newService();
        if (dataService == null) {
            return null;
        }
        DataSelection businessQuery = DataSelectionFactory.newDataSelection((BusinessModel)sourceModel);
        if (businessQuery == null) {
            return null;
        }
        BusinessModel businessModel = businessQuery.getBusinessModel();
        if (businessModel == null) {
            return null;
        }
        List dataValues = null;
        try {
            String format;
            Governing govern = null;
            try {
                govern = businessModel.newGoverning();
                govern.setOutputObservations(maxValues);
            }
            catch (MetadataException e) {
                e.printStackTrace();
                govern = null;
            }
            RootDataItem dataItem = null;
            dataItem = businessModel.newDataItem();
            dataItem.setExpression(expression);
            if (expression instanceof Column && (format = ((Column)expression).getSasFormat()) != null && format.length() > 0) {
                BaseCalculatedObjectFactory.setFormat((DataItem)dataItem, format);
            }
            businessModel.addBusinessItem((BusinessItem)dataItem);
            try {
                dataValues = govern == null ? dataService.getPossibleFilterValues((DataItem)dataItem) : dataService.getPossibleFilterValues((DataItem)dataItem, govern);
            }
            finally {
                try {
                    businessModel.removeBusinessItem((BusinessItem)dataItem);
                }
                catch (MetadataException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            sourceModel.removeChild(businessModel);
        }
        return dataValues;
    }

    public static List getDataItemValues(DataItem dataItem, int maxValues) {
        IQDataServices dataService = null;
        try {
            dataService = IQDataServicesFactory.newService();
        }
        catch (DataServicesException e) {
            e.printStackTrace();
        }
        if (dataService == null) {
            return null;
        }
        BusinessModel businessModel = dataItem.getBusinessModel();
        if (businessModel == null) {
            return null;
        }
        List dataServiceValues = null;
        boolean isOlap = false;
        if (businessModel.getStructure() != null) {
            isOlap = businessModel.getStructure().isOLAP();
        }
        if (isOlap) {
            return null;
        }
        Governing govern = null;
        try {
            govern = businessModel.newGoverning();
            govern.setOutputObservations(maxValues);
        }
        catch (MetadataException e) {
            e.printStackTrace();
            govern = null;
        }
        try {
            dataServiceValues = govern == null ? dataService.getPossibleFilterValues(dataItem) : dataService.getPossibleFilterValues(dataItem, govern);
        }
        catch (DataServicesException e) {
            boolean interruption = BaseCalculatedObjectFactory.isInterruptedGetPossibleFilterValues(e);
            if (!interruption) {
                e.printStackTrace();
            }
            return null;
        }
        return dataServiceValues;
    }

    public static boolean isInterruptedGetPossibleFilterValues(DataServicesException e) {
        boolean interruption = false;
        Throwable t = e;
        while (t != null) {
            Throwable cause = t.getCause();
            if (t instanceof InterruptedException || cause instanceof InterruptedException) {
                interruption = true;
                break;
            }
            Throwable t2 = null;
            if (t instanceof ChainedException) {
                t2 = ((ChainedException)t).getTargetException();
            }
            if (t2 == null && t instanceof SQLException) {
                int sam239;
                String msg = t.getMessage();
                if (msg == null) {
                    msg = t.toString();
                }
                if ((sam239 = msg.indexOf("sam.S239.ex.msg")) >= 0) {
                    interruption = true;
                    break;
                }
                t2 = ((SQLException)t).getNextException();
            }
            if (t2 == null) {
                t2 = cause;
            }
            if (t == t2) break;
            t = t2;
        }
        if (!interruption) {
            t = e;
            while (t != null) {
                String msg = t.getMessage();
                if (msg == null) {
                    msg = t.toString();
                }
                int sam239 = msg.indexOf("sam.S239.ex.msg");
                msg = msg.toLowerCase();
                int wait = msg.indexOf("thread waiting");
                int intr = msg.indexOf("interrupted");
                if (sam239 >= 0 || wait >= 0 && intr > wait) {
                    interruption = true;
                    break;
                }
                Throwable t2 = null;
                if (t instanceof ChainedException) {
                    t2 = ((ChainedException)t).getTargetException();
                }
                if (t2 == null && t instanceof SQLException) {
                    t2 = ((SQLException)t).getNextException();
                }
                if (t2 == null) {
                    t2 = t.getCause();
                }
                if (t == t2) break;
                t = t2;
            }
        }
        return interruption;
    }

    static List _getResourceListFormats(List resources, int restrictByType) {
        ArrayList<String> formats = new ArrayList<String>();
        String format = null;
        for (Object child : resources) {
            if (!(child instanceof DataItem)) continue;
            DataItem childDataItem = (DataItem)child;
            if (restrictByType != 0 && restrictByType != childDataItem.getExpressionType() || (format = childDataItem.getFormat()) == null) continue;
            formats.add(format);
        }
        return formats;
    }

    public static List getChildFormats(DataItem dataItem, int restrictByType) {
        if (dataItem == null) {
            return new ArrayList();
        }
        List resources = dataItem.getResources(DataItem.class, 2);
        if (resources == null) {
            return new ArrayList();
        }
        return BaseCalculatedObjectFactory._getResourceListFormats(resources, restrictByType);
    }

    public static List getChildFormats(ExpressionInterface expression, int restrictByType) {
        if (expression == null) {
            return new ArrayList();
        }
        List resources = expression.getResources(DataItem.class, 2);
        if (resources == null) {
            return new ArrayList();
        }
        return BaseCalculatedObjectFactory._getResourceListFormats(resources, restrictByType);
    }

    @Override
    public List getChildFormats(String expressionText, int expressionType, int restrictByType) {
        ExpressionInterface expression = this.newExpressionUtilExpression(expressionText, expressionType);
        return BaseCalculatedObjectFactory.getChildFormats(expression, restrictByType);
    }

    @Override
    public List getDataItemsAndFolders(boolean includeBaseModels) {
        List allDataItems = this.getDataItems(includeBaseModels);
        ArrayList needFolders = new ArrayList(allDataItems);
        ArrayList<DataSourceTreeNode> returnList = new ArrayList<DataSourceTreeNode>();
        ArrayList<MapFolder> subFolders = new ArrayList<MapFolder>();
        BusinessModel currentModel = this._businessModel;
        DataSourceTreeNode rootNode = null;
        while (currentModel != null) {
            if (currentModel instanceof InformationMap) {
                InformationMap map = (InformationMap)currentModel;
                MapFolder rootFolder = null;
                try {
                    rootFolder = map.getRootMapFolder();
                }
                catch (MetadataException e) {
                    this.log.error("", (Throwable)e);
                    return allDataItems;
                }
                HashMap<MapFolder, DataSourceTreeNode> treeNodes = new HashMap<MapFolder, DataSourceTreeNode>();
                HashMap childNodes = new HashMap();
                List<DataSourceTreeNode> children = null;
                children = new ArrayList();
                childNodes.put(rootFolder, children);
                rootNode = new DataSourceTreeNode(this, null, map, children);
                treeNodes.put(rootFolder, rootNode);
                subFolders.add(rootFolder);
                Iterator iterNeedFolders = needFolders.iterator();
                while (iterNeedFolders.hasNext()) {
                    DataItem needsFolder = (DataItem)iterNeedFolders.next();
                    MapFolder itemFolder = null;
                    if (map == needsFolder.getBusinessModel()) {
                        try {
                            itemFolder = map.getMapFolderContaining((BusinessItem)needsFolder);
                        }
                        catch (MetadataException e) {
                            this.log.error("", (Throwable)e);
                            return allDataItems;
                        }
                    }
                    if (itemFolder == null) {
                        iterNeedFolders.remove();
                        continue;
                    }
                    DataSourceTreeNode parentNode = null;
                    DataSourceTreeNode prevParentNode = null;
                    MapFolder parentFolder = itemFolder;
                    while (!subFolders.contains(parentFolder)) {
                        children = new ArrayList();
                        childNodes.put(parentFolder, children);
                        parentNode = new DataSourceTreeNode(this, null, parentFolder, children);
                        treeNodes.put(parentFolder, parentNode);
                        subFolders.add(parentFolder);
                        if (prevParentNode != null) {
                            children.add(prevParentNode);
                            this.dataItemAndFolderSort(children);
                        }
                        prevParentNode = parentNode;
                        if ((parentFolder = parentFolder.getParent()) != null) continue;
                    }
                    if (parentFolder != null && prevParentNode != null) {
                        children = (List)childNodes.get(parentFolder);
                        children.add(prevParentNode);
                        this.dataItemAndFolderSort(children);
                    }
                    parentNode = (DataSourceTreeNode)treeNodes.get(itemFolder);
                    StructureOfDataItem dataItemStructure = needsFolder.getStructure();
                    Object rootDataItem = this._getRootImplObject(needsFolder);
                    if (!dataItemStructure.isOLAP() || needsFolder.getUsage() != DataItemActionType.USAGE_CATEGORY) {
                        DataSourceTreeNode itemNode = new DataSourceTreeNode(this, parentNode, needsFolder);
                        if (itemFolder != null && itemNode != null) {
                            children = (List)childNodes.get(itemFolder);
                            children.add(itemNode);
                            this.dataItemAndFolderSort(children);
                        }
                    }
                    iterNeedFolders.remove();
                }
            } else {
                ArrayList<DataSourceTreeNode> children = new ArrayList<DataSourceTreeNode>();
                rootNode = new DataSourceTreeNode(this, null, currentModel, children);
                List dataItems = this._businessModel.getObjects(0, DataItem.class);
                Iterator iterNeedFolders = needFolders.iterator();
                while (iterNeedFolders.hasNext()) {
                    DataItem needsFolder = (DataItem)iterNeedFolders.next();
                    if (!dataItems.contains(needsFolder)) continue;
                    DataSourceTreeNode childNode = new DataSourceTreeNode(this, rootNode, needsFolder);
                    children.add(childNode);
                    iterNeedFolders.remove();
                }
                this.dataItemAndFolderSort(children);
            }
            if (rootNode.getChildCount() > 0) {
                returnList.add(rootNode);
            }
            if (needFolders.size() > 0) {
                if (includeBaseModels) {
                    currentModel = currentModel.getParentBusinessModel();
                    continue;
                }
                currentModel = null;
                continue;
            }
            currentModel = null;
        }
        if (needFolders.size() > 0) {
            this.dataItemAndFolderSort(needFolders);
            returnList.addAll(needFolders);
        }
        return returnList;
    }

    private void dataItemAndFolderSort(List list) {
        Object[] objArray = list.toArray(new Object[list.size()]);
        Arrays.sort(objArray, new Comparator(){

            public int compare(Object o1, Object o2) {
                int result = 0;
                if (o1 == null) {
                    result = o2 == null ? 0 : -1;
                } else if (o2 == null) {
                    result = 1;
                } else {
                    boolean o1Folder = false;
                    String o1string = null;
                    if (o1 instanceof DataSourceTreeNode) {
                        DataSourceTreeNode o1node = (DataSourceTreeNode)o1;
                        Object o1object = o1node.getOriginalObject();
                        o1Folder = o1object instanceof MapFolder;
                        o1string = o1node.getName();
                    } else {
                        o1string = o1.toString();
                    }
                    boolean o2Folder = false;
                    String o2string = null;
                    if (o2 instanceof DataSourceTreeNode) {
                        DataSourceTreeNode o2node = (DataSourceTreeNode)o2;
                        Object o2object = o2node.getOriginalObject();
                        o2Folder = o2object instanceof MapFolder;
                        o2string = o2node.getName();
                    } else {
                        o2string = o2.toString();
                    }
                    if (o1Folder && !o2Folder) {
                        return -1;
                    }
                    if (!o1Folder && o2Folder) {
                        return 1;
                    }
                    result = o1string.compareTo(o2string);
                }
                return result;
            }

            @Override
            public boolean equals(Object obj) {
                boolean result = this == obj;
                return result;
            }
        });
        list.clear();
        list.addAll(Arrays.asList(objArray));
    }

    @Override
    public boolean canRemoveAllCalculatedItems() {
        return true;
    }

    public int getMaxOutputObservations() {
        return this._maxPhysicalValuestoLoad;
    }

    public void setMaxOutputObservations(int max) {
        this._maxPhysicalValuestoLoad = max;
    }

    protected void finalize() {
        try {
            if (this._timeDateSyntaxDataSelection != null) {
                BusinessModel parentModel = this._timeDateSyntaxDataSelection.getParentBusinessModel();
                if (parentModel != null) {
                    parentModel.removeChild((BusinessModel)this._timeDateSyntaxDataSelection);
                }
                this._timeDateSyntaxDataSelection = null;
            }
        }
        finally {
            try {
                super.finalize();
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean isTypeChangeWarningIgnored() {
        return this._isTypeChangeWarningIgnored;
    }

    public void setTypeChangeWarningIgnored(boolean isTypeChangeWarningIgnored) {
        this._isTypeChangeWarningIgnored = isTypeChangeWarningIgnored;
    }
}

