/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.calculateditems;

import com.sas.dataselectors.calculateditems.BaseCalculatedObjectFactory;
import com.sas.dataselectors.calculateditems.CalculatedItemInterface;
import com.sas.dataselectors.calculateditems.CalculatedItemListV2Interface;
import com.sas.dataselectors.calculateditems.CalculatedObjectFactoryInterface;
import com.sas.expressions.visuals.DataSourceTreeInterface;
import com.sas.expressions.visuals.FunctionTreeInterface;
import com.sas.expressions.visuals.OperationListInterface;
import com.sas.swing.visuals.dataselectors.format.FormatAdapterInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;

public abstract class BaseCalculatedItemListAdapter
implements CalculatedItemListV2Interface {
    public static final String RB_KEY = "BaseCalculatedItemListAdpater.";
    protected String _name;
    protected String _description;
    protected List _calculatedItemList;
    protected CalculatedObjectFactoryInterface _objectFactory;
    protected int _selectionIndex = -1;
    private Locale locale;

    BaseCalculatedItemListAdapter(CalculatedObjectFactoryInterface factory) {
        this._objectFactory = factory;
        this._calculatedItemList = new InnerListOfCalculatedItems(false);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public List getCalculatedItemList() {
        return this._calculatedItemList;
    }

    public boolean commitChanges() {
        if (this._calculatedItemList == null) {
            return false;
        }
        return ((InnerListOfCalculatedItems)this._calculatedItemList).commitChanges();
    }

    public boolean getLevelHasMembers() {
        return this._objectFactory.getLevelHasMembers();
    }

    public String[] getMeasureNames() {
        return this._objectFactory.getMeasureNames();
    }

    public String[] getMemberNames(String levelName) {
        return this._objectFactory.getMemberNames(levelName);
    }

    public String[] getLevelNames(boolean includeHierarchyName) {
        return this._objectFactory.getLevelNames(includeHierarchyName);
    }

    public Map getMeasureNameMap() {
        return this._objectFactory.getMeasureNameMap();
    }

    public Map getLevelNameMap(boolean includeHierarchyName) {
        return this._objectFactory.getLevelNameMap(includeHierarchyName);
    }

    public DataSourceTreeInterface getDataSourceTree() {
        return this._objectFactory.getDataSourceTree();
    }

    public FunctionTreeInterface getFunctionListTree() {
        return this._objectFactory.getFunctionListTree();
    }

    public OperationListInterface getOperationList() {
        return this._objectFactory.getOperationList();
    }

    public DataSourceTreeInterface getPhysicalDataSourceTree() {
        return this._objectFactory.getPhysicalDataSourceTree();
    }

    public DataSourceTreeInterface getBusinessDataSourceTree() {
        return this._objectFactory.getBusinessDataSourceTree();
    }

    public DataSourceTreeInterface getPromptDataSourceTree() {
        return this._objectFactory.getPromptDataSourceTree();
    }

    public void removeAllCalculatedItems() {
        this._calculatedItemList.clear();
    }

    public boolean isTimeDimensionPresent() {
        return false;
    }

    public Object getTimeHierarchy() {
        return null;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public CalculatedItemInterface newCalculatedItem() {
        CalculatedItemInterface item = this._objectFactory.newCalculatedItemFromBusinessObject(null);
        return item;
    }

    public CalculatedItemInterface newCalculatedItem(CalculatedItemInterface toBeCloned) {
        CalculatedItemInterface item = this._objectFactory.newCalculatedItem(toBeCloned);
        return item;
    }

    public boolean addCalculatedItem(CalculatedItemInterface value) {
        return this.getCalculatedItemList().add(value);
    }

    public boolean isCalculatedItemSelected() {
        return this._selectionIndex == -1;
    }

    public void clearSelectionCursor() {
        this._selectionIndex = -1;
    }

    public int getSelectionCount() {
        return this.getCalculatedItemList().size();
    }

    public int getSelectionCursor() {
        return this._selectionIndex;
    }

    public void setSelectionCursor(int index) {
        this._selectionIndex = index;
    }

    public CalculatedItemInterface getSelectedCalculatedItem() {
        if (this._selectionIndex == -1) {
            return null;
        }
        return (CalculatedItemInterface)this.getCalculatedItemList().get(this._selectionIndex);
    }

    public void updateSelectedCalculatedItem(CalculatedItemInterface value) {
        this.getCalculatedItemList().set(this._selectionIndex, value);
    }

    public void removeSelectedCalculatedItem() {
        this.getCalculatedItemList().remove(this._selectionIndex);
    }

    public boolean canRemoveAllCalculatedItems() {
        return this._objectFactory.canRemoveAllCalculatedItems();
    }

    public int getMaxOutputObservations() {
        if (this._objectFactory != null) {
            return this._objectFactory.getMaxOutputObservations();
        }
        return BaseCalculatedObjectFactory.DEFAULT_GOVERNING_LIMIT;
    }

    public void setMaxOutputObservations(int max) {
        if (this._objectFactory != null) {
            this._objectFactory.setMaxOutputObservations(max);
        }
    }

    public FormatAdapterInterface getFormatAdapter() {
        return null;
    }

    public int getMaxLengthOfItemName() {
        return Integer.MAX_VALUE;
    }

    public class InnerListOfCalculatedItems
    implements List {
        List _calculatedItemsToSave = null;
        List _businessModelItemsToUpdate = null;
        List _businessModelItemsToDelete = new ArrayList();

        public InnerListOfCalculatedItems(boolean includeBaseModels) {
            this._calculatedItemsToSave = new ArrayList();
            this._businessModelItemsToUpdate = BaseCalculatedItemListAdapter.this._objectFactory.getBusinessModelCalculatedItemObjects(includeBaseModels);
            int size = this._businessModelItemsToUpdate.size();
            for (int i = 0; i < size; ++i) {
                Object bmObject = this._businessModelItemsToUpdate.get(i);
                CalculatedItemInterface item = BaseCalculatedItemListAdapter.this._objectFactory.newCalculatedItemFromBusinessObject(bmObject);
                this._calculatedItemsToSave.add(item);
            }
        }

        public boolean commitChanges() {
            Iterator iterDelete = this._businessModelItemsToDelete.iterator();
            while (iterDelete.hasNext()) {
                Object item = iterDelete.next();
                if (item != null) {
                    BaseCalculatedItemListAdapter.this._objectFactory.removeBusinessModelCalculatedItemObject(item);
                }
                iterDelete.remove();
            }
            int size = this._calculatedItemsToSave.size();
            for (int i = 0; i < size; ++i) {
                boolean ok = false;
                CalculatedItemInterface item = (CalculatedItemInterface)this._calculatedItemsToSave.get(i);
                ok = item.commitChanges();
                if (ok) continue;
                return false;
            }
            return true;
        }

        Object setCalculatedItemAt(int index, CalculatedItemInterface calculatedItem) {
            return this._calculatedItemsToSave.set(index, calculatedItem);
        }

        void addCalculatedItemAt(int index, CalculatedItemInterface calculatedItem) {
            this._businessModelItemsToUpdate.add(index, null);
            this._calculatedItemsToSave.add(index, calculatedItem);
        }

        Object removeCalculatedItemAt(int index) {
            Object item = this._businessModelItemsToUpdate.get(index);
            this._businessModelItemsToDelete.add(item);
            this._businessModelItemsToUpdate.remove(index);
            return this._calculatedItemsToSave.remove(index);
        }

        CalculatedItemInterface getCalculatedItemAt(int index) {
            return (CalculatedItemInterface)this._calculatedItemsToSave.get(index);
        }

        public Object set(int index, Object element) {
            if (element == null) {
                throw new IllegalArgumentException("attempt to add a null node");
            }
            if (!(element instanceof CalculatedItemInterface)) {
                throw new ClassCastException("attempt to add node not of class FilterLogicCalculatedItemInterface");
            }
            return this.setCalculatedItemAt(index, (CalculatedItemInterface)element);
        }

        public void add(int index, Object element) {
            if (element == null) {
                throw new IllegalArgumentException("attempt to add a null node");
            }
            if (!(element instanceof CalculatedItemInterface)) {
                throw new ClassCastException("attempt to add node not of class FilterLogicCalculatedItemInterface");
            }
            this.addCalculatedItemAt(index, (CalculatedItemInterface)element);
        }

        public Object remove(int index) {
            return this.removeCalculatedItemAt(index);
        }

        public Object get(int index) {
            return this.getCalculatedItemAt(index);
        }

        public boolean addAll(int index, Collection collection) {
            for (Object element : collection) {
                if (element == null) {
                    throw new IllegalArgumentException("attempt to add a null node");
                }
                if (element instanceof CalculatedItemInterface) continue;
                throw new ClassCastException("attempt to add node not of class CalculatedItemInterface");
            }
            Iterator iter = collection.iterator();
            int newIndex = index;
            while (iter.hasNext()) {
                Object element = iter.next();
                this.add(newIndex, element);
                ++newIndex;
            }
            return !collection.isEmpty();
        }

        @Override
        public boolean containsAll(Collection collection) {
            for (Object element : collection) {
                if (this.contains(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean removeAll(Collection collection) {
            boolean changed = false;
            for (Object element : collection) {
                changed = this.remove(element);
            }
            return changed;
        }

        @Override
        public boolean remove(Object object) {
            int index = this.indexOf(object);
            Object old = this.remove(index);
            return true;
        }

        @Override
        public boolean add(Object element) {
            this.add(this.size(), element);
            return true;
        }

        @Override
        public void clear() {
            while (!this._calculatedItemsToSave.isEmpty()) {
                this.remove(0);
            }
        }

        @Override
        public boolean contains(Object element) {
            return this._calculatedItemsToSave.contains(element);
        }

        @Override
        public Iterator iterator() {
            return this._calculatedItemsToSave.iterator();
        }

        public ListIterator listIterator() {
            return this._calculatedItemsToSave.listIterator();
        }

        public ListIterator listIterator(int index) {
            return this._calculatedItemsToSave.listIterator(index);
        }

        @Override
        public boolean retainAll(Collection p1) {
            return this._calculatedItemsToSave.retainAll(p1);
        }

        @Override
        public boolean addAll(Collection collection) {
            return this.addAll(this.size(), collection);
        }

        public List subList(int startIndex, int endIndex) {
            throw new UnsupportedOperationException("subList is not supported for this list");
        }

        @Override
        public int indexOf(Object object) {
            return this._calculatedItemsToSave.indexOf(object);
        }

        @Override
        public boolean equals(Object object) {
            return this._calculatedItemsToSave.equals(object);
        }

        @Override
        public int hashCode() {
            return this._calculatedItemsToSave.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this._calculatedItemsToSave.isEmpty();
        }

        @Override
        public int lastIndexOf(Object object) {
            return this._calculatedItemsToSave.lastIndexOf(object);
        }

        @Override
        public int size() {
            return this._calculatedItemsToSave.size();
        }

        @Override
        public Object[] toArray() {
            return this._calculatedItemsToSave.toArray();
        }

        @Override
        public Object[] toArray(Object[] p1) {
            return this._calculatedItemsToSave.toArray(p1);
        }
    }
}

