/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.BaseTupleElementCommand;
import com.sas.commands.olap.RB;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.Role;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.util.List;

public class SwapDataItemCommand
extends BaseTupleElementCommand {
    private static final String RB_KEY = "SwapDataItemCommand.";
    private String incomingDataItemId = null;
    private CommonLoggerInterface log = null;

    public SwapDataItemCommand(String name) {
        super(name);
    }

    public SwapDataItemCommand(String name, boolean swing) {
        super(name, swing);
    }

    public void execute(Object o) {
        this.getModel();
        if (this.model == null) {
            throw new IllegalStateException();
        }
        try {
            DataItemReference incomingDataItemReference;
            int axisNumber = this.getAxisIndex();
            Role currentRole = this.getRoleCorrespondingToAxis(axisNumber);
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.model).getBusinessQuery();
            BusinessModel businessModel = businessQuery.getBusinessModel();
            DataItem incomingDataItem = this.getIncomingDataItem(businessQuery);
            if (incomingDataItem == null) {
                return;
            }
            Role incomingItemRole = businessQuery.getResultItemRole(incomingDataItem);
            int incomingItemBusinessQueryPosition = this.getBusinessQueryPosition(businessQuery, incomingDataItem);
            DataItem outgoingDataItem = this.getDataItem();
            if (outgoingDataItem == null) {
                return;
            }
            int outgoingItemBusinessQueryPosition = this.getBusinessQueryPosition(businessQuery, outgoingDataItem);
            businessQuery.removeResultItem(outgoingDataItem);
            if (incomingItemRole == Role.BACKGROUND) {
                businessQuery.removeResultItem(incomingDataItem);
            }
            DataItemReference dataItemReference = incomingDataItemReference = incomingDataItem instanceof DataItemReference ? (DataItemReference)incomingDataItem : businessModel.newDataItemReference(incomingDataItem);
            if (!(incomingDataItem instanceof DataItemReference)) {
                businessModel.addBusinessItem((BusinessItem)incomingDataItemReference);
            }
            businessQuery.insertResultItemsAt((DataItem)incomingDataItemReference, currentRole, outgoingItemBusinessQueryPosition);
            if (incomingItemRole == Role.BACKGROUND) {
                DataItemReference outgoingDataItemReference = null;
                outgoingDataItemReference = outgoingDataItem instanceof DataItemReference ? (DataItemReference)outgoingDataItem : businessModel.newDataItemReference(outgoingDataItem);
                businessQuery.insertResultItemsAt((DataItem)outgoingDataItemReference, Role.BACKGROUND, incomingItemBusinessQueryPosition);
            }
            this.executeQuery(businessQuery);
            if (axisNumber == 1) {
                this.eventInfo.put("ROW", "INITIALIZE");
            } else if (axisNumber == 0) {
                this.eventInfo.put("COLUMN", "INITIALIZE");
            }
        }
        catch (Exception oe) {
            this.getLog().error(oe.getMessage(), (Throwable)oe);
        }
    }

    private int getBusinessQueryPosition(BusinessQuery businessQuery, DataItem dataItem) {
        List resultItems = businessQuery.getResultItems();
        int numResultItems = resultItems.size();
        for (int i = 0; i < numResultItems; ++i) {
            DataItem resultItem = (DataItem)resultItems.get(i);
            if (resultItem != dataItem) continue;
            return i;
        }
        return -1;
    }

    private DataItem getIncomingDataItem(BusinessQuery businessQuery) {
        int i;
        String newDataItemId = this.getIncomingDataItemId();
        if (newDataItemId == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "swapIdNotSet.ex.txt"));
        }
        DataItem dataItem = null;
        List resultItems = businessQuery.getResultItems();
        int numResultItems = resultItems.size();
        for (int i2 = 0; i2 < numResultItems; ++i2) {
            Object resultItem = resultItems.get(i2);
            if (!(resultItem instanceof DataItem) || (dataItem = resultItem instanceof DataItemReference ? ((DataItemReference)resultItem).getBaseDataItem() : (DataItem)resultItem) == null || !dataItem.getResultSetID().equals(newDataItemId)) continue;
            return (DataItem)resultItem;
        }
        List dataItems = businessQuery.getBusinessModel().getObjects(true, DataItem.class);
        int numDataItems = dataItems.size();
        for (i = 0; i < numDataItems; ++i) {
            dataItem = (DataItem)dataItems.get(i);
            if (!(dataItem instanceof DataItemReference)) continue;
            if (dataItem.getResultSetID().equals(newDataItemId)) {
                return dataItem;
            }
            if (!((DataItemReference)dataItem).getBaseDataItem().getResultSetID().equals(newDataItemId)) continue;
            return dataItem;
        }
        for (i = 0; i < numDataItems; ++i) {
            dataItem = (DataItem)dataItems.get(i);
            if (dataItem instanceof DataItemReference || !dataItem.getResultSetID().equals(newDataItemId)) continue;
            return dataItem;
        }
        return null;
    }

    private Role getRoleCorrespondingToAxis(int axisIndex) {
        if (axisIndex == 1) {
            return Role.ROW;
        }
        if (axisIndex == 0) {
            return Role.COLUMN;
        }
        if (axisIndex == 3) {
            return Role.HIDDEN;
        }
        return null;
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    @Override
    public int getCommandStatus(ActionSupportFilter filter) {
        return 0;
    }

    public String getIncomingDataItemId() {
        return this.incomingDataItemId;
    }

    public void setIncomingDataItemId(String incomingDataItemId) {
        this.incomingDataItemId = incomingDataItemId;
    }

    private CommonLoggerInterface getLog() {
        if (this.log == null) {
            this.log = LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory());
        }
        return this.log;
    }
}

