/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.BaseTupleElementCommand;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import java.util.ArrayList;
import java.util.List;

public class SortCommand
extends BaseTupleElementCommand {
    protected int sortType = 2;
    protected int sortCategory = 200;
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    public static final int HIERARCHICAL_ASCENDING = 2;
    public static final int HIERARCHICAL_DESCENDING = 3;
    public static final int NONE = 10;
    public static final int TOGGLE = 20;
    public static final int CELL_SORT = 100;
    public static final int LABEL_SORT = 200;

    public SortCommand(String name) {
        super(name);
    }

    public SortCommand(String name, boolean swing) {
        super(name, swing);
    }

    public void execute(Object o) {
        this.getModel();
        if (this.model == null) {
            throw new IllegalStateException();
        }
        try {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.model).getBusinessQuery();
            if (this.sortCategory == 100 && this.getSortQueryActionType(businessQuery) == BusinessQueryActionType.SORT_NONE || this.sortCategory == 200 && this.getSortActionType(businessQuery) == DataItemActionType.SORT_NONE) {
                if (businessQuery.isActionSupported(BusinessQueryActionType.SORT_NONE)) {
                    businessQuery.setSortDirection(BusinessQueryActionType.SORT_NONE, Role.COLUMN);
                    businessQuery.setSortDirection(BusinessQueryActionType.SORT_NONE, Role.ROW);
                }
                if (businessQuery.isActionSupported(BusinessQueryActionType.SORT_CRITERIA)) {
                    businessQuery.setSortCriteria(null, Role.COLUMN);
                    businessQuery.setSortCriteria(null, Role.ROW);
                }
                List allDataItems = businessQuery.getResultItems(Role.COLUMN);
                allDataItems.addAll(businessQuery.getResultItems(Role.ROW));
                int size = allDataItems.size();
                for (int i = 0; i < size; ++i) {
                    DataItem resultItem = (DataItem)allDataItems.get(i);
                    if (!resultItem.isActionSupported(DataItemActionType.SORT_NONE)) continue;
                    resultItem.setSortDirection(this.getSortActionType(businessQuery));
                }
            } else if (this.sortCategory == 200) {
                DataItem dataItem = this.getDataItem();
                businessQuery.setQueryProperty(BusinessQueryProperty.BUSINESS_QUERY_OLAP_SORT_PRECEDENCE, false);
                dataItem.setSortDirection(this.getSortActionType(businessQuery));
            } else if (this.sortCategory == 100) {
                DataItem di;
                ArrayList<String> itemList = new ArrayList<String>();
                this.tupleElement = this.getTupleElement();
                TupleInterface tuple = this.tupleElement.getTuple();
                TupleElementInterface[] elements = tuple.getElements(0, -1);
                for (int i = 0; i < elements.length; ++i) {
                    if (elements[i].isContextual()) continue;
                    if (elements[i].getType() != TupleElementType.MEASURE) {
                        itemList.add(elements[i].getName());
                        continue;
                    }
                    di = this.findDataItem((BusinessQueryProviderInterface)this.model, elements[i]);
                    itemList.add((String)di);
                }
                Role sortRole = null;
                di = this.getDataItem();
                Role currentRole = businessQuery.getResultItemRole(di);
                if (currentRole == Role.ROW) {
                    sortRole = Role.COLUMN;
                } else if (currentRole == Role.COLUMN) {
                    sortRole = Role.ROW;
                }
                businessQuery.setQueryProperty(BusinessQueryProperty.BUSINESS_QUERY_OLAP_SORT_PRECEDENCE, true);
                businessQuery.setSortDirection(this.getSortQueryActionType(businessQuery), sortRole);
                businessQuery.setSortCriteria(itemList, sortRole);
            }
            int axisNumber = this.getAxisIndex();
            this.executeQuery(businessQuery);
            if (axisNumber == 1 && this.sortCategory == 200) {
                this.eventInfo.put("ROW", "INITIALIZE");
            } else if (axisNumber == 0 && this.sortCategory == 200) {
                this.eventInfo.put("COLUMN", "INITIALIZE");
            }
            if (axisNumber == 1 && this.sortCategory == 100) {
                this.eventInfo.put("COLUMN", "INITIALIZE");
            } else if (axisNumber == 0 && this.sortCategory == 100) {
                this.eventInfo.put("ROW", "INITIALIZE");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        Object model = actionFilter.getAttribute("model");
        BusinessQuery bq = null;
        if (model instanceof BusinessQueryProviderInterface) {
            bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
        } else if (model instanceof BusinessQuery) {
            bq = (BusinessQuery)model;
        }
        if (this.sortCategory == 200) {
            if (this.getSortActionType(bq) != DataItemActionType.SORT_NONE && !this.isIQSupported(actionFilter, this.getSortActionType(bq))) {
                return false;
            }
            String uniqueLevelName = (String)actionFilter.getAttribute("uniqueLevelName");
            return this.isSortable(uniqueLevelName);
        }
        if (this.getSortQueryActionType(bq) != BusinessQueryActionType.SORT_NONE && !this.isIQSupported(actionFilter, this.getSortQueryActionType(bq))) {
            return false;
        }
        TupleElementInterface tupleElement = (TupleElementInterface)actionFilter.getAttribute("tupleElement");
        return this.isSortable(tupleElement);
    }

    @Override
    public int getCommandStatus(ActionSupportFilter filter) {
        DataItem di;
        Object model = filter.getAttribute("model");
        BusinessQuery bq = null;
        if (model instanceof BusinessQueryProviderInterface) {
            bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
        } else if (model instanceof BusinessQuery) {
            bq = (BusinessQuery)model;
        }
        if (this.sortCategory == 200) {
            if (this.getSortActionType(bq) != DataItemActionType.SORT_NONE && !this.isIQSupported(filter, this.getSortActionType(bq))) {
                return 1;
            }
            String uniqueLevelName = (String)filter.getAttribute("uniqueLevelName");
            return this.getSortableStatus(uniqueLevelName, model);
        }
        if (this.getSortQueryActionType(bq) != BusinessQueryActionType.SORT_NONE && !this.isIQSupported(filter, this.getSortQueryActionType(bq))) {
            return 1;
        }
        Object dataItem = filter.getAttribute("dataItem");
        if (dataItem != null && dataItem instanceof DataItem && (di = (DataItem)dataItem) != null && di.getExpression() instanceof FractionOfTotalExpression) {
            return 4;
        }
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        return this.getSortableStatus(tupleElement, model);
    }

    protected boolean isSortable(TupleElementInterface tupleElement) {
        return true;
    }

    protected boolean isSortable(String uniqueLevelName) {
        return true;
    }

    protected int getSortableStatus(String uniqueLevelName, Object model) {
        if (!(model instanceof BusinessQueryProviderInterface)) {
            return 1;
        }
        BusinessQuery bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
        if (this.sortCategory == 100 && this.getSortQueryActionType(bq) == BusinessQueryActionType.SORT_NONE || this.sortCategory == 200 && this.getSortActionType(bq) == DataItemActionType.SORT_NONE) {
            if (this.isSortPresent(bq)) {
                return 0;
            }
            return 8;
        }
        DataItem di = null;
        if (uniqueLevelName != null) {
            DataItemActionType currentType;
            DataItemActionType diActionType;
            boolean isCellSortingPriority = bq.getQueryProperty(BusinessQueryProperty.BUSINESS_QUERY_OLAP_SORT_PRECEDENCE);
            if (!isCellSortingPriority && (di = this.getDataItem()) != null && this.sortCategory == 200 && (diActionType = di.getSortDirection()) == (currentType = this.getSortActionType(bq))) {
                return 8;
            }
        } else {
            return 16;
        }
        return 0;
    }

    protected int getSortableStatus(TupleElementInterface tupleElement, Object model) {
        block17: {
            if (!(model instanceof BusinessQueryProviderInterface)) {
                return 1;
            }
            BusinessQuery bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            if (this.sortCategory == 100 && this.getSortQueryActionType(bq) == BusinessQueryActionType.SORT_NONE || this.sortCategory == 200 && this.getSortActionType(bq) == DataItemActionType.SORT_NONE) {
                if (this.isSortPresent(bq)) {
                    return 0;
                }
                return 8;
            }
            DataItem di = null;
            try {
                if (tupleElement != null) {
                    boolean isCellSortingPriority = bq.getQueryProperty(BusinessQueryProperty.BUSINESS_QUERY_OLAP_SORT_PRECEDENCE);
                    if (isCellSortingPriority && (di = this.getDataItem()) != null && this.sortCategory == 100) {
                        Role currentRole = bq.getResultItemRole(di);
                        Role sortRole = null;
                        if (currentRole == Role.ROW) {
                            sortRole = Role.COLUMN;
                        } else if (currentRole == Role.COLUMN) {
                            sortRole = Role.ROW;
                        }
                        BusinessQueryActionType bqActionType = bq.getSortDirection(sortRole);
                        BusinessQueryActionType currentType = this.getSortQueryActionType(bq);
                        if (bqActionType == currentType) {
                            int listSize;
                            int itemSize;
                            TupleInterface tuple = tupleElement.getTuple();
                            TupleElementInterface[] elements = tuple.getElements(0, -1);
                            ArrayList<String> itemList = new ArrayList<String>();
                            for (int i = 0; i < elements.length; ++i) {
                                if (elements[i].getType() != TupleElementType.MEASURE) {
                                    itemList.add(elements[i].getName());
                                    continue;
                                }
                                DataItem di2 = this.findDataItem((BusinessQueryProviderInterface)model, elements[i]);
                                itemList.add((String)di2);
                            }
                            List list = bq.getSortCriteria(sortRole);
                            if (itemList != null && list != null && (itemSize = itemList.size()) == (listSize = list.size())) {
                                for (int i = 0; i < itemSize; ++i) {
                                    Object st1 = itemList.get(i);
                                    Object st2 = list.get(i);
                                    if (st1 == null || st2 == null) {
                                        return 0;
                                    }
                                    if (!(st1 instanceof Object[] && st2 instanceof Object[] ? ((Object[])st1).length != 1 || ((Object[])st2).length != 1 || !((Object[])st1)[0].equals(((Object[])st2)[0]) : !st1.equals(st2))) continue;
                                    return 0;
                                }
                                return 8;
                            }
                        }
                    }
                    break block17;
                }
                return 16;
            }
            catch (MetadataException metadataException) {
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return 0;
    }

    private boolean isSortPresent(BusinessQuery businessQuery) {
        if (businessQuery != null) {
            try {
                List list = businessQuery.getSortCriteria(Role.COLUMN);
                if (list != null && list.size() > 0) {
                    return true;
                }
                list = businessQuery.getSortCriteria(Role.ROW);
                if (list != null && list.size() > 0) {
                    return true;
                }
                list = businessQuery.getResultItems(Role.COLUMN);
                list.addAll(businessQuery.getResultItems(Role.ROW));
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    DataItem resultItem = (DataItem)list.get(i);
                    if (resultItem.getSortDirection() == DataItemActionType.SORT_NONE) continue;
                    return true;
                }
            }
            catch (MetadataException metadataException) {
                // empty catch block
            }
        }
        return false;
    }

    public void setSortType(int sortType) {
        this.sortType = sortType;
    }

    public int getSortType() {
        return this.sortType;
    }

    public void setSortCategory(int sortCategory) {
        this.sortCategory = sortCategory;
    }

    public int getSortCategory() {
        return this.sortCategory;
    }

    private BusinessQueryActionType getSortQueryActionType(BusinessQuery model) {
        switch (this.sortType) {
            case 0: {
                return BusinessQueryActionType.SORT_ASCENDING;
            }
            case 1: {
                return BusinessQueryActionType.SORT_DESCENDING;
            }
            case 2: {
                return BusinessQueryActionType.SORT_HIERARCHICAL_ASCENDING;
            }
            case 3: {
                return BusinessQueryActionType.SORT_HIERARCHICAL_DESCENDING;
            }
            case 10: {
                return BusinessQueryActionType.SORT_NONE;
            }
        }
        return BusinessQueryActionType.SORT_ASCENDING;
    }

    private DataItemActionType getSortActionType(BusinessQuery model) {
        StructureOfData structure;
        BusinessModel businessModel;
        boolean rolap = false;
        if (model != null && (businessModel = model.getBusinessModel()) != null && (structure = businessModel.getStructure()).isRelational()) {
            rolap = true;
        }
        switch (this.sortType) {
            case 2: {
                if (!rolap) {
                    return DataItemActionType.SORT_HIERARCHICAL_ASCENDING;
                }
            }
            case 0: {
                return DataItemActionType.SORT_ASCENDING;
            }
            case 3: {
                if (!rolap) {
                    return DataItemActionType.SORT_HIERARCHICAL_DESCENDING;
                }
            }
            case 1: {
                return DataItemActionType.SORT_DESCENDING;
            }
            case 10: {
                return DataItemActionType.SORT_NONE;
            }
        }
        return DataItemActionType.SORT_ASCENDING;
    }

    @Override
    public boolean isIQSupported(ActionSupportFilter actionFilter, DataItemActionType actionType) {
        Object model;
        String uniqueLevelName = (String)actionFilter.getAttribute("uniqueLevelName");
        if (uniqueLevelName == null) {
            try {
                TupleElementInterface tupleElement = (TupleElementInterface)actionFilter.getAttribute("tupleElement");
                if (tupleElement != null) {
                    uniqueLevelName = tupleElement.getUniqueLevelName();
                }
            }
            catch (OLAPException tupleElement) {
                // empty catch block
            }
        }
        if ((model = actionFilter.getAttribute("model")) instanceof BusinessQueryProviderInterface && model instanceof OLAPDataSetInterface && uniqueLevelName != null) {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            this._dataItem = this.getDataItem(actionFilter);
            DataItem dataItem = this._dataItem;
            if (dataItem != null) {
                return dataItem.isActionSupported(actionType);
            }
        }
        return false;
    }

    @Override
    public boolean isIQSupported(ActionSupportFilter actionFilter, BusinessQueryActionType actionType) {
        Object model;
        String uniqueLevelName = (String)actionFilter.getAttribute("uniqueLevelName");
        if (uniqueLevelName == null) {
            try {
                TupleElementInterface tupleElement = (TupleElementInterface)actionFilter.getAttribute("tupleElement");
                if (tupleElement != null) {
                    uniqueLevelName = tupleElement.getUniqueLevelName();
                }
            }
            catch (OLAPException tupleElement) {
                // empty catch block
            }
        }
        if ((model = actionFilter.getAttribute("model")) instanceof BusinessQueryProviderInterface && model instanceof OLAPDataSetInterface && uniqueLevelName != null) {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            this._dataItem = this.getDataItem(actionFilter);
            DataItem dataItem = this._dataItem;
            if (dataItem != null) {
                return businessQuery.isActionSupported(actionType);
            }
        }
        return false;
    }

    protected boolean isMeasure(DataItem dataItem) {
        if (dataItem == null) {
            return false;
        }
        StructureOfDataItem dataItemStructure = dataItem.getStructure();
        if (dataItemStructure == StructureOfDataItem.STRUCTURE_MEASURE) {
            return true;
        }
        return dataItemStructure == StructureOfDataItem.STRUCTURE_COLUMN && dataItem.getExpressionType() == 2 && dataItem.getUsage() != DataItemActionType.USAGE_CATEGORY;
    }
}

